package com.xebialabs.xlrelease.search;

import java.util.Collections;
import java.util.List;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.serialization.json.jackson.CiSerializer;


public class ReleaseSearchResult {
    private long page;
    private long size;

    @JsonSerialize(contentUsing = CiSerializer.class)
    private List<Release> releases;

    public static ReleaseSearchResult empty(long page) {
        return new ReleaseSearchResult(Collections.emptyList(), page);
    }

    public ReleaseSearchResult(List<Release> releases, long page) {
        this.releases = releases;
        this.page = page;
        this.size = releases.size();
    }

    public long getPage() {
        return page;
    }

    public void setPage(long page) {
        this.page = page;
    }

    public void addReleases(List<Release> releases) {
        if (this.releases == null) {
            this.releases = releases;
        } else {
            this.releases.addAll(releases);
        }
    }

    public List<Release> getReleases() {
        return releases;
    }

    public long getSize() {
        return size;
    }
}
