package com.xebialabs.xlrelease.api.v1.views.search;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import com.xebialabs.xlrelease.api.v1.views.BaseApplicationView;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;

// View for reservations list inside EnvironmentReservationSearchView
class ReservationSearchView {
    private String id;
    private Date startDate;
    private Date endDate;
    private String note;
    private List<BaseApplicationView> applications = new ArrayList<>();

    static ReservationSearchView fromEnvironmentReservation(EnvironmentReservation reservation) {
        ReservationSearchView view = new ReservationSearchView();
        view.id = reservation.getId();
        view.startDate = reservation.getStartDate();
        view.endDate = reservation.getEndDate();
        view.note = reservation.getNote();
        view.applications = reservation.getApplications()
                .stream()
                .map(BaseApplicationView::fromApplication)
                .collect(Collectors.toList());
        return view;
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(final Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(final Date endDate) {
        this.endDate = endDate;
    }

    public String getNote() {
        return note;
    }

    public void setNote(final String note) {
        this.note = note;
    }

    public List<BaseApplicationView> getApplications() {
        return applications;
    }

    public void setApplications(final List<BaseApplicationView> application) {
        this.applications = application;
    }
}
