package com.xebialabs.xlrelease.api.v1.forms;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class CreateTeam {
    private String name;
    private List<String> principals = new ArrayList<>();
    private List<String> roles = new ArrayList<>();
    private List<String> permissions = new ArrayList<>();

    @PublicApiMember
    public CreateTeam() {}

    @PublicApiMember
    public CreateTeam(String name) {
        this.name = name;
    }

    @PublicApiMember
    public CreateTeam(String name, List<String> principals, List<String> roles, List<String> permissions) {
        this.name = name;
        this.principals = principals;
        this.roles = roles;
        this.permissions = permissions;
    }

    @PublicApiMember
    public String getName() {
        return name;
    }

    @PublicApiMember
    public void setName(final String name) {
        this.name = name;
    }

    @PublicApiMember
    public List<String> getPrincipals() {
        return principals;
    }

    @PublicApiMember
    public void setPrincipals(final List<String> principals) {
        this.principals = principals;
    }

    @PublicApiMember
    public List<String> getRoles() {
        return roles;
    }

    @PublicApiMember
    public void setRoles(final List<String> roles) {
        this.roles = roles;
    }

    @PublicApiMember
    public List<String> getPermissions() {
        return permissions;
    }

    @PublicApiMember
    public void setPermissions(final List<String> permissions) {
        this.permissions = permissions;
    }

    @PublicApiMember
    public void addPrincipal(String name) {
        principals.add(name);
    }

    @PublicApiMember
    public void addPrincipals(List<String> names) {
        principals.addAll(names);
    }

    @PublicApiMember
    public void addRole(String name) {
        roles.add(name);
    }

    @PublicApiMember
    public void addRoles(List<String> names) {
        roles.addAll(names);
    }

    @PublicApiMember
    public void addPermission(String name) {
        permissions.add(name);
    }

    @PublicApiMember
    public void addPermissions(List<String> names) {
        permissions.addAll(names);
    }
}
