/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.forms;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.UserProfile;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class UserAccount {
    private String username;
    private boolean external;
    private String profileId;
    private String email;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String password;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String previousPassword;
    private String fullName;
    private String externalId;
    private boolean loginAllowed;
    private String dateFormat;
    private String timeFormat;
    private Integer firstDayOfWeek;
    private Date lastActive;
    private boolean analyticsEnabled = true;
    private boolean taskDrawerEnabled = true;
    private boolean personalAccessTokenEnabled = false;
    private List<String> favouriteDashboards = new ArrayList<String>();

    @PublicApiMember
    public UserAccount() {
    }

    public UserAccount(String username, UserProfile profile, boolean isInternal) {
        this.username = username;
        boolean bl = this.external = !isInternal;
        if (profile != null) {
            this.profileId = profile.getId();
            this.email = profile.getEmail();
            this.fullName = profile.getFullName();
            this.externalId = profile.getExternalId();
            this.loginAllowed = profile.isLoginAllowed();
            this.dateFormat = profile.getDateFormat();
            this.timeFormat = profile.getTimeFormat();
            this.firstDayOfWeek = profile.getFirstDayOfWeek();
            this.lastActive = profile.getLastActive();
            this.analyticsEnabled = profile.isAnalyticsEnabled();
            this.taskDrawerEnabled = profile.isTaskDrawerEnabled();
            this.favouriteDashboards = profile.getFavouriteDashboards();
        }
    }

    public UserAccount(String username, UserProfile profile, boolean isInternal, boolean personalAccessTokenEnabled) {
        this(username, profile, isInternal);
        this.personalAccessTokenEnabled = personalAccessTokenEnabled;
    }

    public UserProfile toUserProfile() {
        UserProfile profile = new UserProfile(this.username, this.email, this.fullName, this.loginAllowed, this.lastActive, this.externalId);
        profile.setDateFormat(this.dateFormat);
        profile.setTimeFormat(this.timeFormat);
        profile.setFirstDayOfWeek(this.firstDayOfWeek);
        profile.setAnalyticsEnabled(this.analyticsEnabled);
        profile.setTaskDrawerEnabled(this.taskDrawerEnabled);
        profile.setFavouriteDashboards(this.favouriteDashboards);
        return profile;
    }

    @PublicApiMember
    public String getUsername() {
        return this.username;
    }

    @PublicApiMember
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isPersonalAccessTokenEnabled() {
        return this.personalAccessTokenEnabled;
    }

    public String getProfileId() {
        return this.profileId;
    }

    @PublicApiMember
    public String getEmail() {
        return this.email;
    }

    @PublicApiMember
    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    @PublicApiMember
    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasPassword() {
        return this.password != null && !this.password.isEmpty();
    }

    public String getPreviousPassword() {
        return this.previousPassword;
    }

    public void setPreviousPassword(String previousPassword) {
        this.previousPassword = previousPassword;
    }

    @PublicApiMember
    public String getFullName() {
        return this.fullName;
    }

    @PublicApiMember
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @PublicApiMember
    public String getExternalId() {
        return this.externalId;
    }

    @PublicApiMember
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @PublicApiMember
    public boolean isLoginAllowed() {
        return this.loginAllowed;
    }

    @PublicApiMember
    public void setLoginAllowed(boolean loginAllowed) {
        this.loginAllowed = loginAllowed;
    }

    @PublicApiMember
    public String getDateFormat() {
        return this.dateFormat;
    }

    @PublicApiMember
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @PublicApiMember
    public Integer getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    @PublicApiMember
    public void setFirstDayOfWeek(Integer firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    @PublicApiMember
    public String getTimeFormat() {
        return this.timeFormat;
    }

    @PublicApiMember
    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    @PublicApiMember
    public Date getLastActive() {
        return this.lastActive;
    }

    @PublicApiMember
    public void setLastActive(Date lastActive) {
        this.lastActive = lastActive;
    }

    @PublicApiMember
    public boolean isAnalyticsEnabled() {
        return this.analyticsEnabled;
    }

    @PublicApiMember
    public void setAnalyticsEnabled(boolean analyticsEnabled) {
        this.analyticsEnabled = analyticsEnabled;
    }

    @PublicApiMember
    public boolean isTaskDrawerEnabled() {
        return this.taskDrawerEnabled;
    }

    @PublicApiMember
    public void setTaskDrawerEnabled(boolean taskDrawerEnabled) {
        this.taskDrawerEnabled = taskDrawerEnabled;
    }

    public List<String> getFavouriteDashboards() {
        return this.favouriteDashboards;
    }

    public void setFavouriteDashboards(List<String> favouriteDashboards) {
        this.favouriteDashboards = favouriteDashboards;
    }
}

