package com.xebialabs.xlrelease.param;

import java.lang.annotation.Annotation;
import org.jboss.resteasy.spi.StringParameterUnmarshaller;

import com.xebialabs.xlrelease.repository.IdType;

public class IdParamUnmarshaller implements StringParameterUnmarshaller<String> {
    private IdType type;

    @Override
    public void setAnnotations(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof IdParam) {
                type = ((IdParam) annotation).value();
            }
        }
    }

    @Override
    public String fromString(String viewId) {
        return type.convertToInternalId(viewId);
    }
}
