package com.xebialabs.xlrelease.api.v1.views;

import java.util.Date;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

public abstract class PlanItemTimeline {
    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String id;

    private String title;

    private Date scheduledStartDate;

    private Date dueDate;

    private Date startDate;

    private Date endDate;

    private Date plannedStartDate;

    private Date plannedEndDate;

    public PlanItemTimeline(PlanItem planItem, Date plannedStartDate, Date plannedEndDate) {
        this.id = planItem.getId();
        this.scheduledStartDate = planItem.getScheduledStartDate();
        this.dueDate = planItem.getDueDate();
        this.startDate = planItem.getStartDate();
        this.endDate = planItem.getEndDate();
        this.title = planItem.getTitle();

        this.plannedStartDate = plannedStartDate;
        this.plannedEndDate = plannedEndDate;
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public Date getScheduledStartDate() {
        return scheduledStartDate;
    }

    public void setScheduledStartDate(final Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(final Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(final Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(final Date endDate) {
        this.endDate = endDate;
    }

    public Date getPlannedStartDate() {
        return plannedStartDate;
    }

    public void setPlannedStartDate(final Date plannedStartDate) {
        this.plannedStartDate = plannedStartDate;
    }

    public Date getPlannedEndDate() {
        return plannedEndDate;
    }

    public void setPlannedEndDate(final Date plannedEndDate) {
        this.plannedEndDate = plannedEndDate;
    }
}
