package com.xebialabs.xlrelease.api.v1.views;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.xebialabs.xlrelease.domain.environments.Application;

public class ApplicationView {
    private String id;
    private String title;
    private List<BaseEnvironmentView> environments = new ArrayList<>();

    public static ApplicationView fromApplication(Application application) {
        ApplicationView view = new ApplicationView();
        view.setId(application.getId());
        view.setTitle(application.getTitle());
        view.environments = application.getEnvironments()
                .stream()
                .map(BaseEnvironmentView::fromEnvironment)
                .collect(Collectors.toList());
        return view;
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public List<BaseEnvironmentView> getEnvironments() {
        return environments;
    }

    public void setEnvironments(final List<BaseEnvironmentView> environments) {
        this.environments = environments;
    }
}
