package com.xebialabs.xlrelease.views;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.reflect.Type;

/**
 * This class is serializable assuming that {@link #properties} contains only CI property values.
 */
public abstract class BaseConfigurationItemView implements Serializable {

    protected String type;

    protected String title;

    protected Map<String, Object> properties = new HashMap<>();

    public Type type() {
        return Type.valueOf(type);
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public Map<String, Object> getProperties() {
        return properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public abstract String getId();

    public abstract void setId(String id);


}
