package com.xebialabs.xlrelease.search;

import java.util.Map;

import com.xebialabs.xlrelease.domain.status.ReleaseStatus;

public class ReleaseCountResult {
    int total;
    Map<ReleaseStatus, Integer> byStatus;

    public ReleaseCountResult(Map<ReleaseStatus, Integer> byStatus) {
        this.byStatus = byStatus;
        this.total = byStatus.values().stream().reduce(0, Integer::sum);
    }

    public int getTotal() {
        return total;
    }

    public Map<ReleaseStatus, Integer> getByStatus() {
        return byStatus;
    }
}
