package com.xebialabs.xlrelease.view;

import java.util.List;
import java.util.Set;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import com.xebialabs.xlrelease.domain.TemplateLogo;
import com.xebialabs.xlrelease.serialization.json.jackson.CiSerializer;

public class WorkflowOverview {
    @JsonIgnore
    private Integer ciUid;
    private String id;
    private String title;
    private String description;
    @JsonSerialize(using = CiSerializer.class)
    private TemplateLogo logo;
    private String author;
    private List<String> tags;
    private Set<String> categories; // only there for templates
    private SCMTraceabilityData scmTraceabilityData;
    private String folderId;
    private String folderTitle;

    public Integer getCiUid() {
        return ciUid;
    }

    public void setCiUid(final Integer ciUid) {
        this.ciUid = ciUid;
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public TemplateLogo getLogo() {
        return logo;
    }

    public void setLogo(final TemplateLogo logo) {
        this.logo = logo;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(final String author) {
        this.author = author;
    }

    public List<String> getTags() {
        return tags;
    }

    public void setTags(final List<String> tags) {
        this.tags = tags;
    }

    public Set<String> getCategories() {
        return categories;
    }

    public void setCategories(final Set<String> categories) {
        this.categories = categories;
    }

    public SCMTraceabilityData getScmTraceabilityData() {
        return scmTraceabilityData;
    }

    public void setScmTraceabilityData(final SCMTraceabilityData scmTraceabilityData) {
        this.scmTraceabilityData = scmTraceabilityData;
    }

    public String getFolderId() {
        return folderId;
    }

    public void setFolderId(final String folderId) {
        this.folderId = folderId;
    }

    public String getFolderTitle() {
        return folderTitle;
    }

    public void setFolderTitle(final String folderTitle) {
        this.folderTitle = folderTitle;
    }
}
