package com.xebialabs.xlrelease.api.v1.views;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class TeamView {

    private String id;
    private String teamName;
    private List<TeamMemberView> members = new ArrayList<>();
    private List<String> permissions = new ArrayList<>();
    private boolean systemTeam;

    @PublicApiMember
    public TeamView() {
    }

    @PublicApiMember
    public String getId() {
        return id;
    }

    @PublicApiMember
    public void setId(String id) {
        this.id = id;
    }

    @PublicApiMember
    public String getTeamName() {
        return teamName;
    }

    @PublicApiMember
    public List<TeamMemberView> getMembers() {
        return members;
    }

    @PublicApiMember
    public List<String> getPermissions() {
        return permissions;
    }

    public boolean isSystemTeam() {
        return systemTeam;
    }

    @PublicApiMember
    public void setTeamName(final String teamName) {
        this.teamName = teamName;
    }

    @PublicApiMember
    public void setMembers(final List<TeamMemberView> members) {
        this.members = members;
    }

    @PublicApiMember
    public void setPermissions(final List<String> permissions) {
        this.permissions = permissions;
    }

    @PublicApiMember
    public void setSystemTeam(final boolean systemTeam) {
        this.systemTeam = systemTeam;
    }

}
