package com.xebialabs.xlrelease.api.v1.forms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;

import static com.xebialabs.xlrelease.domain.status.ReleaseStatus.ABORTED;
import static com.xebialabs.xlrelease.domain.status.ReleaseStatus.ACTIVE_STATUSES;
import static com.xebialabs.xlrelease.domain.status.ReleaseStatus.COMPLETED;
import static com.xebialabs.xlrelease.domain.status.ReleaseStatus.FAILED;
import static com.xebialabs.xlrelease.domain.status.ReleaseStatus.FAILING;
import static com.xebialabs.xlrelease.domain.status.ReleaseStatus.INACTIVE_STATUSES;
import static com.xebialabs.xlrelease.domain.status.ReleaseStatus.IN_PROGRESS;
import static com.xebialabs.xlrelease.domain.status.ReleaseStatus.PAUSED;
import static com.xebialabs.xlrelease.domain.status.ReleaseStatus.PLANNED;
import static java.util.stream.Collectors.toList;

@PublicApiRef
public class ReleasesFilters {
    private String title;
    private List<String> tags;
    private List<String> taskTags;
    private TimeFrame timeFrame;
    private Date from;
    private Date to;
    private boolean active;
    private boolean planned;
    private boolean inProgress;
    private boolean paused;
    private boolean failing;
    private boolean failed;
    private boolean inactive;
    private boolean completed;
    private boolean aborted;
    private boolean onlyMine;
    private boolean onlyFlagged;
    private boolean onlyArchived;
    private String parentId;
    private ReleaseOrderMode orderBy;
    private ReleaseOrderDirection orderDirection;
    private RiskStatusWithThresholds riskStatusWithThresholds;

    public ReleasesFilters() {
    }

    public boolean hasASelectedFilter() {
        return active || planned || inProgress || paused || failing || failed || inactive || completed || aborted || onlyMine || onlyArchived;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public Date getFrom() {
        return from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return to;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public boolean withPlanned() {
        return planned;
    }

    public void setPlanned(boolean planned) {
        this.planned = planned;
    }

    public boolean withActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean withInProgress() {
        return inProgress;
    }

    public void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    public boolean withPaused() {
        return paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean withFailing() {
        return failing;
    }

    public void setFailing(boolean failing) {
        this.failing = failing;
    }

    public boolean withFailed() {
        return failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean withInactive() {
        return inactive;
    }

    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    public boolean withCompleted() {
        return completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public boolean withAborted() {
        return aborted;
    }

    public void setAborted(final boolean aborted) {
        this.aborted = aborted;
    }

    public boolean withOnlyMine() {
        return onlyMine;
    }

    public void setOnlyMine(boolean onlyMine) {
        this.onlyMine = onlyMine;
    }

    public boolean withOnlyFlagged() {
        return onlyFlagged;
    }

    public void setOnlyFlagged(boolean onlyFlagged) {
        this.onlyFlagged = onlyFlagged;
    }

    public boolean withOnlyArchived() {
        return onlyArchived;
    }

    public void setOnlyArchived(boolean onlyArchived) {
        this.onlyArchived = onlyArchived;
    }

    public TimeFrame getTimeFrame() {
        return timeFrame;
    }

    public void setTimeFrame(TimeFrame timeFrame) {
        this.timeFrame = timeFrame;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(final String parentId) {
        this.parentId = parentId;
    }

    public static ReleasesFilters active() {
        ReleasesFilters rf = new ReleasesFilters();
        rf.setActive(true);
        return rf;
    }

    public Date getQueryStartDate() {
        if (timeFrame != null) {
            return new Date(timeFrame.getStartDate(from));
        }
        return from;
    }

    public Date getQueryEndDate() {
        if (timeFrame != null) {
            return new Date(timeFrame.getEndDate(to));
        }
        return to;
    }

    public ReleaseOrderMode getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(final ReleaseOrderMode orderBy) {
        this.orderBy = orderBy;
    }

    public ReleaseOrderDirection getOrderDirection() {
        return orderDirection;
    }

    public void setOrderDirection(final ReleaseOrderDirection orderDirection) {
        this.orderDirection = orderDirection;
    }

    public RiskStatusWithThresholds getRiskStatusWithThresholds() {
        return riskStatusWithThresholds;
    }

    public void setRiskStatusWithThresholds(final RiskStatusWithThresholds riskStatusWithThresholds) {
        this.riskStatusWithThresholds = riskStatusWithThresholds;
    }

    public List<String> getTags() {
        return tags;
    }

    public void setTags(final List<String> tags) {
        this.tags = tags;
    }

    public List<String> getTaskTags() {
        return taskTags;
    }

    public ReleasesFilters setTaskTags(List<String> taskTags) {
        this.taskTags = taskTags;
        return this;
    }

    public List<ReleaseStatus> getStatuses() {
        List<ReleaseStatus> statuses = new ArrayList<>();

        if (this.withPlanned()) {
            statuses.add(PLANNED);
        }

        if (this.withActive()) {
            statuses.addAll(Arrays.stream(ACTIVE_STATUSES).collect(toList()));
        } else {
            if (this.withInProgress()) {
                statuses.add(IN_PROGRESS);
            }
            if (this.withPaused()) {
                statuses.add(PAUSED);
            }
            if (this.withFailing()) {
                statuses.add(FAILING);
            }
            if (this.withFailed()) {
                statuses.add(FAILED);
            }
        }

        if (this.withInactive()) {
            statuses.addAll(Arrays.stream(INACTIVE_STATUSES).collect(toList()));
        } else {
            if (this.withCompleted()) {
                statuses.add(COMPLETED);
            }
            if (this.withAborted()) {
                statuses.add(ABORTED);
            }
        }

        return statuses;
    }

}
