package com.xebialabs.xlrelease.api.v1.form;

import java.util.List;
import java.util.stream.Collectors;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.environments.Environment;

public class ApplicationForm {
    private String title;
    private List<String> environmentIds = null;

    public Application toApplication() {
        Application application = new Application();
        application.setId(null);
        application.setTitle(this.getTitle());

        if (environmentIds != null) {
            List<Environment> envs = environmentIds
                    .stream()
                    .map(id -> Type.valueOf(Environment.class).getDescriptor().<Environment>newInstance(id))
                    .collect(Collectors.toList());

            application.setEnvironments(envs);
        }

        return application;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public List<String> getEnvironmentIds() {
        return environmentIds;
    }

    public void setEnvironmentIds(final List<String> environmentIds) {
        this.environmentIds = environmentIds;
    }
}
