package com.xebialabs.xlrelease.api.v1.views;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import com.fasterxml.jackson.annotation.JsonInclude;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

@PublicApiRef
public class RoleView {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String name;

    private String id;

    private LinkedHashSet<String> permissions = new LinkedHashSet<>();

    private LinkedHashSet<PrincipalView> principals = new LinkedHashSet<>();

    public String getName() {
        return name;
    }

    public String getId() {
        return id;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public Set<String> getPermissions() {
        return permissions;
    }

    public void setPermissions(final Collection<String> permissions) {
        this.permissions.clear();
        this.permissions.addAll(permissions);
    }

    public Set<PrincipalView> getPrincipals() {
        return principals;
    }

    public void setPrincipals(final Collection<PrincipalView> principals) {
        this.principals.clear();
        this.principals.addAll(principals);
    }
}
