/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.forms;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.repository.Ids;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@PublicApiRef
public class FacetFilters {
    private String parentId;
    private String targetId;
    private List<Type> types = new ArrayList<Type>();

    public FacetFilters() {
    }

    public FacetFilters(String parentId, String targetId, List<Type> types) {
        this.parentId = parentId;
        this.targetId = targetId;
        this.types = types;
    }

    public void validate() {
        Checks.checkArgument((this.hasParentId() || this.hasTargetId() ? 1 : 0) != 0, (String)"Please specify targetId or parentId.", (Object[])new Object[0]);
        Checks.checkArgument((!this.hasParentId() || Ids.isReleaseId((String)this.getParentId()) ? 1 : 0) != 0, (String)"Parent ID is not a valid release ID.", (Object[])new Object[0]);
    }

    public boolean hasParentId() {
        return this.parentId != null && Strings.isNotBlank((String)this.parentId);
    }

    public boolean hasTargetId() {
        return this.targetId != null && Strings.isNotBlank((String)this.targetId);
    }

    public FacetFilters withParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public FacetFilters withTargetId(String targetId) {
        this.targetId = targetId;
        return this;
    }

    public FacetFilters withType(Type ... types) {
        this.types = Arrays.asList(types);
        return this;
    }

    public FacetFilters includingType(String type) {
        if (this.types == null) {
            this.withType(Type.valueOf((String)type));
        } else {
            this.types.add(Type.valueOf((String)type));
        }
        return this;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public void setTypes(List<Type> types) {
        this.types = types;
    }
}

