#
# Copyright (c) 2023. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#


from contextlib import closing

from com.xebialabs.xlrelease.plugin.platform import RemoveRevisionRequest
from com.xebialabs.xlrelease.plugin.platform.domain import RemovalReason

# "Injected" variables:

global task
global platformServer

global application  # application id
global revision
global removalReason


# We cannot import code from a common module, therefore we replicate the following
# function everywhere we need it. You are welcome.
def get_client(task):
    python_script = task.pythonScript
    return python_script.getClient()


with closing(get_client(task)) as client:
    task.setStatusLine("Loading application information...")
    app_response = client.getApplication(application)
    progression_id = app_response["progression_id"] if app_response else None
    package_id = app_response["package_id"] if app_response else None
    package_name = app_response["package_name"] if app_response else None

    card_response = client.listCards(progression_id, package_id, revision).results()
    if not card_response:
        raise Exception("No matching card found!")

    card = card_response[0]

    task.setStatusLine("Removing revision...")
    removal_reason = RemovalReason.getRemovalReasonOf(str(removalReason))

    resp = client.removeRevision(card["id"], revision, RemoveRevisionRequest(removal_reason))

    task.setStatusLine("Revision {} removed for application {}.".format(revision, package_name))
