/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.time.Clock;
import java.time.Duration;
import java.util.function.Function;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.TokenExchangeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.WebClientReactiveTokenExchangeTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class TokenExchangeReactiveOAuth2AuthorizedClientProvider
implements ReactiveOAuth2AuthorizedClientProvider {
    private ReactiveOAuth2AccessTokenResponseClient<TokenExchangeGrantRequest> accessTokenResponseClient = new WebClientReactiveTokenExchangeTokenResponseClient();
    private Function<OAuth2AuthorizationContext, Mono<OAuth2Token>> subjectTokenResolver = this::resolveSubjectToken;
    private Function<OAuth2AuthorizationContext, Mono<OAuth2Token>> actorTokenResolver = context -> Mono.empty();
    private Duration clockSkew = Duration.ofSeconds(60L);
    private Clock clock = Clock.systemUTC();

    @Override
    public Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        ClientRegistration clientRegistration = context.getClientRegistration();
        if (!AuthorizationGrantType.TOKEN_EXCHANGE.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            return Mono.empty();
        }
        OAuth2AuthorizedClient authorizedClient = context.getAuthorizedClient();
        if (authorizedClient != null && !this.hasTokenExpired((OAuth2Token)authorizedClient.getAccessToken())) {
            return Mono.empty();
        }
        return this.subjectTokenResolver.apply(context).flatMap(subjectToken -> this.actorTokenResolver.apply(context).map(actorToken -> new TokenExchangeGrantRequest(clientRegistration, (OAuth2Token)subjectToken, (OAuth2Token)actorToken)).defaultIfEmpty((Object)new TokenExchangeGrantRequest(clientRegistration, (OAuth2Token)subjectToken, null))).flatMap(this.accessTokenResponseClient::getTokenResponse).onErrorMap(OAuth2AuthorizationException.class, ex -> new ClientAuthorizationException(ex.getError(), clientRegistration.getRegistrationId(), (Throwable)ex)).map(tokenResponse -> new OAuth2AuthorizedClient(clientRegistration, context.getPrincipal().getName(), tokenResponse.getAccessToken()));
    }

    private Mono<OAuth2Token> resolveSubjectToken(OAuth2AuthorizationContext context) {
        return Mono.just((Object)context).map(ctx -> ctx.getPrincipal().getPrincipal()).filter(principal -> principal instanceof OAuth2Token).cast(OAuth2Token.class);
    }

    private boolean hasTokenExpired(OAuth2Token token) {
        return this.clock.instant().isAfter(token.getExpiresAt().minus(this.clockSkew));
    }

    public void setAccessTokenResponseClient(ReactiveOAuth2AccessTokenResponseClient<TokenExchangeGrantRequest> accessTokenResponseClient) {
        Assert.notNull(accessTokenResponseClient, (String)"accessTokenResponseClient cannot be null");
        this.accessTokenResponseClient = accessTokenResponseClient;
    }

    public void setSubjectTokenResolver(Function<OAuth2AuthorizationContext, Mono<OAuth2Token>> subjectTokenResolver) {
        Assert.notNull(subjectTokenResolver, (String)"subjectTokenResolver cannot be null");
        this.subjectTokenResolver = subjectTokenResolver;
    }

    public void setActorTokenResolver(Function<OAuth2AuthorizationContext, Mono<OAuth2Token>> actorTokenResolver) {
        Assert.notNull(actorTokenResolver, (String)"actorTokenResolver cannot be null");
        this.actorTokenResolver = actorTokenResolver;
    }

    public void setClockSkew(Duration clockSkew) {
        Assert.notNull((Object)clockSkew, (String)"clockSkew cannot be null");
        Assert.isTrue((clockSkew.getSeconds() >= 0L ? 1 : 0) != 0, (String)"clockSkew must be >= 0");
        this.clockSkew = clockSkew;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }
}

