/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.vault.core.ReactiveVaultKeyValueAccessor;
import org.springframework.vault.core.ReactiveVaultKeyValueOperations;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.core.VaultKeyValueOperationsSupport;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultResponseSupport;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveVaultKeyValue1Template
extends ReactiveVaultKeyValueAccessor
implements ReactiveVaultKeyValueOperations {
    private final String path;

    public ReactiveVaultKeyValue1Template(ReactiveVaultOperations vaultOperations, String path) {
        super(vaultOperations, path);
        this.path = path;
    }

    @Override
    public Flux<String> list(String path) {
        return this.reactiveVaultOperations.list(this.createDataPath(path));
    }

    @Override
    public Mono<VaultResponse> get(String path) {
        return this.doRead(path, Map.class, (response, map) -> {
            VaultResponse vaultResponse = new VaultResponse();
            vaultResponse.applyMetadata((VaultResponseSupport<?>)response);
            vaultResponse.setData(map);
            return vaultResponse;
        });
    }

    @Override
    public <T> Mono<VaultResponseSupport<T>> get(String path, Class<T> responseType) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        Assert.notNull(responseType, (String)"Response type must not be null");
        return this.doRead(path, responseType, (response, data) -> {
            VaultResponseSupport result = response;
            result.setData(data);
            return result;
        });
    }

    @Override
    public Mono<Boolean> patch(String path, Map<String, ?> patch) {
        throw new IllegalStateException("K/V engine mount must be version 2 for patch support");
    }

    @Override
    public Mono<Void> put(String path, Object body) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        return this.doWrite(this.createDataPath(path), body).then();
    }

    @Override
    public VaultKeyValueOperationsSupport.KeyValueBackend getApiVersion() {
        return VaultKeyValueOperationsSupport.KeyValueBackend.KV_1;
    }

    @Override
    JsonNode getJsonNode(VaultResponseSupport<JsonNode> response) {
        return response.getRequiredData();
    }

    @Override
    String createDataPath(String path) {
        return String.format("%s/%s", this.path, path);
    }
}

