/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.client;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.nio.ssl.BasicClientTlsStrategy;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.util.Timeout;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.transport.HttpClientTransportOverHTTP;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.HttpComponentsClientHttpConnector;
import org.springframework.http.client.reactive.JdkClientHttpConnector;
import org.springframework.http.client.reactive.JettyClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.vault.client.ClientHttpRequestFactoryFactory;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;
import reactor.netty.http.Http11SslContextSpec;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.SslProvider;

public class ClientHttpConnectorFactory {
    private static final boolean reactorNettyPresent = ClassUtils.isPresent((String)"reactor.netty.http.client.HttpClient", (ClassLoader)ClientHttpConnectorFactory.class.getClassLoader());
    private static final boolean httpComponentsPresent = ClassUtils.isPresent((String)"org.apache.hc.client5.http.impl.async", (ClassLoader)ClientHttpConnectorFactory.class.getClassLoader());
    private static final boolean jettyPresent = ClassUtils.isPresent((String)"org.eclipse.jetty.client.HttpClient", (ClassLoader)ClientHttpConnectorFactory.class.getClassLoader());

    public static ClientHttpConnector create(ClientOptions options, SslConfiguration sslConfiguration) {
        Assert.notNull((Object)options, (String)"ClientOptions must not be null");
        Assert.notNull((Object)sslConfiguration, (String)"SslConfiguration must not be null");
        try {
            if (reactorNettyPresent) {
                return ReactorNetty.usingReactorNetty(options, sslConfiguration);
            }
            if (httpComponentsPresent) {
                return HttpComponents.usingHttpComponents(options, sslConfiguration);
            }
            if (jettyPresent) {
                return JettyClient.usingJetty(options, sslConfiguration);
            }
            return JdkHttpClient.usingJdkHttpClient(options, sslConfiguration);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class ReactorNetty {
        public static ReactorClientHttpConnector usingReactorNetty(ClientOptions options, SslConfiguration sslConfiguration) {
            return new ReactorClientHttpConnector(ReactorNetty.createClient(options, sslConfiguration));
        }

        public static HttpClient createClient(ClientOptions options, SslConfiguration sslConfiguration) {
            HttpClient client = HttpClient.create();
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                Http11SslContextSpec sslContextSpec = ((Http11SslContextSpec)Http11SslContextSpec.forClient().configure(it -> ReactorNetty.configureSsl(sslConfiguration, it))).get();
                client = client.secure(builder -> builder.sslContext((SslProvider.ProtocolSslContextSpec)sslContextSpec));
            }
            client = (HttpClient)((HttpClient)client.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.toIntExact(options.getConnectionTimeout().toMillis()))).proxyWithSystemProperties();
            return client;
        }

        private static void configureSsl(SslConfiguration sslConfiguration, SslContextBuilder sslContextBuilder) {
            try {
                if (sslConfiguration.getTrustStoreConfiguration().isPresent()) {
                    sslContextBuilder.trustManager(ClientHttpRequestFactoryFactory.createTrustManagerFactory(sslConfiguration.getTrustStoreConfiguration()));
                }
                if (sslConfiguration.getKeyStoreConfiguration().isPresent()) {
                    sslContextBuilder.keyManager(ClientHttpRequestFactoryFactory.createKeyManagerFactory(sslConfiguration.getKeyStoreConfiguration(), sslConfiguration.getKeyConfiguration()));
                }
                if (!sslConfiguration.getEnabledProtocols().isEmpty()) {
                    sslContextBuilder.protocols(sslConfiguration.getEnabledProtocols());
                }
                if (!sslConfiguration.getEnabledCipherSuites().isEmpty()) {
                    sslContextBuilder.ciphers(sslConfiguration.getEnabledCipherSuites());
                }
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static class HttpComponents {
        public static HttpComponentsClientHttpConnector usingHttpComponents(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            HttpAsyncClientBuilder httpClientBuilder = HttpComponents.createHttpAsyncClientBuilder(options, sslConfiguration);
            return new HttpComponentsClientHttpConnector(httpClientBuilder.build());
        }

        public static HttpAsyncClientBuilder createHttpAsyncClientBuilder(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClientBuilder.create();
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner((SchemePortResolver)DefaultSchemePortResolver.INSTANCE, ProxySelector.getDefault()));
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                SSLContext sslContext = ClientHttpRequestFactoryFactory.getSSLContext(sslConfiguration);
                String[] enabledProtocols = !sslConfiguration.getEnabledProtocols().isEmpty() ? sslConfiguration.getEnabledProtocols().toArray(new String[0]) : null;
                String[] enabledCipherSuites = !sslConfiguration.getEnabledCipherSuites().isEmpty() ? sslConfiguration.getEnabledCipherSuites().toArray(new String[0]) : null;
                BasicClientTlsStrategy tlsStrategy = new BasicClientTlsStrategy(sslContext, (endpoint, sslEngine) -> {
                    if (enabledProtocols != null) {
                        sslEngine.setEnabledProtocols(enabledProtocols);
                    }
                    if (enabledCipherSuites != null) {
                        sslEngine.setEnabledCipherSuites(enabledCipherSuites);
                    }
                }, null);
                PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy((TlsStrategy)tlsStrategy).build();
                httpClientBuilder.setConnectionManager((AsyncClientConnectionManager)connectionManager);
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)options.getConnectionTimeout().toMillis())).setResponseTimeout(Timeout.ofMilliseconds((long)options.getReadTimeout().toMillis())).setAuthenticationEnabled(true).setRedirectsEnabled(true).build();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            return httpClientBuilder;
        }
    }

    public static class JettyClient {
        public static JettyClientHttpConnector usingJetty(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            return new JettyClientHttpConnector(JettyClient.configureClient(JettyClient.getHttpClient(sslConfiguration), options));
        }

        public static org.eclipse.jetty.client.HttpClient configureClient(org.eclipse.jetty.client.HttpClient httpClient, ClientOptions options) {
            httpClient.setConnectTimeout(options.getConnectionTimeout().toMillis());
            httpClient.setAddressResolutionTimeout(options.getConnectionTimeout().toMillis());
            return httpClient;
        }

        public static org.eclipse.jetty.client.HttpClient getHttpClient(SslConfiguration sslConfiguration) throws IOException, GeneralSecurityException {
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                SslConfiguration.KeyConfiguration keyConfiguration;
                KeyStore keyStore;
                SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
                if (sslConfiguration.getKeyStoreConfiguration().isPresent()) {
                    keyStore = ClientHttpRequestFactoryFactory.getKeyStore(sslConfiguration.getKeyStoreConfiguration());
                    sslContextFactory.setKeyStore(keyStore);
                }
                if (sslConfiguration.getTrustStoreConfiguration().isPresent()) {
                    keyStore = ClientHttpRequestFactoryFactory.getKeyStore(sslConfiguration.getTrustStoreConfiguration());
                    sslContextFactory.setTrustStore(keyStore);
                }
                if ((keyConfiguration = sslConfiguration.getKeyConfiguration()).getKeyAlias() != null) {
                    sslContextFactory.setCertAlias(keyConfiguration.getKeyAlias());
                }
                if (keyConfiguration.getKeyPassword() != null) {
                    sslContextFactory.setKeyManagerPassword(new String(keyConfiguration.getKeyPassword()));
                }
                if (!sslConfiguration.getEnabledProtocols().isEmpty()) {
                    sslContextFactory.setIncludeProtocols(sslConfiguration.getEnabledProtocols().toArray(new String[0]));
                }
                if (!sslConfiguration.getEnabledCipherSuites().isEmpty()) {
                    sslContextFactory.setIncludeCipherSuites(sslConfiguration.getEnabledCipherSuites().toArray(new String[0]));
                }
                ClientConnector connector = new ClientConnector();
                connector.setSslContextFactory(sslContextFactory);
                return new org.eclipse.jetty.client.HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP(connector));
            }
            return new org.eclipse.jetty.client.HttpClient();
        }
    }

    public static class JdkHttpClient {
        public static JdkClientHttpConnector usingJdkHttpClient(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            HttpClient.Builder builder = JdkHttpClient.getBuilder(options, sslConfiguration);
            return new JdkClientHttpConnector(builder.build());
        }

        public static HttpClient.Builder getBuilder(ClientOptions options, SslConfiguration sslConfiguration) throws GeneralSecurityException, IOException {
            HttpClient.Builder builder = java.net.http.HttpClient.newBuilder();
            if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
                SSLContext sslContext = ClientHttpRequestFactoryFactory.getSSLContext(sslConfiguration);
                String[] enabledProtocols = !sslConfiguration.getEnabledProtocols().isEmpty() ? sslConfiguration.getEnabledProtocols().toArray(new String[0]) : null;
                String[] enabledCipherSuites = !sslConfiguration.getEnabledCipherSuites().isEmpty() ? sslConfiguration.getEnabledCipherSuites().toArray(new String[0]) : null;
                SSLParameters parameters = new SSLParameters();
                parameters.setProtocols(enabledProtocols);
                parameters.setCipherSuites(enabledCipherSuites);
                builder.sslContext(sslContext).sslParameters(parameters);
            }
            builder.proxy(ProxySelector.getDefault()).followRedirects(HttpClient.Redirect.ALWAYS).connectTimeout(options.getConnectionTimeout());
            return builder;
        }
    }
}

