import React from 'react';
import { CssCell, CssGrid } from '@digital-ai/dot-components';
import { calculateCellProps } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/helper';
import { ExternalDeploymentCardSkeletonComponent } from './external-deployment-card-skeleton.component';
import './external-deployments-cards-skeleton.component.less';

export const ExternalDeploymentsCardsSkeletonComponent = () => {
    return (
        <div className="external-deployments-cards-skeletons">
            <CssGrid>
                {[...Array(3)].map((_cellValue, cellIndex) => {
                    const props = calculateCellProps(cellIndex);
                    return (
                        <CssCell className="external-deployments-cards-skeletons-card-cell" {...props} key={cellIndex}>
                            <ExternalDeploymentCardSkeletonComponent />
                        </CssCell>
                    );
                })}
            </CssGrid>
        </div>
    );
};
