/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.apiclient.Pair;
import com.versionone.apiclient.exceptions.MetaException;
import com.versionone.apiclient.interfaces.IAssetType;
import com.versionone.apiclient.interfaces.IAttributeDefinition;
import com.versionone.apiclient.interfaces.IMetaModel;
import com.versionone.apiclient.interfaces.IOperation;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;

class AssetType
implements IAssetType {
    private IMetaModel _metaModel;
    private Map _map;
    private String _displayname;
    private String _token;
    private IAssetType _base = null;
    private String _basetoken = null;
    private IAttributeDefinition _orderby = null;
    private String _orderbytoken = null;
    private IAttributeDefinition _ShortNameAttribute = null;
    private String _shortNameToken = null;
    private IAttributeDefinition _NameAttribute = null;
    private String _nameToken = null;
    private IAttributeDefinition _DescriptionAttribute = null;
    private String _descriptionToken = null;

    public AssetType(IMetaModel meta, Element element, Map map) throws Exception {
        Element descriptionElement;
        Element shortNameElement;
        Element nameElement;
        Element orderbyelement;
        this._metaModel = meta;
        this._map = map;
        this._displayname = element.getAttribute("displayname");
        this._token = element.getAttribute("token");
        XPath xpath = XPathFactory.newInstance().newXPath();
        Element baseelement = (Element)xpath.evaluate("Base", element, XPathConstants.NODE);
        if (baseelement != null) {
            this._basetoken = baseelement.getAttribute("nameref");
        }
        if ((orderbyelement = (Element)xpath.evaluate("DefaultOrderBy", element, XPathConstants.NODE)) != null) {
            this._orderbytoken = orderbyelement.getAttribute("tokenref");
        }
        if ((nameElement = (Element)xpath.evaluate("Name", element, XPathConstants.NODE)) != null) {
            this._nameToken = nameElement.getAttribute("tokenref");
        }
        if ((shortNameElement = (Element)xpath.evaluate("ShortName", element, XPathConstants.NODE)) != null) {
            this._shortNameToken = shortNameElement.getAttribute("tokenref");
        }
        if ((descriptionElement = (Element)xpath.evaluate("Description", element, XPathConstants.NODE)) != null) {
            this._descriptionToken = descriptionElement.getAttribute("tokenref");
        }
    }

    private IAttributeDefinition findAttributeDefinition(String name) {
        Pair key = new Pair(this, name);
        return (IAttributeDefinition)this._map.get(key);
    }

    void saveAttributeDefinition(IAttributeDefinition attribdef) {
        Pair key = new Pair(this, attribdef.getName());
        this._map.put(key, attribdef);
    }

    @Override
    public IAttributeDefinition getAttributeDefinition(String name) throws MetaException {
        IAttributeDefinition attribdef = this.findAttributeDefinition(name);
        if (attribdef != null) {
            return attribdef;
        }
        return this._metaModel.getAttributeDefinition(this.getToken() + "." + name);
    }

    @Override
    public boolean isA(IAssetType targettype) throws MetaException {
        for (IAssetType thistype = this; thistype != null; thistype = thistype.getBase()) {
            if (thistype != targettype) continue;
            return true;
        }
        return false;
    }

    @Override
    public IAssetType getBase() throws MetaException {
        if (this._base == null && this._basetoken != null) {
            this._base = this._metaModel.getAssetType(this._basetoken);
        }
        return this._base;
    }

    @Override
    public IAttributeDefinition getDefaultOrderBy() throws MetaException {
        if (this._orderby == null && this._orderbytoken != null) {
            this._orderby = this._metaModel.getAttributeDefinition(this._orderbytoken);
        }
        return this._orderby;
    }

    @Override
    public String getDisplayName() {
        return this._displayname;
    }

    @Override
    public String getToken() {
        return this._token;
    }

    @Override
    public IOperation getOperation(String name) throws MetaException {
        IOperation op = this.lookupOperation(name);
        if (op != null) {
            return op;
        }
        return this._metaModel.getOperation(this.getToken() + "." + name);
    }

    private IOperation lookupOperation(String name) {
        Pair key = new Pair(this, name);
        return (IOperation)this._map.get(key);
    }

    private IAttributeDefinition ResolveAttribute(String token, IAttributeDefinition result) throws MetaException {
        if (result == null && token != null) {
            result = this._metaModel.getAttributeDefinition(token);
        }
        return result;
    }

    @Override
    public IAttributeDefinition getShortNameAttribute() throws MetaException {
        this._ShortNameAttribute = this.ResolveAttribute(this._shortNameToken, this._ShortNameAttribute);
        return this._ShortNameAttribute;
    }

    @Override
    public IAttributeDefinition getNameAttribute() throws MetaException {
        this._NameAttribute = this.ResolveAttribute(this._nameToken, this._NameAttribute);
        return this._NameAttribute;
    }

    @Override
    public IAttributeDefinition getDescriptionAttribute() throws MetaException {
        this._DescriptionAttribute = this.ResolveAttribute(this._descriptionToken, this._DescriptionAttribute);
        return this._DescriptionAttribute;
    }
}

