/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.core.HttpStatusUtil;
import org.springframework.vault.core.ReactiveVaultKeyValueOperationsSupport;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.core.ReactiveVaultTemplate;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultResponseSupport;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

abstract class ReactiveVaultKeyValueAccessor
implements ReactiveVaultKeyValueOperationsSupport {
    protected final ReactiveVaultOperations reactiveVaultOperations;
    private final String path;
    private final ObjectMapper mapper = new ObjectMapper();

    ReactiveVaultKeyValueAccessor(ReactiveVaultOperations reactiveVaultOperations, String path) {
        Assert.notNull((Object)reactiveVaultOperations, (String)"ReactiveVaultOperations must not be null");
        Assert.hasText((String)path, (String)"Path must not be empty");
        this.reactiveVaultOperations = reactiveVaultOperations;
        this.path = path;
    }

    @Override
    public Mono<Void> delete(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        String dataPath = this.createDataPath(path);
        return this.reactiveVaultOperations.doWithSession(webClient -> webClient.delete().uri(dataPath, new Object[0]).exchangeToMono(ReactiveVaultTemplate.mapResponse(String.class, path, HttpMethod.DELETE))).then();
    }

    <I, T> Mono<T> doRead(String path, Class<I> deserializeAs, BiFunction<VaultResponseSupport<?>, I, T> mappingFunction) {
        ParameterizedTypeReference<VaultResponseSupport<JsonNode>> ref = VaultResponses.getTypeReference(JsonNode.class);
        Mono<VaultResponseSupport<JsonNode>> response = this.doRead(this.createDataPath(path), ref);
        return response.map(it -> {
            JsonNode jsonNode = this.getJsonNode((VaultResponseSupport<JsonNode>)it);
            JsonNode jsonMeta = ((JsonNode)it.getRequiredData()).at("/metadata");
            it.setMetadata((Map)this.mapper.convertValue((Object)jsonMeta, (TypeReference)new TypeReference<Map<String, Object>>(){}));
            return mappingFunction.apply((VaultResponseSupport<?>)it, (Object)this.deserialize(jsonNode, deserializeAs));
        });
    }

    <T> Mono<T> doRead(String path, ParameterizedTypeReference<T> typeReference) {
        return this.doRead((WebClient webClient) -> webClient.get().uri(path, new Object[0]), new ResponseFunction(cr -> cr.toEntity(typeReference)));
    }

    <T> Mono<T> doRead(String path, Class<T> typeReference) {
        return this.doRead((WebClient webClient) -> webClient.get().uri(path, new Object[0]), new ResponseFunction(cr -> cr.toEntity(typeReference)));
    }

    <T> T deserialize(JsonNode jsonNode, Class<T> type) {
        try {
            return (T)this.mapper.reader().readValue(jsonNode.traverse(), type);
        }
        catch (IOException e) {
            throw new VaultException("Cannot deserialize response", e);
        }
    }

    <T> Mono<T> doRead(Function<WebClient, WebClient.RequestHeadersSpec<?>> callback, Function<ClientResponse, Mono<T>> responseFunction) {
        return this.reactiveVaultOperations.doWithSession(restOperations -> ((WebClient.RequestHeadersSpec)callback.apply((WebClient)restOperations)).exchangeToMono(responseFunction));
    }

    Mono<VaultResponse> doWrite(String path, @Nullable Object body) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        return this.reactiveVaultOperations.write(path, body);
    }

    abstract JsonNode getJsonNode(VaultResponseSupport<JsonNode> var1);

    abstract String createDataPath(String var1);

    final class ResponseFunction<T>
    implements Function<ClientResponse, Mono<T>> {
        private final Function<ClientResponse, Mono<ResponseEntity<T>>> toEntity;

        public ResponseFunction(Function<ClientResponse, Mono<ResponseEntity<T>>> toEntity) {
            this.toEntity = toEntity;
        }

        @Override
        public Mono<T> apply(ClientResponse clientResponse) {
            if (HttpStatusUtil.isNotFound(clientResponse.statusCode())) {
                return Mono.empty();
            }
            if (clientResponse.statusCode().is2xxSuccessful()) {
                return this.toEntity.apply(clientResponse).mapNotNull(HttpEntity::getBody);
            }
            return clientResponse.bodyToMono(String.class).flatMap(error -> Mono.error((Throwable)((Object)VaultResponses.buildException(clientResponse.statusCode(), ReactiveVaultKeyValueAccessor.this.path, error))));
        }
    }
}

