import { externalApplicationWizard, initialState } from './application-wizard.reducer';
import { mockServerCi } from '../__mocks__/discovery-wizard.mocks';

describe('application wizard reducer', () => {
    const { setConnectionTested, setTestConnectionStatus, testConnection } = externalApplicationWizard.actions;

    it('should have the initial state', () => {
        expect(externalApplicationWizard.name).toBe('externalApplicationWizard');
        expect(externalApplicationWizard.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    describe('reducers', () => {
        describe('setConnectionTested', () => {
            it('should set connectionTested', () => {
                const state = externalApplicationWizard.reducer(initialState, setConnectionTested(true));
                expect(state.connectionTested).toStrictEqual(true);
            });
        });
        describe('setTestConnectionStatus', () => {
            const testConnectionStatus = {
                errorText: 'some text',
                success: false,
            };
            it('should set testConnectionStatus', () => {
                const state = externalApplicationWizard.reducer(initialState, setTestConnectionStatus(testConnectionStatus));
                expect(state.testConnectionStatus).toStrictEqual(testConnectionStatus);
            });
        });
        describe('setConnectionTested', () => {
            it('should do nothing', () => {
                const state = externalApplicationWizard.reducer(initialState, testConnection(mockServerCi));
                expect(state).toStrictEqual(initialState);
            });
        });
    });
});
