#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import logging

from vault import VaultClient
from com.xebialabs.xlrelease.plugin.vault import VaultServer

logger = logging.getLogger("Vault")
print("VAULT V2: Executing %s" % task.getTaskType())
vault_client = VaultClient(url=vaultServer['url'], token=vaultServer['token'], username=vaultServer['username'],
                           password=vaultServer['password'], namespace=vaultServer['namespace'],
                           authenticationMethod=vaultServer['authenticationMethod'], role_id=vaultServer['role_id'], secret_id=vaultServer['secret_id'], logger=logger)

# Use the name of the type in multiple places.
mytype = str(task.getTaskType())
print("=== VAULT SECRET V2 : {} ===".format(mytype))


def getMaskedValue(value):
    return re.sub(r'.*', '*******', value)


if vaultServer['namespace'] is not None and len(vaultServer['namespace']) > 0:
    print("Namespace Provided so Vault Initialization Check is Skipped")
elif vault_client.is_initialized():
    print("Vault Initialized:{}".format(vaultServer['url']))
else:
    vault_client.exit(vault_client.VAULT_NOT_INITIALIZED,
                      "Your Vault Server at {} is not initialized".format(vaultServer['url']), authenticationType=str(vaultServer['authenticationMethod']))

if vault_client.is_sealed():
    vault_client.exit(vault_client.VAULT_SERVER_SEALED, "Vault Server {} is Sealed".format(vaultServer['url']), authenticationType=str(vaultServer['authenticationMethod']))

if vaultServer['authenticationMethod'] == "PAT":
    if vaultServer['token'] is None:
        vault_client.exit(vault_client.VAULT_NO_TOKEN, "You must use a token in Vault for Token Authentication", authenticationType=str(vaultServer['authenticationMethod']))
if vaultServer['authenticationMethod'] == "Basic" or vaultServer['authenticationMethod'] == "LDAP":
    if vaultServer['username'] is None:
        vault_client.exit(vault_client.VAULT_NO_TOKEN,
                          "You must use username/password in Vault for Basic/LDAP Authentication", authenticationType=str(vaultServer['authenticationMethod']))
if vaultServer['authenticationMethod'] == "Approle":
    if vaultServer['role_id'] is None:
        vault_client.exit(vault_client.VAULT_NO_TOKEN,
                          "You must use RoleId/SecretId in Vault for Approle Authentication", authenticationType=str(vaultServer['authenticationMethod']))

# vault.SecretsV2.Read
if mytype == 'vault.SecretsV2-Configure':
    configureBody = {'max_versions': max_versions, 'cas_required': cas_required}
    configureSecretsEngine = 'v1/'+ mount_point + '/config'
    vault_client.configure_kv_engine(path=configureSecretsEngine, body=configureBody)
    print("SecretsV2-Configuration set")

elif mytype == 'vault.SecretsV2-EnableEngine':
    ErrorString = ""
    if backend_type == None or backend_type == "":
        ErrorString += "backend_type"
    if mount_point == None or mount_point == "":
        ErrorString += " mount_point"
    if ErrorString != "" or len(ErrorString) > 0:
        exit("VAULT Error - Please check these Fields :" + ErrorString)
    else:
        payload = {
            'type': backend_type,
            'config': data,
            'description': engine_description,
            'local': auth_local
        }
        enableEnginePath = 'v1/sys/mounts/'+ mount_point
        vault_client.enable_engine(enableEnginePath,payload)
    print("New " + mount_point + " Engine Enabled - V2")

elif mytype == 'vault.SecretsV2-ReadSecret':
    key_path = path + '/' + key
    print("Reading from {}".format(key_path))
    readSecretPath = 'v1/'+ mount_point + '/data/' + path
    read_response = vault_client.read_secret(path=readSecretPath)
    if 'data' in read_response:
        value = read_response['data']['data'][key]
        print(">> Read Secret Request complete for {}/{}/{} - {}".format(mount_point, path, key, getMaskedValue(value)))
        if value is None:
            print("Key {} not found in path  ", key_path)
    else:
        exit("Data not found in path :" + key_path)

elif mytype == 'vault.SecretsV2-ReadConfiguration':
    configureSecretsEngine = 'v1/'+ mount_point + '/config'
    kv_configuration = vault_client.get_config_kv_engine(configureSecretsEngine)
    if 'data' in kv_configuration:
        print('Config under path "kv": max_versions set to "{max_ver}"'.format(
            max_ver=kv_configuration['data']['max_versions'], ))
        print('Config under path "kv": check-and-set require flag set to {cas}'.format(
            cas=kv_configuration['data']['cas_required'], ))
    else:
        exit("Configuration not found for mount point :" + mount_point)

elif mytype == "vault.SecretsV2-ReadSecretVersions":
    readSecretPathVersion = 'v1/'+ mount_point + '/data/' + path + '?version=' + version
    secret_version_response = vault_client.read_secret(path=readSecretPathVersion)
    if 'data' in secret_version_response:
        print('Version {} of secret under path {} contains the following keys: {data}'.format(
            version, path, data=(secret_version_response['data']['data'].keys()), ))
        print('Version {} of secret under path {} created at: {date}'.format(
            version, path, date=secret_version_response['data']['metadata']['created_time'], ))
    else:
        exit("Vault Error: Please Check the Version Number")

elif mytype == "vault.SecretsV2-CreateSecret":
    print('CreateSecret has these values for path, key, cas = {},{},{}'.format(path, key, cas))
    createSecretPath = 'v1/'+ mount_point + '/data/' + path
    data = {key: value}
    options = {}
    if cas:
        options = {'cas': cas_version}

    newsecret = {
        'options': options,
        'data': data
    }
    response = vault_client.create_secret_v2(path=createSecretPath,secret=newsecret)
    if response and 'data' in response:
        version = response['data']['version']
        print("VAULT: Response = %s" % response)
    else:
        if response:
            if 'errors' in response:
                exit("VAULT: Response =" + response['errors'][0])
            else:
                exit("VAULT: Response =" + response)
        else:
            exit("VAULT: Response - Error")

elif mytype == "vault.SecretsV2-PatchExistingSecret":
    patchSecretPath = 'v1/'+ mount_point + '/data/' + path
    data = {key: value}
    secretdata = {'data':data}
    response = vault_client.create_secret(path=patchSecretPath,secret=secretdata)
    print("Response is {}".format(response))

elif mytype == "vault.SecretsV2-DeleteVersion":
    deleteSecretPath = 'v1/'+ mount_point + '/data/' + path
    if latest:  # Delete the latest version
        response = vault_client.delete_secret(path=deleteSecretPath)
    else:  # Need to delete a specific version
        deleteSecretPathDeleteVersion = 'v1/'+ mount_point + '/delete/' + path
        version_array = [int(numeric_string) for numeric_string in version.split(",")]
        versions = {'versions': version_array}
        vault_client.delete_secret_version(path=deleteSecretPathDeleteVersion,versions=versions)

elif mytype == "vault.SecretsV2-UndeleteVersion":
    deleteSecretPath = 'v1/'+ mount_point + '/undelete/' + path
    version_array = [int(numeric_string) for numeric_string in version.split(",")]
    versions = {'versions': version_array}
    vault_client.delete_secret_version(path=deleteSecretPath,versions=versions)
    print("Undeleted path is {}".format(deleteSecretPath))

elif mytype == "vault.SecretsV2-DestroyVersion":
    destroySecretPath = 'v1/'+ mount_point + '/destroy/' + path
    version_array = [int(numeric_string) for numeric_string in version.split(",")]
    versions = {'versions': version_array}
    response = vault_client.destroy_secret_version(path=destroySecretPath,versions=versions)
    print("Response is {}".format(response))

elif mytype == "vault.SecretsV2-ListSecrets":
    listSecretPath = 'v1/'+ mount_point + '/metadata'
    response = vault_client.list_secret_v2(path=listSecretPath)
    print('Response is ', response)
    print('The following secrets are available under {} prefix: {keys}'.format(mount_point,
                                                                               keys=','.join(response['data']['keys'])))

elif mytype == "vault.SecretsV2-ReadSecretMetadata":
    listSecretMetadataPath = 'v1/'+ mount_point + '/metadata/' + path
    hvac_path_metadata = vault_client.read_secret(path=listSecretMetadataPath)
    print('Metadata under path {} is {}'.format(path, hvac_path_metadata))

elif mytype == "vault.SecretsV2-UpdateMetaData":
    updateMetadataPath = 'v1/'+ mount_point + '/metadata/' + path
    secret = {
        "max_versions": max_versions,
        "cas_required": cas
    }
    response = vault_client.update_metadata_v2(path=updateMetadataPath,secret=secret)
    print("Response is {}".format(response))

elif mytype == "vault.SecretsV2-DeleteMetaDataAndAllVersions":
    listSecretPath = 'v1/'+ mount_point + '/metadata/' + path
    vault_client.delete_metadata_all_version(path=listSecretPath)
    print("Delete Meta Data And All Versions")

else:
    print("Not Implemented {}".format(mytype))

if vaultServer['authenticationMethod'] == "Basic" or vaultServer['authenticationMethod'] == "LDAP" or vaultServer['authenticationMethod'] == "Approle":
    vault_client.revokeUserPassToken()
