/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import java.util.Collections;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.core.KeyValueUtilities;
import org.springframework.vault.core.SecretNotFoundException;
import org.springframework.vault.core.VaultKeyValue2Accessor;
import org.springframework.vault.core.VaultKeyValueOperations;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultResponseSupport;

class VaultKeyValue2Template
extends VaultKeyValue2Accessor
implements VaultKeyValueOperations {
    private final String path;

    public VaultKeyValue2Template(VaultOperations vaultOperations, String path) {
        super(vaultOperations, path);
        this.path = path;
    }

    @Override
    @Nullable
    public VaultResponse get(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        return this.doRead(path, Map.class, (response, data) -> {
            VaultResponse vaultResponse = new VaultResponse();
            vaultResponse.applyMetadata((VaultResponseSupport<?>)response);
            vaultResponse.setData(data);
            return vaultResponse;
        });
    }

    @Override
    @Nullable
    public <T> VaultResponseSupport<T> get(String path, Class<T> responseType) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        Assert.notNull(responseType, (String)"Response type must not be null");
        return this.doRead(path, responseType, (response, data) -> {
            VaultResponseSupport result = response;
            result.setData(data);
            return result;
        });
    }

    @Override
    public boolean patch(String path, Map<String, ?> patch) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        Assert.notNull(patch, (String)"Patch body must not be null");
        VaultResponse readResponse = this.get(path);
        if (readResponse == null || readResponse.getData() == null) {
            throw new SecretNotFoundException(String.format("No data found at %s; patch only works on existing data", this.createDataPath(path)), String.format("%s/%s", this.path, path));
        }
        if (readResponse.getMetadata() == null) {
            throw new VaultException("Metadata must not be null");
        }
        Map<String, Object> body = KeyValueUtilities.createPatchRequest(patch, (Map)readResponse.getRequiredData(), readResponse.getMetadata());
        try {
            this.doWrite(this.createDataPath(path), body);
            return true;
        }
        catch (VaultException e) {
            if (e.getMessage() != null && (e.getMessage().contains("check-and-set") || e.getMessage().contains("did not match the current version"))) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void put(String path, Object body) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        this.doWrite(this.createDataPath(path), Collections.singletonMap("data", body));
    }
}

