/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.iam.credentials.v1.IamCredentialsClient;
import com.google.cloud.iam.credentials.v1.IamCredentialsSettings;
import com.google.cloud.iam.credentials.v1.ServiceAccountName;
import com.google.cloud.iam.credentials.v1.SignJwtResponse;
import com.google.cloud.iam.credentials.v1.stub.IamCredentialsStubSettings;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.GcpIamCredentialsAuthenticationOptions;
import org.springframework.vault.authentication.GcpJwtAuthenticationSupport;
import org.springframework.vault.authentication.GoogleJsonUtil;
import org.springframework.vault.authentication.VaultLoginException;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.RestOperations;

public class GcpIamCredentialsAuthentication
extends GcpJwtAuthenticationSupport
implements ClientAuthentication {
    private final GcpIamCredentialsAuthenticationOptions options;
    private final TransportChannelProvider transportChannelProvider;
    private final GoogleCredentials credentials;

    public GcpIamCredentialsAuthentication(GcpIamCredentialsAuthenticationOptions options, RestOperations restOperations) {
        this(options, restOperations, (TransportChannelProvider)IamCredentialsStubSettings.defaultGrpcTransportProviderBuilder().build());
    }

    public GcpIamCredentialsAuthentication(GcpIamCredentialsAuthenticationOptions options, RestOperations restOperations, TransportChannelProvider transportChannelProvider) {
        super(restOperations);
        Assert.notNull((Object)options, (String)"GcpAuthenticationOptions must not be null");
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        Assert.notNull((Object)transportChannelProvider, (String)"TransportChannelProvider must not be null");
        this.options = options;
        this.transportChannelProvider = transportChannelProvider;
        this.credentials = options.getCredentialSupplier().get();
    }

    @Override
    public VaultToken login() throws VaultException {
        String signedJwt = this.signJwt();
        return this.doLogin("GCP-IAM", signedJwt, this.options.getPath(), this.options.getRole());
    }

    protected String signJwt() {
        String string;
        block8: {
            String serviceAccount = this.getServiceAccountId();
            Map<String, Object> jwtPayload = GcpIamCredentialsAuthentication.getJwtPayload(this.options, serviceAccount);
            IamCredentialsSettings credentialsSettings = ((IamCredentialsSettings.Builder)((IamCredentialsSettings.Builder)IamCredentialsSettings.newBuilder().setCredentialsProvider(() -> this.credentials)).setTransportChannelProvider(this.transportChannelProvider)).build();
            IamCredentialsClient iamCredentialsClient = IamCredentialsClient.create((IamCredentialsSettings)credentialsSettings);
            try {
                String payload = GoogleJsonUtil.JSON_FACTORY.toString(jwtPayload);
                ServiceAccountName serviceAccountName = ServiceAccountName.of((String)"-", (String)serviceAccount);
                SignJwtResponse response = iamCredentialsClient.signJwt(serviceAccountName, Collections.emptyList(), payload);
                string = response.getSignedJwt();
                if (iamCredentialsClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iamCredentialsClient != null) {
                        try {
                            iamCredentialsClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new VaultLoginException("Cannot sign JWT", e);
                }
            }
            iamCredentialsClient.close();
        }
        return string;
    }

    private String getServiceAccountId() {
        return this.options.getServiceAccountIdAccessor().getServiceAccountId(this.credentials);
    }

    private static Map<String, Object> getJwtPayload(GcpIamCredentialsAuthenticationOptions options, String serviceAccount) {
        Instant validUntil = options.getClock().instant().plus(options.getJwtValidity());
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("sub", serviceAccount);
        payload.put("aud", "vault/" + options.getRole());
        payload.put("exp", validUntil.getEpochSecond());
        return payload;
    }
}

