/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.admin;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DefaultSaslConfig;
import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.jms.admin.RMQObjectFactory;
import com.rabbitmq.jms.client.AuthenticationMechanism;
import com.rabbitmq.jms.client.ConnectionParams;
import com.rabbitmq.jms.client.DefaultReplyToStrategy;
import com.rabbitmq.jms.client.RMQConnection;
import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.client.ReceivingContext;
import com.rabbitmq.jms.client.ReceivingContextConsumer;
import com.rabbitmq.jms.client.ReplyToStrategy;
import com.rabbitmq.jms.client.RmqJmsContext;
import com.rabbitmq.jms.client.SendingContext;
import com.rabbitmq.jms.client.SendingContextConsumer;
import com.rabbitmq.jms.util.RMQJMSException;
import com.rabbitmq.jms.util.RMQJMSSecurityException;
import com.rabbitmq.jms.util.UriCodec;
import com.rabbitmq.jms.util.WhiteListObjectInputStream;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQConnectionFactory
implements jakarta.jms.ConnectionFactory,
Referenceable,
Serializable,
QueueConnectionFactory,
TopicConnectionFactory {
    private final Logger logger = LoggerFactory.getLogger(RMQConnectionFactory.class);
    private static final long serialVersionUID = -4953157213762979615L;
    private static final int DEFAULT_RABBITMQ_SSL_PORT = 5671;
    private static final int DEFAULT_RABBITMQ_PORT = 5672;
    private String username = "guest";
    private String password = "guest";
    private String virtualHost = "/";
    private String host = "localhost";
    private int port = -1;
    private int onMessageTimeoutMs = 2000;
    private boolean preferProducerMessageProperty = true;
    private boolean requeueOnMessageListenerException = false;
    private boolean requeueOnTimeout = false;
    private boolean nackOnRollback = false;
    private boolean cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose = false;
    private BiFunction<AMQP.BasicProperties.Builder, Message, AMQP.BasicProperties.Builder> amqpPropertiesCustomiser;
    private MetricsCollector metricsCollector = new NoOpMetricsCollector();
    private Consumer<ConnectionFactory> amqpConnectionFactoryPostProcessor = new NoOpSerializableConsumer<ConnectionFactory>();
    private SendingContextConsumer sendingContextConsumer = new NoOpSerializableSendingContextConsumer();
    private ReceivingContextConsumer receivingContextConsumer = new NoOpSerializableReceivingContextConsumer();
    private boolean keepTextMessageType = false;
    private boolean ssl = false;
    private String tlsProtocol;
    private SSLContext sslContext;
    private boolean useDefaultSslContext = false;
    private boolean hostnameVerification = false;
    private int queueBrowserReadMax = Math.max(0, Integer.getInteger("rabbit.jms.queueBrowserReadMax", 0));
    private volatile long terminationTimeout = Long.getLong("rabbit.jms.terminationTimeout", 15000L);
    private int channelsQos = -1;
    private List<String> trustedPackages = WhiteListObjectInputStream.DEFAULT_TRUSTED_PACKAGES;
    private List<URI> uris = Collections.emptyList();
    private boolean declareReplyToDestination = true;
    private ReplyToStrategy replyToStrategy = DefaultReplyToStrategy.INSTANCE;
    private AuthenticationMechanism authenticationMechanism = AuthenticationMechanism.PLAIN;

    public jakarta.jms.Connection createConnection() throws JMSException {
        return this.createConnection(this.username, this.password);
    }

    public jakarta.jms.Connection createConnection(List<Address> endpoints) throws JMSException {
        return this.createConnection(this.username, this.password, endpoints);
    }

    public jakarta.jms.Connection createConnection(String username, String password) throws JMSException {
        if (this.uris == null || this.uris.isEmpty()) {
            return this.createConnection(username, password, (ConnectionFactory cf) -> cf.newConnection());
        }
        List addresses = this.uris.stream().map(uri -> {
            String host = uri.getHost();
            int port = uri.getPort();
            if (port == -1) {
                port = this.isSsl() ? 5671 : 5672;
            }
            return new Address(host, port);
        }).collect(Collectors.toList());
        return this.createConnection(username, password, (ConnectionFactory cf) -> cf.newConnection(addresses));
    }

    public jakarta.jms.Connection createConnection(String username, String password, List<Address> endpoints) throws JMSException {
        return this.createConnection(username, password, (ConnectionFactory cf) -> cf.newConnection(endpoints));
    }

    protected jakarta.jms.Connection createConnection(String username, String password, ConnectionCreator connectionCreator) throws JMSException {
        ReceivingContextConsumer rcc;
        this.logger.trace("Creating a connection for username '{}', password 'xxxxxxxx'.", (Object)username);
        this.username = username;
        this.password = password;
        ConnectionFactory cf = this.createConnectionFactory();
        this.maybeEnableTLS(cf);
        RMQConnectionFactory.setRabbitUri(this.logger, this, cf, this.getUri());
        this.maybeEnableHostnameVerification(cf);
        cf.setMetricsCollector(this.metricsCollector);
        this.setSaslConfig(cf, this.authenticationMechanism);
        if (this.amqpConnectionFactoryPostProcessor != null) {
            this.amqpConnectionFactoryPostProcessor.accept(cf);
        }
        Connection rabbitConnection = this.instantiateNodeConnection(cf, connectionCreator);
        if (this.declareReplyToDestination) {
            rcc = this.receivingContextConsumer;
        } else {
            rcc = ctx -> RMQMessage.doNotDeclareReplyToDestination(ctx.getMessage());
            if (this.receivingContextConsumer != null) {
                rcc = rcc.andThen(this.receivingContextConsumer);
            }
        }
        RMQConnection conn = new RMQConnection(new ConnectionParams().setRabbitConnection(rabbitConnection).setTerminationTimeout(this.getTerminationTimeout()).setQueueBrowserReadMax(this.getQueueBrowserReadMax()).setOnMessageTimeoutMs(this.getOnMessageTimeoutMs()).setChannelsQos(this.channelsQos).setPreferProducerMessageProperty(this.preferProducerMessageProperty).setRequeueOnMessageListenerException(this.requeueOnMessageListenerException).setNackOnRollback(this.nackOnRollback).setCleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose(this.cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose).setAmqpPropertiesCustomiser(this.amqpPropertiesCustomiser).setSendingContextConsumer(this.sendingContextConsumer).setReceivingContextConsumer(rcc).setTrustedPackages(this.trustedPackages).setRequeueOnTimeout(this.requeueOnTimeout).setKeepTextMessageType(this.keepTextMessageType).setReplyToStrategy(this.replyToStrategy));
        this.logger.debug("Connection {} created.", (Object)conn);
        return conn;
    }

    protected ConnectionFactory createConnectionFactory() {
        return new ConnectionFactory();
    }

    private Connection instantiateNodeConnection(ConnectionFactory cf, ConnectionCreator connectionCreator) throws JMSException {
        try {
            return connectionCreator.create(cf);
        }
        catch (SSLException ssle) {
            throw new RMQJMSSecurityException("SSL Exception establishing RabbitMQ Connection", ssle);
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                IOException ioe = (IOException)x;
                String msg = ioe.getMessage();
                if (msg != null) {
                    if (msg.contains("authentication failure") || msg.contains("refused using authentication")) {
                        throw new RMQJMSSecurityException(ioe);
                    }
                    if (msg.contains("Connection refused")) {
                        throw new RMQJMSException("RabbitMQ connection was refused. RabbitMQ broker may not be available.", ioe);
                    }
                }
                throw new RMQJMSException(ioe);
            }
            if (x instanceof TimeoutException) {
                TimeoutException te = (TimeoutException)x;
                throw new RMQJMSException("Timed out establishing RabbitMQ Connection", te);
            }
            throw new RMQJMSException("Unexpected exception thrown by newConnection()", x);
        }
    }

    public String getUri() {
        StringBuilder sb = new StringBuilder(RMQConnectionFactory.getScheme(this.isSsl())).append("://");
        sb.append(RMQConnectionFactory.uriUInfoEscape(this.username, this.password)).append('@');
        sb.append(RMQConnectionFactory.uriHostEscape(this.host)).append(':').append(this.getPort()).append("/");
        sb.append(RMQConnectionFactory.uriVirtualHostEscape(this.virtualHost));
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RMQConnectionFactory{");
        return (this.isSsl() ? sb.append("SSL, ") : sb).append("user='").append(this.username).append("', password").append(this.password != null ? "=xxxxxxxx" : " not set").append(", host='").append(this.host).append("', port=").append(this.getPort()).append(", virtualHost='").append(this.virtualHost).append("', onMessageTimeoutMs=").append(this.onMessageTimeoutMs).append(", queueBrowserReadMax=").append(this.queueBrowserReadMax).append('}').toString();
    }

    public void setUri(String uriString) throws JMSException {
        this.logger.trace("Set connection factory parameters by URI '{}'", (Object)uriString);
        if (uriString != null && !uriString.trim().isEmpty()) {
            ConnectionFactory factory = this.createConnectionFactory();
            RMQConnectionFactory.setRabbitUri(this.logger, this, factory, uriString);
            this.host = factory.getHost();
            this.password = factory.getPassword();
            this.port = factory.getPort();
            this.ssl = factory.isSSL();
            this.username = factory.getUsername();
            this.virtualHost = factory.getVirtualHost();
        } else {
            this.host = null;
            this.password = null;
            this.port = -1;
            this.ssl = false;
            this.username = null;
            this.virtualHost = null;
        }
    }

    public void setUris(List<String> urisAsStrings) throws JMSException {
        if (urisAsStrings != null && !urisAsStrings.isEmpty()) {
            this.uris = urisAsStrings.stream().map(uriAsString -> {
                try {
                    URI uri = new URI((String)uriAsString);
                    if (uri.getScheme() == null || !"amqp".equals(uri.getScheme()) && !"amqps".equals(uri.getScheme())) {
                        throw new IllegalArgumentException("Wrong scheme in AMQP URI: " + uri.getScheme());
                    }
                    return uri;
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Invalid URI: " + uriAsString);
                }
            }).collect(Collectors.toList());
            this.setUri(urisAsStrings.get(0));
        } else {
            this.uris = Collections.emptyList();
            this.setUri(null);
        }
    }

    public void setTrustedPackages(List<String> value) {
        this.trustedPackages = value;
    }

    public List<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    private static void setRabbitUri(Logger logger, RMQConnectionFactory rmqFactory, ConnectionFactory factory, String uriString) throws RMQJMSException {
        if (uriString != null) {
            try {
                factory.setUri(uriString);
            }
            catch (Exception e) {
                logger.error("Could not set URI on {}", (Object)rmqFactory, (Object)e);
                throw new RMQJMSException("Could not set URI on RabbitMQ connection factory.", e);
            }
        }
    }

    private void maybeEnableTLS(ConnectionFactory factory) {
        if (this.ssl) {
            try {
                if (this.useDefaultSslContext) {
                    factory.useSslProtocol(SSLContext.getDefault());
                } else if (this.sslContext != null) {
                    factory.useSslProtocol(this.sslContext);
                } else if (this.tlsProtocol != null) {
                    factory.useSslProtocol(this.tlsProtocol);
                } else {
                    factory.useSslProtocol();
                }
            }
            catch (Exception e) {
                this.logger.warn("Could not set SSL protocol on connection factory, {}. SSL set off.", (Object)this, (Object)e);
                this.ssl = false;
            }
        }
    }

    private void maybeEnableHostnameVerification(ConnectionFactory factory) {
        if (this.hostnameVerification) {
            if (this.ssl) {
                factory.enableHostnameVerification();
            } else {
                this.logger.warn("Hostname verification enabled, but not TLS, please enable TLS too.");
            }
        }
    }

    private void setSaslConfig(ConnectionFactory factory, AuthenticationMechanism authenticationMechanism) {
        switch (authenticationMechanism) {
            case PLAIN: {
                factory.setSaslConfig((SaslConfig)DefaultSaslConfig.PLAIN);
                break;
            }
            case EXTERNAL: {
                factory.setSaslConfig((SaslConfig)DefaultSaslConfig.EXTERNAL);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled AuthenticationMechanism: " + authenticationMechanism);
            }
        }
    }

    public boolean isSsl() {
        return this.ssl;
    }

    @Deprecated
    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void useSslProtocol() throws NoSuchAlgorithmException {
        this.useSslProtocol(ConnectionFactory.computeDefaultTlsProtocol((String[])SSLContext.getDefault().getSupportedSSLParameters().getProtocols()));
    }

    public void useSslProtocol(String protocol) {
        this.tlsProtocol = protocol;
        this.ssl = true;
    }

    public void useSslProtocol(SSLContext context) {
        this.sslContext = context;
        this.ssl = true;
    }

    public void useDefaultSslContext(boolean useDefaultSslContext) {
        this.useDefaultSslContext = useDefaultSslContext;
        this.ssl = true;
    }

    public boolean isUseDefaultSslContext() {
        return this.useDefaultSslContext;
    }

    public void setUseDefaultSslContext(boolean useDefaultSslContext) {
        this.useDefaultSslContext(useDefaultSslContext);
    }

    private static String getScheme(boolean isSsl) {
        return isSsl ? "amqps" : "amqp";
    }

    private static String uriUInfoEscape(String user, String pass) {
        if (null == user) {
            return null;
        }
        if (null == pass) {
            return UriCodec.encUserinfo(user, "UTF-8");
        }
        return UriCodec.encUserinfo(user + ":" + pass, "UTF-8");
    }

    private static String uriHostEscape(String host) {
        return UriCodec.encHost(host, "UTF-8");
    }

    private static String uriVirtualHostEscape(String vHost) {
        return UriCodec.encSegment(vHost, "UTF-8");
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(RMQConnectionFactory.class.getName(), RMQObjectFactory.class.getName(), null);
        RMQConnectionFactory.addStringRefProperty(ref, "uri", this.getUri());
        RMQConnectionFactory.addStringRefProperty(ref, "host", this.getHost());
        RMQConnectionFactory.addStringRefProperty(ref, "password", this.getPassword());
        RMQConnectionFactory.addIntegerRefProperty(ref, "port", this.getPort());
        RMQConnectionFactory.addIntegerRefProperty(ref, "queueBrowserReadMax", this.getQueueBrowserReadMax());
        RMQConnectionFactory.addIntegerRefProperty(ref, "onMessageTimeoutMs", this.getOnMessageTimeoutMs());
        RMQConnectionFactory.addIntegerRefProperty(ref, "channelsQos", this.getChannelsQos());
        RMQConnectionFactory.addBooleanProperty(ref, "ssl", this.ssl);
        RMQConnectionFactory.addLongRefProperty(ref, "terminationTimeout", this.getTerminationTimeout());
        RMQConnectionFactory.addStringRefProperty(ref, "username", this.getUsername());
        RMQConnectionFactory.addStringRefProperty(ref, "virtualHost", this.getVirtualHost());
        RMQConnectionFactory.addBooleanProperty(ref, "cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose", this.isCleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose());
        RMQConnectionFactory.addBooleanProperty(ref, "declareReplyToDestination", this.declareReplyToDestination);
        RMQConnectionFactory.addStringRefProperty(ref, "authenticationMechanism", this.authenticationMechanism.name());
        return ref;
    }

    private static void addStringRefProperty(Reference ref, String propertyName, String value) {
        if (value == null || propertyName == null) {
            return;
        }
        StringRefAddr ra = new StringRefAddr(propertyName, value);
        ref.add(ra);
    }

    private static void addIntegerRefProperty(Reference ref, String propertyName, Integer value) {
        if (value == null || propertyName == null) {
            return;
        }
        StringRefAddr ra = new StringRefAddr(propertyName, String.valueOf(value));
        ref.add(ra);
    }

    private static void addLongRefProperty(Reference ref, String propertyName, Long value) {
        if (value == null || propertyName == null) {
            return;
        }
        StringRefAddr ra = new StringRefAddr(propertyName, String.valueOf(value));
        ref.add(ra);
    }

    private static final void addBooleanProperty(Reference ref, String propertyName, boolean value) {
        if (propertyName == null) {
            return;
        }
        StringRefAddr ra = new StringRefAddr(propertyName, String.valueOf(value));
        ref.add(ra);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.createConnection(userName, password);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.createConnection(userName, password);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (username != null) {
            this.username = username;
        } else {
            this.logger.warn("Cannot set username to null (on {})", (Object)this);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        if (virtualHost != null) {
            this.virtualHost = virtualHost;
        } else {
            this.logger.warn("Cannot set virtualHost to null (on {})", (Object)this);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (host != null) {
            this.host = host;
        } else {
            this.logger.warn("Cannot set host to null (on {})", (Object)this);
        }
    }

    public int getPort() {
        return this.port != -1 ? this.port : (this.isSsl() ? 5671 : 5672);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getTerminationTimeout() {
        return this.terminationTimeout;
    }

    public void setTerminationTimeout(long terminationTimeout) {
        this.terminationTimeout = terminationTimeout;
    }

    public int getQueueBrowserReadMax() {
        return this.queueBrowserReadMax;
    }

    public void setQueueBrowserReadMax(int queueBrowserReadMax) {
        this.queueBrowserReadMax = Math.max(0, queueBrowserReadMax);
    }

    public int getOnMessageTimeoutMs() {
        return this.onMessageTimeoutMs;
    }

    public void setOnMessageTimeoutMs(int onMessageTimeoutMs) {
        if (onMessageTimeoutMs > 0) {
            this.onMessageTimeoutMs = onMessageTimeoutMs;
        } else {
            this.logger.warn("Cannot set onMessageTimeoutMs to non-positive value {} (on {})", (Object)onMessageTimeoutMs, (Object)this);
        }
    }

    public int getChannelsQos() {
        return this.channelsQos;
    }

    public void setChannelsQos(int channelsQos) {
        this.channelsQos = channelsQos;
    }

    public void setPreferProducerMessageProperty(boolean preferProducerMessageProperty) {
        this.preferProducerMessageProperty = preferProducerMessageProperty;
    }

    public boolean isPreferProducerMessageProperty() {
        return this.preferProducerMessageProperty;
    }

    public void setRequeueOnMessageListenerException(boolean requeueOnMessageListenerException) {
        this.requeueOnMessageListenerException = requeueOnMessageListenerException;
    }

    public boolean isRequeueOnMessageListenerException() {
        return this.requeueOnMessageListenerException;
    }

    public void setNackOnRollback(boolean nackOnRollback) {
        this.nackOnRollback = nackOnRollback;
    }

    public boolean isNackOnRollback() {
        return this.nackOnRollback;
    }

    public void setCleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose(boolean cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose) {
        this.cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose = cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose;
    }

    public boolean isCleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose() {
        return this.cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose;
    }

    public void setAmqpPropertiesCustomiser(BiFunction<AMQP.BasicProperties.Builder, Message, AMQP.BasicProperties.Builder> amqpPropertiesCustomiser) {
        this.amqpPropertiesCustomiser = amqpPropertiesCustomiser;
    }

    public void setHostnameVerification(boolean hostnameVerification) {
        this.hostnameVerification = hostnameVerification;
    }

    public void setMetricsCollector(MetricsCollector metricsCollector) {
        this.metricsCollector = metricsCollector;
    }

    public List<String> getUris() {
        return this.uris.stream().map(uri -> uri.toString()).collect(Collectors.toList());
    }

    public void setAmqpConnectionFactoryPostProcessor(Consumer<ConnectionFactory> amqpConnectionFactoryPostProcessor) {
        this.amqpConnectionFactoryPostProcessor = amqpConnectionFactoryPostProcessor;
    }

    public void setSendingContextConsumer(SendingContextConsumer sendingContextConsumer) {
        this.sendingContextConsumer = sendingContextConsumer;
    }

    public void setReceivingContextConsumer(ReceivingContextConsumer receivingContextConsumer) {
        this.receivingContextConsumer = receivingContextConsumer;
    }

    public void setDeclareReplyToDestination(boolean declareReplyToDestination) {
        this.declareReplyToDestination = declareReplyToDestination;
    }

    public void setReplyToStrategy(ReplyToStrategy replyToStrategy) {
        this.replyToStrategy = replyToStrategy;
    }

    public ReplyToStrategy getReplyToStrategy() {
        return this.replyToStrategy;
    }

    public void setAuthenticationMechanism(AuthenticationMechanism authenticationMechanism) {
        this.authenticationMechanism = authenticationMechanism;
    }

    public void setRequeueOnTimeout(boolean requeueOnTimeout) {
        this.requeueOnTimeout = requeueOnTimeout;
    }

    public void setKeepTextMessageType(boolean keepTextMessageType) {
        this.keepTextMessageType = keepTextMessageType;
    }

    public JMSContext createContext() {
        return this.createContext(this.username, this.password, 1);
    }

    public JMSContext createContext(String username, String password) {
        return this.createContext(username, password, 1);
    }

    public JMSContext createContext(String username, String password, int sessionMode) {
        try {
            RMQConnection connection = (RMQConnection)this.createConnection(username, password);
            return new RmqJmsContext(connection, sessionMode);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Error while creating JMSContext", e.getErrorCode(), (Throwable)e);
        }
    }

    public JMSContext createContext(int sessionMode) {
        return this.createContext(this.username, this.password, sessionMode);
    }

    private static final class NoOpSerializableReceivingContextConsumer
    implements ReceivingContextConsumer,
    Serializable {
        private static final long serialVersionUID = 1L;

        private NoOpSerializableReceivingContextConsumer() {
        }

        @Override
        public void accept(ReceivingContext receivingContext) {
        }
    }

    private static final class NoOpSerializableSendingContextConsumer
    implements SendingContextConsumer,
    Serializable {
        private static final long serialVersionUID = 1L;

        private NoOpSerializableSendingContextConsumer() {
        }

        @Override
        public void accept(SendingContext sendingContext) {
        }
    }

    private static final class NoOpSerializableConsumer<T>
    implements Consumer<T>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private NoOpSerializableConsumer() {
        }

        @Override
        public void accept(T t) {
        }
    }

    private static final class NoOpMetricsCollector
    implements MetricsCollector,
    Serializable {
        private static final long serialVersionUID = 1L;

        private NoOpMetricsCollector() {
        }

        public void newConnection(Connection connection) {
        }

        public void closeConnection(Connection connection) {
        }

        public void newChannel(Channel channel) {
        }

        public void closeChannel(Channel channel) {
        }

        public void basicPublish(Channel channel) {
        }

        public void consumedMessage(Channel channel, long deliveryTag, boolean autoAck) {
        }

        public void consumedMessage(Channel channel, long deliveryTag, String consumerTag) {
        }

        public void basicAck(Channel channel, long deliveryTag, boolean multiple) {
        }

        public void basicNack(Channel channel, long deliveryTag) {
        }

        public void basicReject(Channel channel, long deliveryTag) {
        }

        public void basicConsume(Channel channel, String consumerTag, boolean autoAck) {
        }

        public void basicCancel(Channel channel, String consumerTag) {
        }
    }

    @FunctionalInterface
    private static interface ConnectionCreator {
        public Connection create(ConnectionFactory var1) throws Exception;
    }
}

