/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.AuthenticationSteps;
import org.springframework.vault.authentication.AuthenticationStepsFactory;
import org.springframework.vault.authentication.AuthenticationUtil;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.JwtAuthenticationOptions;
import org.springframework.vault.authentication.LoginTokenUtil;
import org.springframework.vault.authentication.VaultLoginException;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

public class JwtAuthentication
implements ClientAuthentication,
AuthenticationStepsFactory {
    public static final String DEFAULT_JWT_AUTHENTICATION_PATH = "jwt";
    private static final Log logger = LogFactory.getLog(JwtAuthentication.class);
    private final JwtAuthenticationOptions options;
    private final RestOperations restOperations;

    public JwtAuthentication(JwtAuthenticationOptions options, RestOperations restOperations) {
        Assert.notNull((Object)options, (String)"JwtAuthenticationOptions must not be null");
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        this.options = options;
        this.restOperations = restOperations;
    }

    @Override
    public AuthenticationSteps getAuthenticationSteps() {
        return AuthenticationSteps.fromSupplier(this.options.getJwtSupplier()).map(token -> JwtAuthentication.getJwtLogin(this.options.getRole(), token)).login(AuthenticationUtil.getLoginPath(this.options.getPath()), new String[0]);
    }

    @Override
    public VaultToken login() throws VaultException {
        Map<String, String> login = JwtAuthentication.getJwtLogin(this.options.getRole(), this.options.getJwtSupplier().get());
        try {
            VaultResponse response = (VaultResponse)this.restOperations.postForObject(AuthenticationUtil.getLoginPath(this.options.getPath()), login, VaultResponse.class, new Object[0]);
            Assert.state((response != null && response.getAuth() != null ? 1 : 0) != 0, (String)"Auth field must not be null");
            logger.debug((Object)"Login successful using JWT authentication");
            return LoginTokenUtil.from(response.getAuth());
        }
        catch (RestClientException e) {
            throw VaultLoginException.create("JWT", e);
        }
    }

    private static Map<String, String> getJwtLogin(@Nullable String role, String jwt) {
        HashMap<String, String> login = new HashMap<String, String>(2);
        login.put(DEFAULT_JWT_AUTHENTICATION_PATH, jwt);
        if (StringUtils.hasText((String)role)) {
            login.put("role", role);
        }
        return login;
    }
}

