#
# Copyright (c) 2023. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#


from contextlib import closing

import java.util.HashMap as HashMap
from scala.jdk.javaapi import CollectionConverters
from com.xebialabs.xlrelease.plugin.platform import RemoveRevisionRequest
from com.xebialabs.xlrelease.plugin.platform.domain import RemovalReason

# "Injected" variables:

global task
global platformServer

global application  # application id
global revision
global removalReason


# We cannot import code from a common module, therefore we replicate the following
# function everywhere we need it. You are welcome.
def get_client(task):
    python_script = task.pythonScript
    return python_script.getClient()


with closing(get_client(task)) as client:
    task.setStatusLine("Loading application information...")
    app_response = client.getApplication(application)
    progression_id = app_response["progression_id"] if app_response else None
    config_id = app_response["correlation_configuration_id"] if app_response else None

    cfg_response = client.getConfiguration(config_id)
    data = HashMap(CollectionConverters.asJava(cfg_response["data"]))
    package_id = data["package_id"]

    card_response = client.listCards(progression_id, package_id, revision).results()
    if not card_response:
        raise Exception("No matching card found!")

    card = card_response[0]
    package_id = data["package_id"]

    task.setStatusLine("Removing revision...")
    removal_reason = RemovalReason.getRemovalReasonOf(str(removalReason))

    resp = client.removeRevision(card["id"], revision, RemoveRevisionRequest(removal_reason))

    task.setStatusLine("Revision {} removed for application {}.".format(revision, application))
