(self["webpackChunkxlrelease"] = self["webpackChunkxlrelease"] || []).push([[540],{

/***/ 72207:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.DateRange = exports.CompositeFilter = void 0;
var _angular2react = __webpack_require__(40958);
var _lazyInjector = __webpack_require__(89243);
var _dateRangeComponent = __webpack_require__(77078);
var _compositeFilterComponent = __webpack_require__(95854);
var DateRange = exports.DateRange = (0, _angular2react.angular2react)('xlrDateRange', _dateRangeComponent.TileDateRange, _lazyInjector.lazyInjector.$injector);
var CompositeFilter = exports.CompositeFilter = (0, _angular2react.angular2react)('compositeFilter', _compositeFilterComponent.compositeFilterComponent, _lazyInjector.lazyInjector.$injector);

/***/ }),

/***/ 6471:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.loadUsernames = loadUsernames;
var _http = __webpack_require__(26511);
function loadUsernames(release) {
  return (0, _http.httpGET)('users/names').then(function (resp) {
    return resp.data;
  });
}

/***/ }),

/***/ 52067:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ReleaseStatus = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _classnames = _interopRequireDefault(__webpack_require__(94184));
var _releaseStatus = __webpack_require__(55585);
__webpack_require__(79625);
var ReleaseStatus = exports.ReleaseStatus = function ReleaseStatus(_ref) {
  var status = _ref.status;
  var _calculateReleaseStat = (0, _releaseStatus.calculateReleaseStatusColor)(status),
    border = _calculateReleaseStat.border,
    background = _calculateReleaseStat.background;
  return /*#__PURE__*/_react.default.createElement(_dotComponents.DotPill, {
    backgroundcolor: background,
    bordercolor: border,
    className: "release-status",
    icon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      className: (0, _classnames.default)('status-icon', status.toLowerCase()),
      iconId: (0, _releaseStatus.calculateReleaseStatusIcon)(status)
    }),
    label: (0, _releaseStatus.formatReleaseStatusText)(status),
    size: "small",
    variant: "outlined"
  });
};

/***/ }),

/***/ 55585:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.formatReleaseStatusText = exports.calculateReleaseStatusIcon = exports.calculateReleaseStatusColor = void 0;
var _capitalize = _interopRequireDefault(__webpack_require__(48403));
var _colors = _interopRequireDefault(__webpack_require__(70925));
var calculateReleaseStatusColor = exports.calculateReleaseStatusColor = function calculateReleaseStatusColor(status) {
  switch (status) {
    case 'TEMPLATE':
    case 'PLANNED':
    case 'ABORTED':
      return {
        background: _colors.default.background,
        border: _colors.default.lightgray
      };
    case 'PAUSED':
    case 'IN_PROGRESS':
      return {
        background: _colors.default.backgroundBlue,
        border: _colors.default.blue
      };
    case 'FAILING':
      return {
        background: _colors.default.warningBackground,
        border: _colors.default.orange
      };
    case 'FAILED':
      return {
        background: _colors.default.errorBackground,
        border: _colors.default.red
      };
    case 'COMPLETED':
      return {
        background: _colors.default.successBackground,
        border: _colors.default.green
      };
    default:
      return {
        background: _colors.default.background,
        border: _colors.default.lightgray
      };
  }
};
var calculateReleaseStatusIcon = exports.calculateReleaseStatusIcon = function calculateReleaseStatusIcon(status) {
  switch (status) {
    case 'TEMPLATE':
      return 'template';
    case 'PLANNED':
    case 'PAUSED':
      return 'circle-paused';
    case 'IN_PROGRESS':
      return 'progress';
    case 'FAILING':
      return 'warning-solid';
    case 'FAILED':
    case 'ABORTED':
      return 'error-solid';
    case 'COMPLETED':
      return 'check-solid';
    default:
      return '';
  }
};
var formatReleaseStatusText = exports.formatReleaseStatusText = function formatReleaseStatusText(status) {
  // capitalize first letter and remove underscores
  return (0, _capitalize.default)(status).replace('_', ' ');
};

/***/ }),

/***/ 92010:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.InputWithJythonEditor = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _jythonCodeEditor = __webpack_require__(13066);
var _task = __webpack_require__(96831);
var InputWithJythonEditor = exports.InputWithJythonEditor = function InputWithJythonEditor(_ref) {
  var _task$inputProperties;
  var disabled = _ref.disabled,
    _onChange = _ref.onChange,
    property = _ref.property,
    release = _ref.release,
    task = _ref.task;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "input-with-jython-editor"
  }, /*#__PURE__*/_react.default.createElement(_jythonCodeEditor.JythonCodeEditor, {
    disabled: disabled,
    onChange: function onChange(e) {
      return _onChange(e);
    },
    script: task !== null && task !== void 0 && (_task$inputProperties = task.inputProperties) !== null && _task$inputProperties !== void 0 && _task$inputProperties[property.name] ? (0, _task.getPropertyFromInputProperties)(task, property.name) : '',
    title: property.label,
    variables: release.variables
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    className: "script-description",
    variant: "body2"
  }, property.description));
};

/***/ }),

/***/ 70110:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.DurationPicker = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireDefault(__webpack_require__(87363));
var _functor = _interopRequireDefault(__webpack_require__(28217));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _pluralize = _interopRequireDefault(__webpack_require__(23450));
var _colors = _interopRequireDefault(__webpack_require__(70925));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var inputNames = ['months', 'days', 'hours'];
var DurationPicker = exports.DurationPicker = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(DurationPicker, _React$Component);
  var _super = _createSuper(DurationPicker);
  function DurationPicker(props) {
    var _this;
    (0, _classCallCheck2.default)(this, DurationPicker);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnBlur", function (e) {
      if (!(e.relatedTarget !== null && inputNames.includes(e.relatedTarget.name) || document.activeElement !== null && inputNames.includes(document.activeElement.name))) {
        _this.switchMode(e, true);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleKeyDown", function (e) {
      if (e.key === 'Escape') {
        _this.switchMode(e);
      }
      if (e.key === 'Enter') {
        _this.switchMode(e, true);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleEnter", function (e) {
      if (e.key === 'Enter') {
        _this.switchMode(e);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "editMode", function () {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "duration-editor",
        style: styles.editStyle
      }, /*#__PURE__*/_react.default.createElement("input", {
        autoFocus: true,
        name: "months",
        onBlur: _this.handleOnBlur,
        onChange: _this.onChange,
        onKeyDown: _this.handleKeyDown,
        style: styles.inputStyle,
        type: "text",
        value: _this.state.months
      }), /*#__PURE__*/_react.default.createElement("label", {
        style: styles.labelStyle
      }, "months"), /*#__PURE__*/_react.default.createElement("input", {
        name: "days",
        onBlur: _this.handleOnBlur,
        onChange: _this.onChange,
        onKeyDown: _this.handleKeyDown,
        style: styles.inputStyle,
        type: "text",
        value: _this.state.days
      }), /*#__PURE__*/_react.default.createElement("label", {
        style: styles.labelStyle
      }, "days"), /*#__PURE__*/_react.default.createElement("input", {
        name: "hours",
        onBlur: _this.handleOnBlur,
        onChange: _this.onChange,
        onKeyDown: _this.handleKeyDown,
        style: styles.inputStyle,
        type: "text",
        value: _this.state.hours
      }), /*#__PURE__*/_react.default.createElement("label", {
        style: styles.labelStyle
      }, "hours"));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "validateMinimum", function (name, value, min) {
      var measures = ['days', 'hours', 'months'];
      measures.splice(measures.indexOf(name), 1);
      var found = measures.find(function (m) {
        var val = _this.state[m];
        return val > 0 && val >= min[m];
      });
      return value > 0 && value >= min[name] || !!found;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onChange", function (evt) {
      var minHours = _this.props.minHours;
      var target = evt.target;
      var name = target.name;
      var value = target.value;
      var isMoreThanMin = value >= 0;
      if (minHours) {
        isMoreThanMin = _this.validateMinimum(name, value, mapHoursToValues(minHours));
      }
      if (isNumeric(value) && isMoreThanMin && value <= 99) {
        _this.setState((0, _defineProperty2.default)({}, name, Math.max(0, value)));
      } else if (value === '') {
        _this.setState((0, _defineProperty2.default)({}, name, ''));
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "switchMode", function (evt) {
      var set = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var _this$props = _this.props,
        onModelChange = _this$props.onModelChange,
        onPristinityChange = _this$props.onPristinityChange;
      var flag = !_this.state.editMode;
      if (set) {
        var _extractValues = extractValues(_this.state),
          months = _extractValues.months,
          days = _extractValues.days,
          hours = _extractValues.hours;
        var rs = evaluateDuration(months, days, hours);
        onModelChange(rs);
        if (onPristinityChange) {
          onPristinityChange(rs === _this.state.originalValue);
        }
        _this.setState({
          editMode: flag
        });
      } else {
        var _mapHoursToValues = mapHoursToValues(_this.state.originalValue),
          _months = _mapHoursToValues.months,
          _days = _mapHoursToValues.days,
          _hours = _mapHoursToValues.hours;
        _this.setState({
          months: _months,
          days: _days,
          hours: _hours,
          editMode: flag
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "viewMode", function () {
      var _extractValues2 = extractValues(_this.state),
        months = _extractValues2.months,
        days = _extractValues2.days,
        hours = _extractValues2.hours;
      if (!months && !days && !hours) {
        var originals = mapHoursToValues(_this.state.originalValue);
        months = originals.months;
        days = originals.days;
        hours = originals.hours;
      }
      var view = new _functor.default('').map(function (s) {
        return appendString(s, months, (0, _pluralize.default)('month', months));
      }).map(function (s) {
        return appendString(s, days, (0, _pluralize.default)('day', days));
      }).map(function (s) {
        return appendString(s, hours, (0, _pluralize.default)('hour', hours));
      }).map(function (s) {
        return _this.props.tip ? "".concat(s, " ").concat(_this.props.tip) : s;
      }).map(function (s) {
        return s === '' ? _this.props.placeholder || 'Placeholder' : s;
      }).identity();
      return !_this.props.disabled ? /*#__PURE__*/_react.default.createElement("input", {
        onClick: _this.switchMode,
        onKeyDown: _this.handleEnter,
        readOnly: true,
        style: styles.viewStyle,
        value: view
      }) : /*#__PURE__*/_react.default.createElement("input", {
        readOnly: true,
        style: styles.viewDisabledStyle,
        value: view
      });
    });
    _this.state = {};
    return _this;
  }
  (0, _createClass2.default)(DurationPicker, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        description = _this$props2.description,
        disabled = _this$props2.disabled,
        label = _this$props2.label;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "xl-react-components"
      }, label && /*#__PURE__*/_react.default.createElement("div", {
        className: "xl-react-components-label"
      }, label), /*#__PURE__*/_react.default.createElement("div", {
        className: "xl-react-components-input ".concat(disabled && 'is-disabled')
      }, this.state.editMode ? this.editMode() : this.viewMode(), /*#__PURE__*/_react.default.createElement("div", {
        className: "xl-react-components-description"
      }, /*#__PURE__*/_react.default.createElement("div", null, description))));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (props.hours !== state.originalValue) {
        var _mapHoursToValues2 = mapHoursToValues(props.hours),
          months = _mapHoursToValues2.months,
          days = _mapHoursToValues2.days,
          hours = _mapHoursToValues2.hours;
        return {
          originalValue: Number(props.hours),
          months: months,
          days: days,
          hours: hours,
          editMode: false
        };
      }
      return null;
    }
  }]);
  return DurationPicker;
}(_react.default.Component);
(0, _defineProperty2.default)(DurationPicker, "propTypes", {
  description: _propTypes.default.string,
  disabled: _propTypes.default.bool.isRequired,
  hours: _propTypes.default.number.isRequired,
  label: _propTypes.default.string,
  minHours: _propTypes.default.number,
  onModelChange: _propTypes.default.func.isRequired,
  onPristinityChange: _propTypes.default.func,
  placeholder: _propTypes.default.string,
  tip: _propTypes.default.string
});
function extractValues(state) {
  var months = state.months,
    days = state.days,
    hours = state.hours;
  return {
    months: defaultVal(months),
    days: defaultVal(days),
    hours: defaultVal(hours)
  };
}
function defaultVal(val) {
  return isNumeric(val) ? val : 0;
}
function isNumeric(n) {
  return !isNaN(parseFloat(n)) && isFinite(n);
}
function mapHoursToValues(hours) {
  var m = Math.floor(hours / 720);
  var remainder = hours - m * 720;
  var d = Math.floor(remainder / 24);
  var h = hours - m * 720 - d * 24;
  return {
    months: m,
    days: d,
    hours: h
  };
}
function evaluateDuration(months, days, hours) {
  return months * 720 + days * 24 + hours;
}
function appendString(str, value, marker) {
  return value !== 0 ? "".concat(str, " ").concat(value, " ").concat(marker) : str;
}
var styles = {
  editStyle: {
    display: 'flex',
    flexDirection: 'row',
    flexWrap: 'nowrap',
    alignItems: 'center'
  },
  viewDisabledStyle: {
    backgroundColor: _colors.default.background,
    borderWidth: 1,
    borderStyle: 'solid',
    borderColor: _colors.default.lightgray,
    borderRadius: 4,
    minHeight: 30,
    display: 'flex',
    alignItems: 'center',
    paddingLeft: 10,
    color: _colors.default.gray,
    fontSize: 12,
    width: '100%'
  },
  viewStyle: {
    borderWidth: 1,
    borderStyle: 'solid',
    borderColor: _colors.default.gray,
    borderRadius: 4,
    minHeight: 30,
    display: 'flex',
    alignItems: 'center',
    paddingLeft: 10,
    color: _colors.default.gray,
    fontSize: 12,
    width: '100%'
  },
  labelStyle: {
    fontSize: 11,
    cursor: 'default',
    marginBottom: 0
  },
  inputStyle: {
    marginLeft: 5,
    marginRight: 5,
    marginBottom: 0,
    minHeight: 30,
    minWidth: 40,
    width: 40,
    borderRadius: 4
  },
  buttonStyle: {
    marginLeft: 5,
    marginRight: 5,
    marginBottom: 0,
    marginTop: 0,
    minHeight: 30,
    minWidth: 50,
    width: 50,
    borderRadius: 4,
    fontSize: 11
  }
};

/***/ }),

/***/ 28217:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var Functor = exports["default"] = /*#__PURE__*/(0, _createClass2.default)(function Functor(v) {
  var _this = this;
  (0, _classCallCheck2.default)(this, Functor);
  (0, _defineProperty2.default)(this, "map", function (fn) {
    return new Functor(fn(_this.v));
  });
  (0, _defineProperty2.default)(this, "identity", function () {
    return _this.v;
  });
  this.v = v;
});

/***/ }),

/***/ 49923:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _activityLogsListController = _interopRequireDefault(__webpack_require__(99276));
var _releaseActivityLogsController = _interopRequireDefault(__webpack_require__(45695));
var _releaseActivityLogs = _interopRequireDefault(__webpack_require__(57805));
var _activityLogsList = _interopRequireDefault(__webpack_require__(69809));
var _activityLogsModal = __webpack_require__(55604);
var _activityLogsMessage = __webpack_require__(22602);
angular.module('xlrelease.activityLogs', ['xlrelease', 'ui.router']).component('activityDetailsModal', _activityLogsModal.ActivityLogsModalComponent).component('activityLogMessage', _activityLogsMessage.ActivityLogMessageComponent).controller('releaseActivityLogsController', _releaseActivityLogsController.default).component('activityLogsList', {
  bindings: {
    filters: '<',
    containerId: '<'
  },
  controller: _activityLogsListController.default,
  template: _activityLogsList.default
}).config(['$stateProvider', function ($stateProvider) {
  $stateProvider.state('releaseLogs', {
    url: '/releases/:releaseId/logs',
    reloadOnSearch: false,
    template: _releaseActivityLogs.default,
    controller: 'releaseActivityLogsController',
    controllerAs: '$ctrl',
    resolve: {
      filterSettings: ['$stateParams', 'Filters', function ($stateParams, Filters) {
        return Filters.getLogsFiltersSettings($stateParams.releaseId);
      }],
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  }).state('templateLogs', {
    url: '/{p:templates|workflows}/:releaseId/logs',
    reloadOnSearch: false,
    template: _releaseActivityLogs.default,
    controller: 'releaseActivityLogsController',
    controllerAs: '$ctrl',
    resolve: {
      filterSettings: ['$stateParams', 'Filters', function ($stateParams, Filters) {
        return Filters.getLogsFiltersSettings($stateParams.releaseId);
      }],
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }]
    }
  });
}]);

/***/ }),

/***/ 99276:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _size = _interopRequireDefault(__webpack_require__(84238));
var _clone = _interopRequireDefault(__webpack_require__(66678));
var _isEqual = _interopRequireDefault(__webpack_require__(18446));
var _concat = _interopRequireDefault(__webpack_require__(57043));
var ITEMS_PER_PAGE = 30;
var ActivityLogsListController = exports["default"] = /*#__PURE__*/function () {
  function ActivityLogsListController($rootScope, $uibModal, Backend, CurrentTimeZone, Events, ClientSettings) {
    (0, _classCallCheck2.default)(this, ActivityLogsListController);
    this._Backend = Backend;
    this._Events = Events;
    this._ClientSettings = ClientSettings;
    this._$rootScope = $rootScope;
    this._$uibModal = $uibModal;
    this.timeZone = CurrentTimeZone.timeZone;

    // pagination
    this.hasMoreLogs = false;
    this.isLoading = false;
    this.page = 0;
  }
  (0, _createClass2.default)(ActivityLogsListController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;
      this.loadLogs();
      this.destroyFilterChangedListener = this._$rootScope.$on(this._Events.filters.filterChanged, function (e, filters) {
        _this.loadLogs();
        _this._ClientSettings.setLogsFilters(_this.containerId, filters);
      });
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.destroyFilterChangedListener();
    }
  }, {
    key: "loadLogs",
    value: function loadLogs() {
      var _this2 = this;
      this.page = !(0, _isEqual.default)(this.filters, this.lastFilters) ? 0 : this.page + 1;
      this.isLoading = true;
      this._Backend.post("activity/".concat(this.containerId, "/logs/search?page=").concat(this.page, "&resultsPerPage=").concat(ITEMS_PER_PAGE), this.filters).then(function (resp) {
        if (_this2.page === 0) {
          _this2.logs = resp.data;
        } else {
          _this2.logs = (0, _concat.default)(_this2.logs, resp.data);
        }
        _this2.hasMoreLogs = (0, _size.default)(resp.data) >= ITEMS_PER_PAGE;
      }).finally(function () {
        _this2.isLoading = false;
        _this2.lastFilters = (0, _clone.default)(_this2.filters);
      });
    }
  }, {
    key: "viewData",
    value: function viewData(dataId) {
      var _this3 = this;
      this._Backend.get("activity/data/".concat(dataId)).then(function (resp) {
        _this3._$uibModal.open({
          animation: false,
          resolve: {
            activityDetailsResponse: function activityDetailsResponse() {
              return resp;
            }
          },
          component: 'activityDetailsModal',
          size: 'lg'
        });
      });
    }
  }, {
    key: "loadMore",
    value: function loadMore() {
      this.loadLogs();
    }
  }]);
  return ActivityLogsListController;
}();
(0, _defineProperty2.default)(ActivityLogsListController, "$inject", ['$rootScope', '$uibModal', 'Backend', 'CurrentTimeZone', 'Events', 'ClientSettings']);

/***/ }),

/***/ 22602:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ActivityLogMessageComponent = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var template = "\n    <span ng-bind-html=\"!showMore && $ctrl.isLimited ? $ctrl.limitedText : $ctrl.fullText\"></span>       \n    <span ng-show=\"$ctrl.isLimited && !showMore\" class=\"link\" ng-click=\"showMore = true\">More</span>  \n    <span ng-show=\"$ctrl.isLimited && showMore\" class=\"link\" ng-click=\"showMore = false\">Hide</span>\n";
var ActivityLogMessageController = /*#__PURE__*/function () {
  function ActivityLogMessageController() {
    var _this = this;
    (0, _classCallCheck2.default)(this, ActivityLogMessageController);
    (0, _defineProperty2.default)(this, "formatMessage", function () {
      var textWithoutTags = String(_this.message).replace(/</g, '&lt;');
      _this.fullText = textWithoutTags.replace(/\[(.+?)\]\((\#\/(templates|releases)\/((Folder\w{32}-)+|((FolderSamplesAndTutorials-(Folder\w{32}-)*)))Release\w{32})\)/gm, '<a href="$2">$1</a>');
      var characters = _this.fullText.split(/(?=[^>]*(?:<|$))/gm);
      if (_this.limitTo === 0 || _.size(characters) <= _this.limitTo) {
        return;
      }
      _this.isLimited = true;
      if (_.includes(_.nth(characters, _this.limitTo), '<a href')) {
        _this.limitedText = _.join(_.slice(characters, 0, _this.limitTo), '').concat('...');
      } else {
        var result = _.join(_.slice(characters, 0, _this.limitTo + 1), '');
        var overflowedCharacters = _.slice(characters, _this.limitTo + 1);
        var isLinkTagOpen = _.find(overflowedCharacters, function (character) {
          return character.includes('<a href') || character === '</a>';
        }) === '</a>';
        if (isLinkTagOpen) {
          result = result.concat('</a>');
        }
        _this.limitedText = result.concat('...');
      }
    });
    this.limitTo = 0;
    this.isLimited = false;
    this.fullText = '';
    this.limitedText = '';
  }
  (0, _createClass2.default)(ActivityLogMessageController, [{
    key: "$onInit",
    value: function $onInit() {
      this.limitTo = this.limit;
      this.formatMessage();
    }
  }]);
  return ActivityLogMessageController;
}();
var ActivityLogMessageComponent = exports.ActivityLogMessageComponent = {
  bindings: {
    message: '<',
    limit: '<'
  },
  controller: ActivityLogMessageController,
  template: template
};

/***/ }),

/***/ 55604:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ActivityLogsModalComponent = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var template = "\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" data-ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"></i></button>\n        <h5 class=\"modal-title\">Event details</h5>\n    </div>\n    <div class=\"modal-body\">\n        <div data-ng-if=\"$ctrl.activityDetails\" >\n            <div class=\"mbm\">The HTTP request that attempted to execute the trigger:</div>\n            <pre style=\"margin: 0; max-height: 465px;\">{{$ctrl.activityDetails | json}}</pre>\n        </div>\n        <div class=\"help-block-component help-message-container\" data-ng-if=\"!$ctrl.activityDetails\">The logged event has been removed from the system. To retain more events, consider increasing the Request Retention limit of the associated HTTP Endpoint for Webhooks.</div>\n    </div>\n    <div class=\"modal-footer\">\n        <div class=\"button cancel\" data-ng-click=\"$ctrl.dismiss()\">Close</div>\n    </div>\n";
var ActivityLogsModalController = /*#__PURE__*/function () {
  function ActivityLogsModalController() {
    (0, _classCallCheck2.default)(this, ActivityLogsModalController);
  }
  (0, _createClass2.default)(ActivityLogsModalController, [{
    key: "$onInit",
    value: function $onInit() {
      var resp = this.resolve.activityDetailsResponse;
      if (resp.status !== 204) {
        this.activityDetails = resp.data;
        this.activityDetails.content = angular.fromJson(this.activityDetails.content);
      }
    }
  }]);
  return ActivityLogsModalController;
}();
ActivityLogsModalController.$inject = [];
var ActivityLogsModalComponent = exports.ActivityLogsModalComponent = {
  bindings: {
    resolve: '<',
    dismiss: '&'
  },
  controller: ActivityLogsModalController,
  template: template
};

/***/ }),

/***/ 45695:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var ReleaseActivityLogsController = exports["default"] = /*#__PURE__*/(0, _createClass2.default)(function ReleaseActivityLogsController($scope, $stateParams, filterSettings, releasePromise) {
  (0, _classCallCheck2.default)(this, ReleaseActivityLogsController);
  this._$scope = $scope;
  this._$scope.containerId = $stateParams.releaseId;
  this._$scope.release = releasePromise.data;
  this._$scope.filters = filterSettings;
  this._$scope.activityFilters = [{
    id: 'display-important',
    model: 'important',
    label: 'Important'
  }, {
    id: 'display-lifecycle',
    model: 'lifecycle',
    label: 'Release life cycle'
  }, {
    id: 'display-release_edit',
    model: 'releaseEdit',
    label: 'Release edits'
  }, {
    id: 'display-task_edit',
    model: 'taskEdit',
    label: 'Task edits'
  }, {
    id: 'display-reassign',
    model: 'reassign',
    label: 'Task assignment'
  }, {
    id: 'display-record_edit',
    model: 'reportingRecordEdit',
    label: 'Record edits'
  }, {
    id: 'display-comments',
    model: 'comments',
    label: 'Comments'
  }, {
    id: 'display-security',
    model: 'security',
    label: 'Security'
  }, {
    id: 'display-other',
    model: 'other',
    label: 'Other'
  }];
});
(0, _defineProperty2.default)(ReleaseActivityLogsController, "$inject", ['$scope', '$stateParams', 'filterSettings', 'releasePromise']);

/***/ }),

/***/ 98440:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


__webpack_require__(61698);
__webpack_require__(49923);

/***/ }),

/***/ 45801:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _permissionsConstants = __webpack_require__(88169);
angular.module('xlrelease.analytics', ['ui.router']).config(['$stateProvider', function ($stateProvider) {
  $stateProvider.state('analytics', {
    url: '/analytics',
    template: '<analytics-page filters="$resolve.filters"></analytics-page>',
    permissions: [_permissionsConstants.GlobalPermissions.VIEW_REPORTS, _permissionsConstants.GlobalPermissions.AUDIT_ALL],
    resolve: {
      filters: ['Filters', function (Filters) {
        return Filters.getAnalyticsFilterSettings();
      }]
    }
  });
  $stateProvider.state('analyticsDetail', {
    url: '/analytics/:dashboardId',
    template: '<analytics-dashboard-page data-dashboard-id="$resolve.dashboardId"></analytics-dashboard-page>',
    permissions: [_permissionsConstants.GlobalPermissions.VIEW_REPORTS, _permissionsConstants.GlobalPermissions.AUDIT_ALL],
    resolve: {
      dashboardId: ['$stateParams', function ($stateParams) {
        return $stateParams.dashboardId;
      }]
    }
  });
  $stateProvider.state('folders.detail.analytics', {
    url: '/analytics/:dashboardId',
    template: '<analytics-dashboard-page data-dashboard-id="$resolve.dashboardId" data-folder="$resolve.folder"></analytics-dashboard-page>',
    resolve: {
      dashboardId: ['$stateParams', function ($stateParams) {
        return $stateParams.dashboardId;
      }]
    },
    params: {
      page: 'analytics'
    }
  });
}]);

/***/ }),

/***/ 26310:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.NOT_CONFIGURED_TOOLTIP = exports.AnalyticsCard = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _chipGroup = __webpack_require__(93523);
var _contextMenu = __webpack_require__(40742);
var _menuItem = __webpack_require__(48447);
var _types = __webpack_require__(3713);
var _helpers = __webpack_require__(97959);
__webpack_require__(47072);
var NOT_CONFIGURED_TOOLTIP = exports.NOT_CONFIGURED_TOOLTIP = 'To use this functionality, please configure Digital.ai Analytics connection first.';
var CARD_CONTEXT_MENU_OPTIONS = [{
  children: /*#__PURE__*/_react.default.createElement(_menuItem.MenuItem, {
    endIconId: "open-new-tab",
    iconId: "edit",
    label: "Edit"
  }),
  key: _types.CardContextMenuItemKey.Edit
}, {
  children: /*#__PURE__*/_react.default.createElement(_menuItem.MenuItem, {
    iconId: "share",
    label: "Share"
  }),
  key: _types.CardContextMenuItemKey.Share
}, {
  children: /*#__PURE__*/_react.default.createElement(_menuItem.MenuItem, {
    iconId: "download",
    label: "Export"
  }),
  key: _types.CardContextMenuItemKey.Export
}];
var AnalyticsCard = exports.AnalyticsCard = function AnalyticsCard(_ref) {
  var contentText = _ref.contentText,
    id = _ref.id,
    imageSrc = _ref.imageSrc,
    isAnalyticsConfigured = _ref.isAnalyticsConfigured,
    isFavorite = _ref.isFavorite,
    onContextMenuItemClick = _ref.onContextMenuItemClick,
    onFavoriteClick = _ref.onFavoriteClick,
    onOpenDashboardClick = _ref.onOpenDashboardClick,
    subtitle = _ref.subtitle,
    tags = _ref.tags,
    title = _ref.title;
  return /*#__PURE__*/_react.default.createElement(_dotComponents.DotCard, {
    className: "analytics-card",
    key: id
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotCardHeader, {
    action: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
      "data-testid": "favorite-button",
      disabled: !isAnalyticsConfigured,
      iconId: (0, _helpers.getFavouriteIcon)(isFavorite),
      onClick: onFavoriteClick,
      tooltip: isAnalyticsConfigured ? (0, _helpers.getFavouriteText)(isFavorite) : NOT_CONFIGURED_TOOLTIP
    }), /*#__PURE__*/_react.default.createElement(_contextMenu.ContextMenu, {
      disabled: !isAnalyticsConfigured,
      menuItems: CARD_CONTEXT_MENU_OPTIONS,
      onSelect: function onSelect(key) {
        return onContextMenuItemClick(key);
      },
      tooltip: isAnalyticsConfigured ? '' : NOT_CONFIGURED_TOOLTIP
    })),
    className: "card-header",
    subheader: "by ".concat(subtitle || 'Digital.ai'),
    title: title,
    titleSize: "medium"
  }), /*#__PURE__*/_react.default.createElement("img", {
    alt: "Analytics card image",
    src: imageSrc || 'static/24.1.10/include/analytics-dashboard/assets/custom.svg'
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotCardContent, {
    className: "card-content"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    className: "card-content-description",
    "data-testid": "content-typography",
    variant: "body1"
  }, contentText), /*#__PURE__*/_react.default.createElement(_chipGroup.ChipGroup, {
    labels: tags
  })), /*#__PURE__*/_react.default.createElement(_dotComponents.DotCardFooter, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    className: "open-dashboard-btn",
    "data-testid": isAnalyticsConfigured ? '' : 'open-analytics-dashboard-btn',
    onClick: onOpenDashboardClick,
    type: "outlined"
  }, "Open dashboard")));
};

/***/ }),

/***/ 19183:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AnalyticsCards = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(67154));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _analyticsCard = __webpack_require__(26310);
var _helper = __webpack_require__(79802);
var _helpers = __webpack_require__(97959);
__webpack_require__(10120);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var analyticsDefaultEmptyStateImg = 'static/24.1.10/styles/img/astronaut_rafiki.svg';
var analyticsConfiguredEmptyStateImg = 'static/24.1.10/styles/img/data_analysis.svg';
var AnalyticsCards = exports.AnalyticsCards = function AnalyticsCards(_ref) {
  var cards = _ref.cards,
    folderId = _ref.folderId,
    isAnalyticsConfigured = _ref.isAnalyticsConfigured,
    isFavouritePage = _ref.isFavouritePage,
    isSearchOrFilterApplied = _ref.isSearchOrFilterApplied,
    profileFavouriteDashboards = _ref.profileFavouriteDashboards;
  var _useState = (0, _react.useState)([]),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    currentAnalyticsCards = _useState2[0],
    setCurrentAnalyticsCards = _useState2[1];
  (0, _react.useEffect)(function () {
    setCurrentAnalyticsCards(cards);
  }, [cards]);
  var handleContextMenuItemClick = function handleContextMenuItemClick(_key) {
    // TODO
  };
  var handleFavoriteClick = function handleFavoriteClick(_id) {
    return function () {
      // TODO
    };
  };
  var handleOpenDashboardClick = function handleOpenDashboardClick(id) {
    return function () {
      if (isAnalyticsConfigured) {
        var analyticsUrl = "analytics/".concat(id);
        if (folderId) {
          window.location.href = "#/folders/".concat(folderId, "/").concat(analyticsUrl);
        } else {
          window.location.href = "#/".concat(analyticsUrl);
        }
      } else {
        // pendo guide will be open
      }
    };
  };
  var renderEmptyState = function renderEmptyState() {
    var emptyStateClassName = 'analytics-empty-state';
    var emptyStateTitleAndSubtitle = (0, _helpers.calculateTitleAndSubtitleForEmptyState)(isFavouritePage, isAnalyticsConfigured);
    var emptyStateButtonProps = isAnalyticsConfigured && !isFavouritePage ? {
      children: 'Manage dashboards',
      endIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
        iconId: "open-new-tab"
      })
    } : undefined;
    var emptyStateImage = isAnalyticsConfigured && !isFavouritePage ? analyticsConfiguredEmptyStateImg : analyticsDefaultEmptyStateImg;
    return isSearchOrFilterApplied ? /*#__PURE__*/_react.default.createElement(_dotComponents.DotEmptyFilterState, {
      className: emptyStateClassName
    }) : /*#__PURE__*/_react.default.createElement(_dotComponents.DotEmptyState, {
      buttonProps: emptyStateButtonProps,
      className: emptyStateClassName,
      imageAltText: "analytics dashboards empty state image",
      imageSrc: emptyStateImage,
      subtitle: emptyStateTitleAndSubtitle.subtitle,
      title: emptyStateTitleAndSubtitle.title
    });
  };
  var renderCards = function renderCards() {
    return currentAnalyticsCards.length > 0 ? /*#__PURE__*/_react.default.createElement(_dotComponents.CssGrid, {
      className: "css-grid"
    }, currentAnalyticsCards.map(function (currentAnalyticsCard, index) {
      return /*#__PURE__*/_react.default.createElement(_dotComponents.CssCell, (0, _extends2.default)({}, (0, _helper.calculateCellProps)(index), {
        key: currentAnalyticsCard.id
      }), /*#__PURE__*/_react.default.createElement(_analyticsCard.AnalyticsCard, (0, _extends2.default)({}, currentAnalyticsCard, {
        isAnalyticsConfigured: isAnalyticsConfigured,
        isFavorite: (0, _helpers.isFavouriteCard)(profileFavouriteDashboards, currentAnalyticsCard.id),
        onContextMenuItemClick: handleContextMenuItemClick,
        onFavoriteClick: handleFavoriteClick(currentAnalyticsCard.id),
        onOpenDashboardClick: handleOpenDashboardClick(currentAnalyticsCard.id)
      })));
    })) : renderEmptyState();
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "analytics-cards"
  }, renderCards());
};

/***/ }),

/***/ 31372:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AnalyticsCardsSkeleton = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(67154));
var _react = _interopRequireDefault(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _helper = __webpack_require__(79802);
var AnalyticsCardsSkeleton = exports.AnalyticsCardsSkeleton = function AnalyticsCardsSkeleton() {
  var renderCardSkeleton = function renderCardSkeleton() {
    return /*#__PURE__*/_react.default.createElement(_dotComponents.DotCard, {
      className: "analytics-card"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotCardContent, {
      className: "card-content"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotSkeleton, {
      height: "20px",
      variant: "text",
      width: "100%"
    }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotSkeleton, {
      height: "100px",
      variant: "rectangular",
      width: "100%"
    }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotSkeleton, {
      height: "20px",
      variant: "text",
      width: "100%"
    }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotSkeleton, {
      height: "20px",
      variant: "text",
      width: "100%"
    })), /*#__PURE__*/_react.default.createElement(_dotComponents.DotCardFooter, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotSkeleton, {
      height: "40px",
      variant: "rectangular",
      width: "100px"
    })));
  };
  var renderCards = function renderCards() {
    return /*#__PURE__*/_react.default.createElement(_dotComponents.CssGrid, {
      className: "css-grid"
    }, [0, 1, 2, 3, 4, 5].map(function (_i, index) {
      return /*#__PURE__*/_react.default.createElement(_dotComponents.CssCell, (0, _extends2.default)({}, (0, _helper.calculateCellProps)(index), {
        key: index
      }), renderCardSkeleton());
    }));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "analytics-cards"
  }, renderCards());
};

/***/ }),

/***/ 69683:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AnalyticsPageFilterDrawer = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(67154));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(319));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireDefault(__webpack_require__(87363));
var _noop = _interopRequireDefault(__webpack_require__(50308));
var _dotComponents = __webpack_require__(92140);
var _avatarWithName = __webpack_require__(7305);
var _helpers = __webpack_require__(97959);
__webpack_require__(68806);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var AnalyticsPageFilterDrawer = exports.AnalyticsPageFilterDrawer = function AnalyticsPageFilterDrawer(_ref) {
  var authors = _ref.authors,
    cardSearch = _ref.cardSearch,
    categories = _ref.categories,
    isDrawerOpened = _ref.isDrawerOpened,
    numberOfFiltersApplied = _ref.numberOfFiltersApplied,
    onCardFilter = _ref.onCardFilter,
    onClearAll = _ref.onClearAll,
    onDrawerClose = _ref.onDrawerClose;
  var renderCategoryCheckboxes = function renderCategoryCheckboxes() {
    return categories.map(function (category) {
      var filterCategories = (cardSearch === null || cardSearch === void 0 ? void 0 : cardSearch.categories) || [];
      var isInFilters = filterCategories.some(function (filterCategory) {
        return filterCategory === category;
      });
      return /*#__PURE__*/_react.default.createElement(_dotComponents.DotCheckbox, {
        checked: isInFilters,
        key: category,
        label: category,
        onChange: function onChange(e) {
          var isChecked = e.target.checked;
          onCardFilter(_objectSpread(_objectSpread({}, cardSearch), {}, {
            categories: isChecked ? [].concat((0, _toConsumableArray2.default)(filterCategories), [category]) : filterCategories.filter(function (currentCategory) {
              return currentCategory !== category;
            })
          }));
        }
      });
    });
  };
  var renderAuthorAutocomplete = function renderAuthorAutocomplete() {
    var authorsSearched = (cardSearch === null || cardSearch === void 0 ? void 0 : cardSearch.authorNames) || [];
    var authorsOptions = authors.map(function (name) {
      return {
        title: name
      };
    });
    var filteredAuthorNames = authorsSearched.map(function (name) {
      return {
        title: name
      };
    });
    return /*#__PURE__*/_react.default.createElement(_dotComponents.DotAutoComplete, {
      freesolo: false,
      inputId: "authors",
      isOptionEqualToValue: function isOptionEqualToValue(option, value) {
        return option.title === value.title;
      },
      multiple: true,
      onChange: function onChange(_ev, value) {
        var _ref2;
        var selectedAuthors = (_ref2 = value) !== null && _ref2 !== void 0 ? _ref2 : [];
        onCardFilter(_objectSpread(_objectSpread({}, cardSearch), {}, {
          authorNames: selectedAuthors.map(function (author) {
            return author.title;
          })
        }));
      },
      options: authorsOptions,
      placeholder: "Start typing to filter by authors",
      renderOption: function renderOption(props, _ref3) {
        var title = _ref3.title;
        return /*#__PURE__*/_react.default.createElement("li", (0, _extends2.default)({
          key: title
        }, props), /*#__PURE__*/_react.default.createElement(_avatarWithName.AvatarWithName, {
          id: "id-".concat(title),
          title: title
        }));
      },
      renderTags: function renderTags(options) {
        return options.map(function (option, index) {
          var author = option;
          return /*#__PURE__*/_react.default.createElement(_dotComponents.DotChip, {
            avatar: /*#__PURE__*/_react.default.createElement(_dotComponents.DotAvatar, {
              alt: "Image for user ".concat(author.title),
              size: "small",
              text: author.title,
              type: "text"
            }),
            className: "author-chip",
            key: index,
            onDelete: function onDelete() {
              onCardFilter(_objectSpread(_objectSpread({}, cardSearch), {}, {
                authorNames: (0, _helpers.removeAuthorFromFilters)(author.title, authorsSearched)
              }));
            },
            size: "small"
          }, author.title);
        });
      },
      value: filteredAuthorNames
    });
  };
  return /*#__PURE__*/_react.default.createElement(_dotComponents.DotClickAwayListener, {
    onClickAway: isDrawerOpened ? onDrawerClose : _noop.default
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotDrawer, {
    ModalProps: {
      hideBackdrop: true
    },
    PaperProps: {
      style: {
        top: '104px',
        padding: '0',
        height: 'calc(100% - 104px)'
      }
    },
    anchor: "right",
    className: "analytics-drawer",
    open: isDrawerOpened,
    variant: "persistent",
    width: "320px"
  }, isDrawerOpened ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "analytics-drawer-header"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "h3"
  }, "Filters"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
    iconId: "close",
    onClick: onDrawerClose,
    tooltip: "Close"
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "analytics-drawer-actions"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "subtitle2"
  }, "Applied filters (".concat(numberOfFiltersApplied, ")")), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    onClick: onClearAll,
    type: "outlined"
  }, "Clear all")), /*#__PURE__*/_react.default.createElement("div", {
    className: "filter-group-title"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "overline"
  }, "Filter by category")), /*#__PURE__*/_react.default.createElement("div", {
    className: "filter-checkbox-group"
  }, renderCategoryCheckboxes()), /*#__PURE__*/_react.default.createElement("div", {
    className: "filter-group-title"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "overline"
  }, "Filter by author")), /*#__PURE__*/_react.default.createElement("div", {
    className: "filter-checkbox-group"
  }, renderAuthorAutocomplete())) : null)));
};

/***/ }),

/***/ 97270:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AnalyticsPageProvider = exports.AnalyticsPage = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _dotComponents = __webpack_require__(92140);
var _analyticsStore = __webpack_require__(85376);
var _hooks = __webpack_require__(96462);
var _licenseWarning = __webpack_require__(65782);
var _analyticsCards = __webpack_require__(19183);
var _analytics = __webpack_require__(66948);
var _helpers = __webpack_require__(97959);
var _analyticsPageFilterDrawer = __webpack_require__(69683);
var _analyticsCards2 = __webpack_require__(31372);
var _analyticsPage = __webpack_require__(16805);
__webpack_require__(12643);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var AnalyticsPageProvider = exports.AnalyticsPageProvider = function AnalyticsPageProvider(props) {
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _analyticsStore.store
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, /*#__PURE__*/_react.default.createElement(AnalyticsPage, props)));
};
var ANALYTICS_PAGE_TABS = [{
  label: 'All dashboards'
}, {
  label: 'Favourites'
}];
var _analytics$actions = _analytics.analytics.actions,
  init = _analytics$actions.init,
  filterCards = _analytics$actions.filterCards,
  setIsDrawerOpened = _analytics$actions.setIsDrawerOpened;
var LICENSE_EDITIONS_FOR_BANNER = ['Essentials', 'Pro', 'Premium', 'Trial'];
var AnalyticsPage = exports.AnalyticsPage = function AnalyticsPage(_ref) {
  var filters = _ref.filters,
    folder = _ref.folder;
  var dispatch = (0, _hooks.useAppDispatch)();
  var _useState = (0, _react.useState)(0),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    selectedTab = _useState2[0],
    setSelectedTab = _useState2[1];
  var license = (0, _hooks.useAppSelector)(_licenseWarning.getLicense);
  var _useAppSelector = (0, _hooks.useAppSelector)(_analytics.getAnalyticsState),
    authors = _useAppSelector.authors,
    isDrawerOpened = _useAppSelector.isDrawerOpened,
    cards = _useAppSelector.cards,
    categories = _useAppSelector.categories,
    cardSearch = _useAppSelector.cardSearch,
    isAnalyticsConfigured = _useAppSelector.isAnalyticsConfigured,
    isLoading = _useAppSelector.isLoading;
  var isBannerVisible = LICENSE_EDITIONS_FOR_BANNER.includes((license === null || license === void 0 ? void 0 : license.edition) || 'Community') && !isAnalyticsConfigured;
  var numberOfFiltersApplied = (0, _helpers.calculateNumberOfFiltersApplied)(cardSearch);
  var _ref2 = cardSearch || {},
    filteredCategories = _ref2.categories,
    filteredAuthors = _ref2.authorNames;
  var isAnyCategoryFilterPresent = !!(filteredCategories && filteredCategories.length > 0);
  var isAnyAuthorFilterPresent = !!(filteredAuthors && filteredAuthors.length > 0);
  var isAnyFilterPresent = isAnyAuthorFilterPresent || isAnyCategoryFilterPresent;
  var isSearchOrFilterApplied = cardSearch && cardSearch.name !== '' || isAnyFilterPresent;
  (0, _react.useEffect)(function () {
    dispatch(init(filters));
  }, []);
  var getCardSearch = function getCardSearch(currentCardSearch) {
    return cardSearch ? _objectSpread(_objectSpread({}, cardSearch), currentCardSearch) : currentCardSearch;
  };
  var handleDrawerOpen = function handleDrawerOpen(event) {
    if (isDrawerOpened) return;
    event.stopPropagation();
    dispatch(setIsDrawerOpened(true));
  };
  var handleDrawerClose = function handleDrawerClose() {
    return dispatch(setIsDrawerOpened(false));
  };
  var handleCardFilterChange = function handleCardFilterChange(currentCardSearch) {
    return dispatch(filterCards(currentCardSearch));
  };
  var handleTabChange = function handleTabChange(value) {
    return setSelectedTab(value);
  };
  var handleClearAllFilters = function handleClearAllFilters() {
    return dispatch(filterCards(_objectSpread(_objectSpread({}, cardSearch), {}, {
      categories: undefined,
      authorNames: undefined
    })));
  };
  var filteredCards = (0, _helpers.filterCardsBySearch)(cards, cardSearch);
  // for now, none of the dashboards are favourites
  var filteredFavouritesCards = filteredCards.filter(function (_card) {
    return false;
  });
  var getAnalyticsTabsWithNumbers = function getAnalyticsTabsWithNumbers() {
    var allDashboardsCount = filteredCards.length;
    return ANALYTICS_PAGE_TABS.map(function (tab, index) {
      var tabCount = index === 0 ? allDashboardsCount : filteredFavouritesCards.length;
      return {
        label: "".concat(tab.label, " (").concat(tabCount, ")")
      };
    });
  };
  var renderLoadingPage = function renderLoadingPage() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "analytics-page"
    }, /*#__PURE__*/_react.default.createElement(_analyticsPage.AnalyticsPagePortal, {
      isAnalyticsConfigured: isAnalyticsConfigured
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "analytics-page-content"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "content-header"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
      "data-testid": "page-title",
      variant: "h1"
    }, "Analytics"), /*#__PURE__*/_react.default.createElement("div", {
      className: "content-header-filter"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotSkeleton, {
      height: "40px",
      variant: "rectangular",
      width: "200px"
    }))), /*#__PURE__*/_react.default.createElement(_dotComponents.DotTabs, {
      className: "analytics-tabs",
      initialValue: selectedTab,
      onChange: handleTabChange,
      tabs: ANALYTICS_PAGE_TABS
    }), /*#__PURE__*/_react.default.createElement("div", null, selectedTab === 0 && /*#__PURE__*/_react.default.createElement(_analyticsCards2.AnalyticsCardsSkeleton, null), selectedTab === 1 && /*#__PURE__*/_react.default.createElement(_analyticsCards2.AnalyticsCardsSkeleton, null))));
  };
  var renderPage = function renderPage() {
    var hidePortalButtons = isAnalyticsConfigured && selectedTab === 0 && !cards.length && !isSearchOrFilterApplied;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "analytics-page"
    }, !hidePortalButtons && /*#__PURE__*/_react.default.createElement(_analyticsPage.AnalyticsPagePortal, {
      isAnalyticsConfigured: isAnalyticsConfigured
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "analytics-page-content"
    }, isBannerVisible && /*#__PURE__*/_react.default.createElement("div", {
      className: "analytics-banner"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotAvatar, {
      alt: "crown icon",
      className: "analytics-banner-avatar",
      iconId: "crown"
    }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
      variant: "body1"
    }, "The upcoming release will include the availability of new Analytics dashboards in the Premium edition. For more information, please contact your Customer Success Manager.")), /*#__PURE__*/_react.default.createElement("div", {
      className: "content-header"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
      "data-testid": "page-title",
      variant: "h1"
    }, "Analytics"), /*#__PURE__*/_react.default.createElement("div", {
      className: "content-header-filter"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotInputText, {
      className: "name-filter",
      defaultValue: filters.name,
      id: "name-filter",
      name: "name-filter",
      onChange: function onChange(e) {
        return handleCardFilterChange(getCardSearch({
          name: e.target.value
        }));
      },
      onClear: function onClear() {
        return handleCardFilterChange(getCardSearch({
          name: ''
        }));
      },
      placeholder: "Filter by name ...",
      startIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
        "data-testid": "name-filter-search-icon",
        fontSize: "small",
        iconId: "search"
      })
    }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotBadge, {
      badgeColor: "#d61f21",
      badgeContent: numberOfFiltersApplied,
      overlap: "circular",
      variant: "standard"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
      iconId: "filter",
      onClick: handleDrawerOpen
    })))), isAnyFilterPresent && /*#__PURE__*/_react.default.createElement("div", {
      className: "aligned-flex-with-gap",
      "data-testid": "filters-row"
    }, filteredCategories && filteredCategories.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
      "data-testid": "category-filters-title",
      variant: "subtitle2"
    }, "Categories:"), filteredCategories.map(function (categoryName) {
      return /*#__PURE__*/_react.default.createElement(_dotComponents.DotChip, {
        "data-testid": "category-filters-".concat(categoryName),
        key: categoryName,
        onDelete: function onDelete() {
          return handleCardFilterChange(getCardSearch({
            categories: (0, _helpers.removeCategoryFromFilters)(categoryName, filteredCategories)
          }));
        },
        size: "small"
      }, categoryName);
    })), filteredAuthors && filteredAuthors.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
      "data-testid": "author-filters-title",
      variant: "subtitle2"
    }, "Authors:"), filteredAuthors.map(function (authorName) {
      return /*#__PURE__*/_react.default.createElement(_dotComponents.DotChip, {
        avatar: /*#__PURE__*/_react.default.createElement(_dotComponents.DotAvatar, {
          alt: "Image for user ".concat(authorName),
          size: "small",
          text: authorName,
          type: "text"
        }),
        "data-testid": "author-filters-".concat(authorName),
        key: authorName,
        onDelete: function onDelete() {
          return handleCardFilterChange(getCardSearch({
            authorNames: (0, _helpers.removeAuthorFromFilters)(authorName, filteredAuthors)
          }));
        },
        size: "small"
      }, authorName);
    })), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
      className: "chipy-btn",
      "data-testid": "clear-all-btn",
      onClick: handleClearAllFilters,
      type: "text"
    }, "Clear all")), /*#__PURE__*/_react.default.createElement(_dotComponents.DotTabs, {
      className: "analytics-tabs",
      initialValue: selectedTab,
      onChange: handleTabChange,
      tabs: getAnalyticsTabsWithNumbers()
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "analytics-tabs-wrapper"
    }, selectedTab === 0 && /*#__PURE__*/_react.default.createElement(_analyticsCards.AnalyticsCards, {
      cards: filteredCards,
      folderId: folder === null || folder === void 0 ? void 0 : folder.id,
      isAnalyticsConfigured: isAnalyticsConfigured,
      isFavouritePage: false,
      isSearchOrFilterApplied: isSearchOrFilterApplied,
      profileFavouriteDashboards: []
    }), selectedTab === 1 && /*#__PURE__*/_react.default.createElement(_analyticsCards.AnalyticsCards, {
      cards: filteredFavouritesCards,
      folderId: folder === null || folder === void 0 ? void 0 : folder.id,
      isAnalyticsConfigured: isAnalyticsConfigured,
      isFavouritePage: true,
      isSearchOrFilterApplied: isSearchOrFilterApplied,
      profileFavouriteDashboards: []
    }))), /*#__PURE__*/_react.default.createElement(_analyticsPageFilterDrawer.AnalyticsPageFilterDrawer, {
      authors: authors,
      cardSearch: cardSearch,
      categories: categories,
      isDrawerOpened: isDrawerOpened,
      numberOfFiltersApplied: numberOfFiltersApplied,
      onCardFilter: handleCardFilterChange,
      onClearAll: handleClearAllFilters,
      onDrawerClose: handleDrawerClose
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading && renderLoadingPage(), !isLoading && renderPage());
};

/***/ }),

/***/ 16805:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AnalyticsPagePortal = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _actionToolbar = __webpack_require__(29755);
var AnalyticsPagePortal = exports.AnalyticsPagePortal = function AnalyticsPagePortal(_ref) {
  var isAnalyticsConfigured = _ref.isAnalyticsConfigured;
  var handleOnClick = function handleOnClick() {
    // TODO redirect to intelligence
    // TODO permissions
  };
  return /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortal, null, isAnalyticsConfigured && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    endIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      iconId: "open-new-tab"
    }),
    onClick: handleOnClick
  }, "Manage dashboards")));
};

/***/ }),

/***/ 87810:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.dashboardDivId = exports.AnalyticsDashboardPageProvider = exports.AnalyticsDashboardPage = void 0;
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _dotComponents = __webpack_require__(92140);
var _analyticsStore = __webpack_require__(85376);
var _hooks = __webpack_require__(96462);
var _navigation = __webpack_require__(94744);
var _analytics = __webpack_require__(66948);
var _analyticsDashboardPage = __webpack_require__(69667);
var _hooks2 = __webpack_require__(38602);
__webpack_require__(79185);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var _analytics$actions = _analytics.analytics.actions,
  loadDashboard = _analytics$actions.loadDashboard,
  clearSelectedDashboard = _analytics$actions.clearSelectedDashboard;
var dashboardDivId = exports.dashboardDivId = 'dashboard-placeholder';
var AnalyticsDashboardPageProvider = exports.AnalyticsDashboardPageProvider = function AnalyticsDashboardPageProvider(props) {
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _analyticsStore.store
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, /*#__PURE__*/_react.default.createElement(AnalyticsDashboardPage, props)));
};
var AnalyticsDashboardPage = exports.AnalyticsDashboardPage = function AnalyticsDashboardPage(_ref) {
  var dashboardId = _ref.dashboardId,
    folder = _ref.folder;
  var _useAppSelector = (0, _hooks.useAppSelector)(_navigation.getNavigationState),
    menuIsOpen = _useAppSelector.menuIsOpen;
  var _useAppSelector2 = (0, _hooks.useAppSelector)(_analytics.getAnalyticsState),
    selectedDashboard = _useAppSelector2.selectedDashboard;
  var dispatch = (0, _hooks.useAppDispatch)();
  if (folder) {
    // TODO check permissions
  }
  (0, _hooks2.useCloseSidebar)(menuIsOpen, dispatch);
  (0, _react.useEffect)(function () {
    dispatch(loadDashboard(dashboardId));
    return function () {
      dispatch(clearSelectedDashboard());
    };
  }, []);
  var renderLoader = function renderLoader() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "dashboard-loader"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotProgress, {
      ariaLabel: "Loading dashboard data",
      size: 100
    }));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "analytics-dashboard-page"
  }, /*#__PURE__*/_react.default.createElement(_analyticsDashboardPage.AnalyticsDashboardPagePortal, {
    dashboardId: dashboardId,
    folderId: folder === null || folder === void 0 ? void 0 : folder.id
  }), selectedDashboard && /*#__PURE__*/_react.default.createElement("div", {
    id: dashboardDivId
  }), !selectedDashboard && renderLoader());
};

/***/ }),

/***/ 69667:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AnalyticsDashboardPagePortal = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _actionToolbar = __webpack_require__(29755);
var _menuItem = __webpack_require__(48447);
var _helpers = __webpack_require__(97959);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var MENU_ITEMS_KEYS = {
  share: 'share',
  export: 'export'
};
var AnalyticsDashboardPagePortal = exports.AnalyticsDashboardPagePortal = function AnalyticsDashboardPagePortal(_ref) {
  var _dashboardId = _ref.dashboardId,
    folderId = _ref.folderId;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isDialogOpen = _useState2[0],
    setDialogOpen = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    isOpenDropdown = _useState4[0],
    setOpenDropdown = _useState4[1];
  var _useState5 = (0, _react.useState)(''),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    modalTitle = _useState6[0],
    setModalTitle = _useState6[1];
  var _useState7 = (0, _react.useState)(null),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    dropdownAnchorEl = _useState8[0],
    setDropdownAnchorEl = _useState8[1];

  // not implemented, to get from platform
  var isFavourite = false;
  var menuOptions = [{
    children: /*#__PURE__*/_react.default.createElement(_menuItem.MenuItem, {
      iconId: "share",
      label: "Share dashboard"
    }),
    key: MENU_ITEMS_KEYS.share
  }, {
    children: /*#__PURE__*/_react.default.createElement(_menuItem.MenuItem, {
      iconId: "download",
      label: "Export dashboard"
    }),
    key: MENU_ITEMS_KEYS.export
  }];
  var handleClick = function handleClick(title) {
    setModalTitle(title);
    setDialogOpen(true);
  };
  var handleCloseModal = function handleCloseModal() {
    setDialogOpen(false);
    setModalTitle('');
  };
  var switchDropdown = function switchDropdown(event) {
    setDropdownAnchorEl(event.currentTarget);
    setOpenDropdown(!isOpenDropdown);
  };
  var handleBackClick = function handleBackClick() {
    if (folderId) {
      window.location.href = "#/folders/".concat(folderId, "/analytics");
    } else {
      window.location.href = '#/analytics';
    }
  };
  var handleSelect = function handleSelect(itemKey) {
    if (itemKey === MENU_ITEMS_KEYS.share) {
      handleClick('Share');
    } else if (itemKey === MENU_ITEMS_KEYS.export) {
      handleClick('Export');
    } else {
      // this should never happen, just here for now....
      handleClick('TODO');
    }
  };
  var handleFavourite = function handleFavourite() {
    // TODO in plaftorm
  };
  return /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortal, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    "data-testid": "back-btn",
    onClick: handleBackClick,
    startIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      iconId: "back"
    }),
    type: "text"
  }, "Back"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    "data-testid": "fav-btn",
    onClick: handleFavourite,
    startIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      iconId: (0, _helpers.getFavouriteIcon)(isFavourite)
    }),
    type: "outlined"
  }, (0, _helpers.getFavouriteText)(isFavourite)), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    "data-testid": "edit-btn",
    endIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      iconId: "open-new-tab"
    }),
    onClick: function onClick() {
      return handleClick('Edit dashboard');
    },
    type: "outlined"
  }, "Edit dashboard"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
    "data-testid": "options-btn",
    iconId: "options",
    onClick: function onClick(e) {
      return switchDropdown(e);
    }
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotMenu, {
    anchorEl: dropdownAnchorEl || undefined,
    dense: true,
    disablePortal: true,
    id: "analytics-portal-menu",
    menuItems: menuOptions,
    menuPlacement: "bottom-end",
    onLeave: function onLeave() {
      return setOpenDropdown(false);
    },
    onSelect: function onSelect(_e, _menu, key) {
      return handleSelect(key);
    },
    open: isOpenDropdown
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotDialog, {
    cancelButtonVisible: false,
    closeIconVisible: true,
    onCancel: handleCloseModal,
    onSubmit: handleCloseModal,
    open: isDialogOpen,
    submitButtonProps: {
      label: 'Close'
    },
    title: modalTitle
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "body1"
  }, "Thanks for being curious about this feature. We are working on it right now. \uD83D\uDE80", /*#__PURE__*/_react.default.createElement("br", null), "Stay tuned for updates!")));
};

/***/ }),

/***/ 52236:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AnalyticsSidebarProvider = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _effects = __webpack_require__(34857);
var _sidebar = __webpack_require__(73811);
var _navigation = __webpack_require__(17523);
var _navigation$actions = _navigation.navigation.actions,
  setBackItem = _navigation$actions.setBackItem,
  updateBreadcrumbs = _navigation$actions.updateBreadcrumbs,
  setSidebarMenu = _navigation$actions.setSidebarMenu,
  setLastBreadcrumb = _navigation$actions.setLastBreadcrumb;
var AnalyticsSidebarProvider = exports.AnalyticsSidebarProvider = /*#__PURE__*/function () {
  function AnalyticsSidebarProvider() {
    (0, _classCallCheck2.default)(this, AnalyticsSidebarProvider);
  }
  (0, _createClass2.default)(AnalyticsSidebarProvider, [{
    key: "isSupported",
    value: function isSupported(path) {
      return path.startsWith('/analytics/');
    }
  }, {
    key: "provide",
    value: /*#__PURE__*/_regenerator.default.mark(function provide(_path) {
      var breadcrumbs;
      return _regenerator.default.wrap(function provide$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            breadcrumbs = [{
              text: 'Dashboards',
              href: "/dashboards"
            }, {
              text: 'Analytics',
              href: "/analytics"
            }];
            _context.next = 3;
            return (0, _effects.put)(setLastBreadcrumb(undefined));
          case 3:
            _context.next = 5;
            return (0, _effects.put)(updateBreadcrumbs(breadcrumbs));
          case 5:
            _context.next = 7;
            return (0, _effects.put)(setSidebarMenu({
              sidebarMenu: [],
              withFolder: false
            }));
          case 7:
            _context.next = 9;
            return (0, _effects.put)(setBackItem({
              pathSuffix: 'analytics',
              title: 'Analytics',
              text: 'Analytics'
            }));
          case 9:
          case "end":
            return _context.stop();
        }
      }, provide);
    })
  }]);
  return AnalyticsSidebarProvider;
}();
(0, _sidebar.registerSidebarProvider)(new AnalyticsSidebarProvider(), 0);

/***/ }),

/***/ 9380:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.INTELLIGENCE_SERVER_TITLE = exports.ANALYTICS_SAMPLE_CARDS = exports.ANALYTICS_CATEGORIES = exports.ANALYTICS_AUTHORS = void 0;
var INTELLIGENCE_SERVER_TITLE = exports.INTELLIGENCE_SERVER_TITLE = 'Digital.ai Analytics';
var ANALYTICS_CATEGORIES = exports.ANALYTICS_CATEGORIES = ['DevOps COE', 'Engineering manager', 'Platform engineer', 'Platform product manager', 'Release manager'];
var ANALYTICS_AUTHORS = exports.ANALYTICS_AUTHORS = ['Digital.ai'];
var ANALYTICS_SAMPLE_CARDS = exports.ANALYTICS_SAMPLE_CARDS = [{
  contentText: 'Efficiently monitor team and application onboarding and maturation rates on the Digital.ai Release-orchestrated pipeline. Identify areas for improvement.',
  id: '1',
  hasFolderFilter: false,
  embeddingUrl: 'http',
  embeddingId: '1',
  externalId: 1,
  imageSrc: 'static/24.1.10/include/analytics-dashboard/assets/onboarding.svg',
  subtitle: ANALYTICS_AUTHORS[0],
  tags: [ANALYTICS_CATEGORIES[0]],
  title: 'Onboarding plan and progress'
}, {
  contentText: 'Leverage DORA metrics for DevOps insights, identify areas for improvement, and drive change in software development.',
  id: '2',
  hasFolderFilter: false,
  embeddingUrl: 'http',
  embeddingId: '2',
  externalId: 2,
  imageSrc: 'static/24.1.10/include/analytics-dashboard/assets/dora-metrics.svg',
  subtitle: ANALYTICS_AUTHORS[0],
  tags: [ANALYTICS_CATEGORIES[1]],
  title: 'DORA overview'
}, {
  contentText: 'Retrospective analysis of past release processes over time.',
  id: '3',
  hasFolderFilter: false,
  embeddingUrl: 'http',
  embeddingId: '3',
  externalId: 3,
  imageSrc: 'static/24.1.10/include/analytics-dashboard/assets/executive.svg',
  subtitle: ANALYTICS_AUTHORS[0],
  tags: [ANALYTICS_CATEGORIES[4]],
  title: 'Release executive overview'
}, {
  contentText: 'Monitor open tasks, address aged incomplete and dependent tasks. Review upcoming tasks for planning, prioritization, and adjustment for successful releases.',
  id: '4',
  hasFolderFilter: false,
  embeddingUrl: 'http',
  embeddingId: '4',
  externalId: 4,
  imageSrc: 'static/24.1.10/include/analytics-dashboard/assets/analysis.svg',
  subtitle: ANALYTICS_AUTHORS[0],
  tags: [ANALYTICS_CATEGORIES[4]],
  title: 'Release task open work analysis'
}, {
  contentText: 'Overview of release delays and dependencies related to Gate tasks.',
  id: '5',
  hasFolderFilter: false,
  embeddingUrl: 'http',
  embeddingId: '5',
  externalId: 5,
  imageSrc: 'static/24.1.10/include/analytics-dashboard/assets/late-task.svg',
  subtitle: ANALYTICS_AUTHORS[0],
  tags: [ANALYTICS_CATEGORIES[4]],
  title: 'Release late task and its impact'
}, {
  contentText: 'By revealing the impact of downstream actions on releases, this report empowers release managers to take proactive operational measures.',
  id: '6',
  hasFolderFilter: false,
  embeddingUrl: 'http',
  embeddingId: '6',
  externalId: 6,
  imageSrc: 'static/24.1.10/include/analytics-dashboard/assets/dependency.svg',
  subtitle: ANALYTICS_AUTHORS[0],
  tags: [ANALYTICS_CATEGORIES[4]],
  title: 'Release dependency dashboard'
}, {
  contentText: 'Gain insights on team adoption of services and automation via Workflows. Identify what works best and manage your developer platform as a product.',
  id: '7',
  hasFolderFilter: false,
  embeddingUrl: 'http',
  embeddingId: '7',
  externalId: 7,
  imageSrc: 'static/24.1.10/include/analytics-dashboard/assets/workflow.svg',
  subtitle: ANALYTICS_AUTHORS[0],
  tags: [ANALYTICS_CATEGORIES[2], ANALYTICS_CATEGORIES[3]],
  title: 'Workflow adoption and usage patterns'
}];

/***/ }),

/***/ 66948:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.initialState = exports.getAnalyticsState = exports.analytics = void 0;
var _toolkit = __webpack_require__(47054);
var _noop = _interopRequireDefault(__webpack_require__(50308));
var initialState = exports.initialState = {
  authors: [],
  cards: [],
  categories: [],
  isAnalyticsConfigured: true,
  // set as true so banner doesn't blink
  isDrawerOpened: false,
  isLoading: true
};
var analytics = exports.analytics = (0, _toolkit.createSlice)({
  name: 'analytics',
  initialState: initialState,
  reducers: {
    init: function init(_state, _action) {
      return (0, _noop.default)();
    },
    filterCards: function filterCards(_state, _action) {
      return (0, _noop.default)();
    },
    setCards: function setCards(state, action) {
      state.cards = action.payload;
    },
    setCategories: function setCategories(state, action) {
      state.categories = action.payload;
    },
    setAuthors: function setAuthors(state, action) {
      state.authors = action.payload;
    },
    setIsDrawerOpened: function setIsDrawerOpened(state, action) {
      state.isDrawerOpened = action.payload;
    },
    setIsAnalyticsConfigured: function setIsAnalyticsConfigured(state, action) {
      state.isAnalyticsConfigured = action.payload;
    },
    setIntelligenceConfiguration: function setIntelligenceConfiguration(state, action) {
      state.isAnalyticsConfigured = true;
      state.intelligenceConfiguration = action.payload;
    },
    setCardSearch: function setCardSearch(state, action) {
      state.cardSearch = action.payload;
    },
    setIsLoading: function setIsLoading(state, action) {
      state.isLoading = action.payload;
    },
    loadDashboard: function loadDashboard(_state, _action) {
      return (0, _noop.default)();
    },
    setSelectedDashboard: function setSelectedDashboard(state, action) {
      state.selectedDashboard = action.payload;
    },
    clearSelectedDashboard: function clearSelectedDashboard(state) {
      state.selectedDashboard = undefined;
    }
  }
});
var getAnalyticsState = exports.getAnalyticsState = function getAnalyticsState(state) {
  return state.analytics;
};

/***/ }),

/***/ 19999:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.analyticsSaga = analyticsSaga;
exports.checkIfIntelligenceIsConfigured = checkIfIntelligenceIsConfigured;
exports.filterCardsSaga = filterCardsSaga;
exports.initSaga = initSaga;
exports.loadCards = loadCards;
exports.loadDashboardSaga = loadDashboardSaga;
exports.setCardSearchSaga = setCardSearchSaga;
exports.toaster = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _effects = __webpack_require__(34857);
var _analytics = __webpack_require__(66948);
var _constants = __webpack_require__(9380);
var _angularAccessor = _interopRequireDefault(__webpack_require__(81403));
var _helpers = __webpack_require__(97959);
var _http = __webpack_require__(26511);
var _toastrFactory = _interopRequireDefault(__webpack_require__(86846));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var _marked = /*#__PURE__*/_regenerator.default.mark(initSaga),
  _marked2 = /*#__PURE__*/_regenerator.default.mark(checkIfIntelligenceIsConfigured),
  _marked3 = /*#__PURE__*/_regenerator.default.mark(loadCards),
  _marked4 = /*#__PURE__*/_regenerator.default.mark(filterCardsSaga),
  _marked5 = /*#__PURE__*/_regenerator.default.mark(setCardSearchSaga),
  _marked6 = /*#__PURE__*/_regenerator.default.mark(loadDashboardSaga),
  _marked7 = /*#__PURE__*/_regenerator.default.mark(analyticsSaga);
var toaster = exports.toaster = (0, _toastrFactory.default)();
var _analytics$actions = _analytics.analytics.actions,
  init = _analytics$actions.init,
  filterCards = _analytics$actions.filterCards,
  setCards = _analytics$actions.setCards,
  setCardSearch = _analytics$actions.setCardSearch,
  setAuthors = _analytics$actions.setAuthors,
  setCategories = _analytics$actions.setCategories,
  setIsAnalyticsConfigured = _analytics$actions.setIsAnalyticsConfigured,
  setIntelligenceConfiguration = _analytics$actions.setIntelligenceConfiguration,
  setIsLoading = _analytics$actions.setIsLoading,
  loadDashboard = _analytics$actions.loadDashboard,
  setSelectedDashboard = _analytics$actions.setSelectedDashboard;
function initSaga(action) {
  var cardSearch;
  return _regenerator.default.wrap(function initSaga$(_context) {
    while (1) switch (_context.prev = _context.next) {
      case 0:
        _context.next = 2;
        return (0, _effects.put)(setCards([]));
      case 2:
        _context.next = 4;
        return (0, _effects.call)(checkIfIntelligenceIsConfigured);
      case 4:
        _context.next = 6;
        return (0, _effects.put)(setCategories(_constants.ANALYTICS_CATEGORIES));
      case 6:
        _context.next = 8;
        return (0, _effects.call)(loadCards);
      case 8:
        cardSearch = action.payload;
        if (!cardSearch) {
          _context.next = 12;
          break;
        }
        _context.next = 12;
        return (0, _effects.put)(filterCards(cardSearch));
      case 12:
      case "end":
        return _context.stop();
    }
  }, _marked);
}
function checkIfIntelligenceIsConfigured() {
  var configurationService, intelligenceServerResponse, intelligenceServer;
  return _regenerator.default.wrap(function checkIfIntelligenceIsConfigured$(_context2) {
    while (1) switch (_context2.prev = _context2.next) {
      case 0:
        _context2.next = 2;
        return (0, _effects.call)(_angularAccessor.default, 'ConfigurationService');
      case 2:
        configurationService = _context2.sent;
        _context2.next = 5;
        return (0, _effects.call)([configurationService, configurationService.searchConfiguration], 'dai.IntelligenceServer', _constants.INTELLIGENCE_SERVER_TITLE);
      case 5:
        intelligenceServerResponse = _context2.sent;
        intelligenceServer = intelligenceServerResponse['dai.IntelligenceServer'];
        if (!(intelligenceServer && intelligenceServer.length)) {
          _context2.next = 12;
          break;
        }
        _context2.next = 10;
        return (0, _effects.put)(setIntelligenceConfiguration(intelligenceServer[0]));
      case 10:
        _context2.next = 14;
        break;
      case 12:
        _context2.next = 14;
        return (0, _effects.put)(setIsAnalyticsConfigured(false));
      case 14:
      case "end":
        return _context2.stop();
    }
  }, _marked2);
}
function loadCards() {
  var _yield$select, intelligenceConfiguration, isAnalyticsConfigured, cards, _yield$call, entity;
  return _regenerator.default.wrap(function loadCards$(_context3) {
    while (1) switch (_context3.prev = _context3.next) {
      case 0:
        _context3.next = 2;
        return (0, _effects.select)(_analytics.getAnalyticsState);
      case 2:
        _yield$select = _context3.sent;
        intelligenceConfiguration = _yield$select.intelligenceConfiguration;
        isAnalyticsConfigured = _yield$select.isAnalyticsConfigured;
        if (!(isAnalyticsConfigured && intelligenceConfiguration)) {
          _context3.next = 17;
          break;
        }
        _context3.next = 8;
        return (0, _effects.put)(setIsLoading(true));
      case 8:
        _context3.next = 10;
        return (0, _effects.call)(_http.httpGET, "api/extension/intelligence/dashboards?serverId=".concat(intelligenceConfiguration.id));
      case 10:
        _yield$call = _context3.sent;
        entity = _yield$call.data.entity;
        cards = (0, _helpers.mapSupersetToAnalyticsCard)(entity, intelligenceConfiguration === null || intelligenceConfiguration === void 0 ? void 0 : intelligenceConfiguration.folderColumnName);
        _context3.next = 15;
        return (0, _effects.put)(setAuthors((0, _helpers.collectAllAuthors)(entity)));
      case 15:
        _context3.next = 20;
        break;
      case 17:
        _context3.next = 19;
        return (0, _effects.put)(setAuthors(_constants.ANALYTICS_AUTHORS));
      case 19:
        cards = _constants.ANALYTICS_SAMPLE_CARDS;
      case 20:
        _context3.next = 22;
        return (0, _effects.put)(setIsLoading(false));
      case 22:
        _context3.next = 24;
        return (0, _effects.put)(setCards(cards));
      case 24:
        return _context3.abrupt("return", cards);
      case 25:
      case "end":
        return _context3.stop();
    }
  }, _marked3);
}
function filterCardsSaga(action) {
  var cardSearch;
  return _regenerator.default.wrap(function filterCardsSaga$(_context4) {
    while (1) switch (_context4.prev = _context4.next) {
      case 0:
        cardSearch = action.payload;
        _context4.next = 3;
        return (0, _effects.put)(setCardSearch(cardSearch));
      case 3:
      case "end":
        return _context4.stop();
    }
  }, _marked4);
}
function setCardSearchSaga(action) {
  var FiltersQueryParams, clientSettings, cardSearch;
  return _regenerator.default.wrap(function setCardSearchSaga$(_context5) {
    while (1) switch (_context5.prev = _context5.next) {
      case 0:
        _context5.next = 2;
        return (0, _effects.call)(_angularAccessor.default, 'FiltersQueryParams');
      case 2:
        FiltersQueryParams = _context5.sent;
        _context5.next = 5;
        return (0, _effects.call)(_angularAccessor.default, 'ClientSettings');
      case 5:
        clientSettings = _context5.sent;
        cardSearch = action.payload;
        clientSettings.setAnalyticsListFilters(cardSearch);
        FiltersQueryParams.update(_objectSpread(_objectSpread({}, cardSearch), {}, {
          categories: (0, _helpers.convertArrayToString)(cardSearch === null || cardSearch === void 0 ? void 0 : cardSearch.categories),
          authorNames: (0, _helpers.convertArrayToString)(cardSearch === null || cardSearch === void 0 ? void 0 : cardSearch.authorNames)
        }));
      case 9:
      case "end":
        return _context5.stop();
    }
  }, _marked5);
}
function loadDashboardSaga(action) {
  var _yield$select2, isAnalyticsConfigured, cards, dashboardId, dashboard, refreshedCards;
  return _regenerator.default.wrap(function loadDashboardSaga$(_context6) {
    while (1) switch (_context6.prev = _context6.next) {
      case 0:
        _context6.next = 2;
        return (0, _effects.call)(checkIfIntelligenceIsConfigured);
      case 2:
        _context6.next = 4;
        return (0, _effects.select)(_analytics.getAnalyticsState);
      case 4:
        _yield$select2 = _context6.sent;
        isAnalyticsConfigured = _yield$select2.isAnalyticsConfigured;
        cards = _yield$select2.cards;
        dashboardId = action.payload;
        if (!isAnalyticsConfigured) {
          _context6.next = 24;
          break;
        }
        if (cards.length) {
          _context6.next = 16;
          break;
        }
        _context6.next = 12;
        return (0, _effects.call)(loadCards);
      case 12:
        refreshedCards = _context6.sent;
        dashboard = refreshedCards.find(function (c) {
          return c.id === dashboardId;
        });
        _context6.next = 17;
        break;
      case 16:
        dashboard = cards.find(function (c) {
          return c.id === dashboardId;
        });
      case 17:
        if (!dashboard) {
          _context6.next = 22;
          break;
        }
        _context6.next = 20;
        return (0, _effects.put)(setSelectedDashboard(dashboard));
      case 20:
        _context6.next = 24;
        break;
      case 22:
        _context6.next = 24;
        return (0, _effects.call)(toaster.error, "Dashboard [".concat(dashboardId, "] can't be found"));
      case 24:
      case "end":
        return _context6.stop();
    }
  }, _marked6);
}
function analyticsSaga() {
  return _regenerator.default.wrap(function analyticsSaga$(_context7) {
    while (1) switch (_context7.prev = _context7.next) {
      case 0:
        _context7.next = 2;
        return (0, _effects.all)([(0, _effects.takeLatest)(init, initSaga), (0, _effects.debounce)(100, filterCards, filterCardsSaga), (0, _effects.takeLatest)(setCardSearch, setCardSearchSaga), (0, _effects.takeLatest)(loadDashboard, loadDashboardSaga)]);
      case 2:
      case "end":
        return _context7.stop();
    }
  }, _marked7);
}

/***/ }),

/***/ 97959:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.removeCategoryFromFilters = exports.removeAuthorFromFilters = exports.mapSupersetToAnalyticsCard = exports.isFavouriteCard = exports.hasFolderFilter = exports.getFavouriteText = exports.getFavouriteIcon = exports.filterCardsBySearch = exports.convertArrayToString = exports.collectAllAuthors = exports.calculateTitleAndSubtitleForEmptyState = exports.calculateNumberOfFiltersApplied = void 0;
var calculateNumberOfFiltersApplied = exports.calculateNumberOfFiltersApplied = function calculateNumberOfFiltersApplied(cardSearch) {
  var numberOfFilters = 0;
  var _ref = cardSearch || {},
    categories = _ref.categories,
    authorNames = _ref.authorNames;
  if (categories && categories.length > 0) numberOfFilters += categories.length;
  if (authorNames && authorNames.length > 0) numberOfFilters += authorNames.length;
  return numberOfFilters;
};
var removeCategoryFromFilters = exports.removeCategoryFromFilters = function removeCategoryFromFilters(categoryName, filteredCategories) {
  return filteredCategories === null || filteredCategories === void 0 ? void 0 : filteredCategories.filter(function (currentCategory) {
    return currentCategory !== categoryName;
  });
};
var removeAuthorFromFilters = exports.removeAuthorFromFilters = function removeAuthorFromFilters(authorName, filteredAuthorNames) {
  return filteredAuthorNames === null || filteredAuthorNames === void 0 ? void 0 : filteredAuthorNames.filter(function (currentAuthorName) {
    return currentAuthorName !== authorName;
  });
};
var convertArrayToString = exports.convertArrayToString = function convertArrayToString(input) {
  if (input && input.length > 0) {
    return input.join(',');
  } else {
    return undefined;
  }
};
var isFavouriteCard = exports.isFavouriteCard = function isFavouriteCard(favouriteDashboards, id) {
  return favouriteDashboards.includes(id);
};
var calculateTitleAndSubtitleForEmptyState = exports.calculateTitleAndSubtitleForEmptyState = function calculateTitleAndSubtitleForEmptyState(isFavouriteTab, isAnalyticsConfigured) {
  if (isFavouriteTab) {
    return {
      subtitle: 'To easily add dashboards to your favourites, simply click the star icon located next to each of the dashboards. 🌟',
      title: 'No favourites have been added so far'
    };
  } else {
    return isAnalyticsConfigured ? {
      subtitle: 'Create and manage Analytics dashboards',
      title: 'Analytics dashboards'
    } : {
      subtitle: 'There are no available dashboards yet.',
      title: 'No dashboards yet'
    };
  }
};
var filterCardsBySearch = exports.filterCardsBySearch = function filterCardsBySearch(cards, cardSearch) {
  var filteredCards = cards;
  if (cardSearch) {
    var name = cardSearch.name,
      authorNames = cardSearch.authorNames,
      categories = cardSearch.categories;
    if (name) {
      filteredCards = filteredCards.filter(function (card) {
        return card.title.toLowerCase().includes(name.toLowerCase());
      });
    }
    if (authorNames && authorNames.length > 0) {
      filteredCards = filteredCards.filter(function (card) {
        return authorNames.includes(card.subtitle);
      });
    }
    if (categories && categories.length > 0) {
      filteredCards = filteredCards.filter(function (card) {
        return card.tags.some(function (tag) {
          return categories.some(function (category) {
            return tag.includes(category);
          });
        });
      });
    }
  }
  return filteredCards;
};
var hasFolderFilter = exports.hasFolderFilter = function hasFolderFilter(dashboard, folderColumn) {
  var _dashboard$filter_con, _nativeFilters$flatMa;
  var nativeFilters = (_dashboard$filter_con = dashboard.filter_configuration) !== null && _dashboard$filter_con !== void 0 ? _dashboard$filter_con : [];
  var nativeFilterConfigurationTargets = (_nativeFilters$flatMa = nativeFilters === null || nativeFilters === void 0 ? void 0 : nativeFilters.flatMap(function (filter) {
    return filter.targets;
  })) !== null && _nativeFilters$flatMa !== void 0 ? _nativeFilters$flatMa : [];
  return nativeFilterConfigurationTargets.filter(function (target) {
    return target !== undefined;
  }).some(function (target) {
    var _target$column;
    return ((_target$column = target.column) === null || _target$column === void 0 ? void 0 : _target$column.name) === folderColumn;
  });
};
var mapSupersetToAnalyticsCard = exports.mapSupersetToAnalyticsCard = function mapSupersetToAnalyticsCard(list, folderColumn) {
  return list.map(function (item) {
    return {
      embeddingId: item.external_embedding_id,
      embeddingUrl: item.server_url,
      id: item.id,
      hasFolderFilter: hasFolderFilter(item, folderColumn),
      externalId: parseInt(item.external_id),
      tags: ['TODO'],
      title: item.name,
      subtitle: 'TODO',
      imageSrc: 'TODO',
      contentText: item.description
    };
  });
};
var collectAllAuthors = exports.collectAllAuthors = function collectAllAuthors(_list) {
  var allAuthors = new Set();
  // TODO we don't have authors coming from platform
  // list.forEach((item) => {
  //     allAuthors.add(item.changed_by_name);
  // });
  return Array.from(allAuthors);
};
var getFavouriteIcon = exports.getFavouriteIcon = function getFavouriteIcon(isFavourite) {
  return isFavourite ? 'star-favorites-active' : 'star-favorites-default';
};
var getFavouriteText = exports.getFavouriteText = function getFavouriteText(isFavourite) {
  return isFavourite ? 'Remove from favourites' : 'Add to favourites';
};

/***/ }),

/***/ 3713:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.CardContextMenuItemKey = void 0;
var CardContextMenuItemKey = exports.CardContextMenuItemKey = /*#__PURE__*/function (CardContextMenuItemKey) {
  CardContextMenuItemKey["Duplicate"] = "duplicate";
  CardContextMenuItemKey["Edit"] = "edit";
  CardContextMenuItemKey["Export"] = "export";
  CardContextMenuItemKey["Hide"] = "hide";
  CardContextMenuItemKey["Share"] = "share";
  return CardContextMenuItemKey;
}({});

/***/ }),

/***/ 85376:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.store = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _effects = __webpack_require__(34857);
var _analytics = __webpack_require__(19999);
var _analytics2 = __webpack_require__(66948);
var _appConfig = __webpack_require__(89887);
var _marked = /*#__PURE__*/_regenerator.default.mark(combinedSaga);
/* global window */
function combinedSaga() {
  return _regenerator.default.wrap(function combinedSaga$(_context) {
    while (1) switch (_context.prev = _context.next) {
      case 0:
        if (false) {}
        _context.prev = 1;
        _context.next = 4;
        return (0, _effects.all)([(0, _effects.call)(_analytics.analyticsSaga)]);
      case 4:
        _context.next = 9;
        break;
      case 6:
        _context.prev = 6;
        _context.t0 = _context["catch"](1);
        // eslint-disable-next-line no-console,angular/log
        console.error('analytics root saga:', _context.t0);
      case 9:
        _context.next = 0;
        break;
      case 11:
      case "end":
        return _context.stop();
    }
  }, _marked, null, [[1, 6]]);
}
var store = exports.store = store || (0, _appConfig.enhanceStore)({
  analytics: _analytics2.analytics.reducer
}, combinedSaga);

/***/ }),

/***/ 92202:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _react2angular = __webpack_require__(96563);
__webpack_require__(45801);
__webpack_require__(85376);
var _analyticsPage = __webpack_require__(97270);
var _analyticsCarouselTile = __webpack_require__(2716);
var _analyticsDashboardPage = __webpack_require__(87810);
__webpack_require__(52236);
angular.module('xlrelease.analytics').component('analyticsPage', (0, _react2angular.react2angular)(_analyticsPage.AnalyticsPageProvider, ['filters', 'folder'])).component('analyticsCarouselTile', (0, _react2angular.react2angular)(_analyticsCarouselTile.AnalyticsCarouselTile, [])).component('analyticsDashboardPage', (0, _react2angular.react2angular)(_analyticsDashboardPage.AnalyticsDashboardPageProvider, ['dashboardId', 'folder']));

/***/ }),

/***/ 2716:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AnalyticsCarouselTile = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _colors = _interopRequireDefault(__webpack_require__(70925));
__webpack_require__(70686);
var followTheLeaderImageLink = 'static/24.1.10/styles/img/follow_the_leader.svg';
var softwareEngineerImageLink = 'static/24.1.10/styles/img/software_engineer.svg';
var userFlowImageLink = 'static/24.1.10/styles/img/user_flow.svg';
var businessAnalyticsImageLink = 'static/24.1.10/styles/img/business_analytics.svg';
var AnalyticsCarouselTile = exports.AnalyticsCarouselTile = function AnalyticsCarouselTile() {
  var analyticsPagesContent = [{
    button: {
      buttonCaption: 'View Analytics',
      buttonType: 'primary',
      onClick: function onClick() {
        return window.location.href = '#/analytics';
      }
    },
    description: 'Take a proactive approach to release management by swiftly addressing delays and efficiently handling gate tasks and dependencies. Gain valuable insights from an overview down to granular details within the release processes.',
    imageLink: followTheLeaderImageLink,
    title: 'Release Manager Dashboards'
  }, {
    button: {
      buttonCaption: 'View Analytics',
      buttonType: 'primary',
      onClick: function onClick() {
        return window.location.href = '#/analytics';
      }
    },
    description: 'Efficiently monitor team and application onboarding and maturation rates on the Digital.ai Release-orchestrated pipeline. Identify areas for improvement.',
    imageLink: softwareEngineerImageLink,
    title: 'DevOps COE Dashboards'
  }, {
    button: {
      buttonCaption: 'View Analytics',
      buttonType: 'primary',
      onClick: function onClick() {
        return window.location.href = '#/analytics';
      }
    },
    description: 'Gain insights on team adoption of services and automation via Workflows. Identify what works best and manage your developer platform as a product.',
    imageLink: userFlowImageLink,
    title: 'Workflow Analytics for Platform Teams'
  }, {
    button: {
      buttonCaption: 'View Analytics',
      buttonType: 'primary',
      onClick: function onClick() {
        return window.location.href = '#/analytics';
      }
    },
    description: "Unlock the potential of DORA Analytics to gain insights into your organization's DevOps practices within software development and delivery processes. Discover areas for improvement and drive meaningful change.",
    imageLink: businessAnalyticsImageLink,
    title: 'DORA Analytics'
  }];
  var analyticsPages = analyticsPagesContent.map(function (page) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "analytics-carousel-page-container",
      key: page.title
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "analytics-carousel-page-container-title"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
      variant: "h2"
    }, page.title), /*#__PURE__*/_react.default.createElement(_dotComponents.DotPill, {
      backgroundcolor: _colors.default.lightviolet,
      bordercolor: _colors.default.violet,
      icon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
        iconId: "crown"
      }),
      label: "Premium",
      variant: "outlined"
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "analytics-carousel-page-content"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "analytics-carousel-page-content-wrapper"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, null, page.description), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
      onClick: page.button.onClick,
      type: page.button.buttonType
    }, page.button.buttonCaption)), /*#__PURE__*/_react.default.createElement("img", {
      alt: "analytics tile image",
      src: page.imageLink
    })));
  });
  return /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotCarousel, {
    animation: "slide",
    autoPlay: true,
    backgroundColor: _colors.default.backgroundBlue,
    className: "analytics-carousel-tile",
    duration: 6,
    pagesContent: analyticsPages,
    pauseAutoPlayOnHover: true,
    progressIndicator: true
  }));
};

/***/ }),

/***/ 41416:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ApplicationsPageComponent = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
__webpack_require__(38398);
var ApplicationsPageComponent = exports.ApplicationsPageComponent = function ApplicationsPageComponent(_ref) {
  var onViewChange = _ref.onViewChange,
    setCreateApplicationView = _ref.setCreateApplicationView;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "applications-placeholder"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "applications"
  }, /*#__PURE__*/_react.default.createElement("img", {
    alt: "Applications",
    src: "static/24.1.10/include/applications-management/assets/applications.png",
    width: "300"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "applications-title"
  }, "Applications"), /*#__PURE__*/_react.default.createElement("div", {
    className: "applications-description"
  }, "Getting started with your applications. Create new applications in Argo CD or Digital.ai Deploy.", /*#__PURE__*/_react.default.createElement("div", {
    className: "applications-buttons"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    "data-testid": "discover-btn",
    onClick: function onClick() {
      return onViewChange();
    },
    type: "outlined"
  }, "Discover applications"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    className: "applications-create-btn",
    "data-testid": "create-btn",
    onClick: function onClick() {
      return setCreateApplicationView(true);
    },
    type: "primary"
  }, "Create application")))));
};

/***/ }),

/***/ 30382:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ApplicationsPageWrapper = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _managedApplicationTable = __webpack_require__(71047);
var _applicationsPage = __webpack_require__(41416);
var _hooks = __webpack_require__(96462);
var _managedApplication = __webpack_require__(55378);
var _managedApplication2 = __webpack_require__(72198);
var _applicationDiscoveryBasic = __webpack_require__(59293);
var _constants = __webpack_require__(15928);
var _workflow = __webpack_require__(39067);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var _applicationManagemen = _managedApplication2.applicationManagement.actions,
  loadManagedApplications = _applicationManagemen.loadManagedApplications,
  getFilters = _applicationManagemen.getFilters;
var init = _workflow.workflow.actions.init;
var ApplicationsPageWrapper = exports.ApplicationsPageWrapper = function ApplicationsPageWrapper(_ref) {
  var folder = _ref.folder;
  var dispatch = (0, _hooks.useAppDispatch)();
  (0, _react.useEffect)(function () {
    if (folder) {
      dispatch(getFilters(folder.id));
      dispatch(loadManagedApplications());
    }
  }, [folder]);
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isWizardView = _useState2[0],
    setIsWizardView = _useState2[1];
  var dataSize = (0, _hooks.useAppSelector)(_managedApplication.getCreatedApplicationsTotalCountSelector);
  var hasAnyData = dataSize > 0;
  var openWorkflowDrawer = function openWorkflowDrawer() {
    dispatch(init({
      categories: [_constants.DEFAULT_APPLICATION_SEARCH_CATEGORY]
    }));
  };
  var renderData = function renderData() {
    return /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, hasAnyData ? /*#__PURE__*/_react.default.createElement(_managedApplicationTable.ManagedApplicationTable, {
      folder: folder,
      setCreateApplicationView: openWorkflowDrawer
    }) : /*#__PURE__*/_react.default.createElement(_applicationsPage.ApplicationsPageComponent, {
      onViewChange: function onViewChange() {
        return setIsWizardView(true);
      },
      setCreateApplicationView: openWorkflowDrawer
    }));
  };
  var renderView = function renderView() {
    return isWizardView ? /*#__PURE__*/_react.default.createElement(_applicationDiscoveryBasic.BasicDiscovery, {
      closeWizard: function closeWizard() {
        return setIsWizardView(false);
      },
      folder: folder
    }) : renderData();
  };
  return !folder ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) : renderView();
};

/***/ }),

/***/ 47601:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ManagedApplicationTableComponentPortal = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _actionToolbar = __webpack_require__(29755);
var ManagedApplicationTableComponentPortal = exports.ManagedApplicationTableComponentPortal = function ManagedApplicationTableComponentPortal(_ref) {
  var onViewChange = _ref.onViewChange;
  return /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    onClick: function onClick() {
      return onViewChange();
    }
  }, "Create application"));
};

/***/ }),

/***/ 71047:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ManagedApplicationTable = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _managedApplication = __webpack_require__(9520);
var _managedApplicationTableComponent = __webpack_require__(47601);
var _hooks = __webpack_require__(96462);
var _managedApplication2 = __webpack_require__(72198);
var _managedApplication3 = __webpack_require__(55378);
var _dotComponents = __webpack_require__(92140);
var _constants = __webpack_require__(55872);
var _search = __webpack_require__(72523);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var _applicationManagemen = _managedApplication2.applicationManagement.actions,
  loadManagedApplications = _applicationManagemen.loadManagedApplications,
  setPage = _applicationManagemen.setPage,
  storeFilters = _applicationManagemen.storeFilters,
  setCondition = _applicationManagemen.setCondition;
var ManagedApplicationTableComponent = function ManagedApplicationTableComponent(_ref) {
  var folder = _ref.folder,
    setCreateApplicationView = _ref.setCreateApplicationView;
  var createdApplications = (0, _hooks.useAppSelector)(_managedApplication3.getCreatedApplicationsSelector);
  var count = (0, _hooks.useAppSelector)(_managedApplication3.getCreatedApplicationsCountSelector);
  var isLoading = (0, _hooks.useAppSelector)(_managedApplication3.getCreatedApplicationsLoadingSelector);
  var page = (0, _hooks.useAppSelector)(_managedApplication3.getCreatedApplicationsPageSelector);
  var condition = (0, _hooks.useAppSelector)(_managedApplication3.getConditionSelector);
  var _useState = (0, _react.useState)(undefined),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    filterTimeout = _useState2[0],
    setFilterTimeout = _useState2[1];
  var dispatch = (0, _hooks.useAppDispatch)();
  (0, _react.useEffect)(function () {
    dispatch(storeFilters());
  }, [page, condition]);
  (0, _react.useEffect)(function () {
    dispatch(loadManagedApplications());
  }, []);
  var _onPageChange = function onPageChange(newPage) {
    dispatch(setPage(newPage));
    dispatch(loadManagedApplications());
  };
  var onDisplayFilterChange = function onDisplayFilterChange(event) {
    var value = event.target.value;
    if (filterTimeout) {
      clearTimeout(filterTimeout);
      setFilterTimeout(undefined);
    }
    setFilterTimeout(setTimeout(function () {
      dispatch(setCondition(value));
    }, 500));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managedApplicationTableComponent.ManagedApplicationTableComponentPortal, {
    folder: folder,
    onViewChange: function onViewChange() {
      return setCreateApplicationView(true);
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "external-deployments-table"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "external-deployments-table-title"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "h1"
  }, "Applications (", count, ")"), /*#__PURE__*/_react.default.createElement(_search.Search, {
    defaultValue: condition,
    inputPlaceholder: "Type to filter",
    key: condition,
    onFilterChange: onDisplayFilterChange,
    searchClassNames: ['mtm', 'mbm']
  })), /*#__PURE__*/_react.default.createElement(_dotComponents.DotTable, {
    className: "external-deployments-table-header",
    columns: headerDefinitions,
    data: [],
    loading: isLoading,
    onUpdateData: function onUpdateData(order, orderBy) {
      return _onPageChange(_objectSpread(_objectSpread({}, page), {}, {
        folderId: folder.id,
        order: order,
        orderBy: orderBy
      }));
    },
    order: page.order,
    orderBy: page.orderBy
  }), count > 0 ? createdApplications.map(function (createdApplication) {
    return /*#__PURE__*/_react.default.createElement(_managedApplication.ManagedApplication, {
      folder: folder,
      key: createdApplication.applicationName,
      managedApplication: createdApplication
    });
  }) : condition && condition.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
    className: "empty-external-deployments-table"
  }, "No applications match the current filter criteria. Consider adjusting the filter values."), /*#__PURE__*/_react.default.createElement(_dotComponents.DotTablePagination, {
    count: count,
    onPageChange: function onPageChange(newPage) {
      return _onPageChange(_objectSpread(_objectSpread({}, page), {}, {
        folderId: folder.id,
        page: newPage
      }));
    },
    onRowsPerPageChange: function onRowsPerPageChange(event) {
      return _onPageChange(_objectSpread(_objectSpread({}, page), {}, {
        folderId: folder.id,
        page: 0,
        resultsPerPage: parseInt(event.target.value)
      }));
    },
    page: page.page,
    rowsPerPage: page.resultsPerPage,
    typography: "body1"
  })));
};
var headerDefinitions = [{
  align: undefined,
  id: _constants.COLUMN_APPLICATION_NAME,
  label: 'Application name',
  sortable: false,
  truncate: false,
  width: _constants.COLUMN_WIDTH
}, {
  align: undefined,
  id: _constants.COLUMN_MANAGED_BY,
  label: 'Managed by',
  sortable: false,
  truncate: false,
  width: _constants.COLUMN_WIDTH
}, {
  align: undefined,
  id: _constants.COLUMN_DATE_CREATED,
  label: 'Date created',
  sortable: false,
  truncate: false,
  width: _constants.COLUMN_WIDTH
}, {
  align: undefined,
  id: _constants.COLUMN_TARGET_DEPLOYMENT,
  label: 'Target deployment',
  sortable: false,
  truncate: false,
  width: _constants.COLUMN_WIDTH
}, {
  align: undefined,
  id: _constants.COLUMN_ENV_TAG,
  label: 'Environment tag',
  sortable: false,
  truncate: false,
  width: _constants.COLUMN_WIDTH
}, {
  align: undefined,
  id: _constants.COLUMN_TARGET_CONNECTION,
  label: 'Target Connection',
  sortable: false,
  truncate: false,
  width: _constants.COLUMN_WIDTH
}, {
  align: undefined,
  id: _constants.COLUMN_DEEP_LINK,
  sortable: false,
  truncate: false,
  width: _constants.COLUMN_WIDTH
}, {
  align: undefined,
  id: _constants.COLUMN_ACTIONS,
  sortable: false,
  truncate: false,
  width: _constants.COLUMN_WIDTH
}];
var ManagedApplicationTable = exports.ManagedApplicationTable = /*#__PURE__*/(0, _react.memo)(ManagedApplicationTableComponent);

/***/ }),

/***/ 9520:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ManagedApplication = exports.EDIT_BUTTON_ACTION = exports.DELETE_BUTTON_ACTION = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _moment = _interopRequireDefault(__webpack_require__(72897));
var _upperFirst = _interopRequireDefault(__webpack_require__(11700));
__webpack_require__(96715);
var _hooks = __webpack_require__(96462);
var _managedApplication = __webpack_require__(55378);
var _constants = __webpack_require__(71297);
var _externalDeployments = __webpack_require__(69041);
var _navigation = __webpack_require__(17523);
var _managedApplication2 = __webpack_require__(72198);
var _utils = __webpack_require__(19192);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var _folderExternalDeploy = _externalDeployments.folderExternalDeployments.actions,
  getAvailablePlugins = _folderExternalDeploy.getAvailablePlugins,
  setLiveDeploymentsPreconditionFilter = _folderExternalDeploy.setLiveDeploymentsPreconditionFilter;
var _applicationManagemen = _managedApplication2.applicationManagement.actions,
  navigateToWorkflow = _applicationManagemen.navigateToWorkflow,
  loadEditPermission = _applicationManagemen.loadEditPermission;
var navigateTo = _navigation.navigation.actions.navigateTo;
var EDIT_BUTTON_ACTION = exports.EDIT_BUTTON_ACTION = 'edit';
var DELETE_BUTTON_ACTION = exports.DELETE_BUTTON_ACTION = 'delete';
var ManagedApplicationComponent = function ManagedApplicationComponent(_ref) {
  var _validServerCards$fin;
  var folder = _ref.folder,
    managedApplication = _ref.managedApplication;
  var isManagedByRelease = managedApplication.managedBy === 'Release';
  var _managedApplication$c = managedApplication.connectionServer,
    targetConnection = _managedApplication$c.name,
    serverType = _managedApplication$c.type;
  var validServerCards = (0, _hooks.useAppSelector)(_managedApplication.getValidServerCards);
  var hasEditPermission = (0, _hooks.useAppSelector)(_managedApplication.getHasEditPipelinesPermission);
  var dispatch = (0, _hooks.useAppDispatch)();
  (0, _react.useEffect)(function () {
    dispatch(loadEditPermission(folder));
    dispatch(getAvailablePlugins(_constants.STATUS_HTTP_CONNECTION));
  }, []);
  var serverIcon = ((_validServerCards$fin = validServerCards.find(function (validServerCard) {
    return validServerCard.type === serverType;
  })) === null || _validServerCards$fin === void 0 ? void 0 : _validServerCards$fin.iconLocation) || '';
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    open = _useState2[0],
    setOpen = _useState2[1];
  var _useState3 = (0, _react.useState)(undefined),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    anchorEl = _useState4[0],
    setAnchorEl = _useState4[1];
  var handleToggle = function handleToggle(event) {
    setAnchorEl(event.currentTarget);
    setOpen(!open);
  };
  var menuItems = [{
    key: EDIT_BUTTON_ACTION,
    children: 'Edit'
  }, {
    key: DELETE_BUTTON_ACTION,
    children: 'Delete'
  }];
  var onItemSelect = function onItemSelect(managedApplicationId, deleteWorkflowId, updateWorkflowId) {
    return function (_event, _menuId, itemKey) {
      setOpen(false);
      if (itemKey === DELETE_BUTTON_ACTION) {
        dispatch(navigateToWorkflow({
          actionName: itemKey,
          managedApplicationId: managedApplicationId,
          workflowId: deleteWorkflowId
        }));
      } else if (itemKey === EDIT_BUTTON_ACTION) {
        dispatch(navigateToWorkflow({
          actionName: itemKey,
          managedApplicationId: managedApplicationId,
          workflowId: updateWorkflowId
        }));
      }
    };
  };
  var viewDeployments = function viewDeployments(app) {
    dispatch(setLiveDeploymentsPreconditionFilter({
      folderId: folder.id,
      applicationName: app
    }));
    dispatch(navigateTo({
      pathSuffix: "folders/".concat(folder.id, "/application-pipelines/external-deployments")
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_dotComponents.DotCard, {
    className: "created-application-card",
    key: managedApplication.applicationName
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-testid": "app".concat(managedApplication.applicationName)
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotCardContent, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "application-name-column",
    title: managedApplication.applicationName
  }, managedApplication.applicationName), /*#__PURE__*/_react.default.createElement("div", {
    className: "managed-by-column"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTooltip, {
    title: managedApplication.managedBy
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotPill, {
    backgroundcolor: isManagedByRelease ? '#E8EDF3 !important' : '#F3F5F6 !important',
    bordercolor: isManagedByRelease ? '#3D6C9E' : undefined,
    icon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      iconId: isManagedByRelease ? 'release' : 'lock'
    }),
    label: (0, _upperFirst.default)(managedApplication.managedBy),
    labelcolor: "#3B485C !important",
    size: "small",
    status: "success",
    variant: "outlined"
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "date-created-column"
  }, (0, _moment.default)(managedApplication.dateCreated).format('MMM DD, YYYY')), /*#__PURE__*/_react.default.createElement("div", {
    className: "target-deployment-column"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotAvatar, {
    alt: "ArgoCD Logo",
    imageSrc: serverIcon,
    size: "small"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "target-deployment-column-text"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTooltip, {
    title: (0, _utils.extractContentInLastBrackets)(managedApplication.applicationReference)
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "target-deployment-column-text"
  }, (0, _utils.extractContentInLastBrackets)(managedApplication.applicationReference))))), /*#__PURE__*/_react.default.createElement("div", {
    className: "environment-tag-column"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotPill, {
    backgroundcolor: "#E9F0E0 !important",
    bordercolor: "#498500",
    icon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      iconId: "environment"
    }),
    label: managedApplication.environmentTag,
    labelcolor: "#3B485C !important",
    size: "small",
    status: "success",
    variant: "outlined"
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "target-connection-column"
  }, targetConnection), /*#__PURE__*/_react.default.createElement("div", {
    className: "link-column"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    onClick: function onClick() {
      return viewDeployments(managedApplication.applicationName);
    },
    tooltip: "View deployments",
    type: "outlined"
  }, "View deployments")), /*#__PURE__*/_react.default.createElement("div", {
    className: "actions-column"
  }, hasEditPermission && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "actions"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
    iconId: "options",
    onClick: handleToggle
  })), /*#__PURE__*/_react.default.createElement(_dotComponents.DotMenu, {
    anchorEl: anchorEl,
    disablePortal: true,
    id: "actions-menu",
    menuItems: menuItems,
    onLeave: function onLeave() {
      return setOpen(false);
    },
    onSelect: onItemSelect(managedApplication.id, managedApplication.deleteWorkflowId, managedApplication.updateWorkflowId),
    open: open
  }))))));
};
var ManagedApplication = exports.ManagedApplication = /*#__PURE__*/(0, _react.memo)(ManagedApplicationComponent);

/***/ }),

/***/ 44220:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FolderApplicationsManagementPage = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _externalDeploymentsStore = __webpack_require__(64583);
var _applicationsPageWrapper = __webpack_require__(30382);
var FolderApplicationsManagementPage = exports.FolderApplicationsManagementPage = function FolderApplicationsManagementPage(_ref) {
  var folder = _ref.folder;
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _externalDeploymentsStore.store
  }, /*#__PURE__*/_react.default.createElement(_applicationsPageWrapper.ApplicationsPageWrapper, {
    folder: folder
  }));
};

/***/ }),

/***/ 55872:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.DEFAULT_MANAGED_APPLICATIONS_PAGE = exports.COLUMN_WIDTH = exports.COLUMN_TARGET_DEPLOYMENT = exports.COLUMN_TARGET_CONNECTION = exports.COLUMN_MANAGED_BY = exports.COLUMN_ENV_TAG = exports.COLUMN_DEEP_LINK = exports.COLUMN_DATE_CREATED = exports.COLUMN_APPLICATION_NAME = exports.COLUMN_ACTIONS = exports.APPLICATION_MANAGEMENT_SLICE_NAME = void 0;
var APPLICATION_MANAGEMENT_SLICE_NAME = exports.APPLICATION_MANAGEMENT_SLICE_NAME = 'applicationManagement';
var COLUMN_WIDTH = exports.COLUMN_WIDTH = '12.50%';
var COLUMN_APPLICATION_NAME = exports.COLUMN_APPLICATION_NAME = 'applicationName';
var COLUMN_MANAGED_BY = exports.COLUMN_MANAGED_BY = 'managedBy';
var COLUMN_DATE_CREATED = exports.COLUMN_DATE_CREATED = 'dateCreated';
var COLUMN_TARGET_DEPLOYMENT = exports.COLUMN_TARGET_DEPLOYMENT = 'targetDeployment';
var COLUMN_ENV_TAG = exports.COLUMN_ENV_TAG = 'environmentTag';
var COLUMN_TARGET_CONNECTION = exports.COLUMN_TARGET_CONNECTION = 'targetConnection';
var COLUMN_DEEP_LINK = exports.COLUMN_DEEP_LINK = 'deepLink';
var COLUMN_ACTIONS = exports.COLUMN_ACTIONS = 'actions';
var DEFAULT_PAGE_ORDER = 'asc';
var DEFAULT_PAGE_INDEX = 0;
var DEFAULT_RESULTS_PER_PAGE = 10;
var DEFAULT_FOLDER_ID = undefined;
var DEFAULT_MANAGED_APPLICATIONS_PAGE = exports.DEFAULT_MANAGED_APPLICATIONS_PAGE = {
  order: DEFAULT_PAGE_ORDER,
  page: DEFAULT_PAGE_INDEX,
  resultsPerPage: DEFAULT_RESULTS_PER_PAGE,
  folderId: DEFAULT_FOLDER_ID,
  orderBy: COLUMN_APPLICATION_NAME
};

/***/ }),

/***/ 72198:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.initialState = exports.applicationManagement = void 0;
var _toolkit = __webpack_require__(47054);
var _noop = _interopRequireDefault(__webpack_require__(50308));
var _constants = __webpack_require__(55872);
var _constants2 = __webpack_require__(71297);
var initialState = exports.initialState = {
  condition: _constants2.DEFAULT_CONDITION,
  count: 0,
  folderId: undefined,
  hasEditPipelinesPermission: true,
  isLoading: false,
  managedApplications: [],
  page: _constants.DEFAULT_MANAGED_APPLICATIONS_PAGE,
  templates: [],
  totalCount: 0,
  validServerCards: []
};
var applicationManagement = exports.applicationManagement = (0, _toolkit.createSlice)({
  name: _constants.APPLICATION_MANAGEMENT_SLICE_NAME,
  initialState: initialState,
  reducers: {
    setPage: function setPage(state, action) {
      state.page = action.payload;
    },
    loadManagedApplications: function loadManagedApplications(_state) {
      return (0, _noop.default)();
    },
    navigateToWorkflow: function navigateToWorkflow(_state, _action) {
      return (0, _noop.default)();
    },
    setCondition: function setCondition(state, action) {
      state.condition = action.payload;
    },
    setIsLoading: function setIsLoading(state, action) {
      state.isLoading = action.payload;
    },
    setManagedApplications: function setManagedApplications(state, action) {
      state.managedApplications = action.payload;
    },
    setManagedApplicationsCount: function setManagedApplicationsCount(state, action) {
      state.count = action.payload;
    },
    setManagedApplicationsTotalCount: function setManagedApplicationsTotalCount(state, action) {
      state.totalCount = action.payload;
    },
    storeFilters: function storeFilters(_state) {
      return (0, _noop.default)();
    },
    getFilters: function getFilters(state, action) {
      state.page.folderId = action.payload;
    },
    createManagedApplicationsFromWebhookSource: function createManagedApplicationsFromWebhookSource(_state, _action) {
      return (0, _noop.default)();
    },
    loadEditPermission: function loadEditPermission(_state, _action) {
      return (0, _noop.default)();
    },
    setEditPermission: function setEditPermission(state, action) {
      state.hasEditPipelinesPermission = action.payload;
    }
  }
});

/***/ }),

/***/ 46510:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createOrUpdateVariable = createOrUpdateVariable;
exports.executeCreateManagedApplicationsFromWebhookSourceAction = executeCreateManagedApplicationsFromWebhookSourceAction;
exports.executeFetchManagedApplicationsAction = executeFetchManagedApplicationsAction;
exports.getFiltersAction = getFiltersAction;
exports.loadEditPermissionAction = loadEditPermissionAction;
exports.managedApplicationSaga = managedApplicationSaga;
exports.navigateToWorkflowSaga = navigateToWorkflowSaga;
exports.storeFiltersAction = storeFiltersAction;
exports.toaster = void 0;
exports.withLoadingState = withLoadingState;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _effects = __webpack_require__(34857);
var _ids = _interopRequireDefault(__webpack_require__(39647));
var _http = __webpack_require__(26511);
var _managedApplication = __webpack_require__(72198);
var _workflow = __webpack_require__(39067);
var _variablesService = __webpack_require__(10758);
var _managedApplication2 = __webpack_require__(55378);
var _angularAccessor = _interopRequireDefault(__webpack_require__(81403));
var _toastrFactory = _interopRequireDefault(__webpack_require__(86846));
var _managedApplication3 = __webpack_require__(9520);
var _authenticator = __webpack_require__(78013);
var _permissionsConstants = __webpack_require__(88169);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var _marked = /*#__PURE__*/_regenerator.default.mark(withLoadingState),
  _marked2 = /*#__PURE__*/_regenerator.default.mark(storeFiltersAction),
  _marked3 = /*#__PURE__*/_regenerator.default.mark(executeFetchManagedApplicationsAction),
  _marked4 = /*#__PURE__*/_regenerator.default.mark(getFiltersAction),
  _marked5 = /*#__PURE__*/_regenerator.default.mark(executeCreateManagedApplicationsFromWebhookSourceAction),
  _marked6 = /*#__PURE__*/_regenerator.default.mark(navigateToWorkflowSaga),
  _marked7 = /*#__PURE__*/_regenerator.default.mark(loadEditPermissionAction),
  _marked8 = /*#__PURE__*/_regenerator.default.mark(createOrUpdateVariable),
  _marked9 = /*#__PURE__*/_regenerator.default.mark(managedApplicationSaga);
var _applicationManagemen = _managedApplication.applicationManagement.actions,
  createManagedApplicationsFromWebhookSource = _applicationManagemen.createManagedApplicationsFromWebhookSource,
  getFilters = _applicationManagemen.getFilters,
  loadManagedApplications = _applicationManagemen.loadManagedApplications,
  navigateToWorkflow = _applicationManagemen.navigateToWorkflow,
  setCondition = _applicationManagemen.setCondition,
  setIsLoading = _applicationManagemen.setIsLoading,
  setManagedApplications = _applicationManagemen.setManagedApplications,
  setManagedApplicationsCount = _applicationManagemen.setManagedApplicationsCount,
  setManagedApplicationsTotalCount = _applicationManagemen.setManagedApplicationsTotalCount,
  setPage = _applicationManagemen.setPage,
  storeFilters = _applicationManagemen.storeFilters,
  loadEditPermission = _applicationManagemen.loadEditPermission,
  setEditPermission = _applicationManagemen.setEditPermission;
var _workflow$actions = _workflow.workflow.actions,
  createWorkflowError = _workflow$actions.createWorkflowError,
  createWorkflowSuccess = _workflow$actions.createWorkflowSuccess,
  runWorkflow = _workflow$actions.runWorkflow;
var Ids = (0, _ids.default)();
var toaster = exports.toaster = (0, _toastrFactory.default)();
function withLoadingState(effect) {
  var result;
  return _regenerator.default.wrap(function withLoadingState$(_context) {
    while (1) switch (_context.prev = _context.next) {
      case 0:
        _context.prev = 0;
        _context.next = 3;
        return (0, _effects.put)(setIsLoading(true));
      case 3:
        _context.next = 5;
        return effect;
      case 5:
        result = _context.sent;
        return _context.abrupt("return", result);
      case 7:
        _context.prev = 7;
        _context.next = 10;
        return (0, _effects.put)(setIsLoading(false));
      case 10:
        return _context.finish(7);
      case 11:
      case "end":
        return _context.stop();
    }
  }, _marked, null, [[0,, 7, 11]]);
}
function storeFiltersAction() {
  var _yield$select, page, condition, clientSettings, FiltersQueryParams;
  return _regenerator.default.wrap(function storeFiltersAction$(_context2) {
    while (1) switch (_context2.prev = _context2.next) {
      case 0:
        _context2.next = 2;
        return (0, _effects.select)(_managedApplication2.getApplicationManagementState);
      case 2:
        _yield$select = _context2.sent;
        page = _yield$select.page;
        condition = _yield$select.condition;
        _context2.next = 7;
        return (0, _effects.call)(_angularAccessor.default, 'ClientSettings');
      case 7:
        clientSettings = _context2.sent;
        clientSettings.setManagedApplicationsFilters(_objectSpread(_objectSpread({}, page), {}, {
          condition: condition
        }));
        _context2.next = 11;
        return (0, _effects.call)(_angularAccessor.default, 'FiltersQueryParams');
      case 11:
        FiltersQueryParams = _context2.sent;
        FiltersQueryParams.update(_objectSpread(_objectSpread({}, page), {}, {
          condition: condition
        }));
      case 13:
      case "end":
        return _context2.stop();
    }
  }, _marked2);
}
function executeFetchManagedApplicationsAction() {
  var _yield$select2, page, condition, _yield$call, _yield$call$data, totalCount, count, managedApplications, _err$response, err, errServerData, errorMessage;
  return _regenerator.default.wrap(function executeFetchManagedApplicationsAction$(_context3) {
    while (1) switch (_context3.prev = _context3.next) {
      case 0:
        _context3.next = 2;
        return (0, _effects.select)(_managedApplication2.getApplicationManagementState);
      case 2:
        _yield$select2 = _context3.sent;
        page = _yield$select2.page;
        condition = _yield$select2.condition;
        _context3.prev = 5;
        _context3.next = 8;
        return (0, _effects.call)(withLoadingState, (0, _effects.call)(_http.httpGET, "api/v1/managed-application?page=".concat(page.page, "&folderId=").concat(page.folderId, "&resultsPerPage=").concat(page.resultsPerPage, "&condition=").concat(condition ? encodeURIComponent(condition) : ''), true));
      case 8:
        _yield$call = _context3.sent;
        _yield$call$data = _yield$call.data;
        totalCount = _yield$call$data.totalCount;
        count = _yield$call$data.count;
        managedApplications = _yield$call$data.managedApplications;
        _context3.next = 15;
        return (0, _effects.put)(setManagedApplications(managedApplications));
      case 15:
        _context3.next = 17;
        return (0, _effects.put)(setManagedApplicationsCount(count));
      case 17:
        _context3.next = 19;
        return (0, _effects.put)(setManagedApplicationsTotalCount(totalCount));
      case 19:
        _context3.next = 28;
        break;
      case 21:
        _context3.prev = 21;
        _context3.t0 = _context3["catch"](5);
        err = _context3.t0;
        errServerData = (_err$response = err.response) === null || _err$response === void 0 ? void 0 : _err$response.data;
        errorMessage = "Error fetching managed applications data. Check connection to ".concat(errServerData === null || errServerData === void 0 ? void 0 : errServerData.title, " HTTP Connection or check application logs for more details.");
        _context3.next = 28;
        return (0, _effects.call)(toaster.error, errorMessage);
      case 28:
      case "end":
        return _context3.stop();
    }
  }, _marked3, null, [[5, 21]]);
}
function getFiltersAction(action) {
  var folderId, clientSettings, filters, stateParams, condition;
  return _regenerator.default.wrap(function getFiltersAction$(_context4) {
    while (1) switch (_context4.prev = _context4.next) {
      case 0:
        folderId = action.payload;
        _context4.next = 3;
        return (0, _effects.call)(_angularAccessor.default, 'ClientSettings');
      case 3:
        clientSettings = _context4.sent;
        filters = clientSettings.getManagedApplicationsFilters();
        _context4.next = 7;
        return (0, _effects.call)(_angularAccessor.default, '$stateParams');
      case 7:
        stateParams = _context4.sent;
        condition = stateParams.condition;
        if (condition) filters.condition = condition;
        if (!filters) {
          _context4.next = 15;
          break;
        }
        _context4.next = 13;
        return (0, _effects.put)(setCondition(filters.condition));
      case 13:
        _context4.next = 15;
        return (0, _effects.put)(setPage({
          folderId: folderId,
          page: filters.page,
          order: filters.order,
          orderBy: filters.orderBy,
          resultsPerPage: filters.resultsPerPage
        }));
      case 15:
      case "end":
        return _context4.stop();
    }
  }, _marked4);
}
function executeCreateManagedApplicationsFromWebhookSourceAction(action) {
  var _action$payload, webhookSourceId, folderId;
  return _regenerator.default.wrap(function executeCreateManagedApplicationsFromWebhookSourceAction$(_context5) {
    while (1) switch (_context5.prev = _context5.next) {
      case 0:
        _action$payload = action.payload, webhookSourceId = _action$payload.webhookSourceId, folderId = _action$payload.folderId;
        _context5.next = 3;
        return (0, _effects.call)(withLoadingState, (0, _effects.call)(_http.httpPOST, "/api/v1/managed-application/create-from-webhook-source/".concat(webhookSourceId, "?folderId=").concat(folderId)));
      case 3:
        _context5.next = 5;
        return (0, _effects.call)(toaster.success, "Successfully created managed applications from discovered applications");
      case 5:
      case "end":
        return _context5.stop();
    }
  }, _marked5);
}
function navigateToWorkflowSaga(action) {
  var _action$payload2, actionName, managedApplicationId, workflowId, _yield$call2, managedApplication, _yield$select3, page, variables, updatedWorkflowVariables;
  return _regenerator.default.wrap(function navigateToWorkflowSaga$(_context6) {
    while (1) switch (_context6.prev = _context6.next) {
      case 0:
        _action$payload2 = action.payload, actionName = _action$payload2.actionName, managedApplicationId = _action$payload2.managedApplicationId, workflowId = _action$payload2.workflowId;
        if (!workflowId) {
          _context6.next = 49;
          break;
        }
        _context6.next = 4;
        return (0, _effects.call)(_http.httpGET, "api/v1/managed-application/".concat(managedApplicationId));
      case 4:
        _yield$call2 = _context6.sent;
        managedApplication = _yield$call2.data;
        _context6.next = 8;
        return (0, _effects.select)(_managedApplication2.getApplicationManagementState);
      case 8:
        _yield$select3 = _context6.sent;
        page = _yield$select3.page;
        _context6.next = 12;
        return (0, _effects.call)(_variablesService.getReleaseVariables, workflowId, true);
      case 12:
        variables = _context6.sent;
        _context6.next = 15;
        return (0, _effects.call)(createOrUpdateVariable, workflowId, variables, 'managedApplicationId', managedApplicationId, 'xlrelease.StringVariable');
      case 15:
        _context6.t0 = _context6.sent;
        _context6.next = 18;
        return (0, _effects.call)(createOrUpdateVariable, workflowId, variables, 'applicationName', managedApplication.applicationName, 'xlrelease.StringVariable');
      case 18:
        _context6.t1 = _context6.sent;
        updatedWorkflowVariables = [_context6.t0, _context6.t1];
        if (!(actionName === _managedApplication3.EDIT_BUTTON_ACTION)) {
          _context6.next = 41;
          break;
        }
        _context6.t2 = updatedWorkflowVariables;
        _context6.next = 24;
        return (0, _effects.call)(createOrUpdateVariable, workflowId, variables, 'environmentTag', managedApplication.environmentTag, 'xlrelease.StringVariable');
      case 24:
        _context6.t3 = _context6.sent;
        _context6.next = 27;
        return (0, _effects.call)(createOrUpdateVariable, workflowId, variables, 'managedBy', managedApplication.managedBy, 'xlrelease.StringVariable');
      case 27:
        _context6.t4 = _context6.sent;
        _context6.next = 30;
        return (0, _effects.call)(createOrUpdateVariable, workflowId, variables, 'clusterUrl', managedApplication.applicationReference, 'xlrelease.StringVariable');
      case 30:
        _context6.t5 = _context6.sent;
        _context6.next = 33;
        return (0, _effects.call)(createOrUpdateVariable, workflowId, variables, 'folderId', managedApplication.folderId, 'xlrelease.StringVariable');
      case 33:
        _context6.t6 = _context6.sent;
        _context6.next = 36;
        return (0, _effects.call)(createOrUpdateVariable, workflowId, variables, 'deleteWorkflowId', managedApplication.deleteWorkflowId, 'xlrelease.StringVariable');
      case 36:
        _context6.t7 = _context6.sent;
        _context6.next = 39;
        return (0, _effects.call)(createOrUpdateVariable, workflowId, variables, 'updateWorkflowId', managedApplication.updateWorkflowId, 'xlrelease.StringVariable');
      case 39:
        _context6.t8 = _context6.sent;
        _context6.t2.push.call(_context6.t2, _context6.t3, _context6.t4, _context6.t5, _context6.t6, _context6.t7, _context6.t8);
      case 41:
        _context6.next = 43;
        return (0, _effects.put)(runWorkflow({
          folderId: page.folderId,
          workflow: {
            id: workflowId
          }
        }));
      case 43:
        _context6.next = 45;
        return (0, _effects.race)({
          error: (0, _effects.take)(createWorkflowError.type),
          success: (0, _effects.take)(createWorkflowSuccess.type)
        });
      case 45:
        _context6.next = 47;
        return (0, _effects.all)(updatedWorkflowVariables.map(function (v) {
          return (0, _effects.call)(_variablesService.updateReleaseVariable, _objectSpread(_objectSpread({}, v), {}, {
            value: ''
          }));
        }));
      case 47:
        _context6.next = 60;
        break;
      case 49:
        if (!(actionName === _managedApplication3.DELETE_BUTTON_ACTION)) {
          _context6.next = 58;
          break;
        }
        _context6.next = 52;
        return (0, _effects.call)(_http.httpDELETE, "api/v1/managed-application/".concat(managedApplicationId));
      case 52:
        _context6.next = 54;
        return (0, _effects.call)(toaster.info, "Selected managed application has no connected ".concat(actionName, " workflow,\n            this action triggered deletion of Managed Application only in the Digital.a Release system"));
      case 54:
        _context6.next = 56;
        return (0, _effects.put)(loadManagedApplications());
      case 56:
        _context6.next = 60;
        break;
      case 58:
        _context6.next = 60;
        return (0, _effects.call)(toaster.error, "Selected managed application has no connected ".concat(actionName, " workflow"));
      case 60:
      case "end":
        return _context6.stop();
    }
  }, _marked6);
}
function loadEditPermissionAction(action) {
  var folder, hasEditPermission;
  return _regenerator.default.wrap(function loadEditPermissionAction$(_context7) {
    while (1) switch (_context7.prev = _context7.next) {
      case 0:
        folder = action.payload;
        _context7.next = 3;
        return (0, _effects.call)(_authenticator.hasAnyOfPermissions, [_permissionsConstants.Permissions.EDIT_APP_PIPELINES], folder.$metadata);
      case 3:
        hasEditPermission = _context7.sent;
        _context7.next = 6;
        return (0, _effects.put)(setEditPermission(hasEditPermission));
      case 6:
      case "end":
        return _context7.stop();
    }
  }, _marked7);
}

// eslint-disable-next-line max-params
function createOrUpdateVariable(workflowId, variables, key, value, type) {
  var variable, newVariable, _yield$call3, data;
  return _regenerator.default.wrap(function createOrUpdateVariable$(_context8) {
    while (1) switch (_context8.prev = _context8.next) {
      case 0:
        variable = variables.find(function (v) {
          return v.key === key;
        });
        if (!variable) {
          _context8.next = 6;
          break;
        }
        _context8.next = 4;
        return (0, _effects.call)(_variablesService.updateReleaseVariable, _objectSpread(_objectSpread({}, variable), {}, {
          value: value
        }));
      case 4:
        _context8.next = 12;
        break;
      case 6:
        newVariable = {
          id: null,
          key: key,
          requiresValue: false,
          showOnReleaseStart: false,
          type: type,
          value: value
        };
        _context8.next = 9;
        return (0, _effects.call)(_http.httpPOST, "api/v1/releases/".concat(Ids.toDomainId(workflowId), "/variables"), newVariable);
      case 9:
        _yield$call3 = _context8.sent;
        data = _yield$call3.data;
        variable = data;
      case 12:
        return _context8.abrupt("return", variable);
      case 13:
      case "end":
        return _context8.stop();
    }
  }, _marked8);
}
function managedApplicationSaga() {
  return _regenerator.default.wrap(function managedApplicationSaga$(_context9) {
    while (1) switch (_context9.prev = _context9.next) {
      case 0:
        _context9.next = 2;
        return (0, _effects.all)([(0, _effects.takeEvery)(createManagedApplicationsFromWebhookSource, executeCreateManagedApplicationsFromWebhookSourceAction), (0, _effects.takeEvery)(getFilters, getFiltersAction), (0, _effects.takeLatest)(loadManagedApplications, executeFetchManagedApplicationsAction), (0, _effects.takeLatest)(navigateToWorkflow, navigateToWorkflowSaga), (0, _effects.takeEvery)(storeFilters, storeFiltersAction), (0, _effects.takeEvery)(loadEditPermission, loadEditPermissionAction)]);
      case 2:
      case "end":
        return _context9.stop();
    }
  }, _marked9);
}

/***/ }),

/***/ 55378:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getValidServerCards = exports.getTemplates = exports.getHasEditPipelinesPermission = exports.getCreatedApplicationsTotalCountSelector = exports.getCreatedApplicationsSelector = exports.getCreatedApplicationsPageSelector = exports.getCreatedApplicationsLoadingSelector = exports.getCreatedApplicationsCountSelector = exports.getConditionSelector = exports.getApplicationManagementState = void 0;
var getTemplates = exports.getTemplates = function getTemplates(state) {
  return getApplicationManagementState(state).templates;
};
var getApplicationManagementState = exports.getApplicationManagementState = function getApplicationManagementState(state) {
  return state.applicationManagement;
};
var getCreatedApplicationsSelector = exports.getCreatedApplicationsSelector = function getCreatedApplicationsSelector(state) {
  return getApplicationManagementState(state).managedApplications;
};
var getCreatedApplicationsCountSelector = exports.getCreatedApplicationsCountSelector = function getCreatedApplicationsCountSelector(state) {
  return getApplicationManagementState(state).count;
};
var getCreatedApplicationsTotalCountSelector = exports.getCreatedApplicationsTotalCountSelector = function getCreatedApplicationsTotalCountSelector(state) {
  return getApplicationManagementState(state).totalCount;
};
var getCreatedApplicationsLoadingSelector = exports.getCreatedApplicationsLoadingSelector = function getCreatedApplicationsLoadingSelector(state) {
  return getApplicationManagementState(state).isLoading;
};
var getCreatedApplicationsPageSelector = exports.getCreatedApplicationsPageSelector = function getCreatedApplicationsPageSelector(state) {
  return getApplicationManagementState(state).page;
};
var getValidServerCards = exports.getValidServerCards = function getValidServerCards(state) {
  return getApplicationManagementState(state).validServerCards;
};
var getConditionSelector = exports.getConditionSelector = function getConditionSelector(state) {
  return getApplicationManagementState(state).condition;
};
var getHasEditPipelinesPermission = exports.getHasEditPipelinesPermission = function getHasEditPipelinesPermission(state) {
  return getApplicationManagementState(state).hasEditPipelinesPermission;
};

/***/ }),

/***/ 19192:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.extractContentInLastBrackets = void 0;
var extractContentInLastBrackets = exports.extractContentInLastBrackets = function extractContentInLastBrackets(input) {
  var start = input.lastIndexOf('[');
  var end = input.lastIndexOf(']');
  if (start !== -1 && end !== -1) return input.slice(start + 1, end);
  return input;
};

/***/ }),

/***/ 84954:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ApplicationSource = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _hooks = __webpack_require__(96462);
var _externalDeployments = __webpack_require__(69041);
var _externalDeployments2 = __webpack_require__(12098);
__webpack_require__(94111);
var _filterApplicationsComponent = __webpack_require__(22303);
var _navigation = __webpack_require__(17523);
var _noop = _interopRequireDefault(__webpack_require__(50308));
var _constants = __webpack_require__(71297);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var navigateTo = _navigation.navigation.actions.navigateTo;
var getAvailablePlugins = _externalDeployments.folderExternalDeployments.actions.getAvailablePlugins;
var _folderExternalDeploy = _externalDeployments.folderExternalDeployments.actions,
  loadServers = _folderExternalDeploy.loadServers,
  loadWebhookSources = _folderExternalDeploy.loadWebhookSources,
  loadExternalDeployments = _folderExternalDeploy.loadExternalDeployments,
  getFilters = _folderExternalDeploy.getFilters,
  deleteWebhookSource = _folderExternalDeploy.deleteWebhookSource,
  updateBreadcrumbs = _folderExternalDeploy.updateBreadcrumbs;
var APPLICATION_SOURCE_TABLE_COLUMNS = [{
  id: 'server',
  label: 'Server',
  sortable: false,
  truncate: true,
  width: '30%'
}, {
  id: 'webhook',
  label: 'Webhook',
  sortable: false,
  truncate: true,
  width: '30%'
}, {
  id: 'status',
  label: 'Status',
  sortable: false,
  truncate: true,
  width: '25%'
}, {
  id: 'action',
  label: 'Action',
  sortable: false,
  truncate: true,
  width: '15%'
}];
var ApplicationSourceComponent = function ApplicationSourceComponent(props) {
  var folder = props.folder;
  var servers = (0, _hooks.useAppSelector)(_externalDeployments2.getServersSelector);
  var webhookSources = (0, _hooks.useAppSelector)(_externalDeployments2.getWebhookSourcesSelector);
  var disconnectedServers = (0, _hooks.useAppSelector)(_externalDeployments2.getDisconnectedServers);
  var validServerCards = (0, _hooks.useAppSelector)(_externalDeployments2.getValidServerCards);
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isDialogOpen = _useState2[0],
    setIsDialogOpen = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    isEditMode = _useState4[0],
    setIsEditMode = _useState4[1];
  var _useState5 = (0, _react.useState)(undefined),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    selectedServer = _useState6[0],
    setSelectedServer = _useState6[1];
  var _useState7 = (0, _react.useState)(undefined),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    selectedWebhookSource = _useState8[0],
    setSelectedWebhookSource = _useState8[1];
  var dispatch = (0, _hooks.useAppDispatch)();
  (0, _react.useEffect)(function () {
    dispatch(getFilters(folder.id));
    dispatch(loadWebhookSources(folder.id));
    dispatch(loadExternalDeployments());
    dispatch(updateBreadcrumbs(folder));
    dispatch(loadServers(folder.id));
    dispatch(getAvailablePlugins(_constants.STATUS_HTTP_CONNECTION));
  }, []);
  var goBack = function goBack() {
    return dispatch(navigateTo({
      pathSuffix: "folders/".concat(folder.id, "/application-pipelines/external-deployments")
    }));
  };
  var onDeleteButtonClick = function onDeleteButtonClick(webhookSource) {
    setSelectedWebhookSource(webhookSource);
    setIsDialogOpen(true);
  };
  var onDeleteConfirmed = function onDeleteConfirmed() {
    if (selectedWebhookSource && selectedWebhookSource.id) {
      dispatch(deleteWebhookSource(selectedWebhookSource.id));
      setIsDialogOpen(false);
    }
  };
  var onEditButtonClick = function onEditButtonClick(webhookSource) {
    var serverSelected = servers.find(function (server) {
      return server.id === webhookSource.sourceServer;
    });
    setSelectedServer(serverSelected);
    setSelectedWebhookSource(webhookSource);
    setIsEditMode(true);
  };
  var getImage = function getImage(src, title) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "application-source-img"
    }, /*#__PURE__*/_react.default.createElement("img", {
      alt: title,
      src: src
    }), title);
  };
  var getServerTitleByServerId = function getServerTitleByServerId(serverId) {
    var serverSelected = servers.find(function (server) {
      return server.id === serverId;
    });
    var plugin = validServerCards.find(function (validServerCard) {
      return validServerCard.type === (serverSelected === null || serverSelected === void 0 ? void 0 : serverSelected.type);
    });
    return serverSelected && plugin ? getImage(plugin.iconLocation, serverSelected.title) : '';
  };
  var getTableActions = function getTableActions(webhookSource) {
    return /*#__PURE__*/_react.default.createElement(_dotComponents.DotTableActions, {
      actions: [{
        iconId: 'edit',
        id: 'edit',
        label: 'Edit',
        onClick: function onClick() {
          return onEditButtonClick(webhookSource);
        },
        tooltip: 'Edit'
      }, {
        iconId: 'delete',
        id: 'delete',
        label: 'Delete',
        onClick: function onClick() {
          return onDeleteButtonClick(webhookSource);
        },
        tooltip: 'Delete'
      }],
      id: webhookSource.id || ''
    });
  };
  var getConnectionStatus = function getConnectionStatus(serverId) {
    var connected = !disconnectedServers.includes(serverId);
    return /*#__PURE__*/_react.default.createElement(_dotComponents.DotChip, {
      className: connected ? 'application-source-status-success' : '',
      error: !connected,
      isDeletable: false,
      size: "small",
      startIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
        className: connected ? 'success' : 'error',
        iconId: connected ? 'check-solid' : 'error-solid'
      })
    }, connected ? 'Connected' : 'Disconnected');
  };
  var tableData = webhookSources.map(function (webhookSource) {
    return {
      id: webhookSource.id ? webhookSource.id : undefined,
      rowData: {
        action: getTableActions(webhookSource),
        status: getConnectionStatus(webhookSource.sourceServer || ''),
        webhook: getImage(_constants.IMG_SRC.webhookSource, webhookSource.title),
        server: getServerTitleByServerId(webhookSource.sourceServer)
      }
    };
  });
  return /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, !isEditMode && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "application-source"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "h1"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
    iconId: "back",
    iconSize: "medium",
    onClick: goBack,
    size: "medium",
    tooltip: "Back"
  }), "Application sources"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotTable, {
    className: "application-source-table",
    columns: APPLICATION_SOURCE_TABLE_COLUMNS,
    data: tableData,
    onUpdateData: _noop.default
  })), /*#__PURE__*/_react.default.createElement(_dotComponents.DotConfirmationDialog, {
    className: "application-source-dialog",
    message: /*#__PURE__*/_react.default.createElement("p", null, "You are about to ", /*#__PURE__*/_react.default.createElement("b", null, "DELETE Application source and endpoint"), ". Click ", /*#__PURE__*/_react.default.createElement("b", null, "Delete source and endpoint"), " to confirm", ' '),
    onCancel: function onCancel() {
      return setIsDialogOpen(false);
    },
    onSubmit: function onSubmit() {
      return onDeleteConfirmed();
    },
    open: isDialogOpen,
    submitButtonProps: {
      label: 'Delete source and endpoint',
      startIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
        iconId: "delete"
      }),
      type: 'destructive'
    },
    title: /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
      variant: "h1"
    }, "Delete application source")
  })), isEditMode && /*#__PURE__*/_react.default.createElement(_filterApplicationsComponent.FilterApplications, {
    createManagedApplications: false,
    folder: folder,
    onCancel: function onCancel() {
      return setIsEditMode(false);
    },
    onFilterBack: function onFilterBack() {
      return setIsEditMode(false);
    },
    onSave: function onSave() {
      return setIsEditMode(false);
    },
    plugins: validServerCards,
    server: selectedServer,
    webhookSource: selectedWebhookSource
  }));
};
var ApplicationSource = exports.ApplicationSource = /*#__PURE__*/(0, _react.memo)(ApplicationSourceComponent);

/***/ }),

/***/ 20189:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FolderApplicationSourcePage = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _externalDeploymentsStore = __webpack_require__(64583);
var _applicationSource = __webpack_require__(84954);
var FolderApplicationSourcePage = exports.FolderApplicationSourcePage = function FolderApplicationSourcePage(_ref) {
  var folder = _ref.folder;
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _externalDeploymentsStore.store
  }, /*#__PURE__*/_react.default.createElement(_applicationSource.ApplicationSource, {
    folder: folder
  }));
};

/***/ }),

/***/ 24229:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ExternalDeploymentComponentPortal = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _actionToolbar = __webpack_require__(29755);
var _hooks = __webpack_require__(96462);
var _externalDeployments = __webpack_require__(69041);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var refreshExternalDeployments = _externalDeployments.folderExternalDeployments.actions.refreshExternalDeployments;
var ExternalDeploymentComponentPortal = exports.ExternalDeploymentComponentPortal = function ExternalDeploymentComponentPortal(props) {
  var onViewChange = props.onViewChange,
    openApplicationSources = props.openApplicationSources,
    reSyncEnabled = props.reSyncEnabled;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isMenuOpen = _useState2[0],
    setIsMenuOpen = _useState2[1];
  var _useState3 = (0, _react.useState)(null),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    menuAnchorEl = _useState4[0],
    setMenuAnchorEl = _useState4[1];
  var dispatch = (0, _hooks.useAppDispatch)();
  var toggleMenu = function toggleMenu(event) {
    setMenuAnchorEl(event.currentTarget);
    setIsMenuOpen(!isMenuOpen);
  };
  return /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    disabled: !reSyncEnabled,
    onClick: function onClick() {
      return dispatch(refreshExternalDeployments());
    },
    startIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      iconId: "sync"
    }),
    type: "outlined"
  }, "Re-sync"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    onClick: function onClick() {
      return onViewChange();
    }
  }, "Discover applications"), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
    "data-testid": "application-deployments-menu",
    iconId: "options",
    onClick: toggleMenu
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotMenu, {
    anchorEl: menuAnchorEl || undefined,
    dense: true,
    id: "application-deployments-option",
    menuItems: [{
      children: 'Applications sources',
      key: 'Applications sources'
    }],
    menuPlacement: "bottom",
    onLeave: function onLeave() {
      return setIsMenuOpen(false);
    },
    onSelect: function onSelect() {
      return openApplicationSources();
    },
    open: isMenuOpen
  })));
};

/***/ }),

/***/ 55575:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ExternalDeployment = void 0;
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactMoment = _interopRequireDefault(__webpack_require__(94803));
var _upperFirst = _interopRequireDefault(__webpack_require__(11700));
var _camelCase = _interopRequireDefault(__webpack_require__(68929));
var _deburr = _interopRequireDefault(__webpack_require__(53816));
var _dotComponents = __webpack_require__(92140);
var _constants = __webpack_require__(71297);
var _utils = __webpack_require__(95461);
__webpack_require__(60003);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var ExternalDeploymentComponent = function ExternalDeploymentComponent(_ref) {
  var _ref$connectionServer = _ref.connectionServer,
    type = _ref$connectionServer.type,
    url = _ref$connectionServer.url,
    _ref$externalDeployme = _ref.externalDeployment,
    applicationUid = _ref$externalDeployme.applicationUid,
    applicationPath = _ref$externalDeployme.applicationPath,
    applicationName = _ref$externalDeployme.applicationName,
    state = _ref$externalDeployme.state,
    statusGroup = _ref$externalDeployme.statusGroup,
    pluginInfo = _ref.pluginInfo;
  return /*#__PURE__*/_react.default.createElement(_dotComponents.DotCard, {
    className: "external-deployment-card",
    key: applicationName
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-testid": 'app' + applicationName
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotCardContent, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "icon-column"
  }, /*#__PURE__*/_react.default.createElement("img", {
    alt: type,
    className: "server-icon",
    src: pluginInfo.iconLocation
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "application-name-column",
    title: applicationName
  }, applicationName), /*#__PURE__*/_react.default.createElement("div", {
    className: "environment-column"
  }, /*#__PURE__*/_react.default.createElement("img", {
    alt: "environment",
    className: "server-icon",
    src: _constants.IMG_SRC.environment
  }), /*#__PURE__*/_react.default.createElement("span", {
    title: (0, _utils.generateEnvironmentTitle)(state)
  }, (0, _utils.generateEnvironmentTitle)(state))), /*#__PURE__*/_react.default.createElement("div", {
    className: "version-column"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotLink, {
    "data-testid": "versionLabel-".concat(applicationUid, "-").concat(state.destination),
    href: (0, _utils.getVersionLink)(pluginInfo.isAutoconfigurable, state.versionTag.label, url, applicationPath),
    target: "_blank",
    tooltip: (0, _utils.getVersionTooltip)(pluginInfo.isAutoconfigurable, state.versionTag.label)
  }, (0, _utils.getVersionLabel)(pluginInfo.isAutoconfigurable, state.versionTag.label))), /*#__PURE__*/_react.default.createElement("div", {
    className: "status-column"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotPill, {
    label: (0, _upperFirst.default)((0, _camelCase.default)((0, _deburr.default)(state.deploymentStatus))),
    size: "small",
    status: statusGroup
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "last-updated-column"
  }, /*#__PURE__*/_react.default.createElement(_reactMoment.default, {
    fromNow: true,
    interval: 30000
  }, state.lastChangeTime)), /*#__PURE__*/_react.default.createElement("div", {
    className: "link-column"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
    "data-testid": "deeplink-".concat(applicationUid, "-").concat(state.destination),
    iconId: "open-new-tab",
    onClick: function onClick() {
      return window.open((0, _utils.getDeepLink)(url, applicationPath), '_blank');
    },
    size: "small",
    tooltip: "Open application"
  })))));
};
var ExternalDeployment = exports.ExternalDeployment = /*#__PURE__*/(0, _react.memo)(ExternalDeploymentComponent);

/***/ }),

/***/ 60894:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ExternalDeploymentsTable = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _externalDeployments = __webpack_require__(69041);
var _externalDeployments2 = __webpack_require__(12098);
__webpack_require__(26397);
var _externalDeployment = __webpack_require__(55575);
var _hooks = __webpack_require__(96462);
var _externalDeploymentComponent = __webpack_require__(24229);
var _constants = __webpack_require__(71297);
var _search = __webpack_require__(72523);
var _navigation = __webpack_require__(17523);
var _applicationCreateServerComponent = __webpack_require__(89175);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var navigateTo = _navigation.navigation.actions.navigateTo;
var _folderExternalDeploy = _externalDeployments.folderExternalDeployments.actions,
  getFilters = _folderExternalDeploy.getFilters,
  loadExternalDeployments = _folderExternalDeploy.loadExternalDeployments,
  setCondition = _folderExternalDeploy.setCondition,
  storeFilters = _folderExternalDeploy.storeFilters,
  setPage = _folderExternalDeploy.setPage,
  subscribeToSseStream = _folderExternalDeploy.subscribeToSseStream,
  unsubscribeFromSseStream = _folderExternalDeploy.unsubscribeFromSseStream,
  getAvailablePlugins = _folderExternalDeploy.getAvailablePlugins;
var ExternalDeploymentsTableComponent = function ExternalDeploymentsTableComponent(_ref) {
  var folder = _ref.folder,
    onViewChange = _ref.onViewChange;
  var isLoading = (0, _hooks.useAppSelector)(_externalDeployments2.getIsLoadingSelector);
  var externalDeployments = (0, _hooks.useAppSelector)(_externalDeployments2.getExternalDeploymentsSelector);
  var connectionServers = (0, _hooks.useAppSelector)(_externalDeployments2.getConnectionServersSelector);
  var count = (0, _hooks.useAppSelector)(_externalDeployments2.getExternalDeploymentCountSelector);
  var page = (0, _hooks.useAppSelector)(_externalDeployments2.getExternalDeploymentPageSelector);
  var condition = (0, _hooks.useAppSelector)(_externalDeployments2.getConditionSelector);
  var connectionErrors = (0, _hooks.useAppSelector)(_externalDeployments2.getConnectionErrorsSelector);
  var validServerCards = (0, _hooks.useAppSelector)(_externalDeployments2.getValidServerCards);
  var disconnectedServers = (0, _hooks.useAppSelector)(_externalDeployments2.getDisconnectedServers);
  var servers = (0, _hooks.useAppSelector)(_externalDeployments2.getServersSelector);
  var dispatch = (0, _hooks.useAppDispatch)();
  var _useState = (0, _react.useState)(undefined),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    filterTimeout = _useState2[0],
    setFilterTimeout = _useState2[1];
  var _useState3 = (0, _react.useState)(''),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    selectedErrorServer = _useState4[0],
    setSelectedErrorServer = _useState4[1];
  var _useState5 = (0, _react.useState)(false),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    isServerFormOpen = _useState6[0],
    setServerFormOpen = _useState6[1];
  (0, _react.useEffect)(function () {
    dispatch(getFilters(folder.id));
    dispatch(subscribeToSseStream());
    dispatch(getAvailablePlugins(_constants.STATUS_HTTP_CONNECTION));
    return function () {
      dispatch(unsubscribeFromSseStream());
    };
  }, []);
  (0, _react.useEffect)(function () {
    dispatch(storeFilters());
  }, [page, condition]);
  (0, _react.useEffect)(function () {
    dispatch(loadExternalDeployments());
  }, [servers]);
  var _onPageChange = function onPageChange(newPage) {
    dispatch(setPage(newPage));
    dispatch(loadExternalDeployments());
  };
  var onDisplayFilterChange = function onDisplayFilterChange(event) {
    var value = event.target.value;
    if (filterTimeout) {
      clearTimeout(filterTimeout);
      setFilterTimeout(undefined);
    }
    setFilterTimeout(setTimeout(function () {
      dispatch(setCondition(value));
    }, 500));
  };
  var onServerErrorClick = function onServerErrorClick(err) {
    var errServer = disconnectedServers.find(function (s) {
      return err.includes(s);
    });
    if (errServer) {
      setSelectedErrorServer(errServer);
      setServerFormOpen(true);
    }
  };
  var onServerFormClose = function onServerFormClose() {
    setServerFormOpen(false);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isServerFormOpen ? /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, /*#__PURE__*/_react.default.createElement(_applicationCreateServerComponent.CreateServerForm, {
    closeForm: function closeForm() {
      return onServerFormClose();
    },
    folder: folder,
    serverId: selectedErrorServer
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_externalDeploymentComponent.ExternalDeploymentComponentPortal, {
    folder: folder,
    onViewChange: onViewChange,
    openApplicationSources: function openApplicationSources() {
      return dispatch(navigateTo({
        pathSuffix: "folders/".concat(folder.id, "/application-pipelines/external-deployments/application-sources")
      }));
    },
    reSyncEnabled: true
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "external-deployments-table"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "external-deployments-table-title"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "h1"
  }, "Application deployments (", count, ")"), /*#__PURE__*/_react.default.createElement(_search.Search, {
    defaultValue: condition,
    inputPlaceholder: "Type to filter",
    key: condition,
    onFilterChange: onDisplayFilterChange,
    searchClassNames: ['mtm', 'mbm']
  })), connectionErrors.length > 0 && /*#__PURE__*/_react.default.createElement(_dotComponents.DotTooltip, {
    className: "external-deployments-connection-errors",
    placement: "bottom-start",
    title: /*#__PURE__*/_react.default.createElement("div", null, connectionErrors.map(function (e) {
      return /*#__PURE__*/_react.default.createElement("div", {
        key: e
      }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotLink, {
        onClick: function onClick() {
          return onServerErrorClick(e);
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        style: {
          color: 'white',
          textDecoration: 'underline'
        }
      }, e)));
    }))
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
    iconId: "error-solid"
  }), connectionErrors.length, " disconnected servers")), /*#__PURE__*/_react.default.createElement(_dotComponents.DotTable, {
    className: "external-deployments-table-header",
    columns: headerDefinitions,
    data: [],
    loading: isLoading,
    onUpdateData: function onUpdateData(order, orderBy) {
      return _onPageChange(_objectSpread(_objectSpread({}, page), {}, {
        folderId: folder.id,
        order: order,
        orderBy: orderBy
      }));
    },
    order: page.order,
    orderBy: page.orderBy
  }), count > 0 ? externalDeployments.map(function (externalDeployment) {
    var connectionServer = connectionServers.get(externalDeployment.endpointId);
    var pluginInfo = validServerCards.find(function (validServerCard) {
      return (connectionServer === null || connectionServer === void 0 ? void 0 : connectionServer.type) === validServerCard.type;
    });
    return connectionServer && pluginInfo && /*#__PURE__*/_react.default.createElement(_externalDeployment.ExternalDeployment, {
      connectionServer: connectionServer,
      externalDeployment: externalDeployment,
      key: "".concat(externalDeployment.applicationUid, "-").concat(externalDeployment.state.destination),
      pluginInfo: pluginInfo
    });
  }) : condition && condition.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
    className: "empty-external-deployments-table"
  }, "No applications match the current filter criteria. Consider adjusting the filter values."), /*#__PURE__*/_react.default.createElement(_dotComponents.DotTablePagination, {
    count: count,
    onPageChange: function onPageChange(newPage) {
      return _onPageChange(_objectSpread(_objectSpread({}, page), {}, {
        folderId: folder.id,
        page: newPage
      }));
    },
    onRowsPerPageChange: function onRowsPerPageChange(event) {
      return _onPageChange(_objectSpread(_objectSpread({}, page), {}, {
        folderId: folder.id,
        page: _constants.DEFAULT_PAGE,
        resultsPerPage: parseInt(event.target.value)
      }));
    },
    page: page.page,
    rowsPerPage: page.resultsPerPage,
    typography: "body1"
  })))));
};
var headerDefinitions = [{
  align: 'left',
  id: 'icon',
  sortable: false,
  truncate: false,
  width: '3%'
}, {
  align: undefined,
  id: _constants.APPLICATION_COLUMN_ID,
  label: 'Application name',
  truncate: false,
  width: '20%'
}, {
  align: undefined,
  id: _constants.DESTINATION_COLUMN_ID,
  label: 'Environment',
  truncate: false,
  width: '20%'
}, {
  align: undefined,
  id: _constants.VERSION_COLUMN_ID,
  label: 'Version',
  truncate: false,
  width: '20%'
}, {
  align: undefined,
  id: _constants.STATUS_COLUMN_ID,
  label: 'Status',
  truncate: false,
  width: '16%'
}, {
  align: undefined,
  id: _constants.TIME_COLUMN_ID,
  label: 'Updated',
  truncate: false,
  width: '16%'
}, {
  align: 'right',
  id: 'deeplink',
  sortable: false,
  truncate: false,
  width: '5%'
}];
var ExternalDeploymentsTable = exports.ExternalDeploymentsTable = /*#__PURE__*/(0, _react.memo)(ExternalDeploymentsTableComponent);

/***/ }),

/***/ 11757:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FolderExternalDeploymentsWrapper = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _externalDeploymentsTable = __webpack_require__(60894);
var _applicationDiscoveryBasic = __webpack_require__(59293);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var FolderExternalDeploymentsWrapper = exports.FolderExternalDeploymentsWrapper = function FolderExternalDeploymentsWrapper(_ref) {
  var folder = _ref.folder;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isWizardView = _useState2[0],
    setIsWizardView = _useState2[1];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isWizardView ? /*#__PURE__*/_react.default.createElement(_applicationDiscoveryBasic.BasicDiscovery, {
    closeWizard: function closeWizard() {
      return setIsWizardView(false);
    },
    folder: folder
  }) : /*#__PURE__*/_react.default.createElement(_externalDeploymentsTable.ExternalDeploymentsTable, {
    folder: folder,
    onViewChange: function onViewChange() {
      return setIsWizardView(true);
    }
  }));
};

/***/ }),

/***/ 39985:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FolderExternalDeploymentsPage = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _externalDeploymentsStore = __webpack_require__(64583);
var _folderExternalDeploymentsWrapper = __webpack_require__(11757);
var FolderExternalDeploymentsPage = exports.FolderExternalDeploymentsPage = function FolderExternalDeploymentsPage(_ref) {
  var folder = _ref.folder;
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _externalDeploymentsStore.store
  }, /*#__PURE__*/_react.default.createElement(_folderExternalDeploymentsWrapper.FolderExternalDeploymentsWrapper, {
    folder: folder
  }));
};

/***/ }),

/***/ 59293:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.BasicDiscovery = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _isNil = _interopRequireDefault(__webpack_require__(14293));
var _dotComponents = __webpack_require__(92140);
var _applicationCreateServerComponent = __webpack_require__(89175);
var _discoverModalComponent = __webpack_require__(22393);
var _hooks = __webpack_require__(96462);
__webpack_require__(74852);
var _filterApplicationsComponent = __webpack_require__(22303);
var _externalDeployments = __webpack_require__(69041);
var _externalDeployments2 = __webpack_require__(12098);
var _constants = __webpack_require__(71297);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var _folderExternalDeploy = _externalDeployments.folderExternalDeployments.actions,
  loadServers = _folderExternalDeploy.loadServers,
  loadWebhookSources = _folderExternalDeploy.loadWebhookSources,
  getAvailablePlugins = _folderExternalDeploy.getAvailablePlugins;
var _folderExternalDeploy2 = _externalDeployments.folderExternalDeployments.actions,
  setConfigDetails = _folderExternalDeploy2.setConfigDetails,
  setLiveUpdate = _folderExternalDeploy2.setLiveUpdate,
  setPreSelectedServer = _folderExternalDeploy2.setPreSelectedServer;
var ApplicationDiscoveryBasicComponent = function ApplicationDiscoveryBasicComponent(props) {
  var folder = props.folder,
    closeWizard = props.closeWizard;
  var configDetails = (0, _hooks.useAppSelector)(_externalDeployments2.getConfigDetailsSelector);
  var isLoading = (0, _hooks.useAppSelector)(_externalDeployments2.getIsLoadingSelector);
  var preSelected = (0, _hooks.useAppSelector)(_externalDeployments2.getPreSelectedServer);
  var servers = (0, _hooks.useAppSelector)(_externalDeployments2.getServersSelector);
  var webhookSources = (0, _hooks.useAppSelector)(_externalDeployments2.getWebhookSourcesSelector);
  var validServerCards = (0, _hooks.useAppSelector)(_externalDeployments2.getValidServerCards);
  var _useState = (0, _react.useState)(undefined),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    autoCreatedWebhook = _useState2[0],
    setAutoCreatedWebhook = _useState2[1];
  var _useState3 = (0, _react.useState)({}),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    selectedServers = _useState4[0],
    setSelectedServers = _useState4[1];
  var _useState5 = (0, _react.useState)(undefined),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    typeOfCreatedServer = _useState6[0],
    setTypeOfCreatedServer = _useState6[1];
  var _useState7 = (0, _react.useState)(undefined),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    discoverType = _useState8[0],
    setDiscoverType = _useState8[1];
  var _useState9 = (0, _react.useState)(undefined),
    _useState10 = (0, _slicedToArray2.default)(_useState9, 2),
    selectedServer = _useState10[0],
    setSelectedServer = _useState10[1];
  var _useState11 = (0, _react.useState)(false),
    _useState12 = (0, _slicedToArray2.default)(_useState11, 2),
    createManagedApplications = _useState12[0],
    setCreateManagedApplications = _useState12[1];
  var _useState13 = (0, _react.useState)(false),
    _useState14 = (0, _slicedToArray2.default)(_useState13, 2),
    isModalOpen = _useState14[0],
    setIsModalOpen = _useState14[1];
  var _useState15 = (0, _react.useState)(false),
    _useState16 = (0, _slicedToArray2.default)(_useState15, 2),
    isFilterAppsOpen = _useState16[0],
    setIsFilterAppsOpen = _useState16[1];
  var dispatch = (0, _hooks.useAppDispatch)();
  (0, _react.useEffect)(function () {
    dispatch(setPreSelectedServer(undefined));
    dispatch(loadServers(folder.id));
    dispatch(loadWebhookSources(folder.id));
    dispatch(getAvailablePlugins(_constants.STATUS_HTTP_CONNECTION));
  }, []);
  (0, _react.useEffect)(function () {
    if (!(0, _isNil.default)(preSelected)) {
      updateSelectedServer(preSelected, preSelected.type);
    } else {
      setSelectedServers({});
    }
  }, [preSelected]);
  (0, _react.useEffect)(function () {
    if (!configDetails) return;
    !configDetails.success && configDetails.webhookSourceId ? onModalSubmit() : setIsModalOpen(true);
  }, [configDetails]);
  var updateSelectedServer = function updateSelectedServer(server, serverType) {
    setSelectedServers(function (prevState) {
      return _objectSpread(_objectSpread({}, prevState), {}, (0, _defineProperty2.default)({}, serverType, server));
    });
    setDiscoverType(serverType);
  };
  var getSelectedServer = function getSelectedServer(serverType) {
    return selectedServers[serverType];
  };
  var checkIfSelected = function checkIfSelected(serverType) {
    return !(0, _isNil.default)(selectedServers[serverType]);
  };
  var handleDiscoverApplication = function handleDiscoverApplication(serverType) {
    setSelectedServer(getSelectedServer(serverType));
    var server = getSelectedServer(serverType);
    if (server !== null && server !== void 0 && server.id) {
      dispatch(setLiveUpdate({
        folderId: folder.id,
        serverId: server.id
      }));
    }
  };
  var onModalSubmit = function onModalSubmit() {
    setAutoCreatedWebhook(webhookSources.find(function (webhookSource) {
      return (webhookSource === null || webhookSource === void 0 ? void 0 : webhookSource.id) === (configDetails === null || configDetails === void 0 ? void 0 : configDetails.webhookSourceId);
    }));
    setIsModalOpen(false);
    setIsFilterAppsOpen(true);
    dispatch(setConfigDetails(undefined));
  };
  var closeModal = function closeModal() {
    dispatch(setConfigDetails(undefined));
    setIsModalOpen(false);
  };
  var filterBack = function filterBack() {
    setIsFilterAppsOpen(false);
  };
  var generateServerCard = function generateServerCard(pluginInfo) {
    var _getSelectedServer;
    var serverOptions = servers.filter(function (server) {
      return server.type === pluginInfo.type;
    });
    var onCreateServer = function onCreateServer() {
      return setTypeOfCreatedServer(pluginInfo.type);
    };
    return /*#__PURE__*/_react.default.createElement(_dotComponents.DotCard, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotCardHeader, {
      avatar: pluginInfo.iconLocation.length > 0 ? /*#__PURE__*/_react.default.createElement("img", {
        alt: pluginInfo.type,
        src: pluginInfo.iconLocation
      }) : /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
        iconId: 'plugins'
      }),
      className: "card-header-inline",
      subheader: pluginInfo.subheader,
      subheaderSize: "small",
      title: pluginInfo.title,
      titleSize: "small"
    }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotCardContent, null, serverOptions.length === 0 && /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
      className: "discovery-button",
      "data-testid": "create-server-btn",
      onClick: onCreateServer
    }, "Create connection"), serverOptions.length > 0 && /*#__PURE__*/_react.default.createElement(_dotComponents.DotAutoComplete, {
      actionItem: {
        iconId: 'add',
        onClick: onCreateServer,
        text: 'Create connection'
      },
      className: "server-source",
      freesolo: false,
      inputId: "server-source-input",
      label: "Choose connection",
      multiple: false,
      onChange: function onChange(e, v) {
        return updateSelectedServer(v, pluginInfo.type);
      },
      options: serverOptions,
      value: {
        title: ((_getSelectedServer = getSelectedServer(pluginInfo.type)) === null || _getSelectedServer === void 0 ? void 0 : _getSelectedServer.title) || ''
      }
    }), serverOptions.length > 0 && /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
      className: "discovery-button",
      "data-testid": "discover-server-btn",
      disabled: !checkIfSelected(pluginInfo.type),
      onClick: function onClick() {
        return handleDiscoverApplication(pluginInfo.type);
      }
    }, "Discover applications")));
  };
  var generateServerCards = function generateServerCards() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "discovery"
    }, /*#__PURE__*/_react.default.createElement("h2", null, "Discover applications"), /*#__PURE__*/_react.default.createElement("div", {
      className: "server-cards"
    }, validServerCards.map(function (plugin) {
      return generateServerCard(plugin);
    })), configDetails && /*#__PURE__*/_react.default.createElement(_discoverModalComponent.DiscoverModal, {
      configureDetails: configDetails,
      isModalOpen: isModalOpen && !isLoading,
      onModalClose: closeModal,
      onModalSubmit: onModalSubmit,
      type: discoverType || ''
    }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotCheckbox, {
      checked: createManagedApplications,
      className: "discover-managed-applications-checkbox",
      "data-testid": "discover-managed-applications-checkbox",
      label: "Also create managed applications from discovered applications",
      onChange: function onChange() {
        return setCreateManagedApplications(!createManagedApplications);
      }
    }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
      "data-testid": "discovery-cancel-btn",
      onClick: closeWizard,
      type: "text"
    }, "Cancel"));
  };
  var generateBasicView = function generateBasicView() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !typeOfCreatedServer && generateServerCards(), typeOfCreatedServer && /*#__PURE__*/_react.default.createElement(_applicationCreateServerComponent.CreateServerForm, {
      closeForm: function closeForm() {
        return setTypeOfCreatedServer(undefined);
      },
      folder: folder,
      serverType: typeOfCreatedServer
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, !isFilterAppsOpen && generateBasicView(), isFilterAppsOpen && /*#__PURE__*/_react.default.createElement(_filterApplicationsComponent.FilterApplications, {
    createManagedApplications: createManagedApplications,
    folder: folder,
    onCancel: closeWizard,
    onFilterBack: filterBack,
    onSave: closeWizard,
    plugins: validServerCards,
    server: selectedServer,
    webhookSource: autoCreatedWebhook
  }));
};
var BasicDiscovery = exports.BasicDiscovery = /*#__PURE__*/(0, _react.memo)(ApplicationDiscoveryBasicComponent);

/***/ }),

/***/ 89175:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.CreateServerForm = void 0;
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _connectionDialog = __webpack_require__(62679);
var _externalDeployments = __webpack_require__(69041);
__webpack_require__(62531);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var CreateServerFormComponent = function CreateServerFormComponent(props) {
  var serverType = props.serverType,
    closeForm = props.closeForm,
    serverId = props.serverId,
    folder = props.folder;
  var updateServerList = _externalDeployments.folderExternalDeployments.actions.updateServerList;
  var handleCancelConfiguration = function handleCancelConfiguration() {
    closeForm();
  };
  var handleSaveConfiguration = function handleSaveConfiguration() {
    closeForm();
  };
  return /*#__PURE__*/_react.default.createElement(_connectionDialog.ConnectionDialog, {
    configurationSaveAction: updateServerList,
    connectionId: serverId,
    folderId: folder.id,
    isNewInstance: !serverId,
    keyOrName: 'server',
    onCancel: handleCancelConfiguration,
    onSave: handleSaveConfiguration,
    referencedType: serverType || ''
  });
};
var CreateServerForm = exports.CreateServerForm = /*#__PURE__*/(0, _react.memo)(CreateServerFormComponent);

/***/ }),

/***/ 22393:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.DiscoverModal = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _reactAce = _interopRequireDefault(__webpack_require__(74981));
var _dotComponents = __webpack_require__(92140);
var _externalDeployments = __webpack_require__(64507);
var DiscoverModal = exports.DiscoverModal = function DiscoverModal(props) {
  var configureDetails = props.configureDetails,
    isModalOpen = props.isModalOpen,
    onModalClose = props.onModalClose,
    onModalSubmit = props.onModalSubmit;
  var title = "Configuration ".concat(configureDetails.success ? 'ready' : 'failed');
  var editorOptions = {
    readOnly: true
  };
  var copyCode = function copyCode() {
    navigator.clipboard.writeText(configureDetails.details).then(function () {
      return _externalDeployments.toaster.success('Configuration code was copied to the clipboard!');
    }).catch(function (_) {
      return _externalDeployments.toaster.error('Configuration code cannot be copied to the clipboard. Please, check your browser settings.');
    });
  };
  var renderConfigurationDetails = /*#__PURE__*/_react.default.createElement("div", {
    className: "configuration-details-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
    className: "copy-icon",
    "data-testid": "copy-btn",
    iconId: "duplicate",
    onClick: copyCode,
    tooltip: "Copy to clipboard"
  }), /*#__PURE__*/_react.default.createElement(_reactAce.default, {
    fontSize: 12,
    height: "100%",
    mode: "yaml",
    name: "configure-run-ace-editor",
    placeholder: "Configuration template was empty",
    setOptions: editorOptions,
    theme: "tomorrow",
    value: configureDetails.details,
    width: "100%"
  }));
  return /*#__PURE__*/_react.default.createElement(_dotComponents.DotDialog, {
    className: "configure-run-modal",
    onCancel: onModalClose,
    onSubmit: onModalSubmit,
    open: isModalOpen,
    submitButtonProps: {
      disabled: !configureDetails.success,
      label: 'Next'
    },
    title: title
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotAlertBanner, {
    action: null,
    "data-testid": "configure-success-banner",
    severity: configureDetails.success ? 'success' : 'error'
  }, configureDetails.message, configureDetails.success && /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
    "data-testid": "modal-new-tab",
    iconId: "open-new-tab",
    onClick: function onClick() {
      return window.open(configureDetails.url, '_blank');
    },
    tooltip: "Open webhook link"
  })), configureDetails.details && renderConfigurationDetails);
};

/***/ }),

/***/ 48372:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.EventSourceForm = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
__webpack_require__(75122);
var _dotComponents = __webpack_require__(92140);
var _constants = __webpack_require__(71297);
var _externalDeployments = __webpack_require__(12098);
var _hooks = __webpack_require__(96462);
var _externalDeployments2 = __webpack_require__(69041);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var _folderExternalDeploy = _externalDeployments2.folderExternalDeployments.actions,
  loadFilterEventSource = _folderExternalDeploy.loadFilterEventSource,
  saveEventSource = _folderExternalDeploy.saveEventSource;
var EventSourceFormComponent = function EventSourceFormComponent(props) {
  var closeForm = props.closeForm,
    eventSourceId = props.eventSourceId;
  var filterEventSource = (0, _hooks.useAppSelector)(_externalDeployments.getFilterEventSourceSelector);
  var _useState = (0, _react.useState)(''),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    title = _useState2[0],
    setTitle = _useState2[1];
  var _useState3 = (0, _react.useState)(true),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    sourceEnabled = _useState4[0],
    setSourceEnabled = _useState4[1];
  var _useState5 = (0, _react.useState)(''),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    path = _useState6[0],
    setPath = _useState6[1];
  var _useState7 = (0, _react.useState)(undefined),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    authentication = _useState8[0],
    setAuthentication = _useState8[1];
  var _useState9 = (0, _react.useState)(undefined),
    _useState10 = (0, _slicedToArray2.default)(_useState9, 2),
    authToken = _useState10[0],
    setAuthToken = _useState10[1];
  var _useState11 = (0, _react.useState)(''),
    _useState12 = (0, _slicedToArray2.default)(_useState11, 2),
    githubToken = _useState12[0],
    setGithubToken = _useState12[1];
  var _useState13 = (0, _react.useState)(''),
    _useState14 = (0, _slicedToArray2.default)(_useState13, 2),
    jythonAuthScript = _useState14[0],
    setJythonAuthScript = _useState14[1];
  var _useState15 = (0, _react.useState)(undefined),
    _useState16 = (0, _slicedToArray2.default)(_useState15, 2),
    requestRetention = _useState16[0],
    setRequestRetention = _useState16[1];
  var dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(function () {
    dispatch(loadFilterEventSource(eventSourceId));
  }, []);
  (0, _react.useEffect)(function () {
    if (filterEventSource) {
      setTitle(filterEventSource.title);
      setSourceEnabled(filterEventSource.sourceEnabled);
      setPath(filterEventSource.path);
      setAuthentication(filterEventSource.authentication);
      setRequestRetention(filterEventSource.requestRetention);
      setAuthToken(filterEventSource.authentication.webhookToken);
      setGithubToken(filterEventSource.authentication.githubSecret);
      setJythonAuthScript(filterEventSource.authentication.authenticationScript);
    }
  }, [filterEventSource]);
  var onAuthMethodChange = function onAuthMethodChange(authMethodSelected) {
    if (authMethodSelected) {
      var auth = {
        id: authentication ? authentication.id : null,
        type: authMethodSelected.id,
        githubSecret: githubToken,
        webhookToken: authToken,
        authenticationScript: jythonAuthScript
      };
      setAuthentication(auth);
    } else {
      setAuthentication(undefined);
    }
  };
  var onSubmit = function onSubmit() {
    if (!filterEventSource || !authentication) {
      return;
    }
    var eventSource = _objectSpread(_objectSpread({}, filterEventSource), {}, {
      authentication: resolveFormAuthentication(authentication),
      path: path,
      requestRetention: requestRetention,
      sourceEnabled: sourceEnabled,
      title: title
    });
    dispatch(saveEventSource(eventSource));
    closeForm();
  };
  var resolveFormAuthentication = function resolveFormAuthentication(auth) {
    var submittedAuth = {
      id: auth.id,
      type: auth.type
    };
    if (auth.type === _constants.ENDPOINT_AUTHENTICATION_METHOD.tokenAuth) submittedAuth.webhookToken = authToken;else if (auth.type === _constants.ENDPOINT_AUTHENTICATION_METHOD.githubAuth || auth.type === _constants.ENDPOINT_AUTHENTICATION_METHOD.githubJythonAuth) submittedAuth.githubSecret = githubToken;else if (auth.type === _constants.ENDPOINT_AUTHENTICATION_METHOD.jythonScriptAuth) submittedAuth.authenticationScript = jythonAuthScript;
    return submittedAuth;
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "event-source-form"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "h2"
  }, /*#__PURE__*/_react.default.createElement("img", {
    alt: "Webhook endpoint",
    src: _constants.IMG_SRC.webhookSource
  }), "Endpoint webhook"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotForm, {
    onSubmit: onSubmit
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotInputText, {
    id: "event-source-name",
    label: "Symbolic name for the connection",
    name: "eventSourceName",
    onChange: function onChange(e) {
      return setTitle(e.target.value);
    },
    required: true,
    value: title
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotCheckbox, {
    checked: sourceEnabled,
    label: "Enabled",
    name: "enableEventSource",
    onChange: function onChange() {
      return setSourceEnabled(!sourceEnabled);
    }
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotInputText, {
    helperText: "Provide URl",
    id: "event-source-path",
    label: "Endpoint path",
    name: "endpointPath",
    onChange: function onChange(e) {
      return setPath(e.target.value);
    },
    required: true,
    value: path
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotInputText, {
    helperText: "The maximum number of requests",
    id: "event-source-retention",
    label: "Request retention",
    name: "requestRetention",
    onChange: function onChange(e) {
      return setRequestRetention(+e.target.value);
    },
    type: "number",
    value: '' + requestRetention
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotDivider, null), /*#__PURE__*/_react.default.createElement("div", {
    className: "auth-header"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "h2"
  }, "Authentication")), /*#__PURE__*/_react.default.createElement(_dotComponents.DotAutoComplete, {
    className: "authentication-method",
    freesolo: false,
    inputId: "authentication-method",
    label: "Authentication method",
    multiple: false,
    onChange: function onChange(e, v) {
      return onAuthMethodChange(v);
    },
    options: _constants.EVENT_SOURCE_AUTH_OPTIONS,
    required: true,
    value: _constants.EVENT_SOURCE_AUTH_OPTIONS.find(function (authOption) {
      return authOption.id === (authentication ? authentication.type : _constants.ENDPOINT_AUTHENTICATION_METHOD.noAuth);
    })
  }), (authentication === null || authentication === void 0 ? void 0 : authentication.type) === _constants.ENDPOINT_AUTHENTICATION_METHOD.tokenAuth && /*#__PURE__*/_react.default.createElement(_dotComponents.DotInputText, {
    helperText: "Secret token that will be passed in x-release-webhook-token request header",
    id: "event-source-token",
    label: "Secret Token",
    name: "token",
    onChange: function onChange(e) {
      return setAuthToken(e.target.value);
    },
    type: "password",
    value: authentication.webhookToken
  }), (authentication === null || authentication === void 0 ? void 0 : authentication.type) === _constants.ENDPOINT_AUTHENTICATION_METHOD.githubAuth && /*#__PURE__*/_react.default.createElement(_dotComponents.DotInputText, {
    helperText: "Secret token as defined on the Github Webhook configuration page",
    id: "event-source-webhook-secret",
    label: "Github Webhook Secret",
    name: "githubWebhookSecret",
    onChange: function onChange(e) {
      return setGithubToken(e.target.value);
    },
    type: "password",
    value: authentication.githubSecret
  }), (authentication === null || authentication === void 0 ? void 0 : authentication.type) === _constants.ENDPOINT_AUTHENTICATION_METHOD.githubJythonAuth && /*#__PURE__*/_react.default.createElement(_dotComponents.DotInputText, {
    id: "event-source-secret",
    label: "Github Secret",
    name: "githubSecret",
    onChange: function onChange(e) {
      return setGithubToken(e.target.value);
    },
    type: "password",
    value: authentication.githubSecret
  }), (authentication === null || authentication === void 0 ? void 0 : authentication.type) === _constants.ENDPOINT_AUTHENTICATION_METHOD.jythonScriptAuth && /*#__PURE__*/_react.default.createElement(_dotComponents.DotInputText, {
    helperText: "Jython script that will decide if an incoming request is considered authenticated. This script should set the variable `authenticated` to either `True` or `False`. The script can access the properties of the HTTP request by using the following variables: * endpoint: this HTTP endpoint for Webhooks * config: the HTTP endpoint's authentication method * headers: the headers of the current HTTP request * parameters: the URL parameters of the current HTTP request * payload: the request body of the current HTTP request",
    id: "event-source-jython-script",
    label: "Authentication Script",
    multiline: true,
    name: "jythonScript",
    onChange: function onChange(e) {
      return setJythonAuthScript(e.target.value);
    },
    size: "medium",
    value: authentication.authenticationScript
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'right'
    }
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    onClick: closeForm,
    type: "text"
  }, "Cancel"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    disabled: !authentication || !title || !path,
    isSubmit: true
  }, "Save"))));
};
var EventSourceForm = exports.EventSourceForm = /*#__PURE__*/(0, _react.memo)(EventSourceFormComponent);

/***/ }),

/***/ 22303:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FilterApplications = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _noop = _interopRequireDefault(__webpack_require__(50308));
var _dotComponents = __webpack_require__(92140);
__webpack_require__(60724);
var _externalDeployments = __webpack_require__(69041);
var _externalDeployments2 = __webpack_require__(12098);
var _hooks = __webpack_require__(96462);
var _constants = __webpack_require__(71297);
var _applicationEventSource = __webpack_require__(48372);
var _patchModalComponent = __webpack_require__(92055);
var _managedApplication = __webpack_require__(72198);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var _folderExternalDeploy = _externalDeployments.folderExternalDeployments.actions,
  loadWebhookSourceFilters = _folderExternalDeploy.loadWebhookSourceFilters,
  updateWebhookSourceFilters = _folderExternalDeploy.updateWebhookSourceFilters,
  patchExternalDeployments = _folderExternalDeploy.patchExternalDeployments;
var createManagedApplicationsFromWebhookSource = _managedApplication.applicationManagement.actions.createManagedApplicationsFromWebhookSource;
var FilterApplicationsComponent = function FilterApplicationsComponent(props) {
  var onCancel = props.onCancel,
    onFilterBack = props.onFilterBack,
    onSave = props.onSave,
    server = props.server,
    webhookSource = props.webhookSource,
    createManagedApplications = props.createManagedApplications,
    plugins = props.plugins,
    folder = props.folder;
  var webhookSourceFilters = (0, _hooks.useAppSelector)(_externalDeployments2.getWebhookSourceFiltersSelector);
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isWebhookSourceForm = _useState2[0],
    setIsWebhookSourceForm = _useState2[1];
  var _useState3 = (0, _react.useState)([]),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    folderOptions = _useState4[0],
    setFolderOptions = _useState4[1];
  var _useState5 = (0, _react.useState)([]),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    selectedFolders = _useState6[0],
    setSelectedFolders = _useState6[1];
  var _useState7 = (0, _react.useState)(false),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    isModalOpen = _useState8[0],
    setIsModalOpen = _useState8[1];
  var dispatch = (0, _reactRedux.useDispatch)();
  var webhookSourceId = webhookSource.id || '';
  var serverType = (server === null || server === void 0 ? void 0 : server.type) || '';
  var plugin = plugins === null || plugins === void 0 ? void 0 : plugins.find(function (pluginInfo) {
    return pluginInfo.type === serverType;
  });
  var isAutoconfigurable = plugin ? plugin.isAutoconfigurable : false;
  var title = plugin ? plugin.title : '';
  var icon = plugin ? plugin.iconLocation : '';
  var eventSourceId = webhookSource.eventSource || '';
  var onFilterSave = function onFilterSave() {
    if (createManagedApplications) dispatch(createManagedApplicationsFromWebhookSource({
      folderId: folder.id,
      webhookSourceId: webhookSourceId
    }));
    onSave();
  };
  var saveApplicationFilters = function saveApplicationFilters() {
    dispatch(updateWebhookSourceFilters({
      webhookSourceId: webhookSourceId,
      filteredFolders: selectedFolders
    }));
    if (isAutoconfigurable) {
      setIsModalOpen(true);
    } else {
      onFilterSave();
    }
  };
  var handleSelectedFoldersChange = function handleSelectedFoldersChange(v) {
    setSelectedFolders(v.map(function (value) {
      return value.title;
    }));
  };
  var onEventSourceFormClose = function onEventSourceFormClose() {
    setIsWebhookSourceForm(false);
  };
  var onModalUpdateAutomatically = function onModalUpdateAutomatically() {
    dispatch(patchExternalDeployments(webhookSourceId));
    setIsModalOpen(false);
    onFilterSave();
  };
  var onModalUpdateManually = function onModalUpdateManually() {
    setIsModalOpen(false);
    onFilterSave();
  };
  (0, _react.useEffect)(function () {
    dispatch(loadWebhookSourceFilters(webhookSourceId));
  }, []);
  (0, _react.useEffect)(function () {
    setFolderOptions(webhookSourceFilters ? webhookSourceFilters.folderFilterOptions : []);
    setSelectedFolders(webhookSourceFilters ? webhookSourceFilters.folderFilterValues : []);
  }, [webhookSourceFilters]);
  var generateApplicationFilters = function generateApplicationFilters() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "filter-applications"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotForm, {
      onSubmit: _noop.default
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
      variant: "h1"
    }, "Map folders"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotAutoComplete, {
      className: "folders-filter",
      freesolo: false,
      helperText: 'Map folders to display applications from',
      inputId: "webhook-source-folders-filter",
      label: "Choose folders",
      onChange: function onChange(e, v) {
        return handleSelectedFoldersChange(v);
      },
      options: folderOptions.map(function (option) {
        return {
          id: option,
          title: option
        };
      }),
      value: selectedFolders.map(function (option) {
        return {
          id: option,
          title: option
        };
      })
    }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotCard, {
      className: "filter-card"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotCardHeader, {
      avatar: /*#__PURE__*/_react.default.createElement("img", {
        alt: serverType,
        src: icon
      }),
      className: "card-header-inline",
      subheader: server === null || server === void 0 ? void 0 : server.url,
      subheaderSize: "small",
      title: title,
      titleSize: "small"
    })), /*#__PURE__*/_react.default.createElement(_dotComponents.DotCard, {
      className: "filter-card"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotCardHeader, {
      action: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
        color: "inherit",
        "data-testid": "filter-webhook-edit-action",
        iconId: "edit",
        iconSize: "small",
        onClick: function onClick() {
          return setIsWebhookSourceForm(true);
        },
        size: "medium",
        tooltip: "Edit webhook endpoint"
      }),
      avatar: /*#__PURE__*/_react.default.createElement("img", {
        alt: webhookSource.title,
        src: _constants.IMG_SRC.webhookSource
      }),
      className: "card-header-inline",
      title: webhookSource.title,
      titleSize: "small"
    })), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
      className: "button cancel",
      onClick: onFilterBack,
      type: "text"
    }, "Back"), /*#__PURE__*/_react.default.createElement("span", {
      className: "filter-end-buttons"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
      className: "button cancel",
      onClick: onCancel,
      type: "outlined"
    }, "Cancel"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
      className: "button primary",
      "data-testid": "filter-apps-done-btn",
      disabled: selectedFolders.length === 0,
      onClick: saveApplicationFilters
    }, "Done")))), /*#__PURE__*/_react.default.createElement(_patchModalComponent.PatchModal, {
      isModalOpen: isModalOpen && !isWebhookSourceForm,
      onModalUpdateAutomatically: onModalUpdateAutomatically,
      onModalUpdateManually: onModalUpdateManually
    }));
  };
  var generateWebhookSourceForm = function generateWebhookSourceForm() {
    return /*#__PURE__*/_react.default.createElement(_applicationEventSource.EventSourceForm, {
      closeForm: onEventSourceFormClose,
      eventSourceId: eventSourceId
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isWebhookSourceForm && generateApplicationFilters(), isWebhookSourceForm && generateWebhookSourceForm());
};
var FilterApplications = exports.FilterApplications = /*#__PURE__*/(0, _react.memo)(FilterApplicationsComponent);

/***/ }),

/***/ 92055:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.PatchModal = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
__webpack_require__(10917);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var PatchModal = exports.PatchModal = function PatchModal(props) {
  var isModalOpen = props.isModalOpen,
    onModalUpdateManually = props.onModalUpdateManually,
    onModalUpdateAutomatically = props.onModalUpdateAutomatically;
  var _useState = (0, _react.useState)(true),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isDetailCollapsed = _useState2[0],
    setIsDetailCollapsed = _useState2[1];
  var resolveDetailCollapseText = function resolveDetailCollapseText() {
    if (isDetailCollapsed) return 'Learn more..';else return 'Collapse';
  };
  return /*#__PURE__*/_react.default.createElement(_dotComponents.DotDialog, {
    cancelButtonProps: {
      label: 'Update Manually'
    },
    className: "patch-dialog",
    onCancel: onModalUpdateManually,
    onSubmit: onModalUpdateAutomatically,
    open: isModalOpen,
    submitButtonProps: {
      label: 'Update Automatically'
    },
    title: 'Patch available'
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "patch-dialog-body"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "body1"
  }, "ArgoCD applications need to subscribe to Release notification webhooks if you wish to receive live updates from ArgoCD."), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "body1"
  }, "You can choose to update it manually or automatically. How would you like to proceed?"), /*#__PURE__*/_react.default.createElement("br", null), !isDetailCollapsed && /*#__PURE__*/_react.default.createElement("div", {
    className: "patch-details"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "body1"
  }, "ArgoCD Application.yaml files will be patched with following annotations:"), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("div", {
    className: "patch-details-header"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "h4"
  }, "Annotations")), /*#__PURE__*/_react.default.createElement("div", {
    className: "patch-details-body"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "body1"
  }, "notifications.argoproj.io/subscribe.on-created.release-webhook: \"\" notifications.argoproj.io/subscribe.on-deleted.release-webhook: \"\" notifications.argoproj.io/subscribe.on-health-unknown.release-webhook: \"\" notifications.argoproj.io/subscribe.on-health-progressing.release-webhook: \"\" notifications.argoproj.io/subscribe.on-health-suspended.release-webhook: \"\" notifications.argoproj.io/subscribe.on-health-healthy.release-webhook: \"\" notifications.argoproj.io/subscribe.on-health-degraded.release-webhook: \"\" notifications.argoproj.io/subscribe.on-health-missing.release-webhook: \"\" notifications.argoproj.io/subscribe.on-sync-unknown.release-webhook: \"\" notifications.argoproj.io/subscribe.on-sync-synced.release-webhook: \"\" notifications.argoproj.io/subscribe.on-sync-out-of-sync.release-webhook: \"\""))), /*#__PURE__*/_react.default.createElement("div", {
    className: "patch-details-collapse"
  }, /*#__PURE__*/_react.default.createElement("p", {
    onClick: function onClick() {
      return setIsDetailCollapsed(!isDetailCollapsed);
    }
  }, resolveDetailCollapseText()))));
};

/***/ }),

/***/ 71297:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.VERSION_ORDER_BY = exports.VERSION_COLUMN_ID = exports.TIME_ORDER_BY = exports.TIME_COLUMN_ID = exports.STATUS_ORDER_BY = exports.STATUS_HTTP_CONNECTION = exports.STATUS_COLUMN_ID = exports.SSE_REGISTRATION_URL = exports.SERVER_AUTHENTICATION_OPTIONS = exports.SERVER_AUTHENTICATION_METHOD = exports.MAX_AGE_NO_CACHE = exports.IMG_SRC = exports.EVENT_TYPE = exports.EVENT_SOURCE_AUTH_OPTIONS = exports.ENDPOINT_TYPE = exports.ENDPOINT_AUTHENTICATION_METHOD = exports.DESTINATION_ORDER_BY = exports.DESTINATION_COLUMN_ID = exports.DEFAULT_RESULTS_PER_PAGE = exports.DEFAULT_PAGE = exports.DEFAULT_ORDER_BY = exports.DEFAULT_ORDER = exports.DEFAULT_MAX_AGE = exports.DEFAULT_CONDITION = exports.APPLICATION_ORDER_BY = exports.APPLICATION_COLUMN_ID = void 0;
var EVENT_TYPE = exports.EVENT_TYPE = {
  applicationPackageCreated: 'application-package-created',
  applicationPackageDeleted: 'application-package-deleted',
  applicationChanged: 'application-changed',
  applicationCreated: 'application-created',
  applicationDeleted: 'application-deleted'
};
var SSE_REGISTRATION_URL = exports.SSE_REGISTRATION_URL = 'sse-applications/application-status/register';
var STATUS_HTTP_CONNECTION = exports.STATUS_HTTP_CONNECTION = 'configuration.StatusHttpConnection';
var DEPLOY_REMOTE_ENDPOINT_TYPE = 'digitalai.DeployServer';
var DEPLOY_ENDPOINT_TYPE = 'xldeploy.XLDeployServer';
var ARGOCD_ENDPOINT_TYPE = 'argocd.ArgoCD';
var ARGOCD_REMOTE_ENDPOINT_TYPE = 'argocd.APIServer';
var DEPLOY_TEST = 'test.XLDeploy';
var ARGO_TEST = 'test.ArgoCD';
var ENDPOINT_TYPE = exports.ENDPOINT_TYPE = {
  deployRemote: DEPLOY_REMOTE_ENDPOINT_TYPE,
  deploy: DEPLOY_ENDPOINT_TYPE,
  argoCd: ARGOCD_ENDPOINT_TYPE,
  remoteArgoCd: ARGOCD_REMOTE_ENDPOINT_TYPE,
  deployTest: DEPLOY_TEST,
  argoTest: ARGO_TEST
};
var IMG_SRC = exports.IMG_SRC = {
  argoCd: 'static/24.1.10/include/external-deployments/assets/argocd.svg',
  deploy: 'static/24.1.10/include/external-deployments/assets/deploy-with-background.svg',
  environment: 'static/24.1.10/include/external-deployments/assets/environment.svg',
  webhookSource: 'static/24.1.10/include/external-deployments/assets/webhook-source.svg'
};
var APPLICATION_COLUMN_ID = exports.APPLICATION_COLUMN_ID = 'applicationName';
var DESTINATION_COLUMN_ID = exports.DESTINATION_COLUMN_ID = 'environment';
var VERSION_COLUMN_ID = exports.VERSION_COLUMN_ID = 'version';
var STATUS_COLUMN_ID = exports.STATUS_COLUMN_ID = 'status';
var TIME_COLUMN_ID = exports.TIME_COLUMN_ID = 'updated';
var APPLICATION_ORDER_BY = exports.APPLICATION_ORDER_BY = 'APPLICATION';
var DESTINATION_ORDER_BY = exports.DESTINATION_ORDER_BY = 'DESTINATION';
var VERSION_ORDER_BY = exports.VERSION_ORDER_BY = 'VERSION';
var STATUS_ORDER_BY = exports.STATUS_ORDER_BY = 'STATUS';
var TIME_ORDER_BY = exports.TIME_ORDER_BY = 'TIME';
var DEFAULT_MAX_AGE = exports.DEFAULT_MAX_AGE = 60000;
var MAX_AGE_NO_CACHE = exports.MAX_AGE_NO_CACHE = 0;
var SERVER_AUTHENTICATION_METHOD = exports.SERVER_AUTHENTICATION_METHOD = {
  none: 'None',
  basic: 'Basic',
  ntlm: 'Ntlm',
  oauth2: 'OAuth2'
};
var SERVER_AUTHENTICATION_OPTIONS = exports.SERVER_AUTHENTICATION_OPTIONS = [{
  id: SERVER_AUTHENTICATION_METHOD.none,
  title: SERVER_AUTHENTICATION_METHOD.none
}, {
  id: SERVER_AUTHENTICATION_METHOD.basic,
  title: SERVER_AUTHENTICATION_METHOD.basic
}, {
  id: SERVER_AUTHENTICATION_METHOD.ntlm,
  title: SERVER_AUTHENTICATION_METHOD.ntlm
}, {
  id: SERVER_AUTHENTICATION_METHOD.oauth2,
  title: SERVER_AUTHENTICATION_METHOD.oauth2
}];
var ENDPOINT_AUTHENTICATION_METHOD = exports.ENDPOINT_AUTHENTICATION_METHOD = {
  noAuth: 'events.NoAuthentication',
  tokenAuth: 'events.TokenAuthentication',
  githubAuth: 'github.GithubAuthentication',
  githubJythonAuth: 'github.GithubJythonAuthentication',
  jythonScriptAuth: 'events.JythonScriptAuthentication'
};
var EVENT_SOURCE_AUTH_OPTIONS = exports.EVENT_SOURCE_AUTH_OPTIONS = [{
  id: ENDPOINT_AUTHENTICATION_METHOD.noAuth,
  title: 'No authentication'
}, {
  id: ENDPOINT_AUTHENTICATION_METHOD.tokenAuth,
  title: 'Token authentication'
}, {
  id: ENDPOINT_AUTHENTICATION_METHOD.githubAuth,
  title: 'Github authentication'
}, {
  id: ENDPOINT_AUTHENTICATION_METHOD.githubJythonAuth,
  title: 'Github authentication (Jython)'
}, {
  id: ENDPOINT_AUTHENTICATION_METHOD.jythonScriptAuth,
  title: 'Scripted authentication (Jython)'
}];
var DEFAULT_CONDITION = exports.DEFAULT_CONDITION = '';
var DEFAULT_ORDER = exports.DEFAULT_ORDER = 'asc';
var DEFAULT_ORDER_BY = exports.DEFAULT_ORDER_BY = STATUS_COLUMN_ID;
var DEFAULT_PAGE = exports.DEFAULT_PAGE = 0;
var DEFAULT_RESULTS_PER_PAGE = exports.DEFAULT_RESULTS_PER_PAGE = 10;

/***/ }),

/***/ 2387:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.initialState = exports.getApplicationWizardState = exports.externalApplicationWizard = void 0;
var _toolkit = __webpack_require__(47054);
var _noop = _interopRequireDefault(__webpack_require__(50308));
var initialState = exports.initialState = {
  connectionTested: false,
  testConnectionStatus: {
    errorText: '',
    success: undefined
  }
};
var externalApplicationWizard = exports.externalApplicationWizard = (0, _toolkit.createSlice)({
  name: 'externalApplicationWizard',
  initialState: initialState,
  reducers: {
    setConnectionTested: function setConnectionTested(state, action) {
      state.connectionTested = action.payload;
    },
    setTestConnectionStatus: function setTestConnectionStatus(state, action) {
      state.testConnectionStatus = action.payload;
    },
    testConnection: function testConnection(_state, _action) {
      return (0, _noop.default)();
    }
  }
});
var getApplicationWizardState = exports.getApplicationWizardState = function getApplicationWizardState(state) {
  return state.externalApplicationWizard;
};

/***/ }),

/***/ 39958:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.applicationWizardSagas = applicationWizardSagas;
exports.testConnectionSaga = testConnectionSaga;
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _effects = __webpack_require__(34857);
var _applicationWizard = __webpack_require__(2387);
var _http = __webpack_require__(26511);
var _marked = /*#__PURE__*/_regenerator.default.mark(testConnectionSaga),
  _marked2 = /*#__PURE__*/_regenerator.default.mark(applicationWizardSagas);
var _externalApplicationW = _applicationWizard.externalApplicationWizard.actions,
  setConnectionTested = _externalApplicationW.setConnectionTested,
  setTestConnectionStatus = _externalApplicationW.setTestConnectionStatus,
  testConnection = _externalApplicationW.testConnection;
function testConnectionSaga(action) {
  var _yield$call, _yield$call$data, errorText, success;
  return _regenerator.default.wrap(function testConnectionSaga$(_context) {
    while (1) switch (_context.prev = _context.next) {
      case 0:
        _context.next = 2;
        return (0, _effects.call)(_http.httpPOST, "configurations/status", action.payload);
      case 2:
        _yield$call = _context.sent;
        _yield$call$data = _yield$call.data;
        errorText = _yield$call$data.errorText;
        success = _yield$call$data.success;
        _context.next = 8;
        return (0, _effects.put)(setTestConnectionStatus({
          success: success,
          errorText: errorText
        }));
      case 8:
        _context.next = 10;
        return (0, _effects.put)(setConnectionTested(true));
      case 10:
      case "end":
        return _context.stop();
    }
  }, _marked);
}
function applicationWizardSagas() {
  return _regenerator.default.wrap(function applicationWizardSagas$(_context2) {
    while (1) switch (_context2.prev = _context2.next) {
      case 0:
        _context2.next = 2;
        return (0, _effects.all)([(0, _effects.takeEvery)(testConnection, testConnectionSaga)]);
      case 2:
      case "end":
        return _context2.stop();
    }
  }, _marked2);
}

/***/ }),

/***/ 69041:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.initialState = exports.initialPage = exports.folderExternalDeployments = void 0;
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(319));
var _toolkit = __webpack_require__(47054);
var _noop = _interopRequireDefault(__webpack_require__(50308));
var _constants = __webpack_require__(71297);
var initialPage = exports.initialPage = {
  folderId: undefined,
  order: _constants.DEFAULT_ORDER,
  orderBy: _constants.DEFAULT_ORDER_BY,
  page: _constants.DEFAULT_PAGE,
  resultsPerPage: _constants.DEFAULT_RESULTS_PER_PAGE
};
var initialState = exports.initialState = {
  condition: _constants.DEFAULT_CONDITION,
  configDetails: undefined,
  connectionErrors: [],
  connectionServers: new Map(),
  count: 0,
  disconnectedServers: [],
  externalDeployments: [],
  filterEventSource: undefined,
  folderId: undefined,
  isLoading: false,
  maxAge: _constants.DEFAULT_MAX_AGE,
  page: initialPage,
  preSelectedServer: undefined,
  servers: [],
  validServerCards: [],
  webhookSourceFilters: undefined,
  webhookSources: []
};
var folderExternalDeployments = exports.folderExternalDeployments = (0, _toolkit.createSlice)({
  name: 'folderExternalDeployments',
  initialState: initialState,
  reducers: {
    addServerToServers: function addServerToServers(state, action) {
      var serverIndex = state.servers.findIndex(function (s) {
        return s.id === action.payload.id;
      });
      if (serverIndex === -1) state.servers = [].concat((0, _toConsumableArray2.default)(state.servers), [action.payload]);else state.servers[serverIndex] = action.payload;
    },
    createApplicationStatus: function createApplicationStatus(_state, _action) {
      return (0, _noop.default)();
    },
    updateServerList: function updateServerList(_state, _action) {
      return (0, _noop.default)();
    },
    addValidPluginToArray: function addValidPluginToArray(state, action) {
      if (!state.validServerCards.some(function (plugin) {
        return plugin.type === action.payload.type;
      })) {
        state.validServerCards.push(action.payload);
      }
    },
    getAvailablePlugins: function getAvailablePlugins(_state, _action) {
      return (0, _noop.default)();
    },
    createServer: function createServer(_state, _action) {
      return (0, _noop.default)();
    },
    deleteApplicationStatus: function deleteApplicationStatus(_state, _action) {
      return (0, _noop.default)();
    },
    deleteWebhookSource: function deleteWebhookSource(_state, _action) {
      return (0, _noop.default)();
    },
    getFilters: function getFilters(state, action) {
      state.page.folderId = action.payload;
    },
    loadExternalDeployments: function loadExternalDeployments(_state) {
      return (0, _noop.default)();
    },
    loadFilterEventSource: function loadFilterEventSource(_state, _action) {
      return (0, _noop.default)();
    },
    loadServers: function loadServers(_state, _action) {
      return (0, _noop.default)();
    },
    loadWebhookSourceFilters: function loadWebhookSourceFilters(_state, _action) {
      return (0, _noop.default)();
    },
    loadWebhookSources: function loadWebhookSources(_state, _action) {
      return (0, _noop.default)();
    },
    patchExternalDeployments: function patchExternalDeployments(_state, _action) {
      return (0, _noop.default)();
    },
    refreshExternalDeployments: function refreshExternalDeployments(_state) {
      return (0, _noop.default)();
    },
    removeWebhookSource: function removeWebhookSource(state, action) {
      state.webhookSources = state.webhookSources.filter(function (webhookSource) {
        return webhookSource.id !== action.payload;
      });
    },
    saveEventSource: function saveEventSource(_state, _action) {
      return (0, _noop.default)();
    },
    setCondition: function setCondition(state, action) {
      state.condition = action.payload;
    },
    setConfigDetails: function setConfigDetails(state, action) {
      state.configDetails = action.payload;
    },
    setConnectionErrors: function setConnectionErrors(state, action) {
      state.connectionErrors = action.payload;
    },
    setConnectionServers: function setConnectionServers(state, action) {
      state.connectionServers = action.payload;
    },
    setDisconnectedServers: function setDisconnectedServers(state, action) {
      state.disconnectedServers = action.payload;
    },
    setExternalDeployments: function setExternalDeployments(state, action) {
      state.externalDeployments = action.payload;
    },
    setExternalDeploymentsCount: function setExternalDeploymentsCount(state, action) {
      state.count = action.payload;
    },
    setFilterEventSource: function setFilterEventSource(state, action) {
      state.filterEventSource = action.payload;
    },
    setIsLoading: function setIsLoading(state, action) {
      state.isLoading = action.payload;
    },
    setLiveUpdate: function setLiveUpdate(_state, _action) {
      return (0, _noop.default)();
    },
    setMaxAge: function setMaxAge(state, action) {
      state.maxAge = action.payload;
    },
    setPage: function setPage(state, action) {
      state.page = action.payload;
    },
    setPreSelectedServer: function setPreSelectedServer(state, action) {
      state.preSelectedServer = action.payload;
    },
    setServers: function setServers(state, action) {
      state.servers = action.payload;
    },
    setWebhookSourceFilters: function setWebhookSourceFilters(state, action) {
      state.webhookSourceFilters = action.payload;
    },
    setWebhookSources: function setWebhookSources(state, action) {
      state.webhookSources = action.payload;
    },
    storeFilters: function storeFilters(_state) {
      return (0, _noop.default)();
    },
    subscribeToSseStream: function subscribeToSseStream(_state) {
      return (0, _noop.default)();
    },
    unsubscribeFromSseStream: function unsubscribeFromSseStream(_state) {
      return (0, _noop.default)();
    },
    updateApplicationStatus: function updateApplicationStatus(_state, _action) {
      return (0, _noop.default)();
    },
    updateBreadcrumbs: function updateBreadcrumbs(_state, _action) {
      return (0, _noop.default)();
    },
    updateWebhookSourceFilters: function updateWebhookSourceFilters(_state, _action) {
      return (0, _noop.default)();
    },
    setLiveDeploymentsPreconditionFilter: function setLiveDeploymentsPreconditionFilter(_state, _action) {
      return (0, _noop.default)();
    }
  }
});

/***/ }),

/***/ 64507:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = externalDeploymentsRootSaga;
exports.executeCreateServerAction = executeCreateServerAction;
exports.executeDeleteApplicationPackageStatusAction = executeDeleteApplicationPackageStatusAction;
exports.executeDeleteWebhookSourceAction = executeDeleteWebhookSourceAction;
exports.executeLoadExternalDeployments = executeLoadExternalDeployments;
exports.executeLoadExternalDeploymentsAction = executeLoadExternalDeploymentsAction;
exports.executeLoadExternalDeploymentsWithRefreshAction = executeLoadExternalDeploymentsWithRefreshAction;
exports.executeLoadFilterEventSourceAction = executeLoadFilterEventSourceAction;
exports.executeLoadServersAction = executeLoadServersAction;
exports.executeLoadWebhookSourceFiltersAction = executeLoadWebhookSourceFiltersAction;
exports.executeLoadWebhookSourcesAction = executeLoadWebhookSourcesAction;
exports.executePatchExternalDeploymentsAction = executePatchExternalDeploymentsAction;
exports.executeSaveEventSourceAction = executeSaveEventSourceAction;
exports.executeSetupLiveUpdateAction = executeSetupLiveUpdateAction;
exports.executeSseStreamSubscribeAction = executeSseStreamSubscribeAction;
exports.executeSseStreamUnsubscribeAction = executeSseStreamUnsubscribeAction;
exports.executeUpdateApplicationPackageStatusAction = executeUpdateApplicationPackageStatusAction;
exports.executeUpdateWebhookSourceFiltersAction = executeUpdateWebhookSourceFiltersAction;
exports.getAvailablePluginsAction = getAvailablePluginsAction;
exports.getFiltersAction = getFiltersAction;
exports.getWebhookSources = getWebhookSources;
exports.handleApplicationSseEventAction = handleApplicationSseEventAction;
exports.setLiveDeploymentsPreconditionFilterAction = setLiveDeploymentsPreconditionFilterAction;
exports.storeFiltersAction = storeFiltersAction;
exports.toaster = void 0;
exports.updateBreadcrumbsAction = updateBreadcrumbsAction;
exports.updateServerListAction = updateServerListAction;
exports.withLoadingState = withLoadingState;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _effects = __webpack_require__(34857);
var _externalDeployments = __webpack_require__(69041);
var _utils = __webpack_require__(95461);
var _constants = __webpack_require__(71297);
var _externalDeployments2 = __webpack_require__(12098);
var _toastrFactory = _interopRequireDefault(__webpack_require__(86846));
var _http = __webpack_require__(26511);
var _sagaUtils = __webpack_require__(27274);
var _angularAccessor = _interopRequireDefault(__webpack_require__(81403));
var _sse = __webpack_require__(62524);
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var _marked = /*#__PURE__*/_regenerator.default.mark(executeLoadExternalDeploymentsWithRefreshAction),
  _marked2 = /*#__PURE__*/_regenerator.default.mark(executeUpdateApplicationPackageStatusAction),
  _marked3 = /*#__PURE__*/_regenerator.default.mark(executeDeleteApplicationPackageStatusAction),
  _marked4 = /*#__PURE__*/_regenerator.default.mark(withLoadingState),
  _marked5 = /*#__PURE__*/_regenerator.default.mark(executeLoadExternalDeploymentsAction),
  _marked6 = /*#__PURE__*/_regenerator.default.mark(executeLoadExternalDeployments),
  _marked7 = /*#__PURE__*/_regenerator.default.mark(executeSseStreamSubscribeAction),
  _marked8 = /*#__PURE__*/_regenerator.default.mark(handleApplicationSseEventAction),
  _marked9 = /*#__PURE__*/_regenerator.default.mark(executeSseStreamUnsubscribeAction),
  _marked10 = /*#__PURE__*/_regenerator.default.mark(executeCreateServerAction),
  _marked11 = /*#__PURE__*/_regenerator.default.mark(updateServerListAction),
  _marked12 = /*#__PURE__*/_regenerator.default.mark(getAvailablePluginsAction),
  _marked13 = /*#__PURE__*/_regenerator.default.mark(executeSetupLiveUpdateAction),
  _marked14 = /*#__PURE__*/_regenerator.default.mark(getWebhookSources),
  _marked15 = /*#__PURE__*/_regenerator.default.mark(executeLoadWebhookSourceFiltersAction),
  _marked16 = /*#__PURE__*/_regenerator.default.mark(executeUpdateWebhookSourceFiltersAction),
  _marked17 = /*#__PURE__*/_regenerator.default.mark(executeLoadServersAction),
  _marked18 = /*#__PURE__*/_regenerator.default.mark(executeLoadWebhookSourcesAction),
  _marked19 = /*#__PURE__*/_regenerator.default.mark(executeDeleteWebhookSourceAction),
  _marked20 = /*#__PURE__*/_regenerator.default.mark(executeLoadFilterEventSourceAction),
  _marked21 = /*#__PURE__*/_regenerator.default.mark(executeSaveEventSourceAction),
  _marked22 = /*#__PURE__*/_regenerator.default.mark(storeFiltersAction),
  _marked23 = /*#__PURE__*/_regenerator.default.mark(getFiltersAction),
  _marked24 = /*#__PURE__*/_regenerator.default.mark(updateBreadcrumbsAction),
  _marked25 = /*#__PURE__*/_regenerator.default.mark(executePatchExternalDeploymentsAction),
  _marked26 = /*#__PURE__*/_regenerator.default.mark(setLiveDeploymentsPreconditionFilterAction),
  _marked27 = /*#__PURE__*/_regenerator.default.mark(externalDeploymentsRootSaga);
var broadcastSseEvent = _sse.sse.actions.broadcastSseEvent;
var _folderExternalDeploy = _externalDeployments.folderExternalDeployments.actions,
  createApplicationStatus = _folderExternalDeploy.createApplicationStatus,
  updateServerList = _folderExternalDeploy.updateServerList,
  addValidPluginToArray = _folderExternalDeploy.addValidPluginToArray,
  getAvailablePlugins = _folderExternalDeploy.getAvailablePlugins,
  createServer = _folderExternalDeploy.createServer,
  deleteApplicationStatus = _folderExternalDeploy.deleteApplicationStatus,
  loadExternalDeployments = _folderExternalDeploy.loadExternalDeployments,
  loadWebhookSources = _folderExternalDeploy.loadWebhookSources,
  loadWebhookSourceFilters = _folderExternalDeploy.loadWebhookSourceFilters,
  loadServers = _folderExternalDeploy.loadServers,
  refreshExternalDeployments = _folderExternalDeploy.refreshExternalDeployments,
  setIsLoading = _folderExternalDeploy.setIsLoading,
  setConnectionServers = _folderExternalDeploy.setConnectionServers,
  setConfigDetails = _folderExternalDeploy.setConfigDetails,
  setExternalDeployments = _folderExternalDeploy.setExternalDeployments,
  setServers = _folderExternalDeploy.setServers,
  setExternalDeploymentsCount = _folderExternalDeploy.setExternalDeploymentsCount,
  setMaxAge = _folderExternalDeploy.setMaxAge,
  setLiveUpdate = _folderExternalDeploy.setLiveUpdate,
  setWebhookSources = _folderExternalDeploy.setWebhookSources,
  setWebhookSourceFilters = _folderExternalDeploy.setWebhookSourceFilters,
  addServerToServers = _folderExternalDeploy.addServerToServers,
  subscribeToSseStream = _folderExternalDeploy.subscribeToSseStream,
  unsubscribeFromSseStream = _folderExternalDeploy.unsubscribeFromSseStream,
  updateApplicationStatus = _folderExternalDeploy.updateApplicationStatus,
  updateBreadcrumbs = _folderExternalDeploy.updateBreadcrumbs,
  updateWebhookSourceFilters = _folderExternalDeploy.updateWebhookSourceFilters,
  deleteWebhookSource = _folderExternalDeploy.deleteWebhookSource,
  removeWebhookSource = _folderExternalDeploy.removeWebhookSource,
  setFilterEventSource = _folderExternalDeploy.setFilterEventSource,
  loadFilterEventSource = _folderExternalDeploy.loadFilterEventSource,
  saveEventSource = _folderExternalDeploy.saveEventSource,
  storeFilters = _folderExternalDeploy.storeFilters,
  getFilters = _folderExternalDeploy.getFilters,
  setPage = _folderExternalDeploy.setPage,
  setCondition = _folderExternalDeploy.setCondition,
  setConnectionErrors = _folderExternalDeploy.setConnectionErrors,
  setDisconnectedServers = _folderExternalDeploy.setDisconnectedServers,
  patchExternalDeployments = _folderExternalDeploy.patchExternalDeployments,
  setPreSelectedServer = _folderExternalDeploy.setPreSelectedServer,
  setLiveDeploymentsPreconditionFilter = _folderExternalDeploy.setLiveDeploymentsPreconditionFilter;
var toaster = exports.toaster = (0, _toastrFactory.default)();
var url = 'api/v1';
function executeLoadExternalDeploymentsWithRefreshAction() {
  return _regenerator.default.wrap(function executeLoadExternalDeploymentsWithRefreshAction$(_context) {
    while (1) switch (_context.prev = _context.next) {
      case 0:
        _context.next = 2;
        return (0, _effects.put)(setMaxAge(_constants.MAX_AGE_NO_CACHE));
      case 2:
        _context.next = 4;
        return (0, _effects.call)(executeLoadExternalDeploymentsAction);
      case 4:
        _context.next = 6;
        return (0, _effects.put)(setMaxAge(_constants.DEFAULT_MAX_AGE));
      case 6:
      case "end":
        return _context.stop();
    }
  }, _marked);
}
function executeUpdateApplicationPackageStatusAction(action) {
  var _yield$select, connectionServers, externalDeployments, _action$payload, endpointId, event, found, updatedDeployments;
  return _regenerator.default.wrap(function executeUpdateApplicationPackageStatusAction$(_context2) {
    while (1) switch (_context2.prev = _context2.next) {
      case 0:
        _context2.next = 2;
        return (0, _effects.select)(_externalDeployments2.getFolderExternalDeployments);
      case 2:
        _yield$select = _context2.sent;
        connectionServers = _yield$select.connectionServers;
        externalDeployments = _yield$select.externalDeployments;
        _action$payload = action.payload, endpointId = _action$payload.endpointId, event = _action$payload.state;
        found = false;
        updatedDeployments = externalDeployments.map(function (deployment) {
          var server = connectionServers.get(deployment.endpointId);
          if (deployment.applicationUid === event.applicationUid && event.destinationUid === deployment.state.destinationUid && (server === null || server === void 0 ? void 0 : server.id) === endpointId) {
            found = true;
            return _objectSpread(_objectSpread({}, deployment), event);
          }
          return deployment;
        });
        if (!found) {
          _context2.next = 13;
          break;
        }
        _context2.next = 11;
        return (0, _effects.put)(setExternalDeployments(updatedDeployments));
      case 11:
        _context2.next = 15;
        break;
      case 13:
        _context2.next = 15;
        return (0, _effects.call)(executeLoadExternalDeploymentsWithRefreshAction);
      case 15:
      case "end":
        return _context2.stop();
    }
  }, _marked2);
}
function executeDeleteApplicationPackageStatusAction(action) {
  var _yield$select2, connectionServers, externalDeployments, deleteEvent, eventEndpointId, updatedDeployments;
  return _regenerator.default.wrap(function executeDeleteApplicationPackageStatusAction$(_context3) {
    while (1) switch (_context3.prev = _context3.next) {
      case 0:
        _context3.next = 2;
        return (0, _effects.select)(_externalDeployments2.getFolderExternalDeployments);
      case 2:
        _yield$select2 = _context3.sent;
        connectionServers = _yield$select2.connectionServers;
        externalDeployments = _yield$select2.externalDeployments;
        deleteEvent = action.payload.state;
        eventEndpointId = action.payload.endpointId;
        updatedDeployments = externalDeployments.filter(function (_ref) {
          var applicationUid = _ref.applicationUid,
            endpointId = _ref.endpointId,
            state = _ref.state;
          var server = connectionServers.get(endpointId);
          return applicationUid !== deleteEvent.applicationUid || (server === null || server === void 0 ? void 0 : server.id) !== eventEndpointId || state.destinationUid !== deleteEvent.destinationUid;
        });
        _context3.next = 10;
        return (0, _effects.put)(setExternalDeployments(updatedDeployments));
      case 10:
      case "end":
        return _context3.stop();
    }
  }, _marked3);
}
function withLoadingState(effect) {
  var result;
  return _regenerator.default.wrap(function withLoadingState$(_context4) {
    while (1) switch (_context4.prev = _context4.next) {
      case 0:
        _context4.prev = 0;
        _context4.next = 3;
        return (0, _effects.put)(setIsLoading(true));
      case 3:
        _context4.next = 5;
        return effect;
      case 5:
        result = _context4.sent;
        return _context4.abrupt("return", result);
      case 7:
        _context4.prev = 7;
        _context4.next = 10;
        return (0, _effects.put)(setIsLoading(false));
      case 10:
        return _context4.finish(7);
      case 11:
      case "end":
        return _context4.stop();
    }
  }, _marked4, null, [[0,, 7, 11]]);
}
function executeLoadExternalDeploymentsAction() {
  return _regenerator.default.wrap(function executeLoadExternalDeploymentsAction$(_context5) {
    while (1) switch (_context5.prev = _context5.next) {
      case 0:
        _context5.next = 2;
        return (0, _effects.call)(_sagaUtils.withFlagChangingState, (0, _effects.call)(executeLoadExternalDeployments), setIsLoading);
      case 2:
      case "end":
        return _context5.stop();
    }
  }, _marked5);
}
function executeLoadExternalDeployments() {
  var _yield$select3, page, maxAge, condition, _yield$call, _yield$call$data, count, connectionServers, disconnectedServers, externalDeployments, errors, _err$response, err, errServerData, errorMessage;
  return _regenerator.default.wrap(function executeLoadExternalDeployments$(_context6) {
    while (1) switch (_context6.prev = _context6.next) {
      case 0:
        _context6.next = 2;
        return (0, _effects.select)(_externalDeployments2.getFolderExternalDeployments);
      case 2:
        _yield$select3 = _context6.sent;
        page = _yield$select3.page;
        maxAge = _yield$select3.maxAge;
        condition = _yield$select3.condition;
        if (!(!page || !page.folderId)) {
          _context6.next = 8;
          break;
        }
        return _context6.abrupt("return");
      case 8:
        _context6.prev = 8;
        _context6.next = 11;
        return (0, _effects.call)(_http.httpGET, "external-deployment?max-age=".concat(maxAge, "&folderId=").concat(page.folderId, "&page=").concat(page.page, "&resultsPerPage=").concat(page.resultsPerPage, "&orderBy=").concat((0, _utils.mapOrderByValue)(page.orderBy), "&order=").concat(page.order.toUpperCase(), "&condition=").concat(encodeURIComponent(condition)), true);
      case 11:
        _yield$call = _context6.sent;
        _yield$call$data = _yield$call.data;
        count = _yield$call$data.count;
        connectionServers = _yield$call$data.connectionServers;
        disconnectedServers = _yield$call$data.disconnectedServers;
        externalDeployments = _yield$call$data.externalDeployments;
        errors = _yield$call$data.errors;
        _context6.next = 20;
        return (0, _effects.put)(setConnectionServers(new Map(Object.entries(connectionServers))));
      case 20:
        _context6.next = 22;
        return (0, _effects.put)(setConnectionErrors(errors));
      case 22:
        _context6.next = 24;
        return (0, _effects.put)(setExternalDeployments(externalDeployments));
      case 24:
        _context6.next = 26;
        return (0, _effects.put)(setExternalDeploymentsCount(count));
      case 26:
        _context6.next = 28;
        return (0, _effects.put)(setDisconnectedServers(disconnectedServers));
      case 28:
        _context6.next = 37;
        break;
      case 30:
        _context6.prev = 30;
        _context6.t0 = _context6["catch"](8);
        err = _context6.t0;
        errServerData = (_err$response = err.response) === null || _err$response === void 0 ? void 0 : _err$response.data;
        errorMessage = 'Error fetching status data. Check connection to ' + (errServerData === null || errServerData === void 0 ? void 0 : errServerData.title) + ' HTTP Connection or check application logs for more details.';
        _context6.next = 37;
        return (0, _effects.call)(toaster.error, errorMessage);
      case 37:
      case "end":
        return _context6.stop();
    }
  }, _marked6, null, [[8, 30]]);
}
function executeSseStreamSubscribeAction() {
  return _regenerator.default.wrap(function executeSseStreamSubscribeAction$(_context7) {
    while (1) switch (_context7.prev = _context7.next) {
      case 0:
        _context7.next = 2;
        return (0, _effects.call)(_http.httpPOST, _constants.SSE_REGISTRATION_URL, {}, true);
      case 2:
      case "end":
        return _context7.stop();
    }
  }, _marked7);
}
function handleApplicationSseEventAction(action) {
  var _action$payload2, eventName, payload;
  return _regenerator.default.wrap(function handleApplicationSseEventAction$(_context8) {
    while (1) switch (_context8.prev = _context8.next) {
      case 0:
        _action$payload2 = action.payload, eventName = _action$payload2.eventName, payload = _action$payload2.payload;
        _context8.t0 = eventName;
        _context8.next = _context8.t0 === _constants.EVENT_TYPE.applicationPackageCreated ? 4 : _context8.t0 === _constants.EVENT_TYPE.applicationPackageDeleted ? 5 : _context8.t0 === _constants.EVENT_TYPE.applicationCreated ? 6 : _context8.t0 === _constants.EVENT_TYPE.applicationDeleted ? 9 : _context8.t0 === _constants.EVENT_TYPE.applicationChanged ? 12 : 15;
        break;
      case 4:
        return _context8.abrupt("break", 15);
      case 5:
        return _context8.abrupt("break", 15);
      case 6:
        _context8.next = 8;
        return (0, _effects.put)(createApplicationStatus(payload));
      case 8:
        return _context8.abrupt("break", 15);
      case 9:
        _context8.next = 11;
        return (0, _effects.put)(deleteApplicationStatus(payload));
      case 11:
        return _context8.abrupt("break", 15);
      case 12:
        _context8.next = 14;
        return (0, _effects.put)(updateApplicationStatus(payload));
      case 14:
        return _context8.abrupt("break", 15);
      case 15:
      case "end":
        return _context8.stop();
    }
  }, _marked8);
}
function executeSseStreamUnsubscribeAction() {
  return _regenerator.default.wrap(function executeSseStreamUnsubscribeAction$(_context9) {
    while (1) switch (_context9.prev = _context9.next) {
      case 0:
        _context9.next = 2;
        return (0, _effects.call)(_http.httpDELETE, _constants.SSE_REGISTRATION_URL);
      case 2:
      case "end":
        return _context9.stop();
    }
  }, _marked9);
}
function executeCreateServerAction(action) {
  var server, _yield$call2, data;
  return _regenerator.default.wrap(function executeCreateServerAction$(_context10) {
    while (1) switch (_context10.prev = _context10.next) {
      case 0:
        server = action.payload;
        _context10.next = 3;
        return (0, _effects.call)(withLoadingState, (0, _effects.call)(_http.httpPOST, "".concat(url, "/config"), server));
      case 3:
        _yield$call2 = _context10.sent;
        data = _yield$call2.data;
        _context10.next = 7;
        return (0, _effects.call)(toaster.success, "Server saved successfully");
      case 7:
        _context10.next = 9;
        return (0, _effects.put)(addServerToServers(data));
      case 9:
        _context10.next = 11;
        return (0, _effects.put)(setPreSelectedServer(data));
      case 11:
      case "end":
        return _context10.stop();
    }
  }, _marked10);
}
function updateServerListAction(action) {
  var id, _yield$call3, server, finalServerObj;
  return _regenerator.default.wrap(function updateServerListAction$(_context11) {
    while (1) switch (_context11.prev = _context11.next) {
      case 0:
        id = action.payload.id;
        _context11.next = 3;
        return (0, _effects.call)(_http.httpGET, "api/v1/config/".concat(id));
      case 3:
        _yield$call3 = _context11.sent;
        server = _yield$call3.data;
        finalServerObj = server;
        _context11.next = 8;
        return (0, _effects.call)(toaster.success, "Server saved successfully");
      case 8:
        _context11.next = 10;
        return (0, _effects.put)(addServerToServers(finalServerObj));
      case 10:
        _context11.next = 12;
        return (0, _effects.put)(setPreSelectedServer(finalServerObj));
      case 12:
      case "end":
        return _context11.stop();
    }
  }, _marked11);
}
function getAvailablePluginsAction(action) {
  var superType, _yield$call4, temp, filteredObjects, _iterator, _step, _filteredObj$properti, _filteredObj$properti2, _filteredObj$properti3, _filteredObj$properti4, filteredObj, iconLocation, isAutoconfigurable, subheader, title, pluginInfo;
  return _regenerator.default.wrap(function getAvailablePluginsAction$(_context12) {
    while (1) switch (_context12.prev = _context12.next) {
      case 0:
        superType = action.payload;
        _context12.next = 3;
        return (0, _effects.call)(withLoadingState, (0, _effects.call)(_http.httpGET, "metadata/type"));
      case 3:
        _yield$call4 = _context12.sent;
        temp = _yield$call4.data;
        filteredObjects = temp.filter(function (object) {
          return object.superTypes.includes(superType);
        });
        _iterator = _createForOfIteratorHelper(filteredObjects);
        _context12.prev = 7;
        _iterator.s();
      case 9:
        if ((_step = _iterator.n()).done) {
          _context12.next = 22;
          break;
        }
        filteredObj = _step.value;
        iconLocation = ((_filteredObj$properti = filteredObj.properties.find(function (obj) {
          return obj.name === 'iconLocation';
        })) === null || _filteredObj$properti === void 0 ? void 0 : _filteredObj$properti.default) || '';
        isAutoconfigurable = ((_filteredObj$properti2 = filteredObj.properties.find(function (obj) {
          return obj.name === 'isAutoconfigurable';
        })) === null || _filteredObj$properti2 === void 0 ? void 0 : _filteredObj$properti2.default) || false;
        subheader = ((_filteredObj$properti3 = filteredObj.properties.find(function (obj) {
          return obj.name === 'serverCardSubheader';
        })) === null || _filteredObj$properti3 === void 0 ? void 0 : _filteredObj$properti3.default) || '';
        title = ((_filteredObj$properti4 = filteredObj.properties.find(function (obj) {
          return obj.name === 'serverCardTitle';
        })) === null || _filteredObj$properti4 === void 0 ? void 0 : _filteredObj$properti4.default) || '';
        if (!(subheader.length === 0 || title.length === 0)) {
          _context12.next = 17;
          break;
        }
        return _context12.abrupt("continue", 20);
      case 17:
        pluginInfo = {
          iconLocation: iconLocation,
          isAutoconfigurable: isAutoconfigurable,
          subheader: subheader,
          title: title,
          type: filteredObj.type
        };
        _context12.next = 20;
        return (0, _effects.put)(addValidPluginToArray(pluginInfo));
      case 20:
        _context12.next = 9;
        break;
      case 22:
        _context12.next = 27;
        break;
      case 24:
        _context12.prev = 24;
        _context12.t0 = _context12["catch"](7);
        _iterator.e(_context12.t0);
      case 27:
        _context12.prev = 27;
        _iterator.f();
        return _context12.finish(27);
      case 30:
      case "end":
        return _context12.stop();
    }
  }, _marked12, null, [[7, 24, 27, 30]]);
}
function executeSetupLiveUpdateAction(action) {
  var folderId, serverId, _yield$call5, data;
  return _regenerator.default.wrap(function executeSetupLiveUpdateAction$(_context13) {
    while (1) switch (_context13.prev = _context13.next) {
      case 0:
        folderId = action.payload.folderId;
        serverId = action.payload.serverId;
        _context13.next = 4;
        return (0, _effects.call)(withLoadingState, (0, _effects.call)(_http.httpPOST, "external-deployment/setup/".concat(serverId, "?folderId=").concat(folderId)));
      case 4:
        _yield$call5 = _context13.sent;
        data = _yield$call5.data;
        _context13.next = 8;
        return (0, _effects.put)(setConfigDetails(data));
      case 8:
        _context13.next = 10;
        return (0, _effects.call)(getWebhookSources, folderId);
      case 10:
      case "end":
        return _context13.stop();
    }
  }, _marked13);
}
function getWebhookSources(folderId) {
  var _yield$call6, data;
  return _regenerator.default.wrap(function getWebhookSources$(_context14) {
    while (1) switch (_context14.prev = _context14.next) {
      case 0:
        _context14.next = 2;
        return (0, _effects.call)(withLoadingState, (0, _effects.call)(_http.httpGET, "".concat(url, "/config/byTypeAndTitle?configurationType=events.StatusWebhookEventSource&folderId=").concat(folderId, "&folderOnly=true")));
      case 2:
        _yield$call6 = _context14.sent;
        data = _yield$call6.data;
        _context14.next = 6;
        return (0, _effects.put)(setWebhookSources(data));
      case 6:
      case "end":
        return _context14.stop();
    }
  }, _marked14);
}
function executeLoadWebhookSourceFiltersAction(action) {
  var webhookSourceId, _yield$call7, webhookSourceFilters, err;
  return _regenerator.default.wrap(function executeLoadWebhookSourceFiltersAction$(_context15) {
    while (1) switch (_context15.prev = _context15.next) {
      case 0:
        webhookSourceId = action.payload;
        _context15.prev = 1;
        _context15.next = 4;
        return (0, _effects.call)(withLoadingState, (0, _effects.call)(_http.httpGET, "external-deployment/filters/".concat(webhookSourceId)));
      case 4:
        _yield$call7 = _context15.sent;
        webhookSourceFilters = _yield$call7.data;
        _context15.next = 8;
        return (0, _effects.put)(setWebhookSourceFilters(webhookSourceFilters));
      case 8:
        _context15.next = 15;
        break;
      case 10:
        _context15.prev = 10;
        _context15.t0 = _context15["catch"](1);
        err = _context15.t0;
        _context15.next = 15;
        return (0, _effects.call)(toaster.error, err.message);
      case 15:
      case "end":
        return _context15.stop();
    }
  }, _marked15, null, [[1, 10]]);
}
function executeUpdateWebhookSourceFiltersAction(action) {
  var saveWebhookSourceFiltersRequest, _yield$call8, updatedSource, webhookSources, updatedWebhookSources;
  return _regenerator.default.wrap(function executeUpdateWebhookSourceFiltersAction$(_context16) {
    while (1) switch (_context16.prev = _context16.next) {
      case 0:
        saveWebhookSourceFiltersRequest = action.payload;
        _context16.next = 3;
        return (0, _effects.call)(withLoadingState, (0, _effects.call)(_http.httpPUT, "external-deployment/filters/".concat(saveWebhookSourceFiltersRequest.webhookSourceId), saveWebhookSourceFiltersRequest.filteredFolders));
      case 3:
        _yield$call8 = _context16.sent;
        updatedSource = _yield$call8.data;
        _context16.next = 7;
        return (0, _effects.select)(_externalDeployments2.getWebhookSourcesSelector);
      case 7:
        webhookSources = _context16.sent;
        updatedWebhookSources = webhookSources.map(function (webhookSource) {
          if (webhookSource.id === updatedSource.id) return updatedSource;
          return webhookSource;
        });
        _context16.next = 11;
        return (0, _effects.put)(setWebhookSources(updatedWebhookSources));
      case 11:
      case "end":
        return _context16.stop();
    }
  }, _marked16);
}
function executeLoadServersAction(action) {
  var folderId, _yield$call9, servers;
  return _regenerator.default.wrap(function executeLoadServersAction$(_context17) {
    while (1) switch (_context17.prev = _context17.next) {
      case 0:
        folderId = action.payload;
        _context17.next = 3;
        return (0, _effects.call)(withLoadingState, (0, _effects.call)(_http.httpGET, "".concat(url, "/config/byTypeAndTitle?configurationType=configuration.StatusHttpConnection&folderId=").concat(folderId)));
      case 3:
        _yield$call9 = _context17.sent;
        servers = _yield$call9.data;
        _context17.next = 7;
        return (0, _effects.put)(setServers(servers));
      case 7:
      case "end":
        return _context17.stop();
    }
  }, _marked17);
}
function executeLoadWebhookSourcesAction(action) {
  var folderId;
  return _regenerator.default.wrap(function executeLoadWebhookSourcesAction$(_context18) {
    while (1) switch (_context18.prev = _context18.next) {
      case 0:
        folderId = action.payload;
        _context18.next = 3;
        return (0, _effects.call)(getWebhookSources, folderId);
      case 3:
      case "end":
        return _context18.stop();
    }
  }, _marked18);
}
function executeDeleteWebhookSourceAction(action) {
  var webhookSourceId;
  return _regenerator.default.wrap(function executeDeleteWebhookSourceAction$(_context19) {
    while (1) switch (_context19.prev = _context19.next) {
      case 0:
        webhookSourceId = action.payload;
        _context19.next = 3;
        return (0, _effects.call)(withLoadingState, (0, _effects.call)(_http.httpDELETE, "external-deployment/delete/".concat(webhookSourceId)));
      case 3:
        _context19.next = 5;
        return (0, _effects.put)(removeWebhookSource(webhookSourceId));
      case 5:
      case "end":
        return _context19.stop();
    }
  }, _marked19);
}
function executeLoadFilterEventSourceAction(action) {
  var eventSourceId, _yield$call10, eventSource;
  return _regenerator.default.wrap(function executeLoadFilterEventSourceAction$(_context20) {
    while (1) switch (_context20.prev = _context20.next) {
      case 0:
        eventSourceId = action.payload;
        _context20.next = 3;
        return (0, _effects.call)(withLoadingState, (0, _effects.call)(_http.httpGET, "".concat(url, "/config/").concat(eventSourceId)));
      case 3:
        _yield$call10 = _context20.sent;
        eventSource = _yield$call10.data;
        _context20.next = 7;
        return (0, _effects.put)(setFilterEventSource(eventSource));
      case 7:
      case "end":
        return _context20.stop();
    }
  }, _marked20);
}
function executeSaveEventSourceAction(action) {
  var webhookEventSource;
  return _regenerator.default.wrap(function executeSaveEventSourceAction$(_context21) {
    while (1) switch (_context21.prev = _context21.next) {
      case 0:
        webhookEventSource = action.payload;
        _context21.next = 3;
        return (0, _effects.call)(withLoadingState, (0, _effects.call)(_http.httpPUT, "".concat(url, "/config/").concat(webhookEventSource.id), webhookEventSource));
      case 3:
        _context21.next = 5;
        return (0, _effects.call)(toaster.success, "Webhook endpoint updated successfully");
      case 5:
      case "end":
        return _context21.stop();
    }
  }, _marked21);
}
function storeFiltersAction() {
  var _yield$select4, page, condition, clientSettings, FiltersQueryParams;
  return _regenerator.default.wrap(function storeFiltersAction$(_context22) {
    while (1) switch (_context22.prev = _context22.next) {
      case 0:
        _context22.next = 2;
        return (0, _effects.select)(_externalDeployments2.getFolderExternalDeployments);
      case 2:
        _yield$select4 = _context22.sent;
        page = _yield$select4.page;
        condition = _yield$select4.condition;
        _context22.next = 7;
        return (0, _effects.call)(_angularAccessor.default, 'ClientSettings');
      case 7:
        clientSettings = _context22.sent;
        clientSettings.setExternalDeploymentsFilters(_objectSpread(_objectSpread({}, page), {}, {
          condition: condition
        }));
        _context22.next = 11;
        return (0, _effects.call)(_angularAccessor.default, 'FiltersQueryParams');
      case 11:
        FiltersQueryParams = _context22.sent;
        FiltersQueryParams.update(_objectSpread(_objectSpread({}, page), {}, {
          condition: condition
        }));
      case 13:
      case "end":
        return _context22.stop();
    }
  }, _marked22);
}
function getFiltersAction(action) {
  var folderId, clientSettings, filters, stateParams, condition;
  return _regenerator.default.wrap(function getFiltersAction$(_context23) {
    while (1) switch (_context23.prev = _context23.next) {
      case 0:
        folderId = action.payload;
        _context23.next = 3;
        return (0, _effects.call)(_angularAccessor.default, 'ClientSettings');
      case 3:
        clientSettings = _context23.sent;
        filters = clientSettings.getExternalDeploymentsFilters();
        _context23.next = 7;
        return (0, _effects.call)(_angularAccessor.default, '$stateParams');
      case 7:
        stateParams = _context23.sent;
        condition = stateParams.condition;
        if (condition) filters.condition = condition;
        if (!filters) {
          _context23.next = 15;
          break;
        }
        _context23.next = 13;
        return (0, _effects.put)(setCondition(filters.condition));
      case 13:
        _context23.next = 15;
        return (0, _effects.put)(setPage({
          folderId: folderId,
          page: filters.page,
          order: filters.order,
          orderBy: filters.orderBy,
          resultsPerPage: filters.resultsPerPage
        }));
      case 15:
      case "end":
        return _context23.stop();
    }
  }, _marked23);
}
function updateBreadcrumbsAction(action) {
  var folder, breadcrumbs, breadcrumbService;
  return _regenerator.default.wrap(function updateBreadcrumbsAction$(_context24) {
    while (1) switch (_context24.prev = _context24.next) {
      case 0:
        folder = action.payload;
        breadcrumbs = [{
          pathSuffix: 'folders/' + folder.id,
          label: folder.title,
          folder: folder
        }, {
          pathSuffix: 'folders/' + folder.id + '/external-deployments',
          label: 'Application deployments',
          folder: folder
        }, {
          label: 'Application Sources'
        }];
        _context24.next = 4;
        return (0, _effects.call)(_angularAccessor.default, 'BreadcrumbsService');
      case 4:
        breadcrumbService = _context24.sent;
        breadcrumbService.updateBreadcrumbs(breadcrumbs, false);
      case 6:
      case "end":
        return _context24.stop();
    }
  }, _marked24);
}
function executePatchExternalDeploymentsAction(action) {
  var webhookSourceId;
  return _regenerator.default.wrap(function executePatchExternalDeploymentsAction$(_context25) {
    while (1) switch (_context25.prev = _context25.next) {
      case 0:
        webhookSourceId = action.payload;
        _context25.next = 3;
        return (0, _effects.call)(withLoadingState, (0, _effects.call)(_http.httpPOST, "external-deployment/patch/".concat(webhookSourceId)));
      case 3:
        _context25.next = 5;
        return (0, _effects.call)(toaster.success, "External deployments patched successfully");
      case 5:
      case "end":
        return _context25.stop();
    }
  }, _marked25);
}
function setLiveDeploymentsPreconditionFilterAction(action) {
  var folderId, condition;
  return _regenerator.default.wrap(function setLiveDeploymentsPreconditionFilterAction$(_context26) {
    while (1) switch (_context26.prev = _context26.next) {
      case 0:
        folderId = action.payload.folderId;
        condition = action.payload.applicationName;
        _context26.next = 4;
        return (0, _effects.put)(setPage(_objectSpread(_objectSpread({}, _externalDeployments.initialPage), {}, {
          folderId: folderId
        })));
      case 4:
        _context26.next = 6;
        return (0, _effects.put)(setCondition(condition));
      case 6:
        _context26.next = 8;
        return (0, _effects.call)(storeFiltersAction);
      case 8:
      case "end":
        return _context26.stop();
    }
  }, _marked26);
}
function externalDeploymentsRootSaga() {
  return _regenerator.default.wrap(function externalDeploymentsRootSaga$(_context27) {
    while (1) switch (_context27.prev = _context27.next) {
      case 0:
        _context27.next = 2;
        return (0, _effects.all)([(0, _effects.takeEvery)(createApplicationStatus, executeLoadExternalDeploymentsWithRefreshAction), (0, _effects.takeEvery)(createServer, executeCreateServerAction), (0, _effects.takeEvery)(updateServerList, updateServerListAction), (0, _effects.takeEvery)(getAvailablePlugins, getAvailablePluginsAction), (0, _effects.takeEvery)(deleteApplicationStatus, executeDeleteApplicationPackageStatusAction), (0, _effects.takeEvery)(deleteWebhookSource, executeDeleteWebhookSourceAction), (0, _effects.takeEvery)(getFilters, getFiltersAction), (0, _effects.takeEvery)(loadExternalDeployments, executeLoadExternalDeploymentsAction), (0, _effects.takeEvery)(loadFilterEventSource, executeLoadFilterEventSourceAction), (0, _effects.takeEvery)(loadServers, executeLoadServersAction), (0, _effects.takeEvery)(loadWebhookSourceFilters, executeLoadWebhookSourceFiltersAction), (0, _effects.takeEvery)(loadWebhookSources, executeLoadWebhookSourcesAction), (0, _effects.takeEvery)(patchExternalDeployments, executePatchExternalDeploymentsAction), (0, _effects.takeEvery)(refreshExternalDeployments, executeLoadExternalDeploymentsWithRefreshAction), (0, _effects.takeEvery)(saveEventSource, executeSaveEventSourceAction), (0, _effects.takeEvery)(setLiveUpdate, executeSetupLiveUpdateAction), (0, _effects.takeEvery)(storeFilters, storeFiltersAction), (0, _effects.takeEvery)(subscribeToSseStream, executeSseStreamSubscribeAction), (0, _effects.takeEvery)(unsubscribeFromSseStream, executeSseStreamUnsubscribeAction), (0, _effects.takeEvery)(updateApplicationStatus, executeUpdateApplicationPackageStatusAction), (0, _effects.takeEvery)(updateBreadcrumbs, updateBreadcrumbsAction), (0, _effects.takeEvery)(updateWebhookSourceFilters, executeUpdateWebhookSourceFiltersAction), (0, _effects.takeEvery)(broadcastSseEvent, handleApplicationSseEventAction), (0, _effects.takeEvery)(setLiveDeploymentsPreconditionFilter, setLiveDeploymentsPreconditionFilterAction)]);
      case 2:
      case "end":
        return _context27.stop();
    }
  }, _marked27);
}

/***/ }),

/***/ 12098:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getWebhookSourcesSelector = exports.getWebhookSourceFiltersSelector = exports.getValidServerCards = exports.getServersSelector = exports.getPreSelectedServer = exports.getIsLoadingSelector = exports.getFolderExternalDeployments = exports.getFilterEventSourceSelector = exports.getExternalDeploymentsSelector = exports.getExternalDeploymentPageSelector = exports.getExternalDeploymentCountSelector = exports.getDisconnectedServers = exports.getConnectionServersSelector = exports.getConnectionErrorsSelector = exports.getConfigDetailsSelector = exports.getConditionSelector = void 0;
var getFolderExternalDeployments = exports.getFolderExternalDeployments = function getFolderExternalDeployments(state) {
  return state.folderExternalDeployments;
};
var getConnectionServersSelector = exports.getConnectionServersSelector = function getConnectionServersSelector(state) {
  return getFolderExternalDeployments(state).connectionServers;
};
var getExternalDeploymentsSelector = exports.getExternalDeploymentsSelector = function getExternalDeploymentsSelector(state) {
  return getFolderExternalDeployments(state).externalDeployments;
};
var getExternalDeploymentPageSelector = exports.getExternalDeploymentPageSelector = function getExternalDeploymentPageSelector(state) {
  return getFolderExternalDeployments(state).page;
};
var getExternalDeploymentCountSelector = exports.getExternalDeploymentCountSelector = function getExternalDeploymentCountSelector(state) {
  return getFolderExternalDeployments(state).count;
};
var getIsLoadingSelector = exports.getIsLoadingSelector = function getIsLoadingSelector(state) {
  return getFolderExternalDeployments(state).isLoading;
};
var getConfigDetailsSelector = exports.getConfigDetailsSelector = function getConfigDetailsSelector(state) {
  return getFolderExternalDeployments(state).configDetails;
};
var getWebhookSourcesSelector = exports.getWebhookSourcesSelector = function getWebhookSourcesSelector(state) {
  return getFolderExternalDeployments(state).webhookSources;
};
var getServersSelector = exports.getServersSelector = function getServersSelector(state) {
  return getFolderExternalDeployments(state).servers;
};
var getWebhookSourceFiltersSelector = exports.getWebhookSourceFiltersSelector = function getWebhookSourceFiltersSelector(state) {
  return getFolderExternalDeployments(state).webhookSourceFilters;
};
var getFilterEventSourceSelector = exports.getFilterEventSourceSelector = function getFilterEventSourceSelector(state) {
  return getFolderExternalDeployments(state).filterEventSource;
};
var getConditionSelector = exports.getConditionSelector = function getConditionSelector(state) {
  return getFolderExternalDeployments(state).condition;
};
var getConnectionErrorsSelector = exports.getConnectionErrorsSelector = function getConnectionErrorsSelector(state) {
  return getFolderExternalDeployments(state).connectionErrors;
};
var getDisconnectedServers = exports.getDisconnectedServers = function getDisconnectedServers(state) {
  return getFolderExternalDeployments(state).disconnectedServers;
};
var getPreSelectedServer = exports.getPreSelectedServer = function getPreSelectedServer(state) {
  return getFolderExternalDeployments(state).preSelectedServer;
};
var getValidServerCards = exports.getValidServerCards = function getValidServerCards(state) {
  return getFolderExternalDeployments(state).validServerCards;
};

/***/ }),

/***/ 95461:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.mapOrderByValue = exports.getVersionTooltip = exports.getVersionLink = exports.getVersionLabel = exports.getTrimmedCommitHashFromCommitUrl = exports.getDeepLink = exports.getCommitHashFromCommitUrl = exports.generateEnvironmentTitle = void 0;
var _constants = __webpack_require__(71297);
var getDeepLink = exports.getDeepLink = function getDeepLink(endpointUrl, applicationPath) {
  return endpointUrl.replace(/\/+$/, '') + (applicationPath ? applicationPath : '');
};
var mapOrderByValue = exports.mapOrderByValue = function mapOrderByValue(columnName) {
  switch (columnName) {
    case _constants.APPLICATION_COLUMN_ID:
      {
        return _constants.APPLICATION_ORDER_BY;
      }
    case _constants.STATUS_COLUMN_ID:
      {
        return _constants.STATUS_ORDER_BY;
      }
    case _constants.DESTINATION_COLUMN_ID:
      {
        return _constants.DESTINATION_ORDER_BY;
      }
    case _constants.VERSION_COLUMN_ID:
      {
        return _constants.VERSION_ORDER_BY;
      }
    case _constants.TIME_COLUMN_ID:
      {
        return _constants.TIME_ORDER_BY;
      }
    default:
      {
        return _constants.STATUS_ORDER_BY;
      }
  }
};
var generateEnvironmentTitle = exports.generateEnvironmentTitle = function generateEnvironmentTitle(state) {
  var namespace = state.namespace;
  var destination = state.destination;
  return namespace && namespace.trim() !== '' ? "".concat(destination, "/").concat(namespace) : destination;
};
var getCommitHashFromCommitUrl = exports.getCommitHashFromCommitUrl = function getCommitHashFromCommitUrl(commitUrl) {
  return commitUrl.substring(commitUrl.lastIndexOf('/') + 1);
};
var getTrimmedCommitHashFromCommitUrl = exports.getTrimmedCommitHashFromCommitUrl = function getTrimmedCommitHashFromCommitUrl(commitUrl) {
  var hash = getCommitHashFromCommitUrl(commitUrl);
  if (hash.length > 6) return hash.substring(0, 7);else return hash;
};
var getVersionLabel = exports.getVersionLabel = function getVersionLabel(isAutoconfigurable, label) {
  if (isAutoconfigurable) {
    if (label.includes('/commit/')) return '#' + getTrimmedCommitHashFromCommitUrl(label);else if (label.includes('/')) return label.substring(label.lastIndexOf('/') + 1);else return label;
  } else return label;
};
var getVersionTooltip = exports.getVersionTooltip = function getVersionTooltip(isAutoconfigurable, label) {
  if (isAutoconfigurable) {
    if (label.includes('/commit/')) return getCommitHashFromCommitUrl(label);else if (label.includes('/')) return label.substring(0, label.lastIndexOf('/'));else return label;
  } else return label;
};

// eslint-disable-next-line max-params
var getVersionLink = exports.getVersionLink = function getVersionLink(isAutoconfigurable, label, endpointUrl, applicationPath) {
  if (isAutoconfigurable) {
    if (label.includes('/commit/')) return label;else if (label.includes('/')) return label.substring(0, label.lastIndexOf('/'));else return label;
  } else return getDeepLink(endpointUrl, applicationPath);
};

/***/ }),

/***/ 64583:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.store = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _effects = __webpack_require__(34857);
var _externalDeployments = _interopRequireDefault(__webpack_require__(64507));
var _applicationWizard = __webpack_require__(39958);
var _externalDeployments2 = __webpack_require__(69041);
var _applicationWizard2 = __webpack_require__(2387);
var _appConfig = __webpack_require__(89887);
var _managedApplication = __webpack_require__(72198);
var _managedApplication2 = __webpack_require__(46510);
var _marked = /*#__PURE__*/_regenerator.default.mark(combinedSaga);
/* global window */
var reducers = {
  externalApplicationWizard: _applicationWizard2.externalApplicationWizard.reducer,
  folderExternalDeployments: _externalDeployments2.folderExternalDeployments.reducer,
  applicationManagement: _managedApplication.applicationManagement.reducer
};
function combinedSaga() {
  return _regenerator.default.wrap(function combinedSaga$(_context) {
    while (1) switch (_context.prev = _context.next) {
      case 0:
        if (false) {}
        _context.prev = 1;
        _context.next = 4;
        return (0, _effects.all)([(0, _effects.call)(_applicationWizard.applicationWizardSagas), (0, _effects.call)(_externalDeployments.default), (0, _effects.call)(_managedApplication2.managedApplicationSaga)]);
      case 4:
        _context.next = 9;
        break;
      case 6:
        _context.prev = 6;
        _context.t0 = _context["catch"](1);
        // eslint-disable-next-line no-console,angular/log
        console.error('Error from external deployment store saga', _context.t0);
      case 9:
        _context.next = 0;
        break;
      case 11:
      case "end":
        return _context.stop();
    }
  }, _marked, null, [[1, 6]]);
}
var store = exports.store = store || (0, _appConfig.enhanceStore)(reducers, combinedSaga);

/***/ }),

/***/ 91015:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _react2angular = __webpack_require__(96563);
var _folderExternalDeployments = __webpack_require__(39985);
var _folderApplicationSourcesPage = __webpack_require__(20189);
var _folderApplicationsManagement = __webpack_require__(44220);
__webpack_require__(22306);
var folder = ['$stateParams', 'FoldersService', function ($stateParams, FoldersService) {
  return FoldersService.get($stateParams.folderId);
}];
angular.module('xlrelease.folder').component('folderApplicationsManagementPage', (0, _react2angular.react2angular)(_folderApplicationsManagement.FolderApplicationsManagementPage, ['folder'])).component('folderExternalDeploymentsPage', (0, _react2angular.react2angular)(_folderExternalDeployments.FolderExternalDeploymentsPage, ['folder'])).component('folderApplicationSourcesPage', (0, _react2angular.react2angular)(_folderApplicationSourcesPage.FolderApplicationSourcePage, ['folder'])).config(['$urlMatcherFactoryProvider', '$urlRouterProvider', '$stateProvider', function ($urlMatcherFactoryProvider, $urlRouterProvider, $stateProvider) {
  $stateProvider.state('folders.detail.applications-management', {
    url: '/application-pipelines/applications-management?condition',
    template: '<folder-applications-management-page folder="$resolve.folder"></folder-applications-management-page>',
    resolve: {
      folder: folder
    }
  }).state('folders.detail.external-deployments', {
    url: '/application-pipelines/external-deployments?condition',
    template: '<folder-external-deployments-page folder="$resolve.folder"></folder-external-deployments-page>',
    resolve: {
      folder: folder
    }
  }).state('folders.detail.application-sources', {
    url: '/application-pipelines/external-deployments/application-sources',
    template: '<folder-application-sources-page folder="$resolve.folder"></folder-application-sources-page>',
    resolve: {
      folder: folder
    }
  }).state('stepper', {
    url: '/{page:releases|stepper}/:releaseId',
    template: '<stepper release-id="$resolve.releaseId" location-path="$resolve.locationPath" releases-service="$resolve.releasesService"></stepper>',
    resolve: {
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getRelease($stateParams.releaseId);
      }],
      releaseId: ['$stateParams', function ($stateParams) {
        return $stateParams.releaseId;
      }],
      locationPath: ['$location', function ($location) {
        return $location.path();
      }],
      releasesService: ['ReleasesService', function (ReleasesService) {
        return ReleasesService;
      }]
    }
  });
}]);

/***/ }),

/***/ 22306:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ApplicationPipelinesSidebarProvider = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(319));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _sidebar = __webpack_require__(73811);
var _navigation = __webpack_require__(17523);
var _effects = __webpack_require__(34857);
var _folders = __webpack_require__(59462);
var _angularAccessor = _interopRequireDefault(__webpack_require__(81403));
var _navigation$actions = _navigation.navigation.actions,
  setSidebarMenu = _navigation$actions.setSidebarMenu,
  setBackItem = _navigation$actions.setBackItem,
  updateBreadcrumbs = _navigation$actions.updateBreadcrumbs;
var ApplicationPipelinesSidebarProvider = exports.ApplicationPipelinesSidebarProvider = /*#__PURE__*/function () {
  function ApplicationPipelinesSidebarProvider() {
    (0, _classCallCheck2.default)(this, ApplicationPipelinesSidebarProvider);
  }
  (0, _createClass2.default)(ApplicationPipelinesSidebarProvider, [{
    key: "isSupported",
    value: function isSupported(path) {
      return path.startsWith('/folders') && path !== '/folders' && path.includes('/application-pipelines/');
    }
  }, {
    key: "provide",
    value: /*#__PURE__*/_regenerator.default.mark(function provide(path) {
      var _this = this;
      var selectedFolder, uiExtensionsService, folderTabs, folderSidebar, selectedTab, folderPathService, parentFolders, folderBreadcrumbs;
      return _regenerator.default.wrap(function provide$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return (0, _effects.call)(_folders.getFolderOrWaitForIt);
          case 2:
            selectedFolder = _context.sent;
            _context.next = 5;
            return (0, _effects.call)(_angularAccessor.default, 'UiExtensionsService');
          case 5:
            uiExtensionsService = _context.sent;
            _context.next = 8;
            return (0, _effects.call)([uiExtensionsService, uiExtensionsService.getMenuItems], 'xlrelease.sidebar.Folder.ApplicationPipelines', selectedFolder);
          case 8:
            folderTabs = _context.sent;
            folderSidebar = folderTabs.filter(function (tab) {
              return tab.permitted;
            }).map(function (tab) {
              return {
                text: tab.label,
                startIconId: tab.icon,
                pathSuffix: "folders/".concat(selectedFolder.id, "/application-pipelines/").concat(tab.pathSuffix),
                selected: _this.isActivePath(path, tab.pathSuffix),
                tabSuffix: tab.pathSuffix
              };
            });
            selectedTab = folderSidebar.find(function (s) {
              return s.selected;
            });
            if (!selectedTab) {
              _context.next = 26;
              break;
            }
            _context.next = 14;
            return (0, _effects.put)(setSidebarMenu({
              sidebarMenu: folderSidebar,
              withFolder: false
            }));
          case 14:
            _context.next = 16;
            return (0, _effects.put)(setBackItem({
              pathSuffix: "folders/".concat(selectedFolder.id, "/templates"),
              title: selectedFolder.title,
              text: selectedFolder.title
            }));
          case 16:
            _context.next = 18;
            return (0, _effects.call)(_angularAccessor.default, 'FolderPathService');
          case 18:
            folderPathService = _context.sent;
            _context.next = 21;
            return (0, _effects.call)([folderPathService, folderPathService.getPathFromParentFolderId], selectedFolder.id);
          case 21:
            parentFolders = _context.sent;
            folderBreadcrumbs = [];
            folderBreadcrumbs.push.apply(folderBreadcrumbs, (0, _toConsumableArray2.default)(parentFolders.map(function (f) {
              return {
                text: f.title,
                href: "/folders/".concat(f.id, "/application-pipelines/").concat(selectedTab.tabSuffix)
              };
            })));
            _context.next = 26;
            return (0, _effects.put)(updateBreadcrumbs(folderBreadcrumbs));
          case 26:
          case "end":
            return _context.stop();
        }
      }, provide);
    })
  }, {
    key: "isActivePath",
    value: function isActivePath(path, pathSuffix) {
      if (!pathSuffix) return false;
      if (path.endsWith('/application-pipelines')) return pathSuffix === 'applications-management';
      return path.includes(pathSuffix);
    }
  }]);
  return ApplicationPipelinesSidebarProvider;
}();
(0, _sidebar.registerSidebarProvider)(new ApplicationPipelinesSidebarProvider(), 50);

/***/ }),

/***/ 24810:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


__webpack_require__(11240);
__webpack_require__(37535);

/***/ }),

/***/ 11240:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.scmCommitDataModal = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _parseGithubUrl = _interopRequireDefault(__webpack_require__(99430));
__webpack_require__(30458);
var template = "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">Meta information - {{$ctrl.resolve.data.title}} </h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"></i></button>\n        <div class=\"clearfix\"></div>\n    </div>\n    <div class=\"modal-body version-control\">\n        <h4> Source Control Management </h4>\n       \n        <p ng-show=\"$ctrl.noData\"> No data available.</p>\n        \n        <div  ng-hide=\"$ctrl.noData\">\n            <div class=\"col-sm-3\">\n               Commit\n            </div>\n            <div class=\"col-sm-9\">\n                <span class=\"coc-label-button\"> {{$ctrl.coc.kind | uppercase }} </span> <a href={{$ctrl.coc.commitUrl}} target=\"_blank\" rel=\"noopener\" class=\"coc-link\"> {{$ctrl.coc.commit}} </a> \n            </div>\n            <div class=\"col-sm-3\">\n               Timestamp\n            </div>\n            <div class=\"col-sm-9\">\n                {{ $ctrl.coc.date | date:'MMM dd, yyyy hh:mm:ss a' }}\n            </div>\n            <div class=\"col-sm-3\">\n               Committed by\n            </div>\n            <div class=\"col-sm-9\">\n                {{$ctrl.coc.author}}\n            </div>\n            <div class=\"col-sm-3\">\n               Summary\n            </div>\n            <div class=\"col-sm-9 coc-message\">\n                {{$ctrl.coc.message}}\n            </div>\n         \n            <div class=\"col-sm-3\">\n               Source\n            </div>\n            <div class=\"col-sm-9\">\n                <a href={{$ctrl.coc.url}} target=\"_blank\" rel=\"noopener\" class=\"coc-link\"> {{$ctrl.coc.url}} </a>\n            </div>\n            <div class=\"col-sm-3\">\n                File name\n            </div>\n            <div class=\"col-sm-9\">\n                <a href={{$ctrl.coc.fileUrl}} target=\"_blank\" rel=\"noopener\" class=\"coc-link\"> {{$ctrl.coc.fileName}} </a>\n            </div>\n        </div>\n    </div>\n    <div class=\"modal-footer\">\n        &nbsp;<button type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.dismiss()\">Close</button>\n    </div>\n";
var SCMCommitDataModalController = /*#__PURE__*/function () {
  function SCMCommitDataModalController(XlrCocSCMService) {
    (0, _classCallCheck2.default)(this, SCMCommitDataModalController);
    this.XlrCocSCMService = XlrCocSCMService;
  }
  (0, _createClass2.default)(SCMCommitDataModalController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;
      this.noData = true;
      var fetchedData = this.XlrCocSCMService.fetchSCMData(this.resolve.data.scmId);
      if (fetchedData) {
        fetchedData.then(function (coc) {
          _this.coc = coc.data;
          if (_this.coc && _this.coc !== null) {
            _this.noData = false;
            _this.coc.commitUrl = _this.getCommitUrl(_this.coc.commit);
            _this.coc.fileUrl = _this.getFileUrl(_this.coc.commit, _this.coc.fileName);
            _this.coc.url = _this.getUrl('');
          }
        });
      }
    }
  }, {
    key: "getFileUrl",
    value: function getFileUrl(commit, file) {
      var filePath = "blob/".concat(commit, "/").concat(file);
      return this.getUrl(filePath);
    }
  }, {
    key: "getUrl",
    value: function getUrl(path) {
      var url = (0, _parseGithubUrl.default)(this.coc.remote);
      var sourceUrl = "https://".concat(url.host, "/").concat(url.owner, "/").concat(url.name);
      return "".concat(sourceUrl, "/").concat(path);
    }
  }, {
    key: "getCommitUrl",
    value: function getCommitUrl(path) {
      var commitPath = "commit/".concat(path);
      return this.getUrl(commitPath);
    }
  }]);
  return SCMCommitDataModalController;
}();
(0, _defineProperty2.default)(SCMCommitDataModalController, "$inject", ['XlrCocSCMService']);
var scmCommitDataModal = exports.scmCommitDataModal = {
  bindings: {
    close: '&',
    dismiss: '&',
    resolve: '<'
  },
  controller: SCMCommitDataModalController,
  template: template
};
angular.module('xlrelease').component('xlrSCMModal', scmCommitDataModal);

/***/ }),

/***/ 37535:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var XlrCocSCMService = /*#__PURE__*/function () {
  function XlrCocSCMService(Backend) {
    (0, _classCallCheck2.default)(this, XlrCocSCMService);
    this.Backend = Backend;
  }
  (0, _createClass2.default)(XlrCocSCMService, [{
    key: "fetchSCMData",
    value: function fetchSCMData(scmId) {
      if (scmId) {
        return this.Backend.get("coc/scm-traceability?id=".concat(scmId));
      }
      return null;
    }
  }]);
  return XlrCocSCMService;
}();
(0, _defineProperty2.default)(XlrCocSCMService, "$inject", ['Backend']);
angular.module('xlrelease').service('XlrCocSCMService', XlrCocSCMService);

/***/ }),

/***/ 86747:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AddDashboardPage = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _xlrDashboardConstants = __webpack_require__(56918);
var template = "\n    <xlr-add-dashboard-portal folder-id=\"$ctrl.folderId\"></xlr-add-dashboard-portal>\n    <div class=\"dashboard-create-page\">\n        <div class=\"content-under-header\">\n            <div class=\"dashboard-sidebar\">\n                <div class=\"right-sidebar\">\n                    <xlr-dashboard-templates\n                        ng-if=\"!$ctrl.selectedTemplateType\"\n                        parent-id=\"$ctrl.folderId\"\n                        on-select=\"$ctrl.onSelect(templateType)\"\n                        on-cancel=\"$ctrl.onCancel()\">\n                    </xlr-dashboard-templates>\n                    <xlr-dashboard-properties\n                        ng-if=\"$ctrl.selectedTemplateType\"\n                        parent-id=\"$ctrl.folderId\"\n                        template-type=\"$ctrl.selectedTemplateType\"\n                        on-save=\"$ctrl.onSave(dashboard, isNew)\"\n                        on-cancel=\"$ctrl.selectedTemplateType = null\">\n                    </xlr-dashboard-properties>\n                </div>\n            </div>\n        </div>\n    </div>\n";
var AddDashboardPageController = /*#__PURE__*/function () {
  function AddDashboardPageController($state, $stateParams, Page) {
    (0, _classCallCheck2.default)(this, AddDashboardPageController);
    this.$state = $state;
    this.$stateParams = $stateParams;
    this.Page = Page;
  }
  (0, _createClass2.default)(AddDashboardPageController, [{
    key: "$onInit",
    value: function $onInit() {
      this.folderId = this.$stateParams.folderId;
      if (this.folderId) {
        this.Page.setDashboardOpened({
          parentId: this.folderId,
          title: 'New dashboard'
        });
      }
    }
  }, {
    key: "onSelect",
    value: function onSelect(templateType) {
      this.selectedTemplateType = templateType;
    }
  }, {
    key: "onSave",
    value: function onSave(dashboard) {
      var state = this.folderId ? 'folders.detail.folderDashboards' : 'dashboards';
      this.$state.go(state, {
        dashboardId: dashboard.id,
        folderId: this.folderId,
        dashboardMode: this.selectedTemplateType && this.selectedTemplateType.type === 'xlrelease.BlankDashboard' ? _xlrDashboardConstants.DASHBOARD_MODE.DESIGN : _xlrDashboardConstants.DASHBOARD_MODE.VIEW
      }, {
        reload: true
      });
    }
  }, {
    key: "onCancel",
    value: function onCancel() {
      this.$state.go('folders.detail.page', {
        folderId: this.folderId,
        page: 'dashboards'
      });
    }
  }]);
  return AddDashboardPageController;
}();
(0, _defineProperty2.default)(AddDashboardPageController, "$inject", ['$state', '$stateParams', 'Page']);
var AddDashboardPage = exports.AddDashboardPage = {
  controller: AddDashboardPageController,
  template: template
};
angular.module('xlrelease.dashboard').component('xlrAddDashboardPage', AddDashboardPage);

/***/ }),

/***/ 71953:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AddDashboardPagePortal = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _actionToolbar = __webpack_require__(29755);
var _xlrDashboardConstants = __webpack_require__(56918);
var AddDashboardPagePortal = exports.AddDashboardPagePortal = function AddDashboardPagePortal(_ref) {
  var folderId = _ref.folderId;
  var handleCancelClick = function handleCancelClick() {
    if (folderId) {
      window.location.href = "#/folders/".concat(folderId, "/dashboards");
    } else {
      window.location.href = "#/".concat(_xlrDashboardConstants.DASHBOARD_LIST_SUFFIX);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, {
    helpLink: "how-to/configure-custom-dashboards.html"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    onClick: handleCancelClick,
    type: "outlined"
  }, "Cancel"));
};

/***/ }),

/***/ 65692:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.DashboardDetailsHeaderContent = exports.DashboardDetailsHeader = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(67154));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _isEmpty = _interopRequireDefault(__webpack_require__(41609));
var _appConfig = __webpack_require__(89887);
var _dotComponents = __webpack_require__(92140);
var _dashboardActionContextMenu = __webpack_require__(98961);
var _releaseStatus = __webpack_require__(52067);
var _hooks = __webpack_require__(38602);
var _hooks2 = __webpack_require__(96462);
var _navigation = __webpack_require__(94744);
__webpack_require__(24701);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var DashboardDetailsHeader = exports.DashboardDetailsHeader = function DashboardDetailsHeader(props) {
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _appConfig.store
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, /*#__PURE__*/_react.default.createElement(DashboardDetailsHeaderContent, props)));
};
var DashboardDetailsHeaderContent = exports.DashboardDetailsHeaderContent = function DashboardDetailsHeaderContent(_ref) {
  var canCreateDashboard = _ref.canCreateDashboard,
    canDeleteDashboard = _ref.canDeleteDashboard,
    canEditDashboard = _ref.canEditDashboard,
    dashboard = _ref.dashboard,
    editButtonProps = _ref.editButtonProps,
    exportAsPdfButtonProps = _ref.exportAsPdfButtonProps,
    isDesignMode = _ref.isDesignMode,
    isFolderDashboard = _ref.isFolderDashboard,
    isGlobalDashboard = _ref.isGlobalDashboard,
    onDelete = _ref.onDelete,
    onDuplicate = _ref.onDuplicate,
    refreshButtonProps = _ref.refreshButtonProps,
    release = _ref.release;
  var dispatch = (0, _hooks2.useAppDispatch)();
  var _useAppSelector = (0, _hooks2.useAppSelector)(_navigation.getNavigationState),
    menuIsOpen = _useAppSelector.menuIsOpen;
  var _useState = (0, _react.useState)(null),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    contextMenuAnchorEl = _useState2[0],
    setContextMenuAnchorEl = _useState2[1];
  var isReleaseDashboard = !(0, _isEmpty.default)(release);
  var isDeleteEnabled = isGlobalDashboard && canDeleteDashboard;
  var isContextMenuAvailable = isDeleteEnabled || canCreateDashboard;
  var isEditButtonAvailable = canEditDashboard && (isGlobalDashboard || isFolderDashboard);
  isGlobalDashboard && (0, _hooks.useCloseSidebar)(menuIsOpen, dispatch);
  var handleContextMenuOpen = function handleContextMenuOpen(event) {
    setContextMenuAnchorEl(event.currentTarget);
  };
  var headerTitle = isReleaseDashboard ? "Release dashboard for ".concat(release.title) : dashboard.title;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "dashboard-details-header"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "dashboard-details-header-left"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    "data-testid": "header-title",
    noWrap: true,
    variant: "h1"
  }, headerTitle), isReleaseDashboard && /*#__PURE__*/_react.default.createElement(_releaseStatus.ReleaseStatus, {
    status: release.status
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "dashboard-details-header-actions"
  }, isDesignMode ? isEditButtonAvailable && /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, (0, _extends2.default)({
    "data-testid": "edit-properties-btn",
    startIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      iconId: "edit"
    }),
    type: "outlined"
  }, editButtonProps), "Edit properties") : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, (0, _extends2.default)({
    "data-testid": "refresh-dashboard-btn",
    startIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      iconId: "refresh"
    }),
    type: "text"
  }, refreshButtonProps), "Refresh dashboard"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, (0, _extends2.default)({
    "data-testid": "export-as-pdf-btn",
    startIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      iconId: "download"
    }),
    type: "outlined"
  }, exportAsPdfButtonProps), "Export as PDF")), isContextMenuAvailable && /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
    iconId: "options",
    onClick: handleContextMenuOpen
  })), isContextMenuAvailable && /*#__PURE__*/_react.default.createElement(_dashboardActionContextMenu.DashboardActionContextMenu, {
    anchorEl: contextMenuAnchorEl || undefined,
    dashboard: dashboard,
    hasCreateDashboardPermission: canCreateDashboard,
    hasDeleteDashboardPermission: canDeleteDashboard,
    onDelete: onDelete,
    onDuplicate: onDuplicate,
    onLeave: function onLeave() {
      return setContextMenuAnchorEl(null);
    }
  }));
};

/***/ }),

/***/ 69416:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.deleteDashboardModal = void 0;
var template = "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">Delete dashboard</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"></i></button>\n        <div class=\"clearfix\"></div>\n    </div>\n    <div class=\"modal-body actions-modal\">      \n     <p>You are about to delete the dashboard <b>{{::$ctrl.resolve.data.dashboard.title}}</b>.</p>\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button save primary\" type=\"submit\" ng-click=\"$ctrl.close()\">Delete</button>\n    </div>\n";
var deleteDashboardModal = exports.deleteDashboardModal = {
  bindings: {
    close: '&',
    dismiss: '&',
    resolve: '<'
  },
  template: template
};
angular.module('xlrelease.dashboard').component('xlrDeleteDashboardModal', deleteDashboardModal);

/***/ }),

/***/ 91435:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.deleteDashboardModal = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var template = "\n<div class=\"modal-content\">\n    <form name=\"duplicateDashboardForm\" id=\"duplicateDashboardForm\" class=\"form-horizontal\" novalidate>\n        <div class=\"modal-header\">\n            <h4 class=\"modal-title pull-left\" id=\"modal-title\">Duplicate dashboard</h4>\n            <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"></i></button>\n            <div class=\"clearfix\"></div>\n        </div>\n        <div class=\"modal-body actions-modal\">      \n            <div class=\"form-group\">\n                <label class=\"col-sm-2 control-label\" for=\"duplicateDashboard-title\">New name <span ng-if=\"duplicateDashboardForm.$error.required\" class=\"error\">*</span></label>\n                <div class=\"col-sm-10\">\n                    <input type=\"text\" class=\"input-block-level\" name=\"title\" id=\"duplicateDashboard-title\" \n                    ng-model=\"$ctrl.duplicate.title\" ng-maxlength=\"255\" required autofocus/>\n                    <span class=\"field-errors\" ng-if=\"duplicateDashboardForm.title.$invalid\">\n                        <span ng-if=\"duplicateDashboardForm.title.$error.required\">Dashboard name is mandatory</span>\n                        <span ng-if=\"duplicateDashboardForm.title.$error.maxlength\">Dashboard name is too long</span>\n                    </span>\n                </div>\n            </div>\n        </div>\n        <div class=\"modal-footer\">\n            <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n            <button ng-disabled=\"duplicateDashboardForm.$invalid\" class=\"button save primary\" type=\"submit\" ng-click=\"$ctrl.close({$value: $ctrl.duplicate})\">Duplicate</button>\n        </div>\n    </form>\n</div>\n";
var DeleteDashboardModalcController = /*#__PURE__*/function () {
  function DeleteDashboardModalcController() {
    (0, _classCallCheck2.default)(this, DeleteDashboardModalcController);
  }
  (0, _createClass2.default)(DeleteDashboardModalcController, [{
    key: "$onInit",
    value: function $onInit() {
      this.duplicate = {
        title: this.resolve.data.dashboard.title + ' (Copy)'
      };
    }
  }]);
  return DeleteDashboardModalcController;
}();
var deleteDashboardModal = exports.deleteDashboardModal = {
  bindings: {
    close: '&',
    dismiss: '&',
    resolve: '<'
  },
  controller: DeleteDashboardModalcController,
  template: template
};
angular.module('xlrelease.dashboard').component('xlrDuplicateDashboardModal', deleteDashboardModal);

/***/ }),

/***/ 6388:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.GlobalDashboardListContent = exports.GlobalDashboardList = void 0;
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _dotComponents = __webpack_require__(92140);
var _reactRedux = __webpack_require__(37703);
var _hooks = __webpack_require__(96462);
var _navigation = __webpack_require__(17523);
var _globalDashboadStore = __webpack_require__(50898);
var _globalDashboard = __webpack_require__(27059);
var _dashboardList = __webpack_require__(16906);
__webpack_require__(82611);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var _globalDashboard$acti = _globalDashboard.globalDashboard.actions,
  loadGlobalDashboards = _globalDashboard$acti.loadGlobalDashboards,
  executeDashboardAction = _globalDashboard$acti.executeDashboardAction,
  searchWithFilter = _globalDashboard$acti.searchWithFilter;
var navigateTo = _navigation.navigation.actions.navigateTo;
var GlobalDashboardList = exports.GlobalDashboardList = function GlobalDashboardList(props) {
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _globalDashboadStore.store
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, /*#__PURE__*/_react.default.createElement(GlobalDashboardListContent, props)));
};
var GlobalDashboardListContent = exports.GlobalDashboardListContent = function GlobalDashboardListContent(_ref) {
  var filters = _ref.filters;
  var dispatch = (0, _hooks.useAppDispatch)();
  var _useAppSelector = (0, _hooks.useAppSelector)(_globalDashboard.getGlobalDashboardState),
    loading = _useAppSelector.loading,
    dashboards = _useAppSelector.dashboards,
    hasCreateDashboardPermission = _useAppSelector.hasCreateDashboardPermission,
    titleFilter = _useAppSelector.titleFilter;
  (0, _react.useEffect)(function () {
    dispatch(loadGlobalDashboards(filters));
  }, []);
  var handleNewDashboard = function handleNewDashboard() {
    dispatch(navigateTo({
      pathSuffix: 'dashboards/new'
    }));
  };
  var handleDashboardFilterChange = function handleDashboardFilterChange(title) {
    dispatch(searchWithFilter(title));
  };
  var handleDelete = function handleDelete(dashboardId) {
    var dashboardToDelete = dashboards.find(function (currentDashboard) {
      return currentDashboard.id === dashboardId;
    });
    if (!dashboardToDelete) return;
    dispatch(executeDashboardAction({
      actionId: 'DELETE',
      dashboard: dashboardToDelete
    }));
  };
  var handleDuplicate = function handleDuplicate(currentDashboard) {
    dispatch(executeDashboardAction({
      actionId: 'DUPLICATE',
      dashboard: currentDashboard
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_dashboardList.DashboardList, {
    dashboardTitleFilter: titleFilter,
    dashboards: dashboards,
    hasCreateDashboardPermission: hasCreateDashboardPermission,
    isLoading: loading,
    onCreate: handleNewDashboard,
    onDelete: handleDelete,
    onDuplicate: handleDuplicate,
    onFilterChange: handleDashboardFilterChange
  });
};

/***/ }),

/***/ 29848:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.dashboardPlaceholder = void 0;
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var DashboardPlaceholderController = /*#__PURE__*/(0, _createClass2.default)(function DashboardPlaceholderController($location, $ngRedux) {
  (0, _classCallCheck2.default)(this, DashboardPlaceholderController);
  this.$location = $location;
  this.$ngRedux = $ngRedux;
  var state = this.$ngRedux.getState();
  var subMenuItems = _.get(state, 'navigation.sidebarMenu', []);
  this.$location.url(_.nth(subMenuItems, 0).pathSuffix).replace();
});
(0, _defineProperty2.default)(DashboardPlaceholderController, "$inject", ['$location', '$ngRedux']);
var dashboardPlaceholder = exports.dashboardPlaceholder = {
  controller: DashboardPlaceholderController
};
angular.module('xlrelease.dashboard').component('xlrDashboardPlaceholder', dashboardPlaceholder);

/***/ }),

/***/ 51016:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.DashboardProperties = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
__webpack_require__(13575);
var _dashboardProperties2 = _interopRequireDefault(__webpack_require__(4785));
var _xlrDashboardConstants = __webpack_require__(56918);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var DashboardPropertiesController = /*#__PURE__*/function () {
  function DashboardPropertiesController(XlrDashboardService, RolesService, UsersService, ClientSettings, $q, TeamsService, FolderPathService) {
    (0, _classCallCheck2.default)(this, DashboardPropertiesController);
    this.XlrDashboardService = XlrDashboardService;
    this.RolesService = RolesService;
    this.UsersService = UsersService;
    this.ClientSettings = ClientSettings;
    this.$q = $q;
    this.TeamsService = TeamsService;
    this.FolderPathService = FolderPathService;
    this._saveListeners = [];
  }
  (0, _createClass2.default)(DashboardPropertiesController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;
      this.saving = false;
      this.toStep('PROPERTIES');
      if (this.templateType) {
        var configurationUri = this.templateType.properties.find(function (property) {
          return property.name === 'configurationUri';
        }).default;
        if (configurationUri) {
          this.configurationUri = "static/24.1.10/".concat(configurationUri);
        }
      }
      var rolesPromise = this.$q.defer();
      if (this.parentId) {
        rolesPromise.resolve([]);
      } else {
        this.RolesService.getRoleNames().then(function (res) {
          return rolesPromise.resolve(_this._convertToTags(res.data));
        });
      }
      var usersPromise = this.UsersService.getAllUsers().then(function (res) {
        return res.data;
      });
      this.$q.all([rolesPromise.promise, usersPromise]).then(function (_ref) {
        var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
          allRoles = _ref2[0],
          allUsers = _ref2[1];
        _this.allRoles = allRoles;
        _this.allUsers = allUsers;
        _this.columns = _.range(1, _xlrDashboardConstants.DASHBOARD_MAX_COLUMNS + 1);
        if (_this.currentDashboard) {
          _this.dashboard = angular.copy(_this.currentDashboard);
          _this._assignDashboard(_this.dashboard);
        } else {
          _this.roleViewers = [];
          _this.roleEditors = [];
          _this.dashboard = {
            title: _this.templateType ? _this.templateType.properties.find(function (property) {
              return property.name === 'title';
            }).default : '',
            description: _this.templateType ? _this.templateType.properties.find(function (property) {
              return property.name === 'description';
            }).default : '',
            templateType: _this.templateType ? _this.templateType.type : null,
            columns: _this.templateType ? _this.templateType.properties.find(function (property) {
              return property.name === 'columns';
            }).default : _xlrDashboardConstants.DASHBOARD_DEFAULT_COLUMNS,
            parentId: _this.parentId,
            autoRefresh: _this.templateType ? _this.templateType.properties.find(function (property) {
              return property.name === 'autoRefresh';
            }).default : false,
            autoRefreshInterval: _this.templateType ? _this.templateType.properties.find(function (property) {
              return property.name === 'autoRefreshInterval';
            }).default : _xlrDashboardConstants.DASHBOARD_DEFAULT_REFRESH_INTERVAL,
            properties: {}
          };
          _this.owner = _this.ClientSettings.getAuthenticationData();
        }
        if (_this.dashboard.parentId) {
          _this.FolderPathService.getPathFromParentFolderId(_this.dashboard.parentId).then(function (paths) {
            return _this.inheritedFrom = _.last(paths);
          });
        }
      });
    }
  }, {
    key: "_assignDashboard",
    value: function _assignDashboard(dashboard) {
      this.roleViewers = this._convertToTags(dashboard.roleViewers);
      this.roleEditors = this._convertToTags(dashboard.roleEditors);
      this.owner = _.find(this.allUsers, {
        username: dashboard.owner
      });
    }
  }, {
    key: "_convertToTags",
    value: function _convertToTags(roles) {
      return roles.map(function (roleName) {
        return {
          name: roleName,
          type: 'ROLE'
        };
      });
    }
  }, {
    key: "isNew",
    value: function isNew() {
      return !_.has(this, ['dashboard', 'id']);
    }
  }, {
    key: "canEditColumns",
    value: function canEditColumns() {
      return !this.isNew() || !this.templateType || this.templateType.type === 'xlrelease.BlankDashboard';
    }
  }, {
    key: "hasInheritedSecurity",
    value: function hasInheritedSecurity() {
      return !!this.parentId;
    }
  }, {
    key: "isValid",
    value: function isValid() {
      return this.dashboard.title && this.owner;
    }
  }, {
    key: "saveDashboard",
    value: function saveDashboard() {
      var _this2 = this;
      this._saveListeners.forEach(function (listener) {
        return listener(_this2.dashboard);
      });
      var dashboardView = _objectSpread(_objectSpread({}, _.omit(this.dashboard, 'metadata')), {}, {
        roleViewers: this.roleViewers.map(function (role) {
          return role.name;
        }),
        roleEditors: this.roleEditors.map(function (role) {
          return role.name;
        }),
        owner: this.owner.username
      });
      this.saving = true;
      var promise;
      if (this.isNew()) {
        promise = this.XlrDashboardService.create(dashboardView);
      } else {
        promise = this.XlrDashboardService.update(dashboardView);
      }
      promise.then(function (resp) {
        var dashboard = resp.data;
        _this2.onSave({
          dashboard: dashboard,
          isNew: _this2.isNew()
        });
      }).finally(function () {
        return _this2.saving = false;
      });
    }
  }, {
    key: "cancel",
    value: function cancel() {
      this.onCancel();
    }
  }, {
    key: "hasConfiguration",
    value: function hasConfiguration() {
      return !!this.configurationUri;
    }
  }, {
    key: "toStep",
    value: function toStep(step) {
      this.currentStep = step;
    }
  }, {
    key: "registerSaveListener",
    value: function registerSaveListener(listener) {
      this._saveListeners.push(listener);
    }
  }, {
    key: "unregisterSaveListener",
    value: function unregisterSaveListener(listener) {
      this._saveListeners = this._saveListeners.filter(function (item) {
        return item !== listener;
      });
    }
  }, {
    key: "autoRefreshIntervalMinutes",
    get: function get() {
      // even though backend value is in seconds we want to limit to whole minutes
      return ~~(this.dashboard.autoRefreshInterval / 60);
    },
    set: function set(minutes) {
      this.dashboard.autoRefreshInterval = minutes * 60;
    }
  }]);
  return DashboardPropertiesController;
}();
(0, _defineProperty2.default)(DashboardPropertiesController, "$inject", ['xlrelease.XlrDashboardService', 'RolesService', 'UsersService', 'ClientSettings', '$q', 'TeamsService', 'FolderPathService']);
var DashboardProperties = exports.DashboardProperties = {
  bindings: {
    currentDashboard: '<',
    templateType: '<',
    parentId: '<',
    onSave: '&',
    onCancel: '&'
  },
  controller: DashboardPropertiesController,
  template: _dashboardProperties2.default
};
angular.module('xlrelease.dashboard').component('xlrDashboardProperties', DashboardProperties);

/***/ }),

/***/ 94910:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.DashboardPropertiesSidebar = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _dashboardPropertiesSidebar = _interopRequireDefault(__webpack_require__(334));
var _xlrDashboardConstants = __webpack_require__(56918);
var DashboardPropertiesSidebarController = /*#__PURE__*/function () {
  function DashboardPropertiesSidebarController($state, $rootScope, Events, XlrSidebarService) {
    (0, _classCallCheck2.default)(this, DashboardPropertiesSidebarController);
    this.$state = $state;
    this.$rootScope = $rootScope;
    this.Events = Events;
    this.XlrSidebarService = XlrSidebarService;
    this.sidebarOpts = {
      position: 'right',
      backdropOpacity: 0
    };
  }
  (0, _createClass2.default)(DashboardPropertiesSidebarController, [{
    key: "$onInit",
    value: function $onInit() {
      this.$rootScope.$on('$stateChangeStart', this.onCancel.bind(this));
    }
  }, {
    key: "onOpenSidebar",
    value: function onOpenSidebar() {
      this.isVisible = true;
    }
  }, {
    key: "onCloseSidebar",
    value: function onCloseSidebar() {
      this.isVisible = false;
    }
  }, {
    key: "onCancel",
    value: function onCancel() {
      this.XlrSidebarService.close(this.sidebarName);
    }
  }, {
    key: "onSave",
    value: function onSave(dashboard, isNew) {
      this.XlrSidebarService.close(this.sidebarName);
      if (dashboard.parentId) {
        this.$state.go('folders.detail.folderDashboards', {
          dashboardId: dashboard.id,
          folderId: dashboard.parentId
        }, {
          reload: true
        });
      } else {
        this.$state.go('dashboards', {
          dashboardId: dashboard.id,
          dashboardMode: isNew ? _xlrDashboardConstants.DASHBOARD_MODE.DESIGN : undefined
        }, {
          reload: true
        });
      }
    }
  }]);
  return DashboardPropertiesSidebarController;
}();
(0, _defineProperty2.default)(DashboardPropertiesSidebarController, "$inject", ['$state', '$rootScope', 'Events', 'xlrelease.XlrSidebarService']);
var DashboardPropertiesSidebar = exports.DashboardPropertiesSidebar = {
  bindings: {
    sidebarName: '<',
    dashboard: '<'
  },
  controller: DashboardPropertiesSidebarController,
  template: _dashboardPropertiesSidebar.default
};
angular.module('xlrelease.dashboard').component('xlrDashboardPropertiesSidebar', DashboardPropertiesSidebar);

/***/ }),

/***/ 53759:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.DashboardTemplates = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
__webpack_require__(24904);
var _dashboardTemplates2 = _interopRequireDefault(__webpack_require__(59346));
var _xlrDashboardConstants = __webpack_require__(56918);
var DashboardTemplatesController = /*#__PURE__*/function () {
  function DashboardTemplatesController(XlrDashboardService, ClientSettings) {
    (0, _classCallCheck2.default)(this, DashboardTemplatesController);
    this.XlrDashboardService = XlrDashboardService;
    this.ClientSettings = ClientSettings;
  }
  (0, _createClass2.default)(DashboardTemplatesController, [{
    key: "$onInit",
    value: function $onInit() {
      this.loadTemplates();
    }
  }, {
    key: "loadTemplates",
    value: function loadTemplates() {
      var _this = this;
      var dashboardLevel = this.parentId ? _xlrDashboardConstants.DASHBOARD_LEVEL.FOLDER : _xlrDashboardConstants.DASHBOARD_LEVEL.GLOBAL;
      this.XlrDashboardService.getDashboardTemplates(dashboardLevel).then(function (response) {
        _this.templateTypes = response.data;
        _this.blankTemplateType = _this.templateTypes.find(function (templateType) {
          return templateType.type === 'xlrelease.BlankDashboard';
        });
      });
    }
  }, {
    key: "filterTemplateType",
    value: function filterTemplateType(query) {
      var _this2 = this;
      var searchQuery = _(query).trim().toLowerCase();
      return function (templateType) {
        return templateType !== _this2.blankTemplateType && (!searchQuery || _(templateType.label).toLower().includes(searchQuery) || _(templateType.description).toLower().includes(searchQuery));
      };
    }
  }, {
    key: "selectTemplate",
    value: function selectTemplate(templateType) {
      this.onSelect({
        templateType: templateType
      });
    }
  }]);
  return DashboardTemplatesController;
}();
(0, _defineProperty2.default)(DashboardTemplatesController, "$inject", ['xlrelease.XlrDashboardService', 'ClientSettings']);
var DashboardTemplates = exports.DashboardTemplates = {
  bindings: {
    parentId: '<',
    onSelect: '&',
    onCancel: '&'
  },
  controller: DashboardTemplatesController,
  template: _dashboardTemplates2.default
};
angular.module('xlrelease.dashboard').component('xlrDashboardTemplates', DashboardTemplates);

/***/ }),

/***/ 17821:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.tileVersionFilter = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _tileVersionFilterTpl = _interopRequireDefault(__webpack_require__(70464));
var versionFilterType = {
  ALL: 'ALL',
  MAJOR_VERSION: 'MAJOR_VERSION',
  MINOR_VERSION: 'MINOR_VERSION',
  PATCH_VERSION: 'PATCH_VERSION',
  SNAPSHOT_VERSION: 'SNAPSHOT_VERSION',
  ALPHA_VERSION: 'ALPHA_VERSION',
  BETA_VERSION: 'BETA_VERSION',
  RC_VERSION: 'RC_VERSION',
  CUSTOM: 'CUSTOM_VERSION'
};
var versionFilterMap = new Map();
versionFilterMap.set(versionFilterType.ALL, "[^\\n]+");
versionFilterMap.set(versionFilterType.MAJOR_VERSION, "^([0-9]|[1-9][0-9]*)(\\.([0]))(\\.([0]))?$");
versionFilterMap.set(versionFilterType.MINOR_VERSION, "^([0-9]|[1-9][0-9]*)\\.([1-9]|[1-9][1-9]*)*(\\.([0]))?$");
versionFilterMap.set(versionFilterType.PATCH_VERSION, "^([0-9]|[1-9][0-9]*)\\.([0-9]|[1-9][0-9]*)\\.([1-9]|[1-9][1-9]*)$");
versionFilterMap.set(versionFilterType.SNAPSHOT_VERSION, "\\bSNAPSHOT\\b");
versionFilterMap.set(versionFilterType.ALPHA_VERSION, "\\bALPHA\\b");
versionFilterMap.set(versionFilterType.BETA_VERSION, "\\bBETA\\b");
versionFilterMap.set(versionFilterType.RC_VERSION, "\\bRC\\b");
versionFilterMap.set(versionFilterType.CUSTOM, '');
var VersionFilterComponent = /*#__PURE__*/function () {
  function VersionFilterComponent() {
    (0, _classCallCheck2.default)(this, VersionFilterComponent);
    this.versionFilterType = versionFilterType;
    this.versionFilterMap = versionFilterMap;
  }
  (0, _createClass2.default)(VersionFilterComponent, [{
    key: "$onInit",
    value: function $onInit() {
      if (this.tile.properties.versionFilterType.value !== this.versionFilterType.CUSTOM) {
        this.tile.properties.versionFilterRegex = this.versionFilterMap.get(this.tile.properties.versionFilterType.value);
      }
    }
  }, {
    key: "onVersionFilterTypeChange",
    value: function onVersionFilterTypeChange() {
      if (this.tile.properties.versionFilterType.value !== this.versionFilterType.CUSTOM || this.tile.properties.versionFilterType.value !== this.versionFilterType.NONE) {
        this.tile.properties.versionFilterRegex = this.versionFilterMap.get(this.tile.properties.versionFilterType.value);
      } else {
        this.tile.properties.versionFilterRegex = '';
      }
    }
  }]);
  return VersionFilterComponent;
}();
var tileVersionFilter = exports.tileVersionFilter = {
  bindings: {
    tile: '<'
  },
  controller: VersionFilterComponent,
  template: _tileVersionFilterTpl.default
};
angular.module('xlrelease.dashboard').component('xlrTileVersionFilter', tileVersionFilter);

/***/ }),

/***/ 99549:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _tileConfiguration = _interopRequireDefault(__webpack_require__(58048));
var _xlrTileUtil = __webpack_require__(39629);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var TileConfigurationController = /*#__PURE__*/function () {
  function TileConfigurationController(VariablesService, XlrSidebarService, $scope) {
    (0, _classCallCheck2.default)(this, TileConfigurationController);
    this.VariablesService = VariablesService;
    this.XlrSidebarService = XlrSidebarService;
    this.$scope = $scope;
    this._saveListeners = [];
  }
  (0, _createClass2.default)(TileConfigurationController, [{
    key: "$onInit",
    value: function $onInit() {
      this.$scope.release = this.release;
    }
  }, {
    key: "$onChanges",
    value: function $onChanges(changes) {
      if (changes.tile && changes.tile.currentValue) {
        this.configureTile(changes.tile.currentValue);
      }
    }
  }, {
    key: "configureTile",
    value: function configureTile(tile) {
      this.tile = tile;
      this.tileTypeDefinition = this.tileTypeDefs[tile.type];
      this.configurationPropertyDefinitions = _.filter(this.tileTypeDefinition.properties, function (property) {
        return property.category === 'input' && property.hidden !== true;
      });
    }
  }, {
    key: "getConfigUrl",
    value: function getConfigUrl(tile) {
      return (0, _xlrTileUtil.tileOrDefaultUrl)(tile.configurationUri, 'include/DashboardPage/partials/tile-dip-config.html');
    }
  }, {
    key: "createVariable",
    value: function createVariable(name, variableType, createdCallback) {
      if (this.release && this.release.id) {
        var variable = {
          key: name,
          type: variableType
        };
        this.VariablesService.createReleaseVariable(this.release.id, variable).then(function (resp) {
          if (createdCallback) {
            createdCallback(resp.data);
          }
        });
      }
    }
  }, {
    key: "save",
    value: function save() {
      var _this = this;
      this._saveListeners.forEach(function (listener) {
        return listener(_this.tile);
      });
      this.saveTile({
        item: this.tile
      });
      this.dismiss();
    }
  }, {
    key: "update",
    value: function update(tile) {
      this.tile = _objectSpread({}, tile);
    }
  }, {
    key: "dismiss",
    value: function dismiss() {
      this.XlrSidebarService.closeAll();
    }
  }, {
    key: "registerSaveListener",
    value: function registerSaveListener(listener) {
      this._saveListeners.push(listener);
    }
  }, {
    key: "unregisterSaveListener",
    value: function unregisterSaveListener(listener) {
      this._saveListeners = this._saveListeners.filter(function (item) {
        return item !== listener;
      });
    }
  }]);
  return TileConfigurationController;
}();
(0, _defineProperty2.default)(TileConfigurationController, "$inject", ['VariablesService', 'xlrelease.XlrSidebarService', '$scope']);
var tileConfiguration = {
  bindings: {
    tile: '<',
    tileTypeDefs: '=',
    variables: '=',
    release: '=',
    saveTile: '&'
  },
  controller: TileConfigurationController,
  controllerAs: 'xlrTile',
  // Note: this is added for backward compatibility of tiles
  template: _tileConfiguration.default
};
angular.module('xlrelease.dashboard').component('xlrTileConfiguration', tileConfiguration);

/***/ }),

/***/ 23584:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _tileCard = _interopRequireDefault(__webpack_require__(48662));
var tileCard = {
  bindings: {
    tile: '<',
    add: '&',
    label: '<'
  },
  template: _tileCard.default
};
angular.module('xlrelease.dashboard').component('xlrTileCard', tileCard);

/***/ }),

/***/ 84836:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _tileSelector = _interopRequireDefault(__webpack_require__(35190));
__webpack_require__(19165);
var TileSelectorController = /*#__PURE__*/function () {
  function TileSelectorController() {
    (0, _classCallCheck2.default)(this, TileSelectorController);
    this.searchQuery = '';
  }
  (0, _createClass2.default)(TileSelectorController, [{
    key: "$onInit",
    value: function $onInit() {
      this.tileTypeDefsValues = _.values(this.tileTypeDefs);
      this.filteredTileTypeDefs = this.tileTypeDefsValues;
    }
  }, {
    key: "filterTiles",
    value: function filterTiles() {
      var _this = this;
      var searchQuery = _.chain(this.searchQuery).trim().toLower().value();
      if (searchQuery) {
        this.filteredTileTypeDefs = Object.keys(this.tileTypeDefs || {}).reduce(function (filteredTileTypeDefs, tileDef) {
          var tileTypeDef = _this.tileTypeDefs[tileDef];
          if (_.chain(tileTypeDef.label).toLower().includes(searchQuery).value() || _.chain(tileTypeDef.description).toLower().includes(searchQuery).value()) {
            filteredTileTypeDefs.push(tileTypeDef);
          }
          return filteredTileTypeDefs;
        }, []);
      } else {
        this.filteredTileTypeDefs = this.tileTypeDefsValues;
      }
    }
  }]);
  return TileSelectorController;
}();
var tileSelector = {
  bindings: {
    tileTypeDefs: '<',
    addTile: '&'
  },
  controller: TileSelectorController,
  template: _tileSelector.default
};
angular.module('xlrelease.dashboard').component('xlrTileSelector', tileSelector);

/***/ }),

/***/ 50898:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.store = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _effects = __webpack_require__(34857);
var _globalDashboard = __webpack_require__(99456);
var _appConfig = __webpack_require__(89887);
var _globalDashboard2 = __webpack_require__(27059);
var _marked = /*#__PURE__*/_regenerator.default.mark(combinedSaga);
function combinedSaga() {
  return _regenerator.default.wrap(function combinedSaga$(_context) {
    while (1) switch (_context.prev = _context.next) {
      case 0:
        if (false) {}
        _context.prev = 1;
        _context.next = 4;
        return (0, _effects.all)([(0, _effects.call)(_globalDashboard.globalDashboardSaga)]);
      case 4:
        _context.next = 9;
        break;
      case 6:
        _context.prev = 6;
        _context.t0 = _context["catch"](1);
        // eslint-disable-next-line no-console,angular/log
        console.error('analytics root saga:', _context.t0);
      case 9:
        _context.next = 0;
        break;
      case 11:
      case "end":
        return _context.stop();
    }
  }, _marked, null, [[1, 6]]);
}
var store = exports.store = store || (0, _appConfig.enhanceStore)({
  globalDashboard: _globalDashboard2.globalDashboard.reducer
}, combinedSaga);

/***/ }),

/***/ 27059:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.initialState = exports.globalDashboard = exports.getGlobalDashboardState = void 0;
var _toolkit = __webpack_require__(47054);
var _noop = _interopRequireDefault(__webpack_require__(50308));
var initialState = exports.initialState = {
  dashboards: [],
  hasCreateDashboardPermission: false,
  loading: true,
  titleFilter: ''
};
var globalDashboard = exports.globalDashboard = (0, _toolkit.createSlice)({
  name: 'globalDashboard',
  initialState: initialState,
  reducers: {
    loadGlobalDashboards: function loadGlobalDashboards(_state, _action) {
      return (0, _noop.default)();
    },
    setGlobalDashboards: function setGlobalDashboards(state, action) {
      state.dashboards = action.payload;
    },
    setCreateDashboardPermission: function setCreateDashboardPermission(state, action) {
      state.hasCreateDashboardPermission = action.payload;
    },
    executeDashboardAction: function executeDashboardAction(_state, _action) {
      return (0, _noop.default)();
    },
    searchWithFilter: function searchWithFilter(_state, _action) {
      return (0, _noop.default)();
    },
    setGlobalFilter: function setGlobalFilter(state, action) {
      state.titleFilter = action.payload;
    },
    setLoading: function setLoading(state, action) {
      state.loading = action.payload;
    }
  }
});
var getGlobalDashboardState = exports.getGlobalDashboardState = function getGlobalDashboardState(state) {
  return state.globalDashboard;
};

/***/ }),

/***/ 99456:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.executeDashboardActionSaga = executeDashboardActionSaga;
exports.globalDashboardSaga = globalDashboardSaga;
exports.loadDashboards = loadDashboards;
exports.loadGlobalDashboardsSaga = loadGlobalDashboardsSaga;
exports.searchWithFilterSaga = searchWithFilterSaga;
exports.toastr = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _effects = __webpack_require__(34857);
var _globalDashboard = __webpack_require__(27059);
var _http = __webpack_require__(26511);
var _authenticator = __webpack_require__(78013);
var _angularAccessor = _interopRequireDefault(__webpack_require__(81403));
var _toastrFactory = _interopRequireDefault(__webpack_require__(86846));
var _marked = /*#__PURE__*/_regenerator.default.mark(loadGlobalDashboardsSaga),
  _marked2 = /*#__PURE__*/_regenerator.default.mark(loadDashboards),
  _marked3 = /*#__PURE__*/_regenerator.default.mark(executeDashboardActionSaga),
  _marked4 = /*#__PURE__*/_regenerator.default.mark(searchWithFilterSaga),
  _marked5 = /*#__PURE__*/_regenerator.default.mark(globalDashboardSaga);
var _globalDashboard$acti = _globalDashboard.globalDashboard.actions,
  executeDashboardAction = _globalDashboard$acti.executeDashboardAction,
  loadGlobalDashboards = _globalDashboard$acti.loadGlobalDashboards,
  setGlobalDashboards = _globalDashboard$acti.setGlobalDashboards,
  setCreateDashboardPermission = _globalDashboard$acti.setCreateDashboardPermission,
  setGlobalFilter = _globalDashboard$acti.setGlobalFilter,
  searchWithFilter = _globalDashboard$acti.searchWithFilter,
  setLoading = _globalDashboard$acti.setLoading;
var toastr = exports.toastr = (0, _toastrFactory.default)();
function loadGlobalDashboardsSaga(action) {
  var title, hasDashboardCreatePermission;
  return _regenerator.default.wrap(function loadGlobalDashboardsSaga$(_context) {
    while (1) switch (_context.prev = _context.next) {
      case 0:
        title = action.payload.title;
        _context.next = 3;
        return (0, _effects.put)(setLoading(true));
      case 3:
        _context.next = 5;
        return (0, _effects.call)(_authenticator.hasPermission, 'dashboard#create');
      case 5:
        hasDashboardCreatePermission = _context.sent;
        if (!hasDashboardCreatePermission) {
          _context.next = 9;
          break;
        }
        _context.next = 9;
        return (0, _effects.put)(setCreateDashboardPermission(true));
      case 9:
        return _context.delegateYield(loadDashboards(title), "t0", 10);
      case 10:
        _context.next = 12;
        return (0, _effects.put)(setLoading(false));
      case 12:
      case "end":
        return _context.stop();
    }
  }, _marked);
}
function loadDashboards(title) {
  var url, _yield$call, data;
  return _regenerator.default.wrap(function loadDashboards$(_context2) {
    while (1) switch (_context2.prev = _context2.next) {
      case 0:
        url = title ? "dashboards?title=".concat(title) : 'dashboards';
        _context2.next = 3;
        return (0, _effects.call)(_http.httpGET, url);
      case 3:
        _yield$call = _context2.sent;
        data = _yield$call.data;
        _context2.next = 7;
        return (0, _effects.put)(setGlobalDashboards(data));
      case 7:
        _context2.next = 9;
        return (0, _effects.put)(setGlobalFilter(title || ''));
      case 9:
      case "end":
        return _context2.stop();
    }
  }, _marked2);
}
function executeDashboardActionSaga(action) {
  var _action$payload, actionId, dashboard, xlrDashboardService, clientSettings, filter, _err$response, err, errorData;
  return _regenerator.default.wrap(function executeDashboardActionSaga$(_context3) {
    while (1) switch (_context3.prev = _context3.next) {
      case 0:
        _action$payload = action.payload, actionId = _action$payload.actionId, dashboard = _action$payload.dashboard;
        _context3.next = 3;
        return (0, _effects.call)(_angularAccessor.default, 'xlrelease.XlrDashboardService');
      case 3:
        xlrDashboardService = _context3.sent;
        _context3.next = 6;
        return (0, _effects.call)(_angularAccessor.default, 'ClientSettings');
      case 6:
        clientSettings = _context3.sent;
        filter = clientSettings.getGlobalDashboardListFilters();
        _context3.prev = 8;
        if (!(actionId === 'DELETE')) {
          _context3.next = 18;
          break;
        }
        _context3.next = 12;
        return (0, _effects.call)([xlrDashboardService, xlrDashboardService.delete], dashboard);
      case 12:
        _context3.next = 14;
        return (0, _effects.call)(loadDashboards, filter.title);
      case 14:
        _context3.next = 16;
        return (0, _effects.call)(toastr.success, 'Dashboard successfully deleted.');
      case 16:
        _context3.next = 25;
        break;
      case 18:
        if (!(actionId === 'DUPLICATE')) {
          _context3.next = 25;
          break;
        }
        _context3.next = 21;
        return (0, _effects.call)([xlrDashboardService, xlrDashboardService.create], dashboard);
      case 21:
        _context3.next = 23;
        return (0, _effects.call)(loadDashboards, filter.title);
      case 23:
        _context3.next = 25;
        return (0, _effects.call)(toastr.success, 'Dashboard successfully duplicated.');
      case 25:
        _context3.next = 33;
        break;
      case 27:
        _context3.prev = 27;
        _context3.t0 = _context3["catch"](8);
        err = _context3.t0;
        errorData = (_err$response = err.response) === null || _err$response === void 0 ? void 0 : _err$response.data;
        _context3.next = 33;
        return (0, _effects.call)(toastr.error, "Failed to ".concat(actionId === 'DELETE' ? 'delete' : 'duplicate', " a dashboard. Error: ").concat(errorData));
      case 33:
      case "end":
        return _context3.stop();
    }
  }, _marked3, null, [[8, 27]]);
}
function searchWithFilterSaga(action) {
  var FiltersQueryParams, clientSettings, title, filters;
  return _regenerator.default.wrap(function searchWithFilterSaga$(_context4) {
    while (1) switch (_context4.prev = _context4.next) {
      case 0:
        _context4.next = 2;
        return (0, _effects.call)(_angularAccessor.default, 'FiltersQueryParams');
      case 2:
        FiltersQueryParams = _context4.sent;
        _context4.next = 5;
        return (0, _effects.call)(_angularAccessor.default, 'ClientSettings');
      case 5:
        clientSettings = _context4.sent;
        title = action.payload;
        filters = {
          title: title
        };
        clientSettings.setGlobalDashboardListFilters(filters);
        FiltersQueryParams.update(filters);
        _context4.next = 12;
        return (0, _effects.call)(loadDashboards, title);
      case 12:
      case "end":
        return _context4.stop();
    }
  }, _marked4);
}
function globalDashboardSaga() {
  return _regenerator.default.wrap(function globalDashboardSaga$(_context5) {
    while (1) switch (_context5.prev = _context5.next) {
      case 0:
        _context5.next = 2;
        return (0, _effects.all)([(0, _effects.takeLatest)(loadGlobalDashboards, loadGlobalDashboardsSaga), (0, _effects.takeLatest)(executeDashboardAction, executeDashboardActionSaga), (0, _effects.takeLatest)(searchWithFilter, searchWithFilterSaga)]);
      case 2:
      case "end":
        return _context5.stop();
    }
  }, _marked5);
}

/***/ }),

/***/ 31492:
/***/ (function() {

"use strict";


angular.module('xlrelease.dashboard', ['gridster', 'ui.router', 'mgcrea.ngStrap']).config(['$stateProvider', '$urlMatcherFactoryProvider', function ($stateProvider, $urlMatcherFactoryProvider) {
  $urlMatcherFactoryProvider.type('DashboardId', {
    encode: angular.identity,
    decode: angular.identity,
    pattern: /Applications\/Dashboard\w+/
  });
  $urlMatcherFactoryProvider.type('TileId', {
    encode: angular.identity,
    decode: angular.identity,
    pattern: /Applications\/Dashboard\w+\/Tile\w+/
  });
  $stateProvider.state('defaultDashboard', {
    url: '/dashboards',
    template: '<xlr-dashboard-placeholder></xlr-dashboard-placeholder>'
  }).state('dashboards', {
    url: '/dashboards/{dashboardId: DashboardId}?dashboardMode&{refresh:bool}',
    template: '<div xlr-dashboard></div>'
  }).state('globalDashboardList', {
    url: '/dashboards/list',
    template: '<xlr-list-dashboard filters="$resolve.filters"></xlr-list-dashboard>',
    resolve: {
      filters: ['Filters', function (Filters) {
        return Filters.getGlobalDashboardsFilterSettings();
      }]
    }
  }).state('globalDashboardNew', {
    url: '/dashboards/new',
    template: '<xlr-add-dashboard-page></xlr-add-dashboard-page>'
  }).state('globalDashboardDetails', {
    url: '/dashboards/{tileId: TileId}/details?view',
    reloadOnSearch: true,
    templateUrl: 'static/24.1.10/include/DashboardPage/xlr-dashboard-details-mode.html',
    controller: 'xlrelease.dashboard.XlrTileDetailsController',
    controllerAs: 'xlrTileDetailsCtrl',
    resolve: {
      tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService) {
        return XlrDashboardService.loadTile($stateParams.tileId);
      }],
      dashboardPromise: [_.noop],
      releasePromise: [_.noop],
      isGlobalDashboard: _.constant(true)
    }
  }).state('folders.detail.folderDashboards', {
    url: '/dashboards/{dashboardId: DashboardId}?dashboardMode&{refresh:bool}',
    template: '<xlr-dashboard></xlr-dashboard>',
    params: {
      page: 'dashboards'
    }
  }).state('folders.detail.folderDashboardsNew', {
    url: '/dashboards/new',
    template: '<xlr-add-dashboard-page></xlr-add-dashboard-page>',
    params: {
      page: 'dashboards'
    }
  }).state('folders.detail.folderDashboardDetails', {
    url: '/dashboards/{tileId: TileId}/details?view',
    reloadOnSearch: true,
    templateUrl: 'static/24.1.10/include/DashboardPage/xlr-dashboard-details-mode.html',
    controller: 'xlrelease.dashboard.XlrTileDetailsController',
    controllerAs: 'xlrTileDetailsCtrl',
    params: {
      page: 'dashboards'
    },
    resolve: {
      tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', function ($stateParams, XlrDashboardService) {
        return XlrDashboardService.loadTile($stateParams.tileId);
      }],
      dashboardPromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
        return XlrDashboardService.loadConfiguration(Ids.getParentId($stateParams.tileId));
      }],
      releasePromise: [_.noop],
      isGlobalDashboard: _.constant(false)
    }
  }).state('releasesDashboard', {
    url: '/releases/:releaseId/summary/:tileId/details',
    templateUrl: 'static/24.1.10/include/DashboardPage/xlr-dashboard-details-mode.html',
    controller: 'xlrelease.dashboard.XlrTileDetailsController',
    controllerAs: 'xlrTileDetailsCtrl',
    resolve: {
      tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
        return XlrDashboardService.loadTile(Ids.toDomainId($stateParams.releaseId) + '/summary/' + $stateParams.tileId);
      }],
      dashboardPromise: [_.noop],
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
      }],
      isGlobalDashboard: _.constant(false)
    }
  }).state('templatesDashboard', {
    url: '/templates/:releaseId/summary/:tileId/details',
    templateUrl: 'static/24.1.10/include/DashboardPage/xlr-dashboard-details-mode.html',
    controller: 'xlrelease.dashboard.XlrTileDetailsController',
    controllerAs: 'xlrTileDetailsCtrl',
    resolve: {
      tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
        return XlrDashboardService.loadTile(Ids.toDomainId($stateParams.releaseId) + '/summary/' + $stateParams.tileId);
      }],
      dashboardPromise: [_.noop],
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
      }],
      isGlobalDashboard: _.constant(false)
    }
  });
}]);
angular.module('xlrelease.dashboard').factory('xlrDashboardConfigProvider', function () {
  return {
    getPlaceholderProperties: function getPlaceholderProperties() {
      return {
        draggable: {
          enabled: false
        },
        resizable: {
          enabled: false
        }
      };
    },
    getConfig: function getConfig(designMode, changeCallback) {
      return {
        minSizeY: 1,
        minSizeX: 1,
        defaultSizeX: 1,
        defaultSizeY: 1,
        pushing: true,
        floating: true,
        // whether to automatically float items up so they stack (you can temporarily disable if you are adding unsorted items with ng-repeat)
        swapping: true,
        // whether or not to have items of the same size switch places instead of pushing down if they are the same size
        colWidth: 'auto',
        minRows: 1,
        rowHeight: 290,
        margins: [10, 10],
        mobileBreakPoint: 60,
        resizable: {
          enabled: designMode,
          handles: ['n', 'e', 's', 'w', 'ne', 'se', 'sw', 'nw'],
          start: function start(event, $element) {
            $element.addClass('dashboard-resizing');
          },
          stop: function stop(event, $element) {
            $element.removeClass('dashboard-resizing');
            changeCallback();
          }
        },
        draggable: {
          enabled: designMode,
          handle: '.xlr-tile-drag-handle',
          stop: function stop() {
            return changeCallback();
          }
        }
      };
    }
  };
});

/***/ }),

/***/ 56918:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.DASHBOARD_WIDGETS_SIDEBAR_NAME = exports.DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME = exports.DASHBOARD_PROPERTIES_SIDEBAR_NAME = exports.DASHBOARD_MODE = exports.DASHBOARD_MAX_COLUMNS = exports.DASHBOARD_LIST_SUFFIX = exports.DASHBOARD_LEVEL = exports.DASHBOARD_DEFAULT_REFRESH_INTERVAL = exports.DASHBOARD_DEFAULT_COLUMNS = exports.DASHBOARD_CREATION_SIDEBAR_NAME = void 0;
var DASHBOARD_MAX_COLUMNS = exports.DASHBOARD_MAX_COLUMNS = 8;
var DASHBOARD_DEFAULT_COLUMNS = exports.DASHBOARD_DEFAULT_COLUMNS = 6;
var DASHBOARD_DEFAULT_REFRESH_INTERVAL = exports.DASHBOARD_DEFAULT_REFRESH_INTERVAL = 900;
var DASHBOARD_PROPERTIES_SIDEBAR_NAME = exports.DASHBOARD_PROPERTIES_SIDEBAR_NAME = 'DASHBOARD_PROPERTIES_SIDEBAR_NAME';
var DASHBOARD_CREATION_SIDEBAR_NAME = exports.DASHBOARD_CREATION_SIDEBAR_NAME = 'DASHBOARD_CREATION_SIDEBAR_NAME';
var DASHBOARD_WIDGETS_SIDEBAR_NAME = exports.DASHBOARD_WIDGETS_SIDEBAR_NAME = 'DASHBOARD_WIDGETS_SIDEBAR_NAME';
var DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME = exports.DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME = 'DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME';
var DASHBOARD_LIST_SUFFIX = exports.DASHBOARD_LIST_SUFFIX = 'dashboards/list';
var DASHBOARD_MODE = exports.DASHBOARD_MODE = {
  VIEW: 'view',
  DESIGN: 'design'
};
var DASHBOARD_LEVEL = exports.DASHBOARD_LEVEL = {
  RELEASE: 'RELEASE',
  FOLDER: 'FOLDER',
  GLOBAL: 'GLOBAL',
  HOME: 'HOME'
};

/***/ }),

/***/ 83868:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _extends2 = _interopRequireDefault(__webpack_require__(67154));
var _react = _interopRequireDefault(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _react2angular = __webpack_require__(96563);
var _dotComponents = __webpack_require__(92140);
var _actionToolbar = __webpack_require__(29755);
__webpack_require__(90399);
var XlrDashboardHomePortal = function XlrDashboardHomePortal(_ref) {
  var isDesignMode = _ref.isDesignMode,
    canEditDashboard = _ref.canEditDashboard,
    addTilesButtonProps = _ref.addTilesButtonProps,
    backButtonProps = _ref.backButtonProps,
    configureButtonProps = _ref.configureButtonProps,
    addAnalyticsCarouselTileProps = _ref.addAnalyticsCarouselTileProps;
  return /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, null, isDesignMode ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canEditDashboard && /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, (0, _extends2.default)({
    startIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      iconId: "back"
    }),
    type: "outlined"
  }, backButtonProps), "Back to view mode"), canEditDashboard && /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, addTilesButtonProps, "Add tiles")) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    id: "pendo-home-placeholder"
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, (0, _extends2.default)({}, addAnalyticsCarouselTileProps, {
    className: "add-analytics-carousel-button",
    "data-testid": "add-analytics-carousel-button"
  })), canEditDashboard && /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, configureButtonProps, "Configure")));
};
XlrDashboardHomePortal.propTypes = {
  addAnalyticsCarouselTileProps: _propTypes.default.object,
  addTilesButtonProps: _propTypes.default.object,
  backButtonProps: _propTypes.default.object,
  canEditDashboard: _propTypes.default.bool,
  configureButtonProps: _propTypes.default.object,
  isDesignMode: _propTypes.default.bool
};
angular.module('xlrelease.dashboard').component('xlrDashboardHomePortal', (0, _react2angular.react2angular)(XlrDashboardHomePortal, ['isDesignMode', 'canEditDashboard', 'addTilesButtonProps', 'backButtonProps', 'configureButtonProps', 'addAnalyticsCarouselTileProps']));

/***/ }),

/***/ 58371:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.DashboardSidebarProvider = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _effects = __webpack_require__(34857);
var _navigation = __webpack_require__(17523);
var _sidebar = __webpack_require__(73811);
var _angularAccessor = _interopRequireDefault(__webpack_require__(81403));
var _xlrDashboardConstants = __webpack_require__(56918);
var _navigation$actions = _navigation.navigation.actions,
  setBackItem = _navigation$actions.setBackItem,
  updateBreadcrumbs = _navigation$actions.updateBreadcrumbs,
  setSidebarMenu = _navigation$actions.setSidebarMenu,
  setLastBreadcrumb = _navigation$actions.setLastBreadcrumb;
var DashboardSidebarProvider = exports.DashboardSidebarProvider = /*#__PURE__*/function () {
  function DashboardSidebarProvider() {
    (0, _classCallCheck2.default)(this, DashboardSidebarProvider);
    (0, _defineProperty2.default)(this, "dashboardsPrefix", '/dashboards');
    (0, _defineProperty2.default)(this, "dashboardDetailsPattern", /\/Tile(\w+)\/details$/);
  }
  (0, _createClass2.default)(DashboardSidebarProvider, [{
    key: "checkIfInDashboardDetails",
    value: function checkIfInDashboardDetails(path) {
      return this.dashboardDetailsPattern.test(path);
    }
  }, {
    key: "getDashboardId",
    value: function getDashboardId(path, isInDashboardDetails) {
      var dashboardId = path.replace('/dashboards/', '');
      if (isInDashboardDetails) {
        dashboardId = dashboardId.replace(this.dashboardDetailsPattern, '');
      }
      return dashboardId;
    }
  }, {
    key: "isSupported",
    value: function isSupported(path) {
      return path.startsWith('/dashboards/Applications/Dashboard');
    }
  }, {
    key: "provide",
    value: /*#__PURE__*/_regenerator.default.mark(function provide(path) {
      var isInDashboardDetails, dashboardId, xlrDashboardService, _yield$call, dashboard, dashboardHref, breadcrumbs, backItem;
      return _regenerator.default.wrap(function provide$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            isInDashboardDetails = this.checkIfInDashboardDetails(path);
            dashboardId = this.getDashboardId(path, isInDashboardDetails);
            _context.next = 4;
            return (0, _effects.call)(_angularAccessor.default, 'xlrelease.XlrDashboardService');
          case 4:
            xlrDashboardService = _context.sent;
            _context.next = 7;
            return (0, _effects.call)([xlrDashboardService, xlrDashboardService.loadConfiguration], dashboardId);
          case 7:
            _yield$call = _context.sent;
            dashboard = _yield$call.data;
            dashboardHref = "".concat(this.dashboardsPrefix, "/").concat(dashboard.id);
            breadcrumbs = [{
              text: 'Reports',
              href: this.dashboardsPrefix
            }, {
              text: 'Custom dashboards',
              href: "/".concat(_xlrDashboardConstants.DASHBOARD_LIST_SUFFIX)
            }, {
              text: dashboard.title,
              href: dashboardHref
            }];
            if (isInDashboardDetails) {
              breadcrumbs.push({
                text: 'Details'
              });
              backItem = {
                pathSuffix: dashboardHref,
                title: dashboard.title,
                text: dashboard.title
              };
            } else {
              backItem = {
                pathSuffix: _xlrDashboardConstants.DASHBOARD_LIST_SUFFIX,
                title: 'Custom dashboards',
                text: 'Custom dashboards'
              };
            }
            _context.next = 14;
            return (0, _effects.put)(setLastBreadcrumb(undefined));
          case 14:
            _context.next = 16;
            return (0, _effects.put)(updateBreadcrumbs(breadcrumbs));
          case 16:
            _context.next = 18;
            return (0, _effects.put)(setSidebarMenu({
              sidebarMenu: [],
              withFolder: false
            }));
          case 18:
            _context.next = 20;
            return (0, _effects.put)(setBackItem(backItem));
          case 20:
          case "end":
            return _context.stop();
        }
      }, provide, this);
    })
  }]);
  return DashboardSidebarProvider;
}();
(0, _sidebar.registerSidebarProvider)(new DashboardSidebarProvider(), 0);

/***/ }),

/***/ 9121:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var XlrDashboardService = /*#__PURE__*/function () {
  function XlrDashboardService(Backend) {
    (0, _classCallCheck2.default)(this, XlrDashboardService);
    this.Backend = Backend;
  }
  (0, _createClass2.default)(XlrDashboardService, [{
    key: "loadConfiguration",
    value: function loadConfiguration(dashboardId, refresh) {
      var params = {};
      if (!!refresh) {
        params = {
          params: {
            refresh: refresh
          }
        };
      }
      return this.Backend.get("dashboards/".concat(dashboardId), params);
    }
  }, {
    key: "update",
    value: function update(dashboard) {
      var config = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return this.Backend.put("dashboards/".concat(dashboard.id), dashboard, config);
    }
  }, {
    key: "create",
    value: function create(dashboard) {
      return this.Backend.post('dashboards', dashboard);
    }
  }, {
    key: "delete",
    value: function _delete(dashboard) {
      return this.Backend.del("dashboards/".concat(dashboard.id));
    }
  }, {
    key: "tileTypes",
    value: function tileTypes(tileScope) {
      return this.Backend.get("tiles/tile-types?scope=".concat(tileScope));
    }
  }, {
    key: "saveTile",
    value: function saveTile(tile) {
      return this.Backend.put("tiles/".concat(tile.id), tile);
    }
  }, {
    key: "loadTile",
    value: function loadTile(tileId) {
      return this.Backend.get("tiles/".concat(tileId));
    }
  }, {
    key: "list",
    value: function list(parentId, title) {
      return this.Backend.get('dashboards', {
        params: {
          parentId: parentId,
          title: title
        }
      }).then(function (resp) {
        return resp.data;
      });
    }
  }, {
    key: "getDashboardTemplates",
    value: function getDashboardTemplates(tileScope) {
      return this.Backend.get("dashboards/templates?scope=".concat(tileScope));
    }
  }]);
  return XlrDashboardService;
}();
(0, _defineProperty2.default)(XlrDashboardService, "$inject", ['Backend']);
angular.module('xlrelease.dashboard').service('xlrelease.XlrDashboardService', XlrDashboardService);

/***/ }),

/***/ 58863:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _navigation = __webpack_require__(17523);
var _xlrDashboardConstants = __webpack_require__(56918);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var navigateTo = _navigation.navigation.actions.navigateTo;
var XlrDashboardController = /*#__PURE__*/function () {
  function XlrDashboardController($rootScope, $scope, $q, $state, $stateParams, $interval, $location, $uibModal, $ngRedux, Ids, Authenticator, ReleasesService, xlrDashboardConfigProvider, XlrDashboardService, VariablesService, XlrSidebarService, Events, Page, Backend, Download) {
    var _this = this;
    (0, _classCallCheck2.default)(this, XlrDashboardController);
    (0, _defineProperty2.default)(this, "exportDashboard", function () {
      if (!_this.isInProgess) {
        _this.isInProgess = true;
        _this.resetIFrameSrc();
        var dashboardName = _this.getDashboard().title;
        // To ensure all grid tiles appear correctly in generated pdf rename class card-content
        // to pdf-card-content to apply css formatting appropriate for pdf generation
        _this.renameDocumentClass('card-content', 'pdf-card-content');
        var content = document.getElementById('xlrdashboard');
        if (content) {
          var contentRect = content.getBoundingClientRect();
          var useWidth = contentRect.width;
          var useHeight = content.scrollHeight;
          html2canvas(content, {
            width: useWidth + contentRect.left,
            height: useHeight + 150,
            onclone: function onclone(clonedDoc) {
              // For Custom tiles we are converting iFrame elements to native HTML elements from the HTML Object of iFrame
              var iFrameElements = content.querySelectorAll('iframe');
              for (var i = iFrameElements.length - 1; i >= 0; i--) {
                var toBeReplaceIFrameBody = iFrameElements[i].contentDocument.all;
                var afterReplaceIframeElements = content.getElementsByTagName('iFrame');
                for (var j = afterReplaceIframeElements.length - 1; j >= 0; j--) {
                  if (content.getElementsByTagName('iFrame-tile')[j] !== undefined) {
                    if (iFrameElements[i].id === content.getElementsByTagName('iFrame-tile')[j].getElementsByTagName('iFrame')[0].id) {
                      clonedDoc.documentElement.getElementsByTagName('iFrame-tile')[j].outerHTML = '<div>' + toBeReplaceIFrameBody.item(0).getElementsByTagName('body')[0].innerHTML + '</div>';
                      break;
                    }
                  }
                }
              }
            }
          }).then(function (canvas) {
            var data = canvas.toDataURL();
            var encodedDashboardName = encodeURIComponent(dashboardName);
            _this.Download.post("reports/pdf?reportName=".concat(encodedDashboardName), data);
            setTimeout(function () {
              return _this.isInProgess = false;
            }, 1000);
            // Revert pdf-card-content classes to card-content to ensure all grid tiles appear correctly in UI
            _this.renameDocumentClass('pdf-card-content', 'card-content');
          });
        } else {
          setTimeout(function () {
            return _this.isInProgess = false;
          }, 1000);
          // Revert pdf-card-content classes to card-content to ensure all grid tiles appear correctly in UI
          _this.renameDocumentClass('pdf-card-content', 'card-content');
        }
      }
    });
    (0, _defineProperty2.default)(this, "reloadTiles", function () {
      _this.loadTiles(true).then(function () {
        return _this.$state.go(_this.$state.$current.name, {
          refresh: true
        }, {
          notify: false
        });
      });
    });
    (0, _defineProperty2.default)(this, "modeSwitch", function () {
      _this.dashboardMode = _this.isDesignMode() ? _xlrDashboardConstants.DASHBOARD_MODE.VIEW : _xlrDashboardConstants.DASHBOARD_MODE.DESIGN;
      _this.gridsterOpts = _this.getDashboardGridsterOpts(_this.xlrDashboardConfigProvider.getConfig(_this.isDesignMode(), _this.saveDashboard.bind(_this)));
      if (_this.isDesignMode()) {
        _this.stopTilePolling();
      } else {
        _this.startTilePolling();
        _this.$location.search('dashboardMode', null);
      }
    });
    (0, _defineProperty2.default)(this, "toConfigureMode", function () {
      _this.modeSwitch();
      _this.$scope.$apply();
    });
    (0, _defineProperty2.default)(this, "backToViewMode", function () {
      return _this.saveDashboard(true, true);
    });
    (0, _defineProperty2.default)(this, "saveDashboard", function (switchMode) {
      var refreshTiles = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      _this.XlrDashboardService.update(_this.getDashboard()).then(function (response) {
        if (refreshTiles) {
          _this.dashboard = response.data;
        }
        if (switchMode) {
          _this.modeSwitch();
        }
        _this.XlrSidebarService.closeAll();
      });
    });
    (0, _defineProperty2.default)(this, "deleteDashboard", function () {
      var parentId = _this.getDashboard().parentId;
      var navigatePathSuffix = _xlrDashboardConstants.DASHBOARD_LIST_SUFFIX;
      _this.XlrDashboardService.delete(_this.getDashboard()).then(function () {
        if (_this.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.FOLDER && parentId) {
          navigatePathSuffix = "folders/".concat(parentId, "/dashboards");
        }
        _this.$ngRedux.dispatch(navigateTo({
          pathSuffix: navigatePathSuffix
        }));
      });
    });
    (0, _defineProperty2.default)(this, "duplicateDashboard", function (dashboard) {
      _this.XlrDashboardService.create(dashboard).then(function (response) {
        var newDashboard = response.data;
        var pageToNavigate = '';
        if (newDashboard.parentId) {
          pageToNavigate = "folders/".concat(newDashboard.parentId, "/");
        }
        pageToNavigate += "dashboards/".concat(newDashboard.id);
        _this.$ngRedux.dispatch(navigateTo({
          pathSuffix: pageToNavigate
        }));
      });
    });
    (0, _defineProperty2.default)(this, "addAnalyticsCarouselTile", function () {
      if (_this.isHomeDashboard()) {
        var changedDashboard = angular.copy(_this.getDashboard());
        changedDashboard.tiles.push(_this.newTile('xlrelease.AnalyticsCarouselTile', changedDashboard.columns));
        var newDashboardTiles = changedDashboard.tiles.map(function (tile, index) {
          if (index === changedDashboard.tiles.length - 1) {
            return _objectSpread(_objectSpread({}, tile), {}, {
              row: 0,
              col: 0
            });
          } else {
            return _objectSpread(_objectSpread({}, tile), {}, {
              row: tile.row + 2
            });
          }
        });
        _this.XlrDashboardService.update(_objectSpread(_objectSpread({}, changedDashboard), {}, {
          tiles: newDashboardTiles
        }), {
          dontRedirectWhenForbidden: true
        }).then(function (response) {
          _this.updateDashboard(response.data);
        });
      }
    });
    (0, _defineProperty2.default)(this, "editDashboard", function () {
      _this.XlrSidebarService.toggle(_xlrDashboardConstants.DASHBOARD_PROPERTIES_SIDEBAR_NAME);
    });
    (0, _defineProperty2.default)(this, "toggleWidgets", function () {
      _this.XlrSidebarService.toggle(_xlrDashboardConstants.DASHBOARD_WIDGETS_SIDEBAR_NAME);
    });
    this.$rootScope = $rootScope;
    this.$scope = $scope;
    this.$q = $q;
    this.$state = $state;
    this.$stateParams = $stateParams;
    this.$interval = $interval;
    this.$location = $location;
    this.$uibModal = $uibModal;
    this.$ngRedux = $ngRedux;
    this.Ids = Ids;
    this.Authenticator = Authenticator;
    this.ReleasesService = ReleasesService;
    this.xlrDashboardConfigProvider = xlrDashboardConfigProvider;
    this.XlrDashboardService = XlrDashboardService;
    this.VariablesService = VariablesService;
    this.XlrSidebarService = XlrSidebarService;
    this.Events = Events;
    this.Page = Page;
    this.Backend = Backend;
    this.Download = Download;
    this.isInProgress = false;
    this.filteredTileTypeDefs = [];
    this.showAddTileModal = false;
    this.dashboardMode = $stateParams.dashboardMode || _xlrDashboardConstants.DASHBOARD_MODE.VIEW;
    this.gridsterOpts = xlrDashboardConfigProvider.getConfig(this.isDesignMode(), this.saveDashboard.bind(this));
    this.initialized = false;
    this.dashboardPromise = [];
    this.sidebarOpts = {
      position: 'right',
      backdropOpacity: 0
    };
    if (this.$stateParams.releaseId) {
      this.parentId = this.$stateParams.releaseId;
      this.dashboardLevel = _xlrDashboardConstants.DASHBOARD_LEVEL.RELEASE;
    } else if (this.$stateParams.folderId) {
      this.parentId = this.$stateParams.folderId;
      this.dashboardLevel = _xlrDashboardConstants.DASHBOARD_LEVEL.FOLDER;
    } else if (this.$state.current.name === 'home') {
      this.parentId = null;
      this.dashboardLevel = _xlrDashboardConstants.DASHBOARD_LEVEL.HOME;
    } else {
      this.parentId = null;
      this.dashboardLevel = _xlrDashboardConstants.DASHBOARD_LEVEL.GLOBAL;
    }
    if (this.isGlobalDashboard() || this.isFolderDashboard()) {
      this.initWithGlobalOrFolderContext();
    } else if (this.isHomeDashboard()) {
      this.initHomeContext();
    } else {
      this.initWithRelease();
    }
    this.DASHBOARD_WIDGETS_SIDEBAR_NAME = _xlrDashboardConstants.DASHBOARD_WIDGETS_SIDEBAR_NAME;
    this.DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME = _xlrDashboardConstants.DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME;
    this.DASHBOARD_PROPERTIES_SIDEBAR_NAME = _xlrDashboardConstants.DASHBOARD_PROPERTIES_SIDEBAR_NAME;
  }
  (0, _createClass2.default)(XlrDashboardController, [{
    key: "$onDestroy",
    value: function $onDestroy() {
      this.stopTilePolling();
    }
  }, {
    key: "initPlaceholders",
    value: function initPlaceholders(maxCol, maxRow) {
      this.gridsterPlaceholderOpts = _objectSpread(_objectSpread({}, this.gridsterOpts), this.xlrDashboardConfigProvider.getPlaceholderProperties());
      var col = 0;
      var row = 0;
      var sizeX = 1;
      this.placeholders = _.times(maxCol * maxRow, function () {
        var config = {
          col: col,
          row: row,
          sizeX: sizeX
        };
        if (col + 1 >= maxCol) {
          col = 0;
          row++;
        } else {
          col++;
        }
        return config;
      });
    }
  }, {
    key: "initWithRelease",
    value: function initWithRelease() {
      var _this2 = this;
      this.dashboard = {
        id: "".concat(this.Ids.toDomainId(this.$stateParams.releaseId), "/").concat(this.$stateParams.extensionPath),
        tiles: []
      };
      this.release = _.get(this.$scope, ['releasePageExtensionCtrl', 'release']);
      this.canEditDashboard = this.Authenticator.hasEditPermission(this.release) && !this.ReleasesService.isReleaseArchived(this.release);
      this.canDeleteDashboard = false;
      this.$q.all([this.loadTiles(), this.loadTileTypes(), this.loadAllVariables(), this.loadAllVariableValues()]).then(function () {
        _this2.initialized = true;
      });
    }
  }, {
    key: "initWithGlobalOrFolderContext",
    value: function initWithGlobalOrFolderContext() {
      var _this3 = this;
      this.dashboard = {
        id: this.$stateParams.dashboardId,
        tiles: []
      };
      this.release = {};
      this.$q.all([this.loadTiles(), this.loadTileTypes(), this.loadAllVariables(), this.loadAllVariableValues()]).then(function () {
        _this3.initialized = true;
        _this3.canEditDashboard = _this3.Authenticator.hasPermission('dashboard#edit', _this3.dashboard.metadata);
        _this3.canCreateDashboard = _this3.isGlobalDashboard() ? _this3.Authenticator.hasPermission('dashboard#create') : _this3.Authenticator.hasPermission('dashboard#edit', _this3.dashboard.metadata);
        _this3.canDeleteDashboard = _this3.canEditDashboard;
        if (!_this3.canEditDashboard && _this3.isDesignMode()) {
          _this3.modeSwitch();
        }
        if (!_this3.isDesignMode()) {
          _this3.startTilePolling();
        }
      });
    }
  }, {
    key: "initHomeContext",
    value: function initHomeContext() {
      var _this4 = this;
      this.dashboard = {
        id: 'Applications/DashboardHome',
        tiles: []
      };
      this.release = {};
      this.$q.all([this.loadTiles(), this.loadTileTypes(), this.loadAllVariables(), this.loadAllVariableValues()]).then(function () {
        _this4.initialized = true;
        _this4.canEditDashboard = _this4.Authenticator.isAdminOr();
        _this4.canDeleteDashboard = false;
        if (!_this4.canEditDashboard && _this4.isDesignMode()) {
          _this4.modeSwitch();
        }
        if (!_this4.isDesignMode()) {
          _this4.startTilePolling();
        }
      });
    }
  }, {
    key: "renameDocumentClass",
    value: function renameDocumentClass(sourceClassName, destinationClassName) {
      Array.from(document.getElementsByClassName(sourceClassName)).forEach(function (element) {
        var classList = element.classList;
        classList.add(destinationClassName);
        classList.remove(sourceClassName);
      });
    }
  }, {
    key: "resetIFrameSrc",
    value: function resetIFrameSrc() {
      var iFrame = document.querySelector('[downloader] > iframe');
      if (iFrame) {
        iFrame.setAttribute('src', '');
      }
    }
  }, {
    key: "loadTiles",
    value: function loadTiles() {
      var _this5 = this;
      var refresh = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      return this.XlrDashboardService.loadConfiguration(this.dashboard.id, refresh).then(function (response) {
        if (!_.isEmpty(response.data)) {
          _this5.dashboard = response.data;
          _this5.gridsterOpts = _this5.getDashboardGridsterOpts(_this5.gridsterOpts);
          _this5.initPlaceholders(_this5.dashboard.columns, _this5.dashboard.rows);
        }
        return _this5.dashboard;
      });
    }
  }, {
    key: "loadTileTypes",
    value: function loadTileTypes() {
      var _this6 = this;
      return this.XlrDashboardService.tileTypes(this.dashboardLevel).then(function (response) {
        _this6.tileTypes = response.data;
        _this6.tileTypeDefs = _.reduce(_this6.tileTypes, function (memo, it) {
          it.property = _.keyBy(it.properties, 'name');
          memo[it.type] = it;
          return memo;
        }, {});
        _this6.filteredTileTypeDefs = _.values(_this6.tileTypeDefs);
        return _this6.tileTypeDefs;
      });
    }
  }, {
    key: "loadAllVariables",
    value: function loadAllVariables() {
      var _this7 = this;
      return this.VariablesService.getAllVariables(this.$stateParams.releaseId, this.$stateParams.folderId).then(function (allVariables) {
        _this7.allVariables = allVariables;
        return _this7.allVariables;
      });
    }
  }, {
    key: "loadAllVariableValues",
    value: function loadAllVariableValues() {
      var _this8 = this;
      return this.VariablesService.getAllVariableValues(this.$stateParams.releaseId, this.$stateParams.folderId).then(function (allVariableValues) {
        _this8.allVariableValues = allVariableValues;
        return _this8.allVariableValues;
      });
    }
  }, {
    key: "getDashboardGridsterOpts",
    value: function getDashboardGridsterOpts(config) {
      return _objectSpread(_objectSpread({}, config), {}, {
        columns: this.dashboard.columns,
        // for home dashboard we need some fancy number to not have scrollbars
        rowHeight: this.isHomeDashboard() ? 161 : 150 + 450 / this.dashboard.columns,
        rows: this.dashboard.rows,
        maxSizeY: this.dashboard.rows,
        maxSizeX: this.dashboard.columns
      });
    }
  }, {
    key: "isDesignMode",
    value: function isDesignMode() {
      return this.dashboardMode === _xlrDashboardConstants.DASHBOARD_MODE.DESIGN;
    }
  }, {
    key: "getVariables",
    value: function getVariables() {
      return this.isDesignMode() ? this.allVariables : this.allVariableValues;
    }
  }, {
    key: "newTile",
    value: function newTile(tileType, dashboardColumns) {
      return {
        id: null,
        type: tileType,
        title: this.tileTypeDefs[tileType].property.title.default,
        uri: this.tileTypeDefs[tileType].property.uri.default,
        minSizeX: this.tileTypeDefs[tileType].property.minSizeX.default,
        minSizeY: this.tileTypeDefs[tileType].property.minSizeY.default,
        sizeX: this.tileTypeDefs[tileType].property.width.default > dashboardColumns ? dashboardColumns : this.tileTypeDefs[tileType].property.width.default
      };
    }
  }, {
    key: "isReleaseDashboard",
    value: function isReleaseDashboard() {
      return this.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.RELEASE;
    }
  }, {
    key: "isGlobalDashboard",
    value: function isGlobalDashboard() {
      return this.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.GLOBAL;
    }
  }, {
    key: "isFolderDashboard",
    value: function isFolderDashboard() {
      return this.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.FOLDER;
    }
  }, {
    key: "isHomeDashboard",
    value: function isHomeDashboard() {
      return this.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.HOME;
    }
  }, {
    key: "getDashboard",
    value: function getDashboard() {
      return _.omit(this.dashboard, ['metadata']);
    }
  }, {
    key: "updateDashboard",
    value: function updateDashboard(dashboard) {
      if (!_.isEmpty(dashboard)) {
        this.dashboard = dashboard;
      }
    }
  }, {
    key: "addTile",
    value: function addTile(tileType) {
      var _this9 = this;
      if (tileType) {
        var changedDashboard = angular.copy(this.getDashboard());
        changedDashboard.tiles.push(this.newTile(tileType, changedDashboard.columns));
        this.XlrDashboardService.update(changedDashboard).then(function (response) {
          _this9.updateDashboard(response.data);
        });
      }
    }
  }, {
    key: "removeTile",
    value: function removeTile(item) {
      var _this10 = this;
      var changedDashboard = angular.copy(this.getDashboard());
      var tileIndex = _.findIndex(this.dashboard.tiles, {
        id: item.id
      });
      changedDashboard.tiles.splice(tileIndex, 1);
      this.XlrDashboardService.update(changedDashboard).then(function (response) {
        _this10.updateDashboard(response.data);
      });
    }
  }, {
    key: "saveTile",
    value: function saveTile(tile) {
      var _this11 = this;
      this.XlrDashboardService.saveTile(tile).then(function (response) {
        var updatedTile = response.data;
        var tileIndex = _.findIndex(_this11.dashboard.tiles, {
          id: updatedTile.id
        });
        if (tileIndex >= 0) {
          _this11.dashboard.tiles[tileIndex] = updatedTile;
          _this11.tile = updatedTile;
        } else {
          // the first dashboard has tile with default IDs.
          // Those IDs are changed to unique/fresh values the first time the Dashboard is persisted.
          // Hence we need to fetch the persisted dashboard containing the (same) tiles but with the persisted IDs,
          // so that on subsequent runs `tileIndex` will find the tile by ID
          _this11.loadTiles();
        }
        _this11.XlrSidebarService.close('tileConfigureSidebar');
      });
    }
  }, {
    key: "configureTile",
    value: function configureTile(tile) {
      this.currentTile = tile;
      this.XlrSidebarService.open(_xlrDashboardConstants.DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME);
    }
  }, {
    key: "startTilePolling",
    value: function startTilePolling() {
      var _this12 = this;
      if (this.dashboard.autoRefresh && !_.isEmpty(this.dashboard.tiles) && _.isEmpty(this.dashboardPromise)) {
        this.dashboardPromise = this.$interval(function () {
          _this12.reloadTiles();
        }, this.dashboard.autoRefreshInterval * 1000);
      }
    }
  }, {
    key: "stopTilePolling",
    value: function stopTilePolling() {
      if (!_.isEmpty(this.dashboardPromise)) {
        var isCancelled = this.$interval.cancel(this.dashboardPromise);
        if (isCancelled) {
          this.dashboardPromise = [];
        }
      }
    }
  }]);
  return XlrDashboardController;
}();
(0, _defineProperty2.default)(XlrDashboardController, "$inject", ['$rootScope', '$scope', '$q', '$state', '$stateParams', '$interval', '$location', '$uibModal', '$ngRedux', 'Ids', 'Authenticator', 'ReleasesService', 'xlrDashboardConfigProvider', 'xlrelease.XlrDashboardService', 'VariablesService', 'xlrelease.XlrSidebarService', 'Events', 'Page', 'Backend', 'Download']);
var XlrDashboard = function XlrDashboard() {
  return {
    transclude: true,
    templateUrl: 'static/24.1.10/include/DashboardPage/xlr-dashboard.html',
    controller: 'xlrelease.dashboard.XlrDashboardController',
    controllerAs: 'xlrDashboard'
  };
};
angular.module('xlrelease.dashboard').directive('xlrDashboard', XlrDashboard).controller('xlrelease.dashboard.XlrDashboardController', XlrDashboardController);

/***/ }),

/***/ 59821:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _extends2 = _interopRequireDefault(__webpack_require__(67154));
var _react = _interopRequireDefault(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _react2angular = __webpack_require__(96563);
var _dotComponents = __webpack_require__(92140);
var _actionToolbar = __webpack_require__(29755);
var XlrDashboardPortal = function XlrDashboardPortal(_ref) {
  var isDesignMode = _ref.isDesignMode,
    isGlobalDashboard = _ref.isGlobalDashboard,
    isFolderDashboard = _ref.isFolderDashboard,
    canEditDashboard = _ref.canEditDashboard,
    addTilesButtonProps = _ref.addTilesButtonProps,
    backButtonProps = _ref.backButtonProps,
    configureButtonProps = _ref.configureButtonProps;
  var helpLink = isGlobalDashboard || isFolderDashboard ? 'how-to/configure-custom-dashboards.html' : 'how-to/using-the-release-dashboard.html';
  return /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, {
    helpLink: helpLink
  }, isDesignMode ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canEditDashboard && /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, (0, _extends2.default)({
    startIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      iconId: "back"
    }),
    type: "outlined"
  }, backButtonProps), "Back to view mode"), canEditDashboard && /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, addTilesButtonProps, "Add tiles")) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canEditDashboard && /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, configureButtonProps, "Configure dashboard")));
};
XlrDashboardPortal.propTypes = {
  addTilesButtonProps: _propTypes.default.object,
  backButtonProps: _propTypes.default.object,
  canEditDashboard: _propTypes.default.bool,
  configureButtonProps: _propTypes.default.object,
  isDesignMode: _propTypes.default.bool,
  isFolderDashboard: _propTypes.default.bool,
  isGlobalDashboard: _propTypes.default.bool
};
angular.module('xlrelease.dashboard').component('xlrDashboardPortal', (0, _react2angular.react2angular)(XlrDashboardPortal, ['isDesignMode', 'isGlobalDashboard', 'isFolderDashboard', 'canEditDashboard', 'addTilesButtonProps', 'backButtonProps', 'configureButtonProps']));

/***/ }),

/***/ 93378:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FolderDashboardSidebarProvider = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(319));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _effects = __webpack_require__(34857);
var _sidebar = __webpack_require__(73811);
var _folders = __webpack_require__(59462);
var _angularAccessor = _interopRequireDefault(__webpack_require__(81403));
var _helpers = __webpack_require__(39258);
var _navigation = __webpack_require__(17523);
var _xlrDashboardProvider = __webpack_require__(58371);
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var _navigation$actions = _navigation.navigation.actions,
  setSidebarMenu = _navigation$actions.setSidebarMenu,
  setLastBreadcrumb = _navigation$actions.setLastBreadcrumb,
  updateBreadcrumbs = _navigation$actions.updateBreadcrumbs,
  setBackItem = _navigation$actions.setBackItem;
var FolderDashboardSidebarProvider = exports.FolderDashboardSidebarProvider = /*#__PURE__*/function (_DashboardSidebarProv) {
  (0, _inherits2.default)(FolderDashboardSidebarProvider, _DashboardSidebarProv);
  var _super = _createSuper(FolderDashboardSidebarProvider);
  function FolderDashboardSidebarProvider() {
    (0, _classCallCheck2.default)(this, FolderDashboardSidebarProvider);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(FolderDashboardSidebarProvider, [{
    key: "isSupported",
    value: function isSupported(path) {
      return path.startsWith('/folders/') && path.includes('/dashboards/Applications/Dashboard');
    }
  }, {
    key: "getDashboardsListPath",
    value: function getDashboardsListPath(path) {
      return path.substring(0, path.lastIndexOf(this.dashboardsPrefix) + this.dashboardsPrefix.length);
    }
  }, {
    key: "getDashboardPath",
    value: function getDashboardPath(path, isDetails) {
      return isDetails ? path.substring(0, path.lastIndexOf('/Tile')) : path;
    }
  }, {
    key: "getDashboardId",
    value: function getDashboardId(path, isInDashboardDetails) {
      var searchString = "".concat(this.dashboardsPrefix, "/");
      var lastIndex = path.lastIndexOf(searchString);
      var dashboardId = path.substring(lastIndex + searchString.length);
      if (isInDashboardDetails) {
        dashboardId = dashboardId.replace(this.dashboardDetailsPattern, '');
      }
      return dashboardId;
    }
  }, {
    key: "provide",
    value: /*#__PURE__*/_regenerator.default.mark(function provide(path) {
      var isInDashboardDetails, dashboardId, xlrDashboardService, _yield$call, dashboard, dashboardsListPath, dashboardPath, selectedFolder, uiExtensionsService, folderTabs, $state, selectedPathSuffix, folderSidebar, folderPathService, parentFolders, folderBreadcrumbs;
      return _regenerator.default.wrap(function provide$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            isInDashboardDetails = this.checkIfInDashboardDetails(path);
            dashboardId = this.getDashboardId(path, isInDashboardDetails);
            _context.next = 4;
            return (0, _effects.call)(_angularAccessor.default, 'xlrelease.XlrDashboardService');
          case 4:
            xlrDashboardService = _context.sent;
            _context.next = 7;
            return (0, _effects.call)([xlrDashboardService, xlrDashboardService.loadConfiguration], dashboardId);
          case 7:
            _yield$call = _context.sent;
            dashboard = _yield$call.data;
            dashboardsListPath = this.getDashboardsListPath(path);
            dashboardPath = this.getDashboardPath(path, isInDashboardDetails);
            _context.next = 13;
            return (0, _effects.call)(_folders.getFolderOrWaitForIt);
          case 13:
            selectedFolder = _context.sent;
            _context.next = 16;
            return (0, _effects.call)(_angularAccessor.default, 'UiExtensionsService');
          case 16:
            uiExtensionsService = _context.sent;
            _context.next = 19;
            return (0, _effects.call)([uiExtensionsService, uiExtensionsService.getMenuItems], 'xlrelease.sidebar.Folder', selectedFolder);
          case 19:
            folderTabs = _context.sent;
            _context.next = 22;
            return (0, _effects.call)(_angularAccessor.default, '$state');
          case 22:
            $state = _context.sent;
            selectedPathSuffix = $state.params.page || 'templates';
            folderSidebar = folderTabs.filter(function (tab) {
              return tab.permitted;
            }).map(function (tab) {
              return {
                text: tab.label,
                startIconId: tab.icon,
                endIconId: tab.properties && tab.properties.hasChildren === 'true' ? 'arrow-right' : '',
                pathSuffix: "folders/".concat(selectedFolder.id, "/").concat(tab.pathSuffix),
                selected: selectedPathSuffix ? (0, _helpers.isActivePath)(tab.pathSuffix, selectedPathSuffix) : false
              };
            });
            _context.next = 27;
            return (0, _effects.put)(setSidebarMenu({
              sidebarMenu: folderSidebar,
              withFolder: true
            }));
          case 27:
            _context.next = 29;
            return (0, _effects.call)(_angularAccessor.default, 'FolderPathService');
          case 29:
            folderPathService = _context.sent;
            _context.next = 32;
            return (0, _effects.call)([folderPathService, folderPathService.getPathFromParentFolderId], selectedFolder.id);
          case 32:
            parentFolders = _context.sent;
            folderBreadcrumbs = [];
            folderBreadcrumbs.push.apply(folderBreadcrumbs, (0, _toConsumableArray2.default)(parentFolders.map(function (f) {
              return {
                text: f.title,
                href: "/folders/".concat(f.id, "/").concat(selectedPathSuffix)
              };
            })).concat([{
              text: 'Custom dashboards',
              href: dashboardsListPath
            }, {
              text: dashboard.title,
              href: dashboardPath
            }]));
            if (isInDashboardDetails) {
              folderBreadcrumbs.push({
                text: 'Details'
              });
            }
            _context.next = 38;
            return (0, _effects.put)(setLastBreadcrumb(undefined));
          case 38:
            _context.next = 40;
            return (0, _effects.put)(setBackItem(null));
          case 40:
            _context.next = 42;
            return (0, _effects.put)(updateBreadcrumbs(folderBreadcrumbs));
          case 42:
          case "end":
            return _context.stop();
        }
      }, provide, this);
    })
  }]);
  return FolderDashboardSidebarProvider;
}(_xlrDashboardProvider.DashboardSidebarProvider);
(0, _sidebar.registerSidebarProvider)(new FolderDashboardSidebarProvider());

/***/ }),

/***/ 596:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.NewDashboardSidebarProvider = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _effects = __webpack_require__(34857);
var _navigation = __webpack_require__(17523);
var _sidebar = __webpack_require__(73811);
var _angularAccessor = _interopRequireDefault(__webpack_require__(81403));
var _xlrDashboardConstants = __webpack_require__(56918);
var _navigation$actions = _navigation.navigation.actions,
  setBackItem = _navigation$actions.setBackItem,
  updateBreadcrumbs = _navigation$actions.updateBreadcrumbs,
  setSidebarMenu = _navigation$actions.setSidebarMenu,
  setLastBreadcrumb = _navigation$actions.setLastBreadcrumb;
var NewDashboardSidebarProvider = exports.NewDashboardSidebarProvider = /*#__PURE__*/function () {
  function NewDashboardSidebarProvider() {
    (0, _classCallCheck2.default)(this, NewDashboardSidebarProvider);
  }
  (0, _createClass2.default)(NewDashboardSidebarProvider, [{
    key: "isSupported",
    value: function isSupported(path) {
      return path.startsWith('/dashboards/new');
    }
  }, {
    key: "provide",
    value: /*#__PURE__*/_regenerator.default.mark(function provide() {
      var _mainMenuItems$find, _reportsTabs$find;
      var uiExtensionsService, mainMenuItems, reportsTabs, dashboardTabs, dashboardSidebar, breadcrumbs;
      return _regenerator.default.wrap(function provide$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return (0, _effects.call)(_angularAccessor.default, 'UiExtensionsService');
          case 2:
            uiExtensionsService = _context.sent;
            _context.next = 5;
            return (0, _effects.call)([uiExtensionsService, uiExtensionsService.getMainMenuItems]);
          case 5:
            mainMenuItems = _context.sent;
            reportsTabs = ((_mainMenuItems$find = mainMenuItems.find(function (item) {
              return item.id === 'xlrelease.menu.Reports';
            })) === null || _mainMenuItems$find === void 0 ? void 0 : _mainMenuItems$find.items) || [];
            dashboardTabs = ((_reportsTabs$find = reportsTabs.find(function (tab) {
              return tab.id === 'xlrelease.menu.Dashboards';
            })) === null || _reportsTabs$find === void 0 ? void 0 : _reportsTabs$find.items) || [];
            dashboardSidebar = dashboardTabs.filter(function (tab) {
              return tab.permitted;
            }).map(function (tab) {
              return {
                text: tab.label,
                startIconId: tab.icon,
                pathSuffix: tab.pathSuffix,
                selected: tab.pathSuffix === _xlrDashboardConstants.DASHBOARD_LIST_SUFFIX
              };
            });
            breadcrumbs = [{
              text: 'Dashboards',
              href: "/dashboards"
            }, {
              text: 'Custom dashboards',
              href: "/".concat(_xlrDashboardConstants.DASHBOARD_LIST_SUFFIX)
            }, {
              text: 'New dashboard'
            }];
            _context.next = 12;
            return (0, _effects.put)(setSidebarMenu({
              sidebarMenu: dashboardSidebar,
              withFolder: false
            }));
          case 12:
            _context.next = 14;
            return (0, _effects.put)(setLastBreadcrumb(undefined));
          case 14:
            _context.next = 16;
            return (0, _effects.put)(updateBreadcrumbs(breadcrumbs));
          case 16:
            _context.next = 18;
            return (0, _effects.put)(setBackItem({
              pathSuffix: _xlrDashboardConstants.DASHBOARD_LIST_SUFFIX,
              title: 'Custom dashboards',
              text: 'Custom dashboards'
            }));
          case 18:
          case "end":
            return _context.stop();
        }
      }, provide);
    })
  }]);
  return NewDashboardSidebarProvider;
}();
(0, _sidebar.registerSidebarProvider)(new NewDashboardSidebarProvider(), 0);

/***/ }),

/***/ 27347:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var XlrSidebarService = /*#__PURE__*/function () {
  function XlrSidebarService(SidebarJS) {
    (0, _classCallCheck2.default)(this, XlrSidebarService);
    this.SidebarJS = SidebarJS;
  }
  (0, _createClass2.default)(XlrSidebarService, [{
    key: "open",
    value: function open(sidebarName) {
      this.closeAll();
      this.SidebarJS.open(sidebarName);
    }
  }, {
    key: "close",
    value: function close(sidebarName) {
      this.SidebarJS.close(sidebarName);
    }
  }, {
    key: "closeAll",
    value: function closeAll() {
      var _this = this;
      Object.keys(this.SidebarJS.instances).map(function (instanceName) {
        return _this.SidebarJS.close(instanceName);
      });
    }
  }, {
    key: "toggle",
    value: function toggle(sidebarName) {
      var sidebar = this.SidebarJS.instances[sidebarName];
      if (sidebar.isVisible()) {
        this.closeAll();
      } else {
        this.open(sidebarName);
      }
    }
  }]);
  return XlrSidebarService;
}();
(0, _defineProperty2.default)(XlrSidebarService, "$inject", ['SidebarJS']);
angular.module('xlrelease.dashboard').service('xlrelease.XlrSidebarService', XlrSidebarService);

/***/ }),

/***/ 24346:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var XlrDefaultTileController = /*#__PURE__*/function () {
  function XlrDefaultTileController($scope, XlrDefaultTileService) {
    (0, _classCallCheck2.default)(this, XlrDefaultTileController);
    this.XlrDefaultTileService = XlrDefaultTileService;
    this.data = null;
    this.release = $scope.release;
    if ($scope.xlrTile) {
      this.tile = $scope.xlrTile.tile; // summary mode
    } else {
      this.tile = $scope.xlrTileDetailsCtrl.tile; // details mode
    }
  }
  (0, _createClass2.default)(XlrDefaultTileController, [{
    key: "$onInit",
    value: function $onInit() {
      this.refresh();
    }
  }, {
    key: "refresh",
    value: function refresh() {
      var _this = this;
      this.loading = true;
      // Optional query for getting data from an external backend, for example Jira or Jenkins
      this.XlrDefaultTileService.executeQuery(this.tile.id).then(function (response) {
        _this.data = response.data.data;
      }).finally(function () {
        this.loading = false;
      });
    }
  }]);
  return XlrDefaultTileController;
}();
(0, _defineProperty2.default)(XlrDefaultTileController, "$inject", ['$scope', 'xlrelease.dashboard.XlrDefaultTileService']);
var XlrDefaultTileService = /*#__PURE__*/function () {
  function XlrDefaultTileService(Backend) {
    (0, _classCallCheck2.default)(this, XlrDefaultTileService);
    this.Backend = Backend;
  }
  (0, _createClass2.default)(XlrDefaultTileService, [{
    key: "executeQuery",
    value: function executeQuery(tileId) {
      // This will trigger a Jython script (TileType.py by default) to get data from the external source.
      // The script can access input properties.
      // Query parameters can also be used here and will be available as variables in the script.
      return this.Backend.get("tiles/".concat(tileId, "/data"));
    }
  }]);
  return XlrDefaultTileService;
}();
(0, _defineProperty2.default)(XlrDefaultTileService, "$inject", ['Backend']);
angular.module('xlrelease.dashboard').service('xlrelease.dashboard.XlrDefaultTileService', XlrDefaultTileService).controller('xlrelease.dashboard.XlrDefaultTileController', XlrDefaultTileController);

/***/ }),

/***/ 26092:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _reportTileConstants = __webpack_require__(83239);
var XlrTileDetailsController = /*#__PURE__*/function () {
  function XlrTileDetailsController(tilePromise, releasePromise, dashboardPromise, Ids, Page, ReportTileService, isGlobalDashboard) {
    (0, _classCallCheck2.default)(this, XlrTileDetailsController);
    this.tile = _.get(tilePromise, 'data');
    this.release = _.get(releasePromise, 'data');
    this.dashboard = _.get(dashboardPromise, 'data');
    this.Ids = Ids;
    this.isGlobalDashboard = isGlobalDashboard;
    if (this.dashboard) {
      Page.setDashboardOpened(this.dashboard);
    }
    this.hasFilters = false;
    if (angular.isDefined(this.tile.properties.filters)) {
      this.hasFilters = true;
      this.dateFilter = ReportTileService.getDateFilter(this.tile);
      this.template = "\n                <div class=\"popover popover-dark report-tile-filters-tooltip\">\n                    <div class=\"arrow\"></div>\n                    <div class=\"popover-content\">\n                        <report-tile-filters-tooltip tile=\"xlrTileDetailsCtrl.tile\"></report-tile-filters-tooltip>\n                    </div>\n                </div>\n            ";
    }
  }
  (0, _createClass2.default)(XlrTileDetailsController, [{
    key: "checkIfGlobalDashboard",
    value: function checkIfGlobalDashboard() {
      return this.isGlobalDashboard;
    }
  }, {
    key: "getDashboardUrl",
    value: function getDashboardUrl() {
      if (this.release) {
        var base = this.release.status === 'TEMPLATE' ? 'templates' : 'releases';
        return "#/".concat(base, "/").concat(this.release.id, "/summary");
      } else if (this.dashboard && this.dashboard.parentId) {
        return "#/folders/".concat(this.dashboard.parentId, "/dashboards/").concat(this.dashboard.id);
      } else {
        return "#/dashboards/".concat(this.Ids.getParentId(this.tile.id));
      }
    }
  }, {
    key: "hasDisplayableFilters",
    value: function hasDisplayableFilters() {
      return this.hasFilters && this.tile.properties.filters.filter(function (f) {
        return f.type !== _reportTileConstants.DATE_FILTER_TYPE;
      }).length > 0;
    }
  }]);
  return XlrTileDetailsController;
}();
(0, _defineProperty2.default)(XlrTileDetailsController, "$inject", ['tilePromise', 'releasePromise', 'dashboardPromise', 'Ids', 'Page', 'ReportTileService', 'isGlobalDashboard']);
angular.module('xlrelease.dashboard').controller('xlrelease.dashboard.XlrTileDetailsController', XlrTileDetailsController);

/***/ }),

/***/ 6798:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.XlrTileDetailsPortal = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _react2angular = __webpack_require__(96563);
var _reactRedux = __webpack_require__(37703);
var _dotComponents = __webpack_require__(92140);
var _globalDashboadStore = __webpack_require__(50898);
var _hooks = __webpack_require__(38602);
var _hooks2 = __webpack_require__(96462);
var _navigation = __webpack_require__(94744);
var _actionToolbar = __webpack_require__(29755);
var _linkButton = __webpack_require__(62664);
var XlrTileDetailsPortal = exports.XlrTileDetailsPortal = function XlrTileDetailsPortal(props) {
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _globalDashboadStore.store
  }, /*#__PURE__*/_react.default.createElement(XlrTileDetailsPortalContent, props));
};
var XlrTileDetailsPortalContent = function XlrTileDetailsPortalContent(_ref) {
  var dashboardUrl = _ref.dashboardUrl,
    isGlobalDashboard = _ref.isGlobalDashboard;
  var dispatch = (0, _hooks2.useAppDispatch)();
  var _useAppSelector = (0, _hooks2.useAppSelector)(_navigation.getNavigationState),
    menuIsOpen = _useAppSelector.menuIsOpen;
  isGlobalDashboard && (0, _hooks.useCloseSidebar)(menuIsOpen, dispatch);
  return /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, {
    helpLink: "how-to/using-the-release-dashboard.html"
  }, /*#__PURE__*/_react.default.createElement(_linkButton.LinkButton, {
    href: dashboardUrl
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
    iconId: "chevron-left"
  }), " Back to dashboard"));
};
XlrTileDetailsPortalContent.propTypes = {
  dashboardUrl: _propTypes.default.string,
  isGlobalDashboard: _propTypes.default.bool
};
angular.module('xlrelease.dashboard').component('tileDetailsPortal', (0, _react2angular.react2angular)(XlrTileDetailsPortal, ['dashboardUrl', 'isGlobalDashboard']));

/***/ }),

/***/ 92765:
/***/ (function() {

"use strict";


var XlrTileTitle = function XlrTileTitle() {
  return {
    restrict: 'A',
    require: ['^xlrTile'],
    transclude: true,
    link: function link(scope, elem, attr, ctrls, transclude) {
      _.head(ctrls).setTitle(transclude);
    }
  };
};
angular.module('xlrelease.dashboard').directive('xlrTileTitle', XlrTileTitle);

/***/ }),

/***/ 39629:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.tileOrDefaultUrl = tileOrDefaultUrl;
function tileOrDefaultUrl(uri, defaultUri) {
  return "static/24.1.10/".concat(_.isEmpty(uri) ? _.isUndefined(defaultUri) ? 'include/DashboardPage/partials/no-uri.html' : defaultUri : uri);
}

/***/ }),

/***/ 45336:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _xlrTileUtil = __webpack_require__(39629);
var _xlrDashboardConstants = __webpack_require__(56918);
var XlrTileController = /*#__PURE__*/function () {
  function XlrTileController($scope, $location, $stateParams, Ids) {
    (0, _classCallCheck2.default)(this, XlrTileController);
    this.$scope = $scope;
    this.$location = $location;
    this.$stateParams = $stateParams;
    this.Ids = Ids;
    this.buttons = {};
    this.tile = $scope.tile;
    this.tileTypeDefinition = $scope.tileTypeDefinition;
    this.title = this.tile.title;
    this.variables = $scope.variables;
    this.detailsUrl = (0, _xlrTileUtil.tileOrDefaultUrl)(this.tile.detailsUri);
    this.templateUrl = (0, _xlrTileUtil.tileOrDefaultUrl)(this.tile.uri);
    this.hasDetailsMode = !!this.tile.detailsUri;
  }
  (0, _createClass2.default)(XlrTileController, [{
    key: "details",
    value: function details(viewName) {
      if (this.hasDetailsMode && this.$scope.dashboardMode !== 'design') {
        if (this.$scope.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.RELEASE) {
          var subPath = this.$scope.release.status === 'TEMPLATE' ? 'templates' : 'releases';
          var hyphenatedReleaseId = this.$scope.release.id;
          var domainReleaseId = this.Ids.toDomainId(hyphenatedReleaseId);
          this.$location.path("/".concat(subPath, "/").concat(this.tile.id.replace(domainReleaseId, hyphenatedReleaseId), "/details"));
        } else if (this.$scope.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.FOLDER) {
          this.$location.path("folders/".concat(this.$stateParams.folderId, "/dashboards/").concat(this.tile.id, "/details"));
          if (!!viewName) {
            this.$location.search('view', viewName);
          }
        } else {
          this.$location.path("dashboards/".concat(this.tile.id, "/details"));
          if (!!viewName) {
            this.$location.search('view', viewName);
          }
        }
      }
    }
  }, {
    key: "configure",
    value: function configure() {
      this.tile = angular.copy(this.$scope.tile);
      this.state = 'config';
      this.$scope.configure({
        item: this.tile
      });
    }
  }, {
    key: "view",
    value: function view() {
      this.state = 'view';
    }
  }, {
    key: "remove",
    value: function remove() {
      this.$scope.remove({
        item: this.tile
      });
      this.view();
    }
  }, {
    key: "addButton",
    value: function addButton(btn) {
      if (!_.includes(this.buttons, btn.title)) {
        this.buttons[btn.title] = btn;
      }
    }
  }, {
    key: "onBtnClick",
    value: function onBtnClick(btn) {
      btn.onClick();
    }
  }, {
    key: "isHomeTile",
    value: function isHomeTile() {
      return this.tileTypeDefinition.superTypes.includes('xlrelease.HomeTile');
    }
  }]);
  return XlrTileController;
}();
(0, _defineProperty2.default)(XlrTileController, "$inject", ['$scope', '$location', '$stateParams', 'Ids']);
var xlrTileInject = ['$timeout', 'Events', 'Window'];
var XlrTile = function XlrTile($timeout, Events, Window) {
  return {
    scope: {
      tile: '=',
      tileTypeDefinition: '=',
      release: '=',
      variables: '=',
      dashboardMode: '=',
      dashboardLevel: '=',
      remove: '&',
      configure: '&'
    },
    restrict: 'A',
    templateUrl: 'static/24.1.10/include/DashboardPage/xlr-tile.html',
    controller: 'xlrelease.dashboard.XlrTileController',
    controllerAs: 'xlrTile',
    require: ['xlrTile', '^xlrDashboard'],
    link: function link(scope, elem, attr, ctrls) {
      var vm = ctrls[0];
      scope.xlrDashboard = ctrls[1];
      vm.setTitle = function (transcludedContent) {
        elem.find('.tile-title span').replaceWith(transcludedContent);
      };
      function adjustTileDimensions(el) {
        // left here just for backwards compatibility
        var panelBody = el.find('.panel-body');
        vm.height = panelBody.innerHeight();
        vm.width = panelBody.width();
        scope.$broadcast(Events.tile.resized);
      }
      scope.$on('gridster-item-resized', function (event) {
        adjustTileDimensions(event.targetScope.gridsterItem.$element);
      });
      var resizeFn = $timeout.bind(null, adjustTileDimensions.bind(null, elem), 200);
      Window.onResize(resizeFn, scope);
      resizeFn();
    }
  };
};
XlrTile.$inject = xlrTileInject;
angular.module('xlrelease.dashboard').controller('xlrelease.dashboard.XlrTileController', XlrTileController).directive('xlrTile', XlrTile);

/***/ }),

/***/ 27391:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _react2angular = __webpack_require__(96563);
__webpack_require__(31492);
__webpack_require__(58863);
__webpack_require__(9121);
__webpack_require__(27347);
__webpack_require__(45336);
__webpack_require__(24346);
__webpack_require__(26092);
__webpack_require__(92765);
__webpack_require__(59821);
__webpack_require__(83868);
__webpack_require__(6798);
__webpack_require__(58371);
__webpack_require__(596);
__webpack_require__(93378);
__webpack_require__(78551);
__webpack_require__(86747);
__webpack_require__(69416);
__webpack_require__(91435);
__webpack_require__(17821);
__webpack_require__(46585);
__webpack_require__(29848);
__webpack_require__(94910);
__webpack_require__(51016);
__webpack_require__(53759);
__webpack_require__(99549);
__webpack_require__(23584);
__webpack_require__(84836);
__webpack_require__(93733);
__webpack_require__(15593);
var _globalDashboardList = __webpack_require__(6388);
var _addDashboardPagePortal = __webpack_require__(71953);
var _dashboardDetailsHeader = __webpack_require__(65692);
__webpack_require__(50898);
angular.module('xlrelease.dashboard').component('xlrListDashboard', (0, _react2angular.react2angular)(_globalDashboardList.GlobalDashboardList, ['filters'])).component('xlrAddDashboardPortal', (0, _react2angular.react2angular)(_addDashboardPagePortal.AddDashboardPagePortal, ['folderId'])).component('xlrDashboardDetailsHeader', (0, _react2angular.react2angular)(_dashboardDetailsHeader.DashboardDetailsHeader, ['dashboard', 'canCreateDashboard', 'canDeleteDashboard', 'canEditDashboard', 'editButtonProps', 'exportAsPdfButtonProps', 'isDesignMode', 'isFolderDashboard', 'isGlobalDashboard', 'onDelete', 'onDuplicate', 'refreshButtonProps', 'release']));

/***/ }),

/***/ 390:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.markdownTileConfig = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _markdownTileConfigTpl = _interopRequireDefault(__webpack_require__(17586));
var _constants = __webpack_require__(41166);
var MarkdownTileConfigController = /*#__PURE__*/function () {
  function MarkdownTileConfigController(uuid4) {
    (0, _classCallCheck2.default)(this, MarkdownTileConfigController);
    (0, _defineProperty2.default)(this, "SUPPORTED_ATTACHMENT_TYPES", 'image.*');
    (0, _defineProperty2.default)(this, "MAX_ATTACHMENT_ALLOWED_SIZE", 1000000);
    this.uuid4 = uuid4;
    this.supportAttachments = !!window.FileReader;
    this.onSaveCallback = this.beforeSave.bind(this);
  }
  (0, _createClass2.default)(MarkdownTileConfigController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;
      this.parent.registerSaveListener(this.onSaveCallback);
      this.content = this.tile.properties.content;
      if (this.supportAttachments) {
        var reader = new FileReader();
        this.dropdownZone = angular.element('#markdown-tile-dropdown');
        this.dropdownZone.on('dragenter', function (event) {
          _this.dropCallback(event, function (element) {
            element.addClass('hover-dropdown');
          });
        }).on('dragover', function (event) {
          _this.dropCallback(event, function (element) {
            element.addClass('hover-dropdown');
          });
        }).on('dragleave', function (event) {
          _this.dropCallback(event, function (element) {
            element.removeClass('hover-dropdown');
          });
        }).on('drop', function (event) {
          _this.dropCallback(event, function (element) {
            element.removeClass('hover-dropdown');
            reader.onload = _this.onFileReaderLoad(element);
            var file = event.originalEvent.dataTransfer.files[0]; // upload one picture at the time
            if (file.type.match(_this.SUPPORTED_ATTACHMENT_TYPES) && file.size < _this.MAX_ATTACHMENT_ALLOWED_SIZE) {
              reader.readAsDataURL(file);
            }
          });
        });
      }
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.parent.unregisterSaveListener(this.onSaveCallback);
    }
  }, {
    key: "beforeSave",
    value: function beforeSave(tile) {
      var _this2 = this;
      if (!_.isNull(this.content) && this.supportAttachments) {
        // remove unused attachments
        var usedUuids = [];
        var matchResult;
        while (matchResult = _constants.markdownImageRegex.exec(this.content)) {
          usedUuids.push(matchResult[2]);
        }
        _.chain(this.tile.properties.attachments.value).keys().difference(usedUuids).forEach(function (uuid) {
          delete _this2.tile.properties.attachments.value[uuid];
        });
      }
      this.tile.properties.content = this.content;
    }
  }, {
    key: "dropCallback",
    value: function dropCallback(event, callbackFunc) {
      event.preventDefault();
      event.stopPropagation();
      var element = angular.element(event.target);
      if (element.is('textarea')) {
        callbackFunc(element);
      }
    }
  }, {
    key: "onFileReaderLoad",
    value: function onFileReaderLoad(element) {
      var _this3 = this;
      return function (file) {
        var uuid4 = _this3.uuid4.generate();
        _this3.tile.properties.attachments.value[uuid4] = file.target.result;
        // add image at the cursor position
        var cursorPosition = element.prop('selectionStart');
        var value = element.val();
        var output = [value.slice(0, cursorPosition), "![](".concat(uuid4, ")"), value.slice(cursorPosition)].join('');
        element.val(output).trigger('change');
      };
    }
  }]);
  return MarkdownTileConfigController;
}();
// one megabyte, size is presented in bytes
(0, _defineProperty2.default)(MarkdownTileConfigController, "$inject", ['uuid4']);
var markdownTileConfig = exports.markdownTileConfig = {
  bindings: {
    tile: '<',
    parent: '<',
    variables: '<'
  },
  controller: MarkdownTileConfigController,
  template: _markdownTileConfigTpl.default
};

/***/ }),

/***/ 85409:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.markdownTileView = void 0;
var _markdownTileViewTpl = _interopRequireDefault(__webpack_require__(75316));
var markdownTileView = exports.markdownTileView = {
  bindings: {
    tile: '<',
    parent: '<',
    variables: '<'
  },
  template: _markdownTileViewTpl.default
};

/***/ }),

/***/ 41166:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.markdownImageRegex = void 0;
var markdownImageRegex = exports.markdownImageRegex = /\n?!\[([^\n\]]*)\](?:\(([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})\))?/gi;

/***/ }),

/***/ 93733:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


__webpack_require__(21705);
var _markdownTileViewComponent = __webpack_require__(85409);
var _markdownTileConfigComponent = __webpack_require__(390);
var _markdownAttachmentFilter = __webpack_require__(3614);
angular.module('xlrelease.dashboard').component('markdownTileConfig', _markdownTileConfigComponent.markdownTileConfig).component('markdownTileView', _markdownTileViewComponent.markdownTileView).filter('markdownAttachment', _markdownAttachmentFilter.markdownAttachmentFilter);

/***/ }),

/***/ 3614:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.markdownAttachmentFilter = void 0;
var _constants = __webpack_require__(41166);
var markdownAttachmentFilter = exports.markdownAttachmentFilter = function markdownAttachmentFilter() {
  return function (text, attachments) {
    if (_.isNull(text) || _.isUndefined(attachments)) return text;
    return text.replace(_constants.markdownImageRegex, function (match, alt, uuid) {
      if (_.has(attachments, uuid)) {
        return "![".concat(alt, "](").concat(attachments[uuid], ")");
      }
      return match;
    });
  };
};

/***/ }),

/***/ 28530:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.placeholderTileConfig = void 0;
var _placeholderTileConfigTpl = _interopRequireDefault(__webpack_require__(18741));
var placeholderTileConfig = exports.placeholderTileConfig = {
  bindings: {
    tile: '<',
    parent: '<'
  },
  template: _placeholderTileConfigTpl.default
};

/***/ }),

/***/ 47830:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.placeholderTileView = void 0;
var _placeholderTileViewTpl = _interopRequireDefault(__webpack_require__(70636));
var placeholderTileView = exports.placeholderTileView = {
  bindings: {
    tile: '<',
    parent: '<'
  },
  template: _placeholderTileViewTpl.default
};

/***/ }),

/***/ 15593:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


__webpack_require__(86748);
var _placeholderTileConfigComponent = __webpack_require__(28530);
var _placeholderTileViewComponent = __webpack_require__(47830);
angular.module('xlrelease.dashboard').component('placeholderTileConfig', _placeholderTileConfigComponent.placeholderTileConfig).component('placeholderTileView', _placeholderTileViewComponent.placeholderTileView);

/***/ }),

/***/ 62826:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FolderValidationModalComponent = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _dotComponents = __webpack_require__(92140);
var _filter = _interopRequireDefault(__webpack_require__(63105));
var _folderVersioning = __webpack_require__(50727);
var _folderVersioning2 = __webpack_require__(55170);
var _versionModal = __webpack_require__(75538);
__webpack_require__(29390);
var _folderVersioning3 = __webpack_require__(16705);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var FolderValidationModalComponent = exports.FolderValidationModalComponent = function FolderValidationModalComponent() {
  var dispatch = (0, _reactRedux.useDispatch)();
  var modalIsOpen = (0, _reactRedux.useSelector)(_folderVersioning.getFolderValidationModalState);
  var validation = (0, _reactRedux.useSelector)(_folderVersioning.getFolderValidationDetails);
  var validationTab = (0, _reactRedux.useSelector)(_folderVersioning.getFolderValidationTab);
  var configuration = (0, _reactRedux.useSelector)(_folderVersioning.getConfiguration);
  var _useState = (0, _react.useState)(new Map()),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    messageIdStatus = _useState2[0],
    setMessageIdStatus = _useState2[1];
  var addMessageIdStatus = function addMessageIdStatus(messageId, status) {
    messageIdStatus.set(messageId, status);
  };
  var updateMessageIdStatus = function updateMessageIdStatus(messageId, status) {
    setMessageIdStatus(new Map(messageIdStatus.set(messageId, status)));
  };
  var closeModal = function closeModal() {
    dispatch((0, _folderVersioning2.closeFolderValidationModal)());
  };
  var filterWarningsUpdateData = function filterWarningsUpdateData() {
    var currentMessageType = validationTab;
    var filteredValidationWarnings = (0, _filter.default)(validation.warnings, function (warning) {
      return warning.messageType === currentMessageType;
    });
    var toUpdateTableData = [];
    filteredValidationWarnings.forEach(function (warning) {
      addMessageIdStatus(warning.messageId, warning.resolvedStatus);
      var link = (0, _versionModal.getCiReferenceLink)(warning);
      var title = (0, _versionModal.getWarningTitle)(warning);
      var toUpdateWarningData = {
        id: warning.messageId,
        rowData: {
          ciType: warning.ciTypeDisplayName,
          title: /*#__PURE__*/_react.default.createElement(_dotComponents.DotLink, {
            href: link,
            target: "_self",
            tooltip: link
          }, title),
          property: warning.property,
          resolved: /*#__PURE__*/_react.default.createElement(_dotComponents.DotCheckbox, {
            ariaLabel: "Warning resolved status",
            checked: messageIdStatus.get(warning.messageId),
            label: "Done",
            name: "dot-checkbox",
            onChange: function updateResolvedStatus() {
              warning.resolvedStatus = !warning.resolvedStatus;
              updateMessageIdStatus(warning.messageId, warning.resolvedStatus);
              dispatch((0, _folderVersioning2.updateValidationMessageStatus)(warning));
            },
            value: "resolved-status"
          })
        }
      };
      (0, _versionModal.checkMessageTypeAndUpdateTableData)(toUpdateTableData, warning, currentMessageType, toUpdateWarningData);
    });
    return toUpdateTableData;
  };
  var onTabChange = function onTabChange(value) {
    dispatch((0, _folderVersioning2.changeFolderValidationTab)(value));
  };
  function hasWarnings() {
    return validation.hasOwnProperty('warnings') && validation.warnings.length > 0;
  }
  return /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotDrawer, {
    PaperProps: {
      style: {
        position: 'absolute'
      }
    },
    anchor: "bottom",
    className: "folder-validation-modal",
    height: "100%",
    onClose: closeModal,
    open: modalIsOpen,
    variant: "persistent"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotActionToolbar, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "top-toolbar-icons"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
    color: "default",
    iconId: "help",
    iconSize: "small",
    onClick: closeModal,
    size: "medium",
    tooltip: "Documentation"
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
    color: "default",
    iconId: "close",
    iconSize: "small",
    onClick: closeModal,
    size: "medium",
    tooltip: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_dotComponents.DotAlertBanner, {
    action: "",
    severity: "warning"
  }, "Version ", configuration.appliedVersion, " could not be applied completely. The contents of the folder may not function correctly. Please check the list of warnings below and fix them."), /*#__PURE__*/_react.default.createElement("div", {
    className: "drawer-body"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "divider"
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotTabs, {
    initialValue: validationTab,
    onChange: onTabChange,
    tabs: (0, _versionModal.tabs)(false)
  }), hasWarnings() && /*#__PURE__*/_react.default.createElement("div", {
    className: "tab-content"
  }, validationTab === _folderVersioning3.validationMessageTypes.missingPassword && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "validation-warning-wrapper"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
    className: "validation-warning-icon",
    fontSize: "medium",
    iconId: "warning-solid"
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "validation-warning-description"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "body1"
  }, "The applied version contains missing passwords. You will need to manually correct invalid passwords."))), /*#__PURE__*/_react.default.createElement(_dotComponents.DotTable, {
    columns: (0, _versionModal.passwordsColumns)(true),
    data: filterWarningsUpdateData(),
    maxHeight: "100%",
    onUpdateData: function onUpdateData() {
      return filterWarningsUpdateData();
    },
    order: "asc"
  })), validationTab === _folderVersioning3.validationMessageTypes.nonVersionedReference && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "validation-warning-wrapper"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
    className: "validation-warning-icon",
    fontSize: "medium",
    iconId: "warning-solid"
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "validation-warning-description"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    variant: "body1"
  }, "Message for References outside this folder"))), /*#__PURE__*/_react.default.createElement(_dotComponents.DotTable, {
    columns: (0, _versionModal.externalRefsColumns)(true),
    data: filterWarningsUpdateData(),
    maxHeight: "100%",
    onUpdateData: function onUpdateData() {
      return filterWarningsUpdateData();
    },
    order: "asc"
  })))), /*#__PURE__*/_react.default.createElement("div", {
    className: "drawer-footer"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    onClick: closeModal,
    tooltip: "Close",
    type: "primary"
  }, "Close"))));
};

/***/ }),

/***/ 47934:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FolderVersioningConfigurationComponent = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _classnames = _interopRequireDefault(__webpack_require__(94184));
var _camelCase = _interopRequireDefault(__webpack_require__(68929));
var _includes = _interopRequireDefault(__webpack_require__(64721));
var _sortBy = _interopRequireDefault(__webpack_require__(89734));
var _values = _interopRequireDefault(__webpack_require__(52628));
var _isEmpty = _interopRequireDefault(__webpack_require__(41609));
var _isUndefined = _interopRequireDefault(__webpack_require__(52353));
var _xlReactComponents = __webpack_require__(67082);
var _dotComponents = __webpack_require__(92140);
var _dotIconWrapper = __webpack_require__(23287);
var _folderVersioning = __webpack_require__(16705);
var _folderVersioning2 = __webpack_require__(55170);
var _folderVersioning3 = __webpack_require__(50727);
var _validators = __webpack_require__(32203);
var _components = __webpack_require__(78605);
var _actionToolbar = __webpack_require__(29755);
__webpack_require__(47104);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var FolderVersioningConfigurationComponent = exports.FolderVersioningConfigurationComponent = function FolderVersioningConfigurationComponent(_ref) {
  var folder = _ref.folder,
    onViewChange = _ref.onViewChange;
  var dispatch = (0, _reactRedux.useDispatch)();
  var loading = (0, _reactRedux.useSelector)(_folderVersioning3.getFormProcessingState);
  var form = (0, _reactRedux.useSelector)(_folderVersioning3.getVersioningConfigurationForm);
  var gitConnections = (0, _reactRedux.useSelector)(_folderVersioning3.getGitConnections);
  var isVersionsAvailable = (0, _reactRedux.useSelector)(_folderVersioning3.hasVersions);
  var canEditConfiguration = (0, _reactRedux.useSelector)(_folderVersioning3.hasConfEditPermission);
  var scmPathChangeWarning = (0, _reactRedux.useSelector)(_folderVersioning3.scmPathModificationWarning);
  var versioningStyles = (0, _reactRedux.useSelector)(_folderVersioning3.getVersioningStyles);
  var _React$useState = _react.default.useState(false),
    _React$useState2 = (0, _slicedToArray2.default)(_React$useState, 2),
    scmPathChanged = _React$useState2[0],
    setScmPathChanged = _React$useState2[1];
  (0, _react.useEffect)(function () {
    dispatch((0, _folderVersioning2.initVersioningConfigurationForm)(folder));
  }, []);
  var _onModelChange = function onModelChange(fieldName, value) {
    dispatch((0, _folderVersioning2.updateConfigurationForm)(['field', "".concat(fieldName), 'value'], value));
  };
  var onScmModelChange = function onScmModelChange(fieldName, value) {
    dispatch((0, _folderVersioning2.updateConfigurationForm)(['field', "".concat(fieldName), 'value'], value));
  };
  var onExportModelChange = function onExportModelChange(fieldName, value) {
    dispatch((0, _folderVersioning2.updateConfigurationForm)(['field', "exports", fieldName, "value"], value));
    onPristinityChange(false);
  };
  var _onValidityChange = function onValidityChange(fieldName, valid) {
    dispatch((0, _folderVersioning2.updateConfigurationForm)(['field', "".concat(fieldName), 'valid'], valid));
  };
  var onScmPristineChange = function onScmPristineChange(pristine) {
    onPristinityChange(pristine);
    if (!pristine) setScmPathChanged(true);
  };
  var onVersioningStyleChange = function onVersioningStyleChange(fieldName, value) {
    var versioningStyleEntry = versioningStyles.filter(function (style) {
      return style.title === value;
    });
    var versionType = (0, _isEmpty.default)(versioningStyleEntry) ? versioningStyles[0].id : versioningStyleEntry[0].id;
    dispatch((0, _folderVersioning2.updateConfigurationForm)(['field', "".concat(fieldName), 'value'], versionType));
  };
  var onPristinityChange = function onPristinityChange(pristine) {
    if (!pristine) {
      dispatch((0, _folderVersioning2.addConfirmLeavePopup)());
      dispatch((0, _folderVersioning2.updateConfigurationForm)(['pristine'], pristine));
    }
  };
  var closeConfigurationView = function closeConfigurationView() {
    dispatch((0, _folderVersioning2.removeConfirmLeavePopup)());
    onViewChange(_folderVersioning.viewMode.view);
  };
  var renderHeaderActions = function renderHeaderActions() {
    return /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, {
      helpLink: "how-to/using-gitops-version-control.html"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
      onClick: closeConfigurationView,
      type: "text"
    }, "Cancel"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
      disabled: !form.valid || form.pristine && !form.field.gitConnection.valid,
      onClick: function onClick() {
        return dispatch((0, _folderVersioning2.saveConfiguration)(closeConfigurationView));
      }
    }, "Save"));
  };
  var renderExportRow = function renderExportRow(_ref2) {
    var name = _ref2.name,
      icon = _ref2.icon,
      label = _ref2.label,
      description = _ref2.description,
      value = _ref2.value;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "export-row",
      key: (0, _camelCase.default)(label)
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "export-icon-wrapper"
    }, /*#__PURE__*/_react.default.createElement(_dotIconWrapper.DotIconWrapper, {
      iconId: icon
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "export-label-wrapper"
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "export-label"
    }, label), /*#__PURE__*/_react.default.createElement("span", {
      className: "export-description"
    }, description)), /*#__PURE__*/_react.default.createElement("div", {
      className: "export-switch"
    }, /*#__PURE__*/_react.default.createElement(_components.ToggleComponent, {
      checked: value,
      onChange: function onChange(value) {
        return onExportModelChange(name, value);
      }
    })));
  };
  var autocompleteHandler = function autocompleteHandler(_ref3) {
    var metadata = _ref3.metadata,
      objLabel = _ref3.objLabel,
      suggestedElements = _ref3.suggestedElements,
      value = _ref3.value;
    return Promise.resolve((0, _sortBy.default)(gitConnections.filter(function (c) {
      return (0, _includes.default)(c.title.toLowerCase(), value.toLowerCase());
    }), ['title']));
  };
  var autocompleteHandlers = {
    addCandidates: autocompleteHandler
  };
  var versioningStyleAutocompleteHandlers = {
    addCandidates: function addCandidates() {
      return Promise.resolve(versioningStyles);
    }
  };
  var checkFileType = function checkFileType(value) {
    if ((0, _isUndefined.default)(value) || (0, _isEmpty.default)(value)) {
      return versioningStyles[0];
    } else {
      return versioningStyles.filter(function (style) {
        return style.id === value;
      })[0].title;
    }
  };
  return !loading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderHeaderActions(), /*#__PURE__*/_react.default.createElement("div", {
    className: "col-sm-12",
    id: "versioning-configuration"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "col-sm-12 page-name"
  }, /*#__PURE__*/_react.default.createElement("h4", null, "Version control settings")), /*#__PURE__*/_react.default.createElement("div", {
    className: "col-sm-4 versioning-configuration-sidebar"
  }, /*#__PURE__*/_react.default.createElement("h4", null, "Connect folder to Git"), /*#__PURE__*/_react.default.createElement("p", null, "Folder content will be synchronized in YAML format to the selected Git repository and branch"), /*#__PURE__*/_react.default.createElement("div", {
    className: "fv-connection-form"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "git-icon-wrapper mbm"
  }, /*#__PURE__*/_react.default.createElement("img", {
    alt: "Git Icon",
    src: "static/24.1.10/include/folder-versioning/assets/git-icon.svg"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "mll"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "title"
  }, "Git repository"), /*#__PURE__*/_react.default.createElement("span", {
    className: "description"
  }, "Choose the Git repository to synchronize with"))), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
    className: (0, _classnames.default)({
      mbn: canEditConfiguration
    }),
    handlers: autocompleteHandlers,
    metadata: form.field.gitConnection,
    model: form.field.gitConnection.value,
    objLabel: 'title',
    onModelChange: function onModelChange(value) {
      return _onModelChange(form.field.gitConnection.name, value);
    },
    onPristinityChange: onPristinityChange,
    onValidityChange: function onValidityChange(valid) {
      return _onValidityChange(form.field.gitConnection.name, valid);
    },
    validators: [(0, _validators.requiredSelectValueValidator)('id')]
  }), canEditConfiguration && /*#__PURE__*/_react.default.createElement("div", {
    className: "no-configuration"
  }, "No Git repository?", /*#__PURE__*/_react.default.createElement("button", {
    className: "button underlined pull-right",
    onClick: function onClick() {
      return dispatch((0, _folderVersioning2.goToConfiguration)());
    },
    type: "button"
  }, "New repository")), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetString, {
    disabled: false,
    metadata: form.field.branch,
    model: form.field.branch.value,
    onModelChange: function onModelChange(value) {
      return _onModelChange(form.field.branch.name, value);
    },
    onPristinityChange: onPristinityChange,
    onValidityChange: function onValidityChange(valid) {
      return _onValidityChange(form.field.branch.name, valid);
    },
    validators: [(0, _validators.gitRefnameValidator)('refs/heads', 'Branch name is of incorrect format'), (0, _validators.maxLengthValidator)(form.field.branch.label, 255)]
  }), /*#__PURE__*/_react.default.createElement("legend", null, "Advanced"), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetString, {
    disabled: false,
    metadata: form.field.scmPath,
    model: form.field.scmPath.value,
    onModelChange: function onModelChange(value) {
      return onScmModelChange(form.field.scmPath.name, value);
    },
    onPristinityChange: onScmPristineChange,
    onValidityChange: function onValidityChange(valid) {
      return _onValidityChange(form.field.scmPath.name, valid);
    },
    validators: [(0, _validators.gitRefnameValidator)('refs/heads', 'Repository Path is of incorrect format'), (0, _validators.maxLengthValidator)(form.field.scmPath.label, 255)]
  }), isVersionsAvailable && scmPathChanged && /*#__PURE__*/_react.default.createElement("div", {
    className: "warning-message",
    style: {
      paddingTop: '5px'
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "error",
    style: {
      height: '16px',
      fontFamily: "Lato, 'Helvetica Neue', Helvetica, Arial, sans-serif",
      fontSize: '11px',
      fontWeight: 'normal',
      fontStyle: 'normal',
      fontStretch: 'normal',
      lineHeight: 1.45,
      letterSpacing: 'normal'
    }
  }, scmPathChangeWarning)), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
    className: (0, _classnames.default)({
      mbn: canEditConfiguration
    }),
    disableSorting: true,
    handlers: versioningStyleAutocompleteHandlers,
    metadata: form.field.versioningStyle,
    model: checkFileType(form.field.versioningStyle.value),
    objLabel: 'title',
    onModelChange: function onModelChange(value) {
      return onVersioningStyleChange(form.field.versioningStyle.name, value);
    },
    onPristinityChange: onPristinityChange,
    onValidityChange: function onValidityChange(valid) {
      return _onValidityChange(form.field.versioningStyle.name, valid);
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "col-sm-8 versioning-configuration-content"
  }, /*#__PURE__*/_react.default.createElement("h4", null, "Select the entities to export"), /*#__PURE__*/_react.default.createElement("p", null, "The selected entities in this folder will be exported to the Git repository in YAML format"), (0, _values.default)(form.field.exports).map(function (field) {
    return renderExportRow(field);
  }))));
};
FolderVersioningConfigurationComponent.propTypes = {
  folder: _propTypes.default.object.isRequired,
  onViewChange: _propTypes.default.func.isRequired
};

/***/ }),

/***/ 93217:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FolderVersioningListComponent = void 0;
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _classnames = _interopRequireDefault(__webpack_require__(94184));
var _dotComponents = __webpack_require__(92140);
var _folderVersioning = __webpack_require__(16705);
var _folderVersioning2 = __webpack_require__(55170);
var _folderVersioning3 = __webpack_require__(50727);
var _versionList = __webpack_require__(4274);
var _utils = __webpack_require__(90848);
var _actionToolbar = __webpack_require__(29755);
__webpack_require__(30546);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var FolderVersioningListComponent = exports.FolderVersioningListComponent = function FolderVersioningListComponent(_ref) {
  var folder = _ref.folder,
    canEdit = _ref.canEdit,
    canApply = _ref.canApply,
    canCreate = _ref.canCreate,
    onViewChange = _ref.onViewChange;
  var dispatch = (0, _reactRedux.useDispatch)();
  var listLoading = (0, _reactRedux.useSelector)(_folderVersioning3.getListLoadingState);
  var loadingVersions = (0, _reactRedux.useSelector)(_folderVersioning3.getLoadingVersionState);
  var configuration = (0, _reactRedux.useSelector)(_folderVersioning3.getConfiguration);
  var dateTimeFormat = (0, _reactRedux.useSelector)(_folderVersioning3.getDateTimeFormat);
  (0, _react.useEffect)(function () {
    dispatch((0, _folderVersioning2.initVersioningList)(folder));
    return function () {
      return dispatch((0, _folderVersioning2.cleanupVersioningList)());
    };
  }, []);
  var onOpenConfiguration = function onOpenConfiguration() {
    return onViewChange(_folderVersioning.viewMode.edit);
  };
  var renderHeaderActions = function renderHeaderActions() {
    if (configuration) {
      return /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, {
        helpLink: "how-to/using-gitops-version-control.html"
      }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
        disabled: loadingVersions,
        onClick: function onClick() {
          return dispatch((0, _folderVersioning2.loadVersions)(true));
        },
        startIcon: /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
          iconId: "sync"
        }),
        tooltip: !!configuration.lastFetched && !loadingVersions ? "Last refresh: ".concat((0, _utils.formatDateTime)(configuration.lastFetched, dateTimeFormat.date, dateTimeFormat.time)) : undefined,
        type: "outlined"
      }, "Fetch changes"), canEdit && /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
        id: "configure-btn",
        onClick: onOpenConfiguration
      }, "Configure"));
    } else {
      return /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, {
        helpLink: "how-to/using-gitops-version-control.html"
      });
    }
  };
  var renderInfoBlock = function renderInfoBlock() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "notice-placeholder"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "notice"
    }, /*#__PURE__*/_react.default.createElement("img", {
      alt: "Folder version control",
      className: (0, _classnames.default)({
        'not-configured': !canEdit
      }),
      src: "static/24.1.10/include/folder-versioning/assets/git-folder.svg",
      width: "300"
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "notice-title mtl"
    }, canEdit ? 'Version control' : 'Version control not configured'), /*#__PURE__*/_react.default.createElement("div", {
      className: "notice-description"
    }, "GitOps-enabled version control allows you to store folder content like templates, variables, and connections as YAML in Git.", /*#__PURE__*/_react.default.createElement("br", null), canEdit && /*#__PURE__*/_react.default.createElement("a", {
      className: "button primary mtl",
      onClick: onOpenConfiguration
    }, "Configure"))));
  };
  return !listLoading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderHeaderActions(), /*#__PURE__*/_react.default.createElement("div", {
    className: "content",
    id: "folder-versioning-list"
  }, configuration ? /*#__PURE__*/_react.default.createElement("div", {
    className: "content-inner"
  }, /*#__PURE__*/_react.default.createElement(_versionList.VersionListComponent, {
    canApply: canApply,
    canCreate: canCreate
  })) : renderInfoBlock()));
};
FolderVersioningListComponent.propTypes = {
  canApply: _propTypes.default.bool.isRequired,
  canCreate: _propTypes.default.bool.isRequired,
  canEdit: _propTypes.default.bool.isRequired,
  folder: _propTypes.default.object.isRequired,
  onViewChange: _propTypes.default.func.isRequired
};

/***/ }),

/***/ 3517:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.VersionFormComponent = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireDefault(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _set = _interopRequireDefault(__webpack_require__(36968));
var _dotComponents = __webpack_require__(92140);
var _validators = __webpack_require__(32203);
__webpack_require__(54212);
var _reactRedux = __webpack_require__(37703);
var _folderVersioning = __webpack_require__(50727);
var _folderVersioning2 = __webpack_require__(55170);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var VersionFormComponent = exports.VersionFormComponent = function VersionFormComponent(_ref) {
  var form = _ref.form,
    loading = _ref.loading,
    onUpdate = _ref.onUpdate,
    viewWarningsButton = _ref.viewWarningsButton;
  var dispatch = (0, _reactRedux.useDispatch)();
  var displayVersionError = (0, _reactRedux.useSelector)(_folderVersioning.getDisplayVersionError);
  var displayDescError = (0, _reactRedux.useSelector)(_folderVersioning.getDescriptionVersionError);
  var setFormPropertyValue = function setFormPropertyValue(fieldName, property, value) {
    var formModel = Object.assign({}, form);
    return (0, _set.default)(_objectSpread({}, formModel), ['field', "".concat(fieldName), "".concat(property)], value);
  };
  var closeModal = function closeModal() {
    dispatch((0, _folderVersioning2.closeNewVersionModal)());
  };
  var showWarnings = function showWarnings() {
    dispatch((0, _folderVersioning2.closeVersionFormState)());
  };
  var saveVersion = function saveVersion() {
    dispatch((0, _folderVersioning2.createVersion)());
  };
  var onVersionModelChange = function onVersionModelChange(fieldName, fieldLabel, event) {
    dispatch((0, _folderVersioning2.resetInitialVersionHelperState)());
    var formModel = setFormPropertyValue(fieldName, 'value', event.currentTarget.value);
    onUpdate(formModel);
    var validator = (0, _validators.gitRefnameValidator)('refs/tags', 'Version name is of incorrect format')(event.currentTarget.value).condition || (0, _validators.maxLengthValidator)(fieldLabel, 255)(event.currentTarget.value).condition;
    if (validator) {
      dispatch((0, _folderVersioning2.displayVersionFormatInvalid)());
    }
  };
  var onDescriptionModelChange = function onDescriptionModelChange(fieldName, fieldLabel, event) {
    dispatch((0, _folderVersioning2.resetInitialDescriptionHelperState)());
    var formModel = setFormPropertyValue(fieldName, 'value', event.currentTarget.value);
    onUpdate(formModel);
    var validator = (0, _validators.maxLengthValidator)(fieldLabel, 1024)(event.currentTarget.value).condition;
    if (validator) {
      dispatch((0, _folderVersioning2.descriptionInvalidDisplayModal)());
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "folder-versioning-form"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotForm, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
    className: "mbm",
    variant: "h1"
  }, "Save new version history"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotInputText, {
    disabled: loading,
    error: displayVersionError,
    fullWidth: true,
    helperText: displayVersionError ? 'Version name is of incorrect format' : '*Required',
    id: "version-name",
    label: form.field.name.label,
    name: form.field.name.name,
    onChange: function onChange(event) {
      return onVersionModelChange(form.field.name.name, form.field.name.label, event);
    },
    required: true,
    value: form.field.name.value
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotInputText, {
    disabled: loading,
    error: displayDescError,
    fullWidth: true,
    helperText: displayDescError ? 'Exceeds more than 1024 characters' : 'Your commit description',
    id: "version-description",
    label: form.field.description.label,
    maxRows: 6,
    minRows: 6,
    multiline: true,
    name: form.field.description.name,
    onChange: function onChange(event) {
      return onDescriptionModelChange(form.field.description.name, form.field.description.label, event);
    },
    value: form.field.description.value
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "drawer-footer-form"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    disabled: loading,
    onClick: closeModal,
    tooltip: "Cancel",
    type: "text"
  }, "Cancel"), viewWarningsButton && /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    disabled: loading,
    onClick: showWarnings,
    tooltip: "View warnings",
    type: "text"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
    className: "password-warning-icon",
    fontSize: "medium",
    iconId: "warning-solid"
  }), " View warnings"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    disabled: form.field.name.value === '' || loading,
    onClick: saveVersion,
    tooltip: "Save the version",
    type: "primary"
  }, "Save"))), loading && /*#__PURE__*/_react.default.createElement("div", {
    className: "spinner"
  }, /*#__PURE__*/_react.default.createElement("img", {
    alt: "Loading...",
    src: "static/24.1.10/styles/img/big-ajax-loader.gif"
  })));
};
VersionFormComponent.propTypes = {
  form: _propTypes.default.object,
  loading: _propTypes.default.bool,
  onUpdate: _propTypes.default.func,
  viewWarningsButton: _propTypes.default.bool
};

/***/ }),

/***/ 7337:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.VersionListItem = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _classnames = _interopRequireDefault(__webpack_require__(94184));
var _moment = _interopRequireDefault(__webpack_require__(72897));
var _dotComponents = __webpack_require__(92140);
var _components = __webpack_require__(78605);
var _utils = __webpack_require__(90848);
__webpack_require__(68665);
var defaultDateTimeFormat = {
  date: 'MMM d, y',
  time: 'h:mm:ss a'
};
var VersionListItem = exports.VersionListItem = function VersionListItem(_ref) {
  var name = _ref.name,
    shortMessage = _ref.shortMessage,
    commitTime = _ref.commitTime,
    author = _ref.author,
    _ref$isApplied = _ref.isApplied,
    isApplied = _ref$isApplied === void 0 ? false : _ref$isApplied,
    onSelect = _ref.onSelect,
    isSelected = _ref.isSelected,
    _ref$dateTimeFormat = _ref.dateTimeFormat,
    dateTimeFormat = _ref$dateTimeFormat === void 0 ? defaultDateTimeFormat : _ref$dateTimeFormat,
    onShowWarnings = _ref.onShowWarnings,
    hasValidationWarnings = _ref.hasValidationWarnings;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('version-item', {
      selected: isSelected
    }),
    onClick: onSelect
  }, /*#__PURE__*/_react.default.createElement(_components.AvatarComponent, {
    text: author,
    title: author
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "metadata"
  }, /*#__PURE__*/_react.default.createElement("p", {
    className: "name"
  }, /*#__PURE__*/_react.default.createElement("span", null, name), " ", isApplied && /*#__PURE__*/_react.default.createElement("span", {
    className: "label label-completed pull-right"
  }, "Applied")), /*#__PURE__*/_react.default.createElement("p", {
    className: "message"
  }, shortMessage), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("span", {
    className: "text-sm"
  }, "created by"), " ", author), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("span", {
    className: "text-sm",
    title: (0, _utils.formatDateTime)(commitTime, dateTimeFormat.date, dateTimeFormat.time)
  }, (0, _moment.default)(commitTime).fromNow()), isApplied && hasValidationWarnings && /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
    className: "pull-right",
    onClick: onShowWarnings,
    type: "text"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
    className: "password-warning-icon",
    fontSize: "medium",
    iconId: "warning-solid",
    tooltip: "show warnings"
  }))))));
};
VersionListItem.propTypes = {
  author: _propTypes.default.string.isRequired,
  commitTime: _propTypes.default.number.isRequired,
  commiter: _propTypes.default.string,
  dateTimeFormat: _propTypes.default.shape({
    date: _propTypes.default.string,
    time: _propTypes.default.string
  }),
  fullMessage: _propTypes.default.string,
  hasValidationWarnings: _propTypes.default.bool,
  isApplied: _propTypes.default.bool,
  isSelected: _propTypes.default.bool,
  name: _propTypes.default.string.isRequired,
  onSelect: _propTypes.default.func.isRequired,
  onShowWarnings: _propTypes.default.func.isRequired,
  shortMessage: _propTypes.default.string.isRequired
};

/***/ }),

/***/ 4274:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.VersionListComponent = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(67154));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(63038));
var _react = _interopRequireDefault(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _reactContentLoader = _interopRequireDefault(__webpack_require__(24561));
var _classnames = _interopRequireDefault(__webpack_require__(94184));
var _isEmpty = _interopRequireDefault(__webpack_require__(41609));
var _isEqual = _interopRequireDefault(__webpack_require__(18446));
var _isUndefined = _interopRequireDefault(__webpack_require__(52353));
var _includes = _interopRequireDefault(__webpack_require__(64721));
var _reactAce = _interopRequireDefault(__webpack_require__(74981));
__webpack_require__(12477);
__webpack_require__(42557);
var _xlReactComponents = __webpack_require__(67082);
var _dotComponents = __webpack_require__(92140);
var _folderVersioning = __webpack_require__(50727);
var _folderVersioning2 = __webpack_require__(55170);
var _utils = __webpack_require__(90848);
var _versionModal = __webpack_require__(75538);
var _folderValidationModal = __webpack_require__(62826);
var _versionListItem = __webpack_require__(7337);
__webpack_require__(80928);
var VersionListComponent = exports.VersionListComponent = function VersionListComponent(_ref) {
  var _ref$canApply = _ref.canApply,
    canApply = _ref$canApply === void 0 ? false : _ref$canApply,
    _ref$canCreate = _ref.canCreate,
    canCreate = _ref$canCreate === void 0 ? false : _ref$canCreate;
  var dispatch = (0, _reactRedux.useDispatch)();
  var dateTimeFormat = (0, _reactRedux.useSelector)(_folderVersioning.getDateTimeFormat);
  var versions = (0, _reactRedux.useSelector)(_folderVersioning.getVersions);
  var loading = (0, _reactRedux.useSelector)(_folderVersioning.getLoadingVersionState);
  var configuration = (0, _reactRedux.useSelector)(_folderVersioning.getConfiguration);
  var showCodePreview = (0, _reactRedux.useSelector)(_folderVersioning.getCodePreviewState);
  var code = (0, _reactRedux.useSelector)(_folderVersioning.getCode);
  var hasValidationWarnings = (0, _reactRedux.useSelector)(_folderVersioning.getHasValidationWarnings);
  var versionedFiles = (0, _reactRedux.useSelector)(_folderVersioning.getVersionedFileNames);
  var selectedFilename = (0, _reactRedux.useSelector)(_folderVersioning.getSelectedFilename);
  var _React$useState = _react.default.useState({}),
    _React$useState2 = (0, _slicedToArray2.default)(_React$useState, 2),
    selectedVersion = _React$useState2[0],
    setSelectedVersion = _React$useState2[1];
  var _React$useState3 = _react.default.useState(false),
    _React$useState4 = (0, _slicedToArray2.default)(_React$useState3, 2),
    isApplyModalOpen = _React$useState4[0],
    setIsApplyModalOpen = _React$useState4[1];
  var makeNewVersion = function makeNewVersion() {
    return dispatch((0, _folderVersioning2.validateCurrentFolderState)());
  };
  var onApplyVersion = function onApplyVersion() {
    setIsApplyModalOpen(true);
  };
  var confirmApply = function confirmApply() {
    dispatch((0, _folderVersioning2.applyVersion)(selectedVersion.name));
    closeApplyModal();
  };
  var closeApplyModal = function closeApplyModal() {
    setIsApplyModalOpen(false);
  };
  var isLastAppliedVersion = function isLastAppliedVersion(version) {
    return version.name === configuration.appliedVersion;
  };
  var selectVersion = function selectVersion(version) {
    if (!(0, _isEqual.default)(version, selectedVersion)) {
      dispatch((0, _folderVersioning2.closeCodePreview)());
      setSelectedVersion(version);
    }
  };
  var showWarnings = function showWarnings() {
    dispatch((0, _folderVersioning2.validateAppliedFolderState)());
  };
  var renderSelectedPreviewCode = function renderSelectedPreviewCode() {
    dispatch((0, _folderVersioning2.loadCode)(selectedVersion.name));
  };
  var renderNoCode = function renderNoCode() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _isEmpty.default)(selectedVersion) ? /*#__PURE__*/_react.default.createElement("div", {
      className: "preview pbxl"
    }, /*#__PURE__*/_react.default.createElement("img", {
      alt: "Preview Image",
      height: "207",
      src: "static/24.1.10/include/folder-versioning/assets/preview.svg",
      width: "300"
    }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("button", {
      className: "button mtl mbxl",
      onClick: function onClick() {
        return dispatch((0, _folderVersioning2.loadCode)(selectedVersion.name));
      }
    }, "Preview YAML"))) : renderSelectedPreviewCode());
  };
  var versionedFilesMetadata = {
    label: '',
    placeholder: 'Select file...'
  };
  var versionFileNameChange = function versionFileNameChange(suggestion) {
    dispatch((0, _folderVersioning2.loadFile)(selectedVersion.name, suggestion.value));
  };
  var _onModelChange = function onModelChange(value, initialChange) {
    if (initialChange) {
      dispatch((0, _folderVersioning2.loadFile)(selectedVersion.name, value));
    }
  };
  var autocompleteHandlers = {
    addCandidates: function addCandidates(value) {
      var options = [];
      versionedFiles.forEach(function (item) {
        options.push({
          option: item,
          value: item
        });
      });
      var finalOptions = (0, _isEmpty.default)(value.value) ? options : options.filter(function (c) {
        return (0, _includes.default)(c.value.toLowerCase(), value.value.toLowerCase());
      });
      return Promise.resolve(finalOptions);
    }
  };
  var renderCodePreview = function renderCodePreview() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
      handlers: autocompleteHandlers,
      metadata: versionedFilesMetadata,
      model: selectedFilename,
      objLabel: 'option',
      onModelChange: function onModelChange(value, initialChange) {
        return _onModelChange(value, initialChange);
      },
      onSuggestionSelected: function onSuggestionSelected(suggestion) {
        return versionFileNameChange(suggestion);
      },
      disableSorting: true
    }), /*#__PURE__*/_react.default.createElement("h6", null, selectedVersion.name || 'Current state'), (0, _isUndefined.default)(code) ? /*#__PURE__*/_react.default.createElement("p", null, "No content") : /*#__PURE__*/_react.default.createElement(_reactAce.default, {
      defaultValue: code,
      fontSize: 10,
      height: "100%",
      mode: "yaml",
      name: "yaml-ace-editor",
      setOptions: {
        tabSize: 2,
        readOnly: true,
        useWorker: false
      },
      theme: "tomorrow",
      value: code,
      width: "100%"
    }));
  };
  var renderHeader = function renderHeader() {
    var applySelectedVersion = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("button", {
      className: "button pull-right",
      id: "apply-version",
      onClick: onApplyVersion
    }, /*#__PURE__*/_react.default.createElement("i", {
      className: "xl-icon restore-icon"
    }), "Apply this version"));
    var createVersion = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("button", {
      className: "button primary pull-right",
      id: "save-version",
      onClick: makeNewVersion,
      title: "Make a new version from topmost revision"
    }, "Save as a new version"));
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "version-list-header"
    }, /*#__PURE__*/_react.default.createElement("h4", {
      className: "page-title"
    }, "Version history"), function () {
      if (canApply && !(0, _isEmpty.default)(selectedVersion)) {
        return applySelectedVersion;
      }
      return canCreate && (0, _isEmpty.default)(selectedVersion) ? createVersion : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    }());
  };
  var renderVersionListLoader = function renderVersionListLoader() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "version-item"
    }, /*#__PURE__*/_react.default.createElement(_reactContentLoader.default, {
      height: '400px',
      speed: 2,
      width: '100%'
    }, /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "88",
      x: "58",
      y: "8"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "200",
      x: "58",
      y: "26"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "150",
      x: "58",
      y: "46"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "100",
      x: "58",
      y: "66"
    }), /*#__PURE__*/_react.default.createElement("circle", {
      cx: "20",
      cy: "20",
      r: "20"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "88",
      x: "58",
      y: "108"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "200",
      x: "58",
      y: "126"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "150",
      x: "58",
      y: "146"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "100",
      x: "58",
      y: "166"
    }), /*#__PURE__*/_react.default.createElement("circle", {
      cx: "20",
      cy: "120",
      r: "20"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "88",
      x: "58",
      y: "208"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "200",
      x: "58",
      y: "226"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "150",
      x: "58",
      y: "246"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "100",
      x: "58",
      y: "266"
    }), /*#__PURE__*/_react.default.createElement("circle", {
      cx: "20",
      cy: "220",
      r: "20"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "88",
      x: "58",
      y: "308"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "200",
      x: "58",
      y: "326"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "150",
      x: "58",
      y: "346"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      height: "6",
      rx: "3",
      ry: "3",
      width: "100",
      x: "58",
      y: "366"
    }), /*#__PURE__*/_react.default.createElement("circle", {
      cx: "20",
      cy: "320",
      r: "20"
    })));
  };
  var renderVersionList = function renderVersionList() {
    return versions.length === 0 ? /*#__PURE__*/_react.default.createElement("div", {
      className: "col-sm-12 text-center mtl",
      "data-test-id": "no-versions"
    }, "There are no versions of this folder content available, start by pressing Save as a new version.") : /*#__PURE__*/_react.default.createElement("div", {
      className: "version-list-scroll"
    }, versions.map(function (item) {
      return /*#__PURE__*/_react.default.createElement(_versionListItem.VersionListItem, (0, _extends2.default)({
        dateTimeFormat: dateTimeFormat,
        hasValidationWarnings: hasValidationWarnings,
        key: item.name
      }, item, {
        isApplied: isLastAppliedVersion(item),
        isSelected: selectedVersion.name === item.name,
        onSelect: function onSelect() {
          return selectVersion(item);
        },
        onShowWarnings: function onShowWarnings() {
          return showWarnings();
        }
      }));
    }));
  };
  var renderContent = function renderContent() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "row"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "col-sm-4 version-list-sidebar"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('version-item-label version-item-current', {
        selected: (0, _isEmpty.default)(selectedVersion)
      }),
      onClick: function onClick() {
        return selectVersion({});
      }
    }, /*#__PURE__*/_react.default.createElement("h6", null, /*#__PURE__*/_react.default.createElement("span", {
      className: "label label-primary"
    }, "Current"))), /*#__PURE__*/_react.default.createElement("div", {
      className: "version-item-label"
    }, /*#__PURE__*/_react.default.createElement("h6", null, "Previous versions")), loading ? renderVersionListLoader() : renderVersionList()), /*#__PURE__*/_react.default.createElement("div", {
      className: "col-sm-8 version-content"
    }, showCodePreview && versionedFiles && versionedFiles.length !== 0 ? renderCodePreview() : renderNoCode()));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    id: "folder-history"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "col-sm-12"
  }, renderHeader()), /*#__PURE__*/_react.default.createElement("div", {
    className: "col-sm-12 content-wrapper"
  }, renderContent()), /*#__PURE__*/_react.default.createElement(_versionModal.VersionModalComponent, null), /*#__PURE__*/_react.default.createElement(_folderValidationModal.FolderValidationModalComponent, null), /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotConfirmationDialog, {
    message: /*#__PURE__*/_react.default.createElement("p", null, "Version ", /*#__PURE__*/_react.default.createElement("strong", null, "'", selectedVersion.name, "'"), " will be restored to the version from", ' ', /*#__PURE__*/_react.default.createElement("strong", null, (0, _utils.formatDateTime)(selectedVersion.commitTime, dateTimeFormat.date, dateTimeFormat.time)), "."),
    onCancel: closeApplyModal,
    onSubmit: confirmApply,
    open: isApplyModalOpen,
    title: "Apply Version"
  })));
};
VersionListComponent.propTypes = {
  canApply: _propTypes.default.bool,
  canCreate: _propTypes.default.bool
};

/***/ }),

/***/ 75538:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.tabs = exports.passwordsColumns = exports.getWarningTitle = exports.getCiReferenceLink = exports.externalRefsColumns = exports.checkMessageTypeAndUpdateTableData = exports.VersionModalComponent = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireDefault(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _dotComponents = __webpack_require__(92140);
var _filter = _interopRequireDefault(__webpack_require__(63105));
var _helpButton = __webpack_require__(50909);
var _versionForm = __webpack_require__(3517);
var _folderVersioning = __webpack_require__(50727);
var _folderVersioning2 = __webpack_require__(55170);
__webpack_require__(21638);
var _ids = _interopRequireDefault(__webpack_require__(39647));
var _angularAccessor = _interopRequireDefault(__webpack_require__(81403));
var _constants = __webpack_require__(83571);
var _folderVersioning3 = __webpack_require__(16705);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var getCiReferenceLink = exports.getCiReferenceLink = function getCiReferenceLink(warning) {
  switch (String(warning.ciTypeDisplayName)) {
    case 'Variable':
      return getVariableReferenceLink(warning);
    case 'Connection':
      var folderPrefix = warning.folderId ? "/folders/".concat(warning.folderId) : '';
      return "#".concat(folderPrefix, "/configuration");
    case 'Template':
      if (warning.id) {
        return "#/templates/".concat((0, _ids.default)().toInternalId(warning.id), "/properties");
      } else {
        return '';
      }
    case 'Task':
      return getTaskReferenceLink(warning);
    case 'Trigger':
      return getTriggerReferenceLink(warning);
    case 'Tile':
      return getTileReferenceLink(warning);
    default:
      return "#/folders/".concat(warning.folderId);
  }
};
var getVariableReferenceLink = function getVariableReferenceLink(warning) {
  if (warning.id && warning.id.includes((0, _ids.default)().releasePrefix)) {
    var internalId = (0, _ids.default)().toInternalId(warning.id);
    var folderTemplateId = (0, _ids.default)().releaseIdFrom(internalId);
    return "#/templates/".concat(folderTemplateId, "/variables");
  } else {
    return warning.folderId ? "#/folders/".concat(warning.folderId, "/variables") : '#/global-variables';
  }
};
var getTaskReferenceLink = function getTaskReferenceLink(warning) {
  if (warning.id) {
    var plainFolderId = (0, _ids.default)().noApplications(warning.folderId);
    var indexOfReleaseId = warning.id.indexOf((0, _ids.default)().releasePrefix);
    var indexOfPhaseId = warning.id.indexOf((0, _ids.default)().phasePrefix, indexOfReleaseId);
    var plainTemplateId = warning.id.substring(indexOfReleaseId, indexOfPhaseId - 1);
    var phaseTaskId = (0, _ids.default)().toInternalId(warning.id.substring(indexOfPhaseId));
    return "#/templates/".concat(plainFolderId, "-").concat(plainTemplateId, "?openTaskDetailsModal=").concat(phaseTaskId);
  } else {
    return '';
  }
};
var getTriggerReferenceLink = function getTriggerReferenceLink(warning) {
  if (warning.id) {
    var warningFolderId = warning.folderId.replaceAll('/', '~');
    var triggerIdIndex = warning.id.indexOf((0, _ids.default)().triggerPrefix);
    var plainTriggerId = warning.id.substring(triggerIdIndex);
    var viewStorage = (0, _angularAccessor.default)('ViewStorage');
    viewStorage.setView(_constants.triggerViewKey, "/folders/".concat(warning.folderId, "/triggers"));
    return "#/trigger-management/".concat(plainTriggerId, "?folderId=").concat(warningFolderId);
  } else {
    return '';
  }
};
var getTileReferenceLink = function getTileReferenceLink(warning) {
  if (warning.id) {
    var tileIdIndex = warning.id.indexOf((0, _ids.default)().tilePrefix);
    var dashboardId = warning.id.substring(0, tileIdIndex - 1);
    return "#/folders/".concat(warning.folderId, "/dashboards/").concat(dashboardId);
  } else {
    return '';
  }
};
var checkMessageTypeAndUpdateTableData = exports.checkMessageTypeAndUpdateTableData = function checkMessageTypeAndUpdateTableData(tableData, warning, messageType, warningData) {
  if (messageType === _folderVersioning3.validationMessageTypes.hardcodedPassword || messageType === _folderVersioning3.validationMessageTypes.missingPassword) {
    tableData.push(warningData);
  } else if (messageType === _folderVersioning3.validationMessageTypes.nonVersionedReference) {
    var dependency = warning.dependency;
    var dependencyLink = getCiReferenceLink(warning.dependency);
    var warningWithDependencyData = {
      id: warningData.id,
      rowData: _objectSpread(_objectSpread({}, warningData.rowData), {}, {
        dependency: /*#__PURE__*/_react.default.createElement(_dotComponents.DotLink, {
          href: dependencyLink,
          target: "_self",
          tooltip: dependencyLink
        }, dependency.title)
      })
    };
    tableData.push(warningWithDependencyData);
  }
};
var getWarningTitle = exports.getWarningTitle = function getWarningTitle(warning) {
  var title;
  if (warning.folder === '') {
    title = warning.title;
  } else {
    title = warning.folder + '/' + warning.title;
  }
  return title;
};
var passwordsColumns = exports.passwordsColumns = function passwordsColumns(resolvedShow) {
  return [{
    id: 'ciType',
    label: 'Type',
    width: '20%'
  }, {
    id: 'title',
    label: 'Title',
    width: '60%'
  }, {
    id: 'property',
    label: 'Property',
    width: '20%'
  }, resolvedShow && {
    id: 'resolved',
    label: 'Resolved',
    width: '20%'
  }];
};
var externalRefsColumns = exports.externalRefsColumns = function externalRefsColumns(resolvedShow) {
  return [{
    id: 'ciType',
    label: 'Type',
    width: '20%'
  }, {
    id: 'title',
    label: 'Title',
    width: '60%'
  }, {
    id: 'property',
    label: 'Property',
    width: '20%'
  }, {
    id: 'dependency',
    label: 'Dependency',
    width: '20%'
  }, resolvedShow && {
    id: 'resolved',
    label: 'Resolved',
    width: '20%'
  }];
};

/*label prop has been commented below, we have a feature enhancement request for DotBadge Component, Once Done it will be used */
var tabs = exports.tabs = function tabs(hardcodedPassword) {
  return [hardcodedPassword ? {
    label: 'Passwords',
    // label: (
    //     <DotBadge badgeColor="red" invisible={false} overlap="rectangular">
    //         Passwords
    //     </DotBadge>
    // ),
    value: _folderVersioning3.validationMessageTypes.hardcodedPassword
  } : {
    label: 'Passwords',
    // label: (
    //     <DotBadge badgeColor="red" invisible={false} overlap="rectangular">
    //         Passwords
    //     </DotBadge>
    // ),
    value: _folderVersioning3.validationMessageTypes.missingPassword
  }, {
    //     disabled: true,
    label: 'References',
    //     label: (
    //         <DotBadge badgeColor="red" invisible={false} overlap="rectangular">
    //             References
    //         </DotBadge>
    //     ),
    value: _folderVersioning3.validationMessageTypes.nonVersionedReference
  }];
};
var VersionModalComponent = exports.VersionModalComponent = function VersionModalComponent() {
  var dispatch = (0, _reactRedux.useDispatch)();
  var modalIsOpen = (0, _reactRedux.useSelector)(_folderVersioning.getModalState);
  var loading = (0, _reactRedux.useSelector)(_folderVersioning.getLoadingState);
  var versionForm = (0, _reactRedux.useSelector)(_folderVersioning.getVersionForm);
  var validation = (0, _reactRedux.useSelector)(_folderVersioning.getValidationDetails);
  var validationTab = (0, _reactRedux.useSelector)(_folderVersioning.getValidationTab);
  var showVersionFormStatus = (0, _reactRedux.useSelector)(_folderVersioning.getShowVersionFormStatus);
  var closeModal = function closeModal() {
    dispatch((0, _folderVersioning2.closeNewVersionModal)());
  };
  var proceedSaveWithWarnings = function proceedSaveWithWarnings() {
    dispatch((0, _folderVersioning2.openVersionFormState)());
  };
  var updateForm = function updateForm(formModel) {
    dispatch((0, _folderVersioning2.updateVersionForm)(formModel));
  };
  var filterWarningsUpdateData = function filterWarningsUpdateData() {
    var messageType = validationTab;
    var warnings = (0, _filter.default)(validation.warnings, function (warning) {
      return warning.messageType === messageType;
    });
    var tableData = [];
    warnings.forEach(function (warning) {
      var link = getCiReferenceLink(warning);
      var title = getWarningTitle(warning);
      var warningData = {
        id: warning.id,
        rowData: {
          ciType: warning.ciTypeDisplayName,
          title: /*#__PURE__*/_react.default.createElement(_dotComponents.DotLink, {
            href: link,
            target: "_self",
            tooltip: link
          }, title),
          property: warning.property
        }
      };
      checkMessageTypeAndUpdateTableData(tableData, warning, messageType, warningData);
    });
    return tableData;
  };
  function hasWarnings() {
    return validation.hasOwnProperty('warnings') && validation.warnings.length > 0;
  }
  var onTabChange = function onTabChange(value) {
    dispatch((0, _folderVersioning2.changeValidationTab)(value));
  };
  var getTableComponent = function getTableComponent(columns) {
    return /*#__PURE__*/_react.default.createElement(_dotComponents.DotTable, {
      columns: columns,
      data: filterWarningsUpdateData(),
      maxHeight: "100%",
      order: "asc",
      orderBy: "title"
    });
  };
  var renderWarnings = function renderWarnings() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasWarnings() ? /*#__PURE__*/_react.default.createElement("div", {
      key: "renderWarnings"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "drawer-body"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "divider"
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "tab-nav-wrapper"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTabs, {
      initialValue: validationTab,
      onChange: onTabChange,
      tabs: tabs(true)
    }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
      onClick: proceedSaveWithWarnings,
      tooltip: "Save with warnings",
      type: "primary"
    }, "Save with warnings")), /*#__PURE__*/_react.default.createElement("div", {
      className: "tab-content"
    }, validationTab === _folderVersioning3.validationMessageTypes.hardcodedPassword && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "password-warning-wrapper"
    }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      className: "password-warning-icon",
      fontSize: "medium",
      iconId: "warning-solid"
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "password-warning-description"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
      variant: "body1"
    }, "This folder contains hard-coded passwords. Passwords will not be stored in version control.", /*#__PURE__*/_react.default.createElement("br", null), "When applying a version, Digital.ai Release will attempt to retain the passwords that are configured. However, some passwords may need to be entered manually."))), getTableComponent(passwordsColumns(false))), validationTab === _folderVersioning3.validationMessageTypes.nonVersionedReference && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "password-warning-wrapper"
    }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotIcon, {
      className: "password-warning-icon",
      fontSize: "medium",
      iconId: "warning-solid"
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "password-warning-description"
    }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotTypography, {
      variant: "body1"
    }, "This folder contains references to entities defined outside of versioning scope or in other folders.", /*#__PURE__*/_react.default.createElement("br", null), "Versioning will only store the entities in this folder into source control as a version, but not the external dependencies. When applying this version, you will need to make sure those external dependencies exist, or fix them manually."))), getTableComponent(externalRefsColumns(false)))))) : /*#__PURE__*/_react.default.createElement("div", {
      className: "drawer-body"
    }, /*#__PURE__*/_react.default.createElement(_versionForm.VersionFormComponent, {
      form: versionForm,
      loading: loading,
      onUpdate: updateForm,
      viewWarningsButton: false
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_dotComponents.DotThemeProvider, null, /*#__PURE__*/_react.default.createElement(_dotComponents.DotDrawer, {
    PaperProps: {
      style: {
        position: 'absolute'
      }
    },
    anchor: "bottom",
    className: "version-modal",
    height: "100%",
    onClose: closeModal,
    open: modalIsOpen,
    variant: "persistent"
  }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotActionToolbar, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "top-toolbar-icons"
  }, /*#__PURE__*/_react.default.createElement(_helpButton.HelpButton, {
    helpLink: 'how-to/using-gitops-version-control.html'
  }), /*#__PURE__*/_react.default.createElement(_dotComponents.DotIconButton, {
    color: "default",
    iconId: "close",
    iconSize: "small",
    onClick: closeModal,
    size: "medium",
    tooltip: "Close"
  }))), hasWarnings() && /*#__PURE__*/_react.default.createElement(_dotComponents.DotAlertBanner, {
    action: "",
    severity: "warning"
  }, "This folder refers to information that will not be stored in version control. Please review the warnings below."), showVersionFormStatus ? /*#__PURE__*/_react.default.createElement(_versionForm.VersionFormComponent, {
    form: versionForm,
    loading: loading,
    onUpdate: updateForm,
    viewWarningsButton: showVersionFormStatus
  }) : renderWarnings()));
};

/***/ }),

/***/ 55170:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.warningDisplayModal = exports.validateCurrentFolderState = exports.validateAppliedFolderState = exports.updateVersionForm = exports.updateValidationMessageStatus = exports.updateFolderValidationWarningState = exports.updateConfigurationForm = exports.saveConfigurationSuceeded = exports.saveConfigurationFailed = exports.saveConfiguration = exports.resetInitialVersionHelperState = exports.resetInitialDescriptionHelperState = exports.removeConfirmLeavePopup = exports.openVersionFormState = exports.openNewVersionModal = exports.openFolderValidationModal = exports.loadVersions = exports.loadVersionSucceed = exports.loadVersionFinished = exports.loadVersionFailed = exports.loadFileSucceed = exports.loadFileFailed = exports.loadFile = exports.loadCodeSucceed = exports.loadCodeFailed = exports.loadCode = exports.initVersioningList = exports.initVersioningConfigurationFormSucceed = exports.initVersioningConfigurationForm = exports.initVersionListFinished = exports.goToConfiguration = exports.displayVersionFormatInvalid = exports.descriptionInvalidDisplayModal = exports.createVersionFinished = exports.createVersionFailed = exports.createVersion = exports.closeWarningDisplayModal = exports.closeVersionFormState = exports.closeNewVersionModal = exports.closeFolderValidationModal = exports.closeCodePreview = exports.cleanupVersioningList = exports.changeValidationTab = exports.changeFolderValidationTab = exports.applyVersionSucceed = exports.applyVersion = exports.addConfirmLeavePopup = exports.actionTypes = void 0;
var actionTypes = exports.actionTypes = {
  INITIALIZE_VERSION_LIST_REQUESTED: 'FOLDER-VERSIONING/INITIALIZE_VERSION_LIST_REQUESTED',
  INITIALIZE_VERSION_LIST_FINISHED: 'FOLDER-VERSIONING/INITIALIZE_VERSION_LIST_FINISHED',
  CLEANUP_VERSION_LIST_REQUESTED: 'FOLDER-VERSIONING/CLEANUP_VERSION_LIST_REQUESTED',
  INITIALIZE_CONFIGURATION_FORM_REQUESTED: 'FOLDER-VERSIONING/INITIALIZE_CONFIGURATION_FORM_REQUESTED',
  INITIALIZE_CONFIGURATION_FORM_SUCCEEDED: 'FOLDER-VERSIONING/INITIALIZE_CONFIGURATION_FORM_SUCCEEDED',
  UPDATE_CONFIGURATION_FORM: 'FOLDER-VERSIONING/UPDATE_CONFIGURATION_FORM',
  CREATE_CONFIGURATION_REQUESTED: 'FOLDER-VERSIONING/CREATE_CONFIGURATION_REQUESTED',
  CREATE_CONFIGURATION_SUCCEEDED: 'FOLDER-VERSIONING/CREATE_CONFIGURATION_SUCCEEDED',
  CREATE_CONFIGURATION_FAILED: 'FOLDER-VERSIONING/CREATE_CONFIGURATION_FAILED',
  GO_TO_GIT_CONFIGURATION_FORM: 'FOLDER-VERSIONING/GO_TO_GIT_CONFIGURATION_FORM',
  ADD_CONFIGURATION_FORM_CONFIRMATION_POPUP: 'FOLDER-VERSIONING/ADD_CONFIGURATION_FORM_CONFIRMATION_POPUP',
  REMOVE_CONFIGURATION_FORM_CONFIRMATION_POPUP: 'FOLDER-VERSIONING/REMOVE_CONFIGURATION_FORM_CONFIRMATION_POPUP',
  LOAD_VERSIONS_REQUESTED: 'FOLDER-VERSIONING/LOAD_VERSIONS_REQUESTED',
  LOAD_VERSIONS_SUCCEEDED: 'FOLDER-VERSIONING/LOAD_VERSIONS_SUCCEEDED',
  LOAD_VERSIONS_FAILED: 'FOLDER-VERSIONING/LOAD_VERSIONS_FAILED',
  LOAD_VERSIONS_FINISHED: 'FOLDER-VERSIONING/LOAD_VERSIONS_FINISHED',
  LOAD_VERSION_CODE_REQUESTED: 'FOLDER-VERSIONING/LOAD_VERSION_CODE_REQUESTED',
  LOAD_VERSION_CODE_SUCCEEDED: 'FOLDER-VERSIONING/LOAD_VERSION_CODE_SUCCEEDED',
  LOAD_VERSION_CODE_FAILED: 'FOLDER-VERSIONING/LOAD_VERSION_CODE_FAILED',
  LOAD_VERSION_FILE_REQUESTED: 'FOLDER-VERSIONING/LOAD_VERSION_FILE_REQUESTED',
  LOAD_VERSION_FILE_SUCCEEDED: 'FOLDER-VERSIONING/LOAD_VERSION_FILE_SUCCEEDED',
  LOAD_VERSION_FILE_FAILED: 'FOLDER-VERSIONING/LOAD_VERSION_FILE_FAILED',
  CLOSE_CODE_PREVIEW: 'FOLDER-VERSIONING/CLOSE_CODE_PREVIEW',
  VALIDATE_CURRENT_FOLDER_STATE: 'FOLDER-VERSIONING/VALIDATE_CURRENT_FOLDER_STATE',
  CHANGE_VALIDATION_TAB: 'FOLDER-VERSIONING/CHANGE_VALIDATION_TAB',
  OPEN_NEW_VERSION_MODAL: 'FOLDER-VERSIONING/OPEN_NEW_VERSION_MODAL',
  CLOSE_NEW_VERSION_MODAL: 'FOLDER-VERSIONING/CLOSE_NEW_VERSION_MODAL',
  UPDATE_VERSION_FORM: 'FOLDER-VERSIONING/UPDATE_VERSION_FORM',
  CREATE_VERSION_REQUESTED: 'FOLDER-VERSIONING/CREATE_VERSION_REQUESTED',
  CREATE_VERSION_FAILED: 'FOLDER-VERSIONING/CREATE_VERSION_FAILED',
  CREATE_VERSION_FINISHED: 'FOLDER-VERSIONING/CREATE_VERSION_FINISHED',
  APPLY_VERSION_REQUESTED: 'FOLDER-VERSIONING/APPLY_VERSION_REQUESTED',
  APPLY_VERSION_SUCCEEDED: 'FOLDER-VERSIONING/APPLY_VERSION_SUCCEEDED',
  ERROR_DISPLAY_MODAL: 'FOLDER-VERSIONING/ERROR_DISPLAY_MODAL',
  CLOSE_ERROR_DISPLAY_MODAL: 'FOLDER-VERSIONING/CLOSE_ERROR_DISPLAY_MODAL',
  VERSION_FORMAT_ERROR_DISPLAY_HELPER: 'FOLDER-VERSIONING/VERSION_FORMAT_ERROR_DISPLAY_HELPER',
  RESET_INITIAL_VERSION_HELPER_STATE: 'FOLDER-VERSIONING/RESET_INITIAL_VERSION_HELPER_STATE',
  DESCRIPTION_INVALID_DISPLAY_HELPER: 'FOLDER-VERSIONING/DESCRIPTION_INVALID_DISPLAY_HELPER',
  RESET_INITIAL_DESCRIPTION_HELPER_STATE: 'FOLDER-VERSIONING/RESET_INITIAL_DESCRIPTION_HELPER_STATE',
  SHOW_VERSION_FORM_STATUS: 'FOLDER-VERSIONING/SHOW_VERSION_FORM_STATUS',
  CLOSE_VERSION_FORM_STATUS: 'FOLDER-VERSIONING/CLOSE_VERSION_FORM_STATUS',
  VALIDATE_APPLIED_FOLDER_STATE: 'FOLDER-VERSIONING/VALIDATE_APPLIED_FOLDER_STATE',
  OPEN_FOLDER_VALIDATION_MODAL: 'FOLDER-VERSIONING/OPEN_FOLDER_VALIDATION_MODAL',
  CLOSE_FOLDER_VALIDATION_MODAL: 'FOLDER-VERSIONING/CLOSE_FOLDER_VALIDATION_MODAL',
  CHANGE_FOLDER_VALIDATION_TAB: 'FOLDER-VERSIONING/CHANGE_FOLDER_VALIDATION_TAB',
  UPDATE_VALIDATION_MESSAGE_STATUS: 'FOLDER-VERSIONING/UPDATE_VALIDATION_MESSAGE_STATUS',
  UPDATE_FOLDER_VALIDATION_WARNING_STATE: 'FOLDER-VERSIONING/UPDATE_FOLDER_VALIDATION_WARNING_STATE'
};
var initVersioningList = exports.initVersioningList = function initVersioningList(folder) {
  return {
    type: actionTypes.INITIALIZE_VERSION_LIST_REQUESTED,
    payload: folder
  };
};
var cleanupVersioningList = exports.cleanupVersioningList = function cleanupVersioningList() {
  return {
    type: actionTypes.CLEANUP_VERSION_LIST_REQUESTED
  };
};
var initVersionListFinished = exports.initVersionListFinished = function initVersionListFinished(metadata) {
  return {
    type: actionTypes.INITIALIZE_VERSION_LIST_FINISHED,
    payload: metadata
  };
};
var initVersioningConfigurationForm = exports.initVersioningConfigurationForm = function initVersioningConfigurationForm(folder) {
  return {
    type: actionTypes.INITIALIZE_CONFIGURATION_FORM_REQUESTED,
    payload: folder
  };
};
var initVersioningConfigurationFormSucceed = exports.initVersioningConfigurationFormSucceed = function initVersioningConfigurationFormSucceed(folder, gitConnections, configuration, confId, hasConfEditPermission, isVersionsAvailable, versioningStyles) {
  return {
    type: actionTypes.INITIALIZE_CONFIGURATION_FORM_SUCCEEDED,
    payload: {
      folder: folder,
      gitConnections: gitConnections,
      configuration: configuration,
      confId: confId,
      hasConfEditPermission: hasConfEditPermission,
      isVersionsAvailable: isVersionsAvailable,
      versioningStyles: versioningStyles
    }
  };
};
var updateConfigurationForm = exports.updateConfigurationForm = function updateConfigurationForm(path, value) {
  return {
    type: actionTypes.UPDATE_CONFIGURATION_FORM,
    payload: {
      path: path,
      value: value
    }
  };
};
var saveConfiguration = exports.saveConfiguration = function saveConfiguration(callbackFn) {
  return {
    type: actionTypes.CREATE_CONFIGURATION_REQUESTED,
    payload: {
      callbackFn: callbackFn
    }
  };
};
var saveConfigurationSuceeded = exports.saveConfigurationSuceeded = function saveConfigurationSuceeded() {
  return {
    type: actionTypes.CREATE_CONFIGURATION_SUCCEEDED
  };
};
var saveConfigurationFailed = exports.saveConfigurationFailed = function saveConfigurationFailed() {
  return {
    type: actionTypes.CREATE_CONFIGURATION_FAILED
  };
};
var goToConfiguration = exports.goToConfiguration = function goToConfiguration() {
  return {
    type: actionTypes.GO_TO_GIT_CONFIGURATION_FORM
  };
};
var addConfirmLeavePopup = exports.addConfirmLeavePopup = function addConfirmLeavePopup() {
  return {
    type: actionTypes.ADD_CONFIGURATION_FORM_CONFIRMATION_POPUP
  };
};
var removeConfirmLeavePopup = exports.removeConfirmLeavePopup = function removeConfirmLeavePopup() {
  return {
    type: actionTypes.REMOVE_CONFIGURATION_FORM_CONFIRMATION_POPUP
  };
};
var loadVersions = exports.loadVersions = function loadVersions(fetchChanges) {
  return {
    type: actionTypes.LOAD_VERSIONS_REQUESTED,
    payload: {
      fetchChanges: fetchChanges
    }
  };
};
var loadVersionSucceed = exports.loadVersionSucceed = function loadVersionSucceed(_ref, configuration) {
  var fetched = _ref.fetched,
    versions = _ref.versions;
  return {
    type: actionTypes.LOAD_VERSIONS_SUCCEEDED,
    payload: {
      fetched: fetched,
      versions: versions,
      configuration: configuration
    }
  };
};
var loadVersionFailed = exports.loadVersionFailed = function loadVersionFailed(fetchChanges) {
  return {
    type: actionTypes.LOAD_VERSIONS_FAILED,
    payload: fetchChanges
  };
};
var loadVersionFinished = exports.loadVersionFinished = function loadVersionFinished() {
  return {
    type: actionTypes.LOAD_VERSIONS_FINISHED
  };
};
var loadCode = exports.loadCode = function loadCode(versionName) {
  return {
    type: actionTypes.LOAD_VERSION_CODE_REQUESTED,
    payload: {
      versionName: versionName
    }
  };
};
var loadCodeSucceed = exports.loadCodeSucceed = function loadCodeSucceed(fileNames) {
  return {
    type: actionTypes.LOAD_VERSION_CODE_SUCCEEDED,
    payload: {
      fileNames: fileNames
    }
  };
};
var loadCodeFailed = exports.loadCodeFailed = function loadCodeFailed() {
  return {
    type: actionTypes.LOAD_VERSION_CODE_FAILED
  };
};
var loadFile = exports.loadFile = function loadFile(versionName, fileName) {
  return {
    type: actionTypes.LOAD_VERSION_FILE_REQUESTED,
    payload: {
      versionName: versionName,
      fileName: fileName
    }
  };
};
var loadFileSucceed = exports.loadFileSucceed = function loadFileSucceed(code, selectedFilename) {
  return {
    type: actionTypes.LOAD_VERSION_FILE_SUCCEEDED,
    payload: {
      code: code,
      selectedFilename: selectedFilename
    }
  };
};
var loadFileFailed = exports.loadFileFailed = function loadFileFailed() {
  return {
    type: actionTypes.LOAD_VERSION_FILE_FAILED
  };
};
var closeCodePreview = exports.closeCodePreview = function closeCodePreview() {
  return {
    type: actionTypes.CLOSE_CODE_PREVIEW
  };
};
var validateCurrentFolderState = exports.validateCurrentFolderState = function validateCurrentFolderState() {
  return {
    type: actionTypes.VALIDATE_CURRENT_FOLDER_STATE
  };
};
var changeValidationTab = exports.changeValidationTab = function changeValidationTab(tab) {
  return {
    type: actionTypes.CHANGE_VALIDATION_TAB,
    payload: tab
  };
};
var openNewVersionModal = exports.openNewVersionModal = function openNewVersionModal(validation) {
  return {
    type: actionTypes.OPEN_NEW_VERSION_MODAL,
    payload: validation
  };
};
var closeNewVersionModal = exports.closeNewVersionModal = function closeNewVersionModal() {
  return {
    type: actionTypes.CLOSE_NEW_VERSION_MODAL
  };
};
var updateVersionForm = exports.updateVersionForm = function updateVersionForm(form) {
  return {
    type: actionTypes.UPDATE_VERSION_FORM,
    payload: form
  };
};
var createVersion = exports.createVersion = function createVersion() {
  return {
    type: actionTypes.CREATE_VERSION_REQUESTED
  };
};
var createVersionFailed = exports.createVersionFailed = function createVersionFailed() {
  return {
    type: actionTypes.CREATE_VERSION_FAILED
  };
};
var createVersionFinished = exports.createVersionFinished = function createVersionFinished() {
  return {
    type: actionTypes.CREATE_VERSION_FINISHED
  };
};
var applyVersion = exports.applyVersion = function applyVersion(name) {
  return {
    type: actionTypes.APPLY_VERSION_REQUESTED,
    payload: name
  };
};
var applyVersionSucceed = exports.applyVersionSucceed = function applyVersionSucceed(name) {
  return {
    type: actionTypes.APPLY_VERSION_SUCCEEDED,
    payload: name
  };
};
var warningDisplayModal = exports.warningDisplayModal = function warningDisplayModal(errors) {
  return {
    type: actionTypes.ERROR_DISPLAY_MODAL,
    payload: {
      errors: errors
    }
  };
};
var closeWarningDisplayModal = exports.closeWarningDisplayModal = function closeWarningDisplayModal() {
  return {
    type: actionTypes.CLOSE_ERROR_DISPLAY_MODAL
  };
};
var displayVersionFormatInvalid = exports.displayVersionFormatInvalid = function displayVersionFormatInvalid() {
  return {
    type: actionTypes.VERSION_FORMAT_ERROR_DISPLAY_HELPER
  };
};
var resetInitialVersionHelperState = exports.resetInitialVersionHelperState = function resetInitialVersionHelperState() {
  return {
    type: actionTypes.RESET_INITIAL_VERSION_HELPER_STATE
  };
};
var descriptionInvalidDisplayModal = exports.descriptionInvalidDisplayModal = function descriptionInvalidDisplayModal() {
  return {
    type: actionTypes.DESCRIPTION_INVALID_DISPLAY_HELPER
  };
};
var resetInitialDescriptionHelperState = exports.resetInitialDescriptionHelperState = function resetInitialDescriptionHelperState() {
  return {
    type: actionTypes.RESET_INITIAL_DESCRIPTION_HELPER_STATE
  };
};
var openVersionFormState = exports.openVersionFormState = function openVersionFormState() {
  return {
    type: actionTypes.SHOW_VERSION_FORM_STATUS
  };
};
var closeVersionFormState = exports.closeVersionFormState = function closeVersionFormState() {
  return {
    type: actionTypes.CLOSE_VERSION_FORM_STATUS
  };
};
var validateAppliedFolderState = exports.validateAppliedFolderState = function validateAppliedFolderState() {
  return {
    type: actionTypes.VALIDATE_APPLIED_FOLDER_STATE
  };
};
var openFolderValidationModal = exports.openFolderValidationModal = function openFolderValidationModal(messages) {
  return {
    type: actionTypes.OPEN_FOLDER_VALIDATION_MODAL,
    payload: messages
  };
};
var closeFolderValidationModal = exports.closeFolderValidationModal = function closeFolderValidationModal() {
  return {
    type: actionTypes.CLOSE_FOLDER_VALIDATION_MODAL
  };
};
var changeFolderValidationTab = exports.changeFolderValidationTab = function changeFolderValidationTab(tab) {
  return {
    type: actionTypes.CHANGE_FOLDER_VALIDATION_TAB,
    payload: tab
  };
};
var updateValidationMessageStatus = exports.updateValidationMessageStatus = function updateValidationMessageStatus(warning) {
  return {
    type: actionTypes.UPDATE_VALIDATION_MESSAGE_STATUS,
    payload: warning
  };
};
var updateFolderValidationWarningState = exports.updateFolderValidationWarningState = function updateFolderValidationWarningState(hasWarnings) {
  return {
    type: actionTypes.UPDATE_FOLDER_VALIDATION_WARNING_STATE,
    payload: hasWarnings
  };
};

/***/ }),

/***/ 16705:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.viewMode = exports.validationMessageTypes = void 0;
var viewMode = exports.viewMode = {
  view: 'list',
  edit: 'configure'
};
var validationMessageTypes = exports.validationMessageTypes = {
  hardcodedPassword: 'HARDCODED_PASSWORD',
  missingPassword: 'MISSING_PASSWORD',
  nonVersionedReference: 'NON_VERSIONED_REFERENCE'
};

/***/ }),

/***/ 93395:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.reducers = exports.initialState = exports.folderVersioningReducer = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _camelCase = _interopRequireDefault(__webpack_require__(68929));
var _deburr = _interopRequireDefault(__webpack_require__(53816));
var _find = _interopRequireDefault(__webpack_require__(13311));
var _isUndefined = _interopRequireDefault(__webpack_require__(52353));
var _set = _interopRequireDefault(__webpack_require__(36968));
var _some = _interopRequireDefault(__webpack_require__(59704));
var _upperFirst = _interopRequireDefault(__webpack_require__(11700));
var _folderVersioning = __webpack_require__(55170);
var _folderVersioning2 = __webpack_require__(16705);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var initialState = exports.initialState = function initialState() {
  return {
    listLoading: true,
    formProcessing: true,
    dateTimeFormat: {
      date: 'MMM d, y',
      time: 'h:mm:ss a'
    },
    folder: undefined,
    configuration: undefined,
    versions: [],
    loadingVersions: true,
    codePreviewOpen: false,
    code: '',
    validation: {},
    validationTab: _folderVersioning2.validationMessageTypes.hardcodedPassword,
    modalOpen: false,
    errors: [],
    errorModalOpen: false,
    loading: false,
    needsRefetch: false,
    displayVersionError: false,
    displayDescriptionVersionError: false,
    showVersionFormStatus: false,
    showMoreLessModal: false,
    folderValidations: {},
    folderValidationTab: _folderVersioning2.validationMessageTypes.missingPassword,
    folderValidationModelOpen: false,
    hasValidationWarnings: false,
    scmPathModificationWarning: 'Changing Repository path will result in loss of version history',
    versionForm: {
      valid: false,
      field: {
        name: {
          name: 'name',
          label: 'Version name',
          value: '',
          valid: false,
          required: true
        },
        description: {
          name: 'description',
          label: 'Description',
          value: '',
          valid: false,
          size: 'LARGE'
        }
      }
    },
    gitConnections: [],
    versioningConfigurationForm: {
      valid: false,
      pristine: true,
      field: {
        versioningStyle: {
          name: 'versioningStyle',
          label: 'Versioning style',
          description: 'Determines how many files are generated in source control. “Single file” creates a single Releasefile.yaml for all content, including subfolders.',
          value: '',
          valid: false,
          required: true
        },
        scmPath: {
          name: 'scmPath',
          label: 'Repository path',
          description: 'Path in the repository where the yaml files are stored.',
          value: '',
          valid: false,
          required: true
        },
        branch: {
          name: 'branch',
          label: 'Branch',
          description: 'Branch to synchronize with',
          value: 'master',
          valid: true,
          required: true
        },
        gitConnection: {
          name: 'gitConnection',
          value: {
            id: null
          },
          valid: false,
          required: true
        },
        exports: {
          exportTemplates: {
            name: 'exportTemplates',
            icon: 'template',
            label: 'Templates',
            value: true
          },
          exportWorkflows: {
            name: 'exportWorkflows',
            icon: 'workflow',
            label: 'Workflows',
            value: true
          },
          exportPatterns: {
            name: 'exportPatterns',
            icon: 'pattern-bundle',
            label: 'Patterns',
            value: true
          },
          exportTriggers: {
            name: 'exportTriggers',
            icon: 'trigger',
            label: 'Triggers',
            value: true
          },
          exportVariables: {
            name: 'exportVariables',
            icon: 'variable',
            label: 'Variables',
            value: true
          },
          exportConfiguration: {
            name: 'exportConfiguration',
            icon: 'integrations',
            label: 'Connections',
            value: true
          },
          exportDashboards: {
            name: 'exportDashboards',
            icon: 'dashboard',
            label: 'Dashboards',
            value: true
          },
          exportNotifications: {
            name: 'exportNotifications',
            icon: 'notification-bell',
            label: 'Notifications',
            value: true
          },
          exportSecurity: {
            name: 'exportSecurity',
            icon: 'user-security',
            label: 'Teams & permissions',
            value: false
          }
        }
      }
    },
    versionedFileNames: [],
    selectedFilename: '',
    versioningStyles: {}
  };
};
var folderVersioningReducer = exports.folderVersioningReducer = function folderVersioningReducer() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;
  switch (action.type) {
    case _folderVersioning.actionTypes.INITIALIZE_VERSION_LIST_REQUESTED:
      {
        return _objectSpread(_objectSpread({}, initialState()), {}, {
          needsRefetch: state.needsRefetch,
          listLoading: true
        });
      }
    case _folderVersioning.actionTypes.CLEANUP_VERSION_LIST_REQUESTED:
      {
        return _objectSpread({}, initialState());
      }
    case _folderVersioning.actionTypes.INITIALIZE_VERSION_LIST_FINISHED:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          folder: action.payload.folder,
          configuration: action.payload.configuration,
          dateTimeFormat: {
            date: action.payload.dateTimeFormats.mediumDate,
            time: action.payload.dateTimeFormats.mediumTime
          },
          hasValidationWarnings: action.payload.hasValidationWarnings,
          listLoading: false
        });
      }
    case _folderVersioning.actionTypes.LOAD_VERSIONS_REQUESTED:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          loadingVersions: true,
          needsRefetch: false
        });
      }
    case _folderVersioning.actionTypes.LOAD_VERSIONS_SUCCEEDED:
      {
        var _action$payload = action.payload,
          fetched = _action$payload.fetched,
          versions = _action$payload.versions,
          configuration = _action$payload.configuration;
        var conf = (0, _isUndefined.default)(configuration) ? state.configuration : configuration;
        return _objectSpread(_objectSpread({}, state), {}, {
          versions: versions,
          configuration: _objectSpread(_objectSpread({}, conf), {}, {
            lastFetched: fetched
          })
        });
      }
    case _folderVersioning.actionTypes.LOAD_VERSIONS_FAILED:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          versions: action.payload ? state.versions : initialState().versions
        });
      }
    case _folderVersioning.actionTypes.LOAD_VERSIONS_FINISHED:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          loadingVersions: false
        });
      }
    case _folderVersioning.actionTypes.LOAD_VERSION_CODE_SUCCEEDED:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          versionedFileNames: action.payload.fileNames,
          selectedFilename: action.payload.fileNames[0],
          codePreviewOpen: true
        });
      }
    case _folderVersioning.actionTypes.LOAD_VERSION_CODE_FAILED:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          code: undefined,
          selectedFilename: undefined,
          codePreviewOpen: false
        });
      }
    case _folderVersioning.actionTypes.LOAD_VERSION_FILE_SUCCEEDED:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          code: action.payload.code,
          selectedFilename: action.payload.selectedFilename,
          codePreviewOpen: true
        });
      }
    case _folderVersioning.actionTypes.LOAD_VERSION_FILE_FAILED:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          code: undefined,
          selectedFilename: undefined,
          codePreviewOpen: false
        });
      }
    case _folderVersioning.actionTypes.CLOSE_CODE_PREVIEW:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          codePreviewOpen: false
        });
      }
    case _folderVersioning.actionTypes.CHANGE_VALIDATION_TAB:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          validationTab: action.payload
        });
      }
    case _folderVersioning.actionTypes.OPEN_NEW_VERSION_MODAL:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          validation: action.payload,
          modalOpen: true
        });
      }
    case _folderVersioning.actionTypes.CLOSE_NEW_VERSION_MODAL:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          validation: initialState().validation,
          validationTab: initialState().validationTab,
          modalOpen: false,
          versionForm: initialState().versionForm,
          showVersionFormStatus: initialState().showVersionFormStatus
        });
      }
    case _folderVersioning.actionTypes.UPDATE_VERSION_FORM:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          versionForm: _objectSpread(_objectSpread({}, action.payload), {}, {
            valid: !(0, _some.default)(action.payload.field, ['valid', false])
          })
        });
      }
    case _folderVersioning.actionTypes.CREATE_VERSION_REQUESTED:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          loading: true
        });
      }
    case _folderVersioning.actionTypes.CREATE_VERSION_FINISHED:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          loading: false
        });
      }
    case _folderVersioning.actionTypes.APPLY_VERSION_SUCCEEDED:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          configuration: _objectSpread(_objectSpread({}, state.configuration), {}, {
            appliedVersion: action.payload
          })
        });
      }
    case _folderVersioning.actionTypes.INITIALIZE_CONFIGURATION_FORM_REQUESTED:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          formProcessing: true
        });
      }
    case _folderVersioning.actionTypes.INITIALIZE_CONFIGURATION_FORM_SUCCEEDED:
      {
        var _action$payload2 = action.payload,
          folder = _action$payload2.folder,
          gitConnections = _action$payload2.gitConnections,
          _configuration = _action$payload2.configuration,
          confId = _action$payload2.confId,
          hasConfEditPermission = _action$payload2.hasConfEditPermission,
          isVersionsAvailable = _action$payload2.isVersionsAvailable,
          versioningStyles = _action$payload2.versioningStyles;
        return _objectSpread(_objectSpread({}, state), {}, {
          folder: folder,
          gitConnections: gitConnections,
          versioningConfigurationForm: (0, _isUndefined.default)(confId) ? (0, _isUndefined.default)(_configuration) ? mapConfigurationCreateForm(folder) : mapConfigurationEditForm(_configuration, gitConnections) : mapConfigurationInProgressForm(confId, state.versioningConfigurationForm, gitConnections),
          hasConfEditPermission: hasConfEditPermission,
          formProcessing: false,
          isVersionsAvailable: isVersionsAvailable,
          versioningStyles: versioningStyles,
          codePreviewOpen: false
        });
      }
    case _folderVersioning.actionTypes.UPDATE_CONFIGURATION_FORM:
      {
        var _action$payload3 = action.payload,
          path = _action$payload3.path,
          value = _action$payload3.value;
        return _objectSpread(_objectSpread({}, state), {}, {
          versioningConfigurationForm: updateFormPropertyValue(state.versioningConfigurationForm, path, value)
        });
      }
    case _folderVersioning.actionTypes.CREATE_CONFIGURATION_SUCCEEDED:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          needsRefetch: true
        });
      }
    case _folderVersioning.actionTypes.ERROR_DISPLAY_MODAL:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          errors: action.payload.errors,
          errorModalOpen: true
        });
      }
    case _folderVersioning.actionTypes.CLOSE_ERROR_DISPLAY_MODAL:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          errors: initialState().errors,
          errorModalOpen: false
        });
      }
    case _folderVersioning.actionTypes.VERSION_FORMAT_ERROR_DISPLAY_HELPER:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          displayVersionError: true
        });
      }
    case _folderVersioning.actionTypes.RESET_INITIAL_VERSION_HELPER_STATE:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          displayVersionError: initialState().displayVersionError
        });
      }
    case _folderVersioning.actionTypes.DESCRIPTION_INVALID_DISPLAY_HELPER:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          displayDescriptionVersionError: true
        });
      }
    case _folderVersioning.actionTypes.RESET_INITIAL_DESCRIPTION_HELPER_STATE:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          displayDescriptionVersionError: initialState().displayDescriptionVersionError
        });
      }
    case _folderVersioning.actionTypes.SHOW_VERSION_FORM_STATUS:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          showVersionFormStatus: true
        });
      }
    case _folderVersioning.actionTypes.CLOSE_VERSION_FORM_STATUS:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          showVersionFormStatus: false
        });
      }
    case _folderVersioning.actionTypes.CHANGE_FOLDER_VALIDATION_TAB:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          folderValidationTab: action.payload
        });
      }
    case _folderVersioning.actionTypes.OPEN_FOLDER_VALIDATION_MODAL:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          folderValidations: action.payload,
          folderValidationModelOpen: true
        });
      }
    case _folderVersioning.actionTypes.CLOSE_FOLDER_VALIDATION_MODAL:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          folderValidations: initialState().folderValidations,
          validationTab: initialState().folderValidationTab,
          folderValidationModelOpen: false
        });
      }
    case _folderVersioning.actionTypes.UPDATE_FOLDER_VALIDATION_WARNING_STATE:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          hasValidationWarnings: action.payload
        });
      }
    default:
      return state;
  }
};
var mapConfigurationCreateForm = function mapConfigurationCreateForm(folder) {
  var form = initialState().versioningConfigurationForm;
  var formattedFolderName = (0, _upperFirst.default)((0, _camelCase.default)((0, _deburr.default)(folder.title)));
  form.field.scmPath.value = formattedFolderName;
  return form;
};
var mapConfigurationEditForm = function mapConfigurationEditForm(conf, gitConnections) {
  var form = initialState().versioningConfigurationForm;
  form.field.scmPath.value = conf.scmPath;
  form.field.versioningStyle.value = conf.versioningStyle;
  form.field.branch.value = conf.branch;
  var connection = (0, _find.default)(gitConnections, ['id', conf.gitConnection]);
  if (!(0, _isUndefined.default)(connection)) {
    form.field.gitConnection.value = connection;
  }
  form.field.exports.exportTemplates.value = conf.exportTemplates;
  form.field.exports.exportWorkflows.value = conf.exportWorkflows;
  form.field.exports.exportPatterns.value = conf.exportPatterns;
  form.field.exports.exportTriggers.value = conf.exportTriggers;
  form.field.exports.exportVariables.value = conf.exportVariables;
  form.field.exports.exportConfiguration.value = conf.exportConfiguration;
  form.field.exports.exportDashboards.value = conf.exportDashboards;
  form.field.exports.exportNotifications.value = conf.exportNotifications;
  form.field.exports.exportSecurity.value = conf.exportSecurity;
  return form;
};
var mapConfigurationInProgressForm = function mapConfigurationInProgressForm(confId, formState, gitConnections) {
  var form = _objectSpread({}, formState);
  var connection = (0, _find.default)(gitConnections, ['id', confId]);
  if (!(0, _isUndefined.default)(connection)) {
    form.field.gitConnection.value = connection;
  }
  return form;
};
var updateFormPropertyValue = function updateFormPropertyValue(form, path, value) {
  var updatedForm = (0, _set.default)(_objectSpread({}, form), path, value);
  updatedForm.valid = !(0, _some.default)(updatedForm.field, ['valid', false]);
  return updatedForm;
};
var reducers = exports.reducers = {
  folderVersioning: folderVersioningReducer
};

/***/ }),

/***/ 61428:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.applySelectedVersion = applySelectedVersion;
exports.combinedSaga = combinedSaga;
exports.createNewVersion = createNewVersion;
exports.fetchConfiguration = fetchConfiguration;
exports.fetchVersions = fetchVersions;
exports.folderVersioningSaga = folderVersioningSaga;
exports.gotToGitConfiguration = gotToGitConfiguration;
exports.hasApplyWarnings = hasApplyWarnings;
exports.initializeConfigurationForm = initializeConfigurationForm;
exports.initializeVersionList = initializeVersionList;
exports.previewSelectedFile = previewSelectedFile;
exports.previewSelectedVersion = previewSelectedVersion;
exports.saveConfiguration = saveConfiguration;
exports.updateValidationMessageStatus = updateValidationMessageStatus;
exports.validateAppliedFolderState = validateAppliedFolderState;
exports.validateCurrentFolderState = validateCurrentFolderState;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _effects = __webpack_require__(34857);
var _react = _interopRequireDefault(__webpack_require__(87363));
var _mapValues = _interopRequireDefault(__webpack_require__(66604));
var _isUndefined = _interopRequireDefault(__webpack_require__(52353));
var _isEmpty = _interopRequireDefault(__webpack_require__(41609));
var _folderVersioning = __webpack_require__(55170);
var _folderVersioning2 = __webpack_require__(50727);
var _folderVersioning3 = __webpack_require__(8897);
var _angularAccessor = _interopRequireDefault(__webpack_require__(81403));
var _sagas = __webpack_require__(86157);
var _toastrFactory = _interopRequireDefault(__webpack_require__(86846));
var _permissionsConstants = __webpack_require__(88169);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var _marked = /*#__PURE__*/_regenerator.default.mark(initializeVersionList),
  _marked2 = /*#__PURE__*/_regenerator.default.mark(initializeConfigurationForm),
  _marked3 = /*#__PURE__*/_regenerator.default.mark(fetchConfiguration),
  _marked4 = /*#__PURE__*/_regenerator.default.mark(fetchVersions),
  _marked5 = /*#__PURE__*/_regenerator.default.mark(previewSelectedVersion),
  _marked6 = /*#__PURE__*/_regenerator.default.mark(previewSelectedFile),
  _marked7 = /*#__PURE__*/_regenerator.default.mark(saveConfiguration),
  _marked8 = /*#__PURE__*/_regenerator.default.mark(gotToGitConfiguration),
  _marked9 = /*#__PURE__*/_regenerator.default.mark(createNewVersion),
  _marked10 = /*#__PURE__*/_regenerator.default.mark(applySelectedVersion),
  _marked11 = /*#__PURE__*/_regenerator.default.mark(validateCurrentFolderState),
  _marked12 = /*#__PURE__*/_regenerator.default.mark(validateAppliedFolderState),
  _marked13 = /*#__PURE__*/_regenerator.default.mark(updateValidationMessageStatus),
  _marked14 = /*#__PURE__*/_regenerator.default.mark(folderVersioningSaga),
  _marked15 = /*#__PURE__*/_regenerator.default.mark(combinedSaga);
var toaster = (0, _toastrFactory.default)();
function initializeVersionList(action) {
  var folder, configuration, locale, folderValidationsWarnings, hasValidationWarnings, needsRefetch;
  return _regenerator.default.wrap(function initializeVersionList$(_context) {
    while (1) switch (_context.prev = _context.next) {
      case 0:
        folder = action.payload;
        _context.next = 3;
        return (0, _effects.call)(fetchConfiguration, folder.id);
      case 3:
        configuration = _context.sent;
        _context.next = 6;
        return (0, _effects.call)(_angularAccessor.default, '$locale');
      case 6:
        locale = _context.sent;
        _context.next = 9;
        return (0, _effects.call)(_folderVersioning3.getValidationMessages, folder.id);
      case 9:
        folderValidationsWarnings = _context.sent;
        hasValidationWarnings = hasApplyWarnings(folderValidationsWarnings.data.warnings);
        _context.next = 13;
        return (0, _effects.put)((0, _folderVersioning.initVersionListFinished)({
          folder: folder,
          configuration: configuration,
          dateTimeFormats: locale.DATETIME_FORMATS,
          hasValidationWarnings: hasValidationWarnings
        }));
      case 13:
        if ((0, _isUndefined.default)(configuration)) {
          _context.next = 19;
          break;
        }
        _context.next = 16;
        return (0, _effects.select)(_folderVersioning2.getNeedsRefetch);
      case 16:
        needsRefetch = _context.sent;
        _context.next = 19;
        return (0, _effects.put)((0, _folderVersioning.loadVersions)(needsRefetch));
      case 19:
      case "end":
        return _context.stop();
    }
  }, _marked);
}
function initializeConfigurationForm(action) {
  var folder, location, authenticator, hasConfEditPermission, configuration, gitConfsResponse, versioningStyles, isVersionsAvailable, resp;
  return _regenerator.default.wrap(function initializeConfigurationForm$(_context2) {
    while (1) switch (_context2.prev = _context2.next) {
      case 0:
        folder = action.payload;
        _context2.next = 3;
        return (0, _effects.call)(_angularAccessor.default, '$location');
      case 3:
        location = _context2.sent;
        _context2.next = 6;
        return (0, _effects.call)(_angularAccessor.default, 'Authenticator');
      case 6:
        authenticator = _context2.sent;
        hasConfEditPermission = authenticator.hasPermission(_permissionsConstants.Permissions.EDIT_FOLDER_CONFIGURATION, folder);
        _context2.next = 10;
        return (0, _effects.call)(fetchConfiguration, folder.id);
      case 10:
        configuration = _context2.sent;
        _context2.next = 13;
        return (0, _effects.call)(_folderVersioning3.getGitConfigurations, folder.id);
      case 13:
        gitConfsResponse = _context2.sent;
        _context2.next = 16;
        return (0, _effects.call)(_folderVersioning3.getVersioningStyles);
      case 16:
        versioningStyles = _context2.sent;
        isVersionsAvailable = false;
        if (!configuration) {
          _context2.next = 23;
          break;
        }
        _context2.next = 21;
        return (0, _effects.call)(_folderVersioning3.getVersions, folder.id, false);
      case 21:
        resp = _context2.sent;
        isVersionsAvailable = !(0, _isEmpty.default)(resp.data) ? resp.data.versions.length > 0 : false;
      case 23:
        _context2.next = 25;
        return (0, _effects.put)((0, _folderVersioning.initVersioningConfigurationFormSucceed)(folder, gitConfsResponse.data, configuration, location.search().conf, hasConfEditPermission, isVersionsAvailable, versioningStyles.data));
      case 25:
      case "end":
        return _context2.stop();
    }
  }, _marked2);
}
function fetchConfiguration(folderId) {
  var resp;
  return _regenerator.default.wrap(function fetchConfiguration$(_context3) {
    while (1) switch (_context3.prev = _context3.next) {
      case 0:
        _context3.next = 2;
        return (0, _effects.call)(_folderVersioning3.getConfiguration, folderId);
      case 2:
        resp = _context3.sent;
        return _context3.abrupt("return", !(0, _isEmpty.default)(resp.data) ? resp.data : undefined);
      case 4:
      case "end":
        return _context3.stop();
    }
  }, _marked3);
}
function fetchVersions(action) {
  var folderId, configuration, resp;
  return _regenerator.default.wrap(function fetchVersions$(_context4) {
    while (1) switch (_context4.prev = _context4.next) {
      case 0:
        _context4.next = 2;
        return (0, _effects.select)(_folderVersioning2.getFolderId);
      case 2:
        folderId = _context4.sent;
        _context4.prev = 3;
        configuration = undefined;
        _context4.next = 7;
        return (0, _effects.call)(_folderVersioning3.getVersions, folderId, action.payload.fetchChanges);
      case 7:
        resp = _context4.sent;
        if (!action.payload.fetchChanges) {
          _context4.next = 12;
          break;
        }
        _context4.next = 11;
        return (0, _effects.call)(fetchConfiguration, folderId);
      case 11:
        configuration = _context4.sent;
      case 12:
        _context4.next = 14;
        return (0, _effects.put)((0, _folderVersioning.loadVersionSucceed)(resp.data, configuration));
      case 14:
        _context4.next = 20;
        break;
      case 16:
        _context4.prev = 16;
        _context4.t0 = _context4["catch"](3);
        _context4.next = 20;
        return (0, _effects.put)((0, _folderVersioning.loadVersionFailed)(action.payload.fetchChanges));
      case 20:
        _context4.prev = 20;
        _context4.next = 23;
        return (0, _effects.put)((0, _folderVersioning.loadVersionFinished)());
      case 23:
        return _context4.finish(20);
      case 24:
      case "end":
        return _context4.stop();
    }
  }, _marked4, null, [[3, 16, 20, 24]]);
}
function previewSelectedVersion(action) {
  var folderId, versionedFilenames, versionName;
  return _regenerator.default.wrap(function previewSelectedVersion$(_context5) {
    while (1) switch (_context5.prev = _context5.next) {
      case 0:
        _context5.next = 2;
        return (0, _effects.select)(_folderVersioning2.getFolderId);
      case 2:
        folderId = _context5.sent;
        _context5.prev = 3;
        versionName = action.payload.versionName;
        if (!(0, _isUndefined.default)(versionName)) {
          _context5.next = 11;
          break;
        }
        _context5.next = 8;
        return (0, _effects.call)(_folderVersioning3.getVersionedFileNamesOfCurrentState, folderId);
      case 8:
        versionedFilenames = _context5.sent;
        _context5.next = 14;
        break;
      case 11:
        _context5.next = 13;
        return (0, _effects.call)(_folderVersioning3.getVersionedFileNamesOfSelectedVersion, folderId, versionName);
      case 13:
        versionedFilenames = _context5.sent;
      case 14:
        _context5.next = 16;
        return (0, _effects.put)((0, _folderVersioning.loadCodeSucceed)(versionedFilenames.data));
      case 16:
        _context5.next = 22;
        break;
      case 18:
        _context5.prev = 18;
        _context5.t0 = _context5["catch"](3);
        _context5.next = 22;
        return (0, _effects.put)((0, _folderVersioning.loadCodeFailed)());
      case 22:
      case "end":
        return _context5.stop();
    }
  }, _marked5, null, [[3, 18]]);
}
function previewSelectedFile(action) {
  var folderId, selectedFilename, resp, versionName;
  return _regenerator.default.wrap(function previewSelectedFile$(_context6) {
    while (1) switch (_context6.prev = _context6.next) {
      case 0:
        _context6.next = 2;
        return (0, _effects.select)(_folderVersioning2.getFolderId);
      case 2:
        folderId = _context6.sent;
        selectedFilename = action.payload.fileName;
        _context6.prev = 4;
        versionName = action.payload.versionName;
        if (!(0, _isUndefined.default)(versionName)) {
          _context6.next = 12;
          break;
        }
        _context6.next = 9;
        return (0, _effects.call)(_folderVersioning3.previewCurrentState, folderId, selectedFilename);
      case 9:
        resp = _context6.sent;
        _context6.next = 15;
        break;
      case 12:
        _context6.next = 14;
        return (0, _effects.call)(_folderVersioning3.previewVersion, folderId, versionName, selectedFilename);
      case 14:
        resp = _context6.sent;
      case 15:
        _context6.next = 17;
        return (0, _effects.put)((0, _folderVersioning.loadFileSucceed)(resp.data, selectedFilename));
      case 17:
        _context6.next = 23;
        break;
      case 19:
        _context6.prev = 19;
        _context6.t0 = _context6["catch"](4);
        _context6.next = 23;
        return (0, _effects.put)((0, _folderVersioning.loadFileFailed)());
      case 23:
      case "end":
        return _context6.stop();
    }
  }, _marked6, null, [[4, 19]]);
}
function saveConfiguration(action) {
  var folderId, _yield$select, field, model;
  return _regenerator.default.wrap(function saveConfiguration$(_context7) {
    while (1) switch (_context7.prev = _context7.next) {
      case 0:
        _context7.next = 2;
        return (0, _effects.select)(_folderVersioning2.getFolderId);
      case 2:
        folderId = _context7.sent;
        _context7.next = 5;
        return (0, _effects.select)(_folderVersioning2.getVersioningConfigurationForm);
      case 5:
        _yield$select = _context7.sent;
        field = _yield$select.field;
        model = _objectSpread({
          id: null,
          type: 'xlrelease.FolderVersioningSettings',
          scmPath: field.scmPath.value,
          branch: field.branch.value,
          versioningStyle: field.versioningStyle.value,
          gitConnection: field.gitConnection.value.id
        }, (0, _mapValues.default)(field.exports, 'value'));
        _context7.prev = 8;
        _context7.next = 11;
        return (0, _effects.call)(_folderVersioning3.createConfiguration, folderId, model);
      case 11:
        _context7.next = 13;
        return (0, _effects.call)(_sagas.removeConfirmLeavePopup);
      case 13:
        _context7.next = 15;
        return (0, _effects.put)((0, _folderVersioning.saveConfigurationSuceeded)());
      case 15:
        action.payload.callbackFn();
        _context7.next = 22;
        break;
      case 18:
        _context7.prev = 18;
        _context7.t0 = _context7["catch"](8);
        _context7.next = 22;
        return (0, _effects.put)((0, _folderVersioning.saveConfigurationFailed)());
      case 22:
      case "end":
        return _context7.stop();
    }
  }, _marked7, null, [[8, 18]]);
}
function gotToGitConfiguration() {
  var folderId, location, rootScope;
  return _regenerator.default.wrap(function gotToGitConfiguration$(_context8) {
    while (1) switch (_context8.prev = _context8.next) {
      case 0:
        _context8.next = 2;
        return (0, _effects.select)(_folderVersioning2.getFolderId);
      case 2:
        folderId = _context8.sent;
        _context8.next = 5;
        return (0, _effects.call)(_angularAccessor.default, '$location');
      case 5:
        location = _context8.sent;
        _context8.next = 8;
        return (0, _effects.call)(_angularAccessor.default, '$rootScope');
      case 8:
        rootScope = _context8.sent;
        location.url("/folders/".concat(folderId, "/configuration?confType=git.Repository"));
        rootScope.$digest();
      case 11:
      case "end":
        return _context8.stop();
    }
  }, _marked8);
}
function createNewVersion() {
  var folderId, _yield$select2, field, model, resp, validationMessageResp;
  return _regenerator.default.wrap(function createNewVersion$(_context9) {
    while (1) switch (_context9.prev = _context9.next) {
      case 0:
        _context9.next = 2;
        return (0, _effects.select)(_folderVersioning2.getFolderId);
      case 2:
        folderId = _context9.sent;
        _context9.next = 5;
        return (0, _effects.select)(_folderVersioning2.getVersionForm);
      case 5:
        _yield$select2 = _context9.sent;
        field = _yield$select2.field;
        model = (0, _mapValues.default)(field, 'value');
        _context9.prev = 8;
        _context9.next = 11;
        return (0, _effects.call)(_folderVersioning3.createVersion, folderId, model);
      case 11:
        resp = _context9.sent;
        _context9.next = 14;
        return (0, _effects.put)((0, _folderVersioning.closeNewVersionModal)());
      case 14:
        _context9.next = 16;
        return (0, _effects.put)((0, _folderVersioning.loadVersions)(false));
      case 16:
        _context9.next = 18;
        return (0, _effects.put)((0, _folderVersioning.applyVersionSucceed)(resp.data.name));
      case 18:
        _context9.next = 20;
        return (0, _effects.call)(_folderVersioning3.getValidationMessages, folderId);
      case 20:
        validationMessageResp = _context9.sent;
        _context9.next = 23;
        return (0, _effects.put)((0, _folderVersioning.updateFolderValidationWarningState)(hasApplyWarnings(validationMessageResp.data.warnings)));
      case 23:
        _context9.next = 27;
        break;
      case 25:
        _context9.prev = 25;
        _context9.t0 = _context9["catch"](8);
      case 27:
        _context9.prev = 27;
        _context9.next = 30;
        return (0, _effects.put)((0, _folderVersioning.createVersionFinished)());
      case 30:
        return _context9.finish(27);
      case 31:
      case "end":
        return _context9.stop();
    }
  }, _marked9, null, [[8, 25, 27, 31]]);
}
function applySelectedVersion(action) {
  var version, folderId, resp, hasWarning;
  return _regenerator.default.wrap(function applySelectedVersion$(_context10) {
    while (1) switch (_context10.prev = _context10.next) {
      case 0:
        version = action.payload;
        _context10.next = 3;
        return (0, _effects.select)(_folderVersioning2.getFolderId);
      case 3:
        folderId = _context10.sent;
        _context10.prev = 4;
        _context10.next = 7;
        return (0, _effects.call)(_folderVersioning3.applyVersion, folderId, version);
      case 7:
        _context10.next = 9;
        return (0, _effects.call)(_folderVersioning3.getValidationMessages, folderId);
      case 9:
        resp = _context10.sent;
        hasWarning = hasApplyWarnings(resp.data.warnings);
        if (hasWarning) {
          toaster.warning("Version ".concat(version, " has been applied with warnings"));
        } else {
          toaster.success("Version ".concat(version, " has been successfully applied"));
        }
        _context10.next = 14;
        return (0, _effects.put)((0, _folderVersioning.updateFolderValidationWarningState)(hasWarning));
      case 14:
        _context10.next = 16;
        return (0, _effects.put)((0, _folderVersioning.applyVersionSucceed)(version));
      case 16:
        _context10.next = 18;
        return (0, _effects.call)(validateAppliedFolderState);
      case 18:
        _context10.next = 22;
        break;
      case 20:
        _context10.prev = 20;
        _context10.t0 = _context10["catch"](4);
      case 22:
      case "end":
        return _context10.stop();
    }
  }, _marked10, null, [[4, 20]]);
}
function validateCurrentFolderState(action) {
  var folderId, resp;
  return _regenerator.default.wrap(function validateCurrentFolderState$(_context11) {
    while (1) switch (_context11.prev = _context11.next) {
      case 0:
        _context11.next = 2;
        return (0, _effects.select)(_folderVersioning2.getFolderId);
      case 2:
        folderId = _context11.sent;
        _context11.prev = 3;
        _context11.next = 6;
        return (0, _effects.call)(_folderVersioning3.validateCurrentState, folderId);
      case 6:
        resp = _context11.sent;
        _context11.next = 9;
        return (0, _effects.put)((0, _folderVersioning.openNewVersionModal)(resp.data));
      case 9:
        _context11.next = 14;
        break;
      case 11:
        _context11.prev = 11;
        _context11.t0 = _context11["catch"](3);
        toaster.error("Failed validating current state of the folder. ".concat(_context11.t0));
      case 14:
      case "end":
        return _context11.stop();
    }
  }, _marked11, null, [[3, 11]]);
}
function validateAppliedFolderState(action) {
  var folderId, resp;
  return _regenerator.default.wrap(function validateAppliedFolderState$(_context12) {
    while (1) switch (_context12.prev = _context12.next) {
      case 0:
        _context12.next = 2;
        return (0, _effects.select)(_folderVersioning2.getFolderId);
      case 2:
        folderId = _context12.sent;
        _context12.prev = 3;
        _context12.next = 6;
        return (0, _effects.call)(_folderVersioning3.getValidationMessages, folderId);
      case 6:
        resp = _context12.sent;
        if (!hasApplyWarnings(resp.data.warnings)) {
          _context12.next = 10;
          break;
        }
        _context12.next = 10;
        return (0, _effects.put)((0, _folderVersioning.openFolderValidationModal)(resp.data));
      case 10:
        _context12.next = 15;
        break;
      case 12:
        _context12.prev = 12;
        _context12.t0 = _context12["catch"](3);
        toaster.error("Failed to validate applied version for the folder. ".concat(_context12.t0));
      case 15:
      case "end":
        return _context12.stop();
    }
  }, _marked12, null, [[3, 12]]);
}
function updateValidationMessageStatus(action) {
  var warning, folderId;
  return _regenerator.default.wrap(function updateValidationMessageStatus$(_context13) {
    while (1) switch (_context13.prev = _context13.next) {
      case 0:
        warning = action.payload;
        _context13.next = 3;
        return (0, _effects.select)(_folderVersioning2.getFolderId);
      case 3:
        folderId = _context13.sent;
        _context13.prev = 4;
        _context13.next = 7;
        return (0, _effects.call)(_folderVersioning3.setValidationMessageStatus, folderId, warning.messageId, warning);
      case 7:
        _context13.next = 12;
        break;
      case 9:
        _context13.prev = 9;
        _context13.t0 = _context13["catch"](4);
        toaster.error("Failed to update folder validation message resolved status. ".concat(_context13.t0));
      case 12:
      case "end":
        return _context13.stop();
    }
  }, _marked13, null, [[4, 9]]);
}
function hasApplyWarnings(warnings) {
  var hasApplyWarning = false;
  warnings.forEach(function (value, key) {
    if (value.messageType !== 'HARDCODED_PASSWORD') {
      hasApplyWarning = true;
    }
  });
  return hasApplyWarning;
}
function folderVersioningSaga() {
  return _regenerator.default.wrap(function folderVersioningSaga$(_context14) {
    while (1) switch (_context14.prev = _context14.next) {
      case 0:
        _context14.next = 2;
        return (0, _effects.all)([(0, _effects.takeLatest)(_folderVersioning.actionTypes.INITIALIZE_VERSION_LIST_REQUESTED, initializeVersionList), (0, _effects.takeLatest)(_folderVersioning.actionTypes.INITIALIZE_CONFIGURATION_FORM_REQUESTED, initializeConfigurationForm), (0, _effects.takeLatest)(_folderVersioning.actionTypes.CREATE_CONFIGURATION_REQUESTED, saveConfiguration), (0, _effects.takeLatest)(_folderVersioning.actionTypes.ADD_CONFIGURATION_FORM_CONFIRMATION_POPUP, _sagas.addConfirmLeavePopup), (0, _effects.takeLatest)(_folderVersioning.actionTypes.REMOVE_CONFIGURATION_FORM_CONFIRMATION_POPUP, _sagas.removeConfirmLeavePopup), (0, _effects.takeLatest)(_folderVersioning.actionTypes.GO_TO_GIT_CONFIGURATION_FORM, gotToGitConfiguration), (0, _effects.takeLatest)(_folderVersioning.actionTypes.LOAD_VERSIONS_REQUESTED, fetchVersions), (0, _effects.takeLatest)(_folderVersioning.actionTypes.LOAD_VERSION_CODE_REQUESTED, previewSelectedVersion), (0, _effects.takeLatest)(_folderVersioning.actionTypes.LOAD_VERSION_FILE_REQUESTED, previewSelectedFile), (0, _effects.takeLatest)(_folderVersioning.actionTypes.CREATE_VERSION_REQUESTED, createNewVersion), (0, _effects.takeLatest)(_folderVersioning.actionTypes.APPLY_VERSION_REQUESTED, applySelectedVersion), (0, _effects.takeLatest)(_folderVersioning.actionTypes.VALIDATE_CURRENT_FOLDER_STATE, validateCurrentFolderState), (0, _effects.takeLatest)(_folderVersioning.actionTypes.VALIDATE_APPLIED_FOLDER_STATE, validateAppliedFolderState), (0, _effects.takeLatest)(_folderVersioning.actionTypes.UPDATE_VALIDATION_MESSAGE_STATUS, updateValidationMessageStatus)]);
      case 2:
      case "end":
        return _context14.stop();
    }
  }, _marked14);
}
function combinedSaga() {
  return _regenerator.default.wrap(function combinedSaga$(_context15) {
    while (1) switch (_context15.prev = _context15.next) {
      case 0:
        if (false) {}
        _context15.prev = 1;
        _context15.next = 4;
        return (0, _effects.all)([(0, _effects.call)(folderVersioningSaga)]);
      case 4:
        _context15.next = 9;
        break;
      case 6:
        _context15.prev = 6;
        _context15.t0 = _context15["catch"](1);
        /* eslint-disable no-console, angular/log */
        console.error('Folder version control report saga:', _context15.t0);
        /* eslint-enable */
      case 9:
        _context15.next = 0;
        break;
      case 11:
      case "end":
        return _context15.stop();
    }
  }, _marked15, null, [[1, 6]]);
}

/***/ }),

/***/ 50727:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.scmPathModificationWarning = exports.hasVersions = exports.hasConfEditPermission = exports.getVersions = exports.getVersioningStyles = exports.getVersioningConfigurationForm = exports.getVersionedFileNames = exports.getVersionForm = exports.getValidationTab = exports.getValidationDetails = exports.getShowVersionFormStatus = exports.getShowMoreOrLessStatus = exports.getSelectedFilename = exports.getNeedsRefetch = exports.getModalState = exports.getLoadingVersionState = exports.getLoadingState = exports.getListLoadingState = exports.getHasValidationWarnings = exports.getGitConnections = exports.getFormProcessingState = exports.getFolderVersioningSelector = exports.getFolderValidationTab = exports.getFolderValidationModalState = exports.getFolderValidationDetails = exports.getFolderId = exports.getErrors = exports.getErrorModalState = exports.getDisplayVersionError = exports.getDescriptionVersionError = exports.getDateTimeFormat = exports.getConfiguration = exports.getCodePreviewState = exports.getCode = void 0;
var getFolderVersioningSelector = exports.getFolderVersioningSelector = function getFolderVersioningSelector(state) {
  return state.folderVersioning;
};
var getFolderId = exports.getFolderId = function getFolderId(state) {
  return getFolderVersioningSelector(state).folder.id;
};
var getListLoadingState = exports.getListLoadingState = function getListLoadingState(state) {
  return getFolderVersioningSelector(state).listLoading;
};
var getFormProcessingState = exports.getFormProcessingState = function getFormProcessingState(state) {
  return getFolderVersioningSelector(state).formProcessing;
};
var getConfiguration = exports.getConfiguration = function getConfiguration(state) {
  return getFolderVersioningSelector(state).configuration;
};
var getVersions = exports.getVersions = function getVersions(state) {
  return getFolderVersioningSelector(state).versions;
};
var getLoadingVersionState = exports.getLoadingVersionState = function getLoadingVersionState(state) {
  return getFolderVersioningSelector(state).loadingVersions;
};
var getCodePreviewState = exports.getCodePreviewState = function getCodePreviewState(state) {
  return getFolderVersioningSelector(state).codePreviewOpen;
};
var getCode = exports.getCode = function getCode(state) {
  return getFolderVersioningSelector(state).code;
};
var getNeedsRefetch = exports.getNeedsRefetch = function getNeedsRefetch(state) {
  return getFolderVersioningSelector(state).needsRefetch;
};
var getDateTimeFormat = exports.getDateTimeFormat = function getDateTimeFormat(state) {
  return getFolderVersioningSelector(state).dateTimeFormat;
};
var getModalState = exports.getModalState = function getModalState(state) {
  return getFolderVersioningSelector(state).modalOpen;
};
var getLoadingState = exports.getLoadingState = function getLoadingState(state) {
  return getFolderVersioningSelector(state).loading;
};
var getVersionForm = exports.getVersionForm = function getVersionForm(state) {
  return getFolderVersioningSelector(state).versionForm;
};
var getValidationDetails = exports.getValidationDetails = function getValidationDetails(state) {
  return getFolderVersioningSelector(state).validation;
};
var getValidationTab = exports.getValidationTab = function getValidationTab(state) {
  return getFolderVersioningSelector(state).validationTab;
};
var getVersioningConfigurationForm = exports.getVersioningConfigurationForm = function getVersioningConfigurationForm(state) {
  return getFolderVersioningSelector(state).versioningConfigurationForm;
};
var getGitConnections = exports.getGitConnections = function getGitConnections(state) {
  return getFolderVersioningSelector(state).gitConnections;
};
var hasConfEditPermission = exports.hasConfEditPermission = function hasConfEditPermission(state) {
  return getFolderVersioningSelector(state).hasConfEditPermission;
};
var hasVersions = exports.hasVersions = function hasVersions(state) {
  return getFolderVersioningSelector(state).isVersionsAvailable;
};
var scmPathModificationWarning = exports.scmPathModificationWarning = function scmPathModificationWarning(state) {
  return getFolderVersioningSelector(state).scmPathModificationWarning;
};
var getErrorModalState = exports.getErrorModalState = function getErrorModalState(state) {
  return getFolderVersioningSelector(state).errorModalOpen;
};
var getErrors = exports.getErrors = function getErrors(state) {
  return getFolderVersioningSelector(state).errors;
};
var getDisplayVersionError = exports.getDisplayVersionError = function getDisplayVersionError(state) {
  return getFolderVersioningSelector(state).displayVersionError;
};
var getDescriptionVersionError = exports.getDescriptionVersionError = function getDescriptionVersionError(state) {
  return getFolderVersioningSelector(state).displayDescriptionVersionError;
};
var getShowMoreOrLessStatus = exports.getShowMoreOrLessStatus = function getShowMoreOrLessStatus(state) {
  return getFolderVersioningSelector(state).showMoreLessModal;
};
var getShowVersionFormStatus = exports.getShowVersionFormStatus = function getShowVersionFormStatus(state) {
  return getFolderVersioningSelector(state).showVersionFormStatus;
};
var getFolderValidationModalState = exports.getFolderValidationModalState = function getFolderValidationModalState(state) {
  return getFolderVersioningSelector(state).folderValidationModelOpen;
};
var getFolderValidationDetails = exports.getFolderValidationDetails = function getFolderValidationDetails(state) {
  return getFolderVersioningSelector(state).folderValidations;
};
var getFolderValidationTab = exports.getFolderValidationTab = function getFolderValidationTab(state) {
  return getFolderVersioningSelector(state).folderValidationTab;
};
var getHasValidationWarnings = exports.getHasValidationWarnings = function getHasValidationWarnings(state) {
  return getFolderVersioningSelector(state).hasValidationWarnings;
};
var getVersionedFileNames = exports.getVersionedFileNames = function getVersionedFileNames(state) {
  return getFolderVersioningSelector(state).versionedFileNames;
};
var getSelectedFilename = exports.getSelectedFilename = function getSelectedFilename(state) {
  return getFolderVersioningSelector(state).selectedFilename;
};
var getVersioningStyles = exports.getVersioningStyles = function getVersioningStyles(state) {
  return getFolderVersioningSelector(state).versioningStyles;
};

/***/ }),

/***/ 8897:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.validateCurrentState = exports.setValidationMessageStatus = exports.previewVersion = exports.previewCurrentState = exports.getVersions = exports.getVersioningStyles = exports.getVersionedFileNamesOfSelectedVersion = exports.getVersionedFileNamesOfCurrentState = exports.getValidationMessages = exports.getGitConfigurations = exports.getConfiguration = exports.createVersion = exports.createConfiguration = exports.applyVersion = void 0;
var _http = __webpack_require__(26511);
var folderVersioningApi = 'api/v1/folders/versioning';
var getConfiguration = exports.getConfiguration = function getConfiguration(folderId) {
  return (0, _http.httpGET)("api/v1/folders/versioning/".concat(folderId));
};
var createConfiguration = exports.createConfiguration = function createConfiguration(folderId, conf) {
  return (0, _http.httpPUT)("".concat(folderVersioningApi, "/").concat(folderId), conf);
};
var getGitConfigurations = exports.getGitConfigurations = function getGitConfigurations(folderId) {
  return (0, _http.httpGET)("api/v1/config/byTypeAndTitle?configurationType=git.Repository&folderId=".concat(folderId, "&folderOnly=false"));
};
var getVersioningStyles = exports.getVersioningStyles = function getVersioningStyles() {
  return (0, _http.httpGET)("api/v1/folders/versioning/styles");
};
var previewCurrentState = exports.previewCurrentState = function previewCurrentState(folderId, fileName) {
  return (0, _http.httpRequest)('GET', "".concat(folderVersioningApi, "/").concat(folderId, "/preview?filename=").concat(fileName), null, 'text/vnd.yaml');
};
var previewVersion = exports.previewVersion = function previewVersion(folderId, version, fileName) {
  return (0, _http.httpRequest)('GET', "".concat(folderVersioningApi, "/").concat(folderId, "/versions/").concat(version, "/preview?filename=").concat(fileName), null, 'text/vnd.yaml');
};
var getVersionedFileNamesOfCurrentState = exports.getVersionedFileNamesOfCurrentState = function getVersionedFileNamesOfCurrentState(folderId) {
  return (0, _http.httpRequest)('GET', "".concat(folderVersioningApi, "/").concat(folderId, "/getVersionableFileNames"), null);
};
var getVersionedFileNamesOfSelectedVersion = exports.getVersionedFileNamesOfSelectedVersion = function getVersionedFileNamesOfSelectedVersion(folderId, version) {
  return (0, _http.httpRequest)('GET', "".concat(folderVersioningApi, "/").concat(folderId, "/versions/").concat(version, "/getVersionedFileNames"), null);
};
var getVersions = exports.getVersions = function getVersions(folderId) {
  var fetchFromRemote = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return (0, _http.httpGET)("".concat(folderVersioningApi, "/").concat(folderId, "/versions?fetchChanges=").concat(fetchFromRemote));
};
var createVersion = exports.createVersion = function createVersion(folderId, version) {
  return (0, _http.httpPOST)("".concat(folderVersioningApi, "/").concat(folderId, "/versions"), version);
};
var applyVersion = exports.applyVersion = function applyVersion(folderId, version) {
  return (0, _http.httpPOST)("".concat(folderVersioningApi, "/").concat(folderId, "/versions/").concat(version, "/apply"));
};
var validateCurrentState = exports.validateCurrentState = function validateCurrentState(folderId) {
  return (0, _http.httpGET)("".concat(folderVersioningApi, "/").concat(folderId, "/validate"));
};
var getValidationMessages = exports.getValidationMessages = function getValidationMessages(folderId) {
  return (0, _http.httpGET)("".concat(folderVersioningApi, "/").concat(folderId, "/validation-messages"));
};
var setValidationMessageStatus = exports.setValidationMessageStatus = function setValidationMessageStatus(folderId, messageId, message) {
  return (0, _http.httpPUT)("".concat(folderVersioningApi, "/").concat(folderId, "/message/").concat(messageId, "/update"), message);
};

/***/ }),

/***/ 85011:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.store = void 0;
var _folderVersioning = __webpack_require__(61428);
var _folderVersioning2 = __webpack_require__(93395);
var _appConfig = __webpack_require__(89887);
/* global window */

var store = exports.store = store || (0, _appConfig.enhanceStore)(_folderVersioning2.reducers, _folderVersioning.combinedSaga);

/***/ }),

/***/ 32203:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.requiredSelectValueValidator = exports.maxLengthValidator = exports.gitRefnameValidator = void 0;
var createErrorMessage = function createErrorMessage(text) {
  return {
    show: false,
    text: text,
    type: 'ERROR'
  };
};
var validateSelectValue = function validateSelectValue(input) {
  var propertyName = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  return _.isEmpty(_.get(input, propertyName));
};
var validateMaxLength = function validateMaxLength(inputText, maxLength) {
  return inputText && inputText.trim().length > maxLength;
};
var checkRefFormat = function checkRefFormat(refName) {
  var len = refName.length;
  if (len === 0) return false;
  if (refName.endsWith('.lock')) return false;
  var components = 1;
  var p = '\0';
  for (var i = 0; i < len; i++) {
    var c = refName.charAt(i);
    if (c <= ' ') return false;
    switch (c) {
      case '.':
        if (i === len - 1 || ['\0', '/', '.'].includes(p)) return false;
        break;
      case '/':
        if (i === 0 || i === len - 1) return false;
        if (p === '/') return false;
        components++;
        break;
      case '{':
        if (p === '@') return false;
        break;
      case '~':
      case '^':
      case ':':
      case '?':
      case '[':
      case '*':
      case '\\':
      case "\x7F":
        return false;
      default:
        _.noop();
    }
    p = c;
  }
  return components > 1;
};

// --- VALIDATORS ---
var requiredSelectValueValidator = exports.requiredSelectValueValidator = function requiredSelectValueValidator(propertyName) {
  return function (input) {
    return {
      condition: validateSelectValue(input, propertyName),
      message: createErrorMessage("This field is required")
    };
  };
};
var maxLengthValidator = exports.maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: validateMaxLength(inputText, maxLength),
      message: createErrorMessage("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};
var gitRefnameValidator = exports.gitRefnameValidator = function gitRefnameValidator(refPrefix, errorMessage) {
  return function (inputText) {
    return {
      condition: inputText.length > 0 && !checkRefFormat("".concat(refPrefix, "/").concat(inputText)),
      message: createErrorMessage(errorMessage)
    };
  };
};

/***/ }),

/***/ 19887:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FolderVersioningPage = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _folderVersioning = __webpack_require__(85011);
var _folderVersioning2 = __webpack_require__(16705);
var _folderVersioningList = __webpack_require__(93217);
var _folderVersioningConfiguration = __webpack_require__(47934);
var FolderVersioningPageContainer = function FolderVersioningPageContainer(_ref) {
  var folder = _ref.folder,
    canEdit = _ref.canEdit,
    canApply = _ref.canApply,
    canCreate = _ref.canCreate,
    view = _ref.view,
    onViewChange = _ref.onViewChange;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "folder-details"
  }, view === _folderVersioning2.viewMode.view ? /*#__PURE__*/_react.default.createElement(_folderVersioningList.FolderVersioningListComponent, {
    canApply: canApply,
    canCreate: canCreate,
    canEdit: canEdit,
    folder: folder,
    onViewChange: onViewChange
  }) : /*#__PURE__*/_react.default.createElement(_folderVersioningConfiguration.FolderVersioningConfigurationComponent, {
    folder: folder,
    onViewChange: onViewChange
  }));
};
FolderVersioningPageContainer.propTypes = {
  canApply: _propTypes.default.bool.isRequired,
  canCreate: _propTypes.default.bool.isRequired,
  canEdit: _propTypes.default.bool.isRequired,
  folder: _propTypes.default.object.isRequired,
  onViewChange: _propTypes.default.func.isRequired,
  view: _propTypes.default.string.isRequired
};
var FolderVersioningPage = exports.FolderVersioningPage = function FolderVersioningPage(props) {
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _folderVersioning.store
  }, /*#__PURE__*/_react.default.createElement(FolderVersioningPageContainer, props));
};
FolderVersioningPage.propTypes = {
  canApply: _propTypes.default.bool.isRequired,
  canCreate: _propTypes.default.bool.isRequired,
  canEdit: _propTypes.default.bool.isRequired,
  folder: _propTypes.default.object.isRequired,
  onViewChange: _propTypes.default.func.isRequired,
  view: _propTypes.default.string.isRequired
};

/***/ }),

/***/ 72194:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _folderVersioning = __webpack_require__(16705);
var _permissionsConstants = __webpack_require__(88169);
var template = "\n    <div style=\"height: 100%\">\n        <ng-container ng-if=\"$ctrl.selectedView\">\n            <folder-versioning-page\n                can-edit=\"$ctrl.hasEditPermission\"\n                can-apply=\"$ctrl.hasApplyPermission\"\n                can-create=\"$ctrl.hasCreatePermission\"\n                folder=\"$ctrl.folder\"\n                view=\"$ctrl.selectedView\"\n                on-view-change=\"$ctrl.onViewChange\"\n            ></folder-versioning-page>\n            </ng-container>\n    </div>\n";
var FolderVersioningController = /*#__PURE__*/function () {
  function FolderVersioningController($rootScope, $stateParams, $location, Authenticator) {
    var _this = this;
    (0, _classCallCheck2.default)(this, FolderVersioningController);
    (0, _defineProperty2.default)(this, "changeView", function (value) {
      var screenLocation = "/folders/".concat(_this._$stateParams.folderId, "/version-control");
      if (value === _folderVersioning.viewMode.edit) {
        screenLocation = "".concat(screenLocation, "?action=").concat(_folderVersioning.viewMode.edit);
      }
      _this._$location.url(screenLocation);
      _this.selectedView = value;
    });
    (0, _defineProperty2.default)(this, "onViewChange", function (value) {
      _this.changeView(value);
      _this._$rootScope.$digest();
    });
    this._$rootScope = $rootScope;
    this._$stateParams = $stateParams;
    this._$location = $location;
    this.Authenticator = Authenticator;
  }
  (0, _createClass2.default)(FolderVersioningController, [{
    key: "$onInit",
    value: function $onInit() {
      this.hasEditPermission = this.Authenticator.hasPermission(_permissionsConstants.Permissions.EDIT_FOLDER_VERSIONS, this.folder);
      this.hasApplyPermission = this.Authenticator.hasPermission(_permissionsConstants.Permissions.APPLY_FOLDER_CHANGES, this.folder);
      this.hasCreatePermission = this.Authenticator.hasPermission(_permissionsConstants.Permissions.GENERATE_FOLDER_CONFIGURATION, this.folder);
      var action = this._$location.search().action;
      if (!_.isUndefined(action) && action === _folderVersioning.viewMode.edit) {
        if (this.hasEditPermission) {
          this.selectedView = _folderVersioning.viewMode.edit;
        } else {
          this.changeView(_folderVersioning.viewMode.view);
        }
      } else {
        this.selectedView = _folderVersioning.viewMode.view;
      }
    }
  }]);
  return FolderVersioningController;
}();
(0, _defineProperty2.default)(FolderVersioningController, "$inject", ['$rootScope', '$stateParams', '$location', 'Authenticator']);
var FolderVersioningComponent = {
  bindings: {
    folder: '<'
  },
  controller: FolderVersioningController,
  template: template
};
var _default = exports["default"] = FolderVersioningComponent;

/***/ }),

/***/ 25243:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _index = __webpack_require__(96563);
var _folderVersioning = __webpack_require__(19887);
var _folderVersioning2 = _interopRequireDefault(__webpack_require__(72194));
angular.module('xlrelease.folderVersioning', ['xlrelease', 'ui.router']).component('folderVersioningPage', (0, _index.react2angular)(_folderVersioning.FolderVersioningPage, ['folder', 'canEdit', 'canApply', 'canCreate', 'view', 'onViewChange'])).component('folderVersioning', _folderVersioning2.default);

/***/ }),

/***/ 30332:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.applicationList = exports.applicationForm = exports.actionTypes = void 0;
var actionTypes = exports.actionTypes = {
  APPLICATION_SEARCH_REQUEST: 'envMgmt/APPLICATION_SEARCH_REQUEST',
  APPLICATION_SEARCH_SUCCESS: 'envMgmt/APPLICATION_SEARCH_SUCCESS',
  APPLICATION_SEARCH_FAILURE: 'envMgmt/APPLICATION_SEARCH_FAILURE',
  APPLICATION_GOTO_CREATE_PAGE: 'envMgmt/APPLICATION_GOTO_CREATE_PAGE',
  APPLICATION_GOTO_EDIT_PAGE: 'envMgmt/APPLICATION_GOTO_EDIT_PAGE',
  APPLICATION_DELETE_REQUEST: 'envMgmt/APPLICATION_DELETE_REQUEST',
  APPLICATION_DELETE_SUCCESS: 'envMgmt/APPLICATION_DELETE_SUCCESS',
  APPLICATION_DELETE_FAILURE: 'envMgmt/APPLICATION_DELETE_FAILURE',
  APPLICATION_FORM_CANCEL: 'envMgmt/APPLICATION_FORM_CANCEL',
  APPLICATION_FORM_CLEAN: 'envMgmt/APPLICATION_FORM_CLEAN',
  APPLICATION_FORM_INIT: 'envMgmt/APPLICATION_FORM_INIT',
  APPLICATION_FORM_FAILURE: 'envMgmt/APPLICATION_FORM_FAILURE',
  APPLICATION_LOAD_REQUEST: 'envMgmt/APPLICATION_LOAD_REQUEST',
  APPLICATION_LOAD_SUCCESS: 'envMgmt/APPLICATION_LOAD_SUCCESS',
  APPLICATION_ENV_LOAD_SUCCESS: 'envMgmt/APPLICATION_ENV_LOAD_SUCCESS',
  APPLICATION_STAGE_LOAD_SUCCESS: 'envMgmt/APPLICATION_STAGE_LOAD_SUCCESS',
  APPLICATION_LIST_LOAD_SUCCESS: 'envMgmt/APPLICATION_LIST_LOAD_SUCCESS',
  APPLICATION_FORM_UPDATE_MODEL: 'envMgmt/APPLICATION_FORM_UPDATE_MODEL',
  APPLICATION_FORM_PRISTINE: 'envMgmt/APPLICATION_FORM_PRISTINE',
  APPLICATION_SAVE_REQUEST: 'envMgmt/APPLICATION_SAVE_REQUEST',
  APPLICATION_SAVE_FAILURE: 'envMgmt/APPLICATION_SAVE_FAILURE'
};
var applicationList = exports.applicationList = {
  searchApplications: function searchApplications(applicationName) {
    return {
      type: actionTypes.APPLICATION_SEARCH_REQUEST,
      payload: applicationName
    };
  },
  goToCreatePage: function goToCreatePage() {
    return {
      type: actionTypes.APPLICATION_GOTO_CREATE_PAGE
    };
  },
  goToEditPage: function goToEditPage(application) {
    return {
      type: actionTypes.APPLICATION_GOTO_EDIT_PAGE,
      payload: application
    };
  },
  deleteApplication: function deleteApplication(application) {
    return {
      type: actionTypes.APPLICATION_DELETE_REQUEST,
      payload: application
    };
  }
};
var applicationForm = exports.applicationForm = {
  initForm: function initForm(applicationId) {
    return {
      type: actionTypes.APPLICATION_FORM_INIT,
      payload: applicationId
    };
  },
  cancelForm: function cancelForm() {
    return {
      type: actionTypes.APPLICATION_FORM_CANCEL
    };
  },
  saveApplication: function saveApplication(application) {
    return {
      type: actionTypes.APPLICATION_SAVE_REQUEST,
      payload: application
    };
  },
  updateModel: function updateModel(application) {
    return {
      type: actionTypes.APPLICATION_FORM_UPDATE_MODEL,
      payload: application
    };
  },
  pristineFormChange: function pristineFormChange(pristine) {
    return {
      type: actionTypes.APPLICATION_FORM_PRISTINE,
      payload: pristine
    };
  }
};

/***/ }),

/***/ 32385:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.titleFilterChange = exports.stageFilterChange = exports.searchEnvironments = exports.onEditEnvironment = exports.onDeleteEnvironment = exports.onAddEnvironment = exports.initEnvironmentListSuccess = exports.initEnvironmentList = exports.actionTypes = void 0;
var actionTypes = exports.actionTypes = {
  ENVIRONMENTS_SEARCH_REQUEST: 'envMgmt/ENVIRONMENTS_SEARCH_REQUEST',
  ENVIRONMENTS_SEARCH_SUCCESS: 'envMgmt/ENVIRONMENTS_SEARCH_SUCCESS',
  ENVIRONMENTS_SEARCH_FAILURE: 'envMgmt/ENVIRONMENTS_SEARCH_FAILURE',
  ENVIRONMENT_ADD: 'envMgmt/ENVIRONMENT_ADD',
  ENVIRONMENT_EDIT: 'envMgmt/ENVIRONMENT_EDIT',
  ENVIRONMENT_DELETE_REQUEST: 'envMgmt/ENVIRONMENT_DELETE_REQUEST',
  ENVIRONMENT_DELETE_SUCCESS: 'envMgmt/ENVIRONMENT_DELETE_SUCCESS',
  ENVIRONMENT_DELETE_FAILURE: 'envMgmt/ENVIRONMENT_DELETE_FAILURE',
  INIT_ENVIRONMENT_LIST: 'envMgmt/INIT_ENVIRONMENT_LIST',
  INIT_ENVIRONMENT_LIST_SUCCESS: 'envMgmt/INIT_ENVIRONMENT_LIST_SUCCESS',
  INIT_ENVIRONMENT_LIST_FAILURE: 'envMgmt/INIT_ENVIRONMENT_LIST_FAILURE',
  TITLE_FILTER_CHANGE: 'envMgmt/TITLE_FILTER_CHANGE',
  STAGE_FILTER_CHANGE: 'envMgmt/STAGE_FILTER_CHANGE'
};
var onAddEnvironment = exports.onAddEnvironment = function onAddEnvironment() {
  return {
    type: actionTypes.ENVIRONMENT_ADD
  };
};
var onEditEnvironment = exports.onEditEnvironment = function onEditEnvironment(environment) {
  return {
    type: actionTypes.ENVIRONMENT_EDIT,
    payload: environment
  };
};
var searchEnvironments = exports.searchEnvironments = function searchEnvironments(_ref) {
  var title = _ref.title,
    stageTitle = _ref.stageTitle;
  return {
    type: actionTypes.ENVIRONMENTS_SEARCH_REQUEST,
    payload: {
      title: title,
      stageTitle: stageTitle
    }
  };
};
var onDeleteEnvironment = exports.onDeleteEnvironment = function onDeleteEnvironment(environment) {
  return {
    type: actionTypes.ENVIRONMENT_DELETE_REQUEST,
    payload: environment
  };
};
var initEnvironmentList = exports.initEnvironmentList = function initEnvironmentList() {
  return {
    type: actionTypes.INIT_ENVIRONMENT_LIST
  };
};
var initEnvironmentListSuccess = exports.initEnvironmentListSuccess = function initEnvironmentListSuccess(environments, stages) {
  return {
    type: actionTypes.INIT_ENVIRONMENT_LIST_SUCCESS,
    payload: {
      environments: environments,
      stages: stages
    }
  };
};
var titleFilterChange = exports.titleFilterChange = function titleFilterChange(title) {
  return {
    type: actionTypes.TITLE_FILTER_CHANGE,
    payload: title
  };
};
var stageFilterChange = exports.stageFilterChange = function stageFilterChange(stageTitle) {
  return {
    type: actionTypes.STAGE_FILTER_CHANGE,
    payload: stageTitle
  };
};

/***/ }),

/***/ 42726:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.searchEnvironments = exports.onFormValidChange = exports.onFormSave = exports.onFormPristineChange = exports.onFormChange = exports.onFormCancel = exports.loadEnvironment = exports.initEnvironmentForm = exports.cleanEnvironment = exports.actionTypes = void 0;
var actionTypes = exports.actionTypes = {
  ENVIRONMENT_EDIT_SAVE_FORM: 'envMgmt/ENVIRONMENT_EDIT_SAVE_FORM',
  ENVIRONMENT_EDIT_CANCEL_FORM: 'envMgmt/ENVIRONMENT_EDIT_CANCEL_FORM',
  ENVIRONMENT_EDIT_CLEAN_FORM: 'envMgmt/ENVIRONMENT_EDIT_CLEAN_FORM',
  ENVIRONMENT_EDIT_VALID_FORM: 'envMgmt/ENVIRONMENT_EDIT_VALID_FORM',
  ENVIRONMENT_EDIT_PRISTINE_FORM: 'envMgmt/ENVIRONMENT_EDIT_PRISTINE_FORM',
  ENVIRONMENT_EDIT_CHANGE_FORM: 'envMgmt/ENVIRONMENT_EDIT_CHANGE_FORM',
  ENVIRONMENT_EDIT_CHECK_LEAVE: 'envMgmt/ENVIRONMENT_EDIT_CHECK_LEAVE',
  ENVIRONMENT_LOAD: 'envMgmt/ENVIRONMENT_LOAD',
  ENVIRONMENT_LOAD_SUCCESS: 'envMgmt/ENVIRONMENT_LOAD_SUCCESS',
  ENVIRONMENT_SEARCH: 'envMgmt/ENVIRONMENT_SEARCH',
  ENVIRONMENT_SEARCH_SUCCESS: 'envMgmt/ENVIRONMENT_SEARCH_SUCCESS',
  INIT_ENVIRONMENT_FORM: 'envMgmt/INIT_ENVIRONMENT_FORM',
  INIT_ENVIRONMENT_FORM_SUCCESS: 'envMgmt/INIT_ENVIRONMENT_FORM_SUCCESS',
  INIT_ENVIRONMENT_FORM_FAILURE: 'envMgmt/INIT_ENVIRONMENT_FORM_FAILURE'
};
var onFormChange = exports.onFormChange = function onFormChange(environment) {
  return {
    type: actionTypes.ENVIRONMENT_EDIT_CHANGE_FORM,
    payload: environment
  };
};
var onFormSave = exports.onFormSave = function onFormSave(environment) {
  return {
    type: actionTypes.ENVIRONMENT_EDIT_SAVE_FORM,
    payload: environment
  };
};
var onFormCancel = exports.onFormCancel = function onFormCancel() {
  return {
    type: actionTypes.ENVIRONMENT_EDIT_CANCEL_FORM
  };
};
var onFormValidChange = exports.onFormValidChange = function onFormValidChange(valid) {
  return {
    type: actionTypes.ENVIRONMENT_EDIT_VALID_FORM,
    payload: valid
  };
};
var onFormPristineChange = exports.onFormPristineChange = function onFormPristineChange(pristine) {
  return {
    type: actionTypes.ENVIRONMENT_EDIT_PRISTINE_FORM,
    payload: pristine
  };
};
var cleanEnvironment = exports.cleanEnvironment = function cleanEnvironment() {
  return {
    type: actionTypes.ENVIRONMENT_EDIT_CHECK_LEAVE
  };
};
var loadEnvironment = exports.loadEnvironment = function loadEnvironment(environmentId) {
  return {
    type: actionTypes.ENVIRONMENT_LOAD,
    payload: environmentId
  };
};
var searchEnvironments = exports.searchEnvironments = function searchEnvironments(title) {
  return {
    type: actionTypes.ENVIRONMENT_SEARCH,
    payload: title
  };
};
var initEnvironmentForm = exports.initEnvironmentForm = function initEnvironmentForm(environmentId) {
  return {
    type: actionTypes.INIT_ENVIRONMENT_FORM,
    payload: environmentId
  };
};

/***/ }),

/***/ 3963:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.searchLabels = exports.saveLabel = exports.deleteLabel = exports.actionTypes = void 0;
var actionTypes = exports.actionTypes = {
  LABEL_SEARCH: 'envMgmt/LABEL_SEARCH',
  LABEL_SEARCH_SUCCESS: 'envMgmt/LABEL_SEARCH_SUCCESS',
  LABEL_SEARCH_FAILURE: 'envMgmt/LABEL_SEARCH_FAILURE',
  SAVE_LABEL: 'envMgmt/LABEL_SAVE_LABEL',
  SAVE_LABEL_SUCCESS: 'envMgmt/SAVE_LABEL_SUCCESS',
  SAVE_LABEL_FAILURE: 'envMgmt/SAVE_LABEL_FAILURE',
  DELETE_LABEL: 'envMgmt/DELETE_LABEL_LABEL',
  DELETE_LABEL_SUCCESS: 'envMgmt/DELETE_LABEL_SUCCESS',
  DELETE_LABEL_FAILURE: 'envMgmt/DELETE_LABEL_FAILURE'
};
var searchLabels = exports.searchLabels = function searchLabels(title) {
  return {
    type: actionTypes.LABEL_SEARCH,
    payload: title
  };
};
var saveLabel = exports.saveLabel = function saveLabel(envType) {
  return {
    type: actionTypes.SAVE_LABEL,
    payload: envType
  };
};
var deleteLabel = exports.deleteLabel = function deleteLabel(envType) {
  return {
    type: actionTypes.DELETE_LABEL,
    payload: envType
  };
};

/***/ }),

/***/ 6711:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.showReservationSidebar = exports.openEnvironmentReservationForm = exports.onSearchReservations = exports.initHeader = exports.cleanSchedulingState = exports.actionTypes = void 0;
var actionTypes = exports.actionTypes = {
  SCHEDULE_SEARCH_REQUEST: 'envMgmt/SCHEDULE_SEARCH_REQUEST',
  SCHEDULE_SEARCH_SUCCESS: 'envMgmt/SCHEDULE_SEARCH_SUCCESS',
  SCHEDULE_SEARCH_FAILURE: 'envMgmt/SCHEDULE_SEARCH_FAILURE',
  SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM: 'envMgmt/SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM',
  SCHEDULE_SHOW_RESERVATION_SIDEBAR: 'envMgmt/SCHEDULE_SHOW_RESERVATION_SIDEBAR',
  SCHEDULE_INIT_HEADER_REQUEST: 'envMgmt/SCHEDULE_INIT_HEADER_REQUEST',
  SCHEDULE_INIT_HEADER_SUCCESS: 'envMgmt/SCHEDULE_INIT_HEADER_SUCCESS',
  SCHEDULE_CLEAN_STATE: 'envMgmt/SCHEDULE_CLEAN_STATE'
};
var onSearchReservations = exports.onSearchReservations = function onSearchReservations(schedulerFilter) {
  return {
    type: actionTypes.SCHEDULE_SEARCH_REQUEST,
    payload: schedulerFilter
  };
};
var openEnvironmentReservationForm = exports.openEnvironmentReservationForm = function openEnvironmentReservationForm(reservationId) {
  return {
    type: actionTypes.SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM,
    payload: reservationId
  };
};
var showReservationSidebar = exports.showReservationSidebar = function showReservationSidebar(isOpen) {
  return {
    type: actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR,
    payload: isOpen
  };
};
var initHeader = exports.initHeader = function initHeader() {
  return {
    type: actionTypes.SCHEDULE_INIT_HEADER_REQUEST
  };
};
var cleanSchedulingState = exports.cleanSchedulingState = function cleanSchedulingState() {
  return {
    type: actionTypes.SCHEDULE_CLEAN_STATE
  };
};

/***/ }),

/***/ 5334:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.onReserveEnvironmentCancel = exports.onReserveEnvironment = exports.onReservationFormValidChange = exports.onReservationFormPristineChange = exports.onReservationFormChange = exports.onReservationEnvironmentChange = exports.onDeleteEnvironmentReservation = exports.initEnvironmentReservationForm = exports.actionTypes = void 0;
var actionTypes = exports.actionTypes = {
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE',
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE',
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED',
  SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM',
  SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM',
  SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM',
  SCHEDULE_ENVIRONMENT_RESERVE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVE',
  SCHEDULE_ENVIRONMENT_RESERVE_CANCEL: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVE_CANCEL',
  SCHEDULE_ENVIRONMENT_RESERVE_FAILURE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVE_FAILURE',
  SCHEDULE_ENVIRONMENT_DELETE_RESERVATION: 'envMgmt/SCHEDULE_ENVIRONMENT_DELETE_RESERVATION',
  SCHEDULE_ENVIRONMENT_DELETE_RESERVATION_FAILED: 'envMgmt/SCHEDULE_ENVIRONMENT_DELETE_RESERVATION_FAILED',
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT',
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED'
};
var onReserveEnvironment = exports.onReserveEnvironment = function onReserveEnvironment(reservationModel) {
  return {
    type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVE,
    payload: reservationModel
  };
};
var onReserveEnvironmentCancel = exports.onReserveEnvironmentCancel = function onReserveEnvironmentCancel() {
  return {
    type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_CANCEL
  };
};
var onDeleteEnvironmentReservation = exports.onDeleteEnvironmentReservation = function onDeleteEnvironmentReservation(reservationId) {
  return {
    type: actionTypes.SCHEDULE_ENVIRONMENT_DELETE_RESERVATION,
    payload: reservationId
  };
};
var onReservationFormChange = exports.onReservationFormChange = function onReservationFormChange(reservationModel) {
  return {
    type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE,
    payload: reservationModel
  };
};
var onReservationEnvironmentChange = exports.onReservationEnvironmentChange = function onReservationEnvironmentChange(reservationModel) {
  return {
    type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE,
    payload: reservationModel
  };
};
var onReservationFormPristineChange = exports.onReservationFormPristineChange = function onReservationFormPristineChange(pristine) {
  return {
    type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM,
    payload: pristine
  };
};
var onReservationFormValidChange = exports.onReservationFormValidChange = function onReservationFormValidChange(valid) {
  return {
    type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM,
    payload: valid
  };
};
var initEnvironmentReservationForm = exports.initEnvironmentReservationForm = function initEnvironmentReservationForm(reservationId) {
  return {
    type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT,
    payload: reservationId
  };
};

/***/ }),

/***/ 4077:
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.searchStages = exports.saveStage = exports.deleteStage = exports.actionTypes = void 0;
var actionTypes = exports.actionTypes = {
  STAGE_SEARCH: 'envMgmt/STAGE_SEARCH',
  STAGE_SEARCH_SUCCESS: 'envMgmt/STAGE_SEARCH_SUCCESS',
  STAGE_SEARCH_FAILURE: 'envMgmt/STAGE_SEARCH_FAILURE',
  DELETE_STAGE: 'envMgmt/STAGE_DELETE_STAGE',
  DELETE_STAGE_SUCCESS: 'envMgmt/DELETE_STAGE_SUCCESS',
  DELETE_STAGE_FAILURE: 'envMgmt/DELETE_STAGE_FAILURE',
  SAVE_STAGE: 'envMgmt/STAGE_SAVE_STAGE',
  SAVE_STAGE_SUCCESS: 'envMgmt/SAVE_STAGE_SUCCESS',
  SAVE_STAGE_FAILURE: 'envMgmt/SAVE_STAGE_FAILURE'
};
var searchStages = exports.searchStages = function searchStages(title) {
  return {
    type: actionTypes.STAGE_SEARCH,
    payload: title
  };
};
var deleteStage = exports.deleteStage = function deleteStage(stage) {
  return {
    type: actionTypes.DELETE_STAGE,
    payload: stage
  };
};
var saveStage = exports.saveStage = function saveStage(stage) {
  return {
    type: actionTypes.SAVE_STAGE,
    payload: stage
  };
};

/***/ }),

/***/ 61176:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.updateApp = exports.searchApp = exports.getApp = exports.deleteApp = exports.createApp = void 0;
var _http = __webpack_require__(26511);
var searchApp = exports.searchApp = function searchApp(title) {
  return (0, _http.httpPOST)('api/v1/applications/search', {
    title: title
  }).then(function (resp) {
    return resp.data;
  });
};
var createApp = exports.createApp = function createApp(application) {
  return (0, _http.httpPOST)('api/v1/applications', application).then(function (response) {
    return response.data;
  });
};
var getApp = exports.getApp = function getApp(applicationId) {
  return (0, _http.httpGET)("api/v1/applications/".concat(applicationId)).then(function (response) {
    return response.data;
  });
};
var updateApp = exports.updateApp = function updateApp(application) {
  return (0, _http.httpPUT)("api/v1/applications/".concat(application.id), application);
};
var deleteApp = exports.deleteApp = function deleteApp(applicationId) {
  return (0, _http.httpDELETE)("api/v1/applications/".concat(applicationId));
};

/***/ }),

/***/ 7089:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.updateEnvironment = exports.searchEnvironments = exports.loadEnvironment = exports.getDeployableApplicationsForEnvironment = exports.deleteEnvironment = exports.createEnvironment = void 0;
var _http = __webpack_require__(26511);
var createEnvironment = exports.createEnvironment = function createEnvironment(environment) {
  return (0, _http.httpPOST)('api/v1/environments', environment);
};
var loadEnvironment = exports.loadEnvironment = function loadEnvironment(environmentId) {
  return (0, _http.httpGET)("api/v1/environments/".concat(environmentId)).then(function (response) {
    return response.data;
  });
};
var updateEnvironment = exports.updateEnvironment = function updateEnvironment(environmentId, environment) {
  return (0, _http.httpPUT)("api/v1/environments/".concat(environmentId), environment);
};
var searchEnvironments = exports.searchEnvironments = function searchEnvironments(_ref) {
  var title = _ref.title,
    stage = _ref.stage;
  return (0, _http.httpPOST)('api/v1/environments/search', {
    title: title,
    stage: stage
  }).then(function (response) {
    return response.data;
  });
};
var deleteEnvironment = exports.deleteEnvironment = function deleteEnvironment(environmentId) {
  return (0, _http.httpDELETE)("api/v1/environments/".concat(environmentId));
};
var getDeployableApplicationsForEnvironment = exports.getDeployableApplicationsForEnvironment = function getDeployableApplicationsForEnvironment(environmentId) {
  return (0, _http.httpGET)("api/v1/environments/".concat(environmentId, "/applications")).then(function (response) {
    return response.data;
  });
};

/***/ }),

/***/ 56279:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.updateLabel = exports.searchLabels = exports.getLabel = exports.deleteLabel = exports.createLabel = void 0;
var _http = __webpack_require__(26511);
var createLabel = exports.createLabel = function createLabel(envLabel) {
  return (0, _http.httpPOST)('api/v1/environments/labels', envLabel);
};
var searchLabels = exports.searchLabels = function searchLabels(title) {
  return (0, _http.httpPOST)('api/v1/environments/labels/search', {
    title: title
  }).then(function (response) {
    return response.data;
  });
};
var getLabel = exports.getLabel = function getLabel(envLabelId) {
  return (0, _http.httpGET)("api/v1/environments/labels/".concat(envLabelId)).then(function (response) {
    return response.data;
  });
};
var updateLabel = exports.updateLabel = function updateLabel(envLabelId, envLabel) {
  return (0, _http.httpPUT)("api/v1/environments/labels/".concat(envLabelId), envLabel);
};
var deleteLabel = exports.deleteLabel = function deleteLabel(envLabelId) {
  return (0, _http.httpDELETE)("api/v1/environments/labels/".concat(envLabelId));
};

/***/ }),

/***/ 82762:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.updateReservation = exports.searchReservations = exports.fetchReservation = exports.deleteReservation = exports.createReservation = void 0;
var _http = __webpack_require__(26511);
var searchReservations = exports.searchReservations = function searchReservations(schedulerFilter) {
  return (0, _http.httpPOST)('api/v1/environments/reservations/search', schedulerFilter).then(function (response) {
    return response.data;
  });
};
var createReservation = exports.createReservation = function createReservation(reservation) {
  return (0, _http.httpPOST)('api/v1/environments/reservations', reservation);
};
var updateReservation = exports.updateReservation = function updateReservation(reservationId, reservation) {
  return (0, _http.httpPUT)("api/v1/environments/reservations/".concat(reservationId), reservation);
};
var fetchReservation = exports.fetchReservation = function fetchReservation(reservationId) {
  return (0, _http.httpGET)("api/v1/environments/reservations/".concat(reservationId)).then(function (response) {
    return response.data;
  });
};
var deleteReservation = exports.deleteReservation = function deleteReservation(reservationId) {
  return (0, _http.httpDELETE)("api/v1/environments/reservations/".concat(reservationId));
};

/***/ }),

/***/ 29439:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.updateStage = exports.searchStages = exports.getStage = exports.deleteStage = exports.createStage = void 0;
var _http = __webpack_require__(26511);
var createStage = exports.createStage = function createStage(stage) {
  return (0, _http.httpPOST)('api/v1/environments/stages', stage);
};
var searchStages = exports.searchStages = function searchStages(title) {
  return (0, _http.httpPOST)('api/v1/environments/stages/search', {
    title: title
  }).then(function (response) {
    return response.data;
  });
};
var getStage = exports.getStage = function getStage(stageId) {
  return (0, _http.httpGET)("api/v1/environments/stages/".concat(stageId)).then(function (response) {
    return response.data;
  });
};
var updateStage = exports.updateStage = function updateStage(stageId, stage) {
  return (0, _http.httpPUT)("api/v1/environments/stages/".concat(stageId), stage);
};
var deleteStage = exports.deleteStage = function deleteStage(stageId) {
  return (0, _http.httpDELETE)("api/v1/environments/stages/".concat(stageId));
};

/***/ }),

/***/ 50990:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _dotComponents = __webpack_require__(92140);
var _actionToolbar = __webpack_require__(29755);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ApplicationEditHeaderComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(ApplicationEditHeaderComponent, _Component);
  var _super = _createSuper(ApplicationEditHeaderComponent);
  function ApplicationEditHeaderComponent() {
    (0, _classCallCheck2.default)(this, ApplicationEditHeaderComponent);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(ApplicationEditHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        saveCaption = _this$props.saveCaption,
        saveEnabled = _this$props.saveEnabled,
        onSave = _this$props.onSave,
        onCancel = _this$props.onCancel;
      return /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, {
        helpLink: "how-to/using-applications.html"
      }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
        onClick: onCancel,
        type: "text"
      }, "Cancel"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
        disabled: !saveEnabled,
        onClick: onSave
      }, saveCaption));
    }
  }]);
  return ApplicationEditHeaderComponent;
}(_react.Component);
(0, _defineProperty2.default)(ApplicationEditHeaderComponent, "propTypes", {
  onCancel: _propTypes.default.func.isRequired,
  onSave: _propTypes.default.func.isRequired,
  saveCaption: _propTypes.default.string.isRequired,
  saveEnabled: _propTypes.default.bool.isRequired
});

/***/ }),

/***/ 47589:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(319));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _reactSidebar = _interopRequireDefault(__webpack_require__(60005));
var _differenceBy = _interopRequireDefault(__webpack_require__(70735));
var _isEmpty = _interopRequireDefault(__webpack_require__(41609));
var _applicationEditHeaderComponent = _interopRequireDefault(__webpack_require__(50990));
var _applicationFormComponent = _interopRequireDefault(__webpack_require__(77741));
var _types = __webpack_require__(57809);
var _sidebarEnvironmentList = _interopRequireDefault(__webpack_require__(25690));
__webpack_require__(32429);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ApplicationEditPageComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(ApplicationEditPageComponent, _Component);
  var _super = _createSuper(ApplicationEditPageComponent);
  function ApplicationEditPageComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, ApplicationEditPageComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onSave", function () {
      var application = _this.props.application;
      _this.props.onSaveApplication(application);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFormValidChange", function (valid) {
      _this.setState({
        formValid: valid
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onApplicationChange", function (application) {
      _this.props.onUpdateApplication(application);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onAddEnvironment", function (environment) {
      _this.setState({
        formPristine: false
      });
      var application = _this.props.application;
      var updatedApp = _objectSpread(_objectSpread({}, application), {}, {
        environments: [].concat((0, _toConsumableArray2.default)(application.environments), [environment])
      });
      _this.props.onUpdateApplication(updatedApp);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onPristinityChange", function (pristine) {
      _this.setState({
        formPristine: pristine
      });
      if (!pristine) {
        _this.props.onFormPristine(pristine);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderSidebarContent", function () {
      var _this$props = _this.props,
        application = _this$props.application,
        environments = _this$props.environments,
        stages = _this$props.stages;
      var filteredEnvironments = (0, _differenceBy.default)(environments, application.environments, 'id');
      return /*#__PURE__*/_react.default.createElement(_sidebarEnvironmentList.default, {
        environments: filteredEnvironments,
        onClickEnvironment: _this.onAddEnvironment,
        stages: stages
      });
    });
    _this.state = {
      formValid: false,
      formPristine: true
    };
    return _this;
  }
  (0, _createClass2.default)(ApplicationEditPageComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props2 = this.props,
        applicationId = _this$props2.applicationId,
        initComponent = _this$props2.initComponent;
      initComponent(applicationId);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
        application = _this$props3.application,
        applications = _this$props3.applications,
        onFormCancel = _this$props3.onFormCancel;
      var _this$state = this.state,
        formValid = _this$state.formValid,
        formPristine = _this$state.formPristine;
      var saveEnabled = !formPristine && formValid;
      var saveButtonCaption = (0, _isEmpty.default)(application) ? 'Create' : 'Save';
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "application-form-view"
      }, /*#__PURE__*/_react.default.createElement(_applicationEditHeaderComponent.default, {
        onCancel: onFormCancel,
        onSave: this.onSave,
        saveCaption: saveButtonCaption,
        saveEnabled: saveEnabled
      }), /*#__PURE__*/_react.default.createElement(_reactSidebar.default, {
        contentClassName: "application-form-content",
        docked: true,
        open: true,
        pullRight: true,
        shadow: false,
        sidebar: this.renderSidebarContent(),
        sidebarClassName: "application-form-sidebar",
        transitions: false
      }, /*#__PURE__*/_react.default.createElement(_applicationFormComponent.default, {
        applicationList: applications,
        applicationModel: application,
        onFormChange: this.onApplicationChange,
        onPristinityChange: this.onPristinityChange,
        onValidationChange: this.onFormValidChange
      })));
    }
  }]);
  return ApplicationEditPageComponent;
}(_react.Component);
(0, _defineProperty2.default)(ApplicationEditPageComponent, "propTypes", {
  application: _types.Application,
  applicationId: _propTypes.default.string,
  applications: _propTypes.default.arrayOf(_types.Application),
  environments: _propTypes.default.arrayOf(_types.Environment),
  initComponent: _propTypes.default.func.isRequired,
  onFormCancel: _propTypes.default.func.isRequired,
  onFormPristine: _propTypes.default.func.isRequired,
  onSaveApplication: _propTypes.default.func.isRequired,
  onUpdateApplication: _propTypes.default.func.isRequired,
  stages: _propTypes.default.arrayOf(_types.Stage)
});
(0, _defineProperty2.default)(ApplicationEditPageComponent, "defaultProps", {
  application: {},
  stages: [],
  environments: [],
  applications: []
});

/***/ }),

/***/ 82561:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ApplicationEditPageContainer = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _applicationActions = __webpack_require__(30332);
var _applicationEditPageComponent = _interopRequireDefault(__webpack_require__(47589));
var mapStateToProps = function mapStateToProps(state) {
  return {
    application: state.applicationForm.application,
    applications: state.applicationForm.applications,
    environments: state.applicationForm.environments,
    stages: state.applicationForm.stages
  };
};
var ApplicationEditPageContainer = exports.ApplicationEditPageContainer = (0, _reactRedux.connect)(mapStateToProps, {
  onSaveApplication: _applicationActions.applicationForm.saveApplication,
  initComponent: _applicationActions.applicationForm.initForm,
  onUpdateApplication: _applicationActions.applicationForm.updateModel,
  onFormCancel: _applicationActions.applicationForm.cancelForm,
  onFormPristine: _applicationActions.applicationForm.pristineFormChange
})(_applicationEditPageComponent.default);

/***/ }),

/***/ 77156:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _environmentManagementStore = __webpack_require__(68124);
var _applicationEditPageContainer = __webpack_require__(82561);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ApplicationEditPage = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(ApplicationEditPage, _Component);
  var _super = _createSuper(ApplicationEditPage);
  function ApplicationEditPage() {
    (0, _classCallCheck2.default)(this, ApplicationEditPage);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(ApplicationEditPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
        store: _environmentManagementStore.store
      }, /*#__PURE__*/_react.default.createElement(_applicationEditPageContainer.ApplicationEditPageContainer, {
        applicationId: this.props.applicationId
      }));
    }
  }]);
  return ApplicationEditPage;
}(_react.Component);
(0, _defineProperty2.default)(ApplicationEditPage, "propTypes", {
  applicationId: _propTypes.default.string
});

/***/ }),

/***/ 77741:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _xlReactComponents = __webpack_require__(67082);
var _isEmpty = _interopRequireDefault(__webpack_require__(41609));
var _widgetLinkedEnvironments = _interopRequireDefault(__webpack_require__(1389));
var _validators = __webpack_require__(36735);
var _index = __webpack_require__(57809);
__webpack_require__(61513);
__webpack_require__(29809);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var nameFormMetadata = {
  label: 'Name',
  placeholder: 'Add name...',
  description: 'Name of the application',
  required: true
};
var nameValidator = function nameValidator(applications, selectedId) {
  return function (name) {
    return {
      condition: (0, _validators.itemAlreadyDefined)(applications, selectedId, 'title', name),
      message: (0, _validators.createErrorMessage)('Application already exists')
    };
  };
};
var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: (0, _validators.validateMaxLength)(inputText, maxLength),
      message: (0, _validators.createErrorMessage)("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};
var findApplicationById = function findApplicationById(applications, id) {
  return applications.find(function (e) {
    return e.id === id;
  }) || {};
};
var ApplicationFormComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(ApplicationFormComponent, _Component);
  var _super = _createSuper(ApplicationFormComponent);
  function ApplicationFormComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, ApplicationFormComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onRegister", function (componentApi) {
      componentApi.focus();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onNameChange", function (title) {
      var applicationModel = _this.props.applicationModel;
      if (title !== applicationModel.title) {
        _this.props.onFormChange(_objectSpread(_objectSpread({}, applicationModel), {}, {
          title: title
        }));
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEnvironmentDeleted", function (environment) {
      var applicationModel = _this.props.applicationModel;
      var environments = applicationModel.environments.filter(function (e) {
        return e.id !== environment.id;
      });
      _this.props.onFormChange(_objectSpread(_objectSpread({}, applicationModel), {}, {
        environments: environments
      }));
      _this.props.onPristinityChange(false);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onNameValidityChange", function (valid) {
      _this.props.onValidationChange(valid);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onNamePristine", function (pristine) {
      _this.props.onPristinityChange(pristine);
    });
    return _this;
  }
  (0, _createClass2.default)(ApplicationFormComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        applicationModel = _this$props.applicationModel,
        applicationList = _this$props.applicationList;
      var app = findApplicationById(applicationList, applicationModel.id);
      var subtitle = (0, _isEmpty.default)(app) ? 'New Application' : app.title;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "application-edit-form"
      }, /*#__PURE__*/_react.default.createElement("h4", {
        className: "page-title"
      }, "Applications / ", subtitle), /*#__PURE__*/_react.default.createElement("div", {
        className: "application-form"
      }, /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetString, {
        metadata: nameFormMetadata,
        model: applicationModel.title,
        onModelChange: this.onNameChange,
        onPristinityChange: this.onNamePristine,
        onValidityChange: this.onNameValidityChange,
        register: this.onRegister,
        validators: [nameValidator(applicationList, applicationModel.id), maxLengthValidator(nameFormMetadata.label, 255)]
      }), /*#__PURE__*/_react.default.createElement(_widgetLinkedEnvironments.default, {
        environments: applicationModel.environments,
        onDelete: this.onEnvironmentDeleted
      })));
    }
  }]);
  return ApplicationFormComponent;
}(_react.Component);
(0, _defineProperty2.default)(ApplicationFormComponent, "propTypes", {
  applicationList: _propTypes.default.arrayOf(_index.Application).isRequired,
  applicationModel: _index.Application,
  onFormChange: _propTypes.default.func.isRequired,
  onPristinityChange: _propTypes.default.func.isRequired,
  onValidationChange: _propTypes.default.func.isRequired
});
(0, _defineProperty2.default)(ApplicationFormComponent, "defaultProps", {
  applicationModel: {}
});

/***/ }),

/***/ 25690:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _xlReactComponents = __webpack_require__(67082);
var _includes = _interopRequireDefault(__webpack_require__(64721));
var _sortBy = _interopRequireDefault(__webpack_require__(89734));
var _defaults = _interopRequireDefault(__webpack_require__(91747));
var _environmentSidebarItem = _interopRequireDefault(__webpack_require__(23994));
var _index = __webpack_require__(57809);
__webpack_require__(46);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var stageMetadata = {
  label: '',
  placeholder: 'Filter by stage...'
};
var filterOptions = {
  placeholder: 'Filter environment name...'
};
var SidebarEnvironmentList = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(SidebarEnvironmentList, _Component);
  var _super = _createSuper(SidebarEnvironmentList);
  function SidebarEnvironmentList(props) {
    var _this;
    (0, _classCallCheck2.default)(this, SidebarEnvironmentList);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onStageChange", function (stage) {
      _this.setState({
        stageSelected: stage
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onNameChange", function (name) {
      _this.setState({
        environmentFilter: name
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEnvironmentClick", function (environment) {
      _this.props.onClickEnvironment(environment);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "filterEnvironments", function (environment) {
      var _this$state = _this.state,
        environmentFilter = _this$state.environmentFilter,
        stageSelected = _this$state.stageSelected;
      (0, _defaults.default)(stageSelected, {
        title: ''
      });
      return (0, _includes.default)(environment.title.toLowerCase(), environmentFilter.toLowerCase()) && (0, _includes.default)(environment.stage.title.toLowerCase(), stageSelected.title.toLowerCase());
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderEnvironments", function () {
      var environments = _this.props.environments;
      return environments.filter(function (env) {
        return _this.filterEnvironments(env);
      }).map(function (env) {
        return /*#__PURE__*/_react.default.createElement(_environmentSidebarItem.default, {
          environment: env,
          isClickable: true,
          key: env.id,
          onClick: _this.onEnvironmentClick
        });
      });
    });
    _this.state = {
      stageSelected: {
        title: ''
      },
      environmentFilter: ''
    };
    return _this;
  }
  (0, _createClass2.default)(SidebarEnvironmentList, [{
    key: "render",
    value: function render() {
      var stages = this.props.stages;
      var stageSelected = this.state.stageSelected;
      var autocompleteHandler = function autocompleteHandler(_ref) {
        var metadata = _ref.metadata,
          objLabel = _ref.objLabel,
          suggestedElements = _ref.suggestedElements,
          value = _ref.value;
        return Promise.resolve((0, _sortBy.default)(stages.filter(function (c) {
          return (0, _includes.default)(c.title.toLowerCase(), value.toLowerCase());
        }), ['title']));
      };
      var autocompleteHandlers = {
        addCandidates: autocompleteHandler
      };
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "application-form-environment-sidebar"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "header"
      }, /*#__PURE__*/_react.default.createElement("h4", {
        className: "page-title"
      }, "Environments"), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
        handlers: autocompleteHandlers,
        metadata: stageMetadata,
        model: stageSelected,
        objLabel: 'title',
        onModelChange: this.onStageChange
      }), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetFilter, {
        metadata: filterOptions,
        onUpdate: this.onNameChange
      })), /*#__PURE__*/_react.default.createElement("div", {
        className: "environment-sidebar-list"
      }, this.renderEnvironments()));
    }
  }]);
  return SidebarEnvironmentList;
}(_react.Component);
(0, _defineProperty2.default)(SidebarEnvironmentList, "propTypes", {
  environments: _propTypes.default.arrayOf(_index.Environment),
  onClickEnvironment: _propTypes.default.func.isRequired,
  stages: _propTypes.default.arrayOf(_index.Stage)
});
(0, _defineProperty2.default)(SidebarEnvironmentList, "defaultProps", {
  stages: [],
  environments: []
});

/***/ }),

/***/ 4726:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _xlReactComponents = __webpack_require__(67082);
var _applicationListHeaderComponent = _interopRequireDefault(__webpack_require__(53014));
var _applicationListItemComponent = _interopRequireDefault(__webpack_require__(49490));
var _components = __webpack_require__(78605);
var _types = __webpack_require__(57809);
__webpack_require__(61513);
__webpack_require__(91147);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var helpMessage = "Use Applications to logically group applications and the environments they must be deployed to.";
var ApplicationListComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(ApplicationListComponent, _Component);
  var _super = _createSuper(ApplicationListComponent);
  function ApplicationListComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, ApplicationListComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFilterChange", function (appName) {
      _this.props.searchApplications(appName);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "goToEditPage", function (application) {
      _this.props.onEditApplication(application);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "goToNewPage", function () {
      _this.props.onAddApplication();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "showDeleteModal", function (application) {
      _this.setState({
        deleteModalIsOpen: true,
        applicationToDelete: application
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCloseDeleteModal", function (action) {
      var applicationToDelete = _this.state.applicationToDelete;
      if (action === 'delete') {
        _this.props.onDeleteApplication(applicationToDelete);
      }
      _this.setState({
        deleteModalIsOpen: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderHeader", function () {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "application-list-header"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "col-xs-5"
      }, "Name"), /*#__PURE__*/_react.default.createElement("span", {
        className: "col-xs-5"
      }, "Environment"), /*#__PURE__*/_react.default.createElement("div", {
        className: "col-xs-2"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "pull-right action-section"
      }, "Actions")));
    });
    _this.state = {
      deleteModalIsOpen: false,
      applicationToDelete: {}
    };
    return _this;
  }
  (0, _createClass2.default)(ApplicationListComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.searchApplications('');
    }
  }, {
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var _this$state = this.state,
        deleteModalIsOpen = _this$state.deleteModalIsOpen,
        applicationToDelete = _this$state.applicationToDelete;
      return /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetConfirmationDialog, {
        buttons: [cancelButton, deleteButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseDeleteModal,
        show: deleteModalIsOpen,
        title: "Delete application"
      }, /*#__PURE__*/_react.default.createElement(_components.AlertMessage, {
        alertType: _components.alertType.WARNING
      }, /*#__PURE__*/_react.default.createElement("p", null, "Deleting an application can lead to missing data for connected resources on reporting and environment scheduling.")), /*#__PURE__*/_react.default.createElement("p", null, "You are about to delete application ", /*#__PURE__*/_react.default.createElement("strong", null, applicationToDelete.title), "."));
    }
  }, {
    key: "renderList",
    value: function renderList() {
      var _this2 = this;
      var applications = this.props.applications;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.renderDeleteModal(), this.renderHeader(), applications.map(function (app) {
        return /*#__PURE__*/_react.default.createElement(_applicationListItemComponent.default, {
          application: app,
          key: app.id,
          onDelete: _this2.showDeleteModal,
          onEdit: _this2.goToEditPage
        });
      }));
    }
  }, {
    key: "render",
    value: function render() {
      var applications = this.props.applications;
      return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_applicationListHeaderComponent.default, {
        onApplicationFilterChange: this.onFilterChange,
        onCreate: this.goToNewPage
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "header-shadow"
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "application-list-component"
      }, /*#__PURE__*/_react.default.createElement("h4", {
        className: "page-title"
      }, "Applications (", applications.length, ")"), /*#__PURE__*/_react.default.createElement(_components.HelpBlock, {
        className: "help-message-container"
      }, helpMessage), applications.length ? this.renderList() : /*#__PURE__*/_react.default.createElement(_components.NoData, {
        message: "No applications found."
      })));
    }
  }]);
  return ApplicationListComponent;
}(_react.Component);
(0, _defineProperty2.default)(ApplicationListComponent, "propTypes", {
  applications: _propTypes.default.arrayOf(_types.Application).isRequired,
  onAddApplication: _propTypes.default.func.isRequired,
  onDeleteApplication: _propTypes.default.func.isRequired,
  onEditApplication: _propTypes.default.func.isRequired,
  searchApplications: _propTypes.default.func.isRequired
});

/***/ }),

/***/ 53014:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _dotComponents = __webpack_require__(92140);
var _xlReactComponents = __webpack_require__(67082);
var _headerComponent = _interopRequireDefault(__webpack_require__(39470));
var _actionToolbar = __webpack_require__(29755);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var filterOptions = {
  placeholder: 'Filter by application...'
};
var ApplicationListHeaderComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(ApplicationListHeaderComponent, _Component);
  var _super = _createSuper(ApplicationListHeaderComponent);
  function ApplicationListHeaderComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, ApplicationListHeaderComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFilterChange", function (filter) {
      _this.props.onApplicationFilterChange(filter);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCreate", function () {
      _this.props.onCreate();
    });
    _this.state = {
      createButtonDisabled: false,
      modalIsOpen: false,
      title: ''
    };
    return _this;
  }
  (0, _createClass2.default)(ApplicationListHeaderComponent, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/_react.default.createElement(_headerComponent.default, null, /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, {
        helpLink: "how-to/using-applications.html"
      }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
        onClick: this.onCreate
      }, "New application")), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetFilter, {
        metadata: filterOptions,
        onUpdate: this.onFilterChange
      }));
    }
  }]);
  return ApplicationListHeaderComponent;
}(_react.Component);
(0, _defineProperty2.default)(ApplicationListHeaderComponent, "propTypes", {
  onApplicationFilterChange: _propTypes.default.func.isRequired,
  onCreate: _propTypes.default.func.isRequired
});

/***/ }),

/***/ 49490:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _classnames = _interopRequireDefault(__webpack_require__(94184));
var _types = __webpack_require__(57809);
var _dotIconWrapper = __webpack_require__(23287);
__webpack_require__(78377);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ApplicationListItemComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(ApplicationListItemComponent, _Component);
  var _super = _createSuper(ApplicationListItemComponent);
  function ApplicationListItemComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, ApplicationListItemComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEditApplication", function (event) {
      event.stopPropagation();
      var _this$props = _this.props,
        application = _this$props.application,
        onEdit = _this$props.onEdit;
      onEdit(application);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDeleteApplication", function (event) {
      event.stopPropagation();
      var _this$props2 = _this.props,
        application = _this$props2.application,
        onDelete = _this$props2.onDelete;
      onDelete(application);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderLinkedEnvironments", function () {
      var environments = _this.props.application.environments;
      var environmentNames = environments ? environments.map(function (env) {
        return env.title;
      }).join(', ') : [];
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "application-item-environments col-xs-5"
      }, environmentNames.length ? /*#__PURE__*/_react.default.createElement("span", {
        title: environmentNames
      }, /*#__PURE__*/_react.default.createElement(_dotIconWrapper.DotIconWrapper, {
        className: "mrs",
        iconId: "environment"
      }), environmentNames) : 'All environments');
    });
    return _this;
  }
  (0, _createClass2.default)(ApplicationListItemComponent, [{
    key: "render",
    value: function render() {
      var application = this.props.application;
      var panelClass = (0, _classnames.default)('panel', 'panel-default', 'application-panel');
      return /*#__PURE__*/_react.default.createElement("div", {
        className: panelClass,
        onClick: this.onEditApplication
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "application-item-title col-xs-5",
        title: application.title
      }, /*#__PURE__*/_react.default.createElement(_dotIconWrapper.DotIconWrapper, {
        className: "mrs",
        iconId: "package"
      }), /*#__PURE__*/_react.default.createElement("strong", null, application.title)), this.renderLinkedEnvironments(), /*#__PURE__*/_react.default.createElement("div", {
        className: "actions-container col-xs-2"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "actions pull-right"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "link color-inherited",
        "data-test": "edit-action",
        onClick: this.onEditApplication
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "menu-item-icon xl-icon edit-icon",
        title: "Edit"
      }), /*#__PURE__*/_react.default.createElement("span", {
        className: "action-label"
      }, "Edit")), /*#__PURE__*/_react.default.createElement("span", {
        className: "link delete",
        "data-test": "delete-action",
        onClick: this.onDeleteApplication
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      }), /*#__PURE__*/_react.default.createElement("span", {
        className: "action-label"
      }, "Delete")))));
    }
  }]);
  return ApplicationListItemComponent;
}(_react.Component);
(0, _defineProperty2.default)(ApplicationListItemComponent, "propTypes", {
  application: _types.Application.isRequired,
  onDelete: _propTypes.default.func.isRequired,
  onEdit: _propTypes.default.func.isRequired
});

/***/ }),

/***/ 67709:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ApplicationListPageContainer = void 0;
var _reactRedux = __webpack_require__(37703);
var _applicationActions = __webpack_require__(30332);
var _applicationListComponent = _interopRequireDefault(__webpack_require__(4726));
var mapStateToProps = function mapStateToProps(state) {
  return {
    applications: state.applicationList.applications
  };
};
var ApplicationListPageContainer = exports.ApplicationListPageContainer = (0, _reactRedux.connect)(mapStateToProps, {
  onAddApplication: _applicationActions.applicationList.goToCreatePage,
  onEditApplication: _applicationActions.applicationList.goToEditPage,
  onDeleteApplication: _applicationActions.applicationList.deleteApplication,
  searchApplications: _applicationActions.applicationList.searchApplications
})(_applicationListComponent.default);

/***/ }),

/***/ 75994:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _environmentManagementStore = __webpack_require__(68124);
var _applicationListPageContainer = __webpack_require__(67709);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ApplicationListPage = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(ApplicationListPage, _Component);
  var _super = _createSuper(ApplicationListPage);
  function ApplicationListPage() {
    (0, _classCallCheck2.default)(this, ApplicationListPage);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(ApplicationListPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
        store: _environmentManagementStore.store
      }, /*#__PURE__*/_react.default.createElement(_applicationListPageContainer.ApplicationListPageContainer, null));
    }
  }]);
  return ApplicationListPage;
}(_react.Component);

/***/ }),

/***/ 2281:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _isEmpty = _interopRequireDefault(__webpack_require__(41609));
var _dotComponents = __webpack_require__(92140);
var _actionToolbar = __webpack_require__(29755);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var EnvironmentEditHeaderComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EnvironmentEditHeaderComponent, _Component);
  var _super = _createSuper(EnvironmentEditHeaderComponent);
  function EnvironmentEditHeaderComponent() {
    (0, _classCallCheck2.default)(this, EnvironmentEditHeaderComponent);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(EnvironmentEditHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        onCancel = _this$props.onCancel,
        onSave = _this$props.onSave,
        saveEnabled = _this$props.saveEnabled,
        environmentId = _this$props.environmentId;
      var caption = (0, _isEmpty.default)(environmentId) ? 'Create' : 'Save';
      return /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, {
        helpLink: "how-to/using-environments.html"
      }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
        onClick: onCancel,
        type: "text"
      }, "Cancel"), /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
        disabled: !saveEnabled,
        onClick: onSave
      }, caption));
    }
  }]);
  return EnvironmentEditHeaderComponent;
}(_react.Component);
(0, _defineProperty2.default)(EnvironmentEditHeaderComponent, "propTypes", {
  environmentId: _propTypes.default.string,
  onCancel: _propTypes.default.func.isRequired,
  onSave: _propTypes.default.func.isRequired,
  saveEnabled: _propTypes.default.bool.isRequired
});

/***/ }),

/***/ 55688:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.EnvironmentEditPageContainer = exports.EnvironmentEditPageComponent = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _reactRedux = __webpack_require__(37703);
var _environmentFormActions = __webpack_require__(42726);
var _environmentFormContainer = __webpack_require__(52215);
var _environmentEditHeaderComponent = _interopRequireDefault(__webpack_require__(2281));
__webpack_require__(38374);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var EnvironmentEditPageComponent = exports.EnvironmentEditPageComponent = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EnvironmentEditPageComponent, _Component);
  var _super = _createSuper(EnvironmentEditPageComponent);
  function EnvironmentEditPageComponent() {
    var _this;
    (0, _classCallCheck2.default)(this, EnvironmentEditPageComponent);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onSave", function () {
      var _this$props = _this.props,
        environmentModel = _this$props.environmentModel,
        onFormSave = _this$props.onFormSave;
      onFormSave(environmentModel);
    });
    return _this;
  }
  (0, _createClass2.default)(EnvironmentEditPageComponent, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        formIsPristine = _this$props2.formIsPristine,
        formIsValid = _this$props2.formIsValid,
        environmentId = _this$props2.environmentId,
        onFormCancel = _this$props2.onFormCancel;
      var saveEnabled = !formIsPristine && formIsValid;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "environment-edit-page"
      }, /*#__PURE__*/_react.default.createElement(_environmentEditHeaderComponent.default, {
        environmentId: environmentId,
        onCancel: onFormCancel,
        onSave: this.onSave,
        saveEnabled: saveEnabled
      }), /*#__PURE__*/_react.default.createElement(_environmentFormContainer.EnvironmentFormContainer, {
        environmentId: environmentId
      }));
    }
  }]);
  return EnvironmentEditPageComponent;
}(_react.Component);
(0, _defineProperty2.default)(EnvironmentEditPageComponent, "propTypes", {
  environmentId: _propTypes.default.string,
  environmentModel: _propTypes.default.shape({
    id: _propTypes.default.string,
    title: _propTypes.default.string.isRequired,
    description: _propTypes.default.string.isRequired
  }).isRequired,
  formIsPristine: _propTypes.default.bool.isRequired,
  formIsValid: _propTypes.default.bool.isRequired,
  onFormCancel: _propTypes.default.func.isRequired,
  onFormSave: _propTypes.default.func.isRequired
});
var mapStateToProps = function mapStateToProps(state) {
  return {
    environmentModel: state.environmentForm.environmentModel,
    formIsValid: state.environmentForm.formIsValid,
    formIsPristine: state.environmentForm.formIsPristine
  };
};
var EnvironmentEditPageContainer = exports.EnvironmentEditPageContainer = (0, _reactRedux.connect)(mapStateToProps, {
  onFormCancel: _environmentFormActions.onFormCancel,
  onFormSave: _environmentFormActions.onFormSave
})(EnvironmentEditPageComponent);

/***/ }),

/***/ 77596:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _environmentManagementStore = __webpack_require__(68124);
var _environmentEditPageContainer = __webpack_require__(55688);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var EnvironmentEditPage = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EnvironmentEditPage, _Component);
  var _super = _createSuper(EnvironmentEditPage);
  function EnvironmentEditPage() {
    (0, _classCallCheck2.default)(this, EnvironmentEditPage);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(EnvironmentEditPage, [{
    key: "render",
    value: function render() {
      var environmentId = this.props.environmentId;
      return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
        store: _environmentManagementStore.store
      }, /*#__PURE__*/_react.default.createElement(_environmentEditPageContainer.EnvironmentEditPageContainer, {
        environmentId: environmentId
      }));
    }
  }]);
  return EnvironmentEditPage;
}(_react.Component);
(0, _defineProperty2.default)(EnvironmentEditPage, "propTypes", {
  environmentId: _propTypes.default.string
});

/***/ }),

/***/ 22055:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _reactSidebar = _interopRequireDefault(__webpack_require__(60005));
var _includes = _interopRequireDefault(__webpack_require__(64721));
var _sortBy = _interopRequireDefault(__webpack_require__(89734));
var _clone = _interopRequireDefault(__webpack_require__(66678));
var _differenceWith = _interopRequireDefault(__webpack_require__(29521));
var _isEmpty = _interopRequireDefault(__webpack_require__(41609));
var _isEqual = _interopRequireDefault(__webpack_require__(18446));
var _reject = _interopRequireDefault(__webpack_require__(43063));
var _some = _interopRequireDefault(__webpack_require__(59704));
var _xlReactComponents = __webpack_require__(67082);
var _validators = __webpack_require__(36735);
var _sidebarLabelList = _interopRequireDefault(__webpack_require__(6188));
var _widgetLinkedLabels = _interopRequireDefault(__webpack_require__(22516));
__webpack_require__(61513);
__webpack_require__(30366);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var nameFormMetadata = {
  label: 'Name',
  placeholder: 'Add...',
  description: 'Name of the environment',
  required: true
};
var descriptionFormMetadata = {
  label: 'Description',
  placeholder: 'Set description...',
  description: 'Description of the environment',
  size: 'MEDIUM'
};
var selectFormMetadata = {
  description: 'Name of the stage',
  label: 'Stage',
  placeholder: 'Select stage...',
  required: true
};
var findEnvironmentById = function findEnvironmentById(environments, id) {
  return environments.find(function (e) {
    return e.id === id;
  }) || {};
};
var nameValidator = function nameValidator(environments, selectedId) {
  return function (name) {
    return {
      condition: (0, _validators.itemAlreadyDefined)(environments, selectedId, 'title', name),
      message: (0, _validators.createErrorMessage)('Environment already exists')
    };
  };
};
var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: (0, _validators.validateMaxLength)(inputText, maxLength),
      message: (0, _validators.createErrorMessage)("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};
var EnvironmentFormComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EnvironmentFormComponent, _Component);
  var _super = _createSuper(EnvironmentFormComponent);
  function EnvironmentFormComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, EnvironmentFormComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onRegister", function (componentApi) {
      componentApi.focus();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onPristinityChange", function (pristine) {
      if (!pristine) {
        _this.props.onPristinityChange(pristine);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onNameChange", function (title) {
      var _this$props = _this.props,
        environmentModel = _this$props.environmentModel,
        onFormChange = _this$props.onFormChange;
      if (title !== environmentModel.title) {
        onFormChange(_objectSpread(_objectSpread({}, environmentModel), {}, {
          title: title
        }));
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onStageChange", function (stage) {
      var _this$props2 = _this.props,
        environmentModel = _this$props2.environmentModel,
        onFormChange = _this$props2.onFormChange;
      if (stage && stage.id !== environmentModel.stage.id) {
        onFormChange(_objectSpread(_objectSpread({}, environmentModel), {}, {
          stage: stage
        }));
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDescriptionChange", function (description) {
      var _this$props3 = _this.props,
        environmentModel = _this$props3.environmentModel,
        onFormChange = _this$props3.onFormChange;
      if (description !== environmentModel.description) {
        onFormChange(_objectSpread(_objectSpread({}, environmentModel), {}, {
          description: description
        }));
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onAddLabel", function (envLabel) {
      var environmentModel = _this.props.environmentModel;
      var labels = (0, _clone.default)(environmentModel.labels);
      if (!(0, _some.default)(environmentModel.labels, {
        id: envLabel.id
      })) {
        labels.push(envLabel);
      }
      _this.props.onFormChange(_objectSpread(_objectSpread({}, environmentModel), {}, {
        labels: labels
      }));
      _this.onPristinityChange(false);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onRemoveLabel", function (envLabel) {
      var environmentModel = _this.props.environmentModel;
      var labels = (0, _reject.default)(environmentModel.labels, {
        id: envLabel.id
      });
      _this.props.onFormChange(_objectSpread(_objectSpread({}, environmentModel), {}, {
        labels: labels
      }));
      _this.onPristinityChange(false);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onNameValidityChange", function (valid) {
      var onValidationChange = _this.props.onValidationChange;
      _this.isNameValid = valid;
      onValidationChange(_this.isFormValid);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onStageValidityChange", function (valid) {
      var onValidationChange = _this.props.onValidationChange;
      _this.isStageValid = valid;
      onValidationChange(_this.isFormValid);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onNamePristine", function (pristine) {
      _this.setState({
        namePristine: pristine
      });
      var _this$state = _this.state,
        descriptionPristine = _this$state.descriptionPristine,
        stagePristine = _this$state.stagePristine;
      var isFormPristine = pristine && descriptionPristine && stagePristine;
      _this.onPristinityChange(isFormPristine);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDescPristine", function (pristine) {
      _this.setState({
        descriptionPristine: pristine
      });
      var _this$state2 = _this.state,
        namePristine = _this$state2.namePristine,
        stagePristine = _this$state2.stagePristine;
      var isFormPristine = pristine && namePristine && stagePristine;
      _this.onPristinityChange(isFormPristine);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onStagePristine", function (pristine) {
      _this.setState({
        stagePristine: pristine
      });
      var _this$state3 = _this.state,
        namePristine = _this$state3.namePristine,
        descriptionPristine = _this$state3.descriptionPristine;
      var isFormPristine = pristine && namePristine && descriptionPristine;
      _this.onPristinityChange(isFormPristine);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderSidebarContent", function () {
      var _this$props4 = _this.props,
        environmentModel = _this$props4.environmentModel,
        labelList = _this$props4.labelList,
        saveLabel = _this$props4.saveLabel;
      var filteredLabelList = (0, _differenceWith.default)(labelList, environmentModel.labels, _isEqual.default);
      return /*#__PURE__*/_react.default.createElement(_sidebarLabelList.default, {
        labelList: filteredLabelList,
        onClickLabel: _this.onAddLabel,
        saveLabel: saveLabel
      });
    });
    _this.state = {
      namePristine: true,
      descriptionPristine: true,
      stagePristine: true
    };
    _this.isNameValid = false;
    _this.isStageValid = false;
    return _this;
  }
  (0, _createClass2.default)(EnvironmentFormComponent, [{
    key: "isFormValid",
    get: function get() {
      return this.isNameValid && this.isStageValid;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props5 = this.props,
        environmentModel = _this$props5.environmentModel,
        environments = _this$props5.environments,
        stageList = _this$props5.stageList;
      var env = findEnvironmentById(environments, environmentModel.id);
      var subtitle = (0, _isEmpty.default)(env) ? 'New Environment' : env.title;
      var autocompleteHandler = function autocompleteHandler(_ref) {
        var metadata = _ref.metadata,
          objLabel = _ref.objLabel,
          suggestedElements = _ref.suggestedElements,
          value = _ref.value;
        return Promise.resolve((0, _sortBy.default)(stageList.filter(function (c) {
          return (0, _includes.default)(c.title.toLowerCase(), value.toLowerCase());
        }), ['title']));
      };
      var autocompleteHandlers = {
        addCandidates: autocompleteHandler
      };
      return /*#__PURE__*/_react.default.createElement(_reactSidebar.default, {
        contentClassName: "environment-form-content",
        docked: true,
        open: true,
        pullRight: true,
        shadow: false,
        sidebar: this.renderSidebarContent(),
        sidebarClassName: "environment-form-sidebar",
        transitions: false
      }, /*#__PURE__*/_react.default.createElement("h4", {
        className: "page-title",
        id: "environment-form-title"
      }, "Environments / ", subtitle), /*#__PURE__*/_react.default.createElement("div", {
        className: "environment-form"
      }, /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetString, {
        metadata: nameFormMetadata,
        model: environmentModel.title,
        onModelChange: this.onNameChange,
        onPristinityChange: this.onNamePristine,
        onValidityChange: this.onNameValidityChange,
        register: this.onRegister,
        validators: [nameValidator(environments, environmentModel.id), maxLengthValidator(nameFormMetadata.label, 255)]
      }), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
        handlers: autocompleteHandlers,
        metadata: selectFormMetadata,
        model: environmentModel.stage,
        objLabel: 'title',
        onModelChange: this.onStageChange,
        onPristinityChange: this.onStagePristine,
        onValidityChange: this.onStageValidityChange
      }), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetString, {
        metadata: descriptionFormMetadata,
        model: environmentModel.description,
        onModelChange: this.onDescriptionChange,
        onPristinityChange: this.onDescPristine,
        validators: [maxLengthValidator(descriptionFormMetadata.label, 1024)]
      }), /*#__PURE__*/_react.default.createElement(_widgetLinkedLabels.default, {
        labelList: environmentModel.labels,
        onDelete: this.onRemoveLabel
      })));
    }
  }]);
  return EnvironmentFormComponent;
}(_react.Component);
(0, _defineProperty2.default)(EnvironmentFormComponent, "propTypes", {
  environmentModel: _propTypes.default.shape({
    stage: _propTypes.default.shape({
      id: _propTypes.default.string,
      title: _propTypes.default.string
    }),
    description: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired,
    id: _propTypes.default.string,
    labels: _propTypes.default.arrayOf(_propTypes.default.shape({
      color: _propTypes.default.string.isRequired,
      id: _propTypes.default.string.isRequired,
      title: _propTypes.default.string.isRequired
    }))
  }).isRequired,
  environments: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string,
    title: _propTypes.default.string.isRequired,
    description: _propTypes.default.string
  })).isRequired,
  labelList: _propTypes.default.arrayOf(_propTypes.default.shape({
    color: _propTypes.default.string.isRequired,
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired
  }).isRequired).isRequired,
  onFormChange: _propTypes.default.func.isRequired,
  onPristinityChange: _propTypes.default.func.isRequired,
  onValidationChange: _propTypes.default.func.isRequired,
  saveLabel: _propTypes.default.func.isRequired,
  stageList: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired
  })).isRequired
});

/***/ }),

/***/ 52215:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.EnvironmentFormContainer = exports.EnvironmentForm = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _reactRedux = __webpack_require__(37703);
var _environmentFormActions = __webpack_require__(42726);
var _labelActions = __webpack_require__(3963);
var _environmentFormComponent = _interopRequireDefault(__webpack_require__(22055));
__webpack_require__(4285);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var EnvironmentForm = exports.EnvironmentForm = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EnvironmentForm, _Component);
  var _super = _createSuper(EnvironmentForm);
  function EnvironmentForm() {
    var _this;
    (0, _classCallCheck2.default)(this, EnvironmentForm);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleFormChange", function (environment) {
      var onFormChange = _this.props.onFormChange;
      onFormChange(environment);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleFormPristineChange", function (pristine) {
      var onFormPristineChange = _this.props.onFormPristineChange;
      onFormPristineChange(pristine);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleFormValidChange", function (valid) {
      var onFormValidChange = _this.props.onFormValidChange;
      onFormValidChange(valid);
    });
    return _this;
  }
  (0, _createClass2.default)(EnvironmentForm, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var initEnvironmentForm = this.props.initEnvironmentForm;
      initEnvironmentForm();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var cleanEnvironment = this.props.cleanEnvironment;
      cleanEnvironment();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        stageList = _this$props.stageList,
        environments = _this$props.environments,
        environmentModel = _this$props.environmentModel,
        saveLabel = _this$props.saveLabel,
        labelList = _this$props.labelList;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "environment-form-container"
      }, /*#__PURE__*/_react.default.createElement(_environmentFormComponent.default, {
        environmentModel: environmentModel,
        environments: environments,
        labelList: labelList,
        onFormChange: this.handleFormChange,
        onPristinityChange: this.handleFormPristineChange,
        onValidationChange: this.handleFormValidChange,
        saveLabel: saveLabel,
        stageList: stageList
      }));
    }
  }]);
  return EnvironmentForm;
}(_react.Component);
(0, _defineProperty2.default)(EnvironmentForm, "propTypes", {
  cleanEnvironment: _propTypes.default.func.isRequired,
  environmentId: _propTypes.default.string,
  environmentModel: _propTypes.default.shape({
    stage: _propTypes.default.shape({
      id: _propTypes.default.string,
      title: _propTypes.default.string
    }),
    id: _propTypes.default.string,
    labels: _propTypes.default.arrayOf(_propTypes.default.shape({
      color: _propTypes.default.string.isRequired,
      id: _propTypes.default.string.isRequired,
      title: _propTypes.default.string.isRequired
    })),
    title: _propTypes.default.string.isRequired,
    description: _propTypes.default.string.isRequired
  }).isRequired,
  environments: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string,
    title: _propTypes.default.string.isRequired,
    description: _propTypes.default.string
  })).isRequired,
  initEnvironmentForm: _propTypes.default.func.isRequired,
  labelList: _propTypes.default.arrayOf(_propTypes.default.shape({
    color: _propTypes.default.string.isRequired,
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired
  }).isRequired).isRequired,
  onFormChange: _propTypes.default.func.isRequired,
  onFormPristineChange: _propTypes.default.func.isRequired,
  onFormValidChange: _propTypes.default.func.isRequired,
  saveLabel: _propTypes.default.func.isRequired,
  stageList: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired
  })).isRequired
});
var mapStateToProps = function mapStateToProps(state) {
  return {
    environmentModel: state.environmentForm.environmentModel,
    environments: state.environmentForm.environments,
    stageList: state.environmentStages.stageList,
    labelList: state.labels.labelList
  };
};
var mergeProps = function mergeProps(stateProps, dispatchProps, ownProps) {
  return _objectSpread(_objectSpread(_objectSpread(_objectSpread({}, ownProps), stateProps), dispatchProps), {}, {
    initEnvironmentForm: function initEnvironmentForm() {
      return dispatchProps.initEnvironmentForm(ownProps.environmentId, ownProps.environments);
    }
  });
};
var EnvironmentFormContainer = exports.EnvironmentFormContainer = (0, _reactRedux.connect)(mapStateToProps, {
  cleanEnvironment: _environmentFormActions.cleanEnvironment,
  initEnvironmentForm: _environmentFormActions.initEnvironmentForm,
  onFormChange: _environmentFormActions.onFormChange,
  onFormPristineChange: _environmentFormActions.onFormPristineChange,
  onFormValidChange: _environmentFormActions.onFormValidChange,
  saveLabel: _labelActions.saveLabel
}, mergeProps)(EnvironmentForm);

/***/ }),

/***/ 6188:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _xlReactComponents = __webpack_require__(67082);
var _includes = _interopRequireDefault(__webpack_require__(64721));
var _labelItem = _interopRequireDefault(__webpack_require__(36159));
var _labelModalFormComponent = _interopRequireDefault(__webpack_require__(68113));
var _labelListComponent = __webpack_require__(92188);
__webpack_require__(62035);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var filterLabelFieldMetadata = {
  placeholder: 'Filter by label...'
};
var SidebarLabelList = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(SidebarLabelList, _Component);
  var _super = _createSuper(SidebarLabelList);
  function SidebarLabelList(props) {
    var _this;
    (0, _classCallCheck2.default)(this, SidebarLabelList);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onNameChange", function (name) {
      _this.setState({
        labelFilterText: name
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "filterLabels", function (envLabel) {
      var labelFilterText = _this.state.labelFilterText;
      return (0, _includes.default)(envLabel.title.toLowerCase(), labelFilterText.toLowerCase());
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "showCreateLabelModal", function () {
      _this.setState({
        modalIsOpen: true,
        envLabel: (0, _labelListComponent.initEnvLabelState)()
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onConfirmEditModal", function (envLabel, isCreateAnother) {
      _this.props.saveLabel({
        title: envLabel.title,
        color: envLabel.color
      });
      _this.setState({
        modalIsOpen: isCreateAnother,
        envLabel: (0, _labelListComponent.initEnvLabelState)()
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCancelEditModal", function () {
      _this.setState({
        modalIsOpen: false,
        envLabel: (0, _labelListComponent.initEnvLabelState)()
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderLabels", function () {
      var _this$props = _this.props,
        labelList = _this$props.labelList,
        onClickLabel = _this$props.onClickLabel;
      return labelList.filter(function (envLabel) {
        return _this.filterLabels(envLabel);
      }).map(function (envLabel) {
        return /*#__PURE__*/_react.default.createElement(_labelItem.default, {
          envLabel: envLabel,
          key: envLabel.id,
          onClickLabel: onClickLabel,
          skin: 'plus'
        });
      });
    });
    _this.state = {
      envLabel: (0, _labelListComponent.initEnvLabelState)(),
      modalIsOpen: false,
      labelFilterText: ''
    };
    return _this;
  }
  (0, _createClass2.default)(SidebarLabelList, [{
    key: "render",
    value: function render() {
      var labelList = this.props.labelList;
      var _this$state = this.state,
        envLabel = _this$state.envLabel,
        modalIsOpen = _this$state.modalIsOpen;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        className: "environment-label-sidebar"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "header"
      }, /*#__PURE__*/_react.default.createElement("h4", {
        className: "page-title"
      }, "Labels", /*#__PURE__*/_react.default.createElement("button", {
        className: "button pull-right",
        onClick: this.showCreateLabelModal,
        type: "button"
      }, "New label")), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetFilter, {
        metadata: filterLabelFieldMetadata,
        onUpdate: this.onNameChange
      })), /*#__PURE__*/_react.default.createElement("div", {
        className: "environment-sidebar-label-list"
      }, this.renderLabels())), /*#__PURE__*/_react.default.createElement(_labelModalFormComponent.default, {
        envLabelList: labelList,
        envLabelModel: envLabel,
        modalIsOpen: modalIsOpen,
        onModalCancel: this.onCancelEditModal,
        onModalConfirm: this.onConfirmEditModal
      }));
    }
  }]);
  return SidebarLabelList;
}(_react.Component);
(0, _defineProperty2.default)(SidebarLabelList, "propTypes", {
  labelList: _propTypes.default.arrayOf(_propTypes.default.shape({
    color: _propTypes.default.string.isRequired,
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired
  }).isRequired).isRequired,
  onClickLabel: _propTypes.default.func.isRequired,
  saveLabel: _propTypes.default.func.isRequired
});
(0, _defineProperty2.default)(SidebarLabelList, "defaultProps", {
  labelList: {}
});

/***/ }),

/***/ 92188:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.initEnvLabelState = exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _clone = _interopRequireDefault(__webpack_require__(66678));
var _labelListHeaderComponent = _interopRequireDefault(__webpack_require__(18304));
var _labelItem = _interopRequireDefault(__webpack_require__(36159));
var _labelModalFormComponent = _interopRequireDefault(__webpack_require__(68113));
var _components = __webpack_require__(78605);
__webpack_require__(61513);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var initEnvLabelState = exports.initEnvLabelState = function initEnvLabelState() {
  return {
    id: null,
    title: '',
    color: ''
  };
};
var helpMessage = "Use Labels to identify your environments. You also use Labels to filter the environment scheduler and dashboards.";
var LabelListComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(LabelListComponent, _Component);
  var _super = _createSuper(LabelListComponent);
  function LabelListComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, LabelListComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFilterChange", function (title) {
      _this.props.searchLabels(title);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "showCreateModal", function () {
      _this.setState({
        modalIsOpen: true,
        envLabel: initEnvLabelState()
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "showEditModal", function (envLabel) {
      _this.setState({
        modalIsOpen: true,
        envLabel: (0, _clone.default)(envLabel)
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onConfirmEditModal", function (envLabel, isCreateAnother) {
      _this.props.saveLabel(envLabel);
      var envLabelState = initEnvLabelState();
      if (isCreateAnother) {
        envLabelState.color = envLabel.color;
      }
      _this.setState({
        modalIsOpen: isCreateAnother,
        envLabel: envLabelState
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCancelEditModal", function () {
      _this.setState({
        modalIsOpen: false,
        envLabel: initEnvLabelState()
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onConfirmDeleteModal", function (envLabel) {
      _this.props.deleteLabel(envLabel);
      _this.onCancelEditModal();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderEnvLabel", function (envLabel) {
      return /*#__PURE__*/_react.default.createElement(_labelItem.default, {
        envLabel: envLabel,
        isEditable: true,
        key: envLabel.id,
        onClickLabel: _this.showEditModal
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderLabels", function () {
      var labelList = _this.props.labelList;
      var labels = labelList.map(_this.renderEnvLabel);
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "margin"
      }, /*#__PURE__*/_react.default.createElement("h4", {
        className: "page-title"
      }, "Labels (", labels.length, ")"), /*#__PURE__*/_react.default.createElement(_components.HelpBlock, {
        className: "help-message-container"
      }, helpMessage), labels.length ? labels : /*#__PURE__*/_react.default.createElement(_components.NoData, {
        className: "no-labels-message",
        message: "No labels found."
      }));
    });
    _this.state = {
      modalIsOpen: false,
      envLabel: initEnvLabelState()
    };
    return _this;
  }
  (0, _createClass2.default)(LabelListComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.searchLabels();
    }
  }, {
    key: "render",
    value: function render() {
      var labelList = this.props.labelList;
      var _this$state = this.state,
        modalIsOpen = _this$state.modalIsOpen,
        envLabel = _this$state.envLabel;
      return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_labelListHeaderComponent.default, {
        onCreate: this.showCreateModal,
        onFilterChange: this.onFilterChange
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "header-shadow"
      }), this.renderLabels(), /*#__PURE__*/_react.default.createElement(_labelModalFormComponent.default, {
        envLabelList: labelList,
        envLabelModel: envLabel,
        modalIsOpen: modalIsOpen,
        onModalCancel: this.onCancelEditModal,
        onModalConfirm: this.onConfirmEditModal,
        onModalDelete: this.onConfirmDeleteModal
      }));
    }
  }]);
  return LabelListComponent;
}(_react.Component);
(0, _defineProperty2.default)(LabelListComponent, "propTypes", {
  deleteLabel: _propTypes.default.func.isRequired,
  labelList: _propTypes.default.arrayOf(_propTypes.default.shape({
    color: _propTypes.default.string.isRequired,
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired
  }).isRequired).isRequired,
  saveLabel: _propTypes.default.func.isRequired,
  searchLabels: _propTypes.default.func.isRequired
});

/***/ }),

/***/ 2363:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LabelListContainer = void 0;
var _reactRedux = __webpack_require__(37703);
var _labelActions = __webpack_require__(3963);
var _labelListComponent = _interopRequireDefault(__webpack_require__(92188));
var mapStateToProps = function mapStateToProps(state) {
  return {
    labelList: state.labels.labelList
  };
};
var LabelListContainer = exports.LabelListContainer = (0, _reactRedux.connect)(mapStateToProps, {
  deleteLabel: _labelActions.deleteLabel,
  searchLabels: _labelActions.searchLabels,
  saveLabel: _labelActions.saveLabel
})(_labelListComponent.default);

/***/ }),

/***/ 18304:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _xlReactComponents = __webpack_require__(67082);
var _dotComponents = __webpack_require__(92140);
var _actionToolbar = __webpack_require__(29755);
var _headerComponent = _interopRequireDefault(__webpack_require__(39470));
__webpack_require__(23472);
__webpack_require__(86647);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var LabelListHeaderComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(LabelListHeaderComponent, _Component);
  var _super = _createSuper(LabelListHeaderComponent);
  function LabelListHeaderComponent() {
    var _this;
    (0, _classCallCheck2.default)(this, LabelListHeaderComponent);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "showCreateModal", function () {
      _this.props.onCreate();
    });
    return _this;
  }
  (0, _createClass2.default)(LabelListHeaderComponent, [{
    key: "render",
    value: function render() {
      var onFilterChange = this.props.onFilterChange;
      var filterFieldMetadata = {
        placeholder: 'Filter by label...'
      };
      return /*#__PURE__*/_react.default.createElement(_headerComponent.default, null, /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, {
        helpLink: "how-to/using-environments.html"
      }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
        onClick: this.showCreateModal
      }, "New label")), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetFilter, {
        metadata: filterFieldMetadata,
        onUpdate: onFilterChange
      }));
    }
  }]);
  return LabelListHeaderComponent;
}(_react.Component);
(0, _defineProperty2.default)(LabelListHeaderComponent, "propTypes", {
  onCreate: _propTypes.default.func.isRequired,
  onFilterChange: _propTypes.default.func.isRequired
});

/***/ }),

/***/ 68113:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _isEmpty = _interopRequireDefault(__webpack_require__(41609));
var _isNil = _interopRequireDefault(__webpack_require__(14293));
var _xlReactComponents = __webpack_require__(67082);
var _reactColor = __webpack_require__(6089);
var _components = __webpack_require__(78605);
var _validators = __webpack_require__(36735);
var _colors = _interopRequireDefault(__webpack_require__(70925));
__webpack_require__(23472);
__webpack_require__(86647);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var createButton = {
  action: 'create',
  className: 'button primary',
  keyCodes: [13],
  label: 'Create'
};
var updateButton = {
  action: 'update',
  className: 'button primary',
  keyCodes: [13],
  label: 'Save'
};
var deleteButton = {
  action: 'delete',
  className: 'button secondary',
  label: 'Delete'
};
var deleteModalDeleteButton = {
  action: 'delete-modal-ok',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var deleteModalCancelButton = {
  action: 'delete-modal-cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var titleFieldMetadata = {
  label: 'Name',
  placeholder: 'Add...',
  description: 'Name of the label',
  required: true
};
var nameValidator = function nameValidator(envLabelList) {
  var id = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  return function (name) {
    return {
      condition: (0, _validators.itemAlreadyDefined)(envLabelList, id, 'title', name),
      message: (0, _validators.createErrorMessage)('Label already exists')
    };
  };
};
var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: (0, _validators.validateMaxLength)(inputText, maxLength),
      message: (0, _validators.createErrorMessage)("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};
var defaultColorList = [_colors.default.blue, _colors.default.green, _colors.default.orange, _colors.default.red, _colors.default.gray, _colors.default.purple];
var LabelModalFormComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(LabelModalFormComponent, _Component);
  var _super = _createSuper(LabelModalFormComponent);
  function LabelModalFormComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, LabelModalFormComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onRegister", function (componentApi) {
      componentApi.focus();
      _this.componentApi = componentApi;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "closeModal", function () {
      _this.cancelForm();
      _this.resetForm();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onButtonClick", function (action) {
      var _this$props = _this.props,
        onModalConfirm = _this$props.onModalConfirm,
        onModalDelete = _this$props.onModalDelete;
      var _this$state = _this.state,
        createAnother = _this$state.createAnother,
        labelModel = _this$state.labelModel;
      switch (action) {
        case createButton.action:
          onModalConfirm(labelModel, createAnother);
          _this.resetForm();
          break;
        case updateButton.action:
          onModalConfirm(labelModel, createAnother);
          _this.resetForm();
          break;
        case deleteButton.action:
          _this.setState({
            isDeleteModal: true
          });
          break;
        case deleteModalCancelButton.action:
          _this.setState({
            isDeleteModal: false
          });
          break;
        case deleteModalDeleteButton.action:
          _this.setState({
            isDeleteModal: false
          });
          if (onModalDelete) {
            onModalDelete(labelModel);
          }
          break;
        default:
          _this.cancelForm();
          _this.resetForm();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "cancelForm", function () {
      _this.setState({
        createAnother: false
      });
      _this.props.onModalCancel();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "resetForm", function () {
      _this.colorIsChanged = null;
      _this.setState({
        labelModel: null
      });
      if (_this.componentApi) {
        _this.componentApi.resetPristinity();
        _this.componentApi.focus();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCheckboxClick", function (value) {
      _this.setState({
        createAnother: value.target.checked
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onModelChange", function (title) {
      var labelModel = _this.state.labelModel;
      if (title !== labelModel.title) {
        _this.setState({
          labelModel: _objectSpread(_objectSpread({}, labelModel), {}, {
            title: title
          })
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleValidityChange", function (valid) {
      _this.isValid = valid;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handlePristinityChange", function (pristine) {
      _this.isPristine = pristine;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onColorChangeComplete", function (color) {
      var labelModel = _this.state.labelModel;
      if (labelModel.color !== color.hex) {
        _this.colorIsChanged = true;
      }
      _this.setState({
        displayColorPicker: false,
        labelModel: _objectSpread(_objectSpread({}, labelModel), {}, {
          color: color.hex
        })
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "openColorPicker", function () {
      _this.setState({
        displayColorPicker: !_this.state.displayColorPicker
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "closeColorPicker", function () {
      _this.setState({
        displayColorPicker: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderColorPickerPopover", function () {
      var displayColorPicker = _this.state.displayColorPicker;
      var color = _this.props.envLabelModel.color;
      return displayColorPicker ? /*#__PURE__*/_react.default.createElement("div", {
        className: "color-picker-popover"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "cover",
        onClick: _this.closeColorPicker
      }), /*#__PURE__*/_react.default.createElement(_reactColor.TwitterPicker, {
        color: color,
        colors: defaultColorList,
        onChangeComplete: _this.onColorChangeComplete,
        width: "204"
      })) : null;
    });
    _this.state = {
      createAnother: false,
      displayColorPicker: false,
      isDeleteModal: false,
      labelModel: null,
      prevModel: null
    };
    _this.isPristine = null;
    _this.isValid = null;
    _this.colorIsChanged = null;
    _this.componentApi = null;
    return _this;
  }
  (0, _createClass2.default)(LabelModalFormComponent, [{
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var _this$props2 = this.props,
        envLabelModel = _this$props2.envLabelModel,
        modalIsOpen = _this$props2.modalIsOpen;
      return /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetConfirmationDialog, {
        buttons: [deleteModalCancelButton, deleteModalDeleteButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onButtonClick,
        show: modalIsOpen,
        title: "Delete label"
      }, /*#__PURE__*/_react.default.createElement(_components.AlertMessage, {
        alertType: _components.alertType.WARNING
      }, /*#__PURE__*/_react.default.createElement("p", null, "Deleting a label can lead to missing data for connected resources on reporting and environment scheduling.")), /*#__PURE__*/_react.default.createElement("p", null, "You are about to delete label ", /*#__PURE__*/_react.default.createElement("strong", null, envLabelModel.title), "."));
    }
  }, {
    key: "renderEditModal",
    value: function renderEditModal() {
      var _this$props3 = this.props,
        modalIsOpen = _this$props3.modalIsOpen,
        envLabelList = _this$props3.envLabelList,
        envLabelModel = _this$props3.envLabelModel;
      var labelModel = this.state.labelModel;
      var confirmActionButtonDisabled = this.isPristine && !this.colorIsChanged || !this.isValid;
      var buttons = [cancelButton];
      var modalTitle, modalSkin;
      if ((0, _isNil.default)(envLabelModel.id)) {
        createButton.disabled = confirmActionButtonDisabled;
        buttons.push(createButton);
        modalTitle = 'New label';
        modalSkin = 'checkbox';
      } else {
        updateButton.disabled = confirmActionButtonDisabled;
        buttons.push(deleteButton);
        buttons.push(updateButton);
        modalTitle = 'Edit label';
        modalSkin = 'default';
      }
      if ((0, _isEmpty.default)(envLabelModel.color)) {
        envLabelModel.color = defaultColorList[0];
      }
      var modalHeader = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, modalTitle, /*#__PURE__*/_react.default.createElement("button", {
        className: "btn-close",
        onClick: this.closeModal,
        type: "button"
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetConfirmationDialog, {
        buttons: buttons,
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onButtonClick,
        onCheckboxClick: this.onCheckboxClick,
        show: modalIsOpen,
        skin: modalSkin,
        title: modalHeader
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "environment-label-form"
      }, /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetString, {
        metadata: titleFieldMetadata,
        model: labelModel.title,
        onModelChange: this.onModelChange,
        onPristinityChange: this.handlePristinityChange,
        onValidityChange: this.handleValidityChange,
        register: this.onRegister,
        validators: [nameValidator(envLabelList, labelModel.id), maxLengthValidator(titleFieldMetadata.label, 255)]
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "xl-react-components"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "xl-react-components-label"
      }, /*#__PURE__*/_react.default.createElement("label", null, "Color", /*#__PURE__*/_react.default.createElement("span", {
        className: "required"
      }, "*"))), /*#__PURE__*/_react.default.createElement("div", {
        className: "xl-react-components-input"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "swatch",
        onClick: this.openColorPicker
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "color",
        style: {
          background: labelModel.color
        }
      })), this.renderColorPickerPopover()))));
    }
  }, {
    key: "render",
    value: function render() {
      var isDeleteModal = this.state.isDeleteModal;
      return isDeleteModal ? this.renderDeleteModal() : this.renderEditModal();
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (!state.labelModel || props.envLabelModel.title !== state.prevModel.title) {
        return _objectSpread(_objectSpread({}, state), {}, {
          labelModel: props.envLabelModel,
          prevModel: props.envLabelModel
        });
      }
      return null;
    }
  }]);
  return LabelModalFormComponent;
}(_react.Component);
(0, _defineProperty2.default)(LabelModalFormComponent, "propTypes", {
  envLabelList: _propTypes.default.arrayOf(_propTypes.default.shape({
    color: _propTypes.default.string.isRequired,
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired
  }).isRequired).isRequired,
  envLabelModel: _propTypes.default.shape({
    color: _propTypes.default.string,
    id: _propTypes.default.string,
    title: _propTypes.default.string
  }).isRequired,
  modalIsOpen: _propTypes.default.bool.isRequired,
  onModalCancel: _propTypes.default.func.isRequired,
  onModalConfirm: _propTypes.default.func.isRequired,
  onModalDelete: _propTypes.default.func
});

/***/ }),

/***/ 90745:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _environmentManagementStore = __webpack_require__(68124);
var _labelListContainer = __webpack_require__(2363);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var LabelPage = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(LabelPage, _Component);
  var _super = _createSuper(LabelPage);
  function LabelPage() {
    (0, _classCallCheck2.default)(this, LabelPage);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(LabelPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
        store: _environmentManagementStore.store
      }, /*#__PURE__*/_react.default.createElement(_labelListContainer.LabelListContainer, null));
    }
  }]);
  return LabelPage;
}(_react.Component);

/***/ }),

/***/ 99343:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _environmentListItemComponent = _interopRequireDefault(__webpack_require__(59116));
var _components = __webpack_require__(78605);
__webpack_require__(61513);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var helpMessage = "Use Environments to define environments that are available in your organization. You can also use Environments to filter the environment scheduler and dashboards.";
var EnvironmentListComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EnvironmentListComponent, _Component);
  var _super = _createSuper(EnvironmentListComponent);
  function EnvironmentListComponent() {
    var _this;
    (0, _classCallCheck2.default)(this, EnvironmentListComponent);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderHeader", function () {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "application-list-header"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "col-xs-7"
      }, "Name"), /*#__PURE__*/_react.default.createElement("span", {
        className: "col-xs-2"
      }, "Stage"), /*#__PURE__*/_react.default.createElement("div", {
        className: "col-xs-3"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "pull-right action-section"
      }, "Actions")));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderEnvironmentList", function () {
      var _this$props = _this.props,
        environments = _this$props.environments,
        onEditEnvironment = _this$props.onEditEnvironment,
        onDeleteEnvironment = _this$props.onDeleteEnvironment;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _this.renderHeader(), environments.map(function (environment) {
        return /*#__PURE__*/_react.default.createElement(_environmentListItemComponent.default, {
          environment: environment,
          key: environment.title,
          onDeleteEnvironment: onDeleteEnvironment,
          onEditEnvironment: onEditEnvironment
        });
      }));
    });
    return _this;
  }
  (0, _createClass2.default)(EnvironmentListComponent, [{
    key: "render",
    value: function render() {
      var environments = this.props.environments;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "margin"
      }, /*#__PURE__*/_react.default.createElement("h4", {
        className: "page-title"
      }, "Environments (", environments.length, ")"), /*#__PURE__*/_react.default.createElement(_components.HelpBlock, {
        className: "help-message-container"
      }, helpMessage), environments.length ? this.renderEnvironmentList() : /*#__PURE__*/_react.default.createElement(_components.NoData, {
        message: "No environments found."
      }));
    }
  }]);
  return EnvironmentListComponent;
}(_react.Component);
(0, _defineProperty2.default)(EnvironmentListComponent, "propTypes", {
  environments: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string,
    title: _propTypes.default.string.isRequired,
    description: _propTypes.default.string
  }).isRequired).isRequired,
  onDeleteEnvironment: _propTypes.default.func.isRequired,
  onEditEnvironment: _propTypes.default.func.isRequired
});

/***/ }),

/***/ 80866:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _includes = _interopRequireDefault(__webpack_require__(64721));
var _sortBy = _interopRequireDefault(__webpack_require__(89734));
var _xlReactComponents = __webpack_require__(67082);
var _dotComponents = __webpack_require__(92140);
var _headerComponent = _interopRequireDefault(__webpack_require__(39470));
var _types = __webpack_require__(57809);
var _actionToolbar = __webpack_require__(29755);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var selectStageMetadata = {
  placeholder: 'Filter by stage...'
};
var EnvironmentListHeaderComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EnvironmentListHeaderComponent, _Component);
  var _super = _createSuper(EnvironmentListHeaderComponent);
  function EnvironmentListHeaderComponent() {
    (0, _classCallCheck2.default)(this, EnvironmentListHeaderComponent);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(EnvironmentListHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        stages = _this$props.stages,
        filterStage = _this$props.filterStage,
        filterEnvironmentName = _this$props.filterEnvironmentName,
        onAddNewEnvironment = _this$props.onAddNewEnvironment,
        onStageChange = _this$props.onStageChange,
        onFilterChange = _this$props.onFilterChange;
      var filterOptions = {
        placeholder: 'Filter by environment...'
      };
      var autocompleteHandler = function autocompleteHandler(_ref) {
        var metadata = _ref.metadata,
          objLabel = _ref.objLabel,
          suggestedElements = _ref.suggestedElements,
          value = _ref.value;
        return Promise.resolve((0, _sortBy.default)(stages.filter(function (c) {
          return (0, _includes.default)(c.title.toLowerCase(), value.toLowerCase());
        }), ['title']));
      };
      var autocompleteHandlers = {
        addCandidates: autocompleteHandler
      };
      return /*#__PURE__*/_react.default.createElement(_headerComponent.default, null, /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, {
        helpLink: "how-to/using-environments.html"
      }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
        onClick: onAddNewEnvironment
      }, "New environment")), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetFilter, {
        metadata: filterOptions,
        model: filterEnvironmentName,
        onUpdate: onFilterChange
      }), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
        className: "env-stage-filter",
        handlers: autocompleteHandlers,
        metadata: selectStageMetadata,
        model: filterStage,
        objLabel: 'title',
        onModelChange: onStageChange
      }));
    }
  }]);
  return EnvironmentListHeaderComponent;
}(_react.Component);
(0, _defineProperty2.default)(EnvironmentListHeaderComponent, "propTypes", {
  filterEnvironmentName: _propTypes.default.string.isRequired,
  filterStage: _types.Stage,
  onAddNewEnvironment: _propTypes.default.func.isRequired,
  onFilterChange: _propTypes.default.func.isRequired,
  onStageChange: _propTypes.default.func.isRequired,
  stages: _propTypes.default.arrayOf(_types.Stage)
});

/***/ }),

/***/ 59116:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _classnames = _interopRequireDefault(__webpack_require__(94184));
var _labelItem = _interopRequireDefault(__webpack_require__(36159));
var _types = __webpack_require__(57809);
var _dotIconWrapper = __webpack_require__(23287);
__webpack_require__(30370);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var EnvironmentListItemComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EnvironmentListItemComponent, _Component);
  var _super = _createSuper(EnvironmentListItemComponent);
  function EnvironmentListItemComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, EnvironmentListItemComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEditEnvironment", function (event) {
      event.stopPropagation();
      _this.props.onEditEnvironment(_this.props.environment);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDeleteEnvironment", function (event) {
      event.stopPropagation();
      _this.props.onDeleteEnvironment(_this.props.environment);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderEnvironmentTitle", function () {
      var environment = _this.props.environment;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "environment-title-container"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "col-xs-7 environment-title",
        title: environment.title
      }, /*#__PURE__*/_react.default.createElement(_dotIconWrapper.DotIconWrapper, {
        className: "mrs",
        iconId: "environment"
      }), /*#__PURE__*/_react.default.createElement("strong", null, environment.title)), /*#__PURE__*/_react.default.createElement("span", {
        className: "col-xs-2"
      }, environment.stage.title), /*#__PURE__*/_react.default.createElement("div", {
        className: "actions-container col-xs-3"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "actions pull-right"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "link color-inherited",
        "data-test": "edit-action",
        onClick: _this.onEditEnvironment
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "menu-item-icon xl-icon edit-icon",
        title: "Edit"
      }), /*#__PURE__*/_react.default.createElement("span", {
        className: "action-label"
      }, "Edit")), /*#__PURE__*/_react.default.createElement("span", {
        className: "link delete",
        "data-test": "delete-action",
        onClick: _this.onDeleteEnvironment
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      }), /*#__PURE__*/_react.default.createElement("span", {
        className: "action-label"
      }, "Delete")))));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderEnvironmentLabels", function () {
      var labels = _this.props.environment.labels;
      if (!labels.length) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "environment-labels"
      }, labels.map(function (type) {
        return /*#__PURE__*/_react.default.createElement(_labelItem.default, {
          envLabel: type,
          key: type.id
        });
      }));
    });
    _this.state = {
      isSelected: false
    };
    return _this;
  }
  (0, _createClass2.default)(EnvironmentListItemComponent, [{
    key: "render",
    value: function render() {
      var environment = this.props.environment;
      var isSelected = this.state.isSelected;
      var panelClass = (0, _classnames.default)('panel', 'panel-default', 'environment-panel', {
        'panel-hover': isSelected
      });
      return /*#__PURE__*/_react.default.createElement("div", {
        className: panelClass,
        onClick: this.onEditEnvironment
      }, this.renderEnvironmentTitle(), (environment.description || !!environment.labels.length) && /*#__PURE__*/_react.default.createElement("div", {
        className: "environment-title-separator"
      }), environment.description && /*#__PURE__*/_react.default.createElement("div", {
        className: "environment-description"
      }, environment.description), this.renderEnvironmentLabels());
    }
  }]);
  return EnvironmentListItemComponent;
}(_react.Component);
(0, _defineProperty2.default)(EnvironmentListItemComponent, "propTypes", {
  environment: _types.Environment.isRequired,
  onDeleteEnvironment: _propTypes.default.func.isRequired,
  onEditEnvironment: _propTypes.default.func.isRequired
});

/***/ }),

/***/ 52711:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.EnvironmentListPageContainer = exports.EnvironmentListPageComponent = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _reactRedux = __webpack_require__(37703);
var _xlReactComponents = __webpack_require__(67082);
var _environmentListHeaderComponent = _interopRequireDefault(__webpack_require__(80866));
var _environmentListComponent = _interopRequireDefault(__webpack_require__(99343));
var _environmentActions = __webpack_require__(32385);
var _environmentSelectors = __webpack_require__(7478);
var _components = __webpack_require__(78605);
var _types = __webpack_require__(57809);
__webpack_require__(23472);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var EnvironmentListPageComponent = exports.EnvironmentListPageComponent = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EnvironmentListPageComponent, _Component);
  var _super = _createSuper(EnvironmentListPageComponent);
  function EnvironmentListPageComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, EnvironmentListPageComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleFilterChange", function (environmentName) {
      _this.props.titleFilterChange(environmentName);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleStageChange", function (stage) {
      if (stage) {
        _this.props.stageFilterChange(stage);
      }
    });
    // modal properties
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "buttons", [{
      action: 'cancel',
      className: 'button cancel',
      keyCodes: [27],
      label: 'Cancel'
    }, {
      action: 'ok',
      className: 'button primary',
      keyCodes: [13],
      label: 'Delete'
    }]);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "openConfirmationDialog", function (environment) {
      _this.setState({
        show: true,
        environmentForDelete: environment
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onClose", function (action) {
      if (action === 'ok') {
        _this.props.onDeleteEnvironment(_this.state.environmentForDelete);
      }
      _this.setState({
        show: false,
        environmentForDelete: null
      });
    });
    _this.state = {
      show: false,
      environmentForDelete: null
    };
    return _this;
  }
  (0, _createClass2.default)(EnvironmentListPageComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.initEnvironmentList();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        stages = _this$props.stages,
        filterStage = _this$props.filterStage,
        filterEnvironmentName = _this$props.filterEnvironmentName,
        onAddEnvironment = _this$props.onAddEnvironment,
        environments = _this$props.environments,
        onEditEnvironment = _this$props.onEditEnvironment;
      return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_environmentListHeaderComponent.default, {
        filterEnvironmentName: filterEnvironmentName,
        filterStage: filterStage,
        onAddNewEnvironment: onAddEnvironment,
        onFilterChange: this.handleFilterChange,
        onStageChange: this.handleStageChange,
        stages: stages
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "header-shadow"
      }), /*#__PURE__*/_react.default.createElement(_environmentListComponent.default, {
        environments: environments,
        onDeleteEnvironment: this.openConfirmationDialog,
        onEditEnvironment: onEditEnvironment
      }), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetConfirmationDialog, {
        buttons: this.buttons,
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onClose,
        show: this.state.show,
        title: "Delete environment"
      }, /*#__PURE__*/_react.default.createElement(_components.AlertMessage, {
        alertType: _components.alertType.WARNING
      }, /*#__PURE__*/_react.default.createElement("p", null, "Deleting an environment can lead to missing data for connected resources on reporting and environment scheduling.")), /*#__PURE__*/_react.default.createElement("p", null, "You are about to delete environment ", /*#__PURE__*/_react.default.createElement("strong", null, this.state.environmentForDelete ? this.state.environmentForDelete.title : ''), ".")));
    }
  }]);
  return EnvironmentListPageComponent;
}(_react.Component);
(0, _defineProperty2.default)(EnvironmentListPageComponent, "propTypes", {
  environments: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string,
    title: _propTypes.default.string.isRequired,
    description: _propTypes.default.string
  }).isRequired).isRequired,
  filterEnvironmentName: _propTypes.default.string.isRequired,
  filterStage: _types.Stage,
  initEnvironmentList: _propTypes.default.func.isRequired,
  onAddEnvironment: _propTypes.default.func.isRequired,
  onDeleteEnvironment: _propTypes.default.func.isRequired,
  onEditEnvironment: _propTypes.default.func.isRequired,
  searchEnvironments: _propTypes.default.func.isRequired,
  stageFilterChange: _propTypes.default.func.isRequired,
  stages: _propTypes.default.arrayOf(_types.Stage),
  titleFilterChange: _propTypes.default.func.isRequired
});
var mapStateToProps = function mapStateToProps(state) {
  return {
    stages: state.environmentStages.stageList,
    environments: (0, _environmentSelectors.getFilteredEnvironments)(state),
    filterStage: state.environmentList.filters.stage,
    filterEnvironmentName: state.environmentList.filters.title
  };
};
var EnvironmentListPageContainer = exports.EnvironmentListPageContainer = (0, _reactRedux.connect)(mapStateToProps, {
  stageFilterChange: _environmentActions.stageFilterChange,
  initEnvironmentList: _environmentActions.initEnvironmentList,
  onAddEnvironment: _environmentActions.onAddEnvironment,
  onDeleteEnvironment: _environmentActions.onDeleteEnvironment,
  onEditEnvironment: _environmentActions.onEditEnvironment,
  searchEnvironments: _environmentActions.searchEnvironments,
  titleFilterChange: _environmentActions.titleFilterChange
})(EnvironmentListPageComponent);

/***/ }),

/***/ 42775:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _environmentManagementStore = __webpack_require__(68124);
var _environmentListPageContainer = __webpack_require__(52711);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var EnvironmentListPage = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EnvironmentListPage, _Component);
  var _super = _createSuper(EnvironmentListPage);
  function EnvironmentListPage() {
    (0, _classCallCheck2.default)(this, EnvironmentListPage);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(EnvironmentListPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
        store: _environmentManagementStore.store
      }, /*#__PURE__*/_react.default.createElement(_environmentListPageContainer.EnvironmentListPageContainer, null));
    }
  }]);
  return EnvironmentListPage;
}(_react.Component);

/***/ }),

/***/ 14092:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _xlReactComponents = __webpack_require__(67082);
var _validators = __webpack_require__(36735);
var _types = __webpack_require__(57809);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var nameOptions = {
  label: 'Name',
  description: 'Name of the stage',
  required: true
};
var nameValidator = function nameValidator(stageList, id) {
  return function (name) {
    return {
      condition: (0, _validators.itemAlreadyDefined)(stageList, id, 'title', name),
      message: (0, _validators.createErrorMessage)('Stage already exists')
    };
  };
};
var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: (0, _validators.validateMaxLength)(inputText, maxLength),
      message: (0, _validators.createErrorMessage)("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};
var StageEditModal = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(StageEditModal, _Component);
  var _super = _createSuper(StageEditModal);
  function StageEditModal(props) {
    var _this;
    (0, _classCallCheck2.default)(this, StageEditModal);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onRegister", function (componentApi) {
      componentApi.focus();
      _this.componentApi = componentApi;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "closeModal", function () {
      _this.handleButtonClick(cancelButton.action);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleButtonClick", function (action) {
      var _this$props = _this.props,
        onCancel = _this$props.onCancel,
        onSave = _this$props.onSave;
      var stage = _this.state.stage;
      switch (action) {
        case 'update':
          onSave(stage);
          break;
        case 'cancel':
          onCancel();
          break;
        default:
          throw 'Unknown action';
      }
      _this.resetForm();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleModelChange", function (newTitle) {
      var stage = _this.state.stage;
      if (newTitle !== stage.title) {
        _this.setState({
          stage: _objectSpread(_objectSpread({}, stage), {}, {
            title: newTitle
          })
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleValidityChange", function (valid) {
      _this.isValid = valid;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handlePristinityChange", function (pristine) {
      _this.isPristine = pristine;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "resetForm", function () {
      _this.setState({
        stage: null
      });
      if (_this.componentApi) {
        _this.componentApi.resetPristinity();
      }
    });
    _this.state = {
      stage: null,
      prevModel: null
    };
    _this.isPristine = null;
    _this.isValid = null;
    _this.componentApi = null;
    return _this;
  }
  (0, _createClass2.default)(StageEditModal, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        stages = _this$props2.stages,
        isOpened = _this$props2.isOpened;
      var stage = this.state.stage;
      var disableSaving = this.isPristine || !this.isValid;
      var updateButton = {
        action: 'update',
        className: 'button primary',
        disabled: disableSaving,
        keyCodes: [13],
        label: 'Save'
      };
      var modalHeader = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "Edit stage", /*#__PURE__*/_react.default.createElement("button", {
        className: "btn-close",
        onClick: this.closeModal,
        type: "button"
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetConfirmationDialog, {
        buttons: [cancelButton, updateButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.handleButtonClick,
        show: isOpened,
        title: modalHeader
      }, /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetString, {
        metadata: nameOptions,
        model: stage.title,
        onModelChange: this.handleModelChange,
        onPristinityChange: this.handlePristinityChange,
        onValidityChange: this.handleValidityChange,
        register: this.onRegister,
        validators: [nameValidator(stages, stage.id), maxLengthValidator(nameOptions.label, 255)]
      }));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (!state.stage || props.model.title !== state.prevModel.title || props.model.title === state.prevModel.title && props.model.id !== state.prevModel.id) {
        return _objectSpread(_objectSpread({}, state), {}, {
          stage: props.model,
          prevModel: props.model
        });
      }
      return null;
    }
  }]);
  return StageEditModal;
}(_react.Component);
(0, _defineProperty2.default)(StageEditModal, "propTypes", {
  isOpened: _propTypes.default.bool.isRequired,
  model: _types.Stage.isRequired,
  onCancel: _propTypes.default.func.isRequired,
  onSave: _propTypes.default.func.isRequired,
  stages: _propTypes.default.arrayOf(_types.Stage).isRequired
});
var _default = exports["default"] = StageEditModal;

/***/ }),

/***/ 79579:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _includes = _interopRequireDefault(__webpack_require__(64721));
var _xlReactComponents = __webpack_require__(67082);
var _stageListHeaderComponent = _interopRequireDefault(__webpack_require__(99365));
var _stageListItemComponent = _interopRequireDefault(__webpack_require__(97734));
var _stageEditModal = _interopRequireDefault(__webpack_require__(14092));
var _components = __webpack_require__(78605);
__webpack_require__(61513);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var helpMessage = "Use Stages to logically group environments. You can also use Stages to filter the environment scheduler and dashboards.";
var StageListComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(StageListComponent, _Component);
  var _super = _createSuper(StageListComponent);
  function StageListComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, StageListComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFilterChange", function (filter) {
      _this.setState({
        filter: filter
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "showDeleteModal", function (stage) {
      _this.setState({
        deleteModalIsOpen: true,
        stage: stage
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "showEditModal", function (stage) {
      _this.setState({
        editModalIsOpen: true,
        stage: stage
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCloseDeleteModal", function (action) {
      var stage = _this.state.stage;
      if (action === 'delete') {
        _this.props.deleteStage(stage);
      }
      _this.setState({
        deleteModalIsOpen: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleStageSave", function (stage) {
      var saveStage = _this.props.saveStage;
      saveStage(stage);
      _this.setState({
        editModalIsOpen: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleCancel", function () {
      _this.setState({
        editModalIsOpen: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderStage", function (stage) {
      return /*#__PURE__*/_react.default.createElement(_stageListItemComponent.default, {
        key: stage.id,
        onDelete: _this.showDeleteModal,
        onEdit: _this.showEditModal,
        stage: stage
      });
    });
    _this.state = {
      deleteModalIsOpen: false,
      disabledUpdateButton: true,
      editModalIsOpen: false,
      filter: '',
      stage: {
        id: null,
        title: null
      }
    };
    return _this;
  }
  (0, _createClass2.default)(StageListComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.searchStages();
    }
  }, {
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var _this$state = this.state,
        deleteModalIsOpen = _this$state.deleteModalIsOpen,
        stage = _this$state.stage;
      return /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetConfirmationDialog, {
        buttons: [cancelButton, deleteButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseDeleteModal,
        show: deleteModalIsOpen,
        title: "Delete stage"
      }, /*#__PURE__*/_react.default.createElement(_components.AlertMessage, {
        alertType: _components.alertType.WARNING
      }, /*#__PURE__*/_react.default.createElement("p", null, "Deleting a stage can lead to missing data for connected resources on reporting and environment scheduling.")), /*#__PURE__*/_react.default.createElement("p", null, "You are about to delete stage ", /*#__PURE__*/_react.default.createElement("strong", null, stage.title), "."));
    }
  }, {
    key: "renderStages",
    value: function renderStages() {
      var stageList = this.props.stageList;
      var filter = this.state.filter;
      var stages = stageList.filter(function (stage) {
        return (0, _includes.default)(stage.title.toLowerCase(), filter.toLowerCase());
      }).map(this.renderStage);
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "margin"
      }, /*#__PURE__*/_react.default.createElement("h4", {
        className: "page-title"
      }, "Stages (", stages.length, ")"), /*#__PURE__*/_react.default.createElement(_components.HelpBlock, {
        className: "help-message-container"
      }, helpMessage), stages.length ? stages : /*#__PURE__*/_react.default.createElement(_components.NoData, {
        className: "no-stages-message",
        message: "No stages found."
      }));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        stageList = _this$props.stageList,
        saveStage = _this$props.saveStage;
      var _this$state2 = this.state,
        stage = _this$state2.stage,
        editModalIsOpen = _this$state2.editModalIsOpen;
      return /*#__PURE__*/_react.default.createElement("div", null, this.renderDeleteModal(), /*#__PURE__*/_react.default.createElement(_stageEditModal.default, {
        isOpened: editModalIsOpen,
        model: stage,
        onCancel: this.handleCancel,
        onSave: this.handleStageSave,
        stages: stageList
      }), /*#__PURE__*/_react.default.createElement(_stageListHeaderComponent.default, {
        onFilterChange: this.onFilterChange,
        onSave: saveStage,
        stageList: stageList
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "header-shadow"
      }), this.renderStages(stageList));
    }
  }]);
  return StageListComponent;
}(_react.Component);
(0, _defineProperty2.default)(StageListComponent, "propTypes", {
  deleteStage: _propTypes.default.func.isRequired,
  saveStage: _propTypes.default.func.isRequired,
  searchStages: _propTypes.default.func.isRequired,
  stageList: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired
  })).isRequired
});

/***/ }),

/***/ 11637:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.StageListContainer = void 0;
var _reactRedux = __webpack_require__(37703);
var _stageActions = __webpack_require__(4077);
var _stageListComponent = _interopRequireDefault(__webpack_require__(79579));
var mapStateToProps = function mapStateToProps(state) {
  return {
    stageList: state.environmentStages.stageList
  };
};
var StageListContainer = exports.StageListContainer = (0, _reactRedux.connect)(mapStateToProps, {
  searchStages: _stageActions.searchStages,
  saveStage: _stageActions.saveStage,
  deleteStage: _stageActions.deleteStage
})(_stageListComponent.default);

/***/ }),

/***/ 99365:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _xlReactComponents = __webpack_require__(67082);
var _dotComponents = __webpack_require__(92140);
var _actionToolbar = __webpack_require__(29755);
var _validators = __webpack_require__(36735);
var _headerComponent = _interopRequireDefault(__webpack_require__(39470));
__webpack_require__(23472);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var createButton = {
  action: 'create',
  className: 'button primary',
  keyCodes: [13],
  label: 'Create'
};
var nameOptions = {
  label: 'Name',
  placeholder: 'Add...',
  description: 'Name of the stage',
  required: true
};
var nameValidator = function nameValidator(stageList) {
  return function (name) {
    return {
      condition: (0, _validators.itemAlreadyDefined)(stageList, null, 'title', name),
      message: (0, _validators.createErrorMessage)('Stage already existing')
    };
  };
};
var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: (0, _validators.validateMaxLength)(inputText, maxLength),
      message: (0, _validators.createErrorMessage)("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};
var StageListHeaderComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(StageListHeaderComponent, _Component);
  var _super = _createSuper(StageListHeaderComponent);
  function StageListHeaderComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, StageListHeaderComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onRegister", function (componentApi) {
      componentApi.focus();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCreate", function () {
      _this.setState({
        modalIsOpen: true
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onClose", function (action) {
      if (action === 'create') {
        _this.props.onSave({
          title: _this.state.title
        });
      }
      _this.setState({
        modalIsOpen: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "closeModal", function () {
      _this.onClose(cancelButton.action);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onModelChange", function (title) {
      _this.setState({
        title: title
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onValidityChange", function (valid) {
      _this.setState({
        createButtonDisabled: !valid
      });
    });
    _this.state = {
      createButtonDisabled: false,
      modalIsOpen: false,
      title: ''
    };
    return _this;
  }
  (0, _createClass2.default)(StageListHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        onFilterChange = _this$props.onFilterChange,
        stageList = _this$props.stageList;
      var _this$state = this.state,
        modalIsOpen = _this$state.modalIsOpen,
        createButtonDisabled = _this$state.createButtonDisabled;
      var filterOptions = {
        placeholder: 'Filter by stage...'
      };
      createButton.disabled = createButtonDisabled;
      var modalHeader = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "New stage", /*#__PURE__*/_react.default.createElement("button", {
        className: "btn-close",
        onClick: this.closeModal,
        type: "button"
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/_react.default.createElement(_headerComponent.default, null, /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, {
        helpLink: "how-to/using-environments.html"
      }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
        onClick: this.onCreate
      }, "New stage")), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetFilter, {
        metadata: filterOptions,
        onUpdate: onFilterChange
      }), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetConfirmationDialog, {
        buttons: [cancelButton, createButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onClose,
        show: modalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetString, {
        metadata: nameOptions,
        onModelChange: this.onModelChange,
        onValidityChange: this.onValidityChange,
        register: this.onRegister,
        validators: [nameValidator(stageList), maxLengthValidator(nameOptions.label, 255)]
      })));
    }
  }]);
  return StageListHeaderComponent;
}(_react.Component);
(0, _defineProperty2.default)(StageListHeaderComponent, "propTypes", {
  onFilterChange: _propTypes.default.func.isRequired,
  onSave: _propTypes.default.func.isRequired,
  stageList: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired
  }).isRequired).isRequired
});

/***/ }),

/***/ 97734:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
__webpack_require__(75680);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var StageListItemComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(StageListItemComponent, _Component);
  var _super = _createSuper(StageListItemComponent);
  function StageListItemComponent() {
    (0, _classCallCheck2.default)(this, StageListItemComponent);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(StageListItemComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        stage = _this$props.stage,
        onDelete = _this$props.onDelete,
        onEdit = _this$props.onEdit;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "stage-panel"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "title env-stage-title col-xs-8",
        title: stage.title
      }, stage.title), /*#__PURE__*/_react.default.createElement("div", {
        className: "actions col-xs-4"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "pull-right"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "link color-inherited",
        onClick: function onClick() {
          return onEdit(stage);
        }
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "menu-item-icon xl-icon edit-icon",
        title: "Edit"
      }), /*#__PURE__*/_react.default.createElement("span", {
        className: "action-label"
      }, "Edit")), /*#__PURE__*/_react.default.createElement("span", {
        className: "link delete",
        onClick: function onClick() {
          return onDelete(stage);
        }
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      }), /*#__PURE__*/_react.default.createElement("span", {
        className: "action-label"
      }, "Delete")))));
    }
  }]);
  return StageListItemComponent;
}(_react.Component);
(0, _defineProperty2.default)(StageListItemComponent, "propTypes", {
  onDelete: _propTypes.default.func.isRequired,
  onEdit: _propTypes.default.func.isRequired,
  stage: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired
  }).isRequired
});

/***/ }),

/***/ 11375:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _environmentManagementStore = __webpack_require__(68124);
var _stageListContainer = __webpack_require__(11637);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var StagePage = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(StagePage, _Component);
  var _super = _createSuper(StagePage);
  function StagePage() {
    (0, _classCallCheck2.default)(this, StagePage);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(StagePage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
        store: _environmentManagementStore.store
      }, /*#__PURE__*/_react.default.createElement(_stageListContainer.StageListContainer, null));
    }
  }]);
  return StagePage;
}(_react.Component);

/***/ }),

/***/ 39470:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
__webpack_require__(95995);
var _components = __webpack_require__(78605);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var HeaderComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(HeaderComponent, _Component);
  var _super = _createSuper(HeaderComponent);
  function HeaderComponent() {
    (0, _classCallCheck2.default)(this, HeaderComponent);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(HeaderComponent, [{
    key: "render",
    value: function render() {
      var children = this.props.children;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "header",
        id: "header-environment"
      }, children);
    }
  }]);
  return HeaderComponent;
}(_react.Component);
(0, _defineProperty2.default)(HeaderComponent, "propTypes", {
  children: _propTypes.default.node
});

/***/ }),

/***/ 73845:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.viewsMap = exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _reactBigScheduler = __webpack_require__(17807);
var _xlReactComponents = __webpack_require__(67082);
__webpack_require__(90850);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var viewsMap = exports.viewsMap = {
  0: {
    viewName: 'Day',
    viewType: _reactBigScheduler.ViewTypes.Day,
    showAgenda: false,
    isEventPerspective: false
  },
  1: {
    viewName: 'Week',
    viewType: _reactBigScheduler.ViewTypes.Week,
    showAgenda: false,
    isEventPerspective: false
  },
  2: {
    viewName: 'Month',
    viewType: _reactBigScheduler.ViewTypes.Month,
    showAgenda: false,
    isEventPerspective: false
  }
};
var SchedulingEnvironmentCalendarHeaderComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(SchedulingEnvironmentCalendarHeaderComponent, _Component);
  var _super = _createSuper(SchedulingEnvironmentCalendarHeaderComponent);
  function SchedulingEnvironmentCalendarHeaderComponent() {
    var _this;
    (0, _classCallCheck2.default)(this, SchedulingEnvironmentCalendarHeaderComponent);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "buttonToggle", function (value) {
      _this.props.onViewChange(value);
    });
    return _this;
  }
  (0, _createClass2.default)(SchedulingEnvironmentCalendarHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        dateLabel = _this$props.dateLabel,
        customPrevClick = _this$props.customPrevClick,
        todayClick = _this$props.todayClick,
        customNextClick = _this$props.customNextClick,
        selectedViewType = _this$props.selectedViewType,
        title = _this$props.title;
      var options = [{
        value: viewsMap[0],
        label: viewsMap[0].viewName
      }, {
        value: viewsMap[1],
        label: viewsMap[1].viewName
      }, {
        value: viewsMap[2],
        label: viewsMap[2].viewName
      }];
      return /*#__PURE__*/_react.default.createElement("div", {
        id: "custom-scheduler-header"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "custom-scheduler-left-header"
      }, /*#__PURE__*/_react.default.createElement("h4", null, title)), /*#__PURE__*/_react.default.createElement("div", {
        className: "custom-scheduler-right-header"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "col-sm-3"
      }, /*#__PURE__*/_react.default.createElement("h4", null, dateLabel)), /*#__PURE__*/_react.default.createElement("div", {
        className: "col-sm-6"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "button-group-view"
      }, /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactToggleButton, {
        metadata: options,
        model: options[selectedViewType].value,
        objLabel: "label",
        objValue: "value",
        onToggle: this.buttonToggle
      }))), /*#__PURE__*/_react.default.createElement("div", {
        className: "col-sm-3 custom-right-header"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "button-group-calendar"
      }, /*#__PURE__*/_react.default.createElement("button", {
        className: "button button-icon prev",
        onClick: customPrevClick,
        type: "button"
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "xl-icon chevron-left-icon"
      })), /*#__PURE__*/_react.default.createElement("button", {
        className: "button today",
        onClick: todayClick,
        type: "button"
      }, "Today"), /*#__PURE__*/_react.default.createElement("button", {
        className: "button button-icon next",
        onClick: customNextClick,
        type: "button"
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "xl-icon chevron-right-icon"
      }))))));
    }
  }]);
  return SchedulingEnvironmentCalendarHeaderComponent;
}(_react.Component);
(0, _defineProperty2.default)(SchedulingEnvironmentCalendarHeaderComponent, "propTypes", {
  customNextClick: _propTypes.default.func.isRequired,
  customPrevClick: _propTypes.default.func.isRequired,
  dateLabel: _propTypes.default.any.isRequired,
  onViewChange: _propTypes.default.func.isRequired,
  selectedViewType: _propTypes.default.number.isRequired,
  title: _propTypes.default.string,
  todayClick: _propTypes.default.func.isRequired
});

/***/ }),

/***/ 86670:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.toastr = exports.reservationState = exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _filter = _interopRequireDefault(__webpack_require__(63105));
var _find = _interopRequireDefault(__webpack_require__(13311));
var _flatMap = _interopRequireDefault(__webpack_require__(94654));
var _map = _interopRequireDefault(__webpack_require__(35161));
var _sortBy = _interopRequireDefault(__webpack_require__(89734));
var _reactBigScheduler = _interopRequireWildcard(__webpack_require__(17807));
var _xlReactComponents = __webpack_require__(67082);
var _dotIconWrapper = __webpack_require__(23287);
var _moment = _interopRequireDefault(__webpack_require__(72897));
var _withDndContext = _interopRequireDefault(__webpack_require__(92884));
var _toastrFactory = _interopRequireDefault(__webpack_require__(86846));
var _schedulingEnvironmentCalendarHeaderComponent = _interopRequireWildcard(__webpack_require__(73845));
var _environmentSidebarItem = _interopRequireDefault(__webpack_require__(23994));
var _components = __webpack_require__(78605);
var _types = __webpack_require__(57809);
var _colors = _interopRequireDefault(__webpack_require__(70925));
__webpack_require__(25902);
__webpack_require__(37550);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var toastr = exports.toastr = (0, _toastrFactory.default)();
var reservationState = exports.reservationState = {
  pending: 'PENDING',
  conflict: 'CONFLICT',
  confirmed: 'CONFIRMED'
};
var getStateDescription = function getStateDescription(state) {
  switch (state) {
    case reservationState.pending:
      return {
        title: 'Pending reservation',
        eventClass: 'event--pending',
        circleClass: 'state-circle--pending'
      };
    case reservationState.conflict:
      return {
        title: 'Possible conflict',
        eventClass: 'event--conflict',
        circleClass: 'state-circle--conflict'
      };
    case reservationState.confirmed:
      return {
        title: 'Confirmed',
        eventClass: 'event--confirmed',
        circleClass: 'state-circle--confirmed'
      };
    default:
      return {
        title: '',
        eventClass: 'event--pending',
        circleClass: 'state-circle--pending'
      };
  }
};
var getSchedulerWidth = function getSchedulerWidth(ref) {
  if (ref && ref.current) {
    return ref.current.clientWidth;
  } else {
    // {window width}
    return window.innerWidth;
  }
};
var getSchedulerHeight = function getSchedulerHeight() {
  // {window height} - {scheduler header} - {height of header with filters} - {height of sub navigation} - {height of main navigation}
  return window.innerHeight - 52 - 60 - 56 - 43;
};
var getWeekCellWidth = function getWeekCellWidth() {
  var newWidth = (window.innerWidth - 300) / 7;
  return newWidth < 140 ? 140 : newWidth;
};
var getDayCellWidth = function getDayCellWidth() {
  var newWidth = (window.innerWidth - 300) / 24;
  return newWidth < 80 ? 80 : newWidth;
};
var schedulerConfig = {
  schedulerWidth: getSchedulerWidth(),
  //'1000'
  schedulerMaxHeight: getSchedulerHeight(),
  //500, // Set schedulerMaxHeight to freeze first row //0
  tableHeaderHeight: 40,
  dayResourceTableWidth: 300,
  //160
  weekResourceTableWidth: 300,
  //160
  monthResourceTableWidth: 300,
  //160

  dayCellWidth: getDayCellWidth(),
  //30
  weekCellWidth: getWeekCellWidth(),
  // 140, // 120
  monthCellWidth: 140,
  //80,

  dayMaxEvents: 99,
  weekMaxEvents: 99,
  monthMaxEvents: 99,
  eventItemHeight: 18,
  //22,
  eventItemLineHeight: 20,
  // 24,
  nonAgendaSlotMinHeight: 64,
  //0
  dayStartFrom: 0,
  dayStopTo: 23,
  defaultEventBgColor: _colors.default.lightgray,
  selectedAreaColor: _colors.default.selectedColor,
  nonWorkingTimeHeadColor: _colors.default.black,
  nonWorkingTimeHeadBgColor: _colors.default.background,
  nonWorkingTimeBodyBgColor: _colors.default.white,
  startResizable: false,
  // true,
  endResizable: false,
  //true,
  movable: false,
  //true,
  creatable: false,
  //true,
  crossResourceMove: true,
  checkConflict: true,
  // false,
  scrollToTodayEnabled: true,
  eventItemPopoverEnabled: true,
  calendarPopoverEnabled: false,
  // true, //display calendar popover when clicking on a date label in header
  recurringEventsEnabled: true,
  headerEnabled: false,
  // true, //we can remove header and add custom component above calendar
  displayWeekend: true,
  resourceName: 'Resource Name',
  addMorePopoverHeaderFormat: 'MMM D, YYYY dddd',
  // when max event is defined
  eventItemPopoverDateFormat: 'MMM D, YYYY',
  // 'MMM D',
  nonAgendaDayCellHeaderFormat: 'hh:mm A',
  //'ha', //when is selected Day
  nonAgendaOtherCellHeaderFormat: 'dddd, MMM D',
  //'ddd M/D', //when is selected Week or Month

  minuteStep: 60,
  //30

  views: (0, _map.default)(_schedulingEnvironmentCalendarHeaderComponent.viewsMap)
};
var SchedulingEnvironmentContainer = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(SchedulingEnvironmentContainer, _Component);
  var _super = _createSuper(SchedulingEnvironmentContainer);
  function SchedulingEnvironmentContainer(props) {
    var _this;
    (0, _classCallCheck2.default)(this, SchedulingEnvironmentContainer);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "initSchedulerData", function () {
      var resourceFilter = /*#__PURE__*/_react.default.createElement("div", {
        className: "calendar-filter"
      }, /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetFilter, {
        metadata: {
          placeholder: 'Filter by environment...'
        },
        onUpdate: _this.filterByEnvironmentName
      }));
      var config = schedulerConfig;
      config.resourceName = resourceFilter;

      // overridden configuration has comment with default value, unnecessary configuration has removed
      var schedulerData = new _reactBigScheduler.SchedulerData((0, _moment.default)().format(_reactBigScheduler.DATETIME_FORMAT), _reactBigScheduler.ViewTypes.Month, false, false, config);
      schedulerData.setResources([]);
      schedulerData.setEvents([]);
      return schedulerData;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "filterByEnvironmentName", function (name) {
      _this.props.schedulerFilter.environmentTitle = name;
      _this.props.onFilterChange();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "formatEnvironmentsReservations", function () {
      var schedulerData = _this.state.schedulerData;
      if (_this.props.environmentsReservations !== null) {
        schedulerData.setResources(_this.getFormattedResources());
        schedulerData.setEvents(_this.getFormattedEvents());
      } else {
        schedulerData.setResources([]);
        schedulerData.setEvents([]);
      }
      return schedulerData;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getFormattedResources", function () {
      return (0, _map.default)(_this.props.environmentsReservations, function (data) {
        return {
          id: data.id,
          name: data.title,
          stage: data.stage
          // labels: data.labels
        };
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getFormattedEvents", function () {
      var fatEventList = (0, _map.default)(_this.props.environmentsReservations, function (environmentReservation) {
        var resourceId = environmentReservation.id;
        return (0, _map.default)(environmentReservation.reservations, function (reservation) {
          // TODO: read missing value from object after backend change
          return {
            id: reservation.id,
            start: (0, _moment.default)(reservation.startDate).format(_reactBigScheduler.DATETIME_FORMAT),
            end: (0, _moment.default)(reservation.endDate).format(_reactBigScheduler.DATETIME_FORMAT),
            resourceId: resourceId,
            title: _this.getTitle(reservation),
            applications: reservation.applications,
            state: reservationState.confirmed // reservation.state
          };
        });
      });
      var flatEventList = (0, _flatMap.default)(fatEventList);
      //the event array should be sorted in ascending order by event.start property, otherwise there will be some rendering errors
      return (0, _sortBy.default)(flatEventList, ['start']);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "updateSchedulerEvents", function (schedulerData) {
      schedulerData.setEvents(_this.getFormattedEvents());
      _this.setState({
        schedulerData: schedulerData
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "updateDimensions", function () {
      var schedulerData = _this.state.schedulerData;
      schedulerData.config.schedulerWidth = getSchedulerWidth(_this.containerRef);
      schedulerData.config.schedulerMaxHeight = getSchedulerHeight();
      schedulerData.config.dayCellWidth = getDayCellWidth();
      schedulerData.config.weekCellWidth = getWeekCellWidth();
      _this.setState({
        schedulerData: schedulerData
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "prevClick", function (schedulerData) {
      //SchedulerData.events will be clear after calling this method
      schedulerData.prev();
      _this.onDateChange(schedulerData);
      _this.updateSchedulerEvents(schedulerData);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "nextClick", function (schedulerData) {
      //SchedulerData.events will be clear after calling this method
      schedulerData.next();
      _this.onDateChange(schedulerData);
      _this.updateSchedulerEvents(schedulerData);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCustomViewChange", function (view) {
      _this.onViewChange(_this.state.schedulerData, view);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onViewChange", function (schedulerData, view) {
      //SchedulerData.events will be clear after calling this method
      schedulerData.setViewType(view.viewType, view.showAgenda, view.isEventPerspective);
      _this.onDateChange(schedulerData);
      _this.updateSchedulerEvents(schedulerData);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onSelectDate", function (schedulerData, date) {
      //SchedulerData.events will be clear after calling this method
      schedulerData.setDate(date);
      _this.onDateChange(schedulerData);
      _this.updateSchedulerEvents(schedulerData);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "nonAgendaCellHeaderTemplateResolver", function (schedulerData, item, formattedDateItems, style) {
      var headerToday;
      var datetime = schedulerData.localeMoment(item.time);
      if (schedulerData.viewType === _reactBigScheduler.ViewTypes.Day) {
        headerToday = datetime.isSame(new Date(), 'hour') ? 'header-today' : '';
      } else {
        headerToday = datetime.isSame(new Date(), 'day') ? 'header-today' : '';
      }
      return /*#__PURE__*/_react.default.createElement("th", {
        className: "header3-text",
        key: item.time,
        style: style
      }, formattedDateItems.map(function (formattedItem, index) {
        return /*#__PURE__*/_react.default.createElement("div", {
          className: headerToday,
          dangerouslySetInnerHTML: {
            __html: formattedItem.replace(/[0-9]/g, '<b>$&</b>')
          },
          key: index
        });
      }));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "eventItemTemplateResolver", function (schedulerData, event, bgColor, isStart, isEnd, mustAddCssClass, mustBeHeight, agendaMaxEventWidth) {
      var config = schedulerData.config;
      var popup = /*#__PURE__*/_react.default.createElement(_components.Popup, null, /*#__PURE__*/_react.default.createElement("span", {
        onClick: function onClick() {
          return _this.approveReservation(event);
        }
      }, "Approve"), /*#__PURE__*/_react.default.createElement("span", {
        onClick: function onClick() {
          return _this.askForChangeReservation(event);
        }
      }, "Ask for change"), /*#__PURE__*/_react.default.createElement("span", {
        onClick: function onClick() {
          return _this.declineReservation(event);
        }
      }, "Decline"));
      var popupMenu = event.state === reservationState.pending ? popup : '';
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "event-item ".concat(getStateDescription(event.state).eventClass),
        id: event.id,
        key: event.id,
        style: {
          height: config.eventItemHeight
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        style: {
          marginLeft: '10px',
          lineHeight: "".concat(config.eventItemHeight, "px")
        }
      }, schedulerData.behaviors.getEventTextFunc(schedulerData, event)));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "subtitleGetter", function (schedulerData, event) {
      var title = schedulerData.behaviors.getEventTextFunc(schedulerData, event);
      var stateDescription = getStateDescription(event.state);
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "event-item-popover-content"
      }, title.length > 0 ? /*#__PURE__*/_react.default.createElement("div", {
        className: "event-item-popover-title"
      }, title) : null, /*#__PURE__*/_react.default.createElement("table", {
        className: "event-item-popover-description"
      }, /*#__PURE__*/_react.default.createElement("tbody", null, /*#__PURE__*/_react.default.createElement("tr", null, /*#__PURE__*/_react.default.createElement("th", null, /*#__PURE__*/_react.default.createElement("div", {
        className: stateDescription.circleClass
      })), /*#__PURE__*/_react.default.createElement("td", null, stateDescription.title)), event.applications.length > 0 ? /*#__PURE__*/_react.default.createElement("tr", null, /*#__PURE__*/_react.default.createElement("th", null, /*#__PURE__*/_react.default.createElement(_dotIconWrapper.DotIconWrapper, {
        className: "mrs",
        iconId: "package"
      })), /*#__PURE__*/_react.default.createElement("td", null, event.applications.map(function (application) {
        return application.title;
      }).join(', '))) : null)), /*#__PURE__*/_react.default.createElement("table", {
        className: "event-item-popover-details"
      }, /*#__PURE__*/_react.default.createElement("tbody", null, /*#__PURE__*/_react.default.createElement("tr", null, /*#__PURE__*/_react.default.createElement("td", null, "From:"), /*#__PURE__*/_react.default.createElement("td", null, (0, _moment.default)(event.start).format('MMM D, YYYY - hh:mm A'))), /*#__PURE__*/_react.default.createElement("tr", null, /*#__PURE__*/_react.default.createElement("td", null, "To:"), /*#__PURE__*/_react.default.createElement("td", null, (0, _moment.default)(event.end).format('MMM D, YYYY - hh:mm A'))))));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "approveReservation", function (event) {
      toastr.info("Approve: [ ".concat(event.title, " ]"));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "askForChangeReservation", function (event) {
      toastr.info("Ask for change reservation: [ ".concat(event.title, " ]"));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "declineReservation", function (event) {
      toastr.info("Decline reservation: [ ".concat(event.title, " ]"));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getTitle", function (reservation) {
      if (reservation.release) {
        return reservation.release.title;
      } else if (reservation.applications.length > 0) {
        return reservation.applications.map(function (application) {
          return application.title;
        }).join(', ');
      } else {
        return '';
      }
    });
    //TODO: sketch of implementation for future tasks
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "newEvent", function (schedulerData, slotId, slotName, start, end, type, item) {
      //before save open sidebar form
      var newFreshId = 0;
      schedulerData.events.forEach(function (item) {
        if (item.id >= newFreshId) newFreshId = item.id + 1;
      });
      var title = 'New event you just created';
      var newEvent = {
        id: newFreshId,
        title: title,
        start: start,
        end: end,
        resourceId: slotId
      };
      schedulerData.addEvent(newEvent);
      (0, _filter.default)(_this.props.environmentsReservations, {
        id: slotId
      }).forEach(function (data) {
        return data.reservations.push({
          id: newFreshId,
          startDate: (0, _moment.default)(start).valueOf(),
          endDate: (0, _moment.default)(end).valueOf(),
          state: reservationState.pending,
          application: {
            id: "app_".concat(slotId, "_").concat(newFreshId),
            title: title
          }
        });
      });
      _this.setState({
        schedulerData: schedulerData
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "eventClicked", function (schedulerData, event) {
      var onEventClick = _this.props.onEventClick;
      onEventClick(event);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "updateEventStart", function (schedulerData, event, newStart) {
      //before save open sidebar form populated with event data
      schedulerData.updateEventStart(event, newStart);
      _this.setState({
        schedulerData: schedulerData
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "updateEventEnd", function (schedulerData, event, newEnd) {
      //before save open sidebar form populated with event data
      schedulerData.updateEventEnd(event, newEnd);
      _this.setState({
        schedulerData: schedulerData
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "moveEvent", function (schedulerData, event, slotId, slotName, start, end) {
      //before save open sidebar form populated with event data
      schedulerData.moveEvent(event, slotId, slotName, start, end);
      _this.setState({
        schedulerData: schedulerData
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "conflictOccurred", function (schedulerData, action, event) {
      //implement conflict functionality
      toastr.warning("Conflict occurred. {action: ".concat(action, ", event: { newSlotName: ").concat(event.slotName, ", newStart: ").concat(event.start, ", newEnd: ").concat(event.end, " } }"));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "slotItemTemplateResolver", function (schedulerData, item) {
      var environmentsReservations = _this.props.environmentsReservations;
      var environment = (0, _find.default)(environmentsReservations, {
        id: item.slotId
      });
      return /*#__PURE__*/_react.default.createElement(_environmentSidebarItem.default, {
        environment: environment
      });
    });
    _this.state = {
      schedulerData: _this.initSchedulerData()
    };
    _this.containerRef = /*#__PURE__*/_react.default.createRef();
    _this.resizeObserver = new ResizeObserver(function (_entries) {
      return _this.updateDimensions();
    });
    return _this;
  }
  (0, _createClass2.default)(SchedulingEnvironmentContainer, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateDimensions();
      this.filterByEnvironmentName('');
      if (this.containerRef.current) {
        this.resizeObserver.observe(this.containerRef.current);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.resizeObserver) {
        this.resizeObserver.disconnect();
      }
    }
  }, {
    key: "onDateChange",
    value: function onDateChange(schedulerData) {
      this.props.schedulerFilter.from = (0, _moment.default)(schedulerData.startDate, 'YYYY-MM-DD').startOf('day').valueOf();
      this.props.schedulerFilter.to = (0, _moment.default)(schedulerData.endDate, 'YYYY-MM-DD').endOf('day').valueOf();
      this.props.onFilterChange();
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      // const schedulerData = this.props.schedulerData;
      var schedulerData = this.formatEnvironmentsReservations();
      return /*#__PURE__*/_react.default.createElement("div", {
        id: "scheduler-environment",
        ref: this.containerRef
      }, /*#__PURE__*/_react.default.createElement(_schedulingEnvironmentCalendarHeaderComponent.default, {
        customNextClick: function customNextClick() {
          return _this2.nextClick(schedulerData);
        },
        customPrevClick: function customPrevClick() {
          return _this2.prevClick(schedulerData);
        },
        dateLabel: schedulerData.getDateLabel(),
        onViewChange: this.onCustomViewChange,
        selectedViewType: schedulerData.viewType,
        title: "Environments",
        todayClick: function todayClick() {
          return _this2.onSelectDate(schedulerData, (0, _moment.default)());
        }
      }), /*#__PURE__*/_react.default.createElement(_reactBigScheduler.default, {
        conflictOccurred: this.conflictOccurred,
        eventItemClick: this.eventClicked,
        eventItemTemplateResolver: this.eventItemTemplateResolver,
        moveEvent: this.moveEvent,
        newEvent: this.newEvent,
        nextClick: this.nextClick,
        nonAgendaCellHeaderTemplateResolver: this.nonAgendaCellHeaderTemplateResolver,
        onSelectDate: this.onSelectDate,
        onViewChange: this.onViewChange,
        prevClick: this.prevClick,
        schedulerData: schedulerData,
        slotItemTemplateResolver: this.slotItemTemplateResolver,
        subtitleGetter: this.subtitleGetter,
        updateEventEnd: this.updateEventEnd,
        updateEventStart: this.updateEventStart
      }), (!schedulerData || !schedulerData.resources.length) && /*#__PURE__*/_react.default.createElement("div", {
        className: "no-res-environments-message-container"
      }, /*#__PURE__*/_react.default.createElement(_components.NoData, {
        className: "no-res-environments-message",
        message: "No environments found."
      })));
    }
  }]);
  return SchedulingEnvironmentContainer;
}(_react.Component);
(0, _defineProperty2.default)(SchedulingEnvironmentContainer, "propTypes", {
  environmentsReservations: _propTypes.default.arrayOf(_types.EnvironmentReservation),
  onEventClick: _propTypes.default.func.isRequired,
  onFilterChange: _propTypes.default.func.isRequired,
  schedulerFilter: _types.SchedulerFilter.isRequired
});
var _default = exports["default"] = (0, _withDndContext.default)(SchedulingEnvironmentContainer);

/***/ }),

/***/ 12554:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _xlReactComponents = __webpack_require__(67082);
var _dotComponents = __webpack_require__(92140);
var _includes = _interopRequireDefault(__webpack_require__(64721));
var _actionToolbar = __webpack_require__(29755);
var _headerComponent = _interopRequireDefault(__webpack_require__(39470));
var _types = __webpack_require__(57809);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var applicationFilterMetadata = {
  label: 'Application',
  placeholder: 'Select application...'
};
var stageFilterMetadata = {
  label: 'Stage',
  placeholder: 'Select stage...'
};
var labelsFilterMetadata = {
  label: 'Labels',
  placeholder: 'Select labels...',
  name: 'autocomplete'
};
var autocompleteHandler = function autocompleteHandler(list) {
  return function (_ref) {
    var metadata = _ref.metadata,
      objLabel = _ref.objLabel,
      suggestedElements = _ref.suggestedElements,
      value = _ref.value;
    return Promise.resolve(list.filter(function (item) {
      return (0, _includes.default)(item[objLabel].toLowerCase(), value.toLowerCase());
    }));
  };
};
var SchedulingEnvironmentHeaderComponent = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(SchedulingEnvironmentHeaderComponent, _Component);
  var _super = _createSuper(SchedulingEnvironmentHeaderComponent);
  function SchedulingEnvironmentHeaderComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, SchedulingEnvironmentHeaderComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "selectApplication", function (app) {
      _this.setState({
        applicationSelected: app
      });
      _this.props.onApplicationFilterChange(app);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "selectStage", function (stage) {
      _this.setState({
        stageSelected: stage
      });
      _this.props.onStageFilterChange(stage);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "selectLabel", function (labels) {
      _this.setState({
        labelsSelected: labels
      });
      _this.props.onLabelsFilterChange(labels);
    });
    _this.state = {
      applicationSelected: {},
      stageSelected: {},
      labelsSelected: []
    };
    return _this;
  }
  (0, _createClass2.default)(SchedulingEnvironmentHeaderComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.loadHeaderData();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        applications = _this$props.applications,
        stages = _this$props.stages,
        newReservationDisabled = _this$props.newReservationDisabled,
        onNewReservation = _this$props.onNewReservation,
        labels = _this$props.labels;
      var _this$state = this.state,
        applicationSelected = _this$state.applicationSelected,
        stageSelected = _this$state.stageSelected,
        labelsSelected = _this$state.labelsSelected;
      var applicationsHandler = {
        addCandidates: autocompleteHandler(applications)
      };
      var stagesHandler = {
        addCandidates: autocompleteHandler(stages)
      };
      var labelsHandler = {
        autocomplete: {
          addCandidates: autocompleteHandler(labels.map(function (t) {
            return {
              color: '',
              label: t.title,
              value: t.id
            };
          }))
        }
      };
      return /*#__PURE__*/_react.default.createElement(_headerComponent.default, null, /*#__PURE__*/_react.default.createElement(_actionToolbar.ActionToolbarPortalContainer, {
        helpLink: "how-to/scheduling-environments.html"
      }, /*#__PURE__*/_react.default.createElement(_dotComponents.DotButton, {
        disabled: newReservationDisabled,
        onClick: onNewReservation
      }, "New")), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
        handlers: applicationsHandler,
        metadata: applicationFilterMetadata,
        model: applicationSelected,
        objLabel: 'title',
        onModelChange: this.selectApplication
      }), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
        handlers: stagesHandler,
        metadata: stageFilterMetadata,
        model: stageSelected,
        objLabel: 'title',
        onModelChange: this.selectStage
      }), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetTags, {
        className: "long",
        handlers: labelsHandler,
        inputType: "autocomplete",
        metadata: labelsFilterMetadata,
        model: labelsSelected,
        objLabel: 'label',
        onModelChange: this.selectLabel,
        skin: "checkbox",
        tagTransform: function tagTransform(t) {
          return t;
        }
      }));
    }
  }]);
  return SchedulingEnvironmentHeaderComponent;
}(_react.Component);
(0, _defineProperty2.default)(SchedulingEnvironmentHeaderComponent, "propTypes", {
  applications: _propTypes.default.arrayOf(_types.Application),
  labels: _propTypes.default.arrayOf(_types.Label),
  loadHeaderData: _propTypes.default.func.isRequired,
  newReservationDisabled: _propTypes.default.bool.isRequired,
  onApplicationFilterChange: _propTypes.default.func.isRequired,
  onLabelsFilterChange: _propTypes.default.func.isRequired,
  onNewReservation: _propTypes.default.func.isRequired,
  onStageFilterChange: _propTypes.default.func.isRequired,
  stages: _propTypes.default.arrayOf(_types.Stage)
});
(0, _defineProperty2.default)(SchedulingEnvironmentHeaderComponent, "defaultProps", {
  applications: [],
  labels: [],
  stages: []
});

/***/ }),

/***/ 36998:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SchedulingEnvironmentPageContainer = exports.SchedulingEnvironmentPageComponent = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _reactRedux = __webpack_require__(37703);
var _difference = _interopRequireDefault(__webpack_require__(91966));
var _includes = _interopRequireDefault(__webpack_require__(64721));
var _isEmpty = _interopRequireDefault(__webpack_require__(41609));
var _map = _interopRequireDefault(__webpack_require__(35161));
var _reactSidebar = _interopRequireDefault(__webpack_require__(60005));
var _schedulingEnvironmentHeaderComponent = _interopRequireDefault(__webpack_require__(12554));
var _schedulingEnvironmentContainer = _interopRequireDefault(__webpack_require__(86670));
var _schedulingEnvironmentReservationFormContainer = __webpack_require__(82705);
var _schedulingActions = __webpack_require__(6711);
var _types = __webpack_require__(57809);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var styleSidebar = {
  root: {
    top: '56px'
  },
  sidebar: {
    width: '300px',
    padding: '5px 15px',
    background: '#ffffff',
    color: 'black',
    zIndex: 20,
    boxShadow: '-10px 0 10px -10px #E3E5E8'
  },
  overlay: {
    display: 'none'
  },
  dragHandle: {
    zIndex: 10
  }
};
var SchedulingEnvironmentPageComponent = exports.SchedulingEnvironmentPageComponent = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(SchedulingEnvironmentPageComponent, _Component);
  var _super = _createSuper(SchedulingEnvironmentPageComponent);
  function SchedulingEnvironmentPageComponent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, SchedulingEnvironmentPageComponent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFilterChange", function () {
      var _this$props = _this.props,
        onSearchReservations = _this$props.onSearchReservations,
        schedulerFilter = _this$props.schedulerFilter;
      onSearchReservations(schedulerFilter);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "createReservation", function () {
      var openEnvironmentReservationForm = _this.props.openEnvironmentReservationForm;
      openEnvironmentReservationForm(null);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "editReservation", function (reservation) {
      var openEnvironmentReservationForm = _this.props.openEnvironmentReservationForm;
      openEnvironmentReservationForm(reservation.id);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderReservationForm", function (environmentsReservations) {
      var environments = (0, _map.default)(environmentsReservations, function (data) {
        return {
          id: data.id,
          title: data.title
        };
      });
      return /*#__PURE__*/_react.default.createElement(_schedulingEnvironmentReservationFormContainer.SchedulingEnvironmentReservationFormContainer, {
        environments: environments
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "addFilterApplication", function (application) {
      _this.setState({
        filterEnvironmentByApplication: application
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "addFilterStage", function (stage) {
      _this.setState({
        filterEnvironmentByStage: stage
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "addFilterLabels", function (labels) {
      _this.setState({
        filterEnvironmentByLabels: labels
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "filterEnvironments", function (environments) {
      var filtered = environments;
      var _this$state = _this.state,
        filterEnvironmentByApplication = _this$state.filterEnvironmentByApplication,
        filterEnvironmentByStage = _this$state.filterEnvironmentByStage,
        filterEnvironmentByLabels = _this$state.filterEnvironmentByLabels;
      if (!(0, _isEmpty.default)(filterEnvironmentByApplication)) {
        var applications = _this.props.applications;
        var application = applications.find(function (app) {
          return app.title === filterEnvironmentByApplication;
        });
        if (application) {
          filtered = filtered.filter(function (env) {
            return (0, _includes.default)(application.environments.map(function (e) {
              return e.id;
            }), env.id);
          });
        } else {
          return [];
        }
      }
      if (!(0, _isEmpty.default)(filterEnvironmentByStage)) {
        filtered = filtered.filter(function (env) {
          return env.stage.title === filterEnvironmentByStage;
        });
      }
      if (!(0, _isEmpty.default)(filterEnvironmentByLabels)) {
        filtered = filtered.filter(function (env) {
          return (0, _difference.default)(filterEnvironmentByLabels.map(function (t) {
            return t.value;
          }), env.labels.map(function (t) {
            return t.title;
          })).length === 0;
        });
      }
      return filtered.slice(0, 100);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "loadData", function () {
      _this.props.initHeader();
    });
    _this.state = {
      filterEnvironmentByApplication: '',
      filterEnvironmentByStage: '',
      filterEnvironmentByLabels: []
    };
    return _this;
  }
  (0, _createClass2.default)(SchedulingEnvironmentPageComponent, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var cleanSchedulingState = this.props.cleanSchedulingState;
      cleanSchedulingState();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        applications = _this$props2.applications,
        stages = _this$props2.stages,
        environmentsReservations = _this$props2.environmentsReservations,
        schedulerFilter = _this$props2.schedulerFilter,
        reservationSidebarIsOpen = _this$props2.reservationSidebarIsOpen,
        labels = _this$props2.labels;
      var environmentsFiltered = this.filterEnvironments(environmentsReservations);
      var sidebarContent = reservationSidebarIsOpen ? this.renderReservationForm(environmentsFiltered) : '';
      var isNewReservationDisabled = reservationSidebarIsOpen || !environmentsReservations.length;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_schedulingEnvironmentHeaderComponent.default, {
        applications: applications,
        labels: labels,
        loadHeaderData: this.loadData,
        newReservationDisabled: isNewReservationDisabled,
        onApplicationFilterChange: this.addFilterApplication,
        onLabelsFilterChange: this.addFilterLabels,
        onNewReservation: this.createReservation,
        onStageFilterChange: this.addFilterStage,
        schedulerFilter: schedulerFilter,
        stages: stages
      }), /*#__PURE__*/_react.default.createElement(_reactSidebar.default, {
        open: reservationSidebarIsOpen,
        pullRight: true,
        shadow: false,
        sidebar: sidebarContent,
        styles: styleSidebar
      }, /*#__PURE__*/_react.default.createElement(_schedulingEnvironmentContainer.default, {
        environmentsReservations: environmentsFiltered,
        onEventClick: this.editReservation,
        onFilterChange: this.onFilterChange,
        schedulerFilter: schedulerFilter
      })));
    }
  }]);
  return SchedulingEnvironmentPageComponent;
}(_react.Component);
(0, _defineProperty2.default)(SchedulingEnvironmentPageComponent, "propTypes", {
  applications: _propTypes.default.arrayOf(_types.Application),
  cleanSchedulingState: _propTypes.default.func.isRequired,
  environmentsReservations: _propTypes.default.arrayOf(_types.EnvironmentReservation),
  initHeader: _propTypes.default.func.isRequired,
  labels: _propTypes.default.arrayOf(_types.Label),
  onSearchReservations: _propTypes.default.func.isRequired,
  openEnvironmentReservationForm: _propTypes.default.func,
  reservationSidebarIsOpen: _propTypes.default.bool.isRequired,
  schedulerFilter: _types.SchedulerFilter.isRequired,
  stages: _propTypes.default.arrayOf(_types.Stage)
});
var mapStateToProps = function mapStateToProps(state) {
  return {
    environmentsReservations: state.scheduling.environmentsReservations,
    reservationSidebarIsOpen: state.scheduling.reservationSidebarIsOpen,
    schedulerFilter: state.scheduling.schedulerFilter,
    applications: state.applicationList.applications,
    stages: state.environmentStages.stageList,
    labels: state.labels.labelList
  };
};
var SchedulingEnvironmentPageContainer = exports.SchedulingEnvironmentPageContainer = (0, _reactRedux.connect)(mapStateToProps, {
  onSearchReservations: _schedulingActions.onSearchReservations,
  openEnvironmentReservationForm: _schedulingActions.openEnvironmentReservationForm,
  initHeader: _schedulingActions.initHeader,
  cleanSchedulingState: _schedulingActions.cleanSchedulingState
})(SchedulingEnvironmentPageComponent);

/***/ }),

/***/ 36971:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactRedux = __webpack_require__(37703);
var _environmentManagementStore = __webpack_require__(68124);
var _schedulingEnvironmentPageContainer = __webpack_require__(36998);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var SchedulingEnvironmentPage = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(SchedulingEnvironmentPage, _Component);
  var _super = _createSuper(SchedulingEnvironmentPage);
  function SchedulingEnvironmentPage() {
    (0, _classCallCheck2.default)(this, SchedulingEnvironmentPage);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(SchedulingEnvironmentPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
        store: _environmentManagementStore.store
      }, /*#__PURE__*/_react.default.createElement(_schedulingEnvironmentPageContainer.SchedulingEnvironmentPageContainer, null));
    }
  }]);
  return SchedulingEnvironmentPage;
}(_react.Component);

/***/ }),

/***/ 82705:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SchedulingEnvironmentReservationFormContainer = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _reactRedux = __webpack_require__(37703);
var _isEmpty = _interopRequireDefault(__webpack_require__(41609));
var _xlReactComponents = __webpack_require__(67082);
var _schedulingEnvironmentReservationFormActions = __webpack_require__(5334);
var _types = __webpack_require__(57809);
var _sidebarReservationForm = _interopRequireDefault(__webpack_require__(55172));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var SchedulingEnvironmentReservationForm = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(SchedulingEnvironmentReservationForm, _Component);
  var _super = _createSuper(SchedulingEnvironmentReservationForm);
  function SchedulingEnvironmentReservationForm() {
    var _this;
    (0, _classCallCheck2.default)(this, SchedulingEnvironmentReservationForm);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      reservationToDelete: null,
      deleteModalIsOpen: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onConfirmNewReservation", function () {
      var _this$props = _this.props,
        onReserveEnvironment = _this$props.onReserveEnvironment,
        reservationModel = _this$props.reservationModel;
      onReserveEnvironment(reservationModel);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "showDeleteConfirmationModel", function (id) {
      _this.setState({
        deleteModalIsOpen: true,
        reservationToDelete: id
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCloseDeleteConfirmationModal", function (action) {
      var reservationToDelete = _this.state.reservationToDelete;
      if (action === 'delete') {
        _this.props.onDeleteEnvironmentReservation(reservationToDelete);
      }
      _this.setState({
        deleteModalIsOpen: false,
        reservationModel: null
      });
    });
    return _this;
  }
  (0, _createClass2.default)(SchedulingEnvironmentReservationForm, [{
    key: "renderDeleteConfirmationModal",
    value: function renderDeleteConfirmationModal() {
      var deleteModalIsOpen = this.state.deleteModalIsOpen;
      return /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetConfirmationDialog, {
        buttons: [cancelButton, deleteButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseDeleteConfirmationModal,
        show: deleteModalIsOpen,
        title: "Delete reservation"
      }, /*#__PURE__*/_react.default.createElement("p", null, "You are about to delete reservation."));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        applications = _this$props2.applications,
        environments = _this$props2.environments,
        onReserveEnvironmentCancel = _this$props2.onReserveEnvironmentCancel,
        onReservationEnvironmentChange = _this$props2.onReservationEnvironmentChange,
        onReservationFormChange = _this$props2.onReservationFormChange,
        onReservationFormPristineChange = _this$props2.onReservationFormPristineChange,
        onReservationFormValidChange = _this$props2.onReservationFormValidChange,
        reservationModel = _this$props2.reservationModel,
        reservationFormIsPristine = _this$props2.reservationFormIsPristine,
        reservationFormIsValid = _this$props2.reservationFormIsValid;
      var isEditForm = !(0, _isEmpty.default)(reservationModel.id);
      var isSaveEnabled = !reservationFormIsPristine && reservationFormIsValid;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.renderDeleteConfirmationModal(), /*#__PURE__*/_react.default.createElement(_sidebarReservationForm.default, {
        applications: applications,
        environments: environments,
        isEditForm: isEditForm,
        isSaveEnabled: isSaveEnabled,
        key: reservationModel.id,
        onCancel: onReserveEnvironmentCancel,
        onConfirm: this.onConfirmNewReservation,
        onDelete: this.showDeleteConfirmationModel,
        onFormChange: onReservationFormChange,
        onFormPristinityChange: onReservationFormPristineChange,
        onFormValidationChange: onReservationFormValidChange,
        onReservationEnvironmentChange: onReservationEnvironmentChange,
        reservationModel: reservationModel
      }));
    }
  }]);
  return SchedulingEnvironmentReservationForm;
}(_react.Component);
(0, _defineProperty2.default)(SchedulingEnvironmentReservationForm, "propTypes", {
  applications: _propTypes.default.arrayOf(_types.Application),
  environments: _propTypes.default.arrayOf(_types.Environment),
  onDeleteEnvironmentReservation: _propTypes.default.func.isRequired,
  onReservationEnvironmentChange: _propTypes.default.func.isRequired,
  onReservationFormChange: _propTypes.default.func.isRequired,
  onReservationFormPristineChange: _propTypes.default.func.isRequired,
  onReservationFormValidChange: _propTypes.default.func.isRequired,
  onReserveEnvironment: _propTypes.default.func.isRequired,
  onReserveEnvironmentCancel: _propTypes.default.func.isRequired,
  reservationFormIsPristine: _propTypes.default.bool,
  reservationFormIsValid: _propTypes.default.bool,
  reservationModel: _types.ReservationModel
});
var mapStateToProps = function mapStateToProps(state) {
  return {
    applications: state.schedulingEnvironmentReservationForm.applications,
    reservationFormIsPristine: state.schedulingEnvironmentReservationForm.reservationFormIsPristine,
    reservationFormIsValid: state.schedulingEnvironmentReservationForm.reservationFormIsValid,
    reservationModel: state.schedulingEnvironmentReservationForm.reservationModel
  };
};
var mergeProps = function mergeProps(stateProps, dispatchProps, ownProps) {
  return _objectSpread(_objectSpread(_objectSpread({}, ownProps), stateProps), dispatchProps);
};
var SchedulingEnvironmentReservationFormContainer = exports.SchedulingEnvironmentReservationFormContainer = (0, _reactRedux.connect)(mapStateToProps, {
  initEnvironmentReservationForm: _schedulingEnvironmentReservationFormActions.initEnvironmentReservationForm,
  onDeleteEnvironmentReservation: _schedulingEnvironmentReservationFormActions.onDeleteEnvironmentReservation,
  onReservationFormChange: _schedulingEnvironmentReservationFormActions.onReservationFormChange,
  onReservationEnvironmentChange: _schedulingEnvironmentReservationFormActions.onReservationEnvironmentChange,
  onReservationFormPristineChange: _schedulingEnvironmentReservationFormActions.onReservationFormPristineChange,
  onReservationFormValidChange: _schedulingEnvironmentReservationFormActions.onReservationFormValidChange,
  onReserveEnvironment: _schedulingEnvironmentReservationFormActions.onReserveEnvironment,
  onReserveEnvironmentCancel: _schedulingEnvironmentReservationFormActions.onReserveEnvironmentCancel
}, mergeProps)(SchedulingEnvironmentReservationForm);

/***/ }),

/***/ 55172:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _includes = _interopRequireDefault(__webpack_require__(64721));
var _sortBy = _interopRequireDefault(__webpack_require__(89734));
var _xlReactComponents = __webpack_require__(67082);
var _applicationSelect = _interopRequireDefault(__webpack_require__(65372));
var _widgets = __webpack_require__(67958);
var _types = __webpack_require__(57809);
__webpack_require__(94750);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var environmentFieldMetadata = {
  description: 'Environment to reserve',
  label: 'Environment',
  placeholder: 'Select environment...',
  required: true,
  requiredText: 'Environment is required'
};
var startDateFieldMetadata = {
  label: 'Start date',
  placeholder: 'Set start date...',
  description: 'Start date/time for reservation',
  required: true,
  dateFormat: 'MMM D, YYYY'
};
var endDateFieldMetadata = {
  label: 'End date',
  placeholder: 'Set end date...',
  description: 'End date/time for reservation',
  required: true,
  dateFormat: 'MMM D, YYYY'
};
var noteFieldMetadata = {
  label: 'Note',
  placeholder: 'Set note...',
  description: 'Note for approver',
  size: 'MEDIUM'
};
var SidebarReservationForm = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(SidebarReservationForm, _Component);
  var _super = _createSuper(SidebarReservationForm);
  function SidebarReservationForm(props) {
    var _this;
    (0, _classCallCheck2.default)(this, SidebarReservationForm);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEnvironmentChange", function (environment) {
      var _this$props = _this.props,
        reservationModel = _this$props.reservationModel,
        onFormChange = _this$props.onFormChange,
        onReservationEnvironmentChange = _this$props.onReservationEnvironmentChange;
      if (!environment) {
        environment = {};
      }
      onFormChange(_objectSpread(_objectSpread({}, reservationModel), {}, {
        applications: _.get(environment, 'id') === _.get(reservationModel, ['environment', 'id']) ? _.get(reservationModel, 'applications', []) : [],
        environment: environment
      }));
      onReservationEnvironmentChange(environment);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onApplicationChange", function (selectedApplications) {
      var _this$props2 = _this.props,
        onFormChange = _this$props2.onFormChange,
        reservationModel = _this$props2.reservationModel;
      onFormChange(_objectSpread(_objectSpread({}, reservationModel), {}, {
        applications: selectedApplications
      }));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onNoteChange", function (note) {
      var _this$props3 = _this.props,
        reservationModel = _this$props3.reservationModel,
        onFormChange = _this$props3.onFormChange;
      if (note !== reservationModel.note) {
        onFormChange(_objectSpread(_objectSpread({}, reservationModel), {}, {
          note: note
        }));
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onStartDatetimeChange", function (startDate) {
      var _this$props4 = _this.props,
        reservationModel = _this$props4.reservationModel,
        onFormChange = _this$props4.onFormChange;
      if (startDate !== reservationModel.startDate) {
        onFormChange(_objectSpread(_objectSpread({}, reservationModel), {}, {
          startDate: startDate
        }));
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEndDatetimeChange", function (endDate) {
      var _this$props5 = _this.props,
        reservationModel = _this$props5.reservationModel,
        onFormChange = _this$props5.onFormChange;
      if (endDate !== reservationModel.endDate) {
        onFormChange(_objectSpread(_objectSpread({}, reservationModel), {}, {
          endDate: endDate
        }));
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEnvironmentPristineChange", function (pristine) {
      var onFormPristinityChange = _this.props.onFormPristinityChange;
      var _this$state = _this.state,
        applicationsPristine = _this$state.applicationsPristine,
        startDatePristine = _this$state.startDatePristine,
        startTimePristine = _this$state.startTimePristine,
        endDatePristine = _this$state.endDatePristine,
        endTimePristine = _this$state.endTimePristine,
        notePristine = _this$state.notePristine;
      _this.setState({
        environmentPristine: pristine
      });
      var isFormPristine = pristine && applicationsPristine && startDatePristine && startTimePristine && endDatePristine && endTimePristine && notePristine;
      onFormPristinityChange(isFormPristine);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onApplicationsPristineChange", function (pristine) {
      var onFormPristinityChange = _this.props.onFormPristinityChange;
      var _this$state2 = _this.state,
        environmentPristine = _this$state2.environmentPristine,
        startDatePristine = _this$state2.startDatePristine,
        startTimePristine = _this$state2.startTimePristine,
        endDatePristine = _this$state2.endDatePristine,
        endTimePristine = _this$state2.endTimePristine,
        notePristine = _this$state2.notePristine;
      _this.setState({
        applicationsPristine: pristine
      });
      var isFormPristine = pristine && environmentPristine && startDatePristine && startTimePristine && endDatePristine && endTimePristine && notePristine;
      onFormPristinityChange(isFormPristine);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onStartDatePristineChange", function (pristine) {
      var onFormPristinityChange = _this.props.onFormPristinityChange;
      var _this$state3 = _this.state,
        environmentPristine = _this$state3.environmentPristine,
        applicationsPristine = _this$state3.applicationsPristine,
        startTimePristine = _this$state3.startTimePristine,
        endDatePristine = _this$state3.endDatePristine,
        endTimePristine = _this$state3.endTimePristine,
        notePristine = _this$state3.notePristine;
      _this.setState({
        startDatePristine: pristine
      });
      var isFormPristine = pristine && environmentPristine && applicationsPristine && startTimePristine && endDatePristine && endTimePristine && notePristine;
      onFormPristinityChange(isFormPristine);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onStartTimePristineChange", function (pristine) {
      var onFormPristinityChange = _this.props.onFormPristinityChange;
      var _this$state4 = _this.state,
        environmentPristine = _this$state4.environmentPristine,
        applicationsPristine = _this$state4.applicationsPristine,
        startDatePristine = _this$state4.startDatePristine,
        endDatePristine = _this$state4.endDatePristine,
        endTimePristine = _this$state4.endTimePristine,
        notePristine = _this$state4.notePristine;
      _this.setState({
        startTimePristine: pristine
      });
      var isFormPristine = pristine && environmentPristine && applicationsPristine && startDatePristine && endDatePristine && endTimePristine && notePristine;
      onFormPristinityChange(isFormPristine);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEndDatePristineChange", function (pristine) {
      var onFormPristinityChange = _this.props.onFormPristinityChange;
      var _this$state5 = _this.state,
        environmentPristine = _this$state5.environmentPristine,
        applicationsPristine = _this$state5.applicationsPristine,
        startDatePristine = _this$state5.startDatePristine,
        startTimePristine = _this$state5.startTimePristine,
        endTimePristine = _this$state5.endTimePristine,
        notePristine = _this$state5.notePristine;
      _this.setState({
        endDatePristine: pristine
      });
      var isFormPristine = pristine && environmentPristine && applicationsPristine && startDatePristine && startTimePristine && endTimePristine && notePristine;
      onFormPristinityChange(isFormPristine);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEndTimePristineChange", function (pristine) {
      var onFormPristinityChange = _this.props.onFormPristinityChange;
      var _this$state6 = _this.state,
        environmentPristine = _this$state6.environmentPristine,
        applicationsPristine = _this$state6.applicationsPristine,
        startDatePristine = _this$state6.startDatePristine,
        startTimePristine = _this$state6.startTimePristine,
        endDatePristine = _this$state6.endDatePristine,
        notePristine = _this$state6.notePristine;
      _this.setState({
        endTimePristine: pristine
      });
      var isFormPristine = pristine && environmentPristine && applicationsPristine && startDatePristine && startTimePristine && endDatePristine && notePristine;
      onFormPristinityChange(isFormPristine);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onNotePristine", function (pristine) {
      var onFormPristinityChange = _this.props.onFormPristinityChange;
      var _this$state7 = _this.state,
        environmentPristine = _this$state7.environmentPristine,
        applicationsPristine = _this$state7.applicationsPristine,
        startDatePristine = _this$state7.startDatePristine,
        startTimePristine = _this$state7.startTimePristine,
        endDatePristine = _this$state7.endDatePristine,
        endTimePristine = _this$state7.endTimePristine;
      _this.setState({
        notePristine: pristine
      });
      var isFormPristine = pristine && environmentPristine && applicationsPristine && startDatePristine && startTimePristine && endDatePristine && endTimePristine;
      onFormPristinityChange(isFormPristine);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEnvironmentValidityChange", function (valid) {
      var onFormValidationChange = _this.props.onFormValidationChange;
      _this.isEnvironmentValid = valid;
      onFormValidationChange(_this.isReservationFormValid);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onStartDateTimeValidityChange", function (valid) {
      var onFormValidationChange = _this.props.onFormValidationChange;
      _this.isStartDateTimeValid = valid;
      onFormValidationChange(_this.isReservationFormValid);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEndDateTimeValidityChange", function (valid) {
      var onFormValidationChange = _this.props.onFormValidationChange;
      _this.isEndDateTimeValid = valid;
      onFormValidationChange(_this.isReservationFormValid);
    });
    _this.state = {
      environmentPristine: true,
      applicationsPristine: true,
      startDatePristine: true,
      startTimePristine: true,
      endDatePristine: true,
      endTimePristine: true,
      notePristine: true
    };
    _this.isEnvironmentValid = false;
    _this.isStartDateTimeValid = false;
    _this.isEndDateTimeValid = false;
    return _this;
  }
  (0, _createClass2.default)(SidebarReservationForm, [{
    key: "isReservationFormValid",
    get: function get() {
      return this.isEnvironmentValid && this.isStartDateTimeValid && this.isEndDateTimeValid;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props6 = this.props,
        applications = _this$props6.applications,
        environments = _this$props6.environments,
        isEditForm = _this$props6.isEditForm,
        onCancel = _this$props6.onCancel,
        onConfirm = _this$props6.onConfirm,
        onDelete = _this$props6.onDelete,
        reservationModel = _this$props6.reservationModel,
        isSaveEnabled = _this$props6.isSaveEnabled;
      var autocompleteHandler = function autocompleteHandler(_ref) {
        var metadata = _ref.metadata,
          objLabel = _ref.objLabel,
          suggestedElements = _ref.suggestedElements,
          value = _ref.value;
        return Promise.resolve((0, _sortBy.default)(environments.filter(function (env) {
          return (0, _includes.default)(env.title.toLowerCase(), value.toLowerCase());
        }), ['title']));
      };
      var autocompleteHandlers = {
        addCandidates: autocompleteHandler
      };
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!isEditForm ? /*#__PURE__*/_react.default.createElement("h4", null, "Edit reservation") : /*#__PURE__*/_react.default.createElement("h4", null, "New reservation"), /*#__PURE__*/_react.default.createElement("div", {
        id: "environment-reservation-form"
      }, /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
        disabled: isEditForm,
        handlers: autocompleteHandlers,
        metadata: environmentFieldMetadata,
        model: reservationModel.environment,
        objLabel: 'title',
        onModelChange: this.onEnvironmentChange,
        onPristinityChange: this.onEnvironmentPristineChange,
        onValidityChange: this.onEnvironmentValidityChange
      }), /*#__PURE__*/_react.default.createElement(_applicationSelect.default, {
        model: reservationModel.applications,
        onModelChange: this.onApplicationChange,
        onPristinityChange: this.onApplicationsPristineChange,
        suggestions: applications
      }), /*#__PURE__*/_react.default.createElement(_widgets.WidgetDateTime, {
        metadata: startDateFieldMetadata,
        model: reservationModel.startDate,
        onDatePristinityChange: this.onStartDatePristineChange,
        onModelChange: this.onStartDatetimeChange,
        onTimePristinityChange: this.onStartTimePristineChange,
        onValidityChange: this.onStartDateTimeValidityChange
      }), /*#__PURE__*/_react.default.createElement(_widgets.WidgetDateTime, {
        metadata: endDateFieldMetadata,
        model: reservationModel.endDate,
        onDatePristinityChange: this.onEndDatePristineChange,
        onModelChange: this.onEndDatetimeChange,
        onTimePristinityChange: this.onEndTimePristineChange,
        onValidityChange: this.onEndDateTimeValidityChange
      }), /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetString, {
        metadata: noteFieldMetadata,
        model: reservationModel.note,
        onModelChange: this.onNoteChange,
        onPristinityChange: this.onNotePristine
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "text-right"
      }, /*#__PURE__*/_react.default.createElement("button", {
        className: "button cancel",
        onClick: onCancel
      }, "Cancel"), isEditForm && /*#__PURE__*/_react.default.createElement("button", {
        className: "button default",
        onClick: function onClick() {
          return onDelete(reservationModel.id);
        }
      }, "Delete"), /*#__PURE__*/_react.default.createElement("button", {
        className: "button primary",
        disabled: !isSaveEnabled,
        onClick: onConfirm
      }, "Reserve"))));
    }
  }]);
  return SidebarReservationForm;
}(_react.Component);
(0, _defineProperty2.default)(SidebarReservationForm, "propTypes", {
  applications: _propTypes.default.arrayOf(_types.Application),
  environments: _propTypes.default.arrayOf(_types.Environment).isRequired,
  isEditForm: _propTypes.default.bool.isRequired,
  isSaveEnabled: _propTypes.default.bool,
  onCancel: _propTypes.default.func.isRequired,
  onConfirm: _propTypes.default.func.isRequired,
  onDelete: _propTypes.default.func.isRequired,
  onFormChange: _propTypes.default.func.isRequired,
  onFormPristinityChange: _propTypes.default.func.isRequired,
  onFormValidationChange: _propTypes.default.func.isRequired,
  onReservationEnvironmentChange: _propTypes.default.func.isRequired,
  reservationModel: _types.ReservationModel
});

/***/ }),

/***/ 81433:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _react = _interopRequireWildcard(__webpack_require__(87363));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var SchedulingReleasePage = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(SchedulingReleasePage, _Component);
  var _super = _createSuper(SchedulingReleasePage);
  function SchedulingReleasePage() {
    (0, _classCallCheck2.default)(this, SchedulingReleasePage);
    return _super.apply(this, arguments);
  }
  (0, _createClass2.default)(SchedulingReleasePage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "col-sm-12"
      }, /*#__PURE__*/_react.default.createElement("p", null, "In progress..."));
    }
  }]);
  return SchedulingReleasePage;
}(_react.Component);

/***/ }),

/***/ 65372:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _xlReactComponents = __webpack_require__(67082);
var _includes = _interopRequireDefault(__webpack_require__(64721));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var applicationFieldMetadata = {
  description: 'Applications that will use this environment',
  label: 'Applications',
  name: 'autocomplete',
  placeholder: 'Select applications...'
};
var ApplicationSelect = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(ApplicationSelect, _Component);
  var _super = _createSuper(ApplicationSelect);
  function ApplicationSelect(props) {
    var _this;
    (0, _classCallCheck2.default)(this, ApplicationSelect);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getSuggestedApplications", function (_ref) {
      var metadata = _ref.metadata,
        objLabel = _ref.objLabel,
        suggestedElements = _ref.suggestedElements,
        value = _ref.value;
      var suggestions = _this.props.suggestions;
      var term = value.trim().toLowerCase();
      var apps = suggestions.filter(function (s) {
        return s.title.toLowerCase().includes(term);
      }).map(function (s) {
        return {
          value: s.title
        };
      });
      return Promise.resolve(apps);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleModelChange", function (changes) {
      var _this$props = _this.props,
        suggestions = _this$props.suggestions,
        onModelChange = _this$props.onModelChange,
        model = _this$props.model;
      if (0 === _.xor(changes.map(function (ch) {
        return ch.value;
      }), model.map(function (item) {
        return item.title;
      })).length) {
        return;
      }
      var selectedTitles = changes.map(function (ch) {
        return ch.value;
      });
      var selectedApplications = suggestions.filter(function (app) {
        return (0, _includes.default)(selectedTitles, app.title);
      });
      onModelChange(selectedApplications);
    });
    _this.applicationInputHandlers = {
      autocomplete: {
        addCandidates: _this.getSuggestedApplications.bind((0, _assertThisInitialized2.default)(_this))
      }
    };
    return _this;
  }
  (0, _createClass2.default)(ApplicationSelect, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        model = _this$props2.model,
        onPristinityChange = _this$props2.onPristinityChange;
      var selectedApplications = model.map(function (app) {
        return {
          value: app.title,
          label: app.title
        };
      });
      return /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetTags, {
        handlers: this.applicationInputHandlers,
        inputType: "autocomplete",
        metadata: applicationFieldMetadata,
        model: selectedApplications,
        objLabel: "value",
        onModelChange: this.handleModelChange,
        onPristinityChange: onPristinityChange,
        skin: "checkbox",
        tagTransform: function tagTransform(_) {
          return _;
        }
      });
    }
  }]);
  return ApplicationSelect;
}(_react.Component);
(0, _defineProperty2.default)(ApplicationSelect, "propTypes", {
  model: _propTypes.default.arrayOf(_propTypes.default.shape({
    title: _propTypes.default.string
  })),
  onModelChange: _propTypes.default.func.isRequired,
  onPristinityChange: _propTypes.default.func.isRequired,
  suggestions: _propTypes.default.arrayOf(_propTypes.default.shape({
    title: _propTypes.default.string
  }))
});
(0, _defineProperty2.default)(ApplicationSelect, "defaultProps", {
  model: [],
  suggestions: []
});
var _default = exports["default"] = ApplicationSelect;

/***/ }),

/***/ 23994:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _popover = _interopRequireDefault(__webpack_require__(62443));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _classnames = _interopRequireDefault(__webpack_require__(94184));
var _index = __webpack_require__(57809);
var _labelListTruncated = _interopRequireDefault(__webpack_require__(22137));
var _dotIconWrapper = __webpack_require__(23287);
__webpack_require__(65598);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var EnvironmentSideBarItem = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EnvironmentSideBarItem, _Component);
  var _super = _createSuper(EnvironmentSideBarItem);
  function EnvironmentSideBarItem() {
    var _this;
    (0, _classCallCheck2.default)(this, EnvironmentSideBarItem);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onClick", function (environment) {
      var onClick = _this.props.onClick;
      if (onClick) {
        onClick(environment);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderEnvironmentDescriptionPopup", function (description) {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "description-content"
      }, description);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderEnvironmentDescriptionPopover", function (environment) {
      return /*#__PURE__*/_react.default.createElement(_popover.default, {
        arrowPointAtCenter: true,
        content: _this.renderEnvironmentDescriptionPopup(environment.description),
        overlayClassName: "description-popup",
        placement: "bottomRight",
        trigger: "hover"
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: "icon-info xl-icon info-icon"
      }));
    });
    return _this;
  }
  (0, _createClass2.default)(EnvironmentSideBarItem, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        environment = _this$props.environment,
        isClickable = _this$props.isClickable;
      var containerClass = (0, _classnames.default)('environment-item-container', {
        clickable: isClickable
      });
      return /*#__PURE__*/_react.default.createElement("div", {
        className: containerClass,
        onClick: function onClick() {
          return _this2.onClick(environment);
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "environment-item-title-container"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "title",
        title: environment.title
      }, /*#__PURE__*/_react.default.createElement(_dotIconWrapper.DotIconWrapper, {
        className: "mrs",
        iconId: "environment"
      }), environment.title), environment.description && this.renderEnvironmentDescriptionPopover(environment)), /*#__PURE__*/_react.default.createElement("div", null, environment.labels && !!environment.labels.length && /*#__PURE__*/_react.default.createElement(_labelListTruncated.default, {
        labels: environment.labels
      })));
    }
  }]);
  return EnvironmentSideBarItem;
}(_react.Component);
(0, _defineProperty2.default)(EnvironmentSideBarItem, "propTypes", {
  environment: _index.Environment.isRequired,
  isClickable: _propTypes.default.bool,
  onClick: _propTypes.default.func
});
(0, _defineProperty2.default)(EnvironmentSideBarItem, "defaultProps", {
  isClickable: false,
  environments: []
});

/***/ }),

/***/ 36159:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _classnames = _interopRequireDefault(__webpack_require__(94184));
__webpack_require__(15756);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var componentSize = ['small', 'normal'];
var skinType = ['plus', 'remove', 'normal'];
var LabelItem = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(LabelItem, _Component);
  var _super = _createSuper(LabelItem);
  function LabelItem() {
    var _this;
    (0, _classCallCheck2.default)(this, LabelItem);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleClick", function (label) {
      var onClickLabel = _this.props.onClickLabel;
      if (onClickLabel) {
        onClickLabel(label);
      }
    });
    return _this;
  }
  (0, _createClass2.default)(LabelItem, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        envLabel = _this$props.envLabel,
        size = _this$props.size,
        isEditable = _this$props.isEditable,
        skin = _this$props.skin;
      var style = (0, _classnames.default)('label-box', size, {
        'editable-label': isEditable
      });
      return /*#__PURE__*/_react.default.createElement("div", {
        className: style,
        onClick: function onClick() {
          return _this2.handleClick(envLabel);
        },
        style: {
          backgroundColor: envLabel.color
        },
        title: "Click to edit"
      }, skin === 'plus' && /*#__PURE__*/_react.default.createElement("i", {
        className: "menu-item-icon xl-icon add-icon icon-s",
        title: "Add"
      }), /*#__PURE__*/_react.default.createElement("span", null, envLabel.title), skin === 'remove' && /*#__PURE__*/_react.default.createElement("i", {
        className: "menu-item-icon xl-icon close-icon icon-s",
        title: "Remove"
      }));
    }
  }]);
  return LabelItem;
}(_react.Component);
(0, _defineProperty2.default)(LabelItem, "propTypes", {
  envLabel: _propTypes.default.shape({
    color: _propTypes.default.string.isRequired,
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired
  }).isRequired,
  isEditable: _propTypes.default.bool,
  onClickLabel: _propTypes.default.func,
  size: _propTypes.default.oneOf(componentSize),
  skin: _propTypes.default.oneOf(skinType)
});
(0, _defineProperty2.default)(LabelItem, "defaultProps", {
  isEditable: false,
  size: 'normal',
  skin: 'normal'
});

/***/ }),

/***/ 22137:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _popover = _interopRequireDefault(__webpack_require__(62443));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _reactDom = _interopRequireDefault(__webpack_require__(61533));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _takeRight = _interopRequireDefault(__webpack_require__(69579));
var _labelItem = _interopRequireDefault(__webpack_require__(36159));
__webpack_require__(81855);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var LabelListTruncated = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(LabelListTruncated, _Component);
  var _super = _createSuper(LabelListTruncated);
  function LabelListTruncated(props) {
    var _this;
    (0, _classCallCheck2.default)(this, LabelListTruncated);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setItemRef", function (el) {
      _this.itemRefs.push(el);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderLabelList", function (labels) {
      return labels.map(function (label) {
        return /*#__PURE__*/_react.default.createElement(_labelItem.default, {
          envLabel: label,
          key: label.id,
          ref: _this.setItemRef,
          size: "small"
        });
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderPopupContent", function () {
      var labels = _this.props.labels;
      var moreItems = _this.state.moreItems;
      var labelListInPopup = (0, _takeRight.default)(labels, moreItems);
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "type-popup-content"
      }, _this.renderLabelList(labelListInPopup));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderLabelListPopup", function () {
      var moreItems = _this.state.moreItems;
      return !!moreItems && /*#__PURE__*/_react.default.createElement(_popover.default, {
        arrowPointAtCenter: true,
        content: _this.renderPopupContent(),
        overlayClassName: "type-popup",
        placement: "bottomRight",
        trigger: "hover"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "more-labels"
      }, moreItems, " more..."));
    });
    _this.containerRef = /*#__PURE__*/_react.default.createRef();
    _this.itemRefs = [];
    _this.state = {
      moreItems: null
    };
    return _this;
  }
  (0, _createClass2.default)(LabelListTruncated, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      /* eslint-disable react/no-find-dom-node */
      var container = _reactDom.default.findDOMNode(this.containerRef.current);
      /* eslint-enable react/no-find-dom-node */
      if (container && this.itemRefs.length) {
        var bound = container.getBoundingClientRect();
        var moreItems = this.itemRefs.reduce(function (acc, curr) {
          /* eslint-disable react/no-find-dom-node */
          var node = _reactDom.default.findDOMNode(curr);
          /* eslint-enable react/no-find-dom-node */
          if (node) {
            var rect = node.getBoundingClientRect();
            if (rect.top - bound.top > bound.height / 2) {
              return acc + 1;
            }
          }
          return acc;
        }, 0);
        if (moreItems) {
          /* eslint-disable react/no-did-mount-set-state */
          this.setState({
            moreItems: moreItems
          });
          /* eslint-enable react/no-did-mount-set-state */
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var labels = this.props.labels;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "label-list",
        ref: this.containerRef
      }, this.renderLabelList(labels), this.renderLabelListPopup());
    }
  }]);
  return LabelListTruncated;
}(_react.Component);
(0, _defineProperty2.default)(LabelListTruncated, "propTypes", {
  labels: _propTypes.default.arrayOf(_propTypes.default.object)
});
var _default = exports["default"] = LabelListTruncated;

/***/ }),

/***/ 78409:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "ListBlock", ({
  enumerable: true,
  get: function get() {
    return _listBlock.default;
  }
}));
var _listBlock = _interopRequireDefault(__webpack_require__(97777));

/***/ }),

/***/ 97777:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
__webpack_require__(81886);
var ListBlock = function ListBlock(_ref) {
  var children = _ref.children,
    childrenClassName = _ref.childrenClassName,
    listBlockClassName = _ref.listBlockClassName,
    onDelete = _ref.onDelete;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "list-block ".concat(listBlockClassName)
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "list-block-children ".concat(childrenClassName)
  }, children), /*#__PURE__*/_react.default.createElement("span", {
    className: "cross xl-icon close-icon",
    onClick: onDelete
  }));
};
ListBlock.propTypes = {
  children: _propTypes.default.element.isRequired,
  childrenClassName: _propTypes.default.string,
  listBlockClassName: _propTypes.default.string,
  onDelete: _propTypes.default.func.isRequired
};
ListBlock.defaultProps = {
  childrenClassName: '',
  listBlockClassName: ''
};
var _default = exports["default"] = ListBlock;

/***/ }),

/***/ 1389:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _xlReactComponents = __webpack_require__(67082);
var _listBlock = __webpack_require__(78409);
var _components = __webpack_require__(78605);
var _dotIconWrapper = __webpack_require__(23287);
var _index = __webpack_require__(57809);
__webpack_require__(77284);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var environmentsMetadata = {
  label: 'Linked environments',
  required: false
};
var WidgetLinkedEnvironments = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(WidgetLinkedEnvironments, _Component);
  var _super = _createSuper(WidgetLinkedEnvironments);
  function WidgetLinkedEnvironments() {
    var _this;
    (0, _classCallCheck2.default)(this, WidgetLinkedEnvironments);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onClickDelete", function (environment) {
      _this.props.onDelete(environment);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderEmptyContainer", function () {
      return /*#__PURE__*/_react.default.createElement(_components.HelpBlock, null, "Click an environment on the right to link it to the application");
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderEnvironmentLinked", function (environment) {
      return /*#__PURE__*/_react.default.createElement(_listBlock.ListBlock, {
        childrenClassName: "list-block-env-title",
        key: environment.id,
        onDelete: function onDelete() {
          return _this.onClickDelete(environment);
        }
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_dotIconWrapper.DotIconWrapper, {
        className: "mrs",
        iconId: "environment"
      }), /*#__PURE__*/_react.default.createElement("span", {
        title: environment.title
      }, environment.title)));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderContainer", function (environments) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, environments.map(function (e) {
        return _this.renderEnvironmentLinked(e);
      }));
    });
    return _this;
  }
  (0, _createClass2.default)(WidgetLinkedEnvironments, [{
    key: "render",
    value: function render() {
      var environments = this.props.environments;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "xl-react-components"
      }, /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetLabel, {
        metadata: environmentsMetadata
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "xl-react-components-input"
      }, environments.length ? this.renderContainer(environments) : this.renderEmptyContainer()));
    }
  }]);
  return WidgetLinkedEnvironments;
}(_react.Component);
(0, _defineProperty2.default)(WidgetLinkedEnvironments, "propTypes", {
  environments: _propTypes.default.arrayOf(_index.Environment),
  onDelete: _propTypes.default.func.isRequired
});
(0, _defineProperty2.default)(WidgetLinkedEnvironments, "defaultProps", {
  environments: []
});

/***/ }),

/***/ 22516:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _typeof = __webpack_require__(50008);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(34575));
var _createClass2 = _interopRequireDefault(__webpack_require__(93913));
var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(81506));
var _inherits2 = _interopRequireDefault(__webpack_require__(2205));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(78585));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(29754));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _react = _interopRequireWildcard(__webpack_require__(87363));
var _propTypes = _interopRequireDefault(__webpack_require__(45697));
var _xlReactComponents = __webpack_require__(67082);
var _labelItem = _interopRequireDefault(__webpack_require__(36159));
var _components = __webpack_require__(78605);
var _types = __webpack_require__(57809);
__webpack_require__(15375);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var labelsFiledMetadata = {
  label: 'Labels',
  required: false
};
var WidgetLinkedLabels = exports["default"] = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(WidgetLinkedLabels, _Component);
  var _super = _createSuper(WidgetLinkedLabels);
  function WidgetLinkedLabels() {
    var _this;
    (0, _classCallCheck2.default)(this, WidgetLinkedLabels);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderEmptyContainer", function () {
      return /*#__PURE__*/_react.default.createElement(_components.HelpBlock, null, "Click a label on the right to assign it to the environment");
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderContainer", function (labelList) {
      var onDelete = _this.props.onDelete;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "list-block-label-title"
      }, labelList.map(function (envLabel) {
        return /*#__PURE__*/_react.default.createElement(_labelItem.default, {
          envLabel: envLabel,
          key: envLabel.id,
          onClickLabel: onDelete,
          skin: 'remove'
        });
      }));
    });
    return _this;
  }
  (0, _createClass2.default)(WidgetLinkedLabels, [{
    key: "render",
    value: function render() {
      var labelList = this.props.labelList;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "xl-react-components"
      }, /*#__PURE__*/_react.default.createElement(_xlReactComponents.XlReactWidgetLabel, {
        metadata: labelsFiledMetadata
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "xl-react-components-input"
      }, labelList.length ? this.renderContainer(labelList) : this.renderEmptyContainer()));
    }
  }]);
  return WidgetLinkedLabels;
}(_react.Component);
(0, _defineProperty2.default)(WidgetLinkedLabels, "propTypes", {
  labelList: _propTypes.default.arrayOf(_types.Label).isRequired,
  onDelete: _propTypes.default.func.isRequired
});
(0, _defineProperty2.default)(WidgetLinkedLabels, "defaultProps", {
  labelList: []
});

/***/ }),

/***/ 92884:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _reactDnd = __webpack_require__(90937);
var _reactDndHtml5Backend = _interopRequireDefault(__webpack_require__(13383));
var _default = exports["default"] = (0, _reactDnd.DragDropContext)(_reactDndHtml5Backend.default);

/***/ }),

/***/ 73441:
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
var _react2angular = __webpack_require__(96563);
var _environmentListPage = _interopRequireDefault(__webpack_require__(42775));
var _environmentEditPage = _interopRequireDefault(__webpack_require__(77596));
var _applicationListPage = _interopRequireDefault(__webpack_require__(75994));
var _applicationEditPage = _interopRequireDefault(__webpack_require__(77156));
var _stagePage = _interopRequireDefault(__webpack_require__(11375));
var _labelPage = _interopRequireDefault(__webpack_require__(90745));
var _schedulingReleasePage = _interopRequireDefault(__webpack_require__(81433));
var _schedulingEnvironmentPage = _interopRequireDefault(__webpack_require__(36971));
var _permissionsConstants = __webpack_require__(88169);
angular.module('xlrelease.environmentManagement', ['xlrelease']).component('environmentPage', (0, _react2angular.react2angular)(_environmentListPage.default)).component('environmentEditPage', (0, _react2angular.react2angular)(_environmentEditPage.default, ['environmentId'])).component('stagePage', (0, _react2angular.react2angular)(_stagePage.default)).component('labelPage', (0, _react2angular.react2angular)(_labelPage.default)).component('applicationListPage', (0, _react2angular.react2angular)(_applicationListPage.default)).component('applicationEditPage', (0, _react2angular.react2angular)(_applicationEditPage.default, ['applicationId'])).component('schedulingReleasePage', (0, _react2angular.react2angular)(_schedulingReleasePage.default)).component('schedulingEnvironmentPage', (0, _react2angular.react2angular)(_schedulingEnvironmentPage.default)).config(['$urlMatcherFactoryProvider', '$stateProvider', function ($urlMatcherFactoryProvider, $stateProvider) {
  var envMgmtPattern = 'Configuration/environmentManagement';
  $urlMatcherFactoryProvider.type('EnvironmentId', {
    encode: angular.identity,
    decode: angular.identity,
    pattern: new RegExp(envMgmtPattern + '/Environment\\w+')
  });
  $urlMatcherFactoryProvider.type('ApplicationId', {
    encode: angular.identity,
    decode: angular.identity,
    pattern: new RegExp(envMgmtPattern + '/Application\\w+')
  });
  $urlMatcherFactoryProvider.type('EnvironmentStageId', {
    encode: angular.identity,
    decode: angular.identity,
    pattern: new RegExp(envMgmtPattern + '/EnvironmentStage\\w+')
  });
  $urlMatcherFactoryProvider.type('EnvironmentLabelId', {
    encode: angular.identity,
    decode: angular.identity,
    pattern: new RegExp(envMgmtPattern + '/EnvironmentLabel\\w+')
  });
  $urlMatcherFactoryProvider.type('EnvironmentReservationId', {
    encode: angular.identity,
    decode: angular.identity,
    pattern: new RegExp(envMgmtPattern + '/EnvironmentReservation\\w+')
  });
  $stateProvider.state('environmentCreate', {
    url: '/environments/edit?{environmentId: EnvironmentId}',
    template: '<environment-edit-page environment-id="$resolve.environmentId"></environment-edit-page>',
    resolve: {
      environmentId: ['$stateParams', function ($stateParams) {
        if ($stateParams.environmentId) {
          return $stateParams.environmentId;
        } else {
          return null;
        }
      }]
    }
  }).state('environmentList', {
    url: '/environments',
    permissions: [_permissionsConstants.GlobalPermissions.EDIT_GLOBAL_ENVIRONMENT],
    template: '<environment-page></environment-page>'
  }).state('stageList', {
    url: '/environments-stages',
    permissions: [_permissionsConstants.GlobalPermissions.EDIT_GLOBAL_ENVIRONMENT],
    template: '<stage-page></stage-page>'
  }).state('labelList', {
    url: '/environments-labels',
    permissions: [_permissionsConstants.GlobalPermissions.EDIT_GLOBAL_ENVIRONMENT],
    template: '<label-page></label-page>'
  }).state('environmentSchedule', {
    url: '/schedule-environments',
    permissions: [_permissionsConstants.GlobalPermissions.EDIT_GLOBAL_RESERVATION],
    template: '<scheduling-environment-page></scheduling-environment-page>'
  }).state('applicationList', {
    url: '/applications',
    permissions: [_permissionsConstants.GlobalPermissions.EDIT_GLOBAL_APPLICATION],
    template: '<application-list-page></application-list-page>'
  }).state('applicationCreate', {
    url: '/applications/edit?{applicationId: ApplicationId}',
    template: '<application-edit-page application-id="$resolve.applicationId"></application-edit-page>',
    resolve: {
      applicationId: ['$stateParams', function ($stateParams) {
        if ($stateParams.applicationId) {
          return $stateParams.applicationId;
        } else {
          return null;
        }
      }]
    }
  });
}]);

/***/ }),

/***/ 60610:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.initialState = exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _applicationActions = __webpack_require__(30332);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var initialState = exports.initialState = function initialState() {
  return {
    stages: [],
    environments: [],
    application: {
      title: '',
      environments: []
    },
    applications: []
  };
};
var _default = exports["default"] = function _default() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;
  switch (action.type) {
    case _applicationActions.actionTypes.APPLICATION_LOAD_SUCCESS:
      return _objectSpread(_objectSpread({}, state), {}, {
        application: action.payload
      });
    case _applicationActions.actionTypes.APPLICATION_ENV_LOAD_SUCCESS:
      return _objectSpread(_objectSpread({}, state), {}, {
        environments: action.payload
      });
    case _applicationActions.actionTypes.APPLICATION_STAGE_LOAD_SUCCESS:
      return _objectSpread(_objectSpread({}, state), {}, {
        stages: action.payload
      });
    case _applicationActions.actionTypes.APPLICATION_LIST_LOAD_SUCCESS:
      return _objectSpread(_objectSpread({}, state), {}, {
        applications: action.payload
      });
    case _applicationActions.actionTypes.APPLICATION_FORM_CLEAN:
      return _objectSpread(_objectSpread({}, state), {}, {
        application: initialState().application
      });
    default:
      return state;
  }
};

/***/ }),

/***/ 9639:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.initialState = exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _applicationActions = __webpack_require__(30332);
var _schedulingActions = __webpack_require__(6711);
var _utils = __webpack_require__(85043);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var initialState = exports.initialState = function initialState() {
  return {
    applications: []
  };
};
var _default = exports["default"] = function _default() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;
  switch (action.type) {
    case _applicationActions.actionTypes.APPLICATION_SEARCH_SUCCESS:
      {
        var applications = action.payload.sort(_utils.byTitle);
        return _objectSpread(_objectSpread({}, state), {}, {
          applications: applications
        });
      }
    case _schedulingActions.actionTypes.SCHEDULE_INIT_HEADER_SUCCESS:
      {
        var _applications = action.payload.applications;
        return _objectSpread(_objectSpread({}, state), {}, {
          applications: _applications.sort(_utils.byTitle)
        });
      }
    case _applicationActions.actionTypes.APPLICATION_DELETE_SUCCESS:
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          applications: state.applications.filter(function (app) {
            return app.id !== action.payload.id;
          })
        });
      }
    default:
      return state;
  }
};

/***/ }),

/***/ 81217:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _environmentFormActions = __webpack_require__(42726);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var initialState = function initialState() {
  return {
    environmentModel: {
      stage: {},
      id: null,
      labels: [],
      title: '',
      description: ''
    },
    environments: [],
    formIsPristine: true,
    formIsValid: false
  };
};
var _default = exports["default"] = function _default() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;
  switch (action.type) {
    case _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_CLEAN_FORM:
      return _objectSpread(_objectSpread({}, initialState()), {}, {
        environmentModel: _objectSpread({}, initialState().environmentModel),
        formIsPristine: state.formIsPristine
      });
    case _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_VALID_FORM:
      return _objectSpread(_objectSpread({}, state), {}, {
        formIsValid: action.payload
      });
    case _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_PRISTINE_FORM:
      return _objectSpread(_objectSpread({}, state), {}, {
        formIsPristine: action.payload
      });
    case _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_CHANGE_FORM:
      return _objectSpread(_objectSpread({}, state), {}, {
        environmentModel: action.payload
      });
    case _environmentFormActions.actionTypes.ENVIRONMENT_LOAD_SUCCESS:
      return _objectSpread(_objectSpread({}, state), {}, {
        environmentModel: action.payload
      });
    case _environmentFormActions.actionTypes.ENVIRONMENT_SEARCH_SUCCESS:
      return _objectSpread(_objectSpread({}, state), {}, {
        environments: action.payload
      });
    case _environmentFormActions.actionTypes.INIT_ENVIRONMENT_FORM_SUCCESS:
      var _action$payload = action.payload,
        environment = _action$payload.environment,
        environments = _action$payload.environments;
      return _objectSpread(_objectSpread({}, state), {}, {
        formIsPristine: true,
        environmentModel: environment || initialState().environmentModel,
        environments: environments
      });
    default:
      return state;
  }
};

/***/ }),

/***/ 9866:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.initialState = exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _environmentActions = __webpack_require__(32385);
var _utils = __webpack_require__(85043);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var initialState = exports.initialState = function initialState() {
  return {
    list: [],
    filters: {
      title: '',
      stage: {}
    },
    loading: false
  };
};
var _default = exports["default"] = function _default() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;
  switch (action.type) {
    case _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST:
    case _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_REQUEST:
      return _objectSpread(_objectSpread({}, state), {}, {
        loading: true
      });
    case _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_SUCCESS:
      {
        var environments = action.payload.sort(_utils.byTitle);
        return _objectSpread(_objectSpread({}, state), {}, {
          list: environments,
          loading: false
        });
      }
    case _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_FAILURE:
      return _objectSpread(_objectSpread({}, state), {}, {
        loading: false
      });
    case _environmentActions.actionTypes.ENVIRONMENT_DELETE_REQUEST:
      return _objectSpread(_objectSpread({}, state), {}, {
        loading: true
      });
    case _environmentActions.actionTypes.ENVIRONMENT_DELETE_SUCCESS:
      return _objectSpread(_objectSpread({}, state), {}, {
        loading: false
      });
    case _environmentActions.actionTypes.ENVIRONMENT_DELETE_FAILURE:
      return _objectSpread(_objectSpread({}, state), {}, {
        loading: false
      });
    case _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST_SUCCESS:
      {
        var _environments = action.payload.environments;
        return _objectSpread(_objectSpread({}, state), {}, {
          list: _environments.sort(_utils.byTitle),
          loading: false
        });
      }
    case _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST_FAILURE:
      return _objectSpread(_objectSpread({}, state), {}, {
        loading: false
      });
    case _environmentActions.actionTypes.TITLE_FILTER_CHANGE:
      var title = action.payload;
      return _objectSpread(_objectSpread({}, state), {}, {
        filters: _objectSpread(_objectSpread({}, state.filters), {}, {
          title: title
        })
      });
    case _environmentActions.actionTypes.STAGE_FILTER_CHANGE:
      var stage = action.payload;
      return _objectSpread(_objectSpread({}, state), {}, {
        filters: _objectSpread(_objectSpread({}, state.filters), {}, {
          stage: stage
        })
      });
    default:
      return state;
  }
};

/***/ }),

/***/ 22361:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _labelActions = __webpack_require__(3963);
var _schedulingActions = __webpack_require__(6711);
var _utils = __webpack_require__(85043);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var initialState = function initialState() {
  return {
    labelList: []
  };
};
var _default = exports["default"] = function _default() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;
  switch (action.type) {
    case _labelActions.actionTypes.LABEL_SEARCH_SUCCESS:
      {
        var labels = action.payload;
        return _objectSpread(_objectSpread({}, state), {}, {
          labelList: labels.sort(_utils.byTitle)
        });
      }
    case _schedulingActions.actionTypes.SCHEDULE_INIT_HEADER_SUCCESS:
      {
        var _labels = action.payload.labels;
        return _objectSpread(_objectSpread({}, state), {}, {
          labelList: _labels.sort(_utils.byTitle)
        });
      }
    default:
      return state;
  }
};

/***/ }),

/***/ 64047:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _environmentFormReducer = _interopRequireDefault(__webpack_require__(81217));
var _environmentListReducer = _interopRequireDefault(__webpack_require__(9866));
var _stageReducer = _interopRequireDefault(__webpack_require__(75991));
var _labelReducer = _interopRequireDefault(__webpack_require__(22361));
var _schedulingEnvironmentReservationFormReducer = _interopRequireDefault(__webpack_require__(66938));
var _schedulingReducer = _interopRequireDefault(__webpack_require__(23775));
var _applicationListReducer = _interopRequireDefault(__webpack_require__(9639));
var _applicationFormReducer = _interopRequireDefault(__webpack_require__(60610));
var _default = exports["default"] = {
  environmentForm: _environmentFormReducer.default,
  environmentList: _environmentListReducer.default,
  environmentStages: _stageReducer.default,
  labels: _labelReducer.default,
  schedulingEnvironmentReservationForm: _schedulingEnvironmentReservationFormReducer.default,
  scheduling: _schedulingReducer.default,
  applicationList: _applicationListReducer.default,
  applicationForm: _applicationFormReducer.default
};

/***/ }),

/***/ 66938:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.initialState = exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _schedulingEnvironmentReservationFormActions = __webpack_require__(5334);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var initialState = exports.initialState = function initialState() {
  return {
    reservationModel: {
      id: null,
      environment: {},
      applications: [],
      startDate: new Date(),
      endDate: new Date(new Date().getTime() + 1),
      note: ''
    },
    applications: [],
    environments: [],
    reservationFormIsPristine: true,
    reservationFormIsValid: false
  };
};
var _default = exports["default"] = function _default() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;
  switch (action.type) {
    case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE:
      return _objectSpread(_objectSpread({}, state), {}, {
        reservationModel: action.payload
      });
    case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED:
      return _objectSpread(_objectSpread({}, state), {}, {
        applications: action.payload
      });
    case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM:
      return _objectSpread({}, initialState());
    case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM:
      return _objectSpread(_objectSpread({}, state), {}, {
        reservationFormIsValid: action.payload
      });
    case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM:
      return _objectSpread(_objectSpread({}, state), {}, {
        reservationFormIsPristine: action.payload
      });
    case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_FAILURE:
      return _objectSpread({}, state);
    case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED:
      return _objectSpread(_objectSpread({}, state), {}, {
        reservationModel: initialState().reservationModel
      });
    default:
      return state;
  }
};

/***/ }),

/***/ 23775:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.initialState = exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _moment = _interopRequireDefault(__webpack_require__(72897));
var _schedulingActions = __webpack_require__(6711);
var _utils = __webpack_require__(85043);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var initialState = exports.initialState = function initialState() {
  return {
    environmentsReservations: [],
    schedulerFilter: {
      environmentTitle: '',
      from: (0, _moment.default)().startOf('month').valueOf(),
      to: (0, _moment.default)().endOf('month').valueOf(),
      applications: [],
      stages: [],
      labels: []
    },
    reservationSidebarIsOpen: false
  };
};
var _default = exports["default"] = function _default() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;
  switch (action.type) {
    case _schedulingActions.actionTypes.SCHEDULE_SEARCH_REQUEST:
      return _objectSpread(_objectSpread({}, state), {}, {
        schedulerFilter: action.payload
      });
    case _schedulingActions.actionTypes.SCHEDULE_SEARCH_SUCCESS:
      {
        var environmentsReservations = action.payload;
        return _objectSpread(_objectSpread({}, state), {}, {
          environmentsReservations: environmentsReservations.sort(_utils.byTitle)
        });
      }
    case _schedulingActions.actionTypes.SCHEDULE_SEARCH_FAILURE:
      return _objectSpread({}, state);
    case _schedulingActions.actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR:
      return _objectSpread(_objectSpread({}, state), {}, {
        reservationSidebarIsOpen: action.payload
      });
    case _schedulingActions.actionTypes.SCHEDULE_CLEAN_STATE:
      return _objectSpread({}, initialState());
    default:
      return state;
  }
};

/***/ }),

/***/ 75991:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.initialState = exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(59713));
var _stageActions = __webpack_require__(4077);
var _environmentActions = __webpack_require__(32385);
var _schedulingActions = __webpack_require__(6711);
var _utils = __webpack_require__(85043);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var initialState = exports.initialState = function initialState() {
  return {
    stageList: []
  };
};
var _default = exports["default"] = function _default() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;
  switch (action.type) {
    case _stageActions.actionTypes.STAGE_SEARCH_SUCCESS:
      {
        var stages = action.payload.sort(_utils.byTitle);
        return _objectSpread(_objectSpread({}, state), {}, {
          stageList: stages
        });
      }
    case _schedulingActions.actionTypes.SCHEDULE_INIT_HEADER_SUCCESS:
      {
        var _stages = action.payload.stages;
        return _objectSpread(_objectSpread({}, state), {}, {
          stageList: _stages.sort(_utils.byTitle)
        });
      }
    case _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST_SUCCESS:
      {
        var _stages2 = action.payload.stages;
        return _objectSpread(_objectSpread({}, state), {}, {
          stageList: _stages2.sort(_utils.byTitle)
        });
      }
    default:
      return state;
  }
};

/***/ }),

/***/ 49770:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.applicationFormSaga = applicationFormSaga;
exports.cancelApplicationForm = cancelApplicationForm;
exports.initApplicationForm = initApplicationForm;
exports.saveApplication = saveApplication;
exports.toastr = void 0;
exports.updateApplicationModel = updateApplicationModel;
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _effects = __webpack_require__(34857);
var _isEmpty = _interopRequireDefault(__webpack_require__(41609));
var _toastrFactory = _interopRequireDefault(__webpack_require__(86846));
var _applicationActions = __webpack_require__(30332);
var _applicationService = __webpack_require__(61176);
var _angularAccessor = _interopRequireDefault(__webpack_require__(81403));
var _environmentService = __webpack_require__(7089);
var _stageService = __webpack_require__(29439);
var _sagas = __webpack_require__(86157);
var _marked = /*#__PURE__*/_regenerator.default.mark(initApplicationForm),
  _marked2 = /*#__PURE__*/_regenerator.default.mark(cancelApplicationForm),
  _marked3 = /*#__PURE__*/_regenerator.default.mark(updateApplicationModel),
  _marked4 = /*#__PURE__*/_regenerator.default.mark(saveApplication),
  _marked5 = /*#__PURE__*/_regenerator.default.mark(applicationFormSaga);
var toastr = exports.toastr = (0, _toastrFactory.default)();
var cleanFormFields = {
  type: _applicationActions.actionTypes.APPLICATION_FORM_CLEAN
};
function initApplicationForm(action) {
  var applicationId, application, environments, stages, applications;
  return _regenerator.default.wrap(function initApplicationForm$(_context) {
    while (1) switch (_context.prev = _context.next) {
      case 0:
        _context.prev = 0;
        applicationId = action.payload;
        if ((0, _isEmpty.default)(applicationId)) {
          _context.next = 8;
          break;
        }
        _context.next = 5;
        return (0, _effects.call)(_applicationService.getApp, applicationId);
      case 5:
        application = _context.sent;
        _context.next = 8;
        return (0, _effects.put)({
          type: _applicationActions.actionTypes.APPLICATION_LOAD_SUCCESS,
          payload: application
        });
      case 8:
        _context.next = 10;
        return (0, _effects.call)(_environmentService.searchEnvironments, '');
      case 10:
        environments = _context.sent;
        _context.next = 13;
        return (0, _effects.put)({
          type: _applicationActions.actionTypes.APPLICATION_ENV_LOAD_SUCCESS,
          payload: environments
        });
      case 13:
        _context.next = 15;
        return (0, _effects.call)(_stageService.searchStages, '');
      case 15:
        stages = _context.sent;
        _context.next = 18;
        return (0, _effects.put)({
          type: _applicationActions.actionTypes.APPLICATION_STAGE_LOAD_SUCCESS,
          payload: stages
        });
      case 18:
        _context.next = 20;
        return (0, _effects.call)(_applicationService.searchApp, '');
      case 20:
        applications = _context.sent;
        _context.next = 23;
        return (0, _effects.put)({
          type: _applicationActions.actionTypes.APPLICATION_LIST_LOAD_SUCCESS,
          payload: applications
        });
      case 23:
        _context.next = 29;
        break;
      case 25:
        _context.prev = 25;
        _context.t0 = _context["catch"](0);
        _context.next = 29;
        return (0, _effects.put)({
          type: _applicationActions.actionTypes.APPLICATION_FORM_FAILURE
        });
      case 29:
      case "end":
        return _context.stop();
    }
  }, _marked, null, [[0, 25]]);
}
function cancelApplicationForm() {
  var $state;
  return _regenerator.default.wrap(function cancelApplicationForm$(_context2) {
    while (1) switch (_context2.prev = _context2.next) {
      case 0:
        _context2.next = 2;
        return (0, _effects.call)(_sagas.removeConfirmLeavePopup);
      case 2:
        _context2.next = 4;
        return (0, _effects.call)(_angularAccessor.default, '$state');
      case 4:
        $state = _context2.sent;
        _context2.next = 7;
        return (0, _effects.call)($state.go, 'applicationList');
      case 7:
        _context2.next = 9;
        return (0, _effects.put)(cleanFormFields);
      case 9:
      case "end":
        return _context2.stop();
    }
  }, _marked2);
}
function updateApplicationModel(action) {
  return _regenerator.default.wrap(function updateApplicationModel$(_context3) {
    while (1) switch (_context3.prev = _context3.next) {
      case 0:
        _context3.next = 2;
        return (0, _effects.put)({
          type: _applicationActions.actionTypes.APPLICATION_LOAD_SUCCESS,
          payload: action.payload
        });
      case 2:
      case "end":
        return _context3.stop();
    }
  }, _marked3);
}
function saveApplication(action) {
  var application, $state;
  return _regenerator.default.wrap(function saveApplication$(_context4) {
    while (1) switch (_context4.prev = _context4.next) {
      case 0:
        _context4.prev = 0;
        application = action.payload;
        application.environmentIds = application.environments.map(function (env) {
          return env.id;
        });
        _context4.next = 5;
        return (0, _effects.call)(_angularAccessor.default, '$state');
      case 5:
        $state = _context4.sent;
        _context4.next = 8;
        return (0, _effects.call)(_sagas.removeConfirmLeavePopup);
      case 8:
        if (!(0, _isEmpty.default)(application.id)) {
          _context4.next = 17;
          break;
        }
        _context4.next = 11;
        return (0, _effects.call)(_applicationService.createApp, application);
      case 11:
        _context4.next = 13;
        return (0, _effects.call)(toastr.success, "Created application [".concat(action.payload.title, "]"));
      case 13:
        _context4.next = 15;
        return (0, _effects.call)($state.go, 'applicationList');
      case 15:
        _context4.next = 23;
        break;
      case 17:
        _context4.next = 19;
        return (0, _effects.call)(_applicationService.updateApp, application);
      case 19:
        _context4.next = 21;
        return (0, _effects.call)(toastr.success, "Updated application [".concat(action.payload.title, "]"));
      case 21:
        _context4.next = 23;
        return (0, _effects.call)($state.go, 'applicationList');
      case 23:
        _context4.next = 29;
        break;
      case 25:
        _context4.prev = 25;
        _context4.t0 = _context4["catch"](0);
        _context4.next = 29;
        return (0, _effects.put)({
          type: _applicationActions.actionTypes.APPLICATION_SAVE_FAILURE,
          error: _context4.t0 // for testing purposes
        });
      case 29:
      case "end":
        return _context4.stop();
    }
  }, _marked4, null, [[0, 25]]);
}
function applicationFormSaga() {
  return _regenerator.default.wrap(function applicationFormSaga$(_context5) {
    while (1) switch (_context5.prev = _context5.next) {
      case 0:
        _context5.next = 2;
        return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_SAVE_REQUEST, saveApplication);
      case 2:
        _context5.next = 4;
        return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_FORM_INIT, initApplicationForm);
      case 4:
        _context5.next = 6;
        return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_FORM_UPDATE_MODEL, updateApplicationModel);
      case 6:
        _context5.next = 8;
        return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_FORM_CANCEL, cancelApplicationForm);
      case 8:
        _context5.next = 10;
        return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_FORM_PRISTINE, _sagas.addConfirmLeavePopup);
      case 10:
      case "end":
        return _context5.stop();
    }
  }, _marked5);
}

/***/ }),

/***/ 71770:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(95318);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.applicationListSaga = applicationListSaga;
exports.deleteApplication = deleteApplication;
exports.goToApplicationCreate = goToApplicationCreate;
exports.goToApplicationEdit = goToApplicationEdit;
exports.searchApplications = searchApplications;
exports.toastr = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(87757));
var _effects = __webpack_require__(34857);
var _toastrFactory = _interopRequireDefault(__webpack_require__(86846));
var _applicationActions = __webpack_require__(30332);
var _angularAccessor = _interopRequireDefault(__webpack_require__(81403));
var _applicationService = __webpack_require__(61176);
var _marked = /*#__PURE__*/_regenerator.default.mark(searchApplications)