/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.client.RMQMessageListenerExecutionJMSException;
import com.rabbitmq.jms.util.RMQJMSException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class DeliveryExecutor {
    private final long onMessageTimeoutMs;
    private final boolean closeOnTimeout;
    private ExecutorService onMessageExecutorService = null;
    private final Object lockOnMessageExecutorService = new Object();

    DeliveryExecutor(long onMessageTimeoutMs, boolean closeOnTimeout) {
        this.onMessageTimeoutMs = onMessageTimeoutMs;
        this.closeOnTimeout = closeOnTimeout;
    }

    public void deliverMessageWithProtection(RMQMessage rmqMessage, MessageListener messageListener) throws JMSException, InterruptedException {
        Future<Boolean> task = null;
        try {
            task = this.getExecutorService().submit(new CallOnMessage(rmqMessage, messageListener));
            task.get(this.onMessageTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            if (this.closeOnTimeout) {
                this.closeAbruptly();
                throw new RMQJMSException("onMessage took too long and was interrupted", null);
            }
            task.cancel(true);
            throw new DeliveryProcessingTimeoutException();
        }
        catch (ExecutionException e) {
            throw new RMQMessageListenerExecutionJMSException("onMessage threw exception", e.getCause());
        }
    }

    public void close() {
        this.closeExecutorService(this.takeExecutorService());
    }

    private void closeAbruptly() {
        this.takeExecutorService().shutdownNow();
    }

    private void closeExecutorService(ExecutorService executorService) {
        if (executorService != null) {
            executorService.shutdown();
            if (!this.waitForTerminatedExecutorService(executorService)) {
                executorService.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService takeExecutorService() {
        Object object = this.lockOnMessageExecutorService;
        synchronized (object) {
            ExecutorService es = this.onMessageExecutorService;
            this.onMessageExecutorService = null;
            return es;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService() {
        Object object = this.lockOnMessageExecutorService;
        synchronized (object) {
            if (this.onMessageExecutorService == null) {
                this.onMessageExecutorService = Executors.newSingleThreadExecutor();
            }
            return this.onMessageExecutorService;
        }
    }

    private boolean waitForTerminatedExecutorService(ExecutorService executorService) {
        try {
            return executorService.awaitTermination(this.onMessageTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    static class DeliveryProcessingTimeoutException
    extends RuntimeException {
        DeliveryProcessingTimeoutException() {
        }
    }

    private final class CallOnMessage
    implements Callable<Boolean> {
        private final RMQMessage rmqMessage;
        private final MessageListener messageListener;

        private CallOnMessage(RMQMessage rmqMessage, MessageListener messageListener) {
            this.rmqMessage = rmqMessage;
            this.messageListener = messageListener;
        }

        @Override
        public Boolean call() throws Exception {
            this.messageListener.onMessage((Message)this.rmqMessage);
            return true;
        }
    }
}

