/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import org.apache.commons.lang3.text.WordUtils;

public class TaskDefinition {
    public static final String XLRELEASE_GROUP_REPLACEMENT = "Core";
    public static final String XLRELEASE_GROUP = "xlrelease";
    public static final String XEBIALABS_GROUP = "xebialabs";
    protected String typeName;
    protected String displayGroup;
    protected String displayName;
    protected String description;
    protected String iconLocation;
    protected boolean allowed;
    protected boolean supportedInWorkflow;
    protected boolean containerTask = false;

    public TaskDefinition(Type type, boolean allowed) {
        this.typeName = type.toString();
        this.displayGroup = TaskDefinition.getDisplayGroup(type);
        this.displayName = TaskDefinition.getDisplayName(type);
        Descriptor descriptor = type.getDescriptor();
        this.description = descriptor.getDescription();
        this.allowed = allowed;
        this.supportedInWorkflow = TaskDefinition.getSupportedInWorkflow(type);
        this.iconLocation = TaskDefinition.getIconLocation(descriptor);
    }

    public static String getDisplayGroup(Type type) {
        String prefix = TaskDefinition.getPrefix(type);
        return TaskDefinition.isCore(prefix) ? XLRELEASE_GROUP_REPLACEMENT : prefix;
    }

    public static String getDisplayName(Type type) {
        String groupPrefix;
        String label = type.getDescriptor().getLabel();
        if (label.startsWith(groupPrefix = TaskDefinition.getPrefix(type) + ": ")) {
            label = label.replace(groupPrefix, "");
        }
        return label;
    }

    public static boolean getSupportedInWorkflow(Type type) {
        return (Boolean)type.getDescriptor().getPropertyDescriptor("supportedInWorkflow").getDefaultValue();
    }

    public static String getIconLocation(Descriptor descriptor) {
        PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor("iconLocation");
        if (propertyDescriptor == null) {
            return "";
        }
        if (propertyDescriptor.getDefaultValue() == null) {
            return "";
        }
        return propertyDescriptor.getDefaultValue().toString();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDisplayGroup() {
        return this.displayGroup;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconLocation() {
        return this.iconLocation;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public boolean isSupportedInWorkflow() {
        return this.supportedInWorkflow;
    }

    public boolean isContainerTaskDefinition() {
        return this.containerTask;
    }

    protected static String getPrefix(Type type) {
        if (type.getDescriptor().getLabel().contains(":")) {
            return type.getDescriptor().getLabel().split(":")[0];
        }
        if (TaskDefinition.isCore(type.getPrefix())) {
            return type.getPrefix();
        }
        return WordUtils.capitalize((String)Strings.deCamelize((String)type.getPrefix()).toLowerCase());
    }

    protected static boolean isCore(String prefix) {
        return prefix.equalsIgnoreCase(XLRELEASE_GROUP) || prefix.equalsIgnoreCase(XEBIALABS_GROUP);
    }
}

