/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentCreatedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentDeletedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.EnvironmentRepository;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001\u0002\b\u0010\u0001iA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011)\u0019!C\u0001c!A\u0001\b\u0001B\u0001B\u0003%!\u0007C\u0003:\u0001\u0011\u0005!\bC\u0003O\u0001\u0011\u0005q\nC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003o\u0001A\u0011BA\u001d\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!a\u0011\u0001\t\u0013\t)E\u0001\nF]ZL'o\u001c8nK:$8+\u001a:wS\u000e,'B\u0001\t\u0012\u0003\u001d\u0019XM\u001d<jG\u0016T!AE\n\u0002\u0019\u0015tg/\u001b:p]6,g\u000e^:\u000b\u0005Q)\u0012!\u0003=me\u0016dW-Y:f\u0015\t1r#A\u0005yK\nL\u0017\r\\1cg*\t\u0001$A\u0002d_6\u001c\u0001aE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00051\u0013\u0001C4sSjTH.\u001a3\n\u0005!\u001a#a\u0002'pO\u001eLgnZ\u0001\u0016K:4\u0018N]8o[\u0016tGOU3q_NLGo\u001c:z!\tYc&D\u0001-\u0015\ti\u0013#\u0001\u0006sKB|7/\u001b;pefL!a\f\u0017\u0003+\u0015sg/\u001b:p]6,g\u000e\u001e*fa>\u001c\u0018\u000e^8ss\u0006AQM^3oi\n+8/F\u00013!\t\u0019d'D\u00015\u0015\t)4#\u0001\u0004fm\u0016tGo]\u0005\u0003oQ\u0012\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003%)g/\u001a8u\u0005V\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0004wur\u0004C\u0001\u001f\u0001\u001b\u0005y\u0001\"B\u0015\u0005\u0001\u0004Q\u0003\"\u0002\u0019\u0005\u0001\u0004\u0011\u0004F\u0001\u0003A!\t\tE*D\u0001C\u0015\t\u0019E)\u0001\u0006b]:|G/\u0019;j_:T!!\u0012$\u0002\u000f\u0019\f7\r^8ss*\u0011q\tS\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u0013*\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0017\u0006\u0019qN]4\n\u00055\u0013%!C!vi><\u0018N]3e\u0003I\u0019X-\u0019:dQ\u0016sg/\u001b:p]6,g\u000e^:\u0015\u0005A{\u0006cA)W16\t!K\u0003\u0002T)\u0006!Q\u000f^5m\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\t1K7\u000f\u001e\t\u00033vk\u0011A\u0017\u0006\u0003%mS!\u0001X\n\u0002\r\u0011|W.Y5o\u0013\tq&LA\u0006F]ZL'o\u001c8nK:$\b\"\u00021\u0006\u0001\u0004\t\u0017AE3om&\u0014xN\\7f]R4\u0015\u000e\u001c;feN\u0004\"AY5\u000e\u0003\rT!\u0001Z3\u0002\r\u0019LG\u000e^3s\u0015\t1w-\u0001\u0002wc)\u0011\u0001nE\u0001\u0004CBL\u0017B\u00016d\u0005I)eN^5s_:lWM\u001c;GS2$XM]:)\u0005\u0015a\u0007CA7v\u001b\u0005q'BA\"p\u0015\t\u0001\u0018/\u0001\u0003d_J,'B\u0001:t\u0003)i\u0017n\u0019:p[\u0016$XM\u001d\u0006\u0002i\u0006\u0011\u0011n\\\u0005\u0003m:\u0014Q\u0001V5nK\u0012\f1CZ5oI\u0016sg/\u001b:p]6,g\u000e\u001e\"z\u0013\u0012$\"\u0001W=\t\u000bi4\u0001\u0019A>\u0002\u001b\u0015tg/\u001b:p]6,g\u000e^%e!\ra\u0018q\u0001\b\u0004{\u0006\r\u0001C\u0001@\u001e\u001b\u0005y(bAA\u00013\u00051AH]8pizJ1!!\u0002\u001e\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA\u0006\u0005\u0019\u0019FO]5oO*\u0019\u0011QA\u000f)\u0005\u0019a\u0017A\u00064j]\u0012,eN^5s_:lWM\u001c;CsRKG\u000f\\3\u0015\u0007a\u000b\u0019\u0002C\u0003{\u000f\u0001\u00071\u0010\u000b\u0002\bY\u0006\t2M]3bi\u0016,eN^5s_:lWM\u001c;\u0015\u0007a\u000bY\u0002\u0003\u0004\u0002\u001e!\u0001\r\u0001W\u0001\fK:4\u0018N]8o[\u0016tG\u000f\u000b\u0002\tY\u0006\tR\u000f\u001d3bi\u0016,eN^5s_:lWM\u001c;\u0015\u0007a\u000b)\u0003\u0003\u0004\u0002\u001e%\u0001\r\u0001\u0017\u0015\u0003\u00131\f\u0011\u0003Z3mKR,WI\u001c<je>tW.\u001a8u)\u0011\ti#a\r\u0011\u0007q\ty#C\u0002\u00022u\u0011A!\u00168ji\")!P\u0003a\u0001w\"\u0012!\u0002\\\u0001\tm\u0006d\u0017\u000eZ1uKR!\u0011QFA\u001e\u0011\u0019\tib\u0003a\u00011\u0006ia/\u00197jI\u0006$X\rV5uY\u0016$B!!\f\u0002B!1\u0011Q\u0004\u0007A\u0002a\u000b1C^1mS\u0012\fG/\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:$B!!\f\u0002H!1\u0011QD\u0007A\u0002aC3\u0001AA&!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)\u0011\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005U\u0013q\n\u0002\b'\u0016\u0014h/[2f\u0001")
public class EnvironmentService
implements Logging {
    private final EnvironmentRepository environmentRepository;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentService environmentService = this;
        synchronized (environmentService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public List<Environment> searchEnvironments(EnvironmentFilters environmentFilters) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.environmentRepository.searchEnvironments(environmentFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public Environment findEnvironmentById(String environmentId) {
        return this.environmentRepository.findEnvironmentById(environmentId);
    }

    @Timed
    public Environment findEnvironmentByTitle(String environmentId) {
        return this.environmentRepository.findEnvironmentByTitle(environmentId);
    }

    @Timed
    public Environment createEnvironment(Environment environment) {
        this.logger().debug((Function0 & Serializable)() -> "Creating a new environment");
        this.validate(environment);
        Environment created = this.environmentRepository.createEnvironment(environment);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentCreatedEvent(created));
        return created;
    }

    @Timed
    public Environment updateEnvironment(Environment environment) {
        this.logger().debug((Function0 & Serializable)() -> "Updating environment [" + environment + "]");
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environment);
        Environment updated = this.environmentRepository.updateEnvironment(environment);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentUpdatedEvent(environment));
        return updated;
    }

    @Timed
    public void deleteEnvironment(String environmentId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting environment [" + environmentId + "]");
        Environment environment = this.environmentRepository.findEnvironmentById(environmentId);
        this.environmentRepository.deleteEnvironment(environmentId);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentDeletedEvent(environment));
    }

    private void validate(Environment environment) {
        this.validateTitle(environment);
        this.validateDescription(environment);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environment.getStage()).exists((Function1 & Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)EnvironmentService.$anonfun$validate$1(stage))), (String)"Environment stage ID is required", (Object[])new Object[0]);
    }

    private void validateTitle(Environment environment) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    private void validateDescription(Environment environment) {
        if (environment.getDescription() != null) {
            Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Description cannot be blank", (Object[])new Object[0]);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(EnvironmentStage stage) {
        return StringUtils.hasText((String)stage.getId());
    }

    @Autowired
    public EnvironmentService(EnvironmentRepository environmentRepository, XLReleaseEventBus eventBus) {
        this.environmentRepository = environmentRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

