/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ddata.DurableStore;
import org.apache.pekko.cluster.ddata.DurableStore$LoadAll$;
import org.apache.pekko.cluster.ddata.DurableStore$LoadAllCompleted$;
import org.apache.pekko.cluster.ddata.LmdbDurableStore$;
import org.apache.pekko.cluster.ddata.LmdbDurableStore$WriteBehind$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$DeletedData$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.DirectByteBufferPool$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.ccompat.package;
import org.lmdbjava.CursorIterator;
import org.lmdbjava.Dbi;
import org.lmdbjava.DbiFlags;
import org.lmdbjava.Env;
import org.lmdbjava.EnvFlags;
import org.lmdbjava.PutFlags;
import org.lmdbjava.Txn;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r-s!\u0002&L\u0011\u00031f!\u0002-L\u0011\u0003I\u0006\"\u00021\u0002\t\u0003\t\u0007\"\u00022\u0002\t\u0003\u0019w!B;\u0002\u0011\u00133h!\u0002=\u0002\u0011\u0013K\bB\u00021\u0006\t\u0003\tI\u0002C\u0005\u0002\u001c\u0015\t\t\u0011\"\u0011\u0002\u001e!I\u0011qF\u0003\u0002\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003s)\u0011\u0011!C\u0001\u0003wA\u0011\"a\u0012\u0006\u0003\u0003%\t%!\u0013\t\u0013\u0005]S!!A\u0005\u0002\u0005e\u0003\"CA2\u000b\u0005\u0005I\u0011IA3\u0011%\t9'BA\u0001\n\u0003\nI\u0007C\u0005\u0002l\u0015\t\t\u0011\"\u0003\u0002n\u00191\u0011QO\u0001G\u0003oB!\"!\u001f\u0010\u0005+\u0007I\u0011AA>\u0011)\t)j\u0004B\tB\u0003%\u0011Q\u0010\u0005\u000b\u0003/{!Q3A\u0005\u0002\u0005e\u0005BCAQ\u001f\tE\t\u0015!\u0003\u0002\u001c\"Q\u00111U\b\u0003\u0016\u0004%\t!!*\t\u0015\u0005\u001dvB!E!\u0002\u0013\tI\t\u0003\u0006\u0002*>\u0011)\u001a!C\u0001\u0003KC!\"a+\u0010\u0005#\u0005\u000b\u0011BAE\u0011\u0019\u0001w\u0002\"\u0001\u0002.\"I\u0011\u0011X\b\u0002\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u000b|\u0011\u0013!C\u0001\u0003\u000fD\u0011\"!8\u0010#\u0003%\t!a8\t\u0013\u0005\rx\"%A\u0005\u0002\u0005\u0015\b\"CAu\u001fE\u0005I\u0011AAs\u0011%\tYbDA\u0001\n\u0003\ni\u0002C\u0005\u00020=\t\t\u0011\"\u0001\u00022!I\u0011\u0011H\b\u0002\u0002\u0013\u0005\u00111\u001e\u0005\n\u0003\u000fz\u0011\u0011!C!\u0003\u0013B\u0011\"a\u0016\u0010\u0003\u0003%\t!a<\t\u0013\u0005Mx\"!A\u0005B\u0005U\b\"CA2\u001f\u0005\u0005I\u0011IA3\u0011%\t9gDA\u0001\n\u0003\nI\u0007C\u0005\u0002z>\t\t\u0011\"\u0011\u0002|\u001eI\u0011q`\u0001\u0002\u0002#%!\u0011\u0001\u0004\n\u0003k\n\u0011\u0011!E\u0005\u0005\u0007Aa\u0001\u0019\u0015\u0005\u0002\tm\u0001\"CA4Q\u0005\u0005IQIA5\u0011%\u0011i\u0002KA\u0001\n\u0003\u0013y\u0002C\u0005\u0003*!\n\t\u0011\"!\u0003,!I\u00111\u000e\u0015\u0002\u0002\u0013%\u0011Q\u000e\u0004\u00061.\u0013!Q\b\u0005\tW:\u0012\t\u0011)A\u0005Y\"1\u0001M\fC\u0001\u0005\u0017B\u0011B!\u0015/\u0005\u0004%\tAa\u0015\t\u0011\t}c\u0006)A\u0005\u0005+B\u0011B!\u0019/\u0005\u0004%\tAa\u0019\t\u0011\t-d\u0006)A\u0005\u0005KB\u0011B!\u001c/\u0005\u0004%\tAa\u001c\t\u0011\t}d\u0006)A\u0005\u0005cB\u0011B!!/\u0005\u0004%\tAa!\t\u0011\tUe\u0006)A\u0005\u0005\u000bC\u0011Ba&/\u0005\u0004%\tA!'\t\u0011\t\u0005f\u0006)A\u0005\u00057C\u0011Ba)/\u0001\u0004%IA!*\t\u0013\t]f\u00061A\u0005\n\te\u0006\u0002\u0003Bb]\u0001\u0006KAa*\t\u000f\t\u0015g\u0006\"\u0003\u0003H\"9!\u0011\u001a\u0018\u0005\u0002\t-\u0007b\u0002Bg]\u0011\u0005!q\u001a\u0005\n\u0005+t#\u0019!C\u0001\u0005/D\u0001b!\u0004/A\u0003%!\u0011\u001c\u0005\b\u0007\u001fqC\u0011IB\t\u0011\u001d\u0019iB\fC!\u0007?Aqa!\t/\t\u0003\u0019\u0019\u0003C\u0004\u0004.9\"\taa\t\t\u000f\r=b\u0006\"\u0001\u0004$!91\u0011\u0007\u0018\u0005\u0002\rM\u0002bBB%]\u0011\u00051qD\u0001\u0011\u00196$'\rR;sC\ndWm\u0015;pe\u0016T!\u0001T'\u0002\u000b\u0011$\u0017\r^1\u000b\u00059{\u0015aB2mkN$XM\u001d\u0006\u0003!F\u000bQ\u0001]3lW>T!AU*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0016aA8sO\u000e\u0001\u0001CA,\u0002\u001b\u0005Y%\u0001\u0005'nI\n$UO]1cY\u0016\u001cFo\u001c:f'\t\t!\f\u0005\u0002\\=6\tALC\u0001^\u0003\u0015\u00198-\u00197b\u0013\tyFL\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u000bQ\u0001\u001d:paN$\"\u0001\u001a6\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d|\u0015!B1di>\u0014\u0018BA5g\u0005\u0015\u0001&o\u001c9t\u0011\u0015Y7\u00011\u0001m\u0003\u0019\u0019wN\u001c4jOB\u0011Qn]\u0007\u0002]*\u00111n\u001c\u0006\u0003aF\f\u0001\u0002^=qKN\fg-\u001a\u0006\u0002e\u0006\u00191m\\7\n\u0005Qt'AB\"p]\u001aLw-A\u0006Xe&$XMQ3iS:$\u0007CA<\u0006\u001b\u0005\t!aC,sSR,')\u001a5j]\u0012\u001cb!\u0002.{{\u0006\u0005\u0001CA3|\u0013\tahMA\u000bEK\u0006$G*\u001a;uKJ\u001cV\u000f\u001d9sKN\u001c\u0018n\u001c8\u0011\u0005ms\u0018BA@]\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\u0001\u0002\u00149!\u0011QAA\b\u001d\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006+\u00061AH]8pizJ\u0011!X\u0005\u0004\u0003#a\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003+\t9B\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002\u0012q#\u0012A^\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005}\u0001\u0003BA\u0011\u0003Wi!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\u0005Y\u0006twM\u0003\u0002\u0002*\u0005!!.\u0019<b\u0013\u0011\ti#a\t\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019\u0004E\u0002\\\u0003kI1!a\u000e]\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ti$a\u0011\u0011\u0007m\u000by$C\u0002\u0002Bq\u00131!\u00118z\u0011%\t)%CA\u0001\u0002\u0004\t\u0019$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0017\u0002b!!\u0014\u0002T\u0005uRBAA(\u0015\r\t\t\u0006X\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA+\u0003\u001f\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111LA1!\rY\u0016QL\u0005\u0004\u0003?b&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u000bZ\u0011\u0011!a\u0001\u0003{\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003g\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003?\tAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a\u001c\u0011\t\u0005\u0005\u0012\u0011O\u0005\u0005\u0003g\n\u0019C\u0001\u0004PE*,7\r\u001e\u0002\u0005\u00196$'mE\u0003\u00105v\f\t!A\u0002f]Z,\"!! \u0011\r\u0005}\u0014QQAE\u001b\t\t\tIC\u0002\u0002\u0004N\u000b\u0001\u0002\\7eE*\fg/Y\u0005\u0005\u0003\u000f\u000b\tIA\u0002F]Z\u0004B!a#\u0002\u00126\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b9#A\u0002oS>LA!a%\u0002\u000e\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\t\u0015tg\u000fI\u0001\u0003I\n,\"!a'\u0011\r\u0005}\u0014QTAE\u0013\u0011\ty*!!\u0003\u0007\u0011\u0013\u0017.A\u0002eE\u0002\n\u0011b[3z\u0005V4g-\u001a:\u0016\u0005\u0005%\u0015AC6fs\n+hMZ3sA\u0005Ya/\u00197vK\n+hMZ3s\u000311\u0018\r\\;f\u0005V4g-\u001a:!))\ty+!-\u00024\u0006U\u0016q\u0017\t\u0003o>Aq!!\u001f\u0019\u0001\u0004\ti\bC\u0004\u0002\u0018b\u0001\r!a'\t\u000f\u0005\r\u0006\u00041\u0001\u0002\n\"9\u0011\u0011\u0016\rA\u0002\u0005%\u0015\u0001B2paf$\"\"a,\u0002>\u0006}\u0016\u0011YAb\u0011%\tI(\u0007I\u0001\u0002\u0004\ti\bC\u0005\u0002\u0018f\u0001\n\u00111\u0001\u0002\u001c\"I\u00111U\r\u0011\u0002\u0003\u0007\u0011\u0011\u0012\u0005\n\u0003SK\u0002\u0013!a\u0001\u0003\u0013\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002J*\"\u0011QPAfW\t\ti\r\u0005\u0003\u0002P\u0006eWBAAi\u0015\u0011\t\u0019.!6\u0002\u0013Ut7\r[3dW\u0016$'bAAl9\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0017\u0011\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003CTC!a'\u0002L\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAAtU\u0011\tI)a3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iQ!\u0011QHAw\u0011%\t)\u0005IA\u0001\u0002\u0004\t\u0019\u0004\u0006\u0003\u0002\\\u0005E\b\"CA#E\u0005\u0005\t\u0019AA\u001f\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005}\u0011q\u001f\u0005\n\u0003\u000b\u001a\u0013\u0011!a\u0001\u0003g\ta!Z9vC2\u001cH\u0003BA.\u0003{D\u0011\"!\u0012'\u0003\u0003\u0005\r!!\u0010\u0002\t1kGM\u0019\t\u0003o\"\u001aR\u0001\u000bB\u0003\u0005#\u0001bBa\u0002\u0003\u000e\u0005u\u00141TAE\u0003\u0013\u000by+\u0004\u0002\u0003\n)\u0019!1\u0002/\u0002\u000fI,h\u000e^5nK&!!q\u0002B\u0005\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0005'\u0011I\"\u0004\u0002\u0003\u0016)!!qCA\u0014\u0003\tIw.\u0003\u0003\u0002\u0016\tUAC\u0001B\u0001\u0003\u0015\t\u0007\u000f\u001d7z))\tyK!\t\u0003$\t\u0015\"q\u0005\u0005\b\u0003sZ\u0003\u0019AA?\u0011\u001d\t9j\u000ba\u0001\u00037Cq!a),\u0001\u0004\tI\tC\u0004\u0002*.\u0002\r!!#\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0006B\u001d!\u0015Y&q\u0006B\u001a\u0013\r\u0011\t\u0004\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0017m\u0013)$! \u0002\u001c\u0006%\u0015\u0011R\u0005\u0004\u0005oa&A\u0002+va2,G\u0007C\u0005\u0003<1\n\t\u00111\u0001\u00020\u0006\u0019\u0001\u0010\n\u0019\u0014\r9R&q\bB#!\r)'\u0011I\u0005\u0004\u0005\u00072'!B!di>\u0014\bcA3\u0003H%\u0019!\u0011\n4\u0003\u0019\u0005\u001bGo\u001c:M_\u001e<\u0017N\\4\u0015\t\t5#q\n\t\u0003/:BQa\u001b\u0019A\u00021\fQb]3sS\u0006d\u0017N_1uS>tWC\u0001B+!\u0011\u00119Fa\u0017\u000e\u0005\te#b\u0001B)\u001f&!!Q\fB-\u00055\u0019VM]5bY&T\u0018\r^5p]\u0006q1/\u001a:jC2L'0\u0019;j_:\u0004\u0013AC:fe&\fG.\u001b>feV\u0011!Q\r\t\u0005\u0005/\u00129'\u0003\u0003\u0003j\te#\u0001H*fe&\fG.\u001b>fe^KG\u000f[*ue&tw-T1oS\u001a,7\u000f^\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b%\u0001\u0005nC:Lg-Z:u+\t\u0011\t\b\u0005\u0003\u0003t\tmd\u0002\u0002B;\u0005o\u00022!a\u0002]\u0013\r\u0011I\bX\u0001\u0007!J,G-\u001a4\n\t\u00055\"Q\u0010\u0006\u0004\u0005sb\u0016!C7b]&4Wm\u001d;!\u0003M9(/\u001b;f\u0005\u0016D\u0017N\u001c3J]R,'O^1m+\t\u0011)\t\u0005\u0003\u0003\b\nEUB\u0001BE\u0015\u0011\u0011YI!$\u0002\u0011\u0011,(/\u0019;j_:T1Aa$]\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0005'\u0013II\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002)]\u0014\u0018\u000e^3CK\"Lg\u000eZ%oi\u0016\u0014h/\u00197!\u0003\r!\u0017N]\u000b\u0003\u00057\u0003BAa\u0005\u0003\u001e&!!q\u0014B\u000b\u0005\u00111\u0015\u000e\\3\u0002\t\u0011L'\u000fI\u0001\u0006?2lGMY\u000b\u0003\u0005O\u0003bA!+\u00030\nMVB\u0001BV\u0015\r\u0011ikT\u0001\u0005kRLG.\u0003\u0003\u00032\n-&!C(qi&|gNV1m!\r\u0011)l\u0004\b\u0003/\u0002\t\u0011b\u00187nI\n|F%Z9\u0015\t\tm&\u0011\u0019\t\u00047\nu\u0016b\u0001B`9\n!QK\\5u\u0011%\t)\u0005PA\u0001\u0002\u0004\u00119+\u0001\u0004`Y6$'\rI\u0001\u0005Y6$'\r\u0006\u0002\u00034\u0006y\u0011n\u001d#c\u0013:LG/[1mSj,G-\u0006\u0002\u0002\\\u0005)RM\\:ve\u00164\u0016\r\\;f\u0005V4g-\u001a:TSj,G\u0003\u0002B^\u0005#DqAa5A\u0001\u0004\t\u0019$\u0001\u0003tSj,\u0017a\u00029f]\u0012LgnZ\u000b\u0003\u00053\u0004\u0002Ba7\u0003`\n\r(q`\u0007\u0003\u0005;TAA!,\u0002(%!!\u0011\u001dBo\u0005\u001dA\u0015m\u001d5NCB\u0004BA!:\u0003z:!!q\u001dB{\u001d\u0011\u0011IOa=\u000f\t\t-(\u0011\u001f\b\u0005\u0005[\u0014y/D\u0001R\u0013\t\u0001\u0016+\u0003\u0002O\u001f&\u0011A*T\u0005\u0004\u0005o\\\u0015aA&fs&!!1 B\u007f\u0005\u0015YU-_%e\u0015\r\u00119p\u0013\t\u0005\u0007\u0003\u00199AD\u0002X\u0007\u0007I1a!\u0002L\u00031!UO]1cY\u0016\u001cFo\u001c:f\u0013\u0011\u0019Iaa\u0003\u0003'\u0011+(/\u00192mK\u0012\u000bG/Y#om\u0016dw\u000e]3\u000b\u0007\r\u00151*\u0001\u0005qK:$\u0017N\\4!\u0003-\u0001xn\u001d;SKN$\u0018M\u001d;\u0015\t\tm61\u0003\u0005\b\u0007+\u0019\u0005\u0019AB\f\u0003\u0019\u0011X-Y:p]B!\u00111AB\r\u0013\u0011\u0019Y\"a\u0006\u0003\u0013QC'o\\<bE2,\u0017\u0001\u00039pgR\u001cFo\u001c9\u0015\u0005\tm\u0016a\u0002:fG\u0016Lg/Z\u000b\u0003\u0007K\u0001Baa\n\u0004*5\ta&\u0003\u0003\u0004,\t\u0005#a\u0002*fG\u0016Lg/Z\u0001\u0005S:LG/\u0001\u0004bGRLg/Z\u0001\u0006I\n\u0004V\u000f\u001e\u000b\t\u0005w\u001b)d!\u0011\u0004F!91q\u0007%A\u0002\re\u0012A\u0001;y!\u0019\u0011IKa,\u0004<A1\u0011qPB\u001f\u0003\u0013KAaa\u0010\u0002\u0002\n\u0019A\u000b\u001f8\t\u000f\r\r\u0003\n1\u0001\u0003d\u0006\u00191.Z=\t\u000f\r\u001d\u0003\n1\u0001\u0003\u0000\u0006!A-\u0019;b\u0003-9(/\u001b;f\u0005\u0016D\u0017N\u001c3")
public final class LmdbDurableStore
implements Actor,
ActorLogging {
    private final Config config;
    private final Serialization serialization;
    private final SerializerWithStringManifest serializer;
    private final String manifest;
    private final FiniteDuration writeBehindInterval;
    private final File dir;
    private Lmdb _lmdb;
    private final HashMap<String, DurableStore.DurableDataEnvelope> pending;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private ActorContext context;
    private ActorRef self;

    public static Props props(Config config) {
        return LmdbDurableStore$.MODULE$.props(config);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Serialization serialization() {
        return this.serialization;
    }

    public SerializerWithStringManifest serializer() {
        return this.serializer;
    }

    public String manifest() {
        return this.manifest;
    }

    public FiniteDuration writeBehindInterval() {
        return this.writeBehindInterval;
    }

    public File dir() {
        return this.dir;
    }

    private Lmdb _lmdb() {
        return this._lmdb;
    }

    private void _lmdb_$eq(Lmdb x$1) {
        this._lmdb = x$1;
    }

    public Lmdb org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb() {
        Lmdb lmdb = this._lmdb();
        Lmdb lmdb2 = (Lmdb)OptionVal.Some$.MODULE$.unapply((Object)lmdb);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)lmdb2)) {
            Lmdb l = (Lmdb)OptionVal$.MODULE$.get$extension((Object)lmdb2);
            return l;
        }
        long t0 = System.nanoTime();
        this.log().info("Using durable data in LMDB directory [{}]", (Object)this.dir().getCanonicalPath());
        Long mapSize = this.config.getBytes("lmdb.map-size");
        this.dir().mkdirs();
        Env env = Env.create().setMapSize(Predef$.MODULE$.Long2long(mapSize)).setMaxDbs(1).open(this.dir(), new EnvFlags[]{EnvFlags.MDB_NOLOCK});
        Dbi db = env.openDbi("ddata", new DbiFlags[]{DbiFlags.MDB_CREATE});
        ByteBuffer keyBuffer = ByteBuffer.allocateDirect(env.getMaxKeySize());
        ByteBuffer valueBuffer = ByteBuffer.allocateDirect(102400);
        if (this.log().isDebugEnabled()) {
            this.log().debug("Init of LMDB in directory [{}] took [{} ms]", (Object)this.dir().getCanonicalPath(), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
        }
        Lmdb l = new Lmdb((Env<ByteBuffer>)env, (Dbi<ByteBuffer>)db, keyBuffer, valueBuffer);
        this._lmdb_$eq((Lmdb)OptionVal.Some$.MODULE$.apply((Object)l));
        return l;
    }

    public boolean isDbInitialized() {
        return OptionVal$.MODULE$.isDefined$extension((Object)this._lmdb());
    }

    public void ensureValueBufferSize(int size) {
        ByteBuffer valueBuffer = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb().valueBuffer();
        if (valueBuffer.remaining() < size) {
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(valueBuffer);
            Lmdb qual$1 = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
            ByteBuffer x$1 = ByteBuffer.allocateDirect(size * 2);
            Env<ByteBuffer> x$2 = qual$1.copy$default$1();
            Dbi<ByteBuffer> x$3 = qual$1.copy$default$2();
            ByteBuffer x$4 = qual$1.copy$default$3();
            this._lmdb_$eq((Lmdb)OptionVal.Some$.MODULE$.apply((Object)qual$1.copy(x$2, x$3, x$4, x$1)));
            return;
        }
    }

    public HashMap<String, DurableStore.DurableDataEnvelope> pending() {
        return this.pending;
    }

    public void postRestart(Throwable reason) {
        Actor.postRestart$((Actor)this, (Throwable)reason);
        this.context().become(this.active());
    }

    public void postStop() {
        Actor.postStop$((Actor)this);
        this.writeBehind();
        if (this.isDbInitialized()) {
            Lmdb l = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> l.db().close());
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> l.env().close());
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(l.keyBuffer());
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(l.valueBuffer());
            return;
        }
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.init();
    }

    public PartialFunction<Object, BoxedUnit> init() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ LmdbDurableStore $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (DurableStore$LoadAll$.MODULE$.equals(A1)) {
                    if (this.$outer.dir().exists() && this.$outer.dir().list().length > 0) {
                        BoxedUnit boxedUnit;
                        Lmdb l = this.$outer.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
                        long t0 = System.nanoTime();
                        Txn tx = l.env().txnRead();
                        try {
                            try {
                                CursorIterator iter = l.db().iterate(tx);
                                try {
                                    IntRef n = IntRef.create((int)0);
                                    DurableStore.LoadData loadData = new DurableStore.LoadData((Map<String, DurableStore.DurableDataEnvelope>)package.JavaConverters$.MODULE$.IteratorHasAsScala((java.util.Iterator)iter).asScala().map((Function1 & Serializable)entry -> {
                                        ++n$1.elem;
                                        byte[] keyArray = new byte[((Buffer)entry.key()).remaining()];
                                        ((ByteBuffer)entry.key()).get(keyArray);
                                        String key = new String(keyArray, ByteString$.MODULE$.UTF_8());
                                        byte[] valArray = new byte[((Buffer)entry.val()).remaining()];
                                        ((ByteBuffer)entry.val()).get(valArray);
                                        DurableStore.DurableDataEnvelope envelope = (DurableStore.DurableDataEnvelope)$this.$outer.serializer().fromBinary(valArray, $this.$outer.manifest());
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)envelope);
                                    }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                                    if (loadData.data().nonEmpty()) {
                                        this.$outer.sender().$bang((Object)loadData, this.$outer.self());
                                    }
                                    this.$outer.sender().$bang((Object)DurableStore$LoadAllCompleted$.MODULE$, this.$outer.self());
                                    if (this.$outer.log().isDebugEnabled()) {
                                        this.$outer.log().debug("load all of [{}] entries took [{} ms]", (Object)BoxesRunTime.boxToInteger((int)n.elem), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
                                    }
                                    this.$outer.context().become(this.$outer.active());
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                finally {
                                    Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> iter.close());
                                }
                            }
                            catch (Throwable throwable) {
                                Option option;
                                Throwable throwable2 = throwable;
                                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                    Throwable e = (Throwable)option.get();
                                    throw new DurableStore.LoadFailed("failed to load durable distributed-data", e);
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> tx.close());
                        }
                        return (B1)boxedUnit;
                    }
                    this.$outer.sender().$bang((Object)DurableStore$LoadAllCompleted$.MODULE$, this.$outer.self());
                    this.$outer.context().become(this.$outer.active());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                return DurableStore$LoadAll$.MODULE$.equals(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.pekko.cluster.ddata.LmdbDurableStore$$anonfun$init$1 scala.runtime.IntRef org.lmdbjava.CursorIterator$KeyVal ), $anonfun$applyOrElse$2(org.lmdbjava.CursorIterator ), $anonfun$applyOrElse$3(org.lmdbjava.Txn )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ LmdbDurableStore $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DurableStore.Store) {
                    BoxedUnit boxedUnit;
                    DurableStore.Store store = (DurableStore.Store)A1;
                    String key = store.key();
                    DurableStore.DurableDataEnvelope data = store.data();
                    Option<DurableStore.StoreReply> reply = store.reply();
                    try {
                        Some some;
                        DurableStore.StoreReply storeReply;
                        Object object;
                        this.$outer.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
                        if (this.$outer.writeBehindInterval().length() == 0L) {
                            OptionVal$.MODULE$.None();
                            this.$outer.dbPut(null, key, data);
                            object = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit2;
                            if (this.$outer.pending().isEmpty()) {
                                Scheduler qual$1 = this.$outer.context().system().scheduler();
                                FiniteDuration x$1 = this.$outer.writeBehindInterval();
                                ActorRef x$2 = this.$outer.self();
                                LmdbDurableStore$WriteBehind$ x$3 = LmdbDurableStore$WriteBehind$.MODULE$;
                                ExecutionContextExecutor x$4 = this.$outer.context().dispatcher();
                                ActorRef x$5 = qual$1.scheduleOnce$default$5(x$1, x$2, (Object)x$3);
                                boxedUnit2 = qual$1.scheduleOnce(x$1, x$2, (Object)x$3, (ExecutionContext)x$4, x$5);
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            object = this.$outer.pending().put(key, data);
                        }
                        Option<DurableStore.StoreReply> option = reply;
                        if (option instanceof Some && (storeReply = (DurableStore.StoreReply)(some = (Some)option).value()) != null) {
                            Object successMsg = storeReply.successMsg();
                            ActorRef replyTo = storeReply.replyTo();
                            replyTo.$bang(successMsg, this.$outer.self());
                        } else if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        boxedUnit = BoxedUnit.UNIT;
                        return (B1)boxedUnit;
                    }
                    catch (Throwable throwable) {
                        Some some;
                        DurableStore.StoreReply storeReply;
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) throw throwable;
                        Throwable e = (Throwable)option.get();
                        this.$outer.log().error(e, "failed to store [{}]", (Object)key);
                        Option<DurableStore.StoreReply> option2 = reply;
                        if (option2 instanceof Some && (storeReply = (DurableStore.StoreReply)(some = (Some)option2).value()) != null) {
                            Object failureMsg = storeReply.failureMsg();
                            ActorRef replyTo = storeReply.replyTo();
                            replyTo.$bang(failureMsg, this.$outer.self());
                        } else if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return (B1)boxedUnit;
                }
                if (!LmdbDurableStore$WriteBehind$.MODULE$.equals(A1)) return (B1)function1.apply(x1);
                this.$outer.writeBehind();
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof DurableStore.Store) {
                    return true;
                }
                return LmdbDurableStore$WriteBehind$.MODULE$.equals(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void dbPut(Txn<ByteBuffer> tx, String key, DurableStore.DurableDataEnvelope data) {
        try {
            byte[] value = this.serializer().toBinary((Object)data);
            this.ensureValueBufferSize(value.length);
            Lmdb l = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
            l.keyBuffer().put(key.getBytes(ByteString$.MODULE$.UTF_8())).flip();
            l.valueBuffer().put(value).flip();
            Txn<ByteBuffer> txn = tx;
            Txn txn2 = (Txn)OptionVal.Some$.MODULE$.unapply(txn);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)txn2)) {
                Txn t = (Txn)OptionVal$.MODULE$.get$extension((Object)txn2);
                l.db().put(t, (Object)l.keyBuffer(), (Object)l.valueBuffer(), new PutFlags[0]);
            } else {
                l.db().put((Object)l.keyBuffer(), (Object)l.valueBuffer());
            }
        }
        finally {
            Lmdb l = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
            l.keyBuffer().clear();
            l.valueBuffer().clear();
        }
    }

    public void writeBehind() {
        if (!this.pending().isEmpty()) {
            block9: {
                long t0 = System.nanoTime();
                Txn tx = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb().env().txnWrite();
                try {
                    try {
                        for (Map.Entry<String, DurableStore.DurableDataEnvelope> entry : this.pending().entrySet()) {
                            this.dbPut((Txn<ByteBuffer>)((Txn)OptionVal.Some$.MODULE$.apply((Object)tx)), entry.getKey(), entry.getValue());
                        }
                        tx.commit();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("store and commit of [{}] entries took [{} ms]", (Object)BoxesRunTime.boxToInteger((int)this.pending().size()), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
                        }
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.log().error(e, "failed to store [{}]", (Object)package.JavaConverters$.MODULE$.SetHasAsScala(this.pending().keySet()).asScala().mkString(","));
                            tx.abort();
                            break block9;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.pending().clear();
                }
            }
            return;
        }
    }

    public LmdbDurableStore(Config config) {
        FiniteDuration finiteDuration;
        block5: {
            this.config = config;
            Actor.$init$((Actor)this);
            ActorLogging.$init$((ActorLogging)this);
            this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.context().system());
            this.serializer = (SerializerWithStringManifest)this.serialization().serializerFor(DurableStore.DurableDataEnvelope.class);
            this.manifest = this.serializer().manifest((Object)new DurableStore.DurableDataEnvelope(Replicator$Internal$DeletedData$.MODULE$));
            String string = config.getString("lmdb.write-behind-interval").toLowerCase();
            switch (string == null ? 0 : string.hashCode()) {
                case 109935: {
                    if (!"off".equals(string)) break;
                    finiteDuration = Duration$.MODULE$.Zero();
                    break block5;
                }
            }
            finiteDuration = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("lmdb.write-behind-interval", TimeUnit.MILLISECONDS))).millis();
        }
        this.writeBehindInterval = finiteDuration;
        String string = config.getString("lmdb.dir");
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        this.dir = string.endsWith("ddata") ? new File(new StringBuilder(3).append(string).append("-").append(this.context().system().name()).append("-").append(this.self().path().parent().name()).append("-").append(((Cluster)Cluster$.MODULE$.apply(this.context().system())).selfAddress().port().get()).toString()) : new File(string);
        OptionVal$.MODULE$.None();
        this._lmdb = null;
        this.pending = new HashMap();
        Statics.releaseFence();
    }

    private static final class Lmdb
    implements Product,
    Serializable {
        private final Env<ByteBuffer> env;
        private final Dbi<ByteBuffer> db;
        private final ByteBuffer keyBuffer;
        private final ByteBuffer valueBuffer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Env<ByteBuffer> env() {
            return this.env;
        }

        public Dbi<ByteBuffer> db() {
            return this.db;
        }

        public ByteBuffer keyBuffer() {
            return this.keyBuffer;
        }

        public ByteBuffer valueBuffer() {
            return this.valueBuffer;
        }

        public Lmdb copy(Env<ByteBuffer> env, Dbi<ByteBuffer> db, ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            return new Lmdb(env, db, keyBuffer, valueBuffer);
        }

        public Env<ByteBuffer> copy$default$1() {
            return this.env();
        }

        public Dbi<ByteBuffer> copy$default$2() {
            return this.db();
        }

        public ByteBuffer copy$default$3() {
            return this.keyBuffer();
        }

        public ByteBuffer copy$default$4() {
            return this.valueBuffer();
        }

        public String productPrefix() {
            return "Lmdb";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.env();
                }
                case 1: {
                    return this.db();
                }
                case 2: {
                    return this.keyBuffer();
                }
                case 3: {
                    return this.valueBuffer();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Lmdb;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "env";
                }
                case 1: {
                    return "db";
                }
                case 2: {
                    return "keyBuffer";
                }
                case 3: {
                    return "valueBuffer";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Lmdb)) return false;
            boolean bl = true;
            if (!bl) return false;
            Lmdb lmdb = (Lmdb)x$1;
            Env<ByteBuffer> env = this.env();
            Env<ByteBuffer> env2 = lmdb.env();
            if (env == null) {
                if (env2 != null) {
                    return false;
                }
            } else if (!env.equals(env2)) return false;
            Dbi<ByteBuffer> dbi = this.db();
            Dbi<ByteBuffer> dbi2 = lmdb.db();
            if (dbi == null) {
                if (dbi2 != null) {
                    return false;
                }
            } else if (!dbi.equals(dbi2)) return false;
            ByteBuffer byteBuffer = this.keyBuffer();
            ByteBuffer byteBuffer2 = lmdb.keyBuffer();
            if (byteBuffer == null) {
                if (byteBuffer2 != null) {
                    return false;
                }
            } else if (!((Object)byteBuffer).equals(byteBuffer2)) return false;
            ByteBuffer byteBuffer3 = this.valueBuffer();
            ByteBuffer byteBuffer4 = lmdb.valueBuffer();
            if (byteBuffer3 == null) {
                if (byteBuffer4 == null) return true;
                return false;
            } else {
                if (!((Object)byteBuffer3).equals(byteBuffer4)) return false;
                return true;
            }
        }

        public Lmdb(Env<ByteBuffer> env, Dbi<ByteBuffer> db, ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            this.env = env;
            this.db = db;
            this.keyBuffer = keyBuffer;
            this.valueBuffer = valueBuffer;
            Product.$init$((Product)this);
        }
    }
}

