import { SagaIterator } from 'redux-saga';
import { all, call, put, takeEvery } from 'redux-saga/effects';
import { applicationWizardSagas, testConnectionSaga } from './application-wizard.saga';
import { externalApplicationWizard } from './application-wizard.reducer';
import { mockServerCi } from '../__mocks__/discovery-wizard.mocks';
import { httpPOST } from '../../../../../../../../../core/xlr-ui/app/features/common/services/http';

const { setConnectionTested, setTestConnectionStatus, testConnection } = externalApplicationWizard.actions;

describe('applicationWizardSagas', () => {
    it('should yield all effects', () => {
        const gen: SagaIterator = applicationWizardSagas();
        expect(gen.next().value).toStrictEqual(all([takeEvery(testConnection, testConnectionSaga)]));
        expect(gen.next().done).toBe(true);
    });

    describe('testConnectionSaga', () => {
        it('should yield all effects', () => {
            const success = true;
            const errorText = '';
            const data = { errorText, success };
            const gen = testConnectionSaga({ payload: mockServerCi, type: 'whatever' });
            expect(gen.next().value).toStrictEqual(call(httpPOST, `configurations/status`, mockServerCi));
            expect(gen.next({ data }).value).toStrictEqual(put(setTestConnectionStatus({ success, errorText })));
            expect(gen.next().value).toStrictEqual(put(setConnectionTested(true)));
            expect(gen.next().done).toBeTruthy();
        });
    });
});
