#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from vault import VaultClient

logger.info("=== CHECK CONNECTION ==========================================")
vault_client = VaultClient(url=configuration['url'], token=configuration['token'], username=configuration['username'],
                           password=configuration['password'], namespace=configuration['namespace'],
                           authenticationMethod=configuration['authenticationMethod'], role_id=configuration['role_id'], secret_id=configuration['secret_id'], logger=logger)

if configuration['namespace'] is not None and len(configuration['namespace']) > 0:
    print("Namespace Provided so Vault Initialization Check is Skipped")
else:
    if vault_client.is_initialized():
        logger.info(">> Vault is initialized")
    else:
        VaultClient.exit(VaultClient.VAULT_NOT_INITIALIZED,
                         "Your Vault Server at {} is not initialized".format(configuration.url),authenticationType=str(configuration['authenticationMethod']))

if vault_client.is_authenticated():
    logger.info(">> Your token or Username/Password/role_id is authenticated")
else:
    exit("Vault Server is not authenticated, Please Check Credentials")

if configuration['authenticationMethod'] == "Basic" or configuration['authenticationMethod'] == "LDAP" or configuration['authenticationMethod'] == "Approle":
    vault_client.revokeUserPassToken()
