/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.StringTokenizer;

public final class CellConstraints
implements Cloneable,
Serializable {
    public static final Alignment DEFAULT = new Alignment("default", 2);
    public static final Alignment FILL = new Alignment("fill", 2);
    public static final Alignment LEFT = new Alignment("left", 0);
    public static final Alignment RIGHT = new Alignment("right", 0);
    public static final Alignment CENTER = new Alignment("center", 2);
    public static final Alignment TOP = new Alignment("top", 1);
    public static final Alignment BOTTOM = new Alignment("bottom", 1);
    private static final Alignment[] VALUES = new Alignment[]{DEFAULT, FILL, LEFT, RIGHT, CENTER, TOP, BOTTOM};
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    public int gridX;
    public int gridY;
    public int gridWidth;
    public int gridHeight;
    public Alignment hAlign;
    public Alignment vAlign;
    public Insets insets;

    public CellConstraints() {
        this(1, 1);
    }

    public CellConstraints(int n, int n2) {
        this(n, n2, 1, 1);
    }

    public CellConstraints(int n, int n2, Alignment alignment, Alignment alignment2) {
        this(n, n2, 1, 1, alignment, alignment2, EMPTY_INSETS);
    }

    public CellConstraints(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, DEFAULT, DEFAULT);
    }

    public CellConstraints(int n, int n2, int n3, int n4, Alignment alignment, Alignment alignment2) {
        this(n, n2, n3, n4, alignment, alignment2, EMPTY_INSETS);
    }

    public CellConstraints(int n, int n2, int n3, int n4, Alignment alignment, Alignment alignment2, Insets insets) {
        this.gridX = n;
        this.gridY = n2;
        this.gridWidth = n3;
        this.gridHeight = n4;
        this.hAlign = alignment;
        this.vAlign = alignment2;
        this.insets = insets;
        if (n <= 0) {
            throw new IndexOutOfBoundsException("The grid x must be a positive number.");
        }
        if (n2 <= 0) {
            throw new IndexOutOfBoundsException("The grid y must be a positive number.");
        }
        if (n3 <= 0) {
            throw new IndexOutOfBoundsException("The grid width must be a positive number.");
        }
        if (n4 <= 0) {
            throw new IndexOutOfBoundsException("The grid height must be a positive number.");
        }
        if (alignment == null) {
            throw new NullPointerException("The horizontal alignment must not be null.");
        }
        if (alignment2 == null) {
            throw new NullPointerException("The vertical alignment must not be null.");
        }
        this.ensureValidOrientations(alignment, alignment2);
    }

    public CellConstraints(String string) {
        this();
        this.initFromConstraints(string);
    }

    public CellConstraints xy(int n, int n2) {
        return this.xywh(n, n2, 1, 1);
    }

    public CellConstraints xy(int n, int n2, String string) {
        return this.xywh(n, n2, 1, 1, string);
    }

    public CellConstraints xy(int n, int n2, Alignment alignment, Alignment alignment2) {
        return this.xywh(n, n2, 1, 1, alignment, alignment2);
    }

    public CellConstraints xyw(int n, int n2, int n3) {
        return this.xywh(n, n2, n3, 1, DEFAULT, DEFAULT);
    }

    public CellConstraints xyw(int n, int n2, int n3, String string) {
        return this.xywh(n, n2, n3, 1, string);
    }

    public CellConstraints xyw(int n, int n2, int n3, Alignment alignment, Alignment alignment2) {
        return this.xywh(n, n2, n3, 1, alignment, alignment2);
    }

    public CellConstraints xywh(int n, int n2, int n3, int n4) {
        return this.xywh(n, n2, n3, n4, DEFAULT, DEFAULT);
    }

    public CellConstraints xywh(int n, int n2, int n3, int n4, String string) {
        CellConstraints cellConstraints = this.xywh(n, n2, n3, n4);
        cellConstraints.setAlignments(string);
        return cellConstraints;
    }

    public CellConstraints xywh(int n, int n2, int n3, int n4, Alignment alignment, Alignment alignment2) {
        this.gridX = n;
        this.gridY = n2;
        this.gridWidth = n3;
        this.gridHeight = n4;
        this.hAlign = alignment;
        this.vAlign = alignment2;
        this.ensureValidOrientations(this.hAlign, this.vAlign);
        return this;
    }

    private void initFromConstraints(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        int n = stringTokenizer.countTokens();
        if (n != 2 && n != 4 && n != 6) {
            throw new IllegalArgumentException("You must provide 2, 4 or 6 arguments.");
        }
        Integer n2 = this.decodeInt(stringTokenizer.nextToken());
        if (n2 == null) {
            throw new IllegalArgumentException("First cell constraint element must be a number.");
        }
        this.gridX = n2;
        if (this.gridX <= 0) {
            throw new IndexOutOfBoundsException("The grid x must be a positive number.");
        }
        n2 = this.decodeInt(stringTokenizer.nextToken());
        if (n2 == null) {
            throw new IllegalArgumentException("Second cell constraint element must be a number.");
        }
        this.gridY = n2;
        if (this.gridY <= 0) {
            throw new IndexOutOfBoundsException("The grid y must be a positive number.");
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        n2 = this.decodeInt(string2);
        if (n2 != null) {
            this.gridWidth = n2;
            if (this.gridWidth <= 0) {
                throw new IndexOutOfBoundsException("The grid width must be a positive number.");
            }
            n2 = this.decodeInt(stringTokenizer.nextToken());
            if (n2 == null) {
                throw new IllegalArgumentException("Fourth cell constraint element must be like third.");
            }
            this.gridHeight = n2;
            if (this.gridHeight <= 0) {
                throw new IndexOutOfBoundsException("The grid height must be a positive number.");
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            string2 = stringTokenizer.nextToken();
        }
        this.hAlign = this.decodeAlignment(string2);
        this.vAlign = this.decodeAlignment(stringTokenizer.nextToken());
        this.ensureValidOrientations(this.hAlign, this.vAlign);
    }

    private void setAlignments(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        this.hAlign = this.decodeAlignment(stringTokenizer.nextToken());
        this.vAlign = this.decodeAlignment(stringTokenizer.nextToken());
        this.ensureValidOrientations(this.hAlign, this.vAlign);
    }

    private Integer decodeInt(String string) {
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Alignment decodeAlignment(String string) {
        return Alignment.valueOf(string);
    }

    void ensureValidGridBounds(int n, int n2) {
        if (this.gridX <= 0) {
            throw new IndexOutOfBoundsException("The column index " + this.gridX + " must be positive.");
        }
        if (this.gridX > n) {
            throw new IndexOutOfBoundsException("The column index " + this.gridX + " must be less than or equal to " + n + ".");
        }
        if (this.gridX + this.gridWidth - 1 > n) {
            throw new IndexOutOfBoundsException("The grid width " + this.gridWidth + " must be less than or equal to " + (n - this.gridX + 1) + ".");
        }
        if (this.gridY <= 0) {
            throw new IndexOutOfBoundsException("The row index " + this.gridY + " must be positive.");
        }
        if (this.gridY > n2) {
            throw new IndexOutOfBoundsException("The row index " + this.gridY + " must be less than or equal to " + n2 + ".");
        }
        if (this.gridY + this.gridHeight - 1 > n2) {
            throw new IndexOutOfBoundsException("The grid height " + this.gridHeight + " must be less than or equal to " + (n2 - this.gridY + 1) + ".");
        }
    }

    private void ensureValidOrientations(Alignment alignment, Alignment alignment2) {
        if (!alignment.isHorizontal()) {
            throw new IllegalArgumentException("The horizontal alignment must be one of: left, center, right, fill, default.");
        }
        if (!alignment2.isVertical()) {
            throw new IllegalArgumentException("The vertical alignment must be one of: top, center, botto, fill, default.");
        }
    }

    void setBounds(Component component, FormLayout formLayout, Rectangle rectangle, FormLayout.Measure measure, FormLayout.Measure measure2, FormLayout.Measure measure3, FormLayout.Measure measure4) {
        ColumnSpec columnSpec = this.gridWidth == 1 ? formLayout.getColumnSpec(this.gridX) : null;
        RowSpec rowSpec = this.gridHeight == 1 ? formLayout.getRowSpec(this.gridY) : null;
        Alignment alignment = this.concreteAlignment(this.hAlign, columnSpec);
        Alignment alignment2 = this.concreteAlignment(this.vAlign, rowSpec);
        Insets insets = this.insets != null ? this.insets : EMPTY_INSETS;
        int n = rectangle.x + insets.left;
        int n2 = rectangle.y + insets.top;
        int n3 = rectangle.width - insets.left - insets.right;
        int n4 = rectangle.height - insets.top - insets.bottom;
        int n5 = this.componentSize(component, columnSpec, n3, measure, measure3);
        int n6 = this.componentSize(component, rowSpec, n4, measure2, measure4);
        int n7 = this.origin(alignment, n, n3, n5);
        int n8 = this.origin(alignment2, n2, n4, n6);
        int n9 = this.extent(alignment, n3, n5);
        int n10 = this.extent(alignment2, n4, n6);
        component.setBounds(n7, n8, n9, n10);
    }

    private Alignment concreteAlignment(Alignment alignment, FormSpec formSpec) {
        return formSpec == null ? (alignment == DEFAULT ? FILL : alignment) : this.usedAlignment(alignment, formSpec);
    }

    private Alignment usedAlignment(Alignment alignment, FormSpec formSpec) {
        if (alignment != DEFAULT) {
            return alignment;
        }
        FormSpec.DefaultAlignment defaultAlignment = formSpec.getDefaultAlignment();
        if (defaultAlignment == FormSpec.FILL_ALIGN) {
            return FILL;
        }
        if (defaultAlignment == ColumnSpec.LEFT) {
            return LEFT;
        }
        if (defaultAlignment == FormSpec.CENTER_ALIGN) {
            return CENTER;
        }
        if (defaultAlignment == ColumnSpec.RIGHT) {
            return RIGHT;
        }
        if (defaultAlignment == RowSpec.TOP) {
            return TOP;
        }
        return BOTTOM;
    }

    private int componentSize(Component component, FormSpec formSpec, int n, FormLayout.Measure measure, FormLayout.Measure measure2) {
        if (formSpec == null) {
            return measure2.sizeOf(component);
        }
        if (formSpec.getSize() == Sizes.MINIMUM) {
            return measure.sizeOf(component);
        }
        if (formSpec.getSize() == Sizes.PREFERRED) {
            return measure2.sizeOf(component);
        }
        return Math.min(n, measure2.sizeOf(component));
    }

    private int origin(Alignment alignment, int n, int n2, int n3) {
        if (alignment == RIGHT || alignment == BOTTOM) {
            return n + n2 - n3;
        }
        if (alignment == CENTER) {
            return n + (n2 - n3) / 2;
        }
        return n;
    }

    private int extent(Alignment alignment, int n, int n2) {
        return alignment == FILL ? n : n2;
    }

    public Object clone() {
        try {
            CellConstraints cellConstraints = (CellConstraints)super.clone();
            cellConstraints.insets = (Insets)this.insets.clone();
            return cellConstraints;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CellConstraints");
        stringBuffer.append("[x=");
        stringBuffer.append(this.gridX);
        stringBuffer.append("; y=");
        stringBuffer.append(this.gridY);
        stringBuffer.append("; w=");
        stringBuffer.append(this.gridWidth);
        stringBuffer.append("; h=");
        stringBuffer.append(this.gridHeight);
        stringBuffer.append("; hAlign=");
        stringBuffer.append(this.hAlign);
        stringBuffer.append("; vAlign=");
        stringBuffer.append(this.vAlign);
        if (!EMPTY_INSETS.equals(this.insets)) {
            stringBuffer.append("; insets=");
            stringBuffer.append(this.insets);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String toShortString() {
        return this.toShortString(null);
    }

    public String toShortString(FormLayout formLayout) {
        ColumnSpec columnSpec;
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.formatInt(this.gridX));
        stringBuffer.append(", ");
        stringBuffer.append(this.formatInt(this.gridY));
        stringBuffer.append(", ");
        stringBuffer.append(this.formatInt(this.gridWidth));
        stringBuffer.append(", ");
        stringBuffer.append(this.formatInt(this.gridHeight));
        stringBuffer.append(", \"");
        stringBuffer.append(this.hAlign.abbreviation());
        if (this.hAlign == DEFAULT && formLayout != null) {
            stringBuffer.append('=');
            columnSpec = this.gridWidth == 1 ? formLayout.getColumnSpec(this.gridX) : null;
            stringBuffer.append(this.concreteAlignment(this.hAlign, columnSpec).abbreviation());
        }
        stringBuffer.append(", ");
        stringBuffer.append(this.vAlign.abbreviation());
        if (this.vAlign == DEFAULT && formLayout != null) {
            stringBuffer.append('=');
            columnSpec = this.gridHeight == 1 ? formLayout.getRowSpec(this.gridY) : null;
            stringBuffer.append(this.concreteAlignment(this.vAlign, columnSpec).abbreviation());
        }
        stringBuffer.append("\"");
        if (!EMPTY_INSETS.equals(this.insets)) {
            stringBuffer.append(", ");
            stringBuffer.append(this.insets);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private String formatInt(int n) {
        String string = Integer.toString(n);
        return n < 10 ? " " + string : string;
    }

    public static final class Alignment
    implements Serializable {
        private static final int HORIZONTAL = 0;
        private static final int VERTICAL = 1;
        private static final int BOTH = 2;
        private final transient String name;
        private final transient int orientation;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private Alignment(String string, int n) {
            this.name = string;
            this.orientation = n;
        }

        static Alignment valueOf(String string) {
            String string2 = string.toLowerCase();
            if (string2.equals("d") || string2.equals("default")) {
                return DEFAULT;
            }
            if (string2.equals("f") || string2.equals("fill")) {
                return FILL;
            }
            if (string2.equals("c") || string2.equals("center")) {
                return CENTER;
            }
            if (string2.equals("l") || string2.equals("left")) {
                return LEFT;
            }
            if (string2.equals("r") || string2.equals("right")) {
                return RIGHT;
            }
            if (string2.equals("t") || string2.equals("top")) {
                return TOP;
            }
            if (string2.equals("b") || string2.equals("bottom")) {
                return BOTTOM;
            }
            throw new IllegalArgumentException("Invalid alignment " + string + ". Must be one of: left, center, right, top, bottom, " + "fill, default, l, c, r, t, b, f, d.");
        }

        public String toString() {
            return this.name;
        }

        public char abbreviation() {
            return this.name.charAt(0);
        }

        private boolean isHorizontal() {
            return this.orientation != 1;
        }

        private boolean isVertical() {
            return this.orientation != 0;
        }

        private Object readResolve() {
            return VALUES[this.ordinal];
        }
    }
}

