import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { mountWithStoreAndTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';
import { TemplateTileComponent, TemplateTileProps } from './template-tile.component';
import { ActiveTemplateTile } from './active-template-tile.component';
import { ActiveTileSkeleton } from '../../CommonCardTile/active-tile.skeleton';
import * as angularAccessor from '../../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import { VariablesInterpolatorFactory } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/types/angular';
import { initialState as templateTileInitialState } from './ducks/template-tile.reducer';

describe('TemplateTileComponent', () => {
    const getAngularServiceSpy = jest.spyOn(angularAccessor, 'default') as unknown as jest.SpyInstance<VariablesInterpolatorFactory, [name: unknown]>;

    const dispatch = jest.fn();

    const title = 'Templates';
    const description = 'Test template description';

    const defaultProps: TemplateTileProps = {
        title,
        description,
    };

    const defaultState = {
        templateTile: { ...templateTileInitialState, isLoading: false },
    };

    const mount = (props: TemplateTileProps = defaultProps, state = defaultState) => {
        return mountWithStoreAndTheme(<TemplateTileComponent {...props} />, dispatch, state);
    };

    const getCommonCardTileComponent = (wrapper: ReactWrapper) => wrapper.find(CommonCardTileComponent);
    const getFirstButton = (wrapper: ReactWrapper) => wrapper.find(DotButton).at(0);
    const getSecondButton = (wrapper: ReactWrapper) => wrapper.find(DotButton).at(1);
    const getActiveTemplateTile = (wrapper: ReactWrapper) => wrapper.find(ActiveTemplateTile);
    const getActiveTileSkeleton = (wrapper: ReactWrapper) => wrapper.find(ActiveTileSkeleton);

    beforeEach(() => {
        getAngularServiceSpy.mockReturnValue({
            interpolateInText: jest.fn().mockReturnValue(''),
        });
    });

    it('should render with correct props', () => {
        const wrapper = mount();
        const props = getCommonCardTileComponent(wrapper).props();
        expect(props.title).toBe(title);
        expect(props.description).toBe(description);
        expect(props.imageLink).toBe('static/23.3.4/styles/img/timeline_monochromatic.svg');
        expect(props.primaryButton.buttonCaption).toBe('View templates');
        expect(props.primaryButton.buttonType).toBe('text');
        expect(props.secondaryButton?.buttonCaption).toBe('Create template');
        expect(props.secondaryButton?.buttonType).toBe('outlined');
        expect(getActiveTemplateTile(wrapper)).not.toExist();
        expect(getActiveTileSkeleton(wrapper)).not.toExist();
    });

    it('should handle click event', () => {
        const wrapper = mount();
        const firstButton = getFirstButton(wrapper);
        firstButton.invoke('onClick')?.('' as never);
        expect(window.location.href).toStrictEqual(`http://localhost/#/templates`);
        const secondButton = getSecondButton(wrapper);
        secondButton.invoke('onClick')?.('' as never);
        expect(window.location.href).toStrictEqual(`http://localhost/#/templates/create?fromHome=true`);
    });

    it('should show active tile skeleton if loading', () => {
        const wrapper = mount(defaultProps, { ...defaultState, templateTile: { ...templateTileInitialState, isLoading: true } });
        expect(getActiveTileSkeleton(wrapper)).toExist();
    });
});
