/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import com.atlassian.crowd.embedded.api.ConnectionPoolProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.math.NumberUtils;

public class DefaultConnectionPoolProperties
implements ConnectionPoolProperties {
    private String initialSize = "1";
    private String preferredSize = "10";
    private String maximumSize = "0";
    private String timeoutInSec = Long.toString(TimeUnit.SECONDS.convert(NumberUtils.toLong((String)"30000"), TimeUnit.MILLISECONDS));
    private String supportedProtocol = "plain ssl";
    private String supportedAuthentication = "simple";

    @Override
    public String getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(String initialSize) {
        this.initialSize = initialSize;
    }

    @Override
    public String getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(String maximumSize) {
        this.maximumSize = maximumSize;
    }

    @Override
    public String getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(String preferredSize) {
        this.preferredSize = preferredSize;
    }

    @Override
    public String getTimeoutInSec() {
        return this.timeoutInSec;
    }

    public void setTimeoutInSec(String timeoutInSec) {
        this.timeoutInSec = timeoutInSec;
    }

    @Override
    public String getSupportedAuthentication() {
        return this.supportedAuthentication;
    }

    public void setSupportedAuthentication(String supportedAuthentication) {
        this.supportedAuthentication = supportedAuthentication;
    }

    @Override
    public String getSupportedProtocol() {
        return this.supportedProtocol;
    }

    public void setSupportedProtocol(String supportedProtocol) {
        this.supportedProtocol = supportedProtocol;
    }

    @Override
    public Map<String, String> toPropertiesMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("com.sun.jndi.ldap.connect.pool.initsize", this.getInitialSize());
        map.put("com.sun.jndi.ldap.connect.pool.maxsize", this.getMaximumSize());
        map.put("com.sun.jndi.ldap.connect.pool.prefsize", this.getPreferredSize());
        map.put("com.sun.jndi.ldap.connect.pool.timeout", Long.toString(TimeUnit.MILLISECONDS.convert(NumberUtils.toLong((String)this.getTimeoutInSec()), TimeUnit.SECONDS)));
        map.put("com.sun.jndi.ldap.connect.pool.protocol", this.getSupportedProtocol());
        map.put("com.sun.jndi.ldap.connect.pool.authentication", this.getSupportedAuthentication());
        return map;
    }

    public static ConnectionPoolProperties fromPropertiesMap(Map<String, String> map) {
        DefaultConnectionPoolProperties poolProperties = new DefaultConnectionPoolProperties();
        poolProperties.setInitialSize(map.get("com.sun.jndi.ldap.connect.pool.initsize"));
        poolProperties.setMaximumSize(map.get("com.sun.jndi.ldap.connect.pool.maxsize"));
        poolProperties.setPreferredSize(map.get("com.sun.jndi.ldap.connect.pool.prefsize"));
        poolProperties.setTimeoutInSec(Long.toString(TimeUnit.SECONDS.convert(NumberUtils.toLong((String)map.get("com.sun.jndi.ldap.connect.pool.timeout")), TimeUnit.MILLISECONDS)));
        poolProperties.setSupportedProtocol(map.get("com.sun.jndi.ldap.connect.pool.protocol"));
        poolProperties.setSupportedAuthentication(map.get("com.sun.jndi.ldap.connect.pool.authentication"));
        return poolProperties;
    }
}

