/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.vault;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class HttpRequestHelper {
    private HttpClient httpClient;
    private String proxies;
    String proxyHost;
    int proxyPort;
    String proxyUser;
    String proxyPassword;
    private int statusCode;

    public HttpRequestHelper(String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.httpClient = this.getHttpClient();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public Map<String, String> executeRequest(String url, String method, String jsonHeaders, String body, String filePath) throws IOException, InterruptedException {
        HttpRequest.Builder requestBuilder = HttpRequestHelper.getHttpRequest(url, method, body, filePath);
        HashMap<String, String> headersMap = null;
        HashMap<String, String> responseObj = new HashMap<String, String>();
        if (jsonHeaders != null && (headersMap = HttpRequestHelper.getHashMap(jsonHeaders)) != null && headersMap.size() > 0) {
            for (Map.Entry<String, String> entry : headersMap.entrySet()) {
                requestBuilder.setHeader(entry.getKey(), entry.getValue());
            }
        }
        String responseString = "";
        try {
            HttpResponse<String> response = this.httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
            HttpHeaders headers = response.headers();
            responseObj.put("headers", headers.toString());
            responseObj.put("statusCode", Integer.toString(response.statusCode()));
            responseString = response.body();
            responseObj.put("response", responseString);
        }
        catch (Exception e) {
            System.out.println("ERROR");
            System.out.println(e.getMessage());
            System.out.println(e.getCause());
            System.out.println("---------");
        }
        return responseObj;
    }

    public HttpClient getHttpClient() {
        HttpClient.Builder httpBuilder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(60L));
        if (this.proxyHost != null && this.proxyPort >= 0) {
            Authenticator authenticator = null;
            if (this.proxyUser != null && this.proxyPassword != null) {
                authenticator = new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(HttpRequestHelper.this.proxyUser, HttpRequestHelper.this.proxyPassword.toCharArray());
                    }
                };
                httpBuilder.authenticator(authenticator);
            }
            httpBuilder.proxy(ProxySelector.of(new InetSocketAddress(this.proxyHost, this.proxyPort)));
        }
        return httpBuilder.build();
    }

    public static HttpRequest.Builder getHttpRequest(String url, String method, String req_body, String filepath) throws FileNotFoundException {
        HttpRequest.Builder requestBuilder = null;
        Object file = null;
        switch (method.toUpperCase()) {
            case "GET": {
                requestBuilder = HttpRequest.newBuilder().GET();
                break;
            }
            case "LIST": {
                requestBuilder = HttpRequest.newBuilder().uri(URI.create(url)).method("LIST", HttpRequest.BodyPublishers.noBody()).header("Content-Type", "application/json");
                break;
            }
            case "POST": {
                if (req_body != null) {
                    requestBuilder = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(req_body));
                    break;
                }
                if (filepath != null) {
                    FileInputStream inputStream = new FileInputStream(Paths.get(filepath, new String[0]).toString());
                    BufferedInputStream buf_ins = new BufferedInputStream(inputStream);
                    Supplier<BufferedInputStream> streamSupplier = () -> buf_ins;
                    requestBuilder = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofInputStream(streamSupplier));
                    requestBuilder.setHeader("Content-Type", "application/octet-stream");
                    break;
                }
            }
            case "PATCH": {
                if (req_body != null) {
                    requestBuilder = HttpRequest.newBuilder().uri(URI.create(url)).method("PATCH", HttpRequest.BodyPublishers.ofString(req_body)).header("Content-Type", "application/json");
                    break;
                }
            }
            case "PUT": {
                if (req_body != null) {
                    requestBuilder = HttpRequest.newBuilder().PUT(HttpRequest.BodyPublishers.ofString(req_body));
                    break;
                }
                if (filepath != null) {
                    FileInputStream inputStream = new FileInputStream(Paths.get(filepath, new String[0]).toString());
                    BufferedInputStream buf_ins = new BufferedInputStream(inputStream);
                    Supplier<BufferedInputStream> streamSupplier = () -> buf_ins;
                    requestBuilder = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofInputStream(streamSupplier));
                    requestBuilder.setHeader("Content-Type", "application/octet-stream");
                    break;
                }
            }
            case "DELETE": {
                requestBuilder = HttpRequest.newBuilder().DELETE();
            }
        }
        requestBuilder.uri(URI.create(url));
        return requestBuilder;
    }

    public static String getBasicAuthenticationHeader(String username, String password) {
        String valueToEncode = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(valueToEncode.getBytes());
    }

    private static HashMap<String, String> getHashMap(String jsonString) throws JsonProcessingException {
        if (jsonString != null && jsonString.length() > 0) {
            HashMap mapping = (HashMap)new ObjectMapper().readValue(jsonString, HashMap.class);
            return mapping;
        }
        return null;
    }
}

