#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import logging
import re

from vault import VaultClient

logger = logging.getLogger("Vault")
print("VAULT V1: Executing %s" % task.getTaskType())
vault_client = VaultClient(url=vaultServer['url'], token=vaultServer['token'], username=vaultServer['username'],
                           password=vaultServer['password'], namespace=vaultServer['namespace'],
                           authenticationMethod=vaultServer['authenticationMethod'], role_id=vaultServer['role_id'], secret_id=vaultServer['secret_id'], logger=logger)
# Use the name of the type in multiple places.
mytype = str(task.getTaskType())
print("=== VAULT SECRET V1 : {} ===".format(mytype))

def getMaskedValue(value):
    return re.sub(r'.*', '*******', value)

if vaultServer['namespace'] is not None and len(vaultServer['namespace']) > 0:
    print("Namespace Provided so Vault Initialization Check is Skipped")
elif vault_client.is_initialized():
    print("Vault Initialized:{}".format(vaultServer['url']))
else:
    vault_client.exit(vault_client.VAULT_NOT_INITIALIZED,
                      "Your Vault Server at {} is not initialized".format(vaultServer['url']), authenticationType=str(vaultServer['authenticationMethod']))

if vault_client.is_sealed():
    vault_client.exit(vault_client.VAULT_SERVER_SEALED, "Vault Server {} is Sealed".format(vaultServer['url']), authenticationType=str(vaultServer['authenticationMethod']))

if vaultServer['authenticationMethod'] == "PAT":
    if vaultServer['token'] is None:
        vault_client.exit(vault_client.VAULT_NO_TOKEN, "You must use a token in Vault for Token Authentication", authenticationType=str(vaultServer['authenticationMethod']))
if vaultServer['authenticationMethod'] == "Basic" or vaultServer['authenticationMethod'] == "LDAP":
    if vaultServer['username'] is None:
        vault_client.exit(vault_client.VAULT_NO_TOKEN,
                          "You must use username/password in Vault for Basic/LDAP Authentication", authenticationType=str(vaultServer['authenticationMethod']))
if vaultServer['authenticationMethod'] == "Approle":
    if vaultServer['role_id'] is None:
        vault_client.exit(vault_client.VAULT_NO_TOKEN,
                          "You must use RoleId/SecretId in Vault for Approle Authentication", authenticationType=str(vaultServer['authenticationMethod']))

if mytype == 'vault.SecretsV1-ReadSecret':
    key_path = path + '/' + key
    readSecretPath = 'v1/'+ mount_point + '/' + path
    print("Reading from {}".format(key_path))
    read_response = vault_client.read_secret(path=readSecretPath)
    value = read_response['data'][key]
    print(">> Read Secret Request complete for {}/{}/{} - {}".format(mount_point, path, key, getMaskedValue(value)))
    if key.encode('ascii', 'ignore') not in read_response['data']:
        print("Key {} not found in path  ", key_path)
    print("===============================================================")

elif mytype == 'vault.SecretsV1-ReadDynamicSecret':
    print("ReadDynamic Not Implemented")

elif mytype == 'vault.SecretsV1-CreateSecret':
    masked_secret = {key: getMaskedValue(value)}
    print(">> Writing {} to {}".format(masked_secret, path))
    createSecretPath = 'v1/'+ mount_point + '/' + path
    new_secret = {key: value}
    vault_client.create_secret(path=createSecretPath,secret=new_secret)
    print(">> Write Request complete for {} : {}".format(path, new_secret))
    print("===============================================================")

elif mytype == 'vault.SecretsV1-DeleteSecret':
    deleteSecretPath = 'v1/'+ mount_point + '/' + path
    vault_client.delete_secret(path=deleteSecretPath)
    print(">> Delete Request complete for {}/{}".format(mount_point, path))
    print("===============================================================")

elif mytype == 'vault.SecretsV1-EnableEngine':
    ErrorString = ""
    if backend_type == None or backend_type == "":
        ErrorString += "backend_type"
    if mount_point == None or mount_point == "":
        ErrorString += " mount_point"
    if ErrorString != "" or len(ErrorString) > 0:
        exit("VAULT Error - Please check these Fields :" + ErrorString)
    else:
        payload = {
            'type': backend_type,
            'config': data,
            'description': engine_description,
            'local': auth_local
        }
        enableEnginePath = 'v1/sys/mounts/'+ mount_point
        vault_client.enable_engine(enableEnginePath,payload)
    print("New " + mount_point + " Engine Enabled - V1")

elif mytype == "vault.SecretsV1-ListSecrets":
    listSecretPath = 'v1/' + mount_point
    try:
        response = vault_client.list_secrets(listSecretPath)
        print('The following secrets are available under {} prefix: {keys}'.format(mount_point, keys=', '.join(response['data']['keys'])))
    except Exception as e:
        print('Error Retrieving Secrets List for Mount point {}, Please try with KV Version 1 Type Mount Point '.format(mount_point))

else:
    print("Not Implemented {}".format(mytype))

if vaultServer['authenticationMethod'] == "Basic" or vaultServer['authenticationMethod'] == "LDAP" or vaultServer['authenticationMethod'] == "Approle":
    vault_client.revokeUserPassToken()
