/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.templates;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseRestoredEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.DependencyTargetResolver;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException$;
import com.xebialabs.xlrelease.versioning.templates.ReleaseVersioningSerialization;
import com.xebialabs.xlrelease.versioning.templates.TemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.domain.events.RevisionDeletedEvent;
import com.xebialabs.xlrelease.versioning.templates.domain.events.VersionCreatedEvent;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionDataRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevision;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevisionData;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevisionType$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@Service
@Primary
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u0011e\u0003!\u0011!Q\u0001\niC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\u0006I\u0002!\t!\u001a\u0005\u0006}\u0002!\te \u0005\b\u0003k\u0001A\u0011IA\u001c\u0011\u001d\t9\u0006\u0001C\u0005\u00033B\u0011\"a\u001e\u0001#\u0003%I!!\u001f\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0010\"9\u0011q\u0013\u0001\u0005B\u0005e\u0005bBA[\u0001\u0011\u0005\u0013q\u0017\u0005\b\u0003{\u0003A\u0011IA`\u0011\u001d\tI\u000e\u0001C\u0005\u00037Dq!!:\u0001\t\u0013\t9\u000fC\u0004\u0002l\u0002!I!!<\u00031\u0011\u0013G+Z7qY\u0006$Xm\u0015;pe\u0006<WmU3sm&\u001cWM\u0003\u0002\u00181\u0005IA/Z7qY\u0006$Xm\u001d\u0006\u00033i\t!B^3sg&|g.\u001b8h\u0015\tYB$A\u0005yYJ,G.Z1tK*\u0011QDH\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aH\u0001\u0004G>l7\u0001A\n\u0005\u0001\tBC\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S)j\u0011AF\u0005\u0003WY\u0011a\u0003V3na2\fG/Z*u_J\fw-Z*feZL7-\u001a\t\u0003[Ij\u0011A\f\u0006\u0003_A\nQa\u001d7gi)T\u0011!M\u0001\tOJL'P\u001f7fI&\u00111G\f\u0002\b\u0019><w-\u001b8h\u0003i!X-\u001c9mCR,'+\u001a<jg&|gNU3q_NLGo\u001c:z!\t1\u0014(D\u00018\u0015\tAd#\u0001\u0006sKB|7/\u001b;pefL!AO\u001c\u00035Q+W\u000e\u001d7bi\u0016\u0014VM^5tS>t'+\u001a9pg&$xN]=\u0002=Q,W\u000e\u001d7bi\u0016\u0014VM^5tS>tG)\u0019;b%\u0016\u0004xn]5u_JL\bC\u0001\u001c>\u0013\tqtG\u0001\u0010UK6\u0004H.\u0019;f%\u00164\u0018n]5p]\u0012\u000bG/\u0019*fa>\u001c\u0018\u000e^8ss\u0006q\"/\u001a7fCN,g+\u001a:tS>t\u0017N\\4TKJL\u0017\r\\5{CRLwN\u001c\t\u0003S\u0005K!A\u0011\f\u0003=I+G.Z1tKZ+'o]5p]&twmU3sS\u0006d\u0017N_1uS>t\u0017A\u0004:fY\u0016\f7/Z*feZL7-\u001a\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fj\tqa]3sm&\u001cW-\u0003\u0002J\r\nq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011AJT\u0007\u0002\u001b*\u0011\u0001HG\u0005\u0003\u001f6\u0013\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0003a\u0011X\r]8tSR|'/\u001f,feNLwN\\*feZL7-\u001a\t\u0003%^k\u0011a\u0015\u0006\u0003)V\u000bq!\u001e9he\u0006$WM\u0003\u0002W9\u0005Q\u0001\u0010\u001c9mCR4wN]7\n\u0005a\u001b&\u0001\u0007*fa>\u001c\u0018\u000e^8ssZ+'o]5p]N+'O^5dK\u0006AQM^3oi\n+8\u000f\u0005\u0002\\=6\tAL\u0003\u0002^5\u00051QM^3oiNL!a\u0018/\u0003#ac%+\u001a7fCN,WI^3oi\n+8/\u0001\reKB,g\u000eZ3oGf$\u0016M]4fiJ+7o\u001c7wKJ\u0004\"\u0001\u00142\n\u0005\rl%\u0001\u0007#fa\u0016tG-\u001a8dsR\u000b'oZ3u%\u0016\u001cx\u000e\u001c<fe\u00061A(\u001b8jiz\"\u0012BZ4iS*\\G.\u001c8\u0011\u0005%\u0002\u0001\"\u0002\u001b\n\u0001\u0004)\u0004\"B\u001e\n\u0001\u0004a\u0004\"B \n\u0001\u0004\u0001\u0005\"B\"\n\u0001\u0004!\u0005\"\u0002&\n\u0001\u0004Y\u0005\"\u0002)\n\u0001\u0004\t\u0006\"B-\n\u0001\u0004Q\u0006\"\u00021\n\u0001\u0004\t\u0007FA\u0005q!\t\tH0D\u0001s\u0015\t\u0019H/\u0001\u0006b]:|G/\u0019;j_:T!!\u001e<\u0002\u000f\u0019\f7\r^8ss*\u0011q\u000f_\u0001\u0006E\u0016\fgn\u001d\u0006\u0003sj\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002w\u0006\u0019qN]4\n\u0005u\u0014(!C!vi><\u0018N]3e\u00031\u0019\u0018M^3SKZL7/[8o)!\t\t!a\u0002\u0002\u0018\u0005E\u0002cA\u0012\u0002\u0004%\u0019\u0011Q\u0001\u0013\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0013Q\u0001\u0019AA\u0006\u0003!!X-\u001c9mCR,\u0007\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E!$\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003+\tyAA\u0004SK2,\u0017m]3\t\u000f\u0005e!\u00021\u0001\u0002\u001c\u0005!Qo]3s!\u0011\ti\"a\u000b\u000f\t\u0005}\u0011q\u0005\t\u0004\u0003C!SBAA\u0012\u0015\r\t)\u0003I\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%B%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\tyC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003S!\u0003bBA\u001a\u0015\u0001\u0007\u00111D\u0001\b[\u0016\u001c8/Y4f\u0003-\u0019\u0018M^3WKJ\u001c\u0018n\u001c8\u0015\u0015\u0005e\u00121JA(\u0003#\n)\u0006\u0005\u0004\u0002<\u0005\u0005\u0013QI\u0007\u0003\u0003{Q1!a\u0010%\u0003\u0011)H/\u001b7\n\t\u0005\r\u0013Q\b\u0002\u0004)JL\bcA\u0012\u0002H%\u0019\u0011\u0011\n\u0013\u0003\u0007%sG\u000fC\u0004\u0002N-\u0001\r!a\u0007\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\rC\u0004\u0002\u001a-\u0001\r!a\u0007\t\u000f\u0005M3\u00021\u0001\u0002\u001c\u0005Ya/\u001a:tS>tg*Y7f\u0011\u001d\t\u0019d\u0003a\u0001\u00037\tab\u0019:fCR,'+\u001a<jg&|g\u000e\u0006\u0006\u0002\\\u0005-\u0014QNA8\u0003g\u0002B!!\u0018\u0002h5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'\u0001\u0003eCR\f'bAA3o\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\u0011\tI'a\u0018\u0003!Q+W\u000e\u001d7bi\u0016\u0014VM^5tS>t\u0007bBA\u0005\u0019\u0001\u0007\u00111\u0002\u0005\b\u00033a\u0001\u0019AA\u000e\u0011\u001d\t\t\b\u0004a\u0001\u00037\t1\u0002Z3tGJL\u0007\u000f^5p]\"I\u0011Q\u000f\u0007\u0011\u0002\u0003\u0007\u00111D\u0001\bm\u0016\u00148/[8o\u0003a\u0019'/Z1uKJ+g/[:j_:$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003wRC!a\u0007\u0002~-\u0012\u0011q\u0010\t\u0005\u0003\u0003\u000bI)\u0004\u0002\u0002\u0004*!\u0011QQAD\u0003%)hn\u00195fG.,GM\u0003\u0002tI%!\u00111RAB\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\be\u0016\u001cHo\u001c:f)\u0019\tY!!%\u0002\u0014\"9\u0011Q\n\bA\u0002\u0005m\u0001bBAK\u001d\u0001\u0007\u0011QI\u0001\u000be\u00164\u0018n]5p]&#\u0017\u0001\u00027pC\u0012$b!a\u0003\u0002\u001c\u0006u\u0005bBAK\u001f\u0001\u0007\u0011Q\t\u0005\b\u0003?{\u0001\u0019AAQ\u0003\u001d\u0019wN\u001c;fqR\u0004B!a)\u000226\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000bI+A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0005\u0003W\u000bi+\u0001\u0005qYVl'-\u001b8h\u0015\r\ty\u000bH\u0001\tI\u0016\u0004Hn\\=ji&!\u00111WAS\u0005E\u0011Vm]8mkRLwN\\\"p]R,\u0007\u0010^\u0001\u000fI\u0016dW\r^3SKZL7/[8o)\u0019\t\t!!/\u0002<\"9\u0011Q\n\tA\u0002\u0005m\u0001bBAK!\u0001\u0007\u0011QI\u0001\u0010I\u0016dW\r^3SKZL7/[8ogR1\u0011\u0011AAa\u0003\u0007Dq!!\u0014\u0012\u0001\u0004\tY\u0002C\u0004\u0002FF\u0001\r!a2\u0002\u0017I,g/[:j_:LEm\u001d\t\u0007\u0003\u0013\f\u0019.!\u0012\u000f\t\u0005-\u0017q\u001a\b\u0005\u0003C\ti-C\u0001&\u0013\r\t\t\u000eJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t).a6\u0003\u0007M+\u0017OC\u0002\u0002R\u0012\nq\u0003\u001d:pG\u0016\u001c8OU3ti>\u0014X\r\u001a+f[Bd\u0017\r^3\u0015\r\u0005\u0005\u0011Q\\Aq\u0011\u001d\tyN\u0005a\u0001\u0003\u0017\t\u0001C]3ti>\u0014X\r\u001a+f[Bd\u0017\r^3\t\u000f\u0005\r(\u00031\u0001\u0002\f\u0005y1-\u001e:sK:$H+Z7qY\u0006$X-A\nqe>\u001cWm]:EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u0002\f\u0005%\bbBAp'\u0001\u0007\u00111B\u0001\u000bq2\u0014h+\u001a:tS>tWCAA\u000eQ\r\u0001\u0011\u0011\u001f\t\u0005\u0003g\u0014\t!\u0004\u0002\u0002v*!\u0011q_A}\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\t\u0005m\u0018Q`\u0001\u0004gFd'bAA\u00005\u0005\u0011AMY\u0005\u0005\u0005\u0007\t)PA\bJgR\u0013\u0018M\\:bGRLwN\\1mQ\r\u0001!q\u0001\t\u0005\u0005\u0013\u0011y!\u0004\u0002\u0003\f)\u00191O!\u0004\u000b\u0007\u0005}\u00050\u0003\u0003\u0003\u0012\t-!a\u0002)sS6\f'/\u001f\u0015\u0004\u0001\tU\u0001\u0003\u0002B\f\u0005;i!A!\u0007\u000b\u0007\tm\u00010\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAAa\b\u0003\u001a\t91+\u001a:wS\u000e,\u0007")
public class DbTemplateStorageService
implements TemplateStorageService,
Logging {
    private final TemplateRevisionRepository templateRevisionRepository;
    private final TemplateRevisionDataRepository templateRevisionDataRepository;
    private final ReleaseVersioningSerialization releaseVersioningSerialization;
    private final ReleaseService releaseService;
    private final ReleaseRepository releaseRepository;
    private final RepositoryVersionService repositoryVersionService;
    private final XLReleaseEventBus eventBus;
    private final DependencyTargetResolver dependencyTargetResolver;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DbTemplateStorageService dbTemplateStorageService = this;
        synchronized (dbTemplateStorageService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public void saveRevision(Release template, String user, String message) {
        this.createRevision(template, user, message, this.createRevision$default$4());
    }

    @Override
    public Try<Object> saveVersion(String templateId, String user, String versionName, String message) {
        Release template = this.releaseService.findById(templateId);
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            TemplateRevision version = this.createRevision(template, user, message, versionName);
            $this.templateRevisionRepository.deleteRevisionsForVersion(version);
            $this.eventBus.publish((XLReleaseEvent)new VersionCreatedEvent(templateId, versionName));
            return version.id();
        }).recoverWith((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ DbTemplateStorageService $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0 & Serializable)() -> "Unable to create new template version", (Function0 & Serializable)() -> exception);
                    return (B1)new Failure((Throwable)exception);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof Exception;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
            }
        });
    }

    private TemplateRevision createRevision(Release template, String user, String description, String version) {
        if (template.isWorkflow()) {
            throw new TemplateVersioningException("Template version control is not supported for workflows", TemplateVersioningException$.MODULE$.apply$default$2(), TemplateVersioningException$.MODULE$.apply$default$3());
        }
        TemplateRevision templateRevision = new TemplateRevision();
        templateRevision.ciUid_$eq(Predef$.MODULE$.Integer2int(template.getCiUid()));
        templateRevision.revisionType_$eq(version != null ? TemplateRevisionType$.MODULE$.VERSION() : TemplateRevisionType$.MODULE$.REVISION());
        templateRevision.version_$eq(version);
        templateRevision.description_$eq(description);
        templateRevision.username_$eq(user);
        templateRevision.revisionTime_$eq(new Date());
        TemplateRevision savedTr = this.templateRevisionRepository.create(templateRevision);
        TemplateRevisionData trd = new TemplateRevisionData(savedTr.id(), this.xlrVersion(), this.releaseVersioningSerialization.toBytes(template));
        this.templateRevisionDataRepository.create(trd);
        return savedTr;
    }

    private String createRevision$default$4() {
        return null;
    }

    @Override
    public Release restore(String templateId, int revisionId) {
        Release currentTemplate = this.releaseService.findById(templateId);
        ResolutionContext context = Ids.isInFolder((String)templateId) ? ResolutionContext$.MODULE$.apply(Ids.getParentId((String)templateId)) : ResolutionContext$.MODULE$.GLOBAL();
        Release previousTemplate = this.load(revisionId, context);
        this.processRestoredTemplate(previousTemplate, currentTemplate);
        Release updatedTemplate = this.releaseRepository.replace(currentTemplate, previousTemplate);
        this.eventBus.publish((XLReleaseEvent)new ReleaseRestoredEvent(currentTemplate, updatedTemplate, revisionId));
        return this.releaseService.findById(templateId);
    }

    @Override
    public Release load(int revisionId, ResolutionContext context) {
        Option<TemplateRevisionData> option = this.templateRevisionDataRepository.findById(revisionId);
        if (option instanceof Some) {
            Some some = (Some)option;
            TemplateRevisionData trd = (TemplateRevisionData)some.value();
            Option<Release> option2 = this.releaseVersioningSerialization.fromBytes(trd.content(), trd.dataModelVersion(), context);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Release template = (Release)some2.value();
                return this.processDependencies(template);
            }
            if (None$.MODULE$.equals(option2)) {
                throw new LogFriendlyNotFoundException("Error reading " + revisionId + ", see logs for more details", new Object[0]);
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new LogFriendlyNotFoundException("Revision id " + revisionId + " not found", new Object[0]);
        }
        throw new MatchError(option);
    }

    @Override
    public void deleteRevision(String templateId, int revisionId) {
        this.releaseRepository.getUid(templateId).foreach((Function1 & Serializable)templateCiUid -> {
            DbTemplateStorageService.$anonfun$deleteRevision$1(this, revisionId, templateId, templateCiUid);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void deleteRevisions(String templateId, Seq<Object> revisionIds) {
        this.releaseRepository.getUid(templateId).foreach((Function1 & Serializable)templateCiUid -> {
            DbTemplateStorageService.$anonfun$deleteRevisions$1(this, revisionIds, templateId, templateCiUid);
            return BoxedUnit.UNIT;
        });
    }

    private void processRestoredTemplate(Release restoredTemplate, Release currentTemplate) {
        restoredTemplate.setCiUid(currentTemplate.getCiUid());
        CiHelper.rewriteWithNewId((ConfigurationItem)restoredTemplate, (String)currentTemplate.getId());
        restoredTemplate.setReleaseTriggers(new ArrayList());
        this.processDependencies(restoredTemplate);
        restoredTemplate.get$ciAttributes().setScmTraceabilityDataId(null);
    }

    private Release processDependencies(Release restoredTemplate) {
        restoredTemplate.getAllGates().forEach(gateTask -> {
            List validDependencies = gateTask.getDependencies().stream().filter(d -> d.hasResolvedTarget() || Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.dependencyTargetResolver.resolveTarget(d)).isSuccess()).collect(Collectors.toList());
            gateTask.setDependencies(validDependencies);
        });
        return restoredTemplate;
    }

    private String xlrVersion() {
        Version version = this.repositoryVersionService.readVersionOfComponent("xl-release");
        if (version == null) {
            return "0.0.0";
        }
        return version.getVersion();
    }

    public static final /* synthetic */ void $anonfun$deleteRevision$1(DbTemplateStorageService $this, int revisionId$1, String templateId$2, Integer templateCiUid) {
        $this.templateRevisionRepository.deleteRevisions(templateCiUid, (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{revisionId$1}))));
        $this.eventBus.publish((XLReleaseEvent)new RevisionDeletedEvent(templateId$2, revisionId$1));
    }

    public static final /* synthetic */ void $anonfun$deleteRevisions$1(DbTemplateStorageService $this, Seq revisionIds$1, String templateId$3, Integer templateCiUid) {
        $this.templateRevisionRepository.deleteRevisions(templateCiUid, (Seq<Object>)revisionIds$1);
        revisionIds$1.foreach((Function1)(JFunction1.mcVI.sp & Serializable)id -> $this.eventBus.publish((XLReleaseEvent)new RevisionDeletedEvent(templateId$3, id)));
    }

    @Autowired
    public DbTemplateStorageService(TemplateRevisionRepository templateRevisionRepository, TemplateRevisionDataRepository templateRevisionDataRepository, ReleaseVersioningSerialization releaseVersioningSerialization, ReleaseService releaseService, ReleaseRepository releaseRepository, RepositoryVersionService repositoryVersionService, XLReleaseEventBus eventBus, DependencyTargetResolver dependencyTargetResolver) {
        this.templateRevisionRepository = templateRevisionRepository;
        this.templateRevisionDataRepository = templateRevisionDataRepository;
        this.releaseVersioningSerialization = releaseVersioningSerialization;
        this.releaseService = releaseService;
        this.releaseRepository = releaseRepository;
        this.repositoryVersionService = repositoryVersionService;
        this.eventBus = eventBus;
        this.dependencyTargetResolver = dependencyTargetResolver;
        Logging.$init$((Logging)this);
    }
}

