import { Order, RowsPerPageOption } from '@digital-ai/dot-components';

export interface Template {
    // tech-debt: this should be the same as Release
    abortOnFailure: boolean;
    allowPasswordsInAllFields: boolean;
    archiveRelease: boolean;
    description: string;
    disableNotifications: boolean;
    flag: unknown;
    id: string;
    scriptUserPassword: string;
    scriptUsername: string;
    syntheticProperties: Record<SyntheticTemplateProperties, unknown>;
    tags: Array<string>;
    title: string;
    variableMapping: unknown;
    variables: Array<unknown>;
}

type SyntheticTemplateProperties = 'riskProfile';

export interface TemplateFilter {
    parentId: string;
}

export interface ManagedApplicationType {
    applicationName: string;
    applicationReference: string;
    connectionServer: {
        id: string;
        name: string;
        type: string;
        url: string;
    };
    dateCreated: Date;
    deleteWorkflowId?: string;
    environmentTag: string;
    id: string;
    managedBy: 'Release' | 'View-only';
    updateWorkflowId?: string;
    workflowId?: string;
}

export interface ManagedApplicationsPage {
    folderId?: string;
    order: Order;
    orderBy: string;
    page: number;
    resultsPerPage: RowsPerPageOption;
}

export interface ManagedApplicationsFilters extends ManagedApplicationsPage {
    condition: string;
}

export interface FetchTemplatesResponse {
    cis: Array<Template>;
}

export interface DevOpsDeploymentsFeatureResponse {
    enabled: boolean;
}
