/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.io;

import com.typesafe.config.Config;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.DirectoryStreamer;
import com.xebialabs.xldeploy.packager.io.EmptyStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamer;
import com.xebialabs.xldeploy.packager.io.JarArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.JarFileArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory$;
import com.xebialabs.xldeploy.packager.io.SupportedArchiveExtensions$;
import com.xebialabs.xldeploy.packager.io.UnsupportedArchiveExtensionException;
import com.xebialabs.xldeploy.packager.io.ZipFileArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ZipFileArchiveStreamer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005}t!B\u000b\u0017\u0011\u0003\tc!B\u0012\u0017\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003\u0002C\u0017\u0002\u0005\u0004%\t!\u0001\u0018\t\r]\n\u0001\u0015!\u00030\u0011\u0015A\u0014\u0001\"\u0001:\u0011\u001d\tI'\u0001C\u0001\u0003W2Aa\t\f\u0001w!AAh\u0002B\u0001B\u0003%Q\b\u0003\u0005L\u000f\t\u0005\t\u0015!\u0003I\u0011!auA!A!\u0002\u0013A\u0005\"B\u0016\b\t\u0003i\u0005BB)\bA\u0013%!\u000b\u0003\u0004`\u000f\u0011\u0005a\u0003\u0019\u0005\u0006Q\u001e!\t!\u001b\u0005\t\u0003\u001b9\u0001\u0015\"\u0003\u0002\u0010!9\u0011qF\u0004\u0005\u0002\u0005E\u0002bBA\u001e\u000f\u0011\u0005\u0011Q\b\u0005\n\u0003\u000f:\u0011\u0013!C\u0001\u0003\u0013Bq!a\u000f\b\t\u0003\ty\u0006C\u0004\u0002d\u001d!\t!!\u001a\u0002\u001fM#(/Z1nKJ4\u0015m\u0019;pefT!a\u0006\r\u0002\u0005%|'BA\r\u001b\u0003!\u0001\u0018mY6bO\u0016\u0014(BA\u000e\u001d\u0003!AH\u000eZ3qY>L(BA\u000f\u001f\u0003%AXMY5bY\u0006\u00147OC\u0001 \u0003\r\u0019w.\\\u0002\u0001!\t\u0011\u0013!D\u0001\u0017\u0005=\u0019FO]3b[\u0016\u0014h)Y2u_JL8CA\u0001&!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!I\u0001\u0007Y><w-\u001a:\u0016\u0003=\u0002\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\u000bMdg\r\u000e6\u000b\u0003Q\n\u0001b\u001a:jujdW\rZ\u0005\u0003mE\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0010I\u00164\u0017-\u001e7u\u001b\u0006\u0004\b/\u001b8hgR\t!\b\u0005\u0002#\u000fM\u0011q!J\u0001\u0010CJ\u001c\u0007.\u001b<f\u001b\u0006\u0004\b/\u001b8hgB!a(\u0012%I\u001d\ty4\t\u0005\u0002AO5\t\u0011I\u0003\u0002CA\u00051AH]8pizJ!\u0001R\u0014\u0002\rA\u0013X\rZ3g\u0013\t1uIA\u0002NCBT!\u0001R\u0014\u0011\u0005yJ\u0015B\u0001&H\u0005\u0019\u0019FO]5oO\u0006Y!0\u001b9F]\u000e|G-\u001b8h\u0003-Q\u0017M]#oG>$\u0017N\\4\u0015\tiru\n\u0015\u0005\u0006y-\u0001\r!\u0010\u0005\u0006\u0017.\u0001\r\u0001\u0013\u0005\u0006\u0019.\u0001\r\u0001S\u0001\u0018O\u0016$\u0018I]2iSZ,WI\u001c;ssN#(/Z1nKJ$\"a\u0015,\u0011\u0005\t\"\u0016BA+\u0017\u0005!\u0019FO]3b[\u0016\u0014\b\"B,\r\u0001\u0004A\u0016\u0001\u00024jY\u0016\u0004\"!W/\u000e\u0003iS!aF.\u000b\u0003q\u000bAA[1wC&\u0011aL\u0017\u0002\u0005\r&dW-A\u000fhKR\f%o\u00195jm\u0016,e\u000e\u001e:z'R\u0014X-Y7TiJ,\u0017-\\3s)\r\u0019\u0016M\u001a\u0005\u0006E6\u0001\raY\u0001\u0003SN\u0004\"!\u00173\n\u0005\u0015T&aC%oaV$8\u000b\u001e:fC6DQaZ\u0007A\u0002!\u000bAA\\1nK\u00061r-\u001a;Be\u000eD\u0017N^3PkR\u0004X\u000f^*ue\u0016\fW\u000eF\u0002k\u0003\u0013\u0001$a[>\u0011\u00071<\u00180D\u0001n\u0015\tqw.A\u0005be\u000eD\u0017N^3sg*\u0011\u0001/]\u0001\tG>l\u0007O]3tg*\u0011!o]\u0001\bG>lWn\u001c8t\u0015\t!X/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0006\u0019qN]4\n\u0005al'aE!sG\"Lg/Z(viB,Ho\u0015;sK\u0006l\u0007C\u0001>|\u0019\u0001!\u0011\u0002 \b\u0002\u0002\u0003\u0005)\u0011A?\u0003\u0011\u0011\nX.\u0019:lIE\n2A`A\u0002!\t1s0C\u0002\u0002\u0002\u001d\u0012qAT8uQ&tw\rE\u0002m\u0003\u000bI1!a\u0002n\u00051\t%o\u00195jm\u0016,e\u000e\u001e:z\u0011\u0019\tYA\u0004a\u00011\u00061A/\u0019:hKR\f\u0011dZ3u)\u0006\u0014\u0018I]2iSZ,w*\u001e;qkR\u001cFO]3b[R1\u0011\u0011CA\u000f\u0003?\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/i\u0017a\u0001;be&!\u00111DA\u000b\u0005Y!\u0016M]!sG\"Lg/Z(viB,Ho\u0015;sK\u0006l\u0007BBA\u0006\u001f\u0001\u0007\u0001\fC\u0004\u0002\"=\u0001\r!a\t\u0002\u0015\r|W\u000e\u001d:fgN|'\u000fE\u0004'\u0003K\tI#!\u000b\n\u0007\u0005\u001drEA\u0005Gk:\u001cG/[8ocA\u0019\u0011,a\u000b\n\u0007\u00055\"L\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.A\niCN\f%o\u00195jm\u0016,\u0005\u0010^3og&|g\u000e\u0006\u0003\u00024\u0005e\u0002c\u0001\u0014\u00026%\u0019\u0011qG\u0014\u0003\u000f\t{w\u000e\\3b]\")q\r\u0005a\u0001\u0011\u0006A1\u000f\u001e:fC6,'\u000fF\u0004T\u0003\u007f\t\t%a\u0011\t\u000b\t\f\u0002\u0019A2\t\u000b\u001d\f\u0002\u0019\u0001%\t\u0013\u0005\u0015\u0013\u0003%AA\u0002\u0005M\u0012!C5t\u0003J\u001c\u0007.\u001b<f\u0003I\u0019HO]3b[\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005-#\u0006BA\u001a\u0003\u001bZ#!a\u0014\u0011\t\u0005E\u00131L\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033:\u0013AC1o]>$\u0018\r^5p]&!\u0011QLA*\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u000b\u0004'\u0006\u0005\u0004\"B,\u0014\u0001\u0004A\u0016AD4fi\u0006\u00138\r[5wKRK\b/\u001a\u000b\u0004\u0011\u0006\u001d\u0004\"B4\u0015\u0001\u0004A\u0015!\u00034pe\u000e{gNZ5h)\rQ\u0014Q\u000e\u0005\b\u0003_2\u0001\u0019AA9\u0003\u0019\u0019wN\u001c4jOB!\u00111OA>\u001b\t\t)H\u0003\u0003\u0002p\u0005]$bAA==\u0005AA/\u001f9fg\u00064W-\u0003\u0003\u0002~\u0005U$AB\"p]\u001aLw\r")
public class StreamerFactory {
    private final Map<String, String> archiveMappings;
    private final String zipEncoding;
    private final String jarEncoding;

    public static StreamerFactory forConfig(Config config) {
        return StreamerFactory$.MODULE$.forConfig(config);
    }

    public static StreamerFactory defaultMappings() {
        return StreamerFactory$.MODULE$.defaultMappings();
    }

    private Streamer getArchiveEntryStreamer(File file) {
        String mappedExt = this.getArchiveType(file.getName());
        boolean extOK = BoxesRunTime.unboxToBoolean((Object)TryWith$.MODULE$.apply((Function0 & Serializable)() -> ArtifactIOUtils$.MODULE$.getResettableInputStream(new FileInputStream(file)), (Function1 & Serializable)resettableIs -> BoxesRunTime.boxToBoolean((boolean)SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, file.getName()))).get());
        String string = mappedExt;
        if (!extOK) {
            return new EmptyStreamer();
        }
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new ZipFileArchiveStreamer(file, this.zipEncoding);
        }
        String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return new JarFileArchiveStreamer(file, this.jarEncoding);
        }
        String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> is);
        }
        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new GzipCompressorInputStream(is));
        }
        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new BZip2CompressorInputStream(is));
        }
        throw new MatchError((Object)string);
    }

    public Streamer getArchiveEntryStreamStreamer(InputStream is2, String name) {
        String mappedExt = this.getArchiveType(name);
        InputStream resettableIs = ArtifactIOUtils$.MODULE$.getResettableInputStream(is2);
        boolean extOK = SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, name);
        String string = mappedExt;
        if (!extOK) {
            return new EmptyStreamer();
        }
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new ZipFileArchiveStreamStreamer(resettableIs, this.zipEncoding);
        }
        String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return new JarArchiveStreamStreamer(resettableIs, this.jarEncoding);
        }
        String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> is);
        }
        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new GzipCompressorInputStream(is));
        }
        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new BZip2CompressorInputStream(is));
        }
        throw new MatchError((Object)string);
    }

    public ArchiveOutputStream<? extends ArchiveEntry> getArchiveOutputStream(File target) {
        String string = this.getArchiveType(target.getName());
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new ZipArchiveOutputStream(target);
        }
        String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return new ZipArchiveOutputStream(target);
        }
        String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> os);
        }
        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> new GzipCompressorOutputStream(os));
        }
        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> new BZip2CompressorOutputStream(os));
        }
        String originExt = (String)((Tuple2)this.archiveMappings.find((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)StreamerFactory.$anonfun$getArchiveOutputStream$4(target, am))).get())._1();
        throw new UnsupportedArchiveExtensionException(target.getName() + " with extension " + originExt + " -> " + string + " is not a supported archive output type");
    }

    private TarArchiveOutputStream getTarArchiveOutputStream(File target, Function1<OutputStream, OutputStream> compressor) {
        OutputStream wrapped = (OutputStream)compressor.apply((Object)new FileOutputStream(target));
        TarArchiveOutputStream os = new TarArchiveOutputStream(wrapped);
        os.setLongFileMode(3);
        os.setBigNumberMode(2);
        return os;
    }

    public boolean hasArchiveExtension(String name) {
        return this.archiveMappings.exists((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith('.' + (String)am._1())));
    }

    public Streamer streamer(InputStream is, String name, boolean isArchive) {
        if (this.hasArchiveExtension(name)) {
            return this.getArchiveEntryStreamStreamer(is, name);
        }
        if (isArchive) {
            return new ZipFileArchiveStreamStreamer(ArtifactIOUtils$.MODULE$.getResettableInputStream(is), this.zipEncoding);
        }
        return new FileStreamStreamer(is, name);
    }

    public Streamer streamer(File file) {
        if (file.isDirectory()) {
            return new DirectoryStreamer(file);
        }
        if (this.hasArchiveExtension(file.getName())) {
            return this.getArchiveEntryStreamer(file);
        }
        return new FileStreamer(file);
    }

    public boolean streamer$default$3() {
        return false;
    }

    public String getArchiveType(String name) {
        Some some;
        Tuple2 tuple2;
        Option option = this.archiveMappings.find((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)name.endsWith('.' + (String)am._1())));
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedArchiveExtensionException(name + " is not a supported archive");
        }
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String originExt = (String)tuple2._1();
            String mappedExt = (String)tuple2._2();
            StreamerFactory$.MODULE$.logger().debug((Function0 & Serializable)() -> "Detected mapped archive extension " + originExt + " -> " + mappedExt + " for " + name);
            return mappedExt;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$getArchiveOutputStream$4(File target$1, Tuple2 am) {
        return target$1.getName().endsWith('.' + (String)am._1());
    }

    public StreamerFactory(Map<String, String> archiveMappings, String zipEncoding, String jarEncoding) {
        this.archiveMappings = archiveMappings;
        this.zipEncoding = zipEncoding;
        this.jarEncoding = jarEncoding;
    }
}

