/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core.helpers;

import java.sql.SQLException;
import java.util.Date;
import java.util.UUID;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.hub.HubConfiguration;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.HubUpdater;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.listener.HubChangeExecListener;
import liquibase.hub.model.Connection;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.Operation;
import liquibase.logging.core.BufferedLogService;
import liquibase.util.StringUtil;

@Deprecated
public class HubHandler {
    private final Connection connection;
    private final ChangeExecListener changeExecListener;
    private final String changeLogFile;
    private HubUpdater hubUpdater;
    private Operation operation;

    public HubHandler(Database database, DatabaseChangeLog changeLog, String changeLogFile, ChangeExecListener changeExecListener) throws LiquibaseException {
        this.changeExecListener = changeExecListener;
        this.changeLogFile = changeLogFile;
        this.hubUpdater = new HubUpdater(new Date(), changeLog, database);
        this.connection = this.getConnection(changeLog, database);
    }

    public HubChangeExecListener startHubForChangelogSync(ChangeLogParameters changeLogParameters, String tag, ChangeLogIterator listLogIterator) throws LiquibaseException, SQLException {
        if (this.isConnected()) {
            String operationCommand = tag == null ? "changelog-sync" : "changelog-sync-to-tag";
            this.operation = this.hubUpdater.preUpdateHub("CHANGELOGSYNC", operationCommand, this.connection, this.changeLogFile, changeLogParameters.getContexts(), changeLogParameters.getLabels(), listLogIterator);
            return new HubChangeExecListener(this.operation, this.changeExecListener);
        }
        return null;
    }

    public HubChangeExecListener startHubForUpdate(ChangeLogParameters changeLogParameters, ChangeLogIterator listLogIterator, String operationCommand) throws LiquibaseException, SQLException {
        if (this.isConnected()) {
            this.operation = this.hubUpdater.preUpdateHub("UPDATE", operationCommand, this.connection, this.changeLogFile, changeLogParameters.getContexts(), changeLogParameters.getLabels(), listLogIterator);
            return new HubChangeExecListener(this.operation, this.changeExecListener);
        }
        return null;
    }

    public void postUpdateHub(BufferedLogService bufferLog) {
        if (this.hubUpdater != null) {
            this.hubUpdater.postUpdateHub(this.operation, bufferLog);
        }
    }

    public void postUpdateHubExceptionHandling(BufferedLogService bufferLog, String message) {
        if (this.operation != null) {
            this.hubUpdater.postUpdateHubExceptionHandling(this.operation, bufferLog, message);
        }
    }

    private boolean isConnected() {
        return this.connection != null;
    }

    private Connection getConnection(DatabaseChangeLog changeLog, Database database) throws LiquibaseHubException {
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database);
        if (executor instanceof LoggingExecutor) {
            return null;
        }
        String changeLogId = changeLog.getChangeLogId();
        this.hubUpdater = new HubUpdater(new Date(), changeLog, database);
        if (this.hubUpdater.hubIsNotAvailable(changeLogId)) {
            if (StringUtil.isNotEmpty(HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValue()) && changeLogId == null) {
                String message = "An API key was configured, but no changelog ID exists.\nNo operations will be reported. Register this changelog with Liquibase Hub to generate free deployment reports.\nLearn more at https://hub.liquibase.com.";
                Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
                Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            }
            return null;
        }
        if (StringUtil.isEmpty(HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValue()) && changeLogId != null) {
            String message = "The changelog ID '" + changeLogId + "' was found, but no API Key exists.\nNo operations will be reported. Simply add a liquibase.hub.apiKey setting to generate free deployment reports.\nLearn more at https://hub.liquibase.com.";
            Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
            Scope.getCurrentScope().getLog(this.getClass()).warning(message);
            return null;
        }
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        HubChangeLog hubChangeLog = hubService.getHubChangeLog(UUID.fromString(changeLogId), "*");
        if (hubChangeLog == null) {
            Scope.getCurrentScope().getLog(this.getClass()).warning("Retrieving Hub Change Log failed for Changelog ID: " + changeLogId);
            return null;
        }
        if (hubChangeLog.isDeleted()) {
            String message = "\nThe operation did not complete and will not be reported to Hub because the\nregistered changelog has been deleted by someone in your organization.\nLearn more at https://hub.liquibase.com.";
            throw new LiquibaseHubException(message);
        }
        Connection exampleConnection = new Connection();
        exampleConnection.setProject(hubChangeLog.getProject());
        exampleConnection.setJdbcUrl(database.getConnection().getURL());
        return hubService.getConnection(exampleConnection, true);
    }
}

