/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.akka.extension.quartz;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.EventStream;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.akka.extension.quartz.QuartzCalendars$;
import com.typesafe.akka.extension.quartz.QuartzCronSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedulerExtension$;
import com.typesafe.akka.extension.quartz.QuartzSchedules$;
import com.typesafe.akka.extension.quartz.SimpleActorMessageJob;
import com.typesafe.akka.extension.quartz.package$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\rEq!B#G\u0011\u0003\tf!B*G\u0011\u0003!\u0006BB6\u0002\t\u0003\u00119\u0010C\u0004\u0003z\u0006!\tEa?\t\u000f\t}\u0018\u0001\"\u0011\u0004\u0002!911B\u0001\u0005B\r5a\u0001B*G\u0001\rD\u0001b\u001a\u0004\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\u0006W\u001a!\t\u0001\u001c\u0005\b]\u001a\u0011\r\u0011\"\u0003p\u0011\u00191h\u0001)A\u0005a\")qO\u0002C\u0001q\"9\u0011\u0011\u0002\u0004\u0005\u0012\u0005-\u0001\"CA\f\r\t\u0007I\u0011AA\r\u0011!\t\tC\u0002Q\u0001\n\u0005m\u0001\"CA\u0012\r\t\u0007I\u0011AA\r\u0011!\t)C\u0002Q\u0001\n\u0005m\u0001\"CA\u0014\r\t\u0007I\u0011AA\u0015\u0011!\t\tD\u0002Q\u0001\n\u0005-\u0002\"CA\u001a\r\t\u0007I\u0011AA\u001b\u0011!\t9E\u0002Q\u0001\n\u0005]\u0002\"CA%\r\t\u0007I\u0011AA&\u0011!\t\u0019G\u0002Q\u0001\n\u00055\u0003\"CA3\r\t\u0007I\u0011AA4\u0011!\tIH\u0002Q\u0001\n\u0005%\u0004bBA>\r\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u000b3A\u0011AA\u0015\u0011\u001d\t9I\u0002C\u0001\u0003\u0013Cq!a#\u0007\t\u0003\tI\u0003C\u0004\u0002\u000e\u001a!\t!a$\t\u000f\u0005\u0005f\u0001\"\u0001\u0002~!9\u00111\u0015\u0004\u0005\u0002\u0005\u0015\u0006\"CAV\rE\u0005I\u0011AAW\u0011\u001d\t\u0019M\u0002C\u0001\u0003\u000bDq!!3\u0007\t\u0003\tY\rC\u0004\u0002P\u001a!\t!! \t\u000f\u0005Eg\u0001\"\u0001\u0002T\"9\u0011q\u001b\u0004\u0005\u0002\u0005e\u0007\"CA\u007f\rE\u0005I\u0011AA\u0000\u0011%\u0011\u0019ABI\u0001\n\u0003\ty\u0010C\u0005\u0003\u0006\u0019\t\n\u0011\"\u0001\u0003\b!9!1\u0002\u0004\u0005\u0002\t5\u0001\"\u0003B\u000f\rE\u0005I\u0011AA\u0000\u0011%\u0011yBBI\u0001\n\u0003\ty\u0010C\u0005\u0003\"\u0019\t\n\u0011\"\u0001\u0003\b!9!1\u0005\u0004\u0005\u0002\t\u0015\u0002b\u0002B\u0015\r\u0011\u0005\u0011Q\u0010\u0005\b\u0005W1A\u0011\u0001B\u0017\u0011\u001d\u0011\tD\u0002C\u0001\u0005gA\u0011Ba\u0010\u0007#\u0003%\t!a@\t\u0013\t\u0005c!%A\u0005\u0002\u0005}\b\"\u0003B\"\rE\u0005I\u0011\u0001B\u0004\u0011\u001d\u0011)E\u0002C\u0001\u0005\u000fB\u0011Ba\u0016\u0007#\u0003%\t!a@\t\u0013\tec!%A\u0005\u0002\u0005}\b\"\u0003B.\rE\u0005I\u0011\u0001B\u0004\u0011!\u0011iF\u0002C\u0001\r\n}\u0003b\u0002B2\r\u0011\u0005!Q\r\u0005\b\u0005G2A\u0011\u0001B7\u0011\u001d\u0011\u0019G\u0002C\u0001\u0005wBqAa\u0019\u0007\t\u0003\u0011I\tC\u0004\u0003d\u0019!\tA!&\t\u000f\t\rd\u0001\"\u0001\u0003 \"A!\u0011\u0016\u0004\u0005\u0002\u0019\u0013Y\u000b\u0003\u0005\u00036\u001a!\tA\u0012B\\\u0011\u001d\u0011)M\u0002C\t\u0003{B!Ba2\u0007\u0011\u000b\u0007I\u0011\u0003Be\u0011)\u00119N\u0002EC\u0002\u0013E!\u0011\u001c\u0005\u000b\u0005O4\u0001R1A\u0005\u0012\t%\u0018\u0001G)vCJ$(pU2iK\u0012,H.\u001a:FqR,gn]5p]*\u0011q\tS\u0001\u0007cV\f'\u000f\u001e>\u000b\u0005%S\u0015!C3yi\u0016t7/[8o\u0015\tYE*\u0001\u0003bW.\f'BA'O\u0003!!\u0018\u0010]3tC\u001a,'\"A(\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005I\u000bQ\"\u0001$\u00031E+\u0018M\u001d;{'\u000eDW\rZ;mKJ,\u0005\u0010^3og&|gnE\u0003\u0002+n\u0013\t\u0010\u0005\u0002W36\tqKC\u0001Y\u0003\u0015\u00198-\u00197b\u0013\tQvK\u0001\u0004B]f\u0014VM\u001a\t\u00049\u0002\u0014W\"A/\u000b\u0005y{\u0016!B1di>\u0014(\"A&\n\u0005\u0005l&aC#yi\u0016t7/[8o\u0013\u0012\u0004\"A\u0015\u0004\u0014\u0007\u0019)F\r\u0005\u0002]K&\u0011a-\u0018\u0002\n\u000bb$XM\\:j_:\faa]=ti\u0016l\u0007C\u0001/j\u0013\tQWLA\u0006BGR|'oU=ti\u0016l\u0017A\u0002\u001fj]&$h\b\u0006\u0002c[\")q\r\u0003a\u0001Q\u0006\u0019An\\4\u0016\u0003A\u0004\"!\u001d;\u000e\u0003IT!a]0\u0002\u000b\u00154XM\u001c;\n\u0005U\u0014(A\u0004'pO\u001eLgnZ!eCB$XM]\u0001\u0005Y><\u0007%A\u0007tG\",G-\u001e7fe:\u000bW.Z\u000b\u0002sB\u0019!0a\u0001\u000f\u0005m|\bC\u0001?X\u001b\u0005i(B\u0001@Q\u0003\u0019a$o\\8u}%\u0019\u0011\u0011A,\u0002\rA\u0013X\rZ3g\u0013\u0011\t)!a\u0002\u0003\rM#(/\u001b8h\u0015\r\t\taV\u0001\u0007G>tg-[4\u0016\u0005\u00055\u0001\u0003BA\b\u0003'i!!!\u0005\u000b\u0007\u0005%A*\u0003\u0003\u0002\u0016\u0005E!AB\"p]\u001aLw-A\u0006uQJ,\u0017\rZ\"pk:$XCAA\u000e!\r1\u0016QD\u0005\u0004\u0003?9&aA%oi\u0006aA\u000f\u001b:fC\u0012\u001cu.\u001e8uA\u0005qA\u000f\u001b:fC\u0012\u0004&/[8sSRL\u0018a\u0004;ie\u0016\fG\r\u0015:j_JLG/\u001f\u0011\u0002)\u0011\fW-\\8o)\"\u0014X-\u00193t?\u0012\nX.\u0019:l+\t\tY\u0003E\u0002W\u0003[I1!a\fX\u0005\u001d\u0011un\u001c7fC:\fQ\u0003Z1f[>tG\u000b\u001b:fC\u0012\u001cx\fJ9nCJ\\\u0007%A\beK\u001a\fW\u000f\u001c;US6,'p\u001c8f+\t\t9\u0004\u0005\u0003\u0002:\u0005\rSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0003\nAA[1wC&!\u0011QIA\u001e\u0005!!\u0016.\\3[_:,\u0017\u0001\u00053fM\u0006,H\u000e\u001e+j[\u0016TxN\\3!\u0003%\u00198\r[3ek2,7/\u0006\u0002\u0002NA9\u0011qJA-s\u0006uSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002X]\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY&!\u0015\u0003\u000fQ\u0013\u0018.Z'baB\u0019!+a\u0018\n\u0007\u0005\u0005dI\u0001\bRk\u0006\u0014HO_*dQ\u0016$W\u000f\\3\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u001c\b%A\u0006sk:t\u0017N\\4K_\n\u001cXCAA5!\u001d\ty%!\u0017z\u0003W\u0002B!!\u001c\u0002v5\u0011\u0011q\u000e\u0006\u0004\u000f\u0006E$BAA:\u0003\ry'oZ\u0005\u0005\u0003o\nyG\u0001\u0004K_\n\\U-_\u0001\reVtg.\u001b8h\u0015>\u00147\u000fI\u0001\bgR\fg\u000e\u001a2z)\t\ty\bE\u0002W\u0003\u0003K1!a!X\u0005\u0011)f.\u001b;\u0002\u001f%\u001c\u0018J\\*uC:$'-_'pI\u0016\fQa\u001d;beR$\"!a\u000b\u0002\u0013%\u001c8\u000b^1si\u0016$\u0017a\u00038fqR$&/[4hKJ$B!!%\u0002\u001eB)a+a%\u0002\u0018&\u0019\u0011QS,\u0003\r=\u0003H/[8o!\u0011\tI$!'\n\t\u0005m\u00151\b\u0002\u0005\t\u0006$X\r\u0003\u0004\u0002 v\u0001\r!_\u0001\u0005]\u0006lW-\u0001\u0006tkN\u0004XM\u001c3BY2\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0005\u0003\u007f\n9\u000bC\u0005\u0002*~\u0001\n\u00111\u0001\u0002,\u0005)r/Y5u\r>\u0014(j\u001c2t)>\u001cu.\u001c9mKR,\u0017AE:ikR$wn\u001e8%I\u00164\u0017-\u001e7uIE*\"!a,+\t\u0005-\u0012\u0011W\u0016\u0003\u0003g\u0003B!!.\u0002@6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000bY,A\u0005v]\u000eDWmY6fI*\u0019\u0011QX,\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002B\u0006]&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Q1/^:qK:$'j\u001c2\u0015\t\u0005-\u0012q\u0019\u0005\u0007\u0003?\u000b\u0003\u0019A=\u0002\u0013I,7/^7f\u0015>\u0014G\u0003BA\u0016\u0003\u001bDa!a(#\u0001\u0004I\u0018!\u0003:fgVlW-\u00117m\u0003%\u0019\u0017M\\2fY*{'\r\u0006\u0003\u0002,\u0005U\u0007BBAPI\u0001\u0007\u00110A\tde\u0016\fG/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$\u0002#a&\u0002\\\u0006u\u0017q]Av\u0003c\f)0!?\t\r\u0005}U\u00051\u0001z\u0011\u001d\ty.\na\u0001\u0003C\f\u0001B]3dK&4XM\u001d\t\u00049\u0006\r\u0018bAAs;\nA\u0011i\u0019;peJ+g\r\u0003\u0004\u0002j\u0016\u0002\r!V\u0001\u0004[N<\u0007\"CAwKA\u0005\t\u0019AAx\u0003-!Wm]2sSB$\u0018n\u001c8\u0011\tY\u000b\u0019*\u001f\u0005\u0007\u0003g,\u0003\u0019A=\u0002\u001d\r\u0014xN\\#yaJ,7o]5p]\"I\u0011q_\u0013\u0011\u0002\u0003\u0007\u0011q^\u0001\tG\u0006dWM\u001c3be\"I\u00111`\u0013\u0011\u0002\u0003\u0007\u0011qG\u0001\ti&lWM_8oK\u0006Y2M]3bi\u0016TuNY*dQ\u0016$W\u000f\\3%I\u00164\u0017-\u001e7uIQ*\"A!\u0001+\t\u0005=\u0018\u0011W\u0001\u001cGJ,\u0017\r^3K_\n\u001c6\r[3ek2,G\u0005Z3gCVdG\u000f\n\u001c\u00027\r\u0014X-\u0019;f\u0015>\u00147k\u00195fIVdW\r\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011IA\u000b\u0003\u00028\u0005E\u0016!E;qI\u0006$XMS8c'\u000eDW\rZ;mKR\u0001\u0012q\u0013B\b\u0005#\u0011\u0019B!\u0006\u0003\u0018\te!1\u0004\u0005\u0007\u0003?K\u0003\u0019A=\t\u000f\u0005}\u0017\u00061\u0001\u0002b\"1\u0011\u0011^\u0015A\u0002UC\u0011\"!<*!\u0003\u0005\r!a<\t\r\u0005M\u0018\u00061\u0001z\u0011%\t90\u000bI\u0001\u0002\u0004\ty\u000fC\u0005\u0002|&\u0002\n\u00111\u0001\u00028\u0005YR\u000f\u001d3bi\u0016TuNY*dQ\u0016$W\u000f\\3%I\u00164\u0017-\u001e7uIQ\n1$\u001e9eCR,'j\u001c2TG\",G-\u001e7fI\u0011,g-Y;mi\u00122\u0014aG;qI\u0006$XMS8c'\u000eDW\rZ;mK\u0012\"WMZ1vYR$s'A\teK2,G/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$B!a\u000b\u0003(!1\u0011qT\u0017A\u0002e\f\u0011\u0002Z3mKR,\u0017\t\u001c7\u0002\u001bUt7o\u00195fIVdWMS8c)\u0011\tYCa\f\t\r\u0005}u\u00061\u0001z\u00039\u0019'/Z1uKN\u001b\u0007.\u001a3vY\u0016$B\"a \u00036\t]\"\u0011\bB\u001e\u0005{Aa!a(1\u0001\u0004I\b\"CAwaA\u0005\t\u0019AAx\u0011\u0019\t\u0019\u0010\ra\u0001s\"I\u0011q\u001f\u0019\u0011\u0002\u0003\u0007\u0011q\u001e\u0005\n\u0003w\u0004\u0004\u0013!a\u0001\u0003o\t\u0001d\u0019:fCR,7k\u00195fIVdW\r\n3fM\u0006,H\u000e\u001e\u00133\u0003a\u0019'/Z1uKN\u001b\u0007.\u001a3vY\u0016$C-\u001a4bk2$H\u0005N\u0001\u0019GJ,\u0017\r^3TG\",G-\u001e7fI\u0011,g-Y;mi\u0012*\u0014!\u0004:fg\u000eDW\rZ;mK*{'\r\u0006\t\u0002\u0018\n%#1\nB'\u0005\u001f\u0012\tFa\u0015\u0003V!1\u0011q\u0014\u001bA\u0002eDq!a85\u0001\u0004\t\t\u000f\u0003\u0004\u0002jR\u0002\r!\u0016\u0005\n\u0003[$\u0004\u0013!a\u0001\u0003_Da!a=5\u0001\u0004I\b\"CA|iA\u0005\t\u0019AAx\u0011%\tY\u0010\u000eI\u0001\u0002\u0004\t9$A\fsKN\u001c\u0007.\u001a3vY\u0016TuN\u0019\u0013eK\u001a\fW\u000f\u001c;%i\u00059\"/Z:dQ\u0016$W\u000f\\3K_\n$C-\u001a4bk2$HEN\u0001\u0018e\u0016\u001c8\r[3ek2,'j\u001c2%I\u00164\u0017-\u001e7uI]\naB]3n_Z,7k\u00195fIVdW\r\u0006\u0003\u0002N\t\u0005\u0004BBAPq\u0001\u0007\u00110\u0001\u0005tG\",G-\u001e7f)!\t9Ja\u001a\u0003j\t-\u0004BBAPs\u0001\u0007\u0011\u0010C\u0004\u0002`f\u0002\r!!9\t\r\u0005%\u0018\b1\u0001V)!\t9Ja\u001c\u0003r\te\u0004BBAPu\u0001\u0007\u0011\u0010C\u0004\u0002`j\u0002\rAa\u001d\u0011\u0007q\u0013)(C\u0002\u0003xu\u0013a\"Q2u_J\u001cV\r\\3di&|g\u000e\u0003\u0004\u0002jj\u0002\r!\u0016\u000b\t\u0003/\u0013iHa \u0003\b\"1\u0011qT\u001eA\u0002eDq!a8<\u0001\u0004\u0011\t\tE\u0002r\u0005\u0007K1A!\"s\u0005-)e/\u001a8u'R\u0014X-Y7\t\r\u0005%8\b1\u0001V))\t9Ja#\u0003\u000e\n=%\u0011\u0013\u0005\u0007\u0003?c\u0004\u0019A=\t\u000f\u0005}G\b1\u0001\u0002b\"1\u0011\u0011\u001e\u001fA\u0002UCqAa%=\u0001\u0004\t\t*A\u0005ti\u0006\u0014H\u000fR1uKRQ\u0011q\u0013BL\u00053\u0013YJ!(\t\r\u0005}U\b1\u0001z\u0011\u001d\ty.\u0010a\u0001\u0005gBa!!;>\u0001\u0004)\u0006b\u0002BJ{\u0001\u0007\u0011\u0011\u0013\u000b\u000b\u0003/\u0013\tKa)\u0003&\n\u001d\u0006BBAP}\u0001\u0007\u0011\u0010C\u0004\u0002`z\u0002\rA!!\t\r\u0005%h\b1\u0001V\u0011\u001d\u0011\u0019J\u0010a\u0001\u0003#\u000b\u0001c]2iK\u0012,H.Z%oi\u0016\u0014h.\u00197\u0015\u0015\u0005]%Q\u0016BX\u0005c\u0013\u0019\f\u0003\u0004\u0002 ~\u0002\r!\u001f\u0005\u0007\u0003?|\u0004\u0019A+\t\r\u0005%x\b1\u0001V\u0011\u001d\u0011\u0019j\u0010a\u0001\u0003#\u000b1b]2iK\u0012,H.\u001a&pERQ!\u0011\u0018B_\u0005\u007f\u0013\tMa1\u0015\t\u0005]%1\u0018\u0005\b\u0005G\u0002\u0005\u0019AA/\u0011\u0019\ty\n\u0011a\u0001s\"1\u0011q\u001c!A\u0002UCa!!;A\u0001\u0004)\u0006b\u0002BJ\u0001\u0002\u0007\u0011\u0011S\u0001\u0014S:LG/[1mSN,7)\u00197f]\u0012\f'o]\u0001\u000bi\"\u0014X-\u00193Q_>dWC\u0001Bf!\u0011\u0011iMa5\u000e\u0005\t='\u0002\u0002Bi\u0003_\nQa]5na2LAA!6\u0003P\n\u00012+[7qY\u0016$\u0006N]3bIB{w\u000e\\\u0001\tU>\u00147\u000b^8sKV\u0011!1\u001c\t\u0005\u0005;\u0014\u0019/\u0004\u0002\u0003`*!!\u0011]A8\u0003\r\u0019\b/[\u0005\u0005\u0005K\u0014yN\u0001\u0005K_\n\u001cFo\u001c:f\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0003lB!\u0011Q\u000eBw\u0013\u0011\u0011y/a\u001c\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\bc\u0001/\u0003t&\u0019!Q_/\u0003'\u0015CH/\u001a8tS>t\u0017\n\u001a)s_ZLG-\u001a:\u0015\u0003E\u000ba\u0001\\8pWV\u0004XC\u0001B\u007f\u001d\t\u0011\u0006!A\bde\u0016\fG/Z#yi\u0016t7/[8o)\r\u001171\u0001\u0005\u0007O\u0012\u0001\ra!\u0002\u0011\u0007q\u001b9!C\u0002\u0004\nu\u00131#\u0012=uK:$W\rZ!di>\u00148+_:uK6\f1aZ3u)\r\u00117q\u0002\u0005\u0006O\u0016\u0001\r\u0001\u001b")
public class QuartzSchedulerExtension
implements Extension {
    private SimpleThreadPool threadPool;
    private JobStore jobStore;
    private Scheduler scheduler;
    private final ActorSystem system;
    private final LoggingAdapter log;
    private final int threadCount;
    private final int threadPriority;
    private final boolean daemonThreads_$qmark;
    private final TimeZone defaultTimezone;
    private final TrieMap<String, QuartzSchedule> schedules;
    private final TrieMap<String, JobKey> runningJobs;
    private volatile byte bitmap$0;

    public static QuartzSchedulerExtension get(ActorSystem system) {
        return QuartzSchedulerExtension$.MODULE$.get(system);
    }

    public static QuartzSchedulerExtension createExtension(ExtendedActorSystem system) {
        return QuartzSchedulerExtension$.MODULE$.createExtension(system);
    }

    public static QuartzSchedulerExtension$ lookup() {
        return QuartzSchedulerExtension$.MODULE$.lookup();
    }

    public static Extension get(ClassicActorSystemProvider system) {
        return QuartzSchedulerExtension$.MODULE$.get(system);
    }

    public static Extension apply(ClassicActorSystemProvider system) {
        return QuartzSchedulerExtension$.MODULE$.apply(system);
    }

    public static Extension apply(ActorSystem system) {
        return QuartzSchedulerExtension$.MODULE$.apply(system);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    public String schedulerName() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("QuartzScheduler~%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.system.name()}));
    }

    public Config config() {
        return this.system.settings().config().getConfig("akka.quartz").root().toConfig();
    }

    public int threadCount() {
        return this.threadCount;
    }

    public int threadPriority() {
        return this.threadPriority;
    }

    public boolean daemonThreads_$qmark() {
        return this.daemonThreads_$qmark;
    }

    public TimeZone defaultTimezone() {
        return this.defaultTimezone;
    }

    public TrieMap<String, QuartzSchedule> schedules() {
        return this.schedules;
    }

    public TrieMap<String, JobKey> runningJobs() {
        return this.runningJobs;
    }

    public void standby() {
        this.scheduler().standby();
    }

    public boolean isInStandbyMode() {
        return this.scheduler().isInStandbyMode();
    }

    public boolean start() {
        boolean bl;
        if (this.isStarted()) {
            this.log().warning("Cannot start scheduler, already started.");
            bl = false;
        } else {
            this.scheduler().start();
            bl = true;
        }
        return bl;
    }

    public boolean isStarted() {
        return this.scheduler().isStarted();
    }

    public Option<Date> nextTrigger(String name) {
        return this.runningJobs().get((Object)name).flatMap((Function1 & Serializable)jobKey -> ((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getTriggersOfJob(jobKey)).asScala()).headOption().map((Function1 & Serializable)trigger -> trigger.getNextFireTime()));
    }

    public void suspendAll() {
        this.log().info("Suspending all Quartz jobs.");
        this.scheduler().pauseAll();
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.scheduler().shutdown(waitForJobsToComplete);
    }

    public boolean shutdown$default$1() {
        return false;
    }

    public boolean suspendJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Suspending Quartz Job '{}'", (Object)name);
            this.scheduler().pauseJob(job);
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot suspend", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public boolean resumeJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Resuming Quartz Job '{}'", (Object)name);
            this.scheduler().resumeJob(job);
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot unpause", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void resumeAll() {
        this.log().info("Resuming all Quartz jobs.");
        this.scheduler().resumeAll();
    }

    public boolean cancelJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Cancelling Quartz Job '{}'", (Object)name);
            boolean result = this.scheduler().deleteJob(job);
            this.runningJobs().$minus$eq((Object)name);
            bl = result;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot cancel", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public Date createJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.schedule(name, receiver, msg);
    }

    public Option<String> createJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> createJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone createJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public Date updateJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        return this.rescheduleJob(name, receiver, msg, description, cronExpression, calendar, timezone);
    }

    public Option<String> updateJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> updateJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone updateJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public boolean deleteJobSchedule(String name) {
        return this.unscheduleJob(name);
    }

    public void deleteAll() {
        this.log().info("Deleting all Quartz jobs.");
        this.runningJobs().clear();
        this.schedules().clear();
        this.scheduler().clear();
    }

    /*
     * WARNING - void declaration
     */
    public boolean unscheduleJob(String name) {
        void var2_2;
        boolean isJobCancelled = this.cancelJob(name);
        TrieMap<String, QuartzSchedule> trieMap = isJobCancelled ? this.removeSchedule(name) : BoxedUnit.UNIT;
        return (boolean)var2_2;
    }

    public void createSchedule(String name, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        CronExpression expr;
        Either either = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class})).either((Function0 & Serializable)() -> new CronExpression(cronExpression));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(new StringBuilder(77).append("Invalid 'expression' for Cron Schedule '").append(name).append("'. Failed to validate CronExpression.").toString(), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        CronExpression cronExpression2 = expr = (CronExpression)right.value();
        CronExpression expression = cronExpression2;
        QuartzCronSchedule schedule = new QuartzCronSchedule(name, description, expression, timezone, calendar);
        Option option = this.schedules().putIfAbsent((Object)name, (Object)schedule);
        if (option instanceof Some) {
            throw new IllegalArgumentException(new StringBuilder(44).append("A schedule with this name already exists: [").append(name).append("]").toString());
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Option<String> createSchedule$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createSchedule$default$4() {
        return None$.MODULE$;
    }

    public TimeZone createSchedule$default$5() {
        return this.defaultTimezone();
    }

    public Date rescheduleJob(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.cancelJob(name);
        this.removeSchedule(name);
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Option<String> rescheduleJob$default$4() {
        return None$.MODULE$;
    }

    public Option<String> rescheduleJob$default$6() {
        return None$.MODULE$;
    }

    public TimeZone rescheduleJob$default$7() {
        return this.defaultTimezone();
    }

    public TrieMap<String, QuartzSchedule> removeSchedule(String name) {
        return (TrieMap)this.schedules().$minus$eq((Object)name);
    }

    public Date schedule(String name, ActorRef receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, EventStream receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorRef receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, EventStream receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date scheduleInternal(String name, Object receiver, Object msg, Option<Date> startDate) {
        Option option = this.schedules().get((Object)name);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("No matching quartz configuration found for schedule '%s'"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        QuartzSchedule schedule = (QuartzSchedule)some.value();
        Date date = this.scheduleJob(name, receiver, msg, startDate, schedule);
        return date;
    }

    public Date scheduleJob(String name, Object receiver, Object msg, Option<Date> startDate, QuartzSchedule schedule) {
        this.log().info("Setting up scheduled job '{}', with '{}'", (Object)name, (Object)schedule);
        scala.collection.immutable.Map jobDataMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logBus"), (Object)this.system.eventStream()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"receiver"), receiver), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), msg)}));
        JobDataMap jobData = JobDataMapSupport.newJobDataMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)jobDataMap).asJava()));
        JobDetail job = JobBuilder.newJob(SimpleActorMessageJob.class).withIdentity(new StringBuilder(4).append(name).append("_Job").toString()).usingJobData(jobData).withDescription((String)schedule.description().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).build();
        this.log().debug("Adding jobKey {} to runningJobs map.", (Object)job.getKey());
        this.runningJobs().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)job.getKey()));
        this.log().debug("Building Trigger with startDate '{}", startDate.getOrElse((Function0 & Serializable)() -> new Date()));
        Trigger trigger = schedule.buildTrigger(name, startDate);
        this.log().debug("Scheduling Job '{}' and Trigger '{}'. Is Scheduler Running? {}", (Object)job, (Object)trigger, (Object)BoxesRunTime.boxToBoolean((boolean)this.scheduler().isStarted()));
        return this.scheduler().scheduleJob(job, trigger);
    }

    public void initialiseCalendars() {
        QuartzCalendars$.MODULE$.apply(this.config(), this.defaultTimezone()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)QuartzSchedulerExtension.$anonfun$initialiseCalendars$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            QuartzSchedulerExtension.$anonfun$initialiseCalendars$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.log().info(new StringBuilder(23).append("Initialized calendars: ").append(((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getCalendarNames()).asScala()).mkString(",")).toString());
    }

    /*
     * WARNING - void declaration
     */
    private SimpleThreadPool threadPool$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                SimpleThreadPool _tp = new SimpleThreadPool(this.threadCount(), this.threadPriority());
                _tp.setThreadNamePrefix("AKKA_QRTZ_");
                _tp.setMakeThreadsDaemons(this.daemonThreads_$qmark());
                this.threadPool = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.threadPool;
    }

    public SimpleThreadPool threadPool() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.threadPool$lzycompute() : this.threadPool;
    }

    private JobStore jobStore$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.jobStore = new RAMJobStore();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.jobStore;
    }

    public JobStore jobStore() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.jobStore$lzycompute() : this.jobStore;
    }

    /*
     * WARNING - void declaration
     */
    private Scheduler scheduler$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                void var2_2;
                DirectSchedulerFactory.getInstance().createScheduler(this.schedulerName(), this.system.name(), (ThreadPool)this.threadPool(), this.jobStore());
                Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler(this.schedulerName());
                this.log().debug("Initialized a Quartz Scheduler '{}'", (Object)scheduler);
                this.system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    this.log().info("Shutting down Quartz Scheduler with ActorSystem Termination (Any jobs awaiting completion will end as well, as actors are ending)...");
                    scheduler.shutdown(false);
                });
                this.scheduler = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.scheduler;
    }

    public Scheduler scheduler() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.scheduler$lzycompute() : this.scheduler;
    }

    public static final /* synthetic */ boolean $anonfun$initialiseCalendars$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$initialiseCalendars$2(QuartzSchedulerExtension $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        Calendar calendar = (Calendar)tuple2._2();
        $this.log().info("Configuring Calendar '{}'", (Object)name);
        $this.scheduler().addCalendar(name, calendar, true, true);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public QuartzSchedulerExtension(ActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply(system, (Object)this, package$.MODULE$.quartzExtensionLoggerType());
        this.threadCount = this.config().getInt("threadPool.threadCount");
        Predef$.MODULE$.require(this.threadCount() >= 1, (Function0 & Serializable)() -> "Quartz Thread Count (akka.quartz.threadPool.threadCount) must be a positive integer.");
        this.threadPriority = this.config().getInt("threadPool.threadPriority");
        Predef$.MODULE$.require(this.threadPriority() >= 1 && this.threadPriority() <= 10, (Function0 & Serializable)() -> "Quartz Thread Priority (akka.quartz.threadPool.threadPriority) must be a positive integer between 1 (lowest) and 10 (highest).");
        this.daemonThreads_$qmark = this.config().getBoolean("threadPool.daemonThreads");
        this.defaultTimezone = TimeZone.getTimeZone(this.config().getString("defaultTimezone"));
        this.schedules = new TrieMap();
        this.schedules().$plus$plus$eq(QuartzSchedules$.MODULE$.apply(this.config(), this.defaultTimezone()));
        this.runningJobs = new TrieMap();
        this.log().debug("Configured Schedules: {}", this.schedules());
        this.scheduler().start();
        this.initialiseCalendars();
    }
}

