/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import org.apache.commons.lang3.Range;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;

public class FileDepthSelector
implements FileSelector {
    private final Range<Integer> range;

    public FileDepthSelector(int minDepth, int maxDepth) {
        this.range = Range.between((Comparable)Integer.valueOf(minDepth), (Comparable)Integer.valueOf(maxDepth));
    }

    public FileDepthSelector(int minMaxDepth) {
        this(minMaxDepth, minMaxDepth);
    }

    public FileDepthSelector() {
        this(0, 0);
    }

    @Override
    public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
        return this.range.contains((Object)fileInfo.getDepth());
    }

    @Override
    public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
        return fileInfo.getDepth() < (Integer)this.range.getMaximum();
    }
}

