/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

public class SVNVersion
implements Comparable<SVNVersion> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String build;

    public static SVNVersion parse(String versionString) {
        if (versionString == null) {
            return null;
        }
        try {
            int micro;
            int minor;
            int major;
            String[] fields = versionString.split("\\.", 3);
            String[] fields2 = fields[fields.length - 1].split("-", 2);
            if (fields.length == 1) {
                major = Integer.parseInt(fields2[0]);
                minor = -1;
                micro = -1;
            } else if (fields.length == 2) {
                major = Integer.parseInt(fields[0]);
                minor = Integer.parseInt(fields2[0]);
                micro = -1;
            } else if (fields.length == 3) {
                major = Integer.parseInt(fields[0]);
                minor = Integer.parseInt(fields[1]);
                micro = Integer.parseInt(fields2[0]);
            } else {
                return null;
            }
            return new SVNVersion(major, minor, micro, fields2.length >= 2 ? fields2[1] : null);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public SVNVersion(int major, int minor, int micro, String build) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.build = build;
    }

    public SVNVersion removeBuild() {
        return new SVNVersion(this.major, this.minor, this.micro, null);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.major);
        if (this.minor >= 0) {
            stringBuilder.append(".");
            stringBuilder.append(this.minor);
        }
        if (this.micro >= 0) {
            stringBuilder.append(".");
            stringBuilder.append(this.micro);
        }
        if (this.build != null) {
            stringBuilder.append("-");
            stringBuilder.append(this.build);
        }
        return stringBuilder.toString();
    }

    public int compareNumericParts(SVNVersion o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        int diff = this.major - o.major;
        if (diff != 0) {
            return diff;
        }
        diff = this.minor - o.minor;
        if (diff != 0) {
            return diff;
        }
        return this.micro - o.micro;
    }

    @Override
    public int compareTo(SVNVersion o) {
        int diff = this.compareNumericParts(o);
        if (diff != 0) {
            return diff;
        }
        if (this.build == null) {
            return o.build == null ? 0 : -1;
        }
        if (o.build == null) {
            return 1;
        }
        return this.build.compareTo(o.build);
    }
}

