/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Hashtable;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.RowLock;

public final class RecordId
implements RecordHandle {
    private final PageKey pageId;
    private final int recordId;
    private transient int slotNumberHint;

    public RecordId(ContainerKey containerKey, long l, int n) {
        this.pageId = new PageKey(containerKey, l);
        this.recordId = n;
    }

    public RecordId(PageKey pageKey, int n) {
        this.pageId = pageKey;
        this.recordId = n;
    }

    public RecordId(PageKey pageKey, int n, int n2) {
        this.pageId = pageKey;
        this.recordId = n;
        this.slotNumberHint = n2;
    }

    @Override
    public int getId() {
        return this.recordId;
    }

    @Override
    public long getPageNumber() {
        return this.pageId.getPageNumber();
    }

    @Override
    public Object getPageId() {
        return this.pageId;
    }

    @Override
    public ContainerKey getContainerId() {
        return this.pageId.getContainerId();
    }

    @Override
    public int getSlotNumberHint() {
        return this.slotNumberHint;
    }

    @Override
    public void lockEvent(Latch latch) {
    }

    @Override
    public boolean requestCompatible(Object object, Object object2) {
        RowLock rowLock = (RowLock)object;
        RowLock rowLock2 = (RowLock)object2;
        return rowLock.isCompatible(rowLock2);
    }

    @Override
    public boolean lockerAlwaysCompatible() {
        return true;
    }

    @Override
    public void unlockEvent(Latch latch) {
    }

    public boolean equals(Object object) {
        if (!(object instanceof RecordId)) {
            return false;
        }
        RecordId recordId = (RecordId)object;
        return this.recordId == recordId.recordId && this.pageId.equals(recordId.pageId);
    }

    public int hashCode() {
        int n = 7;
        n = 89 * n + this.pageId.hashCode();
        n = 89 * n + this.recordId;
        return n;
    }

    public String toString() {
        return null;
    }

    @Override
    public boolean lockAttributes(int n, Hashtable<String, Object> hashtable) {
        if ((n & 2) == 0) {
            return false;
        }
        hashtable.put("CONTAINERID", this.pageId.getContainerId().getContainerId());
        hashtable.put("LOCKNAME", "(" + this.pageId.getPageNumber() + "," + this.recordId + ")");
        hashtable.put("TYPE", "ROW");
        return true;
    }
}

