#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import hvac
from vault import VaultClient

logger.info("=== CHECK CONNECTION ==========================================")
vault_client = VaultClient(url=configuration['url'], token=configuration['token'], username=configuration['username'],
                           password=configuration['password'], namespace=configuration['namespace'],
                           authenticationMethod=configuration['authenticationMethod'], role_id=configuration['role_id'], secret_id=configuration['secret_id'], logger=logger)

if configuration['namespace'] is not None and len(configuration['namespace']) > 0:
    print("Namespace Provided so Vault Initialization Check is Skipped")
else:
    if vault_client.client.sys.is_initialized():
        logger.info(">> Vault is initialized")
    else:
        VaultClient.exit(VaultClient.VAULT_NOT_INITIALIZED,
                         "Your Vault Server at {} is not initialized".format(configuration.url),authenticationType=str(configuration['authenticationMethod']))

if vault_client.client.sys.is_sealed():
    VaultClient.exit(VaultClient.VAULT_SERVER_SEALED, "Vault Server {} is Sealed".format(configuration.url),authenticationType=str(configuration['authenticationMethod']))

if configuration['token'] or configuration['username'] or configuration['role_id']:
    logger.info("Validating token or Username/Password/role_id configuration against {}".format(configuration['url']))

    if vault_client.client.is_authenticated():
        logger.info(">> Your token or Username/Password/role_id is authenticated")
        logger.info("===============================================================")
        # vault_client.client.logout(revoke_token=True)
    else:
        VaultClient.exit(VaultClient.VAULT_NOT_AUTHENTICATED, "Vault Server is not authenticated",authenticationType=str(configuration['authenticationMethod']))

else:
    VaultClient.exit(VaultClient.VAULT_NO_TOKEN, "You must use a token or username/password/role_id-secret_id for Vault",str(configuration['authenticationMethod']))

if configuration['authenticationMethod'] == "Basic" or configuration['authenticationMethod'] == "LDAP" or configuration['authenticationMethod'] == "Approle":
    vault_client.revokeUserPassToken()
